<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <?php if($is_post != 1): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <input type="hidden" id="source_type" name="source_type" value="<?php echo $source_type; ?>" />
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_no']; ?></label>
                                            <label class="form-control"><?php echo $document_identity; ?></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <label class="form-control"><?php echo $document_date; ?></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_title']; ?></label>
                                            <label class="form-control"><?php echo $document_title; ?></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-5">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['pay_from']; ?></label>
                                            <label class="form-control" style="overflow: hidden;"><?php echo $account_title . ' ['.$bank_name.' - '.$account_no .']'; ?></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive" style="height: 300px;">
                                            <table id="tblEmployee" class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th style="text-align: center;"><?php echo $lang['sr']; ?></th>
                                                    <th style="text-align: center;"><?php echo $lang['employee_name']; ?></th>
                                                    <th style="text-align: center;"><?php echo $lang['bank_name']; ?></th>
                                                    <th style="text-align: center;"><?php echo $lang['bank_iban']; ?></th>
                                                    <th style="text-align: center;"><?php echo $lang['amount']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($cheque_details as $grid_row => $detail): ?>
                                                <tr id="grid_row_<?php echo $grid_row; ?>" data-row_id="<?php echo $grid_row; ?>">
                                                    <td class="text-center"><?php echo $grid_row+1; ?></td>
                                                    <td class="text-left"><?php echo $detail['bank_title']; ?></td>
                                                    <td class="text-left"><?php echo $detail['bank_name']; ?></td>
                                                    <td class="text-left"><?php echo $detail['bank_iban']; ?></td>
                                                    <td class="text-right"><?php echo number_format($detail['amount']); ?></td>
                                                </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                                <tfoot>
                                                <tr>
                                                    <td colspan="4" class="text-right"><?php echo $lang['total_amount']; ?></td>
                                                    <td class="text-right"><?php echo $total_amount; ?></td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <!--<div class="col-sm-4">
                                        <div class="form-group">
                                            <label for="pay_from_company_id">Pay From</label>
                                            <select class="form-control" id="pay_from_company_id" name="pay_from_company_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($companies as $company): ?>
                                                <option <?php echo ($company['company_id']==$pay_from_company_id?'selected':'');?> value="<?php echo $company['company_id']; ?>" data-ref_id="<?php echo $company['ref_id']; ?>"><?php echo $company['company_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>-->
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['pay_date']; ?></label>
                                            <input type="text" id="pay_date" name="pay_date" value="<?php echo $pay_date; ?>" class="form-control dtpDate"/>
                                            <input type="hidden" id="pay_from_company_id" name="pay_from_company_id" value="<?php echo $pay_from_company_id; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label for="posting_type">Posting Type</label>
                                            <select class="form-control" id="posting_type" name="posting_type">
                                                <option value="Single">Single</option>
                                                <option value="Club">Club</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnGetPostData" type="button" class="form-control btn btn-info"><i class="fa fa-search"></i> Fetch</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="tblAccounts" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th class="text-center"><?php echo $lang['pay_date']; ?></th>
                                                    <th class="text-center"><?php echo $lang['sys_key']; ?></th>
                                                    <th class="text-center"><?php echo $lang['sys_tag']; ?></th>
                                                    <th class="text-center"><?php echo $lang['year']; ?></th>
                                                    <th class="text-center"><?php echo $lang['comp']; ?></th>
                                                    <th class="text-center"><?php echo $lang['party_id']; ?></th>
                                                    <th class="text-center"><?php echo $lang['party']; ?></th>
                                                    <th class="text-center"><?php echo $lang['tran_type']; ?></th>
                                                    <th class="text-center"><?php echo $lang['bah_key']; ?></th>
                                                    <th class="text-center"><?php echo $lang['ah_key']; ?></th>
                                                    <th class="text-center"><?php echo $lang['cc_key']; ?></th>
                                                    <th class="text-center"><?php echo $lang['bud_key']; ?></th>
                                                    <th class="text-center"><?php echo $lang['narr']; ?></th>
                                                    <th class="text-center"><?php echo $lang['ref']; ?></th>
                                                    <th class="text-center"><?php echo $lang['tax_type']; ?></th>
                                                    <th class="text-center"><?php echo $lang['p_amount']; ?></th>
                                                    <th class="text-center"><?php echo $lang['b_amount']; ?></th>
                                                    <th class="text-center"><?php echo $lang['ctrl_no']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($account_details as $row_id => $detail): ?>
                                                <tr>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][PayDate]" value="<?php echo $detail['PayDate']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Syskey]" value="<?php echo $detail['SysKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][SysTag]" value="<?php echo $detail['SysTag']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Year]" value="<?php echo $detail['Year']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control comp" name="account_details[<?php echo $row_id; ?>][Comp]" value="<?php echo $detail['Comp']; ?>" readonly/></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][PartyID]" value="<?php echo $detail['PartyID']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Party]" value="<?php echo $detail['Party']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][tran_type]" value="<?php echo $detail['tran_type']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][BAHKey]" value="<?php echo $detail['BAHKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][AHKey]" value="<?php echo $detail['AHKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][CCKey]" value="<?php echo $detail['CCKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][BudKey]" value="<?php echo $detail['BudKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Narr]" value="<?php echo $detail['Narr']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Ref]" value="<?php echo $detail['Ref']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][taxType]" value="<?php echo $detail['taxType']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Pamount]" value="<?php echo $detail['Pamount']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Bamount]" value="<?php echo $detail['Bamount']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Ctrl_No]" value="<?php echo $detail['Ctrl_No']; ?>" /></td>
                                                </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div id="divBudget" class="table-responsive">
                                            <table id="tblBudgets" class="table table-striped">
                                                <thead>
                                                <tr><th colspan="6">Budget Entry</th></tr>
                                                <tr>
                                                    <th>Comp</th>
                                                    <th>Year</th>
                                                    <th>BudKey</th>
                                                    <th>Ref</th>
                                                    <th>budAmount</th>
                                                    <th>Status</th>
                                                    <th>PartyID</th>
                                                    <th>AHKey</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $row_id =0; ?>
                                                <?php foreach($budgets as $budget): ?>
                                                <tr>
                                                    <td class="text-center"><input type="text" class="form-control comp" name="budgets[<?php echo $row_id; ?>][Comp]" value="<?php echo $budget['Comp']; ?>" readonly /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][Year]" value="<?php echo $budget['Year']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" required="true" onfocusout="check(this);" name="budgets[<?php echo $row_id; ?>][BudKey]" value="<?php echo $budget['BudKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][Ref]" value="<?php echo $budget['Ref']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][budAmt]" value="<?php echo $budget['budAmount']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][Status]" value="<?php echo $budget['Status']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][PartyID]" value="<?php echo $budget['PartyID']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][AHKey]" value="<?php echo $budget['AHKey']; ?>" /></td>
                                                </tr>
                                                <?php $row_id++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/bank_letter.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $URLGetAccountsData = '<?php echo $href_get_accounts_data; ?>';
        var $company_accounts = <?php echo json_encode($company_accounts); ?>;
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>