<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['deposit_slip_no']; ?></label>
                                            <input type="text" id="deposit_slip_no" name="deposit_slip_no" value="<?php echo $deposit_slip_no; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['deposit_slip_date']; ?></label>
                                            <input type="text" id="deposit_slip_date" name="deposit_slip_date" value="<?php echo $deposit_slip_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['deposit_slip_title']; ?></label>
                                            <input type="text" id="deposit_slip_title" name="deposit_slip_title" value="<?php echo $deposit_slip_title; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['payroll_date']; ?></label>
                                            <input type="text" id="payroll_date" name="payroll_date" value="<?php echo $payroll_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>" <?php echo ($department_id==$department['department_id']?'selected="true"':''); ?>><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['employee']; ?></label>
                                            <select class="form-control" id="employee_registration_id" name="employee_registration_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($employees as $employee): ?>
                                                <option value="<?php echo $employee['employee_registration_id']; ?>" <?php echo ($employee_registration_id==$employee['employee_registration_id']?'selected="true"':''); ?>><?php echo $employee['employee_name'].' - '.$employee['employee_code']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn btn-info form-control" id="btnSearch">Search</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-5">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_name']; ?></label>
                                                    <input type="hidden" id="bank_id" name="bank_id" value="<?php echo $bank_id; ?>" class="form-control"/>
                                                    <input type="hidden" id="bank_name" name="bank_name" value="<?php echo $bank_name; ?>" class="form-control"/>
                                                    <select class="form-control" id="company_account_id" name="company_account_id">
                                                        <option value="" data-bank_id="" data-bank_name="" data-bank_branch="">&nbsp;</option>
                                                        <?php foreach($company_accounts as $account): ?>
                                                        <option <?php echo ($company_account_id==$account['company_account_id']?'selected="true"':''); ?> value="<?php echo $account['company_account_id']; ?>" data-bank_id="<?php echo $account['bank_id']; ?>" data-bank_name="<?php echo $account['bank_name']; ?>" data-bank_branch="<?php echo $account['bank_branch']; ?>"><?php echo $account['account_title'] . ' ['.$account['bank_name'].' - '.$account['account_no'].']'; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="company_account_id" class="error" style="display: none;"></label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_branch']; ?></label>
                                                    <input type="text" id="bank_branch" name="bank_branch" value="<?php echo $bank_branch; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-7">
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['cheque_date']; ?></label>
                                                    <input type="text" id="cheque_date" name="cheque_date" value="<?php echo $cheque_date; ?>" class="form-control dtpDate"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['cheque_no']; ?></label>
                                                    <input type="text" id="cheque_no" name="cheque_no" value="<?php echo $cheque_no; ?>" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['cheque_amount']; ?></label>
                                                    <input type="text" id="cheque_amount" name="cheque_amount" value="<?php echo $cheque_amount; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="tblDepositSlip" class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th>&nbsp;</th>
                                                    <th><?php echo $lang['sno']; ?></th>
                                                    <th><?php echo $lang['employee_name']; ?></th>
                                                    <th><?php echo $lang['account_title']; ?></th>
                                                    <th><?php echo $lang['account_no']; ?></th>
                                                    <th><?php echo $lang['rupees']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($details as $row_no=>$detail): ?>
                                                <tr>
                                                    <td><input onclick="calculateAmount();" type="checkbox" data-amount="<?php echo $detail['amount']; ?>" id="payroll_<?php echo $row_no; ?>_payroll_id" name="payrolls[<?php echo $row_no; ?>][payroll_id]" value="<?php echo $detail['payroll_id']; ?>" checked /></td>
                                                    <td><?php echo ($row_no+1); ?></td>
                                                    <td>
                                                        <input type="hidden" name="payrolls[<?php echo $row_no; ?>][employee_id]" value="<?php echo $detail['employee_id']; ?>" />
                                                        <input type="hidden" name="payrolls[<?php echo $row_no; ?>][employee_registration_id]" value="<?php echo $detail['employee_registration_id']; ?>" />
                                                        <input type="hidden" name="payrolls[<?php echo $row_no; ?>][employee_code]" value="<?php echo $detail['employee_code']; ?>" />
                                                        <input type="hidden" name="payrolls[<?php echo $row_no; ?>][registration_code]" value="<?php echo $detail['registration_code']; ?>" />
                                                        <input type="text" class="form-control" name="payrolls[<?php echo $row_no; ?>][employee_name]" value="<?php echo $detail['employee_name']; ?>" readonly/>
                                                        </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="payrolls[<?php echo $row_no; ?>][account_title]" value="<?php echo $detail['account_title']; ?>" readonly/>
                                                        </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="payrolls[<?php echo $row_no; ?>][account_no]" value="<?php echo $detail['account_no']; ?>" readonly/>
                                                        </td>
                                                    <td>
                                                        <input type="text" class="form-control text-right" name="payrolls[<?php echo $row_no; ?>][amount]" value="<?php echo $detail['amount']; ?>" readonly/>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">

                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/deposit_slip.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $URLGetPayrolls = '<?php echo $href_get_payrolls; ?>';
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>