<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<style type="text/css" src="plugins/dataTables/extensions/FixedColumns/css/dataTables.fixedColumns.min.css"></style>
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-body">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form" >
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['title']; ?></label>
                                            <input type="text" id="document_title" name="document_title" value="<?php echo $document_title; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <option value="">&nbsp;</option>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="department_id" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['registration_code']; ?></label>
                                            <input type="text" id="registration_code" name="registration_code" value="<?php echo $registration_code; ?>" class="form-control"/>
                                        </div>
                                    </div>

                                    <!--
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['remaining_payroll']; ?></label>
                                            <input type="text" id="remaining_payroll" name="remaining_payroll" value="<?php echo $remaining_payroll; ?>" class="form-control fPinteger"/>
                                        </div>
                                    </div>
                                    -->

                                </div>
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['from_date']; ?></label>
                                            <input type="text" id="from_date" name="from_date" value="<?php echo $from_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['to_date']; ?></label>
                                            <input type="text" id="to_date" name="to_date" value="<?php echo $to_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <!-- <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['make_all_present']; ?></label>
                                            <div class="input-group"> -->
                                                <!--<input type="text" id="working_days" name="working_days" value="<?php echo $working_days; ?>" class="form-control fPInteger"/>-->
                                                <!-- <span class="input-group-addon">
                                                    <input type="checkbox" id="all_present" name="all_present" value="1" />
                                                </span>
                                            </div>

                                            <label class="error" for="working_days" style="display: none"></label>
                                        </div>
                                    </div> -->
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <span class="input-group-addon">
                                                <label>Attach file</label>
                                                <input type="file" name="userfile" id="userfile"  value="" />
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="submit" id="btnCalculate" name="btnCalculate" class="btn btn-primary form-control">Calculate</button>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" id="btnDownload" name="btnDownload" class="btn btn-info form-control"><?php echo $lang['download']; ?></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div id="divPayroll" class="table-responsive">

                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-addon" style="background-color: #fb8aa9;">
                                            <i class="">&nbsp;</i>
                                        </div>
                                        <input type="text" class="form-control" readonly value="Covid Vaccine Pending" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-addon bg-yellow-active">
                                            <i class="">&nbsp;</i>
                                        </div>
                                        <input type="text" class="form-control" readonly value="Covid Vaccine 1st Dose" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                            <i class="">&nbsp;</i>
                                        </div>
                                        <input type="text" class="form-control" readonly value="Covid Vaccine 2nd Dose" />
                                    </div>
                                </div>
                            </div>
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <link rel="stylesheet" href="plugins/dataTables/dataTables.bootstrap.css">
    <script src="plugins/dataTables/jquery.dataTables.js"></script>
    <script src="plugins/dataTables/dataTables.bootstrap.js"></script>
    <script type="text/javascript" src="plugins/dataTables/extensions/FixedColumns/js/dataTables.fixedColumns.min.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);

        var $URLupload_payroll_file = '<?php echo $href_upload_payroll_file; ?>';
        var $URLGetCheckUserFileUpload = '<?php echo $href_update_data_from_file; ?>';
        var $URLGetPayroll = '<?php echo $href_get_payroll; ?>';
        var $URLDownloadExcel = '<?php echo $href_download_excel; ?>';
        var $URLGetPayrollData = '<?php echo $href_get_payroll_data; ?>';
        var $URLGetTaxAmount = '<?php echo $href_get_tax_amount; ?>';
        var $URLUpdatePayrollData = '<?php echo $href_update_payroll_data; ?>';
    </script>
    <script type="text/javascript" src="../admin/view/js/payroll/generate_payroll.js?v=1"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>