<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="document_identity"><span class="required">*</span>&nbsp;<?php echo $lang['document_no']; ?></label>
                                            <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="document_date"><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="document_title"><span class="required">*</span>&nbsp;<?php echo $lang['document_title']; ?></label>
                                            <input type="text" id="document_title" name="document_title" value="<?php echo $document_title; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="company_account_id"><span class="required">*</span>&nbsp;<?php echo $lang['pay_from']; ?></label>
                                            <select id="company_account_id" name="company_account_id" class="form-control" required>
                                                <option value="">&nbsp;</option>
                                                <?php foreach($company_accounts as $account): ?>
                                                <option value="<?php echo $account['company_account_id']; ?>" <?php echo ($account['company_account_id']==$company_account_id?'selected':''); ?>><?php echo $account['account_title']?> [<?php echo $account['account_no']; ?>]</option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="company_account_id" class="error"></label>
                                        </div>
                                    </div>
                                </div>
                                <?php if($is_edit==0): ?>
                                <hr />
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="employee_bank"><?php echo $lang['employee_bank']; ?></label>
                                            <select class="form-control" id="bank_id" name="bank_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($employee_banks as $bank): ?>
                                                <option value="<?php echo $bank['bank_id']; ?>"><?php echo $bank['bank_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="department_id"><?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>" <?php echo ($department_id==$department['department_id']?'selected="true"':''); ?>><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="employee_registration_id"><?php echo $lang['employee']; ?></label>
                                            <select class="form-control" id="employee_registration_id" name="employee_registration_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($employees as $employee): ?>
                                                <option value="<?php echo $employee['employee_registration_id']; ?>" <?php echo ($employee_registration_id==$employee['employee_registration_id']?'selected="true"':''); ?>><?php echo $employee['employee_code'].' / '.$employee['registration_code'].' - '.$employee['employee_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="source_type"><span class="required">*</span>&nbsp;<?php echo $lang['source_type']; ?></label>
                                            <select class="form-control" id="source_type" name="source_type"<?php echo ($is_edit==1?'disabled':''); ?>>
                                            <option value="">&nbsp;</option>
                                            <?php foreach($source_types as $type => $source): ?>
                                            <option value="<?php echo $type; ?>" <?php echo ($type==$source_type?'selected':'')?>><?php echo $source; ?></option>
                                            <?php endforeach; ?>
                                            </select>
                                            <label for="source_type" class="error"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['source_date']; ?></label>
                                            <input type="text" id="source_date" name="source_date" value="<?php echo $source_date; ?>" class="form-control <?php echo ($is_edit==1?'':'dtpDate'); ?>"  <?php echo ($is_edit==1?'readonly':''); ?>/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3" id="divShowDeduction" style="display: none;">
                                        <div class="form-group">
                                            <label>Show Deduction</label>
                                            <div class="form-control">
                                                <label><input type="radio" id="show_deduction_no" name="show_deduction" value="No" <?php echo ($letter_type != 'Yes'?'checked':''); ?> /> No</label>
                                                &nbsp;&nbsp;&nbsp;
                                                <label><input type="radio" id="show_deduction_yes" name="show_deduction" value="Yes" <?php echo ($letter_type == 'Yes'?'checked':''); ?>/> Yes</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if($is_edit==0): ?>
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['cheque_no']; ?></label>
                                            <input type="text" id="cheque_no" name="cheque_no" value="<?php echo $cheque_no; ?>" class="form-control fPInteger"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['cheque_date']; ?></label>
                                            <input type="text" id="cheque_date" name="cheque_date" value="<?php echo $cheque_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn btn-info form-control" id="btnSearch"><i class="fa fa-search"></i> Search</button>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <hr />
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="tblEmployees" class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th>&nbsp;</th>
                                                    <th style="width: 40%;"><?php echo $lang['employee_name']; ?></th>
                                                    <th style="width: 20%;"><?php echo $lang['cheque_date']; ?></th>
                                                    <th style="width: 20%;"><?php echo $lang['cheque_no']; ?></th>
                                                    <th style="width: 20%;"><?php echo $lang['cheque_amount']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $grid_row=0; ?>
                                                <?php foreach($details as $employee): ?>
                                                <tr id="grid_row_<?php echo $grid_row; ?>" data-employee_registration_id="<?php echo $employee['employee_registration_id']; ?>">
                                                    <td>
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][individual_cheque_id]" value="<?php echo $employee['individual_cheque_id']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][individual_cheque_detail_id]" value="<?php echo $employee['individual_cheque_detail_id']; ?>" />
                                                        <button type="button" class="btn btn-xs btn-danger" onclick="removeRow(<?php echo $grid_row; ?>)"><i class="fa fa-times"></i></button>
                                                    </td>
                                                    <td>
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][source_table]" value="<?php echo $employee['source_table']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][source_table_id]" value="<?php echo $employee['source_table_id']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][employee_registration_id]" value="<?php echo $employee['employee_registration_id']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][employee_id]" value="<?php echo $employee['employee_id']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][employee_code]" value="<?php echo $employee['employee_code']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][registration_code]" value="<?php echo $employee['registration_code']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][bank_id]" value="<?php echo $employee['bank_id']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][bank_name]" value="<?php echo $employee['bank_name']; ?>" />
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][bank_iban]" value="<?php echo $employee['bank_iban']; ?>" />
                                                        <?php if($employee['employee_name'] != ''):?>
                                                        <input type="text"   name="employees[<?php echo $grid_row; ?>][employee_name]" value="<?php echo $employee['employee_name']; ?>" class="form-control" readonly/>
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][bank_title]" value="<?php echo $employee['bank_title']; ?>" class="form-control" readonly/>
                                                        <?php else: ?>
                                                        <input type="hidden" name="employees[<?php echo $grid_row; ?>][employee_name]" value="<?php echo $employee['employee_name']; ?>" class="form-control" readonly/>
                                                        <input type="text"   name="employees[<?php echo $grid_row; ?>][bank_title]" value="<?php echo $employee['bank_title']; ?>" class="form-control" readonly/>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <input type="text"   name="employees[<?php echo $grid_row; ?>][cheque_date]" value="<?php echo $employee['cheque_date']; ?>" class="form-control dtpDate" required/>
                                                    </td>
                                                    <td>
                                                        <input type="text"   name="employees[<?php echo $grid_row; ?>][cheque_no]" value="<?php echo $employee['cheque_no']; ?>" class="form-control" required/>
                                                    </td>
                                                    <td>
                                                        <input type="text"   name="employees[<?php echo $grid_row; ?>][cheque_amount]" value="<?php echo $employee['cheque_amount']; ?>" class="form-control text-right amount" readonly/>
                                                    </td>
                                                </tr>
                                                <?php $grid_row++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-8">

                                    </div>
                                    <div class="col-sm-2">
                                        <label><?php echo $lang['total_employee']; ?></label>
                                        <input type="text" class="form-control text-right" id="total_employee" name="total_employee" value="<?php echo $total_employee; ?>" readonly/>
                                    </div>
                                    <div class="col-sm-2">
                                        <label><?php echo $lang['total_amount']; ?></label>
                                        <input type="text" class="form-control text-right" id="total_amount" name="total_amount" value="<?php echo $total_amount; ?>" readonly/>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/individual_cheque.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $URLGetData = '<?php echo $href_get_data; ?>';
        var $grid_row = <?php echo $grid_row; ?>;

        var $company_accounts = <?php echo json_encode($company_accounts); ?>;
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>