<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box box-primary">
                        <div class="box-header">
                            <?php if ($error) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error; ?>
                            </div>
                            <?php } ?>
                            <?php if ($warning) { ?>
                            <div class="alert alert-warning alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $warning; ?>
                            </div>
                            <?php } ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label>Message</label>
                                        <input type="text" class="form-control" id="message" value="<?php echo $default_message; ?>" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="table-responsive">
                                        <table id="tblEmployee" class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>Reg. Code</th>
                                                <th>Employee Name</th>
                                                <th>Mobile No.</th>
                                                <th>Cheque Date</th>
                                                <th>Cheque No.</th>
                                                <th>Amount</th>
                                                <th>Status</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php foreach($employees as $id => $employee): ?>
                                            <tr id="row_<?php echo $id; ?>" data-row_id="<?php echo $id; ?>">
                                                <td><?php echo $employee['registration_code']; ?></td>
                                                <td><?php echo $employee['employee_name']; ?></td>
                                                <td><?php echo $employee['mobile_no']; ?></td>
                                                <td><?php echo $employee['cheque_date']; ?></td>
                                                <td><?php echo $employee['cheque_no']; ?></td>
                                                <td><?php echo $employee['amount']; ?></td>
                                                <td class="status"></td>
                                            </tr>
                                            <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-8"></div>
                                <div class="col-sm-2">
                                    <button type="button" class="btn btn-default form-control" onclick="window.close();">Close</button>
                                </div>
                                <div class="col-sm-2">
                                    <button type="button" class="btn btn-primary form-control" id="btnSendSMS">Send SMS</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        var $URLSendSMS = '<?php echo $href_send_sms; ?>';

        $(document).on('click','#btnSendSMS',function() {
            $(this).prop('disabled',true);
            sendSMS(0);
        });

        function sendSMS($row_id) {
            var $employee = $arrEmployees[$row_id];
            if(typeof $employee !== 'undefined') {
                $employee.row_id = $row_id;
                if($employee.mobile_no == '') {
                    $('#tblEmployee').find('tbody').find('#row_'+$row_id).css('background-color','red');
                    sendSMS(parseInt($row_id)+1);
                } else {
                    var $data = {
                        message  : $('#message').val(),
                        employee : $employee
                    };
                    $.ajax({
                        url: $URLSendSMS,
                        dataType: 'json',
                        type: 'post',
                        data: $data,
                        mimeType:"multipart/form-data",
                        beforeSend: function() {
                            $('#tblEmployee').find('tbody').find('#row_'+$row_id).css('background-color','yellow');
                            $('#tblEmployee').find('tbody').find('#row_'+$row_id).find('.status').html('Sending');
                        },
                        complete: function() {
                        },
                        success: function(json) {
                            if(json.success)
                            {
                                $('#tblEmployee').find('tbody').find('#row_'+$row_id).css('background-color','green');
                                $('#tblEmployee').find('tbody').find('#row_'+$row_id).find('.status').html('Done');
                                sendSMS(parseInt($row_id)+1);
                            } else {
                                alert(json.error);
                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            console.log(xhr.responseText);
                        }
                    })
                }
            }
        }

        var $arrEmployees = <?php echo json_encode($employees); ?>;
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>