<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['date']; ?></label>
                                            <input type="text" id="date" name="date" value="<?php echo $date; ?>" class="form-control <?php echo ($lock!=1?'dtpDate':''); ?>" <?php echo ($lock==1?'readonly':''); ?>/>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['employee']; ?></label>
                                            <select id="employee_registration_id" name="employee_registration_id" class="form-control" <?php echo ($lock==1?'disabled':''); ?>>
                                                <option value="" data-employee_id="" data-registration_code="" data-employee_code=""  >&nbsp;</option>
                                                <?php foreach($employees as $employee): ?>
                                                <option data-employee_id="<?php echo $employee['employee_id'];?>" data-registration_code="<?php echo $employee['registration_code'];?>" data-employee_code="<?php echo $employee['employee_code'];?>" value="<?php echo $employee['employee_registration_id']; ?>" <?php echo ($employee['employee_registration_id']==$employee_registration_id?'selected="true"':''); ?>><?php echo $employee['employee_name'].' ['.$employee['employee_code'].'/'.$employee['registration_code'].']'; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="employee_registration_id" style="display: none;">&nbsp;</label>
                                            <input type="hidden" id="registration_code" name="registration_code" value="<?php echo $registration_code; ?>"  />
                                            <input type="hidden" id="employee_id" name="employee_id" value="<?php echo $employee_id; ?>" />
                                            <input type="hidden" id="employee_code" name="employee_code" value="<?php echo $employee_code; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['total_amount']; ?></label>
                                            <input type="text" id="total_amount" name="total_amount" value="<?php echo $total_amount; ?>" class="form-control fPDecimal text-right" <?php echo ($lock==1?'readonly':''); ?>/>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['description']; ?></label>
                                            <textarea class="form-control" id="description" name="description" rows="3"  <?php echo ($lock==1?'readonly':''); ?>><?php echo $description; ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['from_deduction']; ?></label>
                                            <select id="deduction_id" name="deduction_id" class="form-control"  <?php echo ($lock==1?'disabled':''); ?>>
                                                <option data-company_account_id="0" value="">&nbsp;</option>
                                                <?php foreach($deductions as $deduction): ?>
                                                <option data-company_account_id="<?php echo $deduction['company_account_id'];?>" value="<?php echo $deduction['deduction_id']; ?>" <?php echo ($deduction['deduction_id']==$deduction_id?'selected="true"':''); ?>><?php echo $deduction['deduction_name'].' ['.$deduction['deduction_code'].']'; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_account']; ?></label>
                                            <select id="company_account_id" name="company_account_id" class="form-control"  <?php echo ($lock==1?'disabled':''); ?>>
                                                <option value="0">&nbsp;</option>
                                                <?php foreach($company_accounts as $account): ?>
                                                <option value="<?php echo $account['company_account_id']; ?>" <?php echo ($account['company_account_id']==$company_account_id?'selected="true"':''); ?>><?php echo $account['account_title'].' ['.$account['bank_name'].' - '.$account['account_no'].']'; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['cheque_date']; ?></label>
                                            <input type="text" id="cheque_date" name="cheque_date" value="<?php echo $cheque_date; ?>" class="form-control <?php echo ($lock!=1?'dtpDate':''); ?>"  <?php echo ($lock==1?'readonly':''); ?>/>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['cheque_no']; ?></label>
                                            <input type="text" id="cheque_no" name="cheque_no" value="<?php echo $cheque_no; ?>" class="form-control"  <?php echo ($lock==1?'readonly':''); ?>/>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['start_date']; ?></label>
                                            <input type="text" id="start_date" name="start_date" value="<?php echo $start_date; ?>" class="form-control <?php echo ($lock==1?'':'dtpDate'); ?>"  <?php echo ($lock==1?'readonly':''); ?> />
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['total_installment']; ?></label>
                                            <input type="text" id="total_installment" name="total_installment" value="<?php echo $total_installment; ?>" class="form-control fPInteger text-right" <?php echo ($is_edit==1?'readonly':''); ?>/>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="table-responsive">
                                            <table id="tblLoanInstallment" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th><?php echo $lang['installment_date']; ?></th>
                                                    <th><?php echo $lang['installment_amount']; ?></th>
                                                    <th><?php echo $lang['adjustment_type']; ?></th>
                                                    <th><?php echo $lang['installment_remarks']; ?></th>
                                                    <th style="width: 15px;">
                                                        <button type="button" data-toggle="tooltip" class="btnAddInstallment btn btn-xs btn-primary" title="Add"><i class="fa fa-plus"></i></button>
                                                    </th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $grid_row_installment=0; ?>
                                                <?php $total_installment_amount=0; ?>
                                                <?php foreach($installments as $installment): ?>
                                                <tr id="grid_row_installment_<?php echo $grid_row_installment; ?>" data-grid_row_installment="<?php echo $grid_row_installment; ?>">
                                                    <?php if($installment[payroll_id] == '') { ?>
                                                    <td><input type="text" class="form-control dtpDate" id="installment_<?php echo $grid_row_installment; ?>_installment_date" name="installments[<?php echo $grid_row_installment; ?>][installment_date]" value="<?php echo $installment['installment_date']; ?>" /></td>
                                                    <td><input onchange="calculateTotal();" type="text" class="form-control fPDecimal text-right" id="installment_<?php echo $grid_row_installment; ?>_installment_amount" name="installments[<?php echo $grid_row_installment; ?>][installment_amount]" value="<?php echo $installment['installment_amount']; ?>" /></td>
                                                    <td>
                                                    <select class="form-control" id="installment_<?php echo $grid_row_installment; ?>_adjustment_type" name="installments[<?php echo $grid_row_installment; ?>][adjustment_type]" >
                                                        <option value="Payroll" <?php echo ($installment['adjustment_type'] =='Payroll'?'selected=true':'');?>>Payroll</option>
                                                        <option value="Cash" <?php echo ($installment['adjustment_type'] =='Cash'?'selected=true':'');?>>Cash</option>
                                                        <option value="Transfer" <?php echo ($installment['adjustment_type'] =='Transfer'?'selected=true':'');?>>Transfer</option>
                                                    </select>
                                                    </td>
                                                    <td><input type="text" class="form-control" id="installment_<?php echo $grid_row_installment; ?>_remarks" name="installments[<?php echo $grid_row_installment; ?>][remarks]" value="<?php echo $installment['installment_remarks']; ?>" />

                                                    <td style="width: 15px;">

                                                        <button type="button" onclick="" data-toggle="tooltip" class="btnRemoveGrid btn btn-xs btn-danger" title="Remove">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    </td>
                                                    <?php } else { ?>

                                                    <td><input type="text" class="form-control dtpDate" id="installment_<?php echo $grid_row_installment; ?>_installment_date" name="installments[<?php echo $grid_row_installment; ?>][installment_date]" value="<?php echo $installment['installment_date']; ?>" readonly /></td>
                                                    <td><input onchange="calculateTotal();" type="text" class="form-control text-right" id="installment_<?php echo $grid_row_installment; ?>_installment_amount" name="installments[<?php echo $grid_row_installment; ?>][installment_amount]" value="<?php echo $installment['installment_amount']; ?>" readonly /></td>
                                                    <td>
                                                        <input type="text" class="form-control" id="installment_<?php echo $grid_row_installment; ?>_adjustment_type" name="installments[<?php echo $grid_row_installment; ?>][adjustment_type]" value="<?php echo $installment['adjustment_type']; ?>" readonly />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="installment_<?php echo $grid_row_installment; ?>_remarks" name="installments[<?php echo $grid_row_installment; ?>][remarks]" value="<?php echo $installment['installment_remarks']; ?>" readonly />
                                                        <input type="hidden" class="form-control" id="installment_<?php echo $grid_row_installment; ?>_payroll_id" name="installments[<?php echo $grid_row_installment; ?>][payroll_id]" value="<?php echo $installment['payroll_id']; ?>" />
                                                        <input type="hidden" class="form-control" id="installment_<?php echo $grid_row_installment; ?>_payroll_deduction_id" name="installments[<?php echo $grid_row_installment; ?>][payroll_deduction_id]" value="<?php echo $installment['payroll_deduction_id']; ?>" />
                                                    </td>
                                                    <td>&nbsp;</td>
                                                    <?php } ?>
                                                </tr>
                                                <?php $total_installment_amount += $installment['installment_amount']; ?>
                                                <?php $grid_row_installment++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                            <div class="col-sm-3">
                                                <label>&nbsp;<?php echo $lang['total_amount']; ?></label>
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control fPDecimal text-right" id="total_installment_amount" name="total_installment_amount" value="<?php echo number_format($total_installment_amount,2,'.',''); ?>" readonly />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);

        var $grid_row_installment=<?php echo $grid_row_installment; ?>;
        var $URLGetInstallment='<?php echo $href_get_installment; ?>';
    </script>
    <script type="text/javascript" src="../admin/view/js/payroll/loan.js"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>