<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-body">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label for="document_date"><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label for="document_identity"><span class="required">*</span>&nbsp;<?php echo $lang['document_identity']; ?></label>
                                            <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label for="document_title"><span class="required">*</span>&nbsp;<?php echo $lang['document_title']; ?></label>
                                            <input type="text" id="document_title" name="document_title" value="<?php echo $document_title; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label for="company_account_id"><span class="required">*</span>&nbsp;<?php echo $lang['pay_from']; ?></label>
                                            <select required class="form-control" id="company_account_id" name="company_account_id">
                                                <option value=""></option>
                                                <?php foreach($company_accounts as $account): ?>
                                                <option value="<?php echo $account['company_account_id']; ?>" <?php echo ($company_account_id==$account['company_account_id']?'selected':'')?>><?php echo $account['account_title'].' ['.$account['account_no'].']'; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="company_account_id" class="error">&nbsp;</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label for="bank_branch"><span class="required">*</span>&nbsp;<?php echo $lang['bank_branch']; ?></label>
                                            <input type="text" id="bank_branch" name="bank_branch" value="<?php echo $bank_branch; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label for="cheque_date"><span class="required">*</span>&nbsp;<?php echo $lang['cheque_date']; ?></label>
                                            <input type="text" id="cheque_date" name="cheque_date" value="<?php echo $cheque_date; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label for="cheque_no"><span class="required">*</span>&nbsp;<?php echo $lang['cheque_no']; ?></label>
                                            <input type="text" id="cheque_no" name="cheque_no" value="<?php echo $cheque_no; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label for="total_allowance"><span class="required">*</span>&nbsp;<?php echo $lang['cheque_amount']; ?></label>
                                            <input type="text" id="total_allowance" name="total_allowance" value="<?php echo $total_allowance; ?>" class="form-control text-right" readonly/>
                                        </div>
                                    </div>
                                </div>
                                <hr />
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label for="bank_id"><span class="required">*</span>&nbsp;<?php echo $lang['bank']; ?></label>
                                            <select class="form-control" id="bank_id" name="bank_id">
                                                <option value="">-- No Selection --</option>
                                                <?php foreach($banks as $bank): ?>
                                                <option value="<?php echo $bank['bank_id']; ?>" <?php echo ($bank_id==$bank['bank_id']?'selected':'')?>><?php echo $bank['bank_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="bank_id" class="error">&nbsp;</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <option value="">&nbsp;</option>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>" <?php echo (in_array($department['department_id'], $department_id)?'selected':'')?>><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="department_id" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['registration_code']; ?></label>
                                            <input type="text" id="registration_code" name="registration_code" value="<?php echo $registration_code; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" id="btnCalculate" name="btnCalculate" class="btn btn-primary form-control">Get Data</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="tblManualAllowance" class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th><input type="checkbox" id="chk_all" value="1" /></th>
                                                    <th>Sr.</th>
                                                    <th><?php echo $lang['registration_code']; ?></th>
                                                    <th><?php echo $lang['employee_name']; ?></th>
                                                    <th><?php echo $lang['bank_name']; ?></th>
                                                    <th><?php echo $lang['account_no']; ?></th>
                                                    <th><?php echo $lang['account_title']; ?></th>
                                                    <th><?php echo $lang['allowance_amount']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $sr=1; ?>
                                                <?php foreach($manual_allowance_details as $index => $row): ?>
                                                <tr data-index="<?php echo $index; ?>">
                                                    <td>
                                                        <input type="checkbox" id="detail_<?php echo $index; ?>_selected" name="details[<?php echo $index; ?>][selected]" value="1" checked/>
                                                        <input type="hidden" id="detail_<?php echo $index; ?>_employee_registration_id" name="details[<?php echo $index; ?>][employee_registration_id]" value="<?php echo $row['employee_registration_id']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="detail_<?php echo $index; ?>_sr" name="details[<?php echo $index; ?>][sr]" value="<?php echo $sr; ?>" readonly style="min-width: 75px; width: 75px;"/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="detail_<?php echo $index; ?>_registration_code" name="details[<?php echo $index; ?>][registration_code]" value="<?php echo $row['registration_code']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="detail_<?php echo $index; ?>_employee_name" name="details[<?php echo $index; ?>][employee_name]" value="<?php echo $row['employee_name']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="hidden" class="form-control" id="detail_<?php echo $index; ?>_bank_id" name="details[<?php echo $index; ?>][bank_id]" value="<?php echo $row['bank_id']; ?>" readonly/>
                                                        <input type="text" class="form-control" id="detail_<?php echo $index; ?>_bank_name" name="details[<?php echo $index; ?>][bank_name]" value="<?php echo $row['bank_name']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="detail_<?php echo $index; ?>_account_no" name="details[<?php echo $index; ?>][account_no]" value="<?php echo $row['account_no']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="detail_<?php echo $index; ?>_account_title" name="details[<?php echo $index; ?>][account_title]" value="<?php echo $row['account_title']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control fPDecimal text-right" id="detail_<?php echo $index; ?>_allowance_amount" name="details[<?php echo $index; ?>][allowance_amount]" value="<?php echo $row['allowance_amount']; ?>" required/>
                                                    </td>
                                                </tr>
                                                <?php $sr++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);

        var $URLGetEmployeeData = '<?php echo $href_get_employee_data; ?>';
    </script>
    <script type="text/javascript" src="../admin/view/js/payroll/manual_allowance.js"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>