<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="document_identity"><span class="required">*</span>&nbsp;<?php echo $lang['document_no']; ?></label>
                                            <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="document_date"><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <?php if($isEdit==1): ?>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control" readonly/>
                                            <?php else: ?>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="nominee_name">&nbsp;<?php echo $lang['nominee_name']; ?></label>
                                            <input type="text" id="nominee_name" name="nominee_name" value="<?php echo $nominee_name; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="reason_for">&nbsp;<?php echo $lang['reason_for']; ?></label>
                                            <input type="text" id="reason_for" name="reason_for" value="<?php echo $reason_for; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="employee_registration_id"><span class="required">*</span>&nbsp;<?php echo $lang['employee_name']; ?></label>
                                            <?php if($isEdit==1): ?>
                                            <input type="text" id="employee_name" name="employee_name" value="<?php echo $employee_name; ?>" class="form-control" readonly />
                                            <input type="hidden" id="employee_registration_id" name="employee_registration_id" value="<?php echo $employee_registration_id; ?>" />
                                            <?php else: ?>
                                            <select class="form-control" id="employee_registration_id" name="employee_registration_id">
                                                <option value="" data-employee_code="" data-employee_address="">&nbsp;</option>
                                                <?php foreach($company_employees as $company_name => $employees): ?>
                                                <optgroup label="<?php echo $company_name; ?>">
                                                    <?php foreach($employees as $employee): ?>
                                                    <option data-employee_code="<?php echo $employee['employee_code'];?>" data-employee_address="<?php echo $employee['cnic_address'];?>" value="<?php echo $employee['employee_registration_id']; ?>"><?php echo $employee['employee_name']; ?></option>
                                                    <?php endforeach; ?>
                                                </optgroup>
                                                <?php endforeach; ?>
                                            </select>
                                            <input type="hidden" id="employee_name" name="employee_name" value="<?php echo $employee_name; ?>" />
                                            <?php endif; ?>
                                            <input type="hidden" id="employee_code" name="employee_code" value="<?php echo $employee_code; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-9">
                                        <div class="form-group">
                                            <label for="employee_address"><span class="required">*</span>&nbsp;<?php echo $lang['employee_address']; ?></label>
                                            <input type="text" id="employee_address" name="employee_address" value="<?php echo $employee_address; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="ref_documents"><span class="required">*</span>&nbsp;<?php echo $lang['reference_document']; ?></label>
                                            <?php if($isEdit==1): ?>
                                            <input type="text" class="form-control" id="ref_document_identity" name="ref_document_identity" value="<?php echo $ref_document_identity; ?>" readonly/>
                                            <?php else: ?>
                                            <select class="form-control" id="ref_document" name="ref_document">
                                                <option value="">&nbsp;</option>
                                            </select>
                                            <input type="hidden" id="ref_document_identity" name="ref_document_identity" value="<?php echo $ref_document_identity; ?>" />
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="payment_for"><span class="required">*</span>&nbsp;<?php echo $lang['payment_for']; ?></label>
                                            <input type="text" id="payment_for" name="payment_for" value="<?php echo $payment_for; ?>" class="form-control" readonly/>
                                            <input type="hidden" id="source_table" name="source_table" value="<?php echo $source_table; ?>" class="form-control" readonly/>
                                            <input type="hidden" id="source_table_id" name="source_table_id" value="<?php echo $source_table_id; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="transfer_type"><span class="required">*</span>&nbsp;<?php echo $lang['transfer_type']; ?></label>
                                            <input type="text" id="transfer_type" name="transfer_type" value="<?php echo $transfer_type; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="amount"><span class="required">*</span>&nbsp;<?php echo $lang['amount']; ?></label>
                                            <input type="text" id="amount" name="amount" value="<?php echo $amount; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="bank_name"></span>&nbsp;<?php echo $lang['bank_name']; ?></label>
                                            <input type="text" id="bank_name" name="bank_name" value="<?php echo $bank_name; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="bank_name"></span>&nbsp;<?php echo $lang['bank_title']; ?></label>
                                            <input type="text" id="bank_title" name="bank_title" value="<?php echo $bank_title; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="cheque_date">&nbsp;<?php echo $lang['cheque_date']; ?></label>
                                            <input type="text" id="cheque_date" name="cheque_date" value="<?php echo $cheque_date; ?>" class="form-control dtpDate" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="cheque_no">&nbsp;<?php echo $lang['cheque_no']; ?></label>
                                            <input type="text" id="cheque_no" name="cheque_no" value="<?php echo $cheque_no; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/payment_letter.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $URLGetReferenceDocuments = '<?php echo $href_ref_documents; ?>';

        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>