<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['email']; ?></h1>
            <div class="row">
                <div class="col-md-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-body">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form id="form" method="post" enctype="multipart/form-data">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="from_date"><span class="required">*</span>&nbsp;<?php echo $lang['from_date']; ?></label>
                                            <input required type="text" id="from_date" name="from_date" value="" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="to_date"><span class="required">*</span>&nbsp;<?php echo $lang['to_date']; ?></label>
                                            <input required type="text" id="to_date" name="to_date" value="" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="department_id"><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <select id="department_id" name="department_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <br />
                                            <div class="pull-right box-tools">
                                                <button id="btnGetRecords" onclick="getEmailData();" type="button" class="btn btn-primary" title="Send Email" data-toggle="tooltip"><i class="fa fa-envelope"></i> Send Email</button>
                                                <a class="btn btn-primary" title="Return Back" data-toggle="tooltip" href="<?php echo $action_cancel; ?>"><i class="fa fa-undo"></i> Return</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr />
                                <div class="row">
                                    <div class="col-md-12">
                                        <div id="tblEmails" class="table-responsive">
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <?php if($deposit_slip_id == ''): ?>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $URLGetPayrollData = '<?php echo $href_get_payroll_data; ?>';
        var $URLSendEmail = '<?php echo $href_send_email; ?>';
        function getEmailData() {
            if($('#form').valid()) {
                var $data = {
                    'date_from': $('#from_date').val(),
                    'date_to': $('#to_date').val(),
                    'department_id': $('#department_id').val(),
                };

                $.ajax({
                    url: $URLGetPayrollData,
                    dataType: 'json',
                    type: 'post',
                    data: $data,
                    mimeType:"multipart/form-data",
                    beforeSend: function() {
                        //$('#tblAssessmentField').before('<i id="loader" class="fa fa-refresh fa-spin"></i>');
                        $('#btnGetRecords').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Fetching Data');
                        $('#tblEmails').html('');
                    },
                    complete: function() {
                        $('#btnGetRecords').html('<i class="fa fa-envelope"></i>&nbsp;Send Email');
                        $('#btnGetRecords').prop('disabled',false);
                        sendEmail(0);
                    },
                    success: function(json) {
                        if(json.success)
                        {
                            $('#tblEmails').html(json.html);
                            console.log(json);
                        } else {
                            alert(json.error);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        console.log(xhr.responseText);
                    }
                })

            } else {
                console.log("FALSE");
            }
        }

        function sendEmail($id) {
            var $data = $('#M'+$id).data();
            if($data) {
                if(isValidEmail($data['email'])) {
                    $data['id'] = $id;

                    $.ajax({
                        url: $URLSendEmail,
                        dataType: 'json',
                        type: 'post',
                        data: $data,
                        mimeType:"multipart/form-data",
                        beforeSend: function() {
                            $('#M'+$id+' .status').html("Working");
                            $('#M'+$id).css("background-color", "yellow");
                        },
                        complete: function() {
                        },
                        success: function(json) {
                            if(json.success)
                            {
                                $('#M'+json.id+' .status').html("Done");
                                $('#M'+json.id).css("background-color", "green");
                                sendEmail(json.next_id);
                            } else {
                                alert(json.error);
                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#M'+$id+' .status').html("Invalid Email");
                    $('#M'+$id).css("background-color", "red");
                    sendEmail(parseInt($id)+1);
                }
            } else {
                $('#btnGetRecords').prop('disabled',false);
            }
            console.log($data);
        }

        function isValidEmail(email) {
            var regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if(!regex.test(email)) {
                return false;
            }else{
                return true;
            }
        }

    </script>
    <script type="text/javascript" src="../admin/view/js/payroll/payroll.js"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>