<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-md-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-md-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <?php if($deposit_slip_id == ''): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-body">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['from_date']; ?></label>
                                            <input type="text" id="from_date" name="from_date" value="<?php echo $from_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['to_date']; ?></label>
                                            <input type="text" id="to_date" name="to_date" value="<?php echo $to_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['working_days']; ?></label>
                                            <input type="text" id="working_days" name="working_days" value="<?php echo $working_days; ?>" class="form-control fPInteger"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_title']; ?></label>
                                            <input type="text" id="document_title" name="document_title" value="<?php echo $document_title; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['employee_name']; ?></label>
                                            <?php if($is_edit==1): ?>
                                            <input type="hidden" id="employee_registration_id" name="employee_registration_id" value="<?php echo $employee_registration_id; ?>" />
                                            <input type="text" class="form-control" id="employee_name" name="employee_name" value="<?php echo $registration_code . ' - ' . $employee_name; ?>" readonly/>
                                            <?php else: ?>
                                            <select class="form-control" id="employee_registration_id" name="employee_registration_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($employees as $employee): ?>
                                                <option value="<?php echo $employee['employee_registration_id']; ?>" <?php echo ($employee['employee_registration_id']==$employee_registration_id?'selected="true"':'');?>><?php echo $employee['employee_code'] . ' - ' . $employee['employee_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="employee_registration_id" style="display: none;"></label>
                                            <?php endif; ?>
                                            <input type="hidden" id="employee_id" name="employee_id" value="<?php echo $employee_id; ?>" />
                                            <input type="hidden" id="bank_id" name="bank_id" value="<?php echo $bank_id; ?>" />
                                            <input type="hidden" id="bank_account_no" name="bank_account_no" value="<?php echo $bank_account_no; ?>" />
                                            <input type="hidden" id="bank_account_title" name="bank_account_title" value="<?php echo $bank_account_title; ?>" />
                                            <input type="hidden" id="bank_iban" name="bank_iban" value="<?php echo $bank_iban; ?>" />
                                            <input type="hidden" id="taxable" name="taxable" value="<?php echo $taxable; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <input type="text" class="form-control" id="department_name" value="<?php echo $department_name; ?>" readonly/>
                                            <input type="hidden" id="department_id" name="department_id" value="<?php echo $department_id; ?>" />
                                        </div>
                                    </div>
                                </div>
                                <hr />
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['basic_salary']; ?></label>
                                                    <input onchange="calcTaxable();" type="text" id="basic_salary" name="basic_salary" value="<?php echo $basic_salary; ?>" class="form-control text-right"/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['house_rent_percent']; ?></label>
                                                    <input type="text" id="house_rent_percent" name="house_rent_percent" value="<?php echo $house_rent_percent; ?>" class="form-control text-right"/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['house_rent_allowance']; ?></label>
                                                    <input onchange="calcTaxable();" type="text" id="house_rent_allowance" name="house_rent_allowance" value="<?php echo $house_rent_allowance; ?>" class="form-control text-right"/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['arrears']; ?></label>
                                                    <input onchange="calcTaxable();" type="text" id="arrears" name="arrears" value="<?php echo $arrears; ?>" class="form-control text-right"/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['manual_addition']; ?></label>
                                                    <input onchange="calcTaxable();" type="text" id="manual_addition" name="manual_addition" value="<?php echo $manual_addition; ?>" class="form-control text-right"/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['overtime']; ?></label>
                                                    <input onchange="calcTaxable();" type="text" id="overtime" name="overtime" value="<?php echo $overtime; ?>" class="form-control text-right"/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['taxable_allowance']; ?></label>
                                                    <input type="text" id="taxable_allowance" name="taxable_allowance" value="<?php echo $taxable_allowance; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['grossable_allowance']; ?></label>
                                                    <input type="text" id="grossable_allowance" name="grossable_allowance" value="<?php echo $grossable_allowance; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['gross_salary']; ?></label>
                                                    <input type="text" id="gross_salary" name="gross_salary" value="<?php echo $gross_salary; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['taxable_salary']; ?></label>
                                                    <input type="text" id="taxable_salary" name="taxable_salary" value="<?php echo $taxable_salary; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['other_deduction']; ?></label>
                                                    <input onchange="calcPayable();" type="text" id="other_deduction" name="other_deduction" value="<?php echo $other_deduction; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['manual_deduction']; ?></label>
                                                    <input onchange="calcPayable();" type="text" id="manual_deduction" name="manual_deduction" value="<?php echo $manual_deduction; ?>" class="form-control text-right"/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['net_salary']; ?></label>
                                                    <input type="text" id="net_salary" name="net_salary" value="<?php echo $net_salary; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['total_present']; ?></label>
                                                    <input type="text" id="total_present" name="total_present" value="<?php echo $total_present; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['total_absent']; ?></label>
                                                    <input onchange="calcPayable();" type="text" id="total_absent" name="total_absent" value="<?php echo $total_absent; ?>" class="form-control text-right" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['attendance_deduction']; ?></label>
                                                    <input type="text" id="attendance_deduction" name="attendance_deduction" value="<?php echo $attendance_deduction; ?>" class="form-control text-right" readonly/>
                                                    <input type="hidden" id="daily_deduction" name="daily_deduction" value="<?php echo $daily_deduction; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['tax_deduction']; ?></label>
                                                    <input onchange="calcPayable();" type="text" id="tax_deduction" name="tax_deduction" value="<?php echo $tax_deduction; ?>" class="form-control text-right"/>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['payable_salary']; ?></label>
                                                    <input type="text" id="payable_salary" name="payable_salary" value="<?php echo $payable_salary; ?>" class="form-control text-right" readonly/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="panel panel-default">
                                            <div class="panel-heading">
                                                <label><?php echo $lang['allowance']; ?></label>
                                            </div>
                                            <div class="panel-body">
                                                <div class="table-responsive">
                                                    <table id="tblPayrollAllowance" class="table table-bordered">
                                                        <thead>
                                                        <tr>
                                                            <th><?php echo $lang['code']; ?></th>
                                                            <th><?php echo $lang['name']; ?></th>
                                                            <th><?php echo $lang['amount']; ?></th>
                                                            <th><?php echo $lang['grossable']; ?></th>
                                                            <th><?php echo $lang['taxable']; ?></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $total_allowance=0; ?>
                                                        <?php foreach($allowances as $allowance_row => $allowance): ?>
                                                        <tr data-allowance_row="<?php echo $allowance_row; ?>">
                                                            <td>
                                                                <?php echo $allowance['allowance_code']; ?>
                                                                <input type="hidden" id="payroll_allowance_<?php echo $allowance_row; ?>_payroll_allowance_id" name="payroll_allowances[<?php echo $allowance_row; ?>][payroll_allowance_id]" value="<?php echo $allowance['payroll_allowance_id']; ?>" />
                                                                <input type="hidden" id="payroll_allowance_<?php echo $allowance_row; ?>_allowance_id" name="payroll_allowances[<?php echo $allowance_row; ?>][allowance_id]" value="<?php echo $allowance['allowance_id']; ?>" />
                                                            </td>
                                                            <td>
                                                                <?php echo $allowance['allowance_name']; ?>
                                                            </td>
                                                            <td class="text-right">
                                                                <input onchange="calculateOtherAllowance();" type="text" class="form-control text-right fPDecimal" id="payroll_allowance_<?php echo $allowance_row; ?>_allowance_amount" name="payroll_allowances[<?php echo $allowance_row; ?>][allowance_amount]" value="<?php echo $allowance['allowance_amount']; ?>" />
                                                            </td>
                                                            <td class="text-right">
                                                                <input onchange="calculateOtherAllowance();" type="checkbox" id="payroll_allowance_<?php echo $allowance_row; ?>_grossable" name="payroll_allowances[<?php echo $allowance_row; ?>][grossable]" value="1" <?php echo ($allowance['grossable']==1?'checked':''); ?> />
                                                            </td>
                                                            <td class="text-right">
                                                                <input onchange="calculateOtherAllowance();" type="checkbox" id="payroll_allowance_<?php echo $allowance_row; ?>_taxable" name="payroll_allowances[<?php echo $allowance_row; ?>][taxable]" value="1" <?php echo ($allowance['taxable']==1?'checked':''); ?>/>
                                                            </td>
                                                        </tr>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="panel panel-default">
                                            <div class="panel-heading">
                                                <label><?php echo $lang['deduction']; ?></label>
                                            </div>
                                            <div class="panel-body">
                                                <div class="table-responsive">
                                                    <table id="tblPayrollDeduction" class="table table-bordered">
                                                        <thead>
                                                        <tr>
                                                            <th><?php echo $lang['code']; ?></th>
                                                            <th><?php echo $lang['name']; ?></th>
                                                            <th><?php echo $lang['amount']; ?></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $total_deduction=0; ?>
                                                        <?php foreach($deductions as $deduction_row=>$deduction): ?>
                                                        <tr data-deduction_row="<?php echo $deduction_row; ?>">
                                                            <td>
                                                                <?php echo $deduction['deduction_code']; ?>
                                                                <input type="hidden" id="payroll_deduction_<?php echo $deduction_row; ?>_payroll_deduction_id" name="payroll_deductions[<?php echo $deduction_row; ?>][payroll_deduction_id]" value="<?php echo $deduction['payroll_deduction_id']; ?>"/>
                                                                <input type="hidden" id="payroll_deduction_<?php echo $deduction_row; ?>_deduction_id" name="payroll_deductions[<?php echo $deduction_row; ?>][deduction_id]" value="<?php echo $deduction['deduction_id']; ?>"/>
                                                            </td>
                                                            <td>
                                                                <?php echo $deduction['deduction_name']; ?>
                                                            </td>
                                                            <td class="text-right">
                                                                <?php if($deduction['ref_document'] != 'Employee Deduction'): ?>
                                                                <?php echo $deduction['ref_document'] . ' - '. $deduction['deduction_amount']; ?>
                                                                <input type="hidden" class="form-control text-right fPDecimal" id="payroll_deduction_<?php echo $deduction_row; ?>_deduction_amount" name="payroll_deductions[<?php echo $deduction_row; ?>][deduction_amount]" value="<?php echo $deduction['deduction_amount']; ?>"/>
                                                                <?php else : ?>
                                                                <input onchange="calculateOtherDeduction();" type="text" class="form-control text-right fPDecimal" id="payroll_deduction_<?php echo $deduction_row; ?>_deduction_amount" name="payroll_deductions[<?php echo $deduction_row; ?>][deduction_amount]" value="<?php echo $deduction['deduction_amount']; ?>"/>
                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <?php if($deposit_slip_id == ''): ?>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);

        var $URLGetPayroll = '<?php echo $href_get_payroll; ?>';
        var $URLGetTaxAmount = '<?php echo $href_get_tax_amount; ?>';
    </script>
    <script type="text/javascript" src="../admin/view/js/payroll/payroll.js?v=20221220"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>