<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-info" title="Send Bulk Email" data-toggle="tooltip" href="<?php echo $href_get_email; ?>" ><i class="fa fa-envelope"></i></a>
                        <a class="btn btn-primary" title="Add New" data-toggle="tooltip" href="<?php echo $action_insert; ?>"><i class="fa fa-plus"></i></a>
                        <button onclick="ConfirmDelete('<?php echo $action_delete; ?>',1)" class="btn btn-danger" title="Delete" data-toggle="tooltip" type="button"><i class="fa fa-trash-o"></i></button>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?></div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?></div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="#" method="post" enctype="multipart/form-data" id="form">
                                <table id="dataTable" class="table table-striped table-bordered table-hover" align="center">
                                    <thead>
                                    <tr>
                                        <td align="center"><?php echo $lang['action']; ?></td>
                                        <td align="center"><?php echo $lang['document_date']; ?></td>
                                        <td align="center"><?php echo $lang['document_title']; ?></td>
                                        <td align="center"><?php echo $lang['department']; ?></td>
                                        <td align="center"><?php echo $lang['employee_code']; ?></td>
                                        <td align="center"><?php echo $lang['registration_code']; ?></td>
                                        <td align="center"><?php echo $lang['employee_name']; ?></td>
                                        <td align="center"><?php echo $lang['gross_salary']; ?></td>
                                        <td align="center"><?php echo $lang['tax_deduction']; ?></td>
                                        <td align="center"><?php echo $lang['payable_salary']; ?></td>
                                        <td align="center"><?php echo $lang['exclusive']; ?></td>
                                        <td align="center"><?php echo $lang['created_at']; ?></td>
                                        <td align="center"><input id="check_all" type="checkbox" /></td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<link rel="stylesheet" href="plugins/dataTables/dataTables.bootstrap.css">
<script src="plugins/dataTables/jquery.dataTables.js"></script>
<script src="plugins/dataTables/dataTables.bootstrap.js"></script>
<script type="text/javascript">
    var $URLSendEmail = '<?php echo $href_send_email; ?>';
    var $departments = <?php echo json_encode($departments); ?>;

    $(document).on('click','#check_all',function() {
        var $val = $(this).is(':checked');
        if($val==true) {
            $('#dataTable').find('tbody').find('input[type=checkbox]').prop('checked', true);
        } else {
            $('#dataTable').find('tbody').find('input[type=checkbox]').prop('checked', false);
        }
    });
    jQuery(document).ready(function(){
        oTable = jQuery('#dataTable').dataTable({
            "bProcessing": true,
            "bServerSide": true,
            "bFilter": true,
            "bAutoWidth": false,
            "sPaginationType": "full_numbers",
            "sAjaxSource": "<?php echo $action_ajax; ?>"
            ,"aoColumnDefs" : [ {
                'bSortable' : false,
                'aTargets' : [ 0,12 ]
            }, {
                'bSearchable' : false,
                'aTargets' : [ 0,12 ]
            } ]
            , "aaSorting": [[ 11, "desc" ]]
            , "pageLength": 50
        });
    });

    function sendEmail($obj, $payroll_id) {
        $.ajax({
            url: $URLSendEmail,
            dataType: 'json',
            type: 'post',
            data: 'payroll_id='+$payroll_id,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $($obj).html('<span class="fa fa-refresh fa-spin"></span>');
            },
            complete: function() {
                $($obj).html('<span class="fa fa-envelope-square"></span>')
                // $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    //$($obj).html('<span class="fa fa-envelope-square"></span>');
                    $($obj).remove();
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }

    function BootboxContent() {
        var $html = '';
        $html += '<div class="row text-left">';
        $html += '  <div class="col-sm-6">';
        $html += '      <div class="form-group">';
        $html += '          <label for="from_date"><span data-toggle="tooltip" title="From Date">From Date</span></label>';
        $html += '          <input type="text" name="from_date" value="" placeholder="From Date" id="from_date" class="form-control dtpDate">';
        $html += '      </div>';
        $html += '  </div>';
        $html += '  <div class="col-sm-6">';
        $html += '      <div class="form-group">';
        $html += '          <label for="to_date"><span data-toggle="tooltip" title="To Date">To Date</span></label>';
        $html += '          <input type="text" name="to_date" value="" placeholder="To Date" id="to_date" class="form-control dtpDate">';
        $html += '      </div>';
        $html += '  </div>';
        $html += '</div>';
        $html += '<div class="row text-left">';
        $html += '  <div class="col-sm-12">';
        $html += '      <div class="form-group">';
        $html += '          <label for="department"><span data-toggle="tooltip" title="Department">Department</span></label>';
        $html += '          <select class="form-control" id="department_id" name="department_id">';
        $html += '              <option value="">&nbsp;</option>';
        <?php foreach($departments as $department): ?>
        $html += '              <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>';
        <?php endforeach; ?>
        $html += '          </select>';
        $html += '      </div>';
        $html += '  </div>';
        $html += '</div>';

        var object = $('<div/>').html($html).contents();

        object.find('.dtpDate').datetimepicker({
            format: "DD-MM-YYYY",
            startDate: "1900-01-01",
            pickTime: false,
            autoclose: true
        });

        return object
    }

    function sendBulkEmail() {
        var dialog = bootbox.dialog({
            title: 'Send Email',
            message: BootboxContent,
            buttons: {
                send: {
                    label: "Send",
                    className: 'btn-info',
                    callback: function(){
                        var $from_date = $('#from_date').val();
                        var $to_date = $('#to_date').val();
                        var $department_id = $('#department_id').val();
                        console.log($from_date, $to_date, $department_id);
                        if($from_date=='') {
                            alert('From Date is Required');
                        } else if($to_date=='') {
                            alert('To Date is Required');
                        //} else if($department_id=='') {
                            //alert('Department is Required');
                        } else {
                            $.ajax({
                                url: $URLSendEmail,
                                dataType: 'json',
                                type: 'post',
                                data: 'from_date='+$from_date+'&to_date='+$to_date+'&department_id='+$department_id,
                                mimeType:"multipart/form-data",
                                beforeSend: function() {
                                    var obj = $('.bootbox').find('.btn-info');
                                    $(obj).prop('disabled',true);
                                },
                                complete: function() {
                                },
                                success: function(json) {
                                    if(json.success)
                                    {
                                        console.log(json);
                                    } else {
                                        alert(json.error);
                                    }
                                    dialog.modal('hide');
                                },
                                error: function(xhr, ajaxOptions, thrownError) {
                                    console.log(xhr.responseText);
                                }
                            })
                        }
                        return false;
                    }
                }
            }
        });
    }
</script>
<?php echo $footer; ?>
</body>
</html>