<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-md-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-md-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <?php if($is_post != 1): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="save();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                        <?php endif; ?>
                        <?php if($is_edit == 1 && $is_post != 1): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="finalize();">
                            <i class="fa fa-thumbs-up"></i>
                            &nbsp;<?php echo $lang['finalize']; ?>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-body">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_no']; ?></label>
                                            <input type="text" value="<?php echo $document_identity; ?>  " id="document_identity" readonly="true"  name="document_identity" class="form-control"/>
                                            <label class="error" for="document_no" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>" <?php echo ($department['department_id']==$department_id?'selected="true"':''); ?> ><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="department_id" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['employee']; ?></label>
                                            <select class="form-control" id="employee_registration_id" name="employee_registration_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($registrations as $employee): ?>
                                                <option value="<?php echo $employee['employee_registration_id']; ?>" <?php echo ($employee['employee_registration_id']==$employee_registration_id?'selected="true"':''); ?> ><?php echo $employee['registration_code'].' - '.$employee['employee_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="employee_registration_id" style="display: none;"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['wef_date']; ?></label>
                                            <input type="text" id="wef_date" value="<?php echo $wef_date; ?>" name="wef_date" class="form-control dtpDate"/>
                                            <label class="error" for="wef_date" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['increment_percentage']; ?></label>
                                            <input type="text" value="<?php echo $increment_percent; ?>" id="total_increment_percent"  name="total_increment_percent" class="form-control fPDecimal"/>
                                            <label class="error" for="department_id" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['increment_amount']; ?></label>
                                            <input type="text" id="total_increment_amount" name="total_increment_amount" class="form-control fPDecimal" value="<?php echo $increment_amount; ?>"/>
                                            <label class="error" for="total_increment_amount" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <?php if($is_post != 1): ?>
                                        <label>&nbsp;</label>
                                        <button id="btnSearch" type="button" class="form-control btn btn-primary"><i class="fa fa-floppy-o"></i>&nbsp;<?php echo $lang['calculate']; ?></button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="table-responsive">
                                                <table id="tblSalaryIncrement" class="table table-striped table-bordered">
                                                    <thead class="th-color">
                                                    <tr>
                                                        <th><input type="checkbox" name="is_selected" id="is_selected" value="1" /></th>
                                                        <th class="center">Sr.</th>
                                                        <th class="center"><?php echo $lang['employee_name']; ?></th>
                                                        <th class="center"><?php echo $lang['joining_date']; ?></th>
                                                        <th class="center"><?php echo $lang['no_of_years']; ?></th>
                                                        <th class="center"><?php echo $lang['designation']; ?></th>
                                                        <th class="center"><?php echo $lang['history']; ?></th>
                                                        <th class="center"><?php echo $lang['last_salary_updated']; ?></th>
                                                        <th class="center"><?php echo $lang['basic_salary']; ?></th>
                                                        <th class="center"><?php echo $lang['increment_percentage']; ?></th>
                                                        <th class="center"><?php echo $lang['increment_amount']; ?></th>
                                                        <th class="center"><?php echo $lang['new_salary']; ?></th>
                                                        <th class="center"><?php echo $lang['arrears']; ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <input type="hidden" name="salary_increment_id" value="<?php echo $salary_increment_id; ?>" />
                                                    <?php foreach($salary_increment_details as $key => $detail)
                                                    { ?>
                                                    <tr>
                                                        <td><input type="checkbox" id="is_select_<?php echo $key; ?>" name="increment_process[<?php echo $key; ?>][is_select]" value="1" checked="true" /></td>
                                                        <td><?php echo ($key+1); ?></td>
                                                        <td><?php echo $detail['employee']; ?>
                                                            <input type="hidden" name="increment_process[<?php echo $key; ?>][employee_registration_id]" id="employee_registration_id_<?php echo $key; ?>" value="<?php echo $detail['employee_registration_id']; ?>" />
                                                            <input type="hidden" name="increment_process[<?php echo $key; ?>][employee]" id="employee_<?php echo $key; ?>" value="<?php echo $detail['employee']; ?>" />
                                                            <input type="hidden" name="increment_process[<?php echo $key; ?>][employee_salary_id]" id="employee_salary_id_<?php echo $key; ?>" value="<?php echo $detail['employee_salary_id']; ?>" />
                                                            <input type="hidden" name="increment_process[<?php echo $key; ?>][employee_id]" id="employee_id_<?php echo $key; ?>" value="<?php echo $detail['employee_id']; ?>" />
                                                            <input type="hidden" name="increment_process[<?php echo $key; ?>][company_id]" id="company_id_<?php echo $key; ?>" value="<?php echo $detail['company_id']; ?>" />
                                                        </td>
                                                        <td><?php echo $detail['joining_date']; ?>
                                                            <input type="hidden" value="<?php echo $detail['joining_date']; ?>" name="increment_process[<?php echo $key; ?>][joining_date]" />
                                                        </td>
                                                        <td>
                                                            <?php
                                                            $date = Date('Y-m-d');
                                                            $date1 = new DateTime($detail['joining_date']);
                                                            $date2 = new DateTime($date);
                                                            $interval = $date1->diff($date2);
                                                            ?>
                                                            <?php echo $detail['no_of_years']; ?>
                                                            <input type="hidden" value="<?php echo $detail['no_of_years']; ?>" name="increment_process[<?php echo $key; ?>][no_of_years]" />
                                                        </td>
                                                        <td>
                                                            <?php echo $detail['designation_name']; ?>
                                                            <input type="hidden" value="<?php echo $detail['designation_name']; ?>" name="increment_process[<?php echo $key; ?>][designation_name]" />
                                                        </td>
                                                        <td><button class="btn btn-xs btn-info" onclick="getHistory(event,<?php echo $key; ?>);" data-id="<?php echo $detail['employee_registration_id']; ?>">History</button></td>
                                                        <td>
                                                            <?php echo stdDate($detail['last_salary_updated']); ?>
                                                            <input type="hidden" name="increment_process[<?php echo $key; ?>][last_salary_updated]" id="last_salary_updated_<?php echo $key; ?>" value="<?php echo $detail['last_salary_updated']; ?>" />
                                                        </td>
                                                        <td>
                                                            <?php echo $detail['basic_salary']; ?>
                                                            <input type="hidden" name="increment_process[<?php echo $key; ?>][basic_salary]" id="basic_salary_<?php echo $key; ?>" value="<?php echo $detail['basic_salary']; ?>" />
                                                        </td>
                                                        <td data-id="<?php echo $key; ?>">
                                                            <input type="text" class="form-control"  onchange="calculateAmount(this);" id="increment_percent_<?php echo $key; ?>" name="increment_process[<?php echo $key; ?>][increment_percent]" value="<?php echo $detail['increment_percent']; ?>" />
                                                        </td>
                                                        <td data-id="<?php echo $key; ?>">
                                                            <input type="text" class="form-control" onchange="calculatePercent(this);" id="increment_amount_<?php echo $key; ?>" name="increment_process[<?php echo $key; ?>][increment_amount]" value="<?php echo $detail['increment_amount']; ?>" />
                                                        </td>
                                                        <td data-id="<?php echo $key; ?>">
                                                            <input type="text" name="increment_process[<?php echo $key; ?>][new_salary]" class="form-control" onchange="calculateNewSalary(this);" id="new_salary_<?php echo $key; ?>" value="<?php echo $detail['new_salary']; ?>" />
                                                        </td>
                                                        <td data-id="<?php echo $key; ?>">
                                                            <input type="text" name="increment_process[<?php echo $key; ?>][arrears]" class="form-control" id="new_salary_<?php echo $key; ?>" value="<?php echo $detail['arrears']; ?>" />
                                                        </td>
                                                    </tr>

                                                    <?php }
                                                ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <?php if($is_post != 1): ?>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="save();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <?php endif; ?>
                                <?php if($is_edit == 1 && $is_post != 1): ?>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="finalize();">
                                    <i class="fa fa-thumbs-up"></i>
                                    &nbsp;<?php echo $lang['finalize']; ?>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Salary History</h4>
                </div>
                <div class="modal-body" id="modal-body">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);

        var $URLGetData = '<?php echo $href_get_emp_data; ?>';
        var $URLGetArrears = '<?php echo $href_get_arrears; ?>';
        var $URLGetSalaryHistory = '<?php echo $href_get_salary_history; ?>';
        var $UrlFinalize = '<?php echo $action_finalize; ?>';
    </script>
    <script type="text/javascript" src="../admin/view/js/payroll/salary_increment.js"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>