<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <?php if($total_paid_amount == 0): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="submitDocument();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-8">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['voucher_no']; ?></label>
                                                    <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['date']; ?></label>
                                                    <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['employee_name']; ?></label>
                                                    <?php if($isEdit): ?>
                                                    <input type="hidden" id="employee_registration_id" name="employee_registration_id" value="<?php echo $employee_registration_id; ?>" />
                                                    <input type="text" class="form-control" id="employee_name" name="employee_name" value="<?php echo $employee_name; ?>" readonly/>
                                                    <?php else: ?>
                                                    <select id="employee_registration_id" name="employee_registration_id" class="form-control">
                                                        <option value="" data-employee_id="" data-registration_code="" data-employee_code="">&nbsp;</option>
                                                        <?php foreach($employees as $employee): ?>
                                                        <option data-employee_id="<?php echo $employee['employee_id'];?>" data-registration_code="<?php echo $employee['registration_code'];?>" data-employee_code="<?php echo $employee['employee_code'];?>" value="<?php echo $employee['employee_registration_id']; ?>" <?php echo ($employee['employee_registration_id']==$employee_registration_id?'selected="true"':''); ?>><?php echo $employee['registration_code'].' - '.$employee['employee_name']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label class="error" for="employee_registration_id" style="display: none;">&nbsp;</label>
                                                    <?php endif; ?>
                                                    <input type="hidden" id="employee_id" name="employee_id" value="<?php echo $employee_id; ?>" />
                                                    <input type="hidden" id="employee_code" name="employee_code" value="<?php echo $employee_code; ?>" />
                                                    <input type="hidden" id="registration_code" name="registration_code" value="<?php echo $registration_code; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['allowance_type']; ?></label>
                                                    <?php if($isEdit): ?>
                                                    <input type="hidden" id="special_allowance_type_id" name="special_allowance_type_id" value="<?php echo $special_allowance_type_id; ?>" />
                                                    <input type="text" class="form-control" id="special_allowance_type" name="special_allowance_type" value="<?php echo $special_allowance_type; ?>" readonly/>
                                                    <?php else: ?>
                                                    <select class="form-control" id="special_allowance_type_id" name="special_allowance_type_id">
                                                        <option></option>
                                                        <?php foreach($special_allowance_types as $type): ?>
                                                        <option value="<?php echo $type['special_allowance_type_id']; ?>" <?php echo ($type['special_allowance_type_id'] == $special_allowance_type_id?'selected=true':'');?>><?php echo $type['special_allowance_type']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="special_allowance_type_id" class="error" style="display: none;">&nbsp;</label>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['document']; ?></label>
                                                    <?php if($href_document_file != ''): ?>
                                                    <a target="_blank" class="pull-right" href="<?php echo $href_document_file; ?>" title="Document"><?php echo $file_name; ?></a>
                                                    <?php endif; ?>
                                                    <input type="file" class="form-control" id="document" name="document" value="" accept="text/plain"  />
                                                    <input type="hidden" class="form-control" id="file_name" name="file_name" value="<?php echo $file_name; ?>" />
                                                    <input type="hidden" class="form-control" id="file_directory" name="file_directory" value="<?php echo $file_directory; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" id="divPeriod">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['medical_from']; ?></label>
                                                    <input type="text" id="medical_from" name="medical_from" value="<?php echo $medical_from; ?>" class="form-control dtpDate"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['medical_to']; ?></label>
                                                    <input type="text" id="medical_to" name="medical_to" value="<?php echo $medical_to; ?>" class="form-control dtpDate"/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="table-responsive">
                                                    <table id="tblSpecialAllowance" class="table table-bordered">
                                                        <thead>
                                                        <tr>
                                                            <th style="width: 15px;" <?php echo ($isEdit==1?'class="hide"':''); ?>><a class="btnAddAllowance btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a></th>
                                                            <th class="text-center"><?php echo $lang['relation']; ?></th>
                                                            <th class="text-center"><?php echo $lang['allowance_category']; ?></th>
                                                            <th class="text-center"><?php echo $lang['amount']; ?></th>
                                                            <th class="text-center"><?php echo $lang['remarks']; ?></th>
                                                            <th class="text-center"><?php echo $lang['receipt_date']; ?></th>
                                                            <th class="text-center"><?php echo $lang['receipt_no']; ?></th>
                                                            <th class="text-center"><?php echo $lang['policy_amount']; ?></th>
                                                            <th class="text-center"><?php echo $lang['approved_amount']; ?></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $grid_row_allowance=0; ?>
                                                        <?php foreach($allowance_details as $detail): ?>

                                                        <tr id="grid_row_id_<?php echo $grid_row_allowance; ?>" data-row_id="<?php echo $grid_row_allowance; ?>">
                                                            <td style="width: 15px;" class="hide">
                                                                <a class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove" href="javascript:void(0);"><i class="fa fa-minus"></i></a>
                                                                <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_special_allowance_detail_id" name="details[<?php echo $grid_row_allowance; ?>][special_allowance_detail_id]" value="<?php echo $detail['special_allowance_detail_id']; ?>" />
                                                            </td>
                                                            <td>
                                                                <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_allowance_for" name="details[<?php echo $grid_row_allowance; ?>][allowance_for]" value="<?php echo $detail['allowance_for']; ?>" />
                                                                <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_school_id" name="details[<?php echo $grid_row_allowance; ?>][school_id]" value="<?php echo $detail['school_id']; ?>" />
                                                                <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_class_id" name="details[<?php echo $grid_row_allowance; ?>][class_id]" value="<?php echo $detail['class_id']; ?>" />
                                                                <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_period_start_date" name="details[<?php echo $grid_row_allowance; ?>][period_start_date]" value="<?php echo $detail['period_start_date']; ?>" />
                                                                <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_period_end_date" name="details[<?php echo $grid_row_allowance; ?>][period_end_date]" value="<?php echo $detail['period_end_date']; ?>" />
                                                                <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_employee_family_id" name="details[<?php echo $grid_row_allowance; ?>][employee_family_id]" value="<?php echo $detail['employee_family_id']; ?>" />
                                                                <input style="width: 200px;" type="text" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_employee_family_name" name="details[<?php echo $grid_row_allowance; ?>][employee_family_name]" value="<?php echo $detail['full_name']; ?>" readonly/>
                                                            </td>
                                                            <td>
                                                                <input type="hidden" id="detail_<?php echo $grid_row_allowance; ?>_special_allowance_category_id" name="details[<?php echo $grid_row_allowance; ?>][special_allowance_category_id]" value="<?php echo $detail['special_allowance_category_id']; ?>" />
                                                                <input style="width: 150px;" type="text" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_special_allowance_category" name="details[<?php echo $grid_row_allowance; ?>][special_allowance_category]" value="<?php echo $detail['special_allowance_category']; ?>" readonly/>
                                                            </td>
                                                            <td><input onchange="calculatePolicyAmount(<?php echo $grid_row_allowance; ?>);" type="text" class="form-control fPDecimal" id="detail_<?php echo $grid_row_allowance; ?>_amount" name="details[<?php echo $grid_row_allowance; ?>][amount]" value="<?php echo $detail['amount']; ?>" /></td>
                                                            <td><input type="text" class="form-control" maxlength="60" id="detail_<?php echo $grid_row_allowance; ?>_remarks" name="details[<?php echo $grid_row_allowance; ?>][remarks]" value="<?php echo $detail['remarks']; ?>" /></td>
                                                            <td><input type="text" class="form-control dtpDate" id="detail_<?php echo $grid_row_allowance; ?>_receipt_date" name="details[<?php echo $grid_row_allowance; ?>][receipt_date]" value="<?php echo $detail['receipt_date']; ?>" /></td>
                                                            <td><input type="text" class="form-control" maxlength="21" id="detail_<?php echo $grid_row_allowance; ?>_receipt_no" name="details[<?php echo $grid_row_allowance; ?>][receipt_no]" value="<?php echo $detail['receipt_no']; ?>" /></td>
                                                            <td>
                                                                <input type="text" class="form-control fPDecimal" maxlength="21" id="detail_<?php echo $grid_row_allowance; ?>_policy_amount" name="details[<?php echo $grid_row_allowance; ?>][policy_amount]" value="<?php echo $detail['policy_amount']; ?>" readonly/>
                                                                <input type="hidden" id="detail_<?php echo $grid_row_allowance; ?>_policy_on" name="details[<?php echo $grid_row_allowance; ?>][policy_on]" value="<?php echo $detail['policy_on']; ?>" />
                                                                <input type="hidden" id="detail_<?php echo $grid_row_allowance; ?>_policy_value" name="details[<?php echo $grid_row_allowance; ?>][policy_value]" value="<?php echo $detail['policy_value']; ?>" />
                                                            </td>
                                                            <td>
                                                                <input onchange="calculateTotal();" type="text" class="form-control fPDecimal" maxlength="21" id="detail_<?php echo $grid_row_allowance; ?>_approved_amount" name="details[<?php echo $grid_row_allowance; ?>][approved_amount]" value="<?php echo $detail['approved_amount']; ?>" />
                                                            </td>
                                                        </tr>
                                                        <?php $grid_row_allowance++; ?>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['total_amount']; ?></label>
                                                    <input type="text" id="total_amount" name="total_amount" value="<?php echo $total_amount ?>" class="form-control fPDecimal" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-sm-9">
                                                <div class="row bg-aqua-gradient">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label>&nbsp;</label>
                                                            <div class="checkbox">
                                                                <label>
                                                                    <input type="checkbox" id="is_taxable" name="is_taxable" value="1" <?php echo ($is_taxable==1?'checked':''); ?> />
                                                                    <?php echo $lang['is_taxable']; ?>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['approved_status']; ?></label>
                                                            <select class="form-control" id="approved_status" name="approved_status">
                                                                <option value="Requested" <?php echo ($approved_status=='Requested'?'selected="true"':''); ?>>Requested</option>
                                                                <option value="Approved" <?php echo ($approved_status=='Approved'?'selected="true"':''); ?>>Approved</option>
                                                                <option value="Rejected" <?php echo ($approved_status=='Rejected'?'selected="true"':''); ?>>Rejected</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['approved_amount']; ?></label>
                                                            <input type="text" readonly id="approved_amount" name="approved_amount" value="<?php echo round($approved_amount) ?>" class="form-control fPDecimal" onchange="validate_total_amount()"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="panel panel-info">
                                            <div class="panel-heading">
                                                <label><?php echo $lang['allowance_policy']; ?></label>
                                            </div>
                                            <div class="panel-body">
                                                <div class="table-responsive">
                                                    <table id="tblPolicyScholarship" class="table table-bordered">
                                                        <thead>
                                                        <tr>
                                                            <th>Relation</th>
                                                            <th>Allowance Category</th>
                                                            <th>Allowance On</th>
                                                            <th>Allowance Value</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php foreach($employee_policies as $policy): ?>
                                                        <tr>
                                                            <td><?php echo $policy['relation']; ?></td>
                                                            <td><?php echo $policy['allowance_category']; ?></td>
                                                            <td><?php echo $policy['allowance_on']; ?></td>
                                                            <td><?php echo $policy['allowance_value']; ?></td>
                                                        </tr>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="panel panel-info" style="<?php if($isEdit != 1) { echo 'display: none;'; } ?>" id="installmentDiv">
                                            <div class="panel-heading">
                                                <label><?php echo $lang['installment']; ?></label>
                                            </div>
                                            <div class="panel-body">
                                                <div class="table-responsive">
                                                    <table id="tblInstallment" class="table table-bordered">
                                                        <thead>
                                                        <tr>
                                                            <th>Date</th>
                                                            <th>Amount <button type="button" class="btn btn-xs btn-info" id="addInstallment" onclick="addRowInstallment();" >+</button></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php foreach($installments as $key => $installment): ?>
                                                        <tr data-row_id="<?php echo $key; ?>">
                                                            <td><input type="text" class="form-control dtpDate" name="installments[<?php echo $key; ?>][installment_date]" id="installment_<?php echo $key; ?>_installment_date" value="<?php echo stdDate($installment['installment_date']); ?>" /></td>
                                                            <td><input onchange="calculateTotalInstallments(this);" type="text" class="form-control" name="installments[<?php echo $key; ?>][installment_amount]" id="installment_<?php echo $key; ?>_installment_amount" value="<?php echo $installment['installment_amount']; ?>" /></td>
                                                        </tr>
                                                        <?php endforeach; ?>
                                                        <?php $grid_row_installments = count($installments); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <?php if($total_paid_amount == 0): ?>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="submitDocument();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <?php endif; ?>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script type="text/javascript" src="../admin/view/js/payroll/special_allowance.js?v=20210708"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);

        var $employees = <?php echo json_encode($employees); ?>;
        var $special_allowance_types = <?php echo json_encode($special_allowance_types); ?>;
        var $policies = <?php echo json_encode($policies); ?>;
        var $families = <?php echo json_encode($employee_families); ?>;
        var $grid_row_allowance = <?php echo $grid_row_allowance; ?>;
        var $URLGetPolicy = '<?php echo $href_get_policy; ?>';
        var $URLGetAllowanceType = '<?php echo $href_get_allowance_type; ?>';
        var $URLGetAllowanceCategory = '<?php echo $href_get_allowance_category; ?>';
        var $grid_row_installments = '<?php echo $grid_row_installments; ?>';
        var $date = '<?php echo $document_date; ?>';
        var isEdit = '<?php echo $isEdit; ?>';

    </script>

    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>