<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <?php if($is_post != 1): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_no']; ?></label>
                                            <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" placeholder="AUTO" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="document_date"><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="document_title"><span class="required">*</span>&nbsp;<?php echo $lang['document_title']; ?></label>
                                            <input type="text" id="document_title" name="document_title" value="<?php echo $document_title; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['enayat_event']; ?></label>
                                            <select required class="form-control" id="enayat_event_id" name="enayat_event_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($events as $event): ?>
                                                <option <?php echo ($enayat_event_id==$event['enayat_event_id']?'selected="true"':''); ?> value="<?php echo $event['enayat_event_id']; ?>"><?php echo $event['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="enayat_event_id" class="error" style="display: none;"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="panel panel-default">
                                            <div class="panel-heading">
                                                <div class="row">
                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label for="department_id"><?php echo $lang['department']; ?></label>
                                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                                <?php foreach($departments as $department): ?>
                                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label for="employee_registration_id"><span class="required">*</span>&nbsp;<?php echo $lang['employee']; ?></label>
                                                            <select class="form-control" id="employee_registration_id" name="employee_registration_id[]" multiple>
                                                                <?php foreach($employees as $employee): ?>
                                                                <option value="<?php echo $employee['employee_registration_id']; ?>"><?php echo $employee['registration_code'].' - '.$employee['employee_name']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['amount']; ?></label>
                                                            <input type="text" id="master_amount" name="master_amount" value="<?php echo $master_amount; ?>" class="form-control text-right"/>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label>&nbsp;</label>
                                                            <button type="button" class="form-control btn-primary" id="btnSearch"><i class="fa fa-plus"></i> Add Employees</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="panel-body">
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <div class="table-responsive">
                                                            <table id="tblSpecialEnayat" class="table table-striped">
                                                                <thead>
                                                                <tr>
                                                                    <th>&nbsp;</th>
                                                                    <th style="text-align: center;"><?php echo $lang['employee']; ?></th>
                                                                    <th style="text-align: center;"><?php echo $lang['amount']; ?></th>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                <?php $grid_row=0;?>
                                                                <?php foreach($special_enayat_details as $detail): ?>
                                                                <?php if($detail['isPost']==1): ?>
                                                                <tr id="grid_row_<?php echo $grid_row; ?>" data-row_id="<?php echo $grid_row; ?>">
                                                                    <td>&nbsp;</td>
                                                                    <td>
                                                                        <input readonly type="hidden" class="form-control" name="employees[<?php echo $grid_row; ?>][special_enayat_detail_id]" value="<?php echo $detail['special_enayat_detail_id']; ?>"/>
                                                                        <input readonly type="hidden" class="form-control" name="employees[<?php echo $grid_row; ?>][employee_id]" value="<?php echo $detail['employee_id']; ?>"/>
                                                                        <input readonly type="hidden" class="form-control" name="employees[<?php echo $grid_row; ?>][employee_registration_id]" value="<?php echo $detail['employee_registration_id']; ?>"/>
                                                                        <input readonly type="text" class="form-control" name="employees[<?php echo $grid_row; ?>][employee_name]" value="<?php echo $detail['full_name']; ?>"/>
                                                                    </td>
                                                                    <td>
                                                                        <input readonly type="text" class="form-control text-right amount" name="employees[<?php echo $grid_row; ?>][amount]" id="amount_<?php echo $grid_row; ?>" value="<?php echo $detail['amount']; ?>"/>
                                                                    </td>
                                                                </tr>
                                                                <?php else: ?>
                                                                <tr id="grid_row_<?php echo $grid_row; ?>" data-row_id="<?php echo $grid_row; ?>">
                                                                    <td><button type="button" class="btn btn-danger btn-xs" onclick="removeRow(<?php echo $grid_row; ?>);"><i class="fa fa-times"></i></button></td>
                                                                    <td>
                                                                        <input readonly type="hidden" class="form-control" name="employees[<?php echo $grid_row; ?>][special_enayat_detail_id]" value="<?php echo $detail['special_enayat_detail_id']; ?>"/>
                                                                        <input readonly type="hidden" class="form-control" name="employees[<?php echo $grid_row; ?>][employee_id]" value="<?php echo $detail['employee_id']; ?>"/>
                                                                        <input readonly type="hidden" class="form-control" name="employees[<?php echo $grid_row; ?>][employee_registration_id]" value="<?php echo $detail['employee_registration_id']; ?>"/>
                                                                        <input readonly type="text" class="form-control" name="employees[<?php echo $grid_row; ?>][employee_name]" value="<?php echo $detail['full_name']; ?>"/>
                                                                    </td>
                                                                    <td>
                                                                        <input onchange="calcTotal();" type="text" class="form-control text-right amount" name="employees[<?php echo $grid_row; ?>][amount]" id="amount_<?php echo $grid_row; ?>" value="<?php echo $detail['amount']; ?>"/>
                                                                    </td>
                                                                </tr>
                                                                <?php endif; ?>
                                                                <?php $grid_row++; ?>
                                                                <?php endforeach; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-offset-6 col-sm-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['total_employee']; ?></label>
                                                            <input type="text" class="form-control text-right" id="total_employee" name="total_employee" value="<?php echo $total_employee; ?>" readonly/>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['total_amount']; ?></label>
                                                            <input type="text" class="form-control text-right" id="total_amount" name="total_amount" value="<?php echo $total_amount; ?>" readonly/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/special_enayat.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $grid_row = <?php echo $grid_row; ?>;
        var $URLGetEmployees = '<?php echo $href_get_employees; ?>';
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>