<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_download_excel; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group PDate" style="display: none;">
                                            <label><?php echo $lang['from_document_date']; ?></label>
                                            <input required type="text" class="form-control dtpDate" id="from_document_date" name="from_document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                        <div class="form-group PDate" style="display: none;">
                                            <label><?php echo $lang['to_document_date']; ?></label>
                                            <input required type="text" class="form-control dtpDate" id="to_document_date" name="to_document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['employee']; ?></label>
                                            <select class="form-control" id="employee_registration_id" name="employee_registration_id" >
                                                <option></option>
                                                <?php foreach($employees as $employee): ?>
                                                <option value="<?php echo $employee['employee_registration_id']; ?>"><?php echo $employee['employee_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="employee_registration_id" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <option></option>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="department_id" style="display: none;"></label>
                                        </div>
                                        <div class="form-group">
                                            <div class="radio">
                                                <label>
                                                    <input type="radio" name="reportType" id="reportTypeYearlySummary" value="YearlySummary" checked>
                                                    <?php echo $lang['yearly_summary']; ?>
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label>
                                                    <input type="radio" name="reportType" id="reportTypeSummary" value="Summary">
                                                    <?php echo $lang['summary']; ?>
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label>
                                                    <input type="radio" name="reportType" id="reportTypeDetail" value="Detail">
                                                    <?php echo $lang['detail']; ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnPrint" class="btn btn-info form-control" type="button" onclick="printReport();">
                                                <i class="fa fa-print"></i>
                                                &nbsp;<?php echo $lang['print']; ?>
                                            </button>
                                        </div>
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnExcel" class="btn btn-info form-control" type="button" onclick="excelReport();">
                                                <i class="fa fa-cloud-download"></i>
                                                &nbsp;<?php echo $lang['excel']; ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script type="text/javascript" src="../admin/view/js/report/withholding_statement.js"></script>
    <script type="text/javascript">
        var $URLPrintReport = '<?php echo $href_print_report; ?>';
        var $URLExcelReport = '<?php echo $href_excel_report; ?>';

        function printReport() {
            $('#form').attr('action',$URLPrintReport).submit();
        }

        function excelReport() {
            $('#form').attr('action',$URLExcelReport).submit();
        }

        $('input[name="reportType"]').on('change', function() {
            var $val = $(this).val();

            if($val == 'YearlySummary') {
                $('.PDate').hide('slow');
            } else {
                $('.PDate').show('slow');
            }
            console.log($val);
        });


        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>