<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_print_report; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>Company</label>
                                            <select class="form-control" id="company_id" name="company_id">
                                                <option>&nbsp;</option>
                                                <?php foreach($companies as $company): ?>
                                                <option value="<?php echo $company['company_id']; ?>" <?php echo ($company_id==$company['company_id']?'selected':'')?>><?php echo $company['company_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id">
                                                <option>&nbsp;</option>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>Joining From Dt.</label>
                                            <input type="text" class="form-control dtpDate" id="from_joining_date" name="from_joining_date" />
                                        </div>
                                        <div class="form-group">
                                            <label>Joining To Dt.</label>
                                            <input type="text" class="form-control dtpDate" id="to_joining_date" name="to_joining_date" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>Leave From Dt.</label>
                                            <input type="text" class="form-control dtpDate" id="from_leaving_date" name="from_leaving_date" />
                                        </div>
                                        <div class="form-group">
                                            <label>Leave To Dt.</label>
                                            <input type="text" class="form-control dtpDate" id="to_leaving_date" name="to_leaving_date" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['status']; ?></label>
                                            <select class="form-control" id="status_id" name="status_id">
                                                <option value="Active">Active</option>
                                                <option value="Inactive">Inactive</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['eobi']; ?></label>
                                            <select class="form-control" id="eobi_status" name="eobi_status">
                                                <option value="Any">Any</option>
                                                <option value="Registered">Registered</option>
                                                <option value="Not-Registered">Not-Registered</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                    <div class="row">
                                        <div class="col-sm-3">
                                            <div id="_available_column" class="panel panel-default">
                                                <div class="panel-heading">
                                                    <label class="panel-title">Available Column</label>
                                                </div>
                                                <div class="panel-body list-group" style="height: 200px; overflow-y: auto;">
                                                    <?php foreach($columns as $column): ?>
                                                    <a class="list-group-item" data-column_name="<?php echo $column['column_name']; ?>" data-display_name="<?php echo $column['display_name']; ?>" data-column_ratio="<?php echo $column['column_ratio']; ?>" href="javascript:void(0);">
                                                    <span onclick="fnAddToList(this);" class="badge bg-yellow"><i class="fa fa-arrow-right"></i></span>
                                                    <p class="list-group-item-text"><?php echo $column['display_name']; ?></p>
                                                </a>
                                                <?php endforeach; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div id="_display_column" class="panel panel-default">
                                                <div class="panel-heading">
                                                    <label class="panel-title">Display Column</label>
                                                </div>
                                                <div class="panel-body list-group" style="height: 200px; overflow-y: auto;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group">
                                                <label><?php echo $lang['page_size']; ?></label>
                                                <select id="page_size" name="page_size" class="form-control">
                                                    <option value="A4">A4</option>
                                                    <option value="A3">A3</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label><?php echo $lang['page_orientation']; ?></label>
                                                <select id="page_orientation" name="page_orientation" class="form-control">
                                                    <option value="P">Portrait</option>
                                                    <option value="L">Landscape</option>
                                                </select>
                                            </div>
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnPDF" class="btn btn-info form-control" type="button">
                                                <i class="fa fa-print"></i>
                                                &nbsp;<?php echo $lang['print']; ?>
                                            </button>
                                            <button id="btnExcel" class="btn btn-success form-control" type="button">
                                                <i class="fa fa-print"></i>
                                                &nbsp;<?php echo $lang['excel']; ?>
                                            </button>
                                        </div>
                                    </div>    
                                    </div>
                            </form>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="table-responsive">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/report/employee_data.js"></script>
    <script type="text/javascript">
        var $URLGetDepartments = '<?php echo $href_get_departments; ?>';
        var $URLGetReport = '<?php echo $href_get_report; ?>';
        var $URLPrintReport = '<?php echo $href_print_report; ?>';
        var $URLPrintExcel = '<?php echo $href_print_excel; ?>';
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>