<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="panel panel-default">
                                            <div class="panel-body" style="background-color: #A9B6BC">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['company']; ?></label>
                                                            <select id="company_id" name="company_id[]" class="form-control" multiple>
                                                                <?php foreach($companies as $company): ?>
                                                                <option value="<?php echo $company['company_id']; ?>"><?php echo $company['company_name']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['department']; ?></label>
                                                            <select id="department_id" name="department_id[]" class="form-control" multiple>
                                                                <?php foreach($departments as $department): ?>
                                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['designation']; ?></label>
                                                            <select id="designation_id" name="designation_id[]" class="form-control" multiple>
                                                                <?php foreach($designations as $designation): ?>
                                                                <option value="<?php echo $designation['designation_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['slary_bank']; ?></label>
                                                            <select id="bank_id" name="bank_id[]" class="form-control" multiple>
                                                                <?php foreach($banks as $bank): ?>
                                                                <option value="<?php echo $bank['bank_id']; ?>"><?php echo $bank['bank_name']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['joining_date']; ?></label>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <label><?php echo $lang['from']; ?></label>
                                                                    <input type="text" class="form-control" id="joining_from_date" name="joining_from_date" value="" />
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <label><?php echo $lang['to']; ?></label>
                                                                    <input type="text" class="form-control" id="joining_to_date" name="joining_to_date" value="" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['leaving_date']; ?></label>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <label><?php echo $lang['from']; ?></label>
                                                                    <input type="text" class="form-control" id="leaving_from_date" name="leaving_from_date" value="" />
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <label><?php echo $lang['to']; ?></label>
                                                                    <input type="text" class="form-control" id="leaving_to_date" name="leaving_to_date" value="" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['class']; ?></label>
                                                            <select id="class_id" name="class_id[]" class="form-control" multiple>
                                                                <?php foreach($classes as $class): ?>
                                                                <option value="<?php echo $class['class_id']; ?>"><?php echo $class['class_name']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['section']; ?></label>
                                                            <select id="section_id" name="section_id[]" class="form-control" multiple>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['madrassa_going']; ?></label>
                                                            <select id="madrassa_going" name="madrassa_going" class="form-control">
                                                                <option value="">ALL</option>
                                                                <option value="-Not Defined-">-Not Defined-</option>
                                                                <option value="Yes">Yes</option>
                                                                <option value="No">No</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['madrassa_name']; ?></label>
                                                            <select id="madrassa_id" name="madrassa_id[]" class="form-control" multiple>
                                                                <?php foreach($madrassas as $madrassa): ?>
                                                                <option value="<?php echo $madrassa['madrassa_id']; ?>"><?php echo $madrassa['madrassa_name']; ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['status']; ?></label>
                                                            <select id="status" name="status" class="form-control">
                                                                <option value="">ALL</option>
                                                                <option value="Active">Active</option>
                                                                <option value="Inactive">Inactive</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['finance_support']; ?></label>
                                                            <select id="finance_support" name="finance_support[]" class="form-control" multiple>
                                                                <option value="New FA">New FA</option>
                                                                <option value="Old FA">Old FA</option>
                                                                <option value="Inactive">Inactive</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="panel-body">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div id="_available_column" class="panel panel-default">
                                                            <div class="panel-heading">
                                                                <label class="panel-title"><?php echo $lang['available_column']; ?></label>
                                                            </div>
                                                            <div class="panel-body list-group" style="height: 350px; overflow-y: auto;">
                                                                <?php foreach($columns as $column): ?>
                                                                <a class="list-group-item" data-column_name="<?php echo $column['column_name']; ?>" data-display_name="<?php echo $column['display_name']; ?>" data-column_ratio="<?php echo $column['column_ratio']; ?>" href="javascript:void(0);">
                                                                    <span onclick="fnAddToList(this);" class="badge bg-yellow"><i class="fa fa-arrow-right"></i></span>
                                                                    <p class="list-group-item-text"><?php echo $column['display_name']; ?></p>
                                                                </a>
                                                                <?php endforeach; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div id="_display_column" class="panel panel-default">
                                                            <div class="panel-heading">
                                                                <label class="panel-title"><?php echo $lang['display_column']; ?></label>
                                                                <button type="button" onclick="$(this).parent().siblings('.panel-body').html('');" class="btn btn-info btn-xs pull-right"><i class="fa fa-refresh"></i></button>
                                                            </div>
                                                            <div class="panel-body list-group" style="height: 350px; overflow-y: auto;"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['report_title']; ?></label>
                                                            <input type="text" id="report_title" name="report_title" class="form-control" />
                                                        </div>
                                                        <div class="checkbox">
                                                            <label><input type="checkbox" id="show_empty" name="show_empty" value="1" />&nbsp;&nbsp;<?php echo $lang['show_empty']; ?></label>
                                                        </div>
                                                        <div class="form-group">
                                                            <label><?php echo $lang['page_size']; ?></label>
                                                            <select id="page_size" name="page_size" class="form-control">
                                                                <option value="A4">A4</option>
                                                                <option value="A3">A3</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label><?php echo $lang['page_orientation']; ?></label>
                                                            <select id="page_orientation" name="page_orientation" class="form-control">
                                                                <option value="P">Portrait</option>
                                                                <option value="L">Landscape</option>
                                                            </select>
                                                        </div>
                                                        <div id="_load_report" class="panel panel-default">
                                                            <div class="panel-heading">
                                                                <label class="panel-title"><?php echo $lang['load_report']; ?></label>
                                                            </div>
                                                            <div class="panel-body list-group" style="height: 114px; overflow-y: auto;">
                                                                <?php foreach($reports as $report): ?>
                                                                <a class="list-group-item" data-report_criteria_id="<?php echo $report['report_criteria_id']; ?>" data-report_id="<?php echo $report['report_id']; ?>" href="javascript:void(0);">
                                                                    <button onclick="removeReport(this)" class="btn btn-danger btn-xs pull-right">
                                                                        <i class="fa fa-remove"></i>
                                                                    </button>
                                                                    <p class="list-group-item-text"><?php echo $report['report_title']; ?></p>
                                                                </a>
                                                                <?php endforeach; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <button id="btnPDF" type="button" class="btn btn-default form-control">PDF</button>
                                                        </div>
                                                        <div class="form-group">
                                                            <button id="btnExcel" type="button" class="btn btn-default form-control">Excel</button>
                                                        </div>
                                                        <div class="form-group">
                                                            <button id="btnSave" type="button" class="btn btn-info form-control">Save Report</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="table-responsive">
                                        <table id="tblReport" class="table table-striped table-bordered">
                                            <thead class="th-color">
                                            <tr>
                                                <th class="text-center">Sr.</th>
                                                <th class="text-center"><?php echo $lang['employee_code']; ?></th>
                                                <th class="text-center"><?php echo $lang['registration_code']; ?></th>
                                                <th class="text-center"><?php echo $lang['employee_name']; ?></th>
                                                <th class="text-center"><?php echo $lang['joining_date']; ?></th>
                                                <th class="text-center"><?php echo $lang['eobi_no']; ?></th>
                                                <th class="text-center"><?php echo $lang['eobi_date']; ?></th>
                                                <th class="text-center"><?php echo $lang['cnic_no']; ?></th>
                                                <th class="text-center"><?php echo $lang['dob']; ?></th>
                                                <th class="text-center"><?php echo $lang['gross_salary']; ?></th>
                                                <th class="text-center"><?php echo $lang['gross_with_allowance']; ?></th>
                                                <th class="text-center"><?php echo $lang['eobi_deduction']; ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="view/js/report/student_data.js"></script>
    <script type="text/javascript" src="../assets/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);
        var $UrlGetSection = '<?php echo $href_get_section; ?>';

        var $UrlFilterReport = '<?php echo $action_filter_student_data; ?>';
        var $UrlPdfReport = '<?php echo $action_pdf_student_data; ?>';
        var $UrlExcelReport = '<?php echo $action_excel_student_data; ?>';

        var $UrlSaveReport = '<?php echo $action_save_student_data; ?>';
        var $UrlRemoveReport = '<?php echo $action_remove_student_data; ?>';
        var $UrlLoadReport = '<?php echo $action_load_student_data; ?>';
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>