<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_print_report; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="report_type">Report Type</label>
                                            <select class="form-control" id="report_type" name="report_type">
                                                <option value="eobi_statement">EOBI Statement</option>
                                                <option value="full_employee">Full Employee</option>
                                                <option value="active_employee">Active Employee</option>
                                                <option value="inactive_employee">Inactive Employee</option>
                                                <option value="eobi_deducted">EOBI Deducted</option>
                                                <option value="eobi_not_deducted">EOBI Not Deducted</option>
                                                <option value="eobi_no_salary">EOBI No Salary</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="department_id">Department</label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department_id; ?>"><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" class="form-control btn btn-primary" id="btnPrint">Print</button>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" class="form-control btn btn-success" id="btnExcel">Excel</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row" id="divDates" style="display: none;">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>From Date</label>
                                            <input required type="text" class="form-control dtpDate" id="from_date" name="from_date" value="" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>To Date</label>
                                            <input required type="text" class="form-control dtpDate" id="to_date" name="to_date" value="" />
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script type="text/javascript" src="../admin/view/js/report/eobi.js"></script>
    <script type="text/javascript">
        var $URLReportFullEmployee = '<?php echo $href_full_employee; ?>';
        var $URLReportActiveEmployee = '<?php echo $href_active_employee; ?>';
        var $URLReportInactiveEmployee = '<?php echo $href_inactive_employee; ?>';
        var $URLReportEOBIDeducted = '<?php echo $href_eobi_deducted; ?>';
        var $URLReportEOBINotDeducted = '<?php echo $href_eobi_not_deducted; ?>';
        var $URLReportEOBIStatement = '<?php echo $href_eobi_statement; ?>';
        var $URLReportEOBINoSalary = '<?php echo $href_eobi_no_salary; ?>';

        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>