<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_print_report; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><input type="radio" id="select_employee" name="select" value="employee_code" checked />&nbsp;<?php echo $lang['employee_code']; ?></label>
                                            <input type="text" id="employee_code" name="employee_code" class="form-control" />
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><input type="radio" id="select_registration" name="select" value="registration_code" />&nbsp;<?php echo $lang['registration_code']; ?></label>
                                            <input type="text" id="registration_code" name="registration_code" class="form-control" readonly />
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><input type="radio" id="select_department" name="select" value="department_id" />&nbsp;<?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple disabled>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['hijri_period']; ?></label>
                                            <input type="text" class="form-control" id="hijri_period" name="hijri_period" value=""/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['issue_date']; ?></label>
                                            <input type="text" class="form-control dtpDate" id="issue_date" name="issue_date" value="<?php echo stdDate(); ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><?php echo $lang['name']; ?></label>
                                            <input type="text" class="form-control" id="name" name="name" value=""/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['designation']; ?></label>
                                            <input type="text" class="form-control" id="designation" name="designation"/>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?php echo $lang[report_type]; ?></label>
                                            <select class="form-control" name="report_type" id="report_type" >
                                                <option value="with_tax"><?php echo $lang[with_tax]; ?></option>
                                                <option value="without_tax"><?php echo $lang[without_tax]; ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <a class="btn btn-info form-control" href="javascript:void(0);" onclick="generateCertificate();">
                                                <i class="fa fa-print"></i> Generate Certificate
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <a class="btn btn-info form-control" href="javascript:void(0);" onclick="printReport();">
                                                <i class="fa fa-print"></i> Print Certificate
                                            </a>
                                        </div>
                                    </div>
                                    <!--
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <a class="btn btn-info form-control" href="javascript:void(0);" onclick="printDetailReport();">
                                                <i class="fa fa-print"></i>
                                                &nbsp;<?php echo $lang['print_report']; ?>
                                            </a>
                                        </div>
                                    </div>
                                    -->
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        var $URLGenerateCertificate = '<?php echo $href_generate_certificate; ?>';
        var $URLPrintReport = '<?php echo $href_print_report; ?>';
        var $URLPrintDetailReport = '<?php echo $href_print_detail_report; ?>';

        $(document).on('click','#select_employee,#select_registration,#select_department', function() {
            var $val = $('input[name="select"]:checked').val();
            if($val=='employee_code') {
                $("#department_id").val(null).trigger('change');
                $('#registration_code').prop('readonly',true);
                $('#department_id').prop('disabled',true);
                $('#employee_code').prop('readonly',false);
            } else if($val=='registration_code') {
                $("#department_id").val(null).trigger('change');
                $('#employee_code').prop('readonly',true);
                $('#department_id').prop('disabled',true);
                $('#registration_code').prop('readonly',false);
            } else {
                $('#employee_code').prop('readonly',true);
                $('#registration_code').prop('readonly',true);
                $('#department_id').prop('disabled',false);

            }
            console.log($val);
        });

        function generateCertificate() {
            var $filter_type = $('input[name="select"]:checked').val();
            var $employee_code = $('#employee_code').val();
            var $registration_code = $('#registration_code').val();
            var $department_id = $('#department_id').val();
            var $hijri_period = $('#hijri_period').val();
            var $issue_date = $('#issue_date').val();
            var $name = $('#name').val();
            var $designation = $('#designation').val();
            var $report_type = $('#report_type').val();

            if($('#'+$filter_type).val()=='' || $('#'+$filter_type).val()==null) {
                alert($filter_type + ' is required');
                return;
            }

            if($hijri_period=='') {
                alert('Hijri Period is required');
                return;
            }

            if($issue_date=='') {
                alert('Issue Date Period is required');
                return;
            }

            if($name=='') {
                alert('Issuer Name is required');
                return;
            }

            if($designation=='') {
                alert('Issuer Designation is required');
                return;
            }
            var $bootbox = bootbox.dialog({
                message: '<div class="text-center"><i class="fa fa-spin fa-spinner"></i> More data may take more time. Please wait....</div>',
                closeButton: false,
                onEscape: false,
                backdrop: true
            });

            var $data = $('#form').serialize();
            $.ajax({
                url: $URLGenerateCertificate,
                dataType: 'json',
                type: 'post',
                data: $data,
                mimeType:"multipart/form-data",
                beforeSend: function() {
                },
                complete: function() {
                    bootbox.hideAll();
                },
                success: function(json) {
                    if(json.success) {
                        alert(json.message);
                    } else {
                        console.log(json);
                        alert(json.error);
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    console.log(xhr.responseText);
                }
            })
            //$('#form').attr('action', $URLGenerateCertificate).submit();
        }

        function printDetailReport() {
            $('#form').attr('action', $URLPrintDetailReport).submit();
        }

        function printReport() {
            $('#form').attr('action', $URLPrintReport).submit();
        }
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>