<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-6">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_excel_report; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <div class="form-group">
                                            <label><?php echo $lang['company']; ?></label>
                                            <select class="form-control" id="company_id" name="company_id[]" multiple>
                                                <option value="">&nbsp;</option>
                                                <?php foreach($companies as $company): ?>
                                                <option value="<?php echo $company['company_id']; ?>"><?php echo $company['company_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <option value="">&nbsp;</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['employee_status']; ?></label>
                                            <select class="form-control" id="employee_status" name="employee_status">
                                                <option value="">&nbsp;</option>
                                                <option value="Active">Active</option>
                                                <option value="InActive">InActive</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['employee']; ?></label>
                                            <select class="form-control" id="employee_id" name="employee_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($employees as $employee): ?>
                                                <option value="<?php echo $employee['employee_id']; ?>"><?php echo $employee['employee_code'].'-'.$employee['employee_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['no_of_increments']; ?></label>
                                            <input type="text" class="form-control" id="no_of_increments" name="no_of_increments" value="" />
                                        </div>
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnExcel" class="btn btn-success form-control" type="submit">
                                                <i class="fa fa-file-excel-o"></i> Excel
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                    </div>
                </div>
            </div>
        </section>
        <script type="text/javascript">
            $(document).on('change','#company_id', function() {
                var $URLGetDepartment = '<?php echo $href_get_department; ?>';
                var $company_id = $('#company_id').val();

                $.ajax({
                    url: $URLGetDepartment,
                    dataType: 'json',
                    type: 'post',
                    data: 'company_id='+$company_id,
                    mimeType:"multipart/form-data",
                    beforeSend: function() {
                        $('#department_id').before('<span id="loader" class="pull-right"><i class="fa fa-spin fa-refresh"></i></span>')
                    },
                    complete: function() {
                        $('#loader').remove();
                    },
                    success: function(json) {
                        if(json.success)
                        {
                            var $html = '';
                            var $data = json.data;
                            for(var company_name in $data) {
                                $html += ' <optgroup label="'+company_name+'">';
                                for (var index in $data[company_name]) {
                                    var department = $data[company_name][index];
                                    $html += '<option value="'+department['department_id']+'">'+department['department_name']+'</option>';
                                }
                                $html += ' </optgroup>';
                            }

                            $('#department_id').html($html).trigger('change');
                        } else {
                            alert(json.error);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        console.log(xhr.responseText);
                    }
                })
            });

            $(document).on('click','#btnExcel',function() {
                $('#form').submit();
            })
        </script>
    </div>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>