<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_print_report; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['from_document_date']; ?></label>
                                            <input type="text" class="form-control dtpDate" id="from_document_date" name="from_document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['to_document_date']; ?></label>
                                            <input type="text" class="form-control dtpDate" id="to_document_date" name="to_document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div id="_available_column" class="panel panel-default">
                                            <div class="panel-heading">
                                                <label class="panel-title">Available Column</label>
                                            </div>
                                            <div class="panel-body list-group" style="height: 200px; overflow-y: auto;">
                                                <?php foreach($deductions as $deduction): ?>
                                                <a class="list-group-item" data-deduction_id="<?php echo $deduction['deduction_id']; ?>" data-deduction_code="<?php echo $deduction['deduction_code']; ?>" data-deduction_name="<?php echo $deduction['deduction_name']; ?>" href="javascript:void(0);">
                                                    <span onclick="fnAddToList(this);" class="badge bg-yellow"><i class="fa fa-arrow-right"></i></span>
                                                    <p class="list-group-item-text"><?php echo $deduction['deduction_name']; ?></p>
                                                </a>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div id="_display_column" class="panel panel-default">
                                            <div class="panel-heading">
                                                <label class="panel-title">Display Column</label>
                                            </div>
                                            <div class="panel-body list-group" style="height: 200px; overflow-y: auto;">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>Sub Title</label>
                                            <input type="text" class="form-control" id="subtitle" name="subtitle" value="" />
                                        </div>
                                        <!--
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnFilter" class="btn btn-info form-control" type="button">
                                                <i class="fa fa-search"></i>
                                                &nbsp;<?php echo $lang['search']; ?>
                                            </button>
                                        </div>
                                        -->
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnPrint" class="btn btn-info form-control" type="submit">
                                                <i class="fa fa-print"></i>
                                                &nbsp;<?php echo $lang['print']; ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="table-responsive">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/report/saving_statement.js"></script>
    <script type="text/javascript">
        var $URLGetReport = '<?php echo $href_get_report; ?>';
        var $URLPrintReport = '<?php echo $href_print_report; ?>';
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>