<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_print_report; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['from_transaction_date']; ?></label>
                                            <input type="text" class="form-control dtpDate" id="from_transaction_date" name="from_transaction_date" value="" autocomplete="off"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['to_transaction_date']; ?></label>
                                            <input type="text" class="form-control dtpDate" id="to_transaction_date" name="to_transaction_date" value=""  autocomplete="off"/>
                                        </div>
                                    </div>
                                    <!--<div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <option value="">&nbsp;</option>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>-->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><?php echo $lang['company']; ?></label>
                                            <select class="form-control" id="company_id" name="company_id[]" multiple>
                                                <option value="">&nbsp;</option>
                                                <?php foreach($companys as $company): ?>
                                                <option value="<?php echo $company['company_id']; ?>"><?php echo $company['company_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnFilter" class="btn btn-info form-control" type="button">
                                                <i class="fa fa-search"></i>
                                                &nbsp;<?php echo $lang['search']; ?>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 hide">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnPrint" class="btn btn-info form-control" type="submit">
                                                <i class="fa fa-print"></i>
                                                &nbsp;<?php echo $lang['print']; ?>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button id="btnExcel" class="btn btn-info form-control" type="button">
                                                <i class="fa fa-download"></i>
                                                &nbsp;<?php echo $lang['excel']; ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="table-responsive">
                                        <!--<table id="tblReport" class="table table-striped table-bordered">
                                            <thead class="th-color">
                                            <tr>
                                                <th class="center">Sr.</th>
                                                <th class="center"><?php echo $lang['ntn']; ?></th>
                                                <th class="center"><?php echo $lang['cnic']; ?></th>
                                                <th class="center"><?php echo $lang['employee_code']; ?></th>
                                                <th class="center"><?php echo $lang['employee_name']; ?></th>
                                                <th class="center"><?php echo $lang['city']; ?></th>
                                                <th class="center"><?php echo $lang['address']; ?></th>
                                                <th class="center"><?php echo $lang['gross']; ?></th>
                                                <th class="center"><?php echo $lang['tax']; ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>-->
                                        <table id="tblReport" class="table table-striped table-bordered">
                                            <thead class="th-color">
                                            <tr>
                                                <th class="center">Sr.</th>
                                                <th class="center"><?php echo $lang['company']; ?></th>
                                                <th class="center"><?php echo $lang['ntn']; ?></th>
                                                <th class="center"><?php echo $lang['cnic']; ?></th>
                                                <th class="center"><?php echo $lang['email']; ?></th>
                                                <th class="center"><?php echo $lang['employee_code']; ?></th>
                                                <th class="center"><?php echo $lang['reg_no']; ?></th>
                                                <th class="center"><?php echo $lang['employee_name']; ?></th>
                                                <th class="center"><?php echo $lang['department']; ?></th>
                                                <th class="center"><?php echo $lang['gross_amount']; ?></th>
                                                <th class="center"><?php echo $lang['taxable_amount']; ?></th>
                                                <th class="center"><?php echo $lang['itax_deducted']; ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/report/tax_deduction.js"></script>
    <script type="text/javascript">
        var $URLGetReport = '<?php echo $href_get_report; ?>';
        var $URLPrintReport = '<?php echo $href_print_report; ?>';
        var $URLExcelReport = '<?php echo $href_excel_report; ?>';
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>