<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_download_excel; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><?php echo $lang['company']; ?></label>
                                            <?php if(count($companies)==1): ?>
                                            <input type="hidden" id="company_id" name="company_id[]" value="<?php echo $companies[0]['company_id']; ?>" />
                                            <input type="text" id="company_name" name="company_name" value="<?php echo $companies[0]['company_name']; ?>" readonly />
                                            <?php else: ?>
                                            <select class="form-control" id="company_id" name="company_id[]" multiple size="5">
                                                <?php foreach($companies as $company): ?>
                                                <option value="<?php echo $company['company_id']; ?>"><?php echo $company['company_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <?php endif; ?>
                                            <label class="error" for="company_id" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><?php echo $lang['from_document_date']; ?></label>
                                            <input type="text" class="form-control dtpDate" id="from_document_date" name="from_document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><?php echo $lang['to_document_date']; ?></label>
                                            <input type="text" class="form-control dtpDate" id="to_document_date" name="to_document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <button id="btnFilter" class="btn btn-info form-control" type="button">
                                                <i class="fa fa-search"></i>
                                                &nbsp;<?php echo $lang['search']; ?>
                                            </button>
                                        </div>
                                        <div class="form-group">
                                            <button id="btnPrint" class="btn btn-info form-control" type="submit">
                                                <i class="fa fa-cloud-download"></i>
                                                &nbsp;<?php echo $lang['excel']; ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="table-responsive">
                                        <table id="tblReport" class="table table-striped table-bordered">
                                            <thead class="th-color">
                                            <tr>
                                                <th class="text-center">Sr.</th>
                                                <th class="text-center"><?php echo $lang['registration_no']; ?></th>
                                                <th class="text-center"><?php echo $lang['identification_no']; ?></th>
                                                <th class="text-center"><?php echo $lang['name']; ?></th>
                                                <th class="text-center"><?php echo $lang['transaction_date']; ?></th>
                                                <th class="text-center"><?php echo $lang['code']; ?></th>
                                                <th class="text-center"><?php echo $lang['amount']; ?></th>
                                                <th class="text-center"><?php echo $lang['exemption_code']; ?></th>
                                                <th class="text-center"><?php echo $lang['tax_amount']; ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script type="text/javascript" src="../admin/view/js/report/withholding_statement.js"></script>
    <script type="text/javascript">
        var $URLGetReport = '<?php echo $href_get_report; ?>';
        var $URLPrintReport = '<?php echo $href_print_report; ?>';

        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>