<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['shift_title']; ?></label>
                                            <input type="text" id="shift_title" name="shift_title" value="<?php echo $shift_title; ?>" class="form-control"/>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['late_deduction']; ?></label>
                                            <input type="text" id="late_deduction" name="late_deduction" value="<?php echo $late_deduction; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th class="text-center"><?php echo $lang['day']; ?></th>
                                                    <th class="text-center"><?php echo $lang['day_status']; ?></th>
                                                    <th class="text-center"><?php echo $lang['from_time']; ?></th>
                                                    <th class="text-center"><?php echo $lang['to_time']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($shift_details as $row_no => $detail): ?>
                                                <tr>
                                                    <td><input type="text" class="form-control" id="shift_detail_<?php echo $row_no ?>_day" name="shift_details[<?php echo $row_no ?>][day]" value="<?php echo $detail['day']; ?>" readonly /></td>
                                                    <td>
                                                        <select class="form-control" id="shift_detail_<?php echo $row_no ?>_day_status" name="shift_details[<?php echo $row_no ?>][day_status]">
                                                            <option value="Working Day" <?php echo ($detail['day_status']=='Working Day'?'selected="true"':''); ?>><?php echo $lang['working_day']; ?></option>
                                                            <option value="Holiday" <?php echo ($detail['day_status']=='Holiday'?'selected="true"':''); ?>><?php echo $lang['holiday']; ?></option>
                                                        </select>
                                                    </td>
                                                    <td><input type="text" class="form-control dtpTime" id="shift_detail_<?php echo $row_no ?>_from_time" name="shift_details[<?php echo $row_no ?>][from_time]" value="<?php echo $detail['from_time']; ?>" /></td>
                                                    <td><input type="text" class="form-control dtpTime" id="shift_detail_<?php echo $row_no ?>_to_time" name="shift_details[<?php echo $row_no ?>][to_time]" value="<?php echo $detail['to_time']; ?>" /></td>
                                                </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>