<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-primary" title="Add New" data-toggle="tooltip" href="<?php echo $action_insert; ?>"><i class="fa fa-plus"></i></a>
                        <button onclick="ConfirmDelete('<?php echo $action_delete; ?>',1)" class="btn btn-danger" title="Delete" data-toggle="tooltip" type="button"><i class="fa fa-trash-o"></i></button>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main content -->
        <section class="content">
        <!-- jPList core js and css  -->
        <link href="plugins/jplist/css/jplist.core.min.css" rel="stylesheet" type="text/css" />
        <script src="plugins/jplist/js/jplist.core.min.js"></script>

        <!-- jPList sort bundle -->
        <script src="plugins/jplist/js/jplist.sort-bundle.min.js"></script>

        <!-- jPList textbox filter control -->
        <script src="plugins/jplist/js/jplist.textbox-filter.min.js"></script>
        <link href="plugins/jplist/css/jplist.textbox-filter.min.css" rel="stylesheet" type="text/css" />

        <!-- jPList pagination bundle -->
        <script src="plugins/jplist/js/jplist.pagination-bundle.min.js"></script>
        <link href="plugins/jplist/css/jplist.pagination-bundle.min.css" rel="stylesheet" type="text/css" />

        <!-- jPList history bundle -->
        <script src="plugins/jplist/js/jplist.history-bundle.min.js"></script>
        <link href="plugins/jplist/css/jplist.history-bundle.min.css" rel="stylesheet" type="text/css" />

        <!-- jPList toggle bundle -->
        <script src="plugins/jplist/js/jplist.filter-toggle-bundle.min.js"></script>
        <link href="plugins/jplist/css/jplist.filter-toggle-bundle.min.css" rel="stylesheet" type="text/css" />

        <!-- jPList start -->
        <script>
            $('document').ready(function(){

                $('#demo').jplist({
                    itemsBox: '.list'
                    ,itemPath: '.list-item'
                    ,panelPath: '.jplist-panel'
                    //,debug: true
                });
            });
        </script>
        <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?></div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?></div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="#" method="post" enctype="multipart/form-data">
                            <!-- demo -->
                            <div id="demo">

                            <!-- panel -->
                            <div class="jplist-panel">

                                <!-- reset button -->
                                <button
                                        type="button"
                                        class="jplist-reset-btn"
                                        data-control-type="reset"
                                        data-control-name="reset"
                                        data-control-action="reset">
                                    Reset  <i class="fa fa-share"></i>
                                </button>
                                <!-- items per page dropdown -->
                                <div
                                        class="jplist-drop-down"
                                        data-control-type="items-per-page-drop-down"
                                        data-control-name="paging"
                                        data-control-action="paging">
                                    <ul>
                                        <li><span data-number="3"> 3 per page </span></li>
                                        <li><span data-number="5"> 5 per page </span></li>
                                        <li><span data-number="10" data-default="true"> 10 per page </span></li>
                                        <li><span data-number="all"> View All </span></li>
                                    </ul>
                                </div>
                                <!-- sort dropdown -->
                                <div
                                        class="jplist-drop-down"
                                        data-control-type="sort-drop-down"
                                        data-control-name="sort"
                                        data-control-action="sort">
                                    <ul>
                                        <li><span data-path="default">Sort by</span></li>
                                        <li><span data-path=".title" data-order="asc" data-type="text">Title A-Z</span></li>
                                        <li><span data-path=".title" data-order="desc" data-type="text">Title Z-A</span></li>
                                        <li><span data-path=".desc" data-order="asc" data-type="text">Description A-Z</span></li>
                                        <li><span data-path=".desc" data-order="desc" data-type="text">Description Z-A</span></li>
                                        <li><span data-path=".like" data-order="asc" data-type="number">Likes asc</span></li>
                                        <li><span data-path=".like" data-order="desc" data-type="number">Likes desc</span></li>
                                    </ul>
                                </div>
                                <!-- text filter by title -->
                                <div class="text-filter-box">
                                    <!--[if lt IE 10]>
                                    <div class="jplist-label">Filter by Title:</div>
                                    <![endif]-->
                                    <input data-path=".title" data-button="#title-search-button" type="text" value="" placeholder="Filter by Title" data-control-type="textbox" data-control-name="title-filter" data-control-action="filter" />
                                    <button type="button" id="title-search-button">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>

                                <!-- text filter by description -->
                                <div class="text-filter-box">

                                    <!--[if lt IE 10]>
                                    <div class="jplist-label">Filter by Description:</div>
                                    <![endif]-->

                                    <input
                                            data-path=".desc"
                                            data-button="#desc-search-button"
                                            type="text"
                                            value=""
                                            placeholder="Filter by Description"
                                            data-control-type="textbox"
                                            data-control-name="desc-filter"
                                            data-control-action="filter"
                                            />

                                    <button
                                            type="button"
                                            id="desc-search-button">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>

                                <!-- checkbox filters -->
                                <div
                                        class="jplist-group"
                                        data-control-type="checkbox-group-filter"
                                        data-control-action="filter"
                                        data-control-name="themes">
                                    <input
                                            data-path=".architecture"
                                            id="architecture"
                                            type="checkbox"
                                            />
                                    <label for="architecture">Architecture</label>
                                    <input
                                            data-path=".christmas"
                                            id="christmas"
                                            type="checkbox"
                                            />
                                    <label for="christmas">Christmas</label>
                                    <input
                                            data-path=".nature"
                                            id="nature"
                                            type="checkbox"
                                            />
                                    <label for="nature">Nature</label>
                                    <input
                                            data-path=".lifestyle"
                                            id="lifestyle"
                                            type="checkbox"
                                            />
                                    <label for="lifestyle">Lifestyle</label>
                                </div>
                                <div
                                        class="jplist-group"
                                        data-control-type="checkbox-group-filter"
                                        data-control-action="filter"
                                        data-control-name="colors">
                                    <input
                                            data-path=".red"
                                            id="red-color"
                                            type="checkbox"
                                            />
                                    <label for="red-color">Red</label>
                                    <input
                                            data-path=".green"
                                            id="green-color"
                                            type="checkbox"
                                            />
                                    <label for="green-color">Green</label>
                                    <input
                                            data-path=".blue"
                                            id="blue-color"
                                            type="checkbox"
                                            />
                                    <label for="blue-color">Blue</label>
                                    <input
                                            data-path=".brown"
                                            id="brown-color"
                                            type="checkbox"
                                            />
                                    <label for="brown-color">Brown</label>

                                </div>
                                <!-- list / grid view -->
                                <div
                                        class="jplist-views"
                                        data-control-type="views"
                                        data-control-name="views"
                                        data-control-action="views"
                                        data-default="jplist-list-view">

                                    <button type="button" class="jplist-view jplist-list-view" data-type="jplist-list-view"></button>
                                    <button type="button" class="jplist-view jplist-grid-view" data-type="jplist-grid-view"></button>
                                </div>

                                <div
                                        class="jplist-label"
                                        data-type="Page {current} of {pages}"
                                        data-control-type="pagination-info"
                                        data-control-name="paging"
                                        data-control-action="paging">
                                </div>

                                <div class="jplist-pagination" data-control-type="pagination" data-control-name="paging" data-control-action="paging">

                                </div>
                                <div class="jplist-hide-preloader jplist-preloader" data-control-type="preloader" data-control-name="preloader" data-control-action="preloader">
                                    <img src="plugins/jplist/img/common/ajax-loader-line.gif" alt="Loading..." title="Loading..." />
                                </div>
                            </div>

                            <div class="list">
                                <div class="list-item">
                                </div>

                                <div class="list-item">
                                </div>
                            </div>

                            <div class="jplist-no-results">
                                <p>No results found</p>
                            </div>

                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<link rel="stylesheet" href="plugins/dataTables/dataTables.bootstrap.css">
<script src="plugins/dataTables/jquery.dataTables.js"></script>
<script src="plugins/dataTables/dataTables.bootstrap.js"></script>
<script type="text/javascript">
    jQuery(document).ready(function(){
        oTable = jQuery('#dataTable').dataTable( {
            "bProcessing": true,
            "bServerSide": true,
            "bFilter": true,
            "bAutoWidth": false,
            "sPaginationType": "full_numbers",
            "sAjaxSource": "<?php echo $action_ajax; ?>"
            ,"aoColumnDefs" : [ {
                'bSortable' : false,
                'aTargets' : [ 0 ]
            }, {
                'bSearchable' : false,
                'aTargets' : [ 0 ]
            } ]
            , "aaSorting": [[ 1, "asc" ]]
        });
    });
</script>
<?php echo $footer; ?>
</body>
</html>