<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="nav-tabs-custom">
                                    <ul class="nav nav-tabs">
                                        <li class="active"><a href="#general_setting" data-toggle="tab">General Setting</a></li>
                                        <li><a href="#policy_setting" data-toggle="tab">Policies</a></li>
                                    </ul>
                                    <div class="tab-content">
                                        <div id="general_setting" class="active tab-pane">
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['company']; ?></label>
                                                        <select class="form-control" id="company_id" name="company_id">
                                                            <?php foreach($companies as $company): ?>
                                                            <option value="<?php echo $company['company_id']; ?>" <?php echo ($company_id==$company['company_id']?'selected="true"':''); ?>><?php echo $company['company_name']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['department_code']; ?></label>
                                                        <input type="text" id="department_code" name="department_code" value="<?php echo $department_code; ?>" class="form-control"/>
                                                    </div>
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['department_name']; ?></label>
                                                        <input type="text" id="department_name" name="department_name" value="<?php echo $department_name; ?>" class="form-control"/>
                                                    </div>
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['address']; ?></label>
                                                        <input type="text" id="address" name="address" value="<?php echo $address; ?>" class="form-control"/>
                                                    </div>
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['phone_no']; ?></label>
                                                        <input type="text" id="phone_no" name="phone_no" value="<?php echo $phone_no; ?>" class="form-control"/>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['party_id']; ?></label>
                                                        <input type="text" id="party_id" name="party_id" value="<?php echo $party_id; ?>" class="form-control"/>
                                                    </div>
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['ah_key']; ?></label>
                                                        <input type="text" id="ah_key" name="ah_key" value="<?php echo $ah_key; ?>" class="form-control"/>
                                                    </div>
                                                    <div class="form-group">
                                                        <label><span class="required">*</span>&nbsp;<?php echo $lang['budget_key']; ?></label>
                                                        <input type="text" id="budget_key" name="budget_key" value="<?php echo $budget_key; ?>" class="form-control"/>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="policy_setting" class="tab-pane">
                                            <div class="row">
                                                <div class="col-sm-2">
                                                    <div class="form-group">
                                                        <?php echo $lang['override_attendance_policy']; ?>
                                                        <input type="checkbox" id="override_attendance_policy" name="override_attendance_policy" value="1" data-toggle="toggle" data-on="Yes" data-off="No" data-width="100%" data-onstyle="success" data-offstyle="danger" <?php echo ($override_attendance_policy=='1'?'checked':'');?>>
                                                    </div>
                                                </div>
                                                <div class="col-sm-2">
                                                    <div class="form-group">
                                                        <?php echo $lang['override_allowance_policy']; ?>
                                                        <input type="checkbox" id="override_allowance_policy" name="override_allowance_policy" value="1" data-toggle="toggle" data-on="Yes" data-off="No" data-width="100%" data-onstyle="success" data-offstyle="danger" <?php echo ($override_allowance_policy=='1'?'checked':'');?>>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div id="panelAttendance" class="panel panel-info">
                                                        <div class="panel-heading">
                                                            Attendance Policy
                                                        </div>
                                                        <div class="panel-body">
                                                            <div class="row">
                                                                <div class="col-sm-2">
                                                                    <div class="form-group">
                                                                        <?php echo $lang['attendance_exempted']; ?>
                                                                        <input type="checkbox" id="attendance_exempted" name="attendance_exempted" value="1" data-toggle="toggle" data-on="Yes" data-off="No" data-width="100%" data-onstyle="success" data-offstyle="danger" <?php echo ($attendance_exempted=='1'?'checked':'');?>>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-2">
                                                                    <div class="form-group">
                                                                        <label><?php echo $lang['deduction_days']; ?></label>
                                                                        <input type="text" class="form-control" name="deduction_days" value="<?php echo $deduction_days; ?>" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-2">
                                                                    <div class="form-group">
                                                                        <label><?php echo $lang['deduction_percent']; ?></label>
                                                                        <input type="text" class="form-control" name="deduction_percent" value="<?php echo $deduction_percent; ?>" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div id="panelAllowance" class="panel panel-info">
                                                        <div class="panel-heading">
                                                            Allowance Policy
                                                        </div>
                                                        <div class="panel-body">
                                                            <div class="table-responsive">
                                                                <table id="tblDepartmentAllowancePolicy" class="table table-bordered">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>Allowance Type</th>
                                                                        <th>Allowance Category</th>
                                                                        <th>Relation</th>
                                                                        <th>Policy on</th>
                                                                        <th>Policy Value</th>
                                                                        <th>&nbsp;</th>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>
                                                                            <select class="form-control" id="allowance_type_id">
                                                                                <option value="">&nbsp;</option>
                                                                                <?php foreach($allowance_type as $type): ?>
                                                                                <option data-allowance_type="<?php echo $type['special_allowance_type']; ?>" value="<?php echo $type['special_allowance_type_id']; ?>"><?php echo $type['special_allowance_type']; ?></option>
                                                                                <?php endforeach; ?>
                                                                            </select>
                                                                        </th>
                                                                        <th>
                                                                            <select class="form-control" id="allowance_category_id">
                                                                                <option value="0">ALL</option>
                                                                            </select>
                                                                        </th>
                                                                        <th>
                                                                            <select class="form-control" id="relation">
                                                                                <option value="Self">Self</option>
                                                                                <option value="Parent">Parent</option>
                                                                                <option value="Sibling">Sibling</option>
                                                                                <option value="Spouse">Spouse</option>
                                                                                <option value="Child">Child</option>
                                                                            </select>
                                                                        </th>
                                                                        <th>
                                                                            <select class="form-control" id="allowance_on">
                                                                                <option value="Percent">Percent</option>
                                                                                <option value="Fixed">Fixed</option>
                                                                            </select>
                                                                        </th>
                                                                        <th>
                                                                            <input type="text" class="form-control fPdecimal" id="allowance_value" value="" />
                                                                        </th>
                                                                        <th><button type="button" class="btn btn-primary btn-xs" id="btnAddPolicy"><i class="fa fa-plus"></i></button></th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <?php $row_id = 0; ?>
                                                                    <?php foreach($policies as $allowance): ?>
                                                                    <tr id="row_<?php echo $row_id; ?>" data-row_id="<?php echo $row_id; ?>">
                                                                        <td>
                                                                            <input type="hidden" id="policy_<?php echo $row_id; ?>_allowance_type_id" name="policies[<?php echo $row_id; ?>][allowance_type_id]" value="<?php echo $allowance['allowance_type_id']?>" />
                                                                            <input type="text" class="form-control" id="policy_<?php echo $row_id; ?>_allowance_type" name="policies[<?php echo $row_id; ?>][allowance_type]" value="<?php echo $allowance['allowance_type']?>" readonly/>
                                                                        </td>
                                                                        <td>
                                                                            <input type="hidden" id="policy_<?php echo $row_id; ?>_allowance_category_id" name="policies[<?php echo $row_id; ?>][allowance_category_id]" value="<?php echo $allowance['allowance_category_id']?>" />
                                                                            <input type="text" class="form-control" id="policy_<?php echo $row_id; ?>_allowance_category" name="policies[<?php echo $row_id; ?>][allowance_category]" value="<?php echo $allowance['allowance_category']?>" readonly/>
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" class="form-control" id="policy_<?php echo $row_id; ?>_relation" name="policies[<?php echo $row_id; ?>][relation]" value="<?php echo $allowance['relation']?>" readonly/>
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" class="form-control" id="policy_<?php echo $row_id; ?>_allowance_on" name="policies[<?php echo $row_id; ?>][allowance_on]" value="<?php echo $allowance['allowance_on']?>" readonly/>
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" class="form-control" id="policy_<?php echo $row_id; ?>_allowance_value" name="policies[<?php echo $row_id; ?>][allowance_value]" value="<?php echo $allowance['allowance_value']?>" readonly/>
                                                                        </td>
                                                                        <td>
                                                                            <a onclick="$(this).parent().parent().remove();" title="Remove" class="btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a>
                                                                            <input type="hidden"  name="policies[<?php echo $row_id; ?>][department_allowance_policy_id]" value="<?php echo $allowance['department_allowance_policy_id']; ?>" />
                                                                        </td>
                                                                    </tr>
                                                                    <?php $row_id++; ?>
                                                                    <?php endforeach; ?>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <link rel="stylesheet" href="plugins/bootstrap-toggle/css/bootstrap-toggle.min.css">
    <script src="plugins/bootstrap-toggle/js/bootstrap-toggle.min.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $URLGetAllowanceCategory = '<?php echo $href_allowance_category; ?>';

        $(document).ready(function() {
            $('#override_attendance_policy').trigger('change');
            $('#override_allowance_policy').trigger('change');
        });

        $(document).on('change','#override_attendance_policy', function() {
            var $override_attendance = $('#override_attendance_policy').is(':checked');
            console.log($override_attendance);
            if($override_attendance) {
                $('#panelAttendance').show('slow');
            } else {
                $('#panelAttendance').hide('slow');
            }
        });

        $(document).on('change','#override_allowance_policy', function() {
            var $override_allowance = $('#override_allowance_policy').is(':checked');
            console.log($override_allowance);
            if($override_allowance) {
                $('#panelAllowance').show('slow');
            } else {
                $('#panelAllowance').hide('slow');
            }
        });

        $(document).on('change','#allowance_type_id', function() {
            var $value = $(this).val();
            console.log($value);
            if($value) {
                $.ajax({
                    url: $URLGetAllowanceCategory,
                    dataType: 'json',
                    type: 'post',
                    data: 'allowance_type_id='+$value,
                    mimeType:"multipart/form-data",
                    beforeSend: function() {
                        $('#allowance_category_id').before('<span id="loader" class="pull-right"><i class="fa fa-spin fa-refresh"></i></span>')
                    },
                    complete: function() {
                        $('#loader').remove();
                    },
                    success: function(json) {
                        $('#allowance_category_id').html(json.html);
                        $('#allowance_category_id').trigger('change');
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        console.log(xhr.responseText);
                    }
                })
            }
        });

        $(document).on('click','#btnAddPolicy', function() {
            var $allowance_type_id = $('#allowance_type_id option:selected').val();
            var $allowance_type = $('#allowance_type_id option:selected').html();
            var $allowance_category_id = $('#allowance_category_id option:selected').val();
            var $allowance_category = $('#allowance_category_id option:selected').html();
            var $relation = $('#relation option:selected').val();
            var $allowance_on = $('#allowance_on option:selected').val();
            var $allowance_value = $('#allowance_value').val();

            if($allowance_type_id=='') {
                alert('Allowance Type required');
            } else if($allowance_value=='') {
                alert('Policy value required');
            } else if($allowance_on == 'Percent' && $allowance_value > 100) {
                alert('Invalid Percentage');
            } else {
                var $html = '';
                $html += '<tr>';
                $html += '<td>';
                $html += '<input type="hidden" name="policies['+$row_id+'][allowance_type_id]" value="'+$allowance_type_id+'" />';
                $html += '<input type="text" class="form-control" name="policies['+$row_id+'][allowance_type]" value="'+$allowance_type+'" readonly/>';
                $html += '</td>';
                $html += '<td>';
                $html += '<input type="hidden" name="policies['+$row_id+'][allowance_category_id]" value="'+$allowance_category_id+'" />';
                $html += '<input type="text" class="form-control" name="policies['+$row_id+'][allowance_category]" value="'+$allowance_category+'" readonly/>';
                $html += '</td>';
                $html += '<td>';
                $html += '<input type="text" class="form-control" name="policies['+$row_id+'][relation]" value="'+$relation+'" readonly/>';
                $html += '</td>';
                $html += '<td>';
                $html += '<input type="text" class="form-control" name="policies['+$row_id+'][allowance_on]" value="'+$allowance_on+'" readonly/>';
                $html += '</td>';
                $html += '<td>';
                $html += '<input type="text" class="form-control" name="policies['+$row_id+'][allowance_value]" value="'+$allowance_value+'" readonly/>';
                $html += '</td>';
                $html += '<td>';
                $html += '<button type="button" class="btn btn-danger btn-sm" onclick="$(this).parent().parent().remove();"><i class="fa fa-times"></i></button>';
                $html += '</td>';
                $html += '</tr>';

                $('#tblDepartmentAllowancePolicy').find('tbody').append($html);
                $row_id++;
            }
        });

        var $row_id = <?php echo $row_id; ?>;
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>