<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="tblTaxSlab" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th style="width: 15px;"><a class="btnAddTaxSlab btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a></th>
                                                    <th class="text-center"><?php echo $lang['range_from']; ?></th>
                                                    <th class="text-center"><?php echo $lang['range_to']; ?></th>
                                                    <th class="text-center"><?php echo $lang['tax_percent']; ?></th>
                                                    <th class="text-center"><?php echo $lang['tax_type']; ?></th>
                                                    <th class="text-center"><?php echo $lang['additional']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $grid_row_tax=0; ?>
                                                <?php foreach($tax_slabs as $tax): ?>
                                                <tr id="grid_row_tax_<?php echo $grid_row_tax; ?>" data-grid_row_tax="<?php echo $grid_row_tax; ?>">
                                                    <td style="width: 15px;"><a class="btnRemoveTaxSlab btn btn-xs btn-danger" title="Remove" href="javascript:void(0);"><i class="fa fa-minus"></i></a></td>
                                                    <td><input type="text" class="form-control text-right" id="tax_slab_<?php echo $grid_row_tax; ?>_range_from" name="tax_slabs[<?php echo $grid_row_tax; ?>][range_from]" value="<?php echo $tax['range_from']; ?>" /></td>
                                                    <td><input type="text" class="form-control text-right" id="tax_slab_<?php echo $grid_row_tax; ?>_range_to" name="tax_slabs[<?php echo $grid_row_tax; ?>][range_to]" value="<?php echo $tax['range_to']; ?>" /></td>
                                                    <td><input type="text" class="form-control text-right" id="tax_slab_<?php echo $grid_row_tax; ?>_tax_percent" name="tax_slabs[<?php echo $grid_row_tax; ?>][tax_percent]" value="<?php echo $tax['tax_percent']; ?>" /></td>
                                                    <td>
                                                        <select class="form-control" id="tax_slab_<?php echo $grid_row_tax; ?>_tax_type" name="tax_slabs[<?php echo $grid_row_tax; ?>][tax_type]" >
                                                            <option value="Difference" <?php echo ($tax['tax_type']=='Difference'?'selected="true"':''); ?>>Difference</option>
                                                            <option value="Fixed" <?php echo ($tax['tax_type']=='Fixed'?'selected="true"':''); ?>>Fixed</option>
                                                        </select>
                                                    </td>
                                                    <td><input type="text" class="form-control text-right" id="tax_slab_<?php echo $grid_row_tax; ?>_additional" name="tax_slabs[<?php echo $grid_row_tax; ?>][additional]" value="<?php echo $tax['additional']; ?>" /></td>
                                                </tr>
                                                <?php $grid_row_tax++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/tax_slab.js"></script>
    <script>
        var $grid_row_tax = <?php echo $grid_row_tax; ?>;
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>