<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<link rel="stylesheet" href="plugins/wysihtml5/bootstrap3-wysihtml5.min.css">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box box-info">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-7">
                                        <div class="form-group">
                                            <label><?php echo $lang['department']; ?></label>
                                            <div class="input-group">
                                                <select class="form-control hide" id="department_id" name="department_id">
                                                    <option>&nbsp;</option>
                                                    <?php foreach($departments as $department): ?>
                                                    <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <div id="btnGetEmployee" data-toggle="tooltip" title="Click to Get Employees" class="input-group-addon" style="cursor: pointer;">
                                                    <i class="fa fa-users"></i>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['subject']; ?></label>
                                            <input type="text" class="form-control" id="subject" name="subject" value="" />
                                        </div>
                                        <div class="form-group">
                                            <label style="width: 100%;"><span class="required">*</span>&nbsp;<?php echo $lang['message']; ?><i style="cursor: pointer;" id="btnHelpMessage" class="fa fa-question-circle fa-lg pull-right" data-toggle="popover" data-placement="bottom" data-content="You can use [RegCode] and [EmployeeName] as legend in email."></i></label>
                                            <textarea class="form-control" id="message" name="message" cols="5" rows="15"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-sm-5">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="table-responsive" style="max-height: 485px;">
                                                    <table id="tblMembers" class="table table-bordered">
                                                        <thead>
                                                        <tr>
                                                            <th>Sr.</th>
                                                            <th>Reg. No.</th>
                                                            <th>Employee Name</th>
                                                            <th>Email Address</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>

                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-offset-9 col-sm-3">
                                                <label>&nbsp;</label>
                                                <button type="button" id="btnSendEmail" class="form-control btn btn-info hide">Send</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/tool/email.js"></script>
    <script type="text/javascript" src="plugins/wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $UrlGetEmployees = '<?php echo $href_get_employees; ?>';
        var $UrlSendEmail = '<?php echo $href_send_email; ?>';
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>