<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="syncDatabase();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['sync_database']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?></div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?></div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="table-responsive">
                                        <table id="tblSyncDatabase" class="table table-bordered table-striped">
                                            <thead>
                                            <tr>
                                                <th>Direction</th>
                                                <th>Table Name</th>
                                                <th>Status</th>
                                                <th>Records</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php foreach($tables as $row_id => $table): ?>
                                            <tr id="<?php echo $row_id; ?>">
                                                <td><?php echo $table['direction']; ?></td>
                                                <td><?php echo $table['table_name']; ?></td>
                                                <td class="status"></td>
                                                <td class="records"></td>
                                            </tr>
                                            <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="syncDatabase();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['sync_database']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/tool/sync.js"></script>
    <script type="text/javascript">
        var $URLSyncDatabase = '<?php echo $href_sync_database; ?>';
        var $tables = <?php echo json_encode($tables); ?>;
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>