<?php

namespace App\Http\Controllers;

use App\Models\AttendanceShift;
use App\Models\AttendanceShiftDetail;
use App\Models\EmployeeAttendance;
use Carbon\Carbon;
use App\Models\Employee;
use App\Models\Attendance;
use App\Models\EmployeeRegistration;
use App\Models\Company;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Helper\Helper;

class AttendanceController extends Controller
{

    public function __construct()
    {
        // $this->middleware('auth:api', ['except' => ['postLogin', 'refresh', 'logout','machine']]);
    }

    private function publicPath(){
        return base_path().'/files/';
    }

//    private function apiLogs($requestDate) {
//        $file = $this->publicPath().'/APILOGS/';
//
//        $fp ="";
//        if(!file_exists($file)){
//            mkdir($file);
//            $fp = fopen($file."API-".date('Y-m-d').".txt","wb");
//        }else{
//            $fp = $file."API-".date('Y-m-d').".txt";
//        }
//        $myfile = fopen($fp, "a") or die("Unable to open file!");
//
//        $txt = "+++++++++++++++++++  API Start +++++++++++++++++++\n";
//        $txt.= '['.date('Y-m-d H:i:s').'] Request Data : '.json_encode($requestDate)."\n";
//        // Api Response
//        $txt.= "++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n";
//        fwrite($myfile, $txt);
//        fclose($myfile);
//    }

    private function apiLogs($message) {
        $file = $this->publicPath().'/APILOGS/';

        $fp ="";
        if(!file_exists($file)){
            mkdir($file);
            $fp = fopen($file."API-".date('Y-m-d').".txt","wb");
        }else{
            $fp = $file."API-".date('Y-m-d').".txt";
        }
        $myfile = fopen($fp, "a") or die("Unable to open file!");
        $txt= '['.date('Y-m-d H:i:s').'] - '.$message."\n";
        fwrite($myfile, $txt);
        fclose($myfile);
    }

    public function machine(Request $request) {

        $company = Company::all()->pluck('db_name','company_id');
        $rows = $request->all();
        $ip_address = $request->ip(); // Get the requestor IP address
        $this->apiLogs("Request IP: " . $ip_address); // Log the IP address
        $this->apiLogs( "Request: " . json_encode($rows));

        $response = [];
        foreach($rows as $row) {

            $attendance_code = $row['user_id'];
            $attendance_date = $row['date'];
            $attendance_time = $row['time'];
            $machine_id = $row['machine_id'];
            $oEmployee = EmployeeRegistration::where('attendance_code',$attendance_code)->first();
            if($oEmployee) {
                $day = date('D', strtotime($attendance_date));

                $oShift = AttendanceShiftDetail::where('attendance_shift_id',$oEmployee['attendance_shift_id'])
                    //->where('is_special',0)
                    ->where('day',$day)->first();

//                $oSpecialShift = AttendanceShiftDetail::where('attendance_shift_id',$oEmployee['attendance_shift_id'])
//                    ->where('is_special',1)
//                    ->where('day',$day)->first();


                if($oShift) {
//                    $shift_in = $oSpecialShift['from_time'] ?? $oShift['from_time'];
//                    $shift_out = $oSpecialShift['to_time'] ?? $oShift['to_time'];
                    $shift_in = $oShift['from_time'];
                    $shift_out = $oShift['to_time'];
                    $day_status = $oShift['day_status'];
                    $oAttendance =EmployeeAttendance::where('employee_registration_id',$oEmployee['employee_registration_id'])->where('attendance_date',$attendance_date)->first();
                    if(empty($oAttendance)) {
                        if($day_status=='Working Day') {
                            if(strtotime($shift_in) >= strtotime($attendance_time)) {
                                $status = 'P';
                            } else {
                                $status = 'LT';
                            }
                        } else {
                            $status = 'H';
                        }

                        $employee_attendance_id = Str::uuid();
                        $dataInsert = [
                            'employee_attendance_id' => $employee_attendance_id,
                            'company_id' => $oEmployee['company_id'],
//                            'company_branch_id' => $oEmployee['company_branch_id'],
                            'department_id' => $oEmployee['department_id'],
                            'employee_registration_id' => $oEmployee['employee_registration_id'],
                            'attendance_date' => $attendance_date,
                            'shift_in' => $shift_in,
                            'shift_out' => $shift_out,
                            'time_in' => $attendance_time,
                            'status' => $status,
                            'attendance_type' => 'Automatic',
                            'created_at' => Carbon::now('Asia/Karachi')->format('Y-m-d H:i:s'),
                            'created_by_id' => 0,
                        ];

                        EmployeeAttendance::insert($dataInsert);
                        $response[] = [
                            'machine_id' => $machine_id,
                            'attendance_code' => $attendance_code,
                            'date' => $attendance_date,
                            'time_in' => $attendance_time,
                            'employee_id' => $oEmployee['employee_id'],
                            'employee_attendance_id' => $employee_attendance_id,
                        ];
                    } else {
                        $employee_attendance_id = $oAttendance['employee_attendance_id'];
                        $dataUpdate = [
                            'time_out' => $attendance_time,
                            'modified_at' => Carbon::now('Asia/Karachi')->format('Y-m-d H:i:s'),
                            'modified_by_id' => 0
                        ];

                        EmployeeAttendance::where('employee_attendance_id',$employee_attendance_id)->update($dataUpdate);
                        $response[] = [
                            'machine_id' => $machine_id,
                            'attendance_code' => $attendance_code,
                            'date' => $attendance_date,
                            'time_out' => $attendance_time,
                            'employee_registration_id' => $oEmployee['employee_registration_id'],
                            'employee_attendance_id' => $employee_attendance_id,
                        ];
                    }
                }
            }
        }
        $this->apiLogs("Response: ".json_encode($response));
        return $this->jsonResponse($response);
    }

    public function checkIn(Request $request)
    {
        try{
            //date_default_timezone_set('Asia/Karachi');
            $this->validate($request, [
                'employee_id' => 'required|string',
                'checkin_time' => 'required|string',
                'longitude' => 'required|string',
                'latitude' => 'required|string',
            ]);

            $employee_id = $request->employee_id;
            $latitude = $request->latitude;
            $longitude = $request->longitude;

            $employeeExists = new EmployeeRegistration();

            $sql = "";
            $sql .= "SELECT";
            $sql .= " `er`.employee_registration_id, e.employee_id, e.employee_code, er.registration_code, e.full_name as employee_name,";
            $sql .= " `c`.`latitude` as `latitude`,";
            $sql .= " `c`.`longitude` as `longitude`,";
            $sql .= " `c`.`distance` as `distance`,";
            $sql .= " (((ACOS(SIN((('" . ($latitude) . "')*PI()/180)) * SIN((c.`latitude`*PI()/180)) + COS((('" . ($latitude) . "')*PI()/180)) * COS((c.`latitude`*PI()/180)) * COS(((('" . ($longitude) . "')- c.`longitude`)*PI()/180)))) * 180/PI()) * 60 * 1.1515) AS `distance_away`";
            $sql .= " FROM `employee_registration` AS `er`";
            $sql .= " INNER JOIN `employee` AS `e` ON `e`.`employee_id` = `er`.`employee_id`";
            $sql .= " LEFT JOIN `company` AS `c` ON `c`.`company_id` = `er`.`company_id`";
            $sql .= " WHERE `er`.`status` = 'Active'";
            $sql .= " AND `er`.`employee_id` = '{$employee_id}'";
            $sql .= " HAVING `distance_away` < c.distance";

            $employeeExists = DB::select(DB::Raw($sql));
            if(!$employeeExists && count($employeeExists)===0){
                return $this->jsonResponse($sql,404, 'Invalid Location');
//            return response()->json([
//                'message' => 'Location not found!',
//                'status' => 'faild',
//                'status_code' => 404
//            ], 404);
            }

            $employees = EmployeeRegistration::where('employee_id', $employee_id)->where('status','Active')->get();
            $request_time = Carbon::parse($request->checkin_time)->format('H:i');
            $server_time = Carbon::now('Asia/Karachi')->format('H:i');
            $server_date = Carbon::now('Asia/Karachi')->format('Y-m-d');

//        // Check difference between server time and checkin time
//        $diffence_time = Carbon::parse($request_time)->diffInMinutes(Carbon::parse($server_time)); // Returns difference in minutes between two times (server time and checkin time)
//
//        if($diffence_time > 10) // If difference is greater than 10 minutes, then checkin time save with mobile time
//        {
//            $checkin_time = $request_time; // Checkin time save with mobile time
//        } else {
//            $checkin_time = $server_time; // Checkin time save with server time
//        }
            $checkin_time = $server_time; // Checkin time save with server time
            //return $this->jsonResponse([$request_time, $server_time, $diffence_time, $checkin_time],401, '');

            DB::beginTransaction();

            $data = [];
            $exist = [];

            foreach($employees as $employee) {
                $check_status = Attendance::where('employee_registration_id', $employee->employee_registration_id)
                    ->where('attendance_date', $server_date)
                    ->first();
                if(!$check_status){
                    $day = date('D',strtotime($server_date));
                    $shift = AttendanceShiftDetail::where('attendance_shift_id',$employee->attendance_shift_id)->where('day',$day)->first();
                    //return $this->jsonResponse([$employee->attendance_shift_id, $day, $shift->day_status],400, 'Testing API');
                    if(strtotime($checkin_time) > strtotime($shift->from_time) && $shift->day_status=='Working Day') {
                        $data = [
                            'employee_attendance_id' => Str::uuid(),
                            'employee_registration_id' => $employee->employee_registration_id,
                            'company_id' => $employee->company_id,
                            'department_id' => $employee->department_id,
                            'attendance_date' => $server_date,
                            'shift_in' => $shift->from_time,
                            'shift_out' => $shift->to_time,
                            'time_in' => $checkin_time,
                            'status' => 'LT',
                            'created_at' => date('Y-m-d H:i:s'),
                        ];
                    } else {
                        $data = [
                            'employee_attendance_id' => Str::uuid(),
                            'employee_registration_id' => $employee->employee_registration_id,
                            'company_id' => $employee->company_id,
                            'department_id' => $employee->department_id,
                            'attendance_date' => $server_date,
                            'shift_in' => $shift->from_time,
                            'shift_out' => $shift->to_time,
                            'time_in' => $checkin_time,
                            'status' => 'P',
                            'created_at' => date('Y-m-d H:i:s'),
                        ];
                    }

                    Attendance::insert($data);
                    Employee::where('employee_id', $request->employee_id)->update(['intime_status' => 1]);
                } else {
                    $exist[] = $check_status;
                }
            }

            if($data && (count($exist)===0)) {
                DB::commit();
                return $this->jsonResponse([],200, 'Checked IN @ '.date('M d, Y H:i', strtotime($server_date.' '.$checkin_time)));
            } else {
                DB::rollBack();
                return $this->jsonResponse(['employee'=>$employee],400, 'You already checked in today.');
            }
        } catch(\Exception $e) {
            DB::rollBack();
            return $this->jsonResponse($e->getMessage(),401, 'Invalid request, contact system administrator');
        }
    }

    public function checkOut(Request $request)
    {
        $this->validate($request, [
            'employee_id' => 'required|string',
            'checkout_time' => 'required|string',
            'longitude' => 'required|string',
            'latitude' => 'required|string',
        ]);

        $employee_id = $request->employee_id;
        $latitude = $request->latitude;
        $longitude = $request->longitude;

        $employeeExists = new EmployeeRegistration();

        $sql = "";
        $sql .= "SELECT";
        $sql .= " `er`.*,";
        $sql .= " `c`.`latitude` as `latitude`,";
        $sql .= " `c`.`longitude` as `longitude`,";
        $sql .= " `c`.`distance` as `distance`,";
        $sql .= " (((ACOS(SIN((('" . ($latitude) . "')*PI()/180)) * SIN((c.`latitude`*PI()/180)) + COS((('" . ($latitude) . "')*PI()/180)) * COS((c.`latitude`*PI()/180)) * COS(((('" . ($longitude) . "')- c.`longitude`)*PI()/180)))) * 180/PI()) * 60 * 1.1515) AS `distance_away`";
        $sql .= " FROM `employee_registration` AS `er`";
        $sql .= " LEFT JOIN `company` AS `c` ON `c`.`company_id` = `er`.`company_id`";
        $sql .= " WHERE `er`.`employee_id` = '{$employee_id}'";
        $sql .= " HAVING `distance_away` < c.distance";

        $employeeExists = DB::select(DB::Raw($sql));

        if(!$employeeExists && count($employeeExists)===0){
//            return response()->json([
//                'message' => 'Location not found!',
//                'status' => 'faild',
//                'status_code' => 404
//            ], 404);
            return $this->jsonResponse([],404, 'Mark your attendance within premises.');
        }

        $employees = EmployeeRegistration::where('employee_id', $employee_id)->where('status','Active')->get();
        $checkout_time = Carbon::parse($request->checkout_time)->format('H:i');
        $server_time = Carbon::now('Asia/Karachi')->format('H:i');
        $server_date = Carbon::now('Asia/Karachi')->format('Y-m-d');

        // Check difference between server time and checkout time
//        $diffence_time = Carbon::parse($checkout_time)->diffInMinutes(Carbon::parse($server_time)); // Returns difference in minutes between two times (server time and checkout time)
//        if($diffence_time < 10) // If difference is less than 10 minutes, then checkout time save with server time
//        {
//            $checkout_time = $server_time; // Checkout time save with server time
//        }
        $checkout_time = $server_time; // Checkout time save with server time

        DB::beginTransaction();

        try{

            $data = [];

            $exsist = [];

            foreach($employees as $employee) {

                $check_status = Attendance::where('employee_registration_id', $employee->employee_registration_id)
                    // ->where('attendance_date', $server_date)
                    ->where('date_out', NULL)
                    ->where('attendance_date', $server_date)
                    ->whereIn('status', ['P','LT'])
                    ->orderBy('attendance_date', 'desc')
                    ->first();

                if($check_status){
                    $data[] = [
                        'employee_attendance_id' => $check_status->employee_attendance_id,
                        'date_out' => $server_date,
                        'time_out' => $checkout_time
                    ];
                } else {
                    $exsist[] = $check_status;
                }
            }

            if($data && (count($exsist)===0)){

                $updated = 0; // initialize variable for updated rows

                foreach($data as $detail){

                    if(Attendance::where('employee_attendance_id', $detail['employee_attendance_id'])
                        ->update([
                            'date_out' => $detail['date_out'],
                            'time_out' => $detail['time_out']
                        ])){
                        $updated++; // if updated rows is greater than 0, then increment variable
                    }
                }


                if($updated==count($data)){

                    Employee::where('employee_id', $request->employee_id)->update(['intime_status' => 0]);
                    DB::commit();
                    return $this->jsonResponse([],200, 'Checkout Successfully!');


                } else {
                    DB::rollBack();
                    return $this->jsonResponse($data,400, 'Checkout Failed! Please try again later or contact administrator.');
                }

            } else {
                DB::rollBack();
                return $this->jsonResponse($data,400, 'You already checkout today.');
            }

        } catch(\Exception $e) {

            DB::rollBack();
            return $this->jsonResponse($data,400, 'Checkout Failed! Please try again later or contact administrator.');
        }

    }


    public function printReport(Request $request)
    {
        $this->validate($request, [
            'employee_id' => 'required|string',
        ]);

        $employee_id = $request->employee_id;
        $date_from = $request->date_from;
        $date_to = $request->date_to;

        if(empty($date_from)){
            $date_from = carbon::now()->subDays(10)->format('Y-m-d');
        } else {
            $date_from = Carbon::parse($date_from)->format('Y-m-d');
        }

        if(empty($date_to)){
            $date_to = Carbon::now()->format('Y-m-d');
        } else {
            $date_to = Carbon::parse($date_to)->format('Y-m-d');
        }

        $difference_40_days = Carbon::parse($date_to)->subDays(40)->format('Y-m-d');
        if($date_from < $difference_40_days){
            return $this->jsonResponse([],400, '40 days limit exceeded.');
        }

        try{

            $employeeRegistration = EmployeeRegistration::selectRaw('GROUP_CONCAT(CONCAT("\'", employee_registration_id, "\'")) AS reg_ids')
                ->where('employee_id', $employee_id)->first();

            $sql = [];
            $sql[] = "SELECT";
            $sql[] = "`attendance_date` AS checkin_date,";
            $sql[] = "`time_in` AS `checkin_time`,";
            $sql[] = "`date_out` AS `checkout_date`,";
            $sql[] = "`time_out` AS `checkout_time`,";
            $sql[] = "`status`   AS `status`";
            $sql[] = "FROM `employee_attendance`";
            $sql[] = "WHERE employee_registration_id IN(". ($employeeRegistration->reg_ids) .")";
            $sql[] = "AND `attendance_date` BETWEEN '{$date_from}' AND '{$date_to}'";
            $sql[] = "GROUP BY `attendance_date`,`time_in`, `date_out`, `time_out`, `status`";
            $sql[] = "ORDER BY `attendance_date`, `date_out` DESC";


            $sql = implode("\n", $sql);
            $data = DB::select(DB::raw($sql));

            if(count($data)>0){
                return $this->jsonResponse($data,200, '');
            } else {
                return $this->jsonResponse($data,404, 'No record found');
            }

        } catch(\Exception $e) {
//            return response()->json([
//                'message' => 'Report Generated Failed! Please try again later or contact administrator.',
//                'status' => 'failed',
//                'status_code' => 401,
//                // 'e' => $e, // For testing purpose
//            ], 401);
            return $this->jsonResponse([],401, 'An error occurred while generating report. Contact Administrator');
        }

    }



    public function checkIntimeStatus(Request $request)
    {
        $this->validate($request, [
            'employee_id' => 'required|string',
        ]);

        $employee_id = $request->employee_id;

        try{
            $employee = EmployeeRegistration::where('employee_id', $employee_id)->first();
            $employee_registration_id = $employee->employee_registration_id;

            $attendance = Attendance::where('employee_registration_id',$employee_registration_id)
                ->where('attendance_date',date('Y-m-d'))->first();
            //return $this->jsonResponse(['employee_id' => $employee_id,'employee_registration_id'=>$employee_registration_id,'attendance'=> $attendance],401, 'Under Mantainance');
            if(empty($attendance)){
                return $this->jsonResponse(0,200, 'Step 1');
            } else {
                if(empty($attendance->time_out)) {
                    return $this->jsonResponse(1,200, 'Step 2');
                } else {
                    return $this->jsonResponse(0,200, 'Step 3');
                }
            }
        } catch(\Exception $e) {
            $myfile = fopen("log".date('Ymd').".txt", "a") or die("Unable to open file!");
            fwrite($myfile, json_encode($e->getMessage(),true));
            fclose($myfile);
//            return response()->json([
//                'message' => 'Check Intime Status Failed! Please try again later or contact administrator.',
//                'status' => 'failed',
//                'status_code' => 401,
//                // 'e' => $e, // For testing purpose
//            ], 401);
            return $this->jsonResponse([],401, 'An error occurred. Contact Administrator');
        }
    }

}