<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\EmployeeRegistration;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use  App\Models\Employee;

class AuthController extends Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function postLogin(Request $request)
    {
        $this->validate($request, [
            'username' => 'required|string',
            'password' => 'required|string',
        ]);

        $credentials = $request->only(['username', 'password']);

        $login_type = 'login_id';
        // check if username or email
        if (filter_var($request->username, FILTER_VALIDATE_EMAIL)) {
            $login_type = 'email';
        }

        $authCredentials = [
            'username' => $credentials['username'],
            'password' => MD5($credentials['password']),
            'login_type' => $login_type
        ];

        if (! $employee = Employee::attempt($authCredentials)) {
            return $this->apiResponse([], 401, 'Unauthorized User');
        }

        $registrations = EmployeeRegistration::where('employee_id','=',$employee->employee_id)->where('status','=','Active')->get();
        $company = [];
        foreach($registrations as $reg) {
            $objCompany = Company::find($reg->company_id);
            $company[] = [
                'employee_registration_id' => $reg->employee_registration_id,
                'company_id' => $objCompany->company_id,
                'company_name' => $objCompany->company_name
            ];
        }

        if (count($company)==0) {
            return $this->apiResponse([], 401, 'Unauthorized User');
        }

        $data = (object) [
            'employee_id' => $employee->employee_id,
            'full_name' => $employee->full_name,
            'email' => $employee->email,
            'profile' => $employee->employee_image,
            'company' => $company
        ];

        $token = (object) [ 
            'type' => 'access_token',
            'access_token' => $employee->access_token,
            'expiry' => time() * 60 * 24
        ];

        return $this->apiResponseWithToken($data, $token, 'Login Successfully!');

    }

    public function me(Request $request)
    {
        $this->validate($request, ['employee_id' => 'required|string']);

        $employee_id = $request->employee_id;
        //$employee = Employee::where('employee_id', $employee_id)->first();
        $employee = Employee::find($employee_id);
        $registrations = EmployeeRegistration::where('employee_id','=',$employee_id)->where('status','=','Active')->get();
        $company = [];
        foreach($registrations as $reg) {
            $objCompany = Company::find($reg->company_id);
            $company[] = [
                'employee_registration_id' => $reg->employee_registration_id,
                'company_id' => $objCompany->company_id,
                'company_name' => $objCompany->company_name
            ];
        }

        $data = [
            'employee_id' => $employee->employee_id,
            'login_id' => $employee->login_id,
            'full_name' => $employee->full_name,
            'employee_image' => $employee->employee_image,
            'joining_date' => $employee->joining_date,
            'email' => $employee->email,
            'mobile_no' => $employee->mobile_no,
            'gender' => $employee->gender,
            'cnic_no' => $employee->cnic_no,
            'company' => $company
        ];

        //$data = $employee->employee_id;
        return $this->apiResponse($data, 200, 'Information fetch successfully!');

        // Old code
        // return response()->json([
        //     'message' => 'Information fetch successfully!',
        //     'status' => 'success',
        //     'status_code' => 200,
        //     'token_type' => 'access_token',
        //     'token' => $employee->access_token,
        //     'employee' => $employee
        // ]);

    }

    public function logout(Request $request)
    {
        $this->validate($request, ['employee_id' => 'required|string']);
        $employee_id = $request->employee_id;
        $employee = Employee::where('employee_id', $employee_id)
        ->where('access_token', '<>', null)
        ->update(['access_token' => null]);
        if($employee){
            return response()->json([
                'message' => 'Logout Successfully!',
                'status' => 'success',
                'status_code' => 200,
                'employee' => $employee
            ]);
        }

        return response()->json([
            'message' => 'Logout Faild!',
            'status' => 'faild',
            'status_code' => 401
        ], 401);
    }

    public function refresh(Request $request)
    {

        $this->validate($request, ['employee_id' => 'required|string']);

        $employee = Employee::refreshToken($request->employee_id);
        if($employee){
            return response()->json([
                'message' => 'Token Refresh Successfully!',
                'status' => 'success',
                'status_code' => 200,
                'token_type' => 'access_token',
                'token' => $employee->access_token,
                'employee' => [
                    'employee_id' => $employee->employee_id,
                    'full_name' => $employee->full_name,
                    'email' => $employee->email,
                    'profile' => $employee->employee_image,
                ],
                'expires_in' => time() * 60 * 24
            ]);
        }

        return response()->json([
            'message' => 'Token Refresh Faild!',
            'status' => 'faild',
            'status_code' => 401
        ], 401);
    }

    public function changePassword(Request $request)
    {
        $this->validate($request, [
            'employee_id' => 'required|string',
            'old_password' => 'required|string',
            'new_password' => 'required|string',
        ]);

        try{

            $employee_id = $request->employee_id;
            $old_password = MD5($request->old_password);
            $new_password = MD5($request->new_password);
            
            $employee = Employee::where('employee_id', $employee_id)
            ->where('login_password', $old_password)->first();

            if($employee){
                $employee->login_password = $new_password;
                $employee->save();
                return response()->json([
                    'message' => 'Password Changed Successfully!',
                    'status' => 'success',
                    'status_code' => 200,
                ]);
            }
            else
            {
                return response()->json([
                    'message' => 'Invalid Old Password!',
                    'status' => 'failed',
                    'status_code' => 401
                ], 401);
            }
        
        }
        catch(\Exception $e){
            return response()->json([
                'message' => 'Password Changed Faild!',
                'status' => 'failed',
                'status_code' => 401,
                // 'error' => $e->getMessage(),
                // 'e' => $e
            ], 401);
        }

    }

}
