<?php

namespace App\Http\Controllers;

use Laravel\Lumen\Routing\Controller as BaseController;

class Controller extends BaseController
{
    //

    /**
     * This is main api controller
     * 
     * All global apis method defined here
     * 
     * @methods
     * apiResponse - This method is used to return api response
     * apiResponseWithToken - This method is used to return api response with token
     */

    /**
     * --------------------------------------------------------------------------------
     * Constructor
     * --------------------------------------------------------------------------------
     */
    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['postLogin', 'refresh', 'logout']]);
    }

    /**
     * --------------------------------------------------------------------------------
     * Get all api response
     * --------------------------------------------------------------------------------
     */

    protected function getDetailConnection($db_name)
    {
        $runtimeConnectionConfig = array_merge(config('database.connections.mysql'), [
            'host' => 'localhost',
            'database' => $db_name,
            'user' => 'root',
            'password' => '',
        ]);
        config(['database.connections.my_con' => $runtimeConnectionConfig]);
        return DB::connection('my_con');
    }

    protected function apiResponse($data = [], $status = 200, $message = 'success') : object
    {
        return response()->json([
            'message' => $message,
            'status' => $this->getStatusName($status),
            'status_code' => $status,
            'employee' => $data
        ], $status);
    }

    protected function jsonResponse($data = [], $status_code = 200, $message = '') : object
    {
        return response()->json([
            'message' => $message,
            'status' => $this->getStatusName($status_code),
            'status_code' => $status_code,
            'data' => $data
        ], $status_code);
    }
    /**
     * --------------------------------------------------------------------------------
     * Response with token
     * --------------------------------------------------------------------------------
     */
    protected function apiResponseWithToken($data, $token, $message = '') : object
    {
        return response()->json([
            'message' => $message,
            'status' => $this->getStatusName(200),
            'status_code' => 200,
            'token_type' => $token->type,
            'token' => $token->access_token,
            'employee' => $data,
            'expires_in' => $token->expiry
        ], 200);
    }


    /**
     * --------------------------------------------------------------------------------
     * Get status name
     * --------------------------------------------------------------------------------
     */
    private function getStatusName(int $code) : string
    {        
        $status = [
            200 => 'Success',
            400 => 'Bad Request',
            401 => 'Unauthorized',
            403 => 'Forbidden',
            404 => 'Not Found',
            500 => 'Internal Server Error',
        ];

        return $status[$code];

    }


}
