<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\EmployeeRegistration;
use Carbon\Carbon;

class EmployeeRegistrationController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['postLogin', 'refresh', 'logout']]);
    }

     public function employeeDirectory(Request $request){

        $employee_id = $request->employee_id;
        $employeesRegistration = EmployeeRegistration::where('employee_id', $employee_id)->first();
        if (empty($employeesRegistration)) {
            return response()->json([
                'message' => 'Employee not found',
                'status' => 'Faild',
                'status_code' => 404
            ], 404);
        }
        
        $directoryList = Employee::select('full_name','mobile_no','email')
             ->where('company_id','=', $request->company_id)
             ->where('employee_id','!=', $employee_id)
             ->get();
             
        return response()->json([
                'data' => $directoryList,
                'message' => 'Get Employee Directory',
                'status' => 'Success',
                'status_code' => 200
            ], 200);
        
     }
    
}