<?php

namespace App\Http\Controllers;

use App\Models\Project;
use Carbon\Carbon;
use App\Models\Employee;
use App\Models\Attendance;
use App\Models\EmployeeRegistration;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProjectController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['postLogin', 'refresh', 'logout']]);
    }

    public function getProjects(Request $request) {
        $this->validate($request, [
            'company_id' => 'required|string',
            'employee_id' => 'required|string',
        ]);

        $company_id = $request->company_id;
        $project_archived = $request->archived;


        $mProjects = Project::where('company_id','=',$company_id);
        if($project_archived !== '') {
            $mProjects = $mProjects->where('project_archived','=',$project_archived);
        }
        $projects = $mProjects->get();
        return response()->json([
            'status' => 'success',
            'status_code' => 200,
            'data' => $projects // For testing purpose
        ], 200);


    }

    public function checkIn(Request $request)
    {

        $this->validate($request, [
            'employee_id' => 'required|string',
            'checkin_time' => 'required|string',
            'longitude' => 'required|string',
            'latitude' => 'required|string',
        ]);

        $employee_id = $request->employee_id;
        $latitude = $request->latitude;
        $longitude = $request->longitude;

        $employeeExists = new EmployeeRegistration();

        $sql = "";
        $sql .= "SELECT";
        $sql .= " `er`.*,";
        $sql .= " `c`.`latitude` as `latitude`,";
        $sql .= " `c`.`longitude` as `longitude`,";
        $sql .= " `c`.`distance` as `distance`,";
        $sql .= " (((ACOS(SIN((('" . ($latitude) . "')*PI()/180)) * SIN((c.`latitude`*PI()/180)) + COS((('" . ($latitude) . "')*PI()/180)) * COS((c.`latitude`*PI()/180)) * COS(((('" . ($longitude) . "')- c.`longitude`)*PI()/180)))) * 180/PI()) * 60 * 1.1515) AS `distance_away`";
        $sql .= " FROM `employee_registration` AS `er`";
        $sql .= " LEFT JOIN `company` AS `c` ON `c`.`company_id` = `er`.`company_id`";
        $sql .= " WHERE `er`.`employee_id` = '{$employee_id}'";
        $sql .= " HAVING `distance_away` < c.distance";

        $employeeExists = DB::select(DB::Raw($sql));

        if(!$employeeExists && count($employeeExists)===0){
            return response()->json([
                'message' => 'Location not found!',
                'status' => 'faild',
                'status_code' => 404
            ], 404);
        }

        $employees = EmployeeRegistration::where('employee_id', $employee_id)->get();
        $checkin_time = Carbon::parse($request->checkin_time)->format('H:i');
        $server_time = Carbon::now()->format('H:i');
        $server_date = Carbon::now()->format('Y-m-d');

        // Check difference between server time and checkin time
        $diffence_time = Carbon::parse($checkin_time)->diffInMinutes(Carbon::parse($server_time)); // Returns difference in minutes between two times (server time and checkin time)

        if($diffence_time > 10) // If difference is greater than 10 minutes, then checkin time save with mobile time
        {
            $checkin_time = $checkin_time; // Checkin time save with mobile time
        } else {
            $checkin_time = $server_time; // Checkin time save with server time
        }

        DB::beginTransaction();

        try{

            $data = [];

            $exsist = [];

            foreach($employees as $employee) {

                $check_status = Attendance::where('employee_registration_id', $employee->employee_registration_id)
                    ->where('attendance_date', $server_date)
                    ->first();

                if(!$check_status){
                    $data[] = [
                        'employee_attendance_id' => Str::uuid(),
                        'employee_registration_id' => $employee->employee_registration_id,
                        'company_id' => $employee->company_id,
                        'department_id' => $employee->department_id,
                        'attendance_date' => $server_date,
                        'time_in' => $checkin_time,
                        'status' => 'P'
                    ];
                } else {
                    $exsist[] = $check_status;
                }
            }

            if($data && (count($exsist)===0)){

                Attendance::insert($data);

                Employee::where('employee_id', $request->employee_id)->update(['intime_status' => 1]);

                DB::commit();
                return response()->json([
                    'message' => 'Checkin Successfully!',
                    'status' => 'success',
                    'status_code' => 200,
                    // 'data' => $data // For testing purpose
                ], 200);


            } else {
                DB::rollBack();
                return response()->json([
                    'message' => 'Your are already checkedin today!',
                    'status' => 'faild',
                    'status_code' => 400,
                    // 'data' => $exsist // If you want to show already checked in employee
                ], 400);
            }

        } catch(\Exception $e) {

            DB::rollBack();
            return response()->json([
                'message' => 'Checkin Failed! Please try again later or contact administrator.',
                'status' => 'failed',
                'status_code' => 401,
                // 'e' => $e, // uncomment this line to see error message
                // 'exists' => $exsist // uncomment this line to see error message
            ], 401);


        }

    }

    public function checkOut(Request $request)
    {
        $this->validate($request, [
            'employee_id' => 'required|string',
            'checkout_time' => 'required|string',
            'longitude' => 'required|string',
            'latitude' => 'required|string',
        ]);

        $employee_id = $request->employee_id;
        $latitude = $request->latitude;
        $longitude = $request->longitude;

        $employeeExists = new EmployeeRegistration();

        $sql = "";
        $sql .= "SELECT";
        $sql .= " `er`.*,";
        $sql .= " `c`.`latitude` as `latitude`,";
        $sql .= " `c`.`longitude` as `longitude`,";
        $sql .= " `c`.`distance` as `distance`,";
        $sql .= " (((ACOS(SIN((('" . ($latitude) . "')*PI()/180)) * SIN((c.`latitude`*PI()/180)) + COS((('" . ($latitude) . "')*PI()/180)) * COS((c.`latitude`*PI()/180)) * COS(((('" . ($longitude) . "')- c.`longitude`)*PI()/180)))) * 180/PI()) * 60 * 1.1515) AS `distance_away`";
        $sql .= " FROM `employee_registration` AS `er`";
        $sql .= " LEFT JOIN `company` AS `c` ON `c`.`company_id` = `er`.`company_id`";
        $sql .= " WHERE `er`.`employee_id` = '{$employee_id}'";
        $sql .= " HAVING `distance_away` < c.distance";

        $employeeExists = DB::select(DB::Raw($sql));

        if(!$employeeExists && count($employeeExists)===0){
            return response()->json([
                'message' => 'Location not found!',
                'status' => 'faild',
                'status_code' => 404
            ], 404);
        }

        $employees = EmployeeRegistration::where('employee_id', $employee_id)->get();
        $checkout_time = Carbon::parse($request->checkout_time)->format('H:i');
        $server_time = Carbon::now()->format('H:i');
        $server_date = Carbon::now()->format('Y-m-d');

        // Check difference between server time and checkout time
        $diffence_time = Carbon::parse($checkout_time)->diffInMinutes(Carbon::parse($server_time)); // Returns difference in minutes between two times (server time and checkout time)

        if($diffence_time > 10) // If difference is greater than 10 minutes, then checkout time save with mobile time
        {
            $checkout_time = $checkout_time; // Checkout time save with mobile time
        } else {
            $checkout_time = $server_time; // Checkout time save with server time
        }

        DB::beginTransaction();

        try{

            $data = [];

            $exsist = [];

            foreach($employees as $employee) {

                $check_status = Attendance::where('employee_registration_id', $employee->employee_registration_id)
                    // ->where('attendance_date', $server_date)
                    ->where('date_out', NULL)
                    ->orderBy('attendance_date', 'desc')
                    ->first();

                if($check_status){
                    $data[] = [
                        'employee_attendance_id' => $check_status->employee_attendance_id,
                        'date_out' => $server_date,
                        'time_out' => $checkout_time
                    ];
                } else {
                    $exsist[] = $check_status;
                }
            }

            if($data && (count($exsist)===0)){

                $updated = 0; // initialize variable for updated rows

                foreach($data as $detail){

                    if(Attendance::where('employee_attendance_id', $detail['employee_attendance_id'])
                        ->update([
                            'date_out' => $detail['date_out'],
                            'time_out' => $detail['time_out']
                        ])){
                        $updated++; // if updated rows is greater than 0, then increment variable
                    } else {
                        $updated--; // if updated rows is less than 0, then decrement variable
                    }
                }


                if($updated==count($data)){

                    Employee::where('employee_id', $request->employee_id)->update(['intime_status' => 0]);
                    DB::commit();
                    return response()->json([
                        'message' => 'Checkout Successfully!',
                        'status' => 'success',
                        'status_code' => 200,
                        // 'data' => $data // For testing purpose
                    ], 200);


                } else {
                    DB::rollBack();
                    return response()->json([
                        'message' => 'Checkout Failed! Please try again later or contact administrator.',
                        'status' => 'failed',
                        'status_code' => 401,
                        // 'data' => $data // For testing purpose
                    ], 401);
                }

            } else {
                DB::rollBack();
                return response()->json([
                    'message' => 'Your are already checkedout today!',
                    'status' => 'faild',
                    'status_code' => 400,
                    // 'data' => $exsist // For testing purpose
                ], 400);
            }

        } catch(\Exception $e) {

            DB::rollBack();
            return response()->json([
                'message' => 'Checkout Failed! Please try again later or contact administrator.',
                'status' => 'failed',
                'status_code' => 401,
                // 'e' => $e, // For testing purpose
                // 'exists' => $exsist // For testing purpose
            ], 401);


        }

    }

    public function printReport(Request $request)
    {
        $this->validate($request, [
            'employee_id' => 'required|string',
        ]);

        $employee_id = $request->employee_id;
        $date_from = $request->date_from;
        $date_to = $request->date_to;

        if(empty($date_from)){
            $date_from = carbon::now()->subDays(10)->format('Y-m-d');
        } else {
            $date_from = Carbon::parse($date_from)->format('Y-m-d');
        }

        if(empty($date_to)){
            $date_to = Carbon::now()->format('Y-m-d');
        } else {
            $date_to = Carbon::parse($date_to)->format('Y-m-d');
        }

        $difference_40_days = Carbon::parse($date_to)->subDays(40)->format('Y-m-d');
        if($date_from < $difference_40_days){
            return response()->json([
                'message' => 'You can not print report for more than 40 days!',
                'status' => 'faild',
                'status_code' => 400,
            ], 400);
        }

        try{

            $employeeRegistration = EmployeeRegistration::selectRaw('GROUP_CONCAT(CONCAT("\'", employee_registration_id, "\'")) AS reg_ids')
                ->where('employee_id', $employee_id)->first();

            $sql = [];
            $sql[] = "SELECT";
            $sql[] = "DATE_FORMAT(`attendance_date`, '%d-%m-%Y') AS checkin_date,";
            $sql[] = "DATE_FORMAT(TIME(`time_in`), '%h:%i %p')  AS `checkin_time`,";
            $sql[] = "DATE_FORMAT(`date_out`, '%d-%m-%Y') AS `checkout_date`,";
            $sql[] = "DATE_FORMAT(TIME(`time_out`), '%h:%i %p') AS `checkout_time`,";
            $sql[] = "`status`   AS `status`";
            $sql[] = "FROM `employee_attendance`";
            $sql[] = "WHERE employee_registration_id IN(". ($employeeRegistration->reg_ids) .")";
            $sql[] = "AND `attendance_date` BETWEEN '{$date_from}' AND '{$date_to}'";
            $sql[] = "GROUP BY `attendance_date`,`time_in`, `date_out`, `time_out`, `status`";
            $sql[] = "ORDER BY `attendance_date`, `date_out` DESC";


            $sql = implode("\n", $sql);
            $data = DB::select(DB::raw($sql));

            if(count($data)>0){
                return response()->json([
                    'message' => 'Report Generated Successfully!',
                    'status' => 'success',
                    'status_code' => 200,
                    'data' => $data,
                ], 200);
            } else {
                return response()->json([
                    'message' => 'No data found!',
                    'status' => 'faild',
                    'status_code' => 404,
                ], 404);
            }

        } catch(\Exception $e) {
            return response()->json([
                'message' => 'Report Generated Failed! Please try again later or contact administrator.',
                'status' => 'failed',
                'status_code' => 401,
                // 'e' => $e, // For testing purpose
            ], 401);

        }

    }



    public function checkIntimeStatus(Request $request)
    {
        $this->validate($request, [
            'employee_id' => 'required|string',
        ]);

        $employee_id = $request->employee_id;

        try{
            $employee = Employee::where('employee_id', $employee_id)->first();
            if($employee->intime_status == 1){
                return response()->json([
                    'message' => 'You are already checkedin!',
                    'status' => 'success',
                    'status_code' => 200,
                    'data' => $employee->intime_status,
                ], 200);
            } else {
                return response()->json([
                    'message' => 'You are not checkedin yet!',
                    'status' => 'success',
                    'status_code' => 200,
                    'data' => $employee->intime_status,
                ], 200);
            }
        } catch(\Exception $e) {
            return response()->json([
                'message' => 'Check Intime Status Failed! Please try again later or contact administrator.',
                'status' => 'failed',
                'status_code' => 401,
                // 'e' => $e, // For testing purpose
            ], 401);

        }
    }

}