<?php

namespace App\Http\Controllers;

use App\Models\Student;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class StudentController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('auth:api', ['except' => ['postLogin', 'refresh', 'logout']]);
    // }

    public function createStudent(Request $request) {
        $this->validate($request, [
            'student_name' => 'required|string',
            'father_name' => 'required|string',
            'dob' => 'date_format:d-m-Y',
            'email' => 'required|email'
        ]);

        $student_id = Str::uuid();
        $data = [
            'student_id' => $student_id,
            'student_name' => $request->student_name,
            'father_name' => $request->father_name,
            'dob' => Carbon::createFromFormat('d-m-Y', $request->dob)->format('Y-m-d'),
            'email' => $request->email,
            'mobile_no' => $request->mobile_no,
            'created_at' => date('Y-m-d H:i:s'),
            'created_by_id' => 1,
        ];

        DB::beginTransaction();
        Student::insert($data);
        DB::commit();


        return response()->json(['student_id' => $student_id], 200);
    }

    public function getStudent(Request $request, $student_id) 
    {
        $student = Student::find($student_id);
        if($student) 
        {
            $data = [
                'student_id' => $student_id,
                'student_name' => $student->student_name,
                'father_name' => $student->father_name,
                'dob' => Carbon::createFromFormat('Y-m-d', $student->dob)->format('d-m-Y'),
                'email' => $student->email,
                'mobile_no' => $student->mobile_no,
                'created_at' => date('d-m-y H:i:s'),
                'created_by_id' => 1,
            ];

            return response()->json(['data' => $data], 200);
        }
                   
        
    }

    public function getStudents(Request $request) {

        $from_date = Carbon::createFromFormat('d-m-Y', $request->from_date)->format('Y-m-d');
        $to_date = Carbon::createFromFormat('d-m-Y', $request->to_date)->format('Y-m-d');
        $students = Student::where('dob','>=',$from_date)
        ->where('dob','<=',$to_date)
        ->get();
        return response()->json(['data' => $students], 200);

    }
}