<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Contracts\Auth\Factory as Auth;
use App\Models\Employee;

class Authenticate
{
    /**
     * The authentication guard factory instance.
     *
     * @var \Illuminate\Contracts\Auth\Factory
     */
    protected $auth;

    /**
     * Create a new middleware instance.
     *
     * @param  \Illuminate\Contracts\Auth\Factory  $auth
     * @return void
     */
    public function __construct(Auth $auth)
    {
        $this->auth = $auth;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {

        $access_token = $request->header('Authorization');
        // remove key from access token
         $access_token = str_replace('access_token ', '', $access_token);
         if (! (Employee::where('access_token', $access_token)->first() && Employee::is_jwt_valid($access_token)) ) {
             return response()->json([
                 'message' => 'Unauthorized',
                 'status' => 'Faild Login',
                 'status_code' => 401
             ], 401);
         }

        return $next($request);
    }
}
