/*
SQLyog Ultimate v10.00 Beta1
MySQL - 5.7.38-log : Database - bsportal_hrms_payroll
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`bsportal_hrms_payroll` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `bsportal_hrms_payroll`;

/*Table structure for table `_temp_machine_attendance` */

CREATE TABLE `_temp_machine_attendance` (
  `emp_no` varchar(8) DEFAULT NULL,
  `machine_no` varchar(8) DEFAULT NULL,
  `ref_no` varchar(8) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `auto_assign` varchar(8) DEFAULT NULL,
  `attendance_date` date DEFAULT NULL,
  `timetable` varchar(255) DEFAULT NULL,
  `on_duty` varchar(8) DEFAULT NULL,
  `off_duty` varchar(8) DEFAULT NULL,
  `clock_in` varchar(8) DEFAULT NULL,
  `clock_out` varchar(8) DEFAULT NULL,
  `normal` tinyint(4) DEFAULT NULL,
  `real_time` tinyint(4) DEFAULT NULL,
  `late` tinyint(4) DEFAULT NULL,
  `early` tinyint(4) DEFAULT NULL,
  `absent` tinyint(4) DEFAULT NULL,
  `ot_time` varchar(8) DEFAULT NULL,
  `work_time` varchar(8) DEFAULT NULL,
  `exception` varchar(8) DEFAULT NULL,
  `must_cin` tinyint(4) DEFAULT NULL,
  `must_cout` tinyint(4) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `ndays` tinyint(4) DEFAULT NULL,
  `week_end` tinyint(4) DEFAULT NULL,
  `holiday` tinyint(4) DEFAULT NULL,
  `att_time` varchar(8) DEFAULT NULL,
  `ndays_ot` varchar(8) DEFAULT NULL,
  `week_end_ot` varchar(8) DEFAULT NULL,
  `holiday_ot` varchar(8) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `_temp_machine_attendance` */

/*Table structure for table `account_posting` */

CREATE TABLE `account_posting` (
  `account_posting_id` char(38) NOT NULL,
  `company_id` int(11) NOT NULL,
  `fiscal_year_id` int(11) NOT NULL,
  `document_date` date NOT NULL,
  `document_no` int(11) NOT NULL AUTO_INCREMENT,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `pay_date` date NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by_id` int(11) NOT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  `is_post` tinyint(4) DEFAULT NULL,
  `post_at` datetime DEFAULT NULL,
  `post_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`account_posting_id`),
  KEY `document_no` (`document_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `account_posting` */

/*Table structure for table `account_posting_budget` */

CREATE TABLE `account_posting_budget` (
  `account_posting_budget_id` char(38) NOT NULL,
  `account_posting_id` char(38) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `Comp` varchar(4) DEFAULT NULL,
  `Year` varchar(4) DEFAULT NULL,
  `BudKey` varchar(4) DEFAULT NULL,
  `Ref` varchar(16) DEFAULT NULL,
  `budAmount` varchar(16) DEFAULT NULL,
  `Status` varchar(4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`account_posting_budget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `account_posting_budget` */

/*Table structure for table `account_posting_ledger` */

CREATE TABLE `account_posting_ledger` (
  `account_posting_ledger_id` char(38) NOT NULL,
  `account_posting_id` char(38) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `PayDate` varchar(16) DEFAULT NULL,
  `SysKey` varchar(16) DEFAULT NULL,
  `SysTag` varchar(16) DEFAULT NULL,
  `Year` varchar(4) DEFAULT NULL,
  `Comp` varchar(4) DEFAULT NULL,
  `PartyID` varchar(4) DEFAULT NULL,
  `Party` varchar(255) DEFAULT NULL,
  `trans_type` varchar(4) DEFAULT NULL,
  `BAHKey` varchar(4) DEFAULT NULL,
  `AHKey` varchar(4) DEFAULT NULL,
  `CCKey` varchar(4) DEFAULT NULL,
  `BudKey` varchar(8) DEFAULT NULL,
  `Narr` varchar(255) DEFAULT NULL,
  `Ref` varchar(4) DEFAULT NULL,
  `taxType` varchar(16) DEFAULT NULL,
  `Pamount` varchar(16) DEFAULT NULL,
  `Bamount` varchar(16) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`account_posting_ledger_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `account_posting_ledger` */

/*Table structure for table `account_posting_slip` */

CREATE TABLE `account_posting_slip` (
  `account_posting_slip_id` char(38) NOT NULL,
  `account_posting_id` char(38) DEFAULT NULL,
  `payroll_date` varchar(16) DEFAULT NULL,
  `deposit_slip_date` varchar(16) DEFAULT NULL,
  `deposit_slip_no` varchar(8) DEFAULT NULL,
  `deposit_slip_title` varchar(32) DEFAULT NULL,
  `account_title` varchar(32) DEFAULT NULL,
  `account_no` varchar(32) DEFAULT NULL,
  `cheque_date` varchar(16) DEFAULT NULL,
  `cheque_no` varchar(16) DEFAULT NULL,
  `cheque_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `post` tinyint(4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`account_posting_slip_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `account_posting_slip` */

/*Table structure for table `advance` */

CREATE TABLE `advance` (
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `advance_id` char(38) NOT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `registration_code` int(11) DEFAULT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `employee_code` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(11,2) DEFAULT '0.00',
  `description` text,
  `company_account_id` int(11) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `cheque_no` varchar(255) DEFAULT NULL,
  `payroll_id` char(38) DEFAULT NULL,
  `payroll_deduction_id` char(38) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`advance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `advance` */

/*Table structure for table `allowance` */

CREATE TABLE `allowance` (
  `allowance_id` int(11) NOT NULL AUTO_INCREMENT,
  `allowance_code` varchar(8) DEFAULT NULL,
  `allowance_name` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`allowance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*Data for the table `allowance` */

insert  into `allowance`(`allowance_id`,`allowance_code`,`allowance_name`,`status`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values (1,NULL,'House Rent','Active','2018-04-27 09:33:15',1,NULL,NULL),(2,NULL,'Conveyance','Active','2018-04-27 09:33:31',1,NULL,NULL),(3,NULL,'Bonus','Active','2018-04-27 09:33:40',1,NULL,NULL),(4,NULL,'Special','Active','2018-04-27 09:33:51',1,NULL,NULL),(5,NULL,'Medical','Active','2018-04-27 09:34:00',1,NULL,NULL),(6,NULL,'Travel','Active','2018-04-27 09:34:19',1,NULL,NULL),(7,NULL,'Overtime','Active','2018-04-27 09:34:28',1,NULL,NULL),(8,NULL,'Others','Active','2019-05-11 12:41:24',1,'2019-06-08 09:23:51',1);

/*Table structure for table `allowance_posting` */

CREATE TABLE `allowance_posting` (
  `allowance_posting_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `document_date` date DEFAULT NULL,
  `document_no` int(11) NOT NULL DEFAULT '0',
  `document_identity` varchar(255) DEFAULT NULL,
  `document_title` varchar(255) DEFAULT NULL,
  `pay_from_company_id` int(11) DEFAULT NULL,
  `company_account_id` char(38) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `bank_name` varchar(255) DEFAULT NULL,
  `bank_branch` varchar(255) DEFAULT NULL,
  `account_title` varchar(255) DEFAULT NULL,
  `account_no` varchar(255) DEFAULT NULL,
  `iban` varchar(255) DEFAULT NULL,
  `party_id` int(11) DEFAULT NULL,
  `ah_key` int(11) DEFAULT NULL,
  `special_allowance_type_id` int(11) DEFAULT NULL,
  `from_allowance_date` date DEFAULT NULL,
  `to_allowance_date` date DEFAULT NULL,
  `department_id` varchar(255) DEFAULT NULL,
  `total_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  `is_post` int(11) DEFAULT NULL,
  `post_at` datetime DEFAULT NULL,
  `post_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`allowance_posting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `allowance_posting` */

/*Table structure for table `allowance_posting_detail` */

CREATE TABLE `allowance_posting_detail` (
  `allowance_posting_detail_id` char(38) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `allowance_posting_summary_id` char(38) DEFAULT NULL,
  `allowance_posting_id` char(38) DEFAULT NULL,
  `special_allowance_installment_id` char(38) NOT NULL,
  `special_allowance_id` char(38) NOT NULL,
  `special_allowance_identity` varchar(255) NOT NULL,
  `special_allowance_date` date DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `cheque_no` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`allowance_posting_detail_id`),
  KEY `allowance_posting_id` (`allowance_posting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `allowance_posting_detail` */

/*Table structure for table `allowance_posting_summary` */

CREATE TABLE `allowance_posting_summary` (
  `allowance_posting_summary_id` char(38) NOT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `employee_name` varchar(255) DEFAULT NULL,
  `total_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `cheque_date` date DEFAULT NULL,
  `cheque_no` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`allowance_posting_summary_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `allowance_posting_summary` */

/*Table structure for table `attendance_shift` */

CREATE TABLE `attendance_shift` (
  `company_id` int(11) DEFAULT NULL,
  `attendance_shift_id` char(38) NOT NULL,
  `shift_title` varchar(255) DEFAULT NULL,
  `late_deduction` decimal(11,2) DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`attendance_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `attendance_shift` */

insert  into `attendance_shift`(`company_id`,`attendance_shift_id`,`shift_title`,`late_deduction`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values (7,'{08BFE024-66BC-445E-8F2C-B3CF1C980CD0}','SFT - Day Shift','1.00','2018-07-23 07:40:02',1,'2020-12-16 13:41:17',3),(5,'{137BAE1A-D2AD-45D0-AF31-E4EB8FA85C18}','Night - hbmc','1.00','2018-07-13 12:20:52',1,'2021-01-04 09:22:13',1),(3,'{2A3D53FF-72F9-4CC3-B79E-672C82C8326E}','Night Shift','2.00','2018-07-09 12:24:45',1,NULL,NULL),(6,'{2DCB3B70-B8A6-4E8A-981B-946E331C8C28}','Day Shift - STSMF','1.00','2018-07-19 07:15:33',1,'2021-06-29 15:35:16',19),(2,'{400B6675-CB0E-448A-A066-159F67548B68}','BM Qasr Staff','1.00','2020-11-25 11:40:25',6,'2020-12-16 13:39:02',3),(8,'{4EEA1AF8-0BAC-4634-8410-D3B68B57EA7A}','NM - Day Shift','1.00','2018-07-23 07:40:30',1,'2020-12-16 13:41:26',3),(19,'{5549525E-C8CC-4630-9940-A992323897BA}','Night Shift TNW','1.00','2021-11-05 16:16:18',1,'2021-11-05 16:16:18',1),(13,'{62BEC8B0-2850-42ED-8B84-3D130305D450}','SF - Day Shift','1.00','2019-12-24 11:59:13',1,'2020-12-16 13:41:57',3),(9,'{6366FF68-79E7-4D62-8267-DCE767F63E51}','SBT - Night Shift','1.00','2018-08-04 05:11:55',1,'2020-12-16 13:41:35',3),(2,'{750255CD-A786-4503-BD11-CCDACAAB836D}','Watchman Night Shift','1.00','2018-04-27 11:02:25',1,'2022-04-28 12:27:28',6),(19,'{794D4115-0CD2-404A-B989-91D7C25BCA36}','Day Shift TNW','1.00','2021-11-05 16:15:20',1,'2021-11-05 16:15:20',1),(3,'{7FAEB81B-C2E8-4ADA-97CB-3EAEB2C726DB}','Day Shift','2.00','2018-07-09 12:24:06',1,NULL,NULL),(4,'{8857CF67-3A87-4805-9DC9-9E9F6AB954B7}','Yasmeen Yahyah Udaipurwala','1.00','2022-01-11 13:57:16',3,'2022-01-13 15:16:30',3),(2,'{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','ANB Ashfaq','1.00','2020-11-25 09:18:23',6,'2021-11-02 16:51:26',1),(2,'{9A8B3474-16CF-4DB5-95C1-798C5D6A92B1}','Office Staff Day Shift','1.00','2018-04-27 11:00:11',1,'2020-12-16 13:39:39',3),(4,'{A8D05D73-9860-4A6C-B99B-E1E96971D12C}','Night Shift - BM','1.00','2018-07-11 11:15:56',3,'2020-12-16 13:38:17',3),(4,'{ADC4DFD1-211D-4BBE-A9CC-5665F947583C}','Day Shift - BM','1.00','2018-07-11 11:14:38',3,'2020-12-16 13:38:25',3),(6,'{BCA835BE-C1CC-423D-A219-8AB800EC7DC3}','Gardner Shift','1.00','2020-02-27 10:22:11',1,'2021-06-29 15:35:00',19),(2,'{BCFC7D26-C85D-49F7-AC06-CA520DE4B5DC}','Nadil Yousuf','1.00','2020-11-25 09:01:46',6,'2021-11-02 16:51:36',1),(17,'{C13B2D7B-3F42-4630-8943-72CE904DB128}','Hamidi Night Shift','1.00','2020-09-10 10:31:57',1,'2021-03-03 10:11:46',1),(2,'{C4451DF5-FEC3-47A9-9192-6B2EB6C8FD67}','Watchman Day Shift','1.00','2018-04-27 11:01:07',1,'2022-04-28 12:26:35',6),(9,'{D6D0DCC3-7A5F-426C-A911-2995F91580A7}','SBT - Day Shift','1.00','2018-08-04 05:11:07',1,'2020-12-16 13:41:41',3),(10,'{D8507066-869E-4248-BC24-E2812694DF97}','AT - Day Shift','2.00','2018-08-18 09:41:55',1,NULL,NULL),(2,'{DB7FEEE7-894C-481F-B63E-2E5CC0772CED}','BM Maali','1.00','2020-11-25 11:45:48',6,'2020-12-16 13:38:55',3),(6,'{E26F8DFF-59C5-4AF3-AE2A-F2536C63BB42}','Night Shift - STSMF','1.00','2018-07-19 07:17:07',1,'2021-06-29 15:35:07',19),(2,'{F0088DC9-9405-4252-BB7C-533A584CC92A}','ANB Hassan','1.00','2020-11-25 09:19:39',6,'2021-11-02 16:51:21',1),(2,'{F2C42367-FDA9-400B-BB44-0FC9BA471412}','ANB Razzaq','1.00','2020-11-25 09:16:50',6,'2021-11-02 16:51:31',1),(5,'{F507C00F-DCE9-4341-87D5-1BC1C173A77E}','Day Shift - hbmc','1.00','2018-07-13 12:19:27',1,'2021-01-04 09:22:07',1),(10,'{FB6B21DE-7ACB-4CBF-B1BB-9673A7DA7BDA}','AT - Night Shift','2.00','2018-08-18 09:42:56',1,NULL,NULL),(17,'{FE43FAC7-E3B1-4491-A543-C7D9227D59E8}','Hamidi Day Shift','1.00','2020-09-10 10:31:03',1,'2021-03-03 10:11:51',1);

/*Table structure for table `attendance_shift_detail` */

CREATE TABLE `attendance_shift_detail` (
  `attendance_shift_id` char(38) DEFAULT NULL,
  `attendance_shift_detail_id` char(38) NOT NULL,
  `day` enum('Mon','Tue','Wed','Thu','Fri','Sat','Sun') DEFAULT NULL,
  `day_status` enum('Working Day','Holiday') DEFAULT NULL,
  `from_time` varchar(8) DEFAULT NULL,
  `to_time` varchar(8) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`attendance_shift_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `attendance_shift_detail` */

insert  into `attendance_shift_detail`(`attendance_shift_id`,`attendance_shift_detail_id`,`day`,`day_status`,`from_time`,`to_time`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values ('{D8507066-869E-4248-BC24-E2812694DF97}','{016FC512-D6EB-4A36-BAE0-3A5E62BCE565}','Sat','Working Day','07:00','15:00','2018-08-18 09:41:56',1,NULL,NULL),('{9A8B3474-16CF-4DB5-95C1-798C5D6A92B1}','{031A92D6-4CE5-467B-A9C6-E4873EE52295}','Tue','Working Day','09:00','17:00','2020-12-16 13:39:39',3,'2020-12-16 13:39:39',3),('{F0088DC9-9405-4252-BB7C-533A584CC92A}','{054D5AA6-AA25-448A-87E2-CF8E43838563}','Thu','Holiday','00:00','00:00','2021-11-02 16:51:21',1,'2021-11-02 16:51:21',1),('{08BFE024-66BC-445E-8F2C-B3CF1C980CD0}','{07AA0755-4A3A-461D-877D-E2B6F11EF69D}','Sun','Holiday','0:00','0:00','2020-12-16 13:41:18',3,'2020-12-16 13:41:18',3),('{F2C42367-FDA9-400B-BB44-0FC9BA471412}','{0817840B-53E3-4719-816E-560C11CB328D}','Mon','Working Day','08:00','20:00','2021-11-02 16:51:32',1,'2021-11-02 16:51:32',1),('{ADC4DFD1-211D-4BBE-A9CC-5665F947583C}','{096CECC2-582D-4F00-BD78-C31B8E620E09}','Tue','Working Day','9:00','17:00','2020-12-16 13:38:25',3,'2020-12-16 13:38:25',3),('{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','{09953D32-5DBC-4D58-9211-560AA9232D2F}','Sun','Holiday','0:00','0:00','2021-11-02 16:51:26',1,'2021-11-02 16:51:26',1),('{400B6675-CB0E-448A-A066-159F67548B68}','{0A0737BB-59AB-4854-9982-77B443AB021D}','Tue','Working Day','08:30','17:00','2020-12-16 13:39:03',3,'2020-12-16 13:39:03',3),('{750255CD-A786-4503-BD11-CCDACAAB836D}','{0A189845-5847-460B-B40B-B23B01AFA9AD}','Mon','Working Day','19:00','07:00','2022-04-28 12:27:29',6,'2022-04-28 12:27:29',6),('{DB7FEEE7-894C-481F-B63E-2E5CC0772CED}','{0A63B55C-0E32-414B-A761-02417EEB895F}','Thu','Working Day','07:30','12:30','2020-12-16 13:38:55',3,'2020-12-16 13:38:55',3),('{DB7FEEE7-894C-481F-B63E-2E5CC0772CED}','{0CE0896B-BEDF-4BFE-B165-C8851019DB69}','Sat','Working Day','07:30','12:30','2020-12-16 13:38:55',3,'2020-12-16 13:38:55',3),('{F507C00F-DCE9-4341-87D5-1BC1C173A77E}','{0E6E0556-6092-451C-AFDB-BEE9E17248CF}','Thu','Working Day','9:00','17:00','2021-01-04 09:22:08',1,'2021-01-04 09:22:08',1),('{E26F8DFF-59C5-4AF3-AE2A-F2536C63BB42}','{109E3280-C34F-40BB-B878-31106C9FF51B}','Tue','Working Day','17:00','08:00','2021-06-29 15:35:07',19,'2021-06-29 15:35:07',19),('{ADC4DFD1-211D-4BBE-A9CC-5665F947583C}','{13EC8ACA-4781-40B8-8E6A-7D52C03B3DD9}','Wed','Working Day','9:00','17:00','2020-12-16 13:38:25',3,'2020-12-16 13:38:25',3),('{D6D0DCC3-7A5F-426C-A911-2995F91580A7}','{1501D2EF-4589-42EB-AB63-917FB66E84B9}','Tue','Working Day','9:00','17:00','2020-12-16 13:41:41',3,'2020-12-16 13:41:41',3),('{794D4115-0CD2-404A-B989-91D7C25BCA36}','{16F490CD-F250-4666-AF18-AE942671D2F2}','Mon','Working Day','9:00','17:00','2021-11-05 16:15:20',1,'2021-11-05 16:15:20',1),('{BCA835BE-C1CC-423D-A219-8AB800EC7DC3}','{173DE64C-685B-4D82-9EA9-A621A97FC165}','Fri','Working Day','08:00','12:30','2021-06-29 15:35:00',19,'2021-06-29 15:35:00',19),('{794D4115-0CD2-404A-B989-91D7C25BCA36}','{17B54234-27F4-48B4-8CF2-5F47253BA9E9}','Tue','Working Day','9:00','17:00','2021-11-05 16:15:20',1,'2021-11-05 16:15:20',1),('{750255CD-A786-4503-BD11-CCDACAAB836D}','{194288EC-52B9-492E-ABF9-CB3428BF5C42}','Sat','Working Day','19:00','07:00','2022-04-28 12:27:29',6,'2022-04-28 12:27:29',6),('{E26F8DFF-59C5-4AF3-AE2A-F2536C63BB42}','{1A781834-10C4-4830-946B-923C470C1539}','Thu','Working Day','17:00','08:00','2021-06-29 15:35:07',19,'2021-06-29 15:35:07',19),('{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','{1AEFFF55-B26B-4A9F-AC5D-48243551F4F9}','Sat','Working Day','20:00','08:00','2021-11-02 16:51:26',1,'2021-11-02 16:51:26',1),('{BCFC7D26-C85D-49F7-AC06-CA520DE4B5DC}','{1B7F70C3-1440-4657-AA70-C5F283547627}','Tue','Working Day','9:00','17:00','2021-11-02 16:51:36',1,'2021-11-02 16:51:36',1),('{5549525E-C8CC-4630-9940-A992323897BA}','{1DC4785C-83FE-4761-80C8-519E31915584}','Fri','Working Day','9:00','17:00','2021-11-05 16:16:18',1,'2021-11-05 16:16:18',1),('{08BFE024-66BC-445E-8F2C-B3CF1C980CD0}','{1E002014-4BB4-454C-B12B-E7BBB0213676}','Wed','Working Day','9:00','17:00','2020-12-16 13:41:18',3,'2020-12-16 13:41:18',3),('{9A8B3474-16CF-4DB5-95C1-798C5D6A92B1}','{1F693492-3A99-4B7A-9751-B29D63737BA9}','Wed','Working Day','09:00','17:00','2020-12-16 13:39:39',3,'2020-12-16 13:39:39',3),('{9A8B3474-16CF-4DB5-95C1-798C5D6A92B1}','{20349D08-4E97-4D87-A826-C8712B04FFD8}','Fri','Working Day','09:00','17:00','2020-12-16 13:39:39',3,'2020-12-16 13:39:39',3),('{FE43FAC7-E3B1-4491-A543-C7D9227D59E8}','{20E5A4C3-DE2C-47F3-8248-45D5B943C779}','Tue','Working Day','9:00','17:00','2021-03-03 10:11:51',1,'2021-03-03 10:11:51',1),('{C13B2D7B-3F42-4630-8943-72CE904DB128}','{24DBDB59-161F-4B1C-9F88-CC20DBAE5858}','Thu','Working Day','17:00','08:00','2021-03-03 10:11:46',1,'2021-03-03 10:11:46',1),('{FB6B21DE-7ACB-4CBF-B1BB-9673A7DA7BDA}','{2509F7A9-C9DB-494A-A51F-2190094E6B82}','Sun','Working Day','14:00','22:00','2018-08-18 09:42:56',1,NULL,NULL),('{FB6B21DE-7ACB-4CBF-B1BB-9673A7DA7BDA}','{2632CFB8-5CC2-41FC-8FFC-823AAC4F8A36}','Wed','Working Day','14:00','22:00','2018-08-18 09:42:56',1,NULL,NULL),('{9A8B3474-16CF-4DB5-95C1-798C5D6A92B1}','{26FE1610-9877-48C7-AB06-A2311586208F}','Mon','Working Day','09:00','17:00','2020-12-16 13:39:39',3,'2020-12-16 13:39:39',3),('{5549525E-C8CC-4630-9940-A992323897BA}','{27DC4025-5F0F-4DCA-A4AF-8A7A224B8FFF}','Sat','Holiday','0:00','0:00','2021-11-05 16:16:18',1,'2021-11-05 16:16:18',1),('{BCFC7D26-C85D-49F7-AC06-CA520DE4B5DC}','{2878F940-EB43-42F4-89A4-DF9C60ADF2B0}','Sun','Working Day','09:00','17:00','2021-11-02 16:51:36',1,'2021-11-02 16:51:36',1),('{400B6675-CB0E-448A-A066-159F67548B68}','{298B7E01-A983-4E18-8BBD-9AE8D9C25EDC}','Sat','Working Day','08:30','17:00','2020-12-16 13:39:03',3,'2020-12-16 13:39:03',3),('{DB7FEEE7-894C-481F-B63E-2E5CC0772CED}','{2A687F7F-1DD2-48FF-9AFB-078EA60B50A3}','Mon','Working Day','07:30','12:30','2020-12-16 13:38:55',3,'2020-12-16 13:38:55',3),('{DB7FEEE7-894C-481F-B63E-2E5CC0772CED}','{2BE081A6-7291-4332-B0E3-AEF3C6C6C11B}','Wed','Working Day','07:30','12:30','2020-12-16 13:38:55',3,'2020-12-16 13:38:55',3),('{7FAEB81B-C2E8-4ADA-97CB-3EAEB2C726DB}','{2C86BBD0-938A-445B-B104-6003310875FE}','Tue','Working Day','9:00','17:00','2018-07-09 12:24:06',1,NULL,NULL),('{F507C00F-DCE9-4341-87D5-1BC1C173A77E}','{2DEBB1A6-2AE3-4817-B139-D69243689FE5}','Sat','Working Day','09:00','17:00','2021-01-04 09:22:08',1,'2021-01-04 09:22:08',1),('{8DDA0E53-75F6-405E-82D0-F27B3779651F}','{2E7D9578-AA8E-4881-B3C0-EC544DC62ECD}','Thu','Working Day','08:15','14:00','2021-11-02 16:51:16',1,'2021-11-02 16:51:16',1),('{D6D0DCC3-7A5F-426C-A911-2995F91580A7}','{2E80BB2F-D5EC-4A5F-99D2-3D26583D5B24}','Sun','Working Day','09:00','17:00','2020-12-16 13:41:41',3,'2020-12-16 13:41:41',3),('{6366FF68-79E7-4D62-8267-DCE767F63E51}','{2E8D2E4A-94FB-4796-871D-83150FCD97DB}','Wed','Working Day','17:00','09:00','2020-12-16 13:41:35',3,'2020-12-16 13:41:35',3),('{7FAEB81B-C2E8-4ADA-97CB-3EAEB2C726DB}','{2FD3806E-2F82-4485-BF48-EEC718B7CCE6}','Fri','Working Day','9:00','17:00','2018-07-09 12:24:06',1,NULL,NULL),('{F2C42367-FDA9-400B-BB44-0FC9BA471412}','{33A6F81E-1F3B-4C75-8360-E3449A4235CB}','Wed','Working Day','08:00','20:00','2021-11-02 16:51:32',1,'2021-11-02 16:51:32',1),('{62BEC8B0-2850-42ED-8B84-3D130305D450}','{345E8BB0-866D-4CC0-A8DB-F1EF32408DC3}','Sat','Working Day','09:00','17:00','2020-12-16 13:41:57',3,'2020-12-16 13:41:57',3),('{62BEC8B0-2850-42ED-8B84-3D130305D450}','{35C54D87-9E18-47BC-AA37-E1B3B998B980}','Fri','Working Day','9:00','17:00','2020-12-16 13:41:57',3,'2020-12-16 13:41:57',3),('{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','{35DAF418-3ED7-4327-8AB5-4907C0D7441C}','Wed','Working Day','20:00','08:00','2021-11-02 16:51:26',1,'2021-11-02 16:51:26',1),('{8857CF67-3A87-4805-9DC9-9E9F6AB954B7}','{35FF9F86-1C0E-4ED6-A865-7D2DC6F23765}','Sat','Holiday','10:30','01:00','2022-01-13 15:16:31',3,'2022-01-13 15:16:31',3),('{7FAEB81B-C2E8-4ADA-97CB-3EAEB2C726DB}','{36D80BFE-3AA5-4245-B306-D43DA046106B}','Wed','Working Day','9:00','17:00','2018-07-09 12:24:06',1,NULL,NULL),('{D8507066-869E-4248-BC24-E2812694DF97}','{37163F51-54F1-44C6-95BC-9B0E5203A45C}','Thu','Working Day','07:00','15:00','2018-08-18 09:41:56',1,NULL,NULL),('{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','{39A2B40C-6D03-4A7B-9D37-24C9D80DBFF3}','Tue','Working Day','20:00','08:00','2021-11-02 16:51:26',1,'2021-11-02 16:51:26',1),('{400B6675-CB0E-448A-A066-159F67548B68}','{39ECC283-DF51-483A-8B84-579F52CE35C5}','Wed','Working Day','08:30','17:00','2020-12-16 13:39:03',3,'2020-12-16 13:39:03',3),('{08BFE024-66BC-445E-8F2C-B3CF1C980CD0}','{3AC412E4-C844-4B70-BA68-AD2FA39875B4}','Mon','Working Day','9:00','17:00','2020-12-16 13:41:18',3,'2020-12-16 13:41:18',3),('{2A3D53FF-72F9-4CC3-B79E-672C82C8326E}','{3C3F471D-E20F-4F38-9815-2B60859E7217}','Wed','Working Day','9:00','17:00','2018-07-09 12:24:45',1,NULL,NULL),('{62BEC8B0-2850-42ED-8B84-3D130305D450}','{3CF09341-1C1E-4AA5-9BB0-061D979745EE}','Wed','Working Day','9:00','17:00','2020-12-16 13:41:57',3,'2020-12-16 13:41:57',3),('{A8D05D73-9860-4A6C-B99B-E1E96971D12C}','{3D36FD2D-9B81-4332-AE4F-EB609EC5A398}','Mon','Working Day','9:00','17:00','2020-12-16 13:38:18',3,'2020-12-16 13:38:18',3),('{4EEA1AF8-0BAC-4634-8410-D3B68B57EA7A}','{3DC3B90E-1134-4A20-A4BC-CF36576109FB}','Sun','Holiday','0:00','0:00','2020-12-16 13:41:26',3,'2020-12-16 13:41:26',3),('{D8507066-869E-4248-BC24-E2812694DF97}','{40832063-216E-4B8C-9FAA-96F5A0EE305C}','Mon','Working Day','07:00','15:00','2018-08-18 09:41:56',1,NULL,NULL),('{FB6B21DE-7ACB-4CBF-B1BB-9673A7DA7BDA}','{40B2597D-719C-4BA8-A666-1CA2C8444E1F}','Tue','Working Day','14:00','22:00','2018-08-18 09:42:56',1,NULL,NULL),('{F0088DC9-9405-4252-BB7C-533A584CC92A}','{40F1C70F-C4DB-45F6-84A9-6EBFC35C46E7}','Sat','Working Day','09:00','17:00','2021-11-02 16:51:21',1,'2021-11-02 16:51:21',1),('{F0088DC9-9405-4252-BB7C-533A584CC92A}','{4197C2BB-13A1-4D44-B313-A8E2FF5A0CF3}','Fri','Working Day','9:00','17:00','2021-11-02 16:51:21',1,'2021-11-02 16:51:21',1),('{DB7FEEE7-894C-481F-B63E-2E5CC0772CED}','{4651E681-3F6B-4D31-AC17-EEC97039A383}','Fri','Working Day','07:30','12:30','2020-12-16 13:38:55',3,'2020-12-16 13:38:55',3),('{8857CF67-3A87-4805-9DC9-9E9F6AB954B7}','{466D2C18-8BDE-4545-B5CD-AB460557A665}','Tue','Working Day','10:30','01:00','2022-01-13 15:16:31',3,'2022-01-13 15:16:31',3),('{8DDA0E53-75F6-405E-82D0-F27B3779651F}','{469F000F-D858-4312-8BD6-5806C23B32D6}','Tue','Holiday','00:00','00:00','2021-11-02 16:51:16',1,'2021-11-02 16:51:16',1),('{FE43FAC7-E3B1-4491-A543-C7D9227D59E8}','{474CCC3E-4321-44B3-B849-D5AD3903217C}','Wed','Working Day','9:00','17:00','2021-03-03 10:11:51',1,'2021-03-03 10:11:51',1),('{BCA835BE-C1CC-423D-A219-8AB800EC7DC3}','{482DD456-D809-426A-A47B-8D93928773B1}','Sat','Working Day','08:00','13:00','2021-06-29 15:35:00',19,'2021-06-29 15:35:00',19),('{400B6675-CB0E-448A-A066-159F67548B68}','{486C0C95-FCC2-4B93-8054-77B0B2CDF6AA}','Thu','Working Day','08:30','17:00','2020-12-16 13:39:03',3,'2020-12-16 13:39:03',3),('{F0088DC9-9405-4252-BB7C-533A584CC92A}','{4962DD86-2A19-4846-8D1E-01D03AB5A195}','Sun','Working Day','09:00','17:00','2021-11-02 16:51:21',1,'2021-11-02 16:51:21',1),('{400B6675-CB0E-448A-A066-159F67548B68}','{498445AA-616E-40E8-A909-0D4B13DD1218}','Mon','Working Day','08:30','17:00','2020-12-16 13:39:03',3,'2020-12-16 13:39:03',3),('{D6D0DCC3-7A5F-426C-A911-2995F91580A7}','{4989AB3B-DC88-403B-BBF7-18CA1211F8AE}','Mon','Working Day','9:00','17:00','2020-12-16 13:41:41',3,'2020-12-16 13:41:41',3),('{794D4115-0CD2-404A-B989-91D7C25BCA36}','{4BA64309-3E6A-46A8-9613-13FC3748CB66}','Thu','Working Day','9:00','17:00','2021-11-05 16:15:20',1,'2021-11-05 16:15:20',1),('{C4451DF5-FEC3-47A9-9192-6B2EB6C8FD67}','{4C13FA59-B5DC-4B53-9211-9EE1A7A0C6F3}','Mon','Working Day','07:00','19:00','2022-04-28 12:26:36',6,'2022-04-28 12:26:36',6),('{A8D05D73-9860-4A6C-B99B-E1E96971D12C}','{4C5CA369-DBF9-4731-B161-676983783FA7}','Sat','Working Day','09:00','13:00','2020-12-16 13:38:18',3,'2020-12-16 13:38:18',3),('{FB6B21DE-7ACB-4CBF-B1BB-9673A7DA7BDA}','{4CEA959F-CFCC-43AC-82A0-10DF8EA4C7A6}','Thu','Working Day','14:00','22:00','2018-08-18 09:42:56',1,NULL,NULL),('{62BEC8B0-2850-42ED-8B84-3D130305D450}','{4D9F3544-686A-4D32-8A2E-326B00E3F643}','Thu','Working Day','9:00','17:00','2020-12-16 13:41:57',3,'2020-12-16 13:41:57',3),('{794D4115-0CD2-404A-B989-91D7C25BCA36}','{52FA93ED-7C2B-40C8-8EA5-4FFF5D8F137D}','Sat','Working Day','09:00','17:00','2021-11-05 16:15:20',1,'2021-11-05 16:15:20',1),('{137BAE1A-D2AD-45D0-AF31-E4EB8FA85C18}','{545E84CE-95FF-4663-8CD3-C08A48946CBF}','Wed','Working Day','17:00','09:00','2021-01-04 09:22:14',1,'2021-01-04 09:22:14',1),('{D8507066-869E-4248-BC24-E2812694DF97}','{557B2CE3-0377-42E5-821F-044CAC6CCA0A}','Fri','Working Day','07:00','15:00','2018-08-18 09:41:56',1,NULL,NULL),('{F2C42367-FDA9-400B-BB44-0FC9BA471412}','{58CBCEC1-EB2C-435F-B3D5-04A41383EBD8}','Fri','Working Day','08:00','20:00','2021-11-02 16:51:32',1,'2021-11-02 16:51:32',1),('{FE43FAC7-E3B1-4491-A543-C7D9227D59E8}','{5BCD1808-31ED-4397-913B-59A35EA0E9B1}','Sun','Holiday','09:00','17:00','2021-03-03 10:11:51',1,'2021-03-03 10:11:51',1),('{C4451DF5-FEC3-47A9-9192-6B2EB6C8FD67}','{5D01365C-49EE-4C71-B6F5-0E8711BFBB47}','Fri','Working Day','07:00','19:00','2022-04-28 12:26:36',6,'2022-04-28 12:26:36',6),('{2DCB3B70-B8A6-4E8A-981B-946E331C8C28}','{5D84B883-951E-4EF8-9CC7-9E2D76242CA7}','Sat','Working Day','09:00','17:00','2021-06-29 15:35:16',19,'2021-06-29 15:35:16',19),('{F2C42367-FDA9-400B-BB44-0FC9BA471412}','{5E0B7BB7-AB65-41C2-A9EB-3332F03A8416}','Sun','Holiday','00:00','00:00','2021-11-02 16:51:32',1,'2021-11-02 16:51:32',1),('{BCA835BE-C1CC-423D-A219-8AB800EC7DC3}','{5E12D2D4-948D-4B16-9FD1-15B427EA7106}','Thu','Working Day','08:00','13:00','2021-06-29 15:35:00',19,'2021-06-29 15:35:00',19),('{FE43FAC7-E3B1-4491-A543-C7D9227D59E8}','{5E6D90F3-E469-4E40-8E6A-8E0390D32383}','Thu','Working Day','9:00','17:00','2021-03-03 10:11:51',1,'2021-03-03 10:11:51',1),('{FE43FAC7-E3B1-4491-A543-C7D9227D59E8}','{628CC07C-34D1-4AE2-9D61-D1C1B05BF27D}','Sat','Working Day','09:00','17:00','2021-03-03 10:11:51',1,'2021-03-03 10:11:51',1),('{2DCB3B70-B8A6-4E8A-981B-946E331C8C28}','{62BA7B85-EF6C-4081-81C8-5C5E9D0837E7}','Wed','Working Day','9:00','17:00','2021-06-29 15:35:16',19,'2021-06-29 15:35:16',19),('{62BEC8B0-2850-42ED-8B84-3D130305D450}','{62F5D319-16FD-4C0B-B5C8-F279353F234C}','Tue','Working Day','9:00','17:00','2020-12-16 13:41:57',3,'2020-12-16 13:41:57',3),('{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','{65651D36-0C05-45B7-B9FE-79234D7C3430}','Mon','Working Day','20:00','08:00','2021-11-02 16:51:26',1,'2021-11-02 16:51:26',1),('{8857CF67-3A87-4805-9DC9-9E9F6AB954B7}','{66033BE6-B335-4FA2-8315-0FDE2127A295}','Fri','Working Day','10:30','01:00','2022-01-13 15:16:31',3,'2022-01-13 15:16:31',3),('{794D4115-0CD2-404A-B989-91D7C25BCA36}','{66D392D9-A920-4E6F-85C0-28121479F609}','Fri','Working Day','9:00','17:00','2021-11-05 16:15:20',1,'2021-11-05 16:15:20',1),('{137BAE1A-D2AD-45D0-AF31-E4EB8FA85C18}','{68CC040F-A1F1-4F61-BFA5-36D2AF52F6C8}','Sun','Holiday','00:00','00:00','2021-01-04 09:22:14',1,'2021-01-04 09:22:14',1),('{08BFE024-66BC-445E-8F2C-B3CF1C980CD0}','{69DD3C8D-8F6F-468B-AE72-1C7EB4F6E17A}','Tue','Working Day','9:00','17:00','2020-12-16 13:41:18',3,'2020-12-16 13:41:18',3),('{750255CD-A786-4503-BD11-CCDACAAB836D}','{6A7FBE60-3E71-4F3D-B045-D6E716C1BA4B}','Tue','Working Day','19:00','07:00','2022-04-28 12:27:29',6,'2022-04-28 12:27:29',6),('{E26F8DFF-59C5-4AF3-AE2A-F2536C63BB42}','{6C61A277-BE9B-4800-8B69-754A732751B1}','Sun','Working Day','17:00','08:00','2021-06-29 15:35:07',19,'2021-06-29 15:35:07',19),('{7FAEB81B-C2E8-4ADA-97CB-3EAEB2C726DB}','{6D1BACE8-8C64-40F7-8AA0-6EE1FF796574}','Mon','Working Day','9:00','17:00','2018-07-09 12:24:06',1,NULL,NULL),('{DB7FEEE7-894C-481F-B63E-2E5CC0772CED}','{6D1FA896-EFC0-4166-B68B-5E408EE44C5C}','Sun','Holiday','0:00','0:00','2020-12-16 13:38:55',3,'2020-12-16 13:38:55',3),('{A8D05D73-9860-4A6C-B99B-E1E96971D12C}','{6F56CDC5-00B7-4E63-8F3A-863838ED773C}','Wed','Working Day','9:00','17:00','2020-12-16 13:38:18',3,'2020-12-16 13:38:18',3),('{2DCB3B70-B8A6-4E8A-981B-946E331C8C28}','{710BD66E-CBAE-413D-8EE5-DC75F0C01CF4}','Fri','Working Day','9:00','17:00','2021-06-29 15:35:16',19,'2021-06-29 15:35:16',19),('{E26F8DFF-59C5-4AF3-AE2A-F2536C63BB42}','{72152054-327C-4646-85D2-921AABC473BB}','Fri','Working Day','17:00','08:00','2021-06-29 15:35:07',19,'2021-06-29 15:35:07',19),('{F507C00F-DCE9-4341-87D5-1BC1C173A77E}','{750A519B-E81F-4786-83C2-2CF420AE406D}','Mon','Working Day','9:00','17:00','2021-01-04 09:22:08',1,'2021-01-04 09:22:08',1),('{C13B2D7B-3F42-4630-8943-72CE904DB128}','{75376A35-0268-490A-B1D1-A79BD8DFC0AC}','Fri','Working Day','17:00','08:00','2021-03-03 10:11:46',1,'2021-03-03 10:11:46',1),('{750255CD-A786-4503-BD11-CCDACAAB836D}','{7699209C-71F6-4EE1-8D6B-300DAAA05709}','Wed','Working Day','19:00','07:00','2022-04-28 12:27:29',6,'2022-04-28 12:27:29',6),('{F2C42367-FDA9-400B-BB44-0FC9BA471412}','{77130903-E2C1-4C76-B8F5-1F95441731D2}','Tue','Working Day','08:00','20:00','2021-11-02 16:51:32',1,'2021-11-02 16:51:32',1),('{C13B2D7B-3F42-4630-8943-72CE904DB128}','{77393458-B275-4C73-80E0-E01F5710D0FA}','Mon','Working Day','17:00','08:00','2021-03-03 10:11:46',1,'2021-03-03 10:11:46',1),('{2DCB3B70-B8A6-4E8A-981B-946E331C8C28}','{791427D0-D6C9-4F8E-880B-B4026DB32A23}','Thu','Working Day','9:00','17:00','2021-06-29 15:35:16',19,'2021-06-29 15:35:16',19),('{F507C00F-DCE9-4341-87D5-1BC1C173A77E}','{7F8195DD-182E-46D8-94A8-7251B06F6BAD}','Fri','Working Day','9:00','17:00','2021-01-04 09:22:08',1,'2021-01-04 09:22:08',1),('{9A8B3474-16CF-4DB5-95C1-798C5D6A92B1}','{81A24177-7BE6-47F4-897A-DCA44638A3FE}','Thu','Working Day','09:00','17:00','2020-12-16 13:39:39',3,'2020-12-16 13:39:39',3),('{C13B2D7B-3F42-4630-8943-72CE904DB128}','{82666D9E-D46B-43ED-BD44-DA82350610BE}','Wed','Working Day','17:00','08:00','2021-03-03 10:11:46',1,'2021-03-03 10:11:46',1),('{E26F8DFF-59C5-4AF3-AE2A-F2536C63BB42}','{82D6BA85-2032-4EB1-BC28-6C2D11E3412D}','Sat','Working Day','17:00','08:00','2021-06-29 15:35:07',19,'2021-06-29 15:35:07',19),('{BCFC7D26-C85D-49F7-AC06-CA520DE4B5DC}','{83A207A1-D8D7-46DF-8B11-E6972F4D8758}','Mon','Working Day','9:00','17:00','2021-11-02 16:51:36',1,'2021-11-02 16:51:36',1),('{794D4115-0CD2-404A-B989-91D7C25BCA36}','{848703A1-B83D-41CA-BF71-7D4E0868F79B}','Sun','Holiday','0:00','0:00','2021-11-05 16:15:20',1,'2021-11-05 16:15:20',1),('{8DDA0E53-75F6-405E-82D0-F27B3779651F}','{8617CD1B-14B9-47E3-9CC2-E8D362048855}','Sun','Working Day','08:15','14:00','2021-11-02 16:51:16',1,'2021-11-02 16:51:16',1),('{7FAEB81B-C2E8-4ADA-97CB-3EAEB2C726DB}','{8626EEAF-710B-4215-AB5F-B91D54B115D3}','Thu','Working Day','9:00','17:00','2018-07-09 12:24:06',1,NULL,NULL),('{4EEA1AF8-0BAC-4634-8410-D3B68B57EA7A}','{8738DF2D-F579-4985-B5C0-49400B69F6B0}','Wed','Working Day','9:00','17:00','2020-12-16 13:41:26',3,'2020-12-16 13:41:26',3),('{400B6675-CB0E-448A-A066-159F67548B68}','{875BBFFD-25A8-46EF-946C-B68814EF458B}','Fri','Working Day','08:30','17:00','2020-12-16 13:39:03',3,'2020-12-16 13:39:03',3),('{5549525E-C8CC-4630-9940-A992323897BA}','{8764ADAE-8CC7-4ED9-BD2A-BFC5A0CC75C0}','Sun','Holiday','0:00','0:00','2021-11-05 16:16:18',1,'2021-11-05 16:16:18',1),('{D8507066-869E-4248-BC24-E2812694DF97}','{88F53666-DE38-428E-90CC-78510DE6D3A8}','Sun','Working Day','07:00','15:00','2018-08-18 09:41:56',1,NULL,NULL),('{2A3D53FF-72F9-4CC3-B79E-672C82C8326E}','{8BD7FE45-4970-4EA9-9C38-101A8C1CACBB}','Mon','Working Day','9:00','17:00','2018-07-09 12:24:45',1,NULL,NULL),('{8DDA0E53-75F6-405E-82D0-F27B3779651F}','{8C38D4F4-97E9-46AC-9652-5F79ED01D760}','Sat','Working Day','08:15','14:00','2021-11-02 16:51:16',1,'2021-11-02 16:51:16',1),('{6366FF68-79E7-4D62-8267-DCE767F63E51}','{8CFFF330-A518-41E8-ADD5-F805C79F2127}','Sun','Working Day','17:00','09:00','2020-12-16 13:41:35',3,'2020-12-16 13:41:35',3),('{D6D0DCC3-7A5F-426C-A911-2995F91580A7}','{8DD2F120-318F-4A25-A123-5CC66C5CA522}','Fri','Working Day','9:00','17:00','2020-12-16 13:41:41',3,'2020-12-16 13:41:41',3),('{9A8B3474-16CF-4DB5-95C1-798C5D6A92B1}','{903B2382-317F-4406-A28C-CEF1A98879C2}','Sun','Holiday','0:00','0:00','2020-12-16 13:39:39',3,'2020-12-16 13:39:39',3),('{BCA835BE-C1CC-423D-A219-8AB800EC7DC3}','{907C29CB-F9A9-403F-A312-2409F6F37C2E}','Sun','Holiday','0:00','0:00','2021-06-29 15:35:00',19,'2021-06-29 15:35:00',19),('{BCFC7D26-C85D-49F7-AC06-CA520DE4B5DC}','{90AD99C0-2269-4344-A4FE-3BF2980B473E}','Sat','Working Day','09:00','17:00','2021-11-02 16:51:36',1,'2021-11-02 16:51:36',1),('{BCFC7D26-C85D-49F7-AC06-CA520DE4B5DC}','{927C9939-8661-42FC-9A13-5B02E08AB1E8}','Fri','Working Day','9:00','17:00','2021-11-02 16:51:36',1,'2021-11-02 16:51:36',1),('{BCA835BE-C1CC-423D-A219-8AB800EC7DC3}','{93D67EE7-81CC-4C4E-A7D0-682129A74C1E}','Mon','Working Day','08:00','13:00','2021-06-29 15:35:00',19,'2021-06-29 15:35:00',19),('{2A3D53FF-72F9-4CC3-B79E-672C82C8326E}','{95263549-755E-4BC0-8517-3880E5C229B3}','Fri','Working Day','9:00','17:00','2018-07-09 12:24:45',1,NULL,NULL),('{FE43FAC7-E3B1-4491-A543-C7D9227D59E8}','{95ECFD3B-0DFE-4F53-A375-125E7291CA14}','Fri','Working Day','9:00','17:00','2021-03-03 10:11:51',1,'2021-03-03 10:11:51',1),('{FB6B21DE-7ACB-4CBF-B1BB-9673A7DA7BDA}','{960EBF94-09A0-4ACB-B05E-1ABB71AEA29E}','Mon','Working Day','14:00','22:00','2018-08-18 09:42:56',1,NULL,NULL),('{D6D0DCC3-7A5F-426C-A911-2995F91580A7}','{9C632BE0-60D9-413E-B962-FE3210813E9D}','Thu','Working Day','9:00','17:00','2020-12-16 13:41:41',3,'2020-12-16 13:41:41',3),('{6366FF68-79E7-4D62-8267-DCE767F63E51}','{9E03048B-807F-4C55-A04B-171B0B96468F}','Mon','Working Day','17:00','09:00','2020-12-16 13:41:35',3,'2020-12-16 13:41:35',3),('{5549525E-C8CC-4630-9940-A992323897BA}','{9E6E24BF-121E-436E-8BEC-8E1B943F333E}','Wed','Working Day','9:00','17:00','2021-11-05 16:16:18',1,'2021-11-05 16:16:18',1),('{750255CD-A786-4503-BD11-CCDACAAB836D}','{9EEFFBE1-B9A8-4FDE-9E13-7E8363BAEA01}','Sun','Working Day','19:00','07:00','2022-04-28 12:27:29',6,'2022-04-28 12:27:29',6),('{E26F8DFF-59C5-4AF3-AE2A-F2536C63BB42}','{9FD9DF1D-70C1-4525-BEBA-1C6FE6961B50}','Mon','Working Day','17:00','08:00','2021-06-29 15:35:07',19,'2021-06-29 15:35:07',19),('{FE43FAC7-E3B1-4491-A543-C7D9227D59E8}','{A1358EF9-C307-49E0-AB79-DB3B1DD484B7}','Mon','Working Day','9:00','17:00','2021-03-03 10:11:51',1,'2021-03-03 10:11:51',1),('{137BAE1A-D2AD-45D0-AF31-E4EB8FA85C18}','{A2A87325-307F-421B-B8DA-9A8D13E5CCA9}','Sat','Holiday','17:00','09:00','2021-01-04 09:22:14',1,'2021-01-04 09:22:14',1),('{5549525E-C8CC-4630-9940-A992323897BA}','{A30B4CCE-8BCB-4904-8FAB-A5FE2D74EDA0}','Thu','Working Day','9:00','17:00','2021-11-05 16:16:18',1,'2021-11-05 16:16:18',1),('{C13B2D7B-3F42-4630-8943-72CE904DB128}','{A3C6A395-DEC1-43D7-87ED-05298C934039}','Sun','Holiday','17:00','08:00','2021-03-03 10:11:46',1,'2021-03-03 10:11:46',1),('{FB6B21DE-7ACB-4CBF-B1BB-9673A7DA7BDA}','{A65DBD4A-CA9E-4C20-A163-541180042255}','Fri','Working Day','14:00','22:00','2018-08-18 09:42:56',1,NULL,NULL),('{8DDA0E53-75F6-405E-82D0-F27B3779651F}','{AA0FAFE2-074A-42E0-A321-95EA64DD7900}','Mon','Working Day','08:15','14:00','2021-11-02 16:51:16',1,'2021-11-02 16:51:16',1),('{794D4115-0CD2-404A-B989-91D7C25BCA36}','{AA7FB31E-0035-4B0F-AA83-B7B40571F369}','Wed','Working Day','9:00','17:00','2021-11-05 16:15:20',1,'2021-11-05 16:15:20',1),('{4EEA1AF8-0BAC-4634-8410-D3B68B57EA7A}','{AD4CAF33-9CFC-4DF1-95F2-A7C39A7CF1A8}','Thu','Working Day','9:00','17:00','2020-12-16 13:41:26',3,'2020-12-16 13:41:26',3),('{2DCB3B70-B8A6-4E8A-981B-946E331C8C28}','{AE32CCF7-0D3E-4FA0-89C0-5515DD305A0F}','Tue','Working Day','9:00','17:00','2021-06-29 15:35:16',19,'2021-06-29 15:35:16',19),('{400B6675-CB0E-448A-A066-159F67548B68}','{B0BA36E3-6E0B-4747-B45A-358EC350B823}','Sun','Holiday','0:00','0:00','2020-12-16 13:39:03',3,'2020-12-16 13:39:03',3),('{F0088DC9-9405-4252-BB7C-533A584CC92A}','{B14F8154-5A35-4869-A4A5-77752216FA85}','Mon','Working Day','09:00','17:00','2021-11-02 16:51:21',1,'2021-11-02 16:51:21',1),('{62BEC8B0-2850-42ED-8B84-3D130305D450}','{B19DB31C-7744-4043-9084-DB41FA986C3F}','Mon','Working Day','9:00','17:00','2020-12-16 13:41:57',3,'2020-12-16 13:41:57',3),('{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','{B1FB2BFE-B4BD-420A-8B59-EDA1D9E2167F}','Fri','Working Day','20:00','08:00','2021-11-02 16:51:26',1,'2021-11-02 16:51:26',1),('{C13B2D7B-3F42-4630-8943-72CE904DB128}','{B391B30F-726A-49BB-B98C-818C1463F6BB}','Sat','Working Day','17:00','08:00','2021-03-03 10:11:46',1,'2021-03-03 10:11:46',1),('{F507C00F-DCE9-4341-87D5-1BC1C173A77E}','{B3929989-5F96-4615-B478-1F7CAE05B7C6}','Tue','Working Day','9:00','17:00','2021-01-04 09:22:08',1,'2021-01-04 09:22:08',1),('{8857CF67-3A87-4805-9DC9-9E9F6AB954B7}','{B4083EAA-73DB-4072-A69B-23B09056BB49}','Mon','Working Day','10:30','01:00','2022-01-13 15:16:31',3,'2022-01-13 15:16:31',3),('{C4451DF5-FEC3-47A9-9192-6B2EB6C8FD67}','{B48E538B-83B2-4DBB-B9E1-27FB3365D996}','Sun','Working Day','07:00','19:00','2022-04-28 12:26:36',6,'2022-04-28 12:26:36',6),('{137BAE1A-D2AD-45D0-AF31-E4EB8FA85C18}','{B51C3B30-F499-4B06-8C31-D0E461D0B3A2}','Mon','Working Day','17:00','09:00','2021-01-04 09:22:14',1,'2021-01-04 09:22:14',1),('{BCFC7D26-C85D-49F7-AC06-CA520DE4B5DC}','{B549C765-4EE9-469A-8369-7AC3FF492ED2}','Thu','Working Day','9:00','17:00','2021-11-02 16:51:36',1,'2021-11-02 16:51:36',1),('{9A8B3474-16CF-4DB5-95C1-798C5D6A92B1}','{B56AB70F-0841-4B61-A758-6DE0DC4468AB}','Sat','Working Day','09:00','13:00','2020-12-16 13:39:39',3,'2020-12-16 13:39:39',3),('{2A3D53FF-72F9-4CC3-B79E-672C82C8326E}','{B62AC3E1-4DAD-4FF3-8E0D-F6B73515DFB9}','Tue','Working Day','9:00','17:00','2018-07-09 12:24:45',1,NULL,NULL),('{750255CD-A786-4503-BD11-CCDACAAB836D}','{B6D847B2-F870-4661-A73A-1C189F45E071}','Fri','Working Day','19:00','07:00','2022-04-28 12:27:29',6,'2022-04-28 12:27:29',6),('{ADC4DFD1-211D-4BBE-A9CC-5665F947583C}','{B94AF171-8EF4-43CA-92AD-7458455798AA}','Sat','Working Day','09:00','17:00','2020-12-16 13:38:25',3,'2020-12-16 13:38:25',3),('{137BAE1A-D2AD-45D0-AF31-E4EB8FA85C18}','{BA6E52F1-3996-48DB-8BB0-BD8CE6F0C42A}','Thu','Working Day','17:00','09:00','2021-01-04 09:22:14',1,'2021-01-04 09:22:14',1),('{A8D05D73-9860-4A6C-B99B-E1E96971D12C}','{BBA893AD-A2D5-4F15-991A-6345B56F4E45}','Tue','Working Day','9:00','17:00','2020-12-16 13:38:18',3,'2020-12-16 13:38:18',3),('{6366FF68-79E7-4D62-8267-DCE767F63E51}','{BBBD589A-5FE8-456C-8C0D-24FE06BA9E00}','Fri','Working Day','17:00','09:00','2020-12-16 13:41:35',3,'2020-12-16 13:41:35',3),('{8857CF67-3A87-4805-9DC9-9E9F6AB954B7}','{BD641C4A-DD9C-4610-A84D-32A4B3C332C1}','Sun','Holiday','0:00','0:00','2022-01-13 15:16:31',3,'2022-01-13 15:16:31',3),('{A8D05D73-9860-4A6C-B99B-E1E96971D12C}','{BEB47B08-9808-4B9D-B19A-76F44E5CD936}','Thu','Working Day','9:00','17:00','2020-12-16 13:38:18',3,'2020-12-16 13:38:18',3),('{5549525E-C8CC-4630-9940-A992323897BA}','{BF85638B-3A77-42B0-882F-A7474DBB5F8F}','Tue','Working Day','9:00','17:00','2021-11-05 16:16:18',1,'2021-11-05 16:16:18',1),('{ADC4DFD1-211D-4BBE-A9CC-5665F947583C}','{C6F1A0E1-817D-4751-BE20-A53C70E29DCA}','Sun','Holiday','0:00','0:00','2020-12-16 13:38:25',3,'2020-12-16 13:38:25',3),('{7FAEB81B-C2E8-4ADA-97CB-3EAEB2C726DB}','{C8F527B6-08AA-4ECF-9290-EDDCBB409BDB}','Sat','Working Day','09:00','17:00','2018-07-09 12:24:06',1,NULL,NULL),('{4EEA1AF8-0BAC-4634-8410-D3B68B57EA7A}','{CB9A99F5-8848-4BA7-B301-B090DAF6A8AE}','Mon','Working Day','9:00','17:00','2020-12-16 13:41:26',3,'2020-12-16 13:41:26',3),('{F507C00F-DCE9-4341-87D5-1BC1C173A77E}','{CD4DB97A-DD92-429F-8E48-536B35B65DDC}','Wed','Working Day','9:00','17:00','2021-01-04 09:22:08',1,'2021-01-04 09:22:08',1),('{BCA835BE-C1CC-423D-A219-8AB800EC7DC3}','{CED02962-097F-44CA-8BB5-949010FB907B}','Tue','Working Day','08:00','13:00','2021-06-29 15:35:00',19,'2021-06-29 15:35:00',19),('{8857CF67-3A87-4805-9DC9-9E9F6AB954B7}','{D1A0D642-7865-49C6-89DF-5DFF0F407BE8}','Wed','Working Day','10:30','01:00','2022-01-13 15:16:31',3,'2022-01-13 15:16:31',3),('{137BAE1A-D2AD-45D0-AF31-E4EB8FA85C18}','{D225E2D1-536E-4F0A-9000-297531B58F02}','Fri','Working Day','17:00','09:00','2021-01-04 09:22:14',1,'2021-01-04 09:22:14',1),('{7FAEB81B-C2E8-4ADA-97CB-3EAEB2C726DB}','{D2457C1E-FCC9-4147-AF64-B016600D1A06}','Sun','Holiday','0:00','0:00','2018-07-09 12:24:06',1,NULL,NULL),('{F2C42367-FDA9-400B-BB44-0FC9BA471412}','{D2619DE4-BAAD-4A47-8151-3CCDE01C2AE4}','Sat','Working Day','08:00','20:00','2021-11-02 16:51:32',1,'2021-11-02 16:51:32',1),('{6366FF68-79E7-4D62-8267-DCE767F63E51}','{D6709266-1AAA-4BFC-A9D3-1DDFF73391B5}','Tue','Working Day','17:00','09:00','2020-12-16 13:41:35',3,'2020-12-16 13:41:35',3),('{C4451DF5-FEC3-47A9-9192-6B2EB6C8FD67}','{D7818C67-C0A4-41A0-BD54-130698E4BBB0}','Sat','Working Day','07:00','19:00','2022-04-28 12:26:36',6,'2022-04-28 12:26:36',6),('{A8D05D73-9860-4A6C-B99B-E1E96971D12C}','{D78923FD-E531-4776-BE59-6F76BE3511B2}','Fri','Working Day','9:00','17:00','2020-12-16 13:38:18',3,'2020-12-16 13:38:18',3),('{6366FF68-79E7-4D62-8267-DCE767F63E51}','{D85D6FF6-25A7-4F45-A0C3-C9956E7083F9}','Thu','Working Day','17:00','09:00','2020-12-16 13:41:35',3,'2020-12-16 13:41:35',3),('{08BFE024-66BC-445E-8F2C-B3CF1C980CD0}','{D8C7BA73-DDAE-4576-B303-82BEB4E4B825}','Sat','Working Day','09:00','14:00','2020-12-16 13:41:18',3,'2020-12-16 13:41:18',3),('{ADC4DFD1-211D-4BBE-A9CC-5665F947583C}','{DA230A60-7D24-4DEE-B9BF-DADA968708AD}','Fri','Working Day','9:00','17:00','2020-12-16 13:38:25',3,'2020-12-16 13:38:25',3),('{2DCB3B70-B8A6-4E8A-981B-946E331C8C28}','{DA451BE0-B57E-4018-933B-B1BC8615264E}','Sun','Holiday','0:00','0:00','2021-06-29 15:35:16',19,'2021-06-29 15:35:16',19),('{ADC4DFD1-211D-4BBE-A9CC-5665F947583C}','{DBE25B8F-958E-4378-864B-4E70AC4FEF91}','Thu','Working Day','9:00','17:00','2020-12-16 13:38:25',3,'2020-12-16 13:38:25',3),('{137BAE1A-D2AD-45D0-AF31-E4EB8FA85C18}','{DC952966-B5AB-4D34-94A2-AC89835755D0}','Tue','Working Day','17:00','09:00','2021-01-04 09:22:14',1,'2021-01-04 09:22:14',1),('{4EEA1AF8-0BAC-4634-8410-D3B68B57EA7A}','{DD087E98-CEC2-41EB-97B8-ED68178EA33E}','Tue','Working Day','9:00','17:00','2020-12-16 13:41:26',3,'2020-12-16 13:41:26',3),('{2A3D53FF-72F9-4CC3-B79E-672C82C8326E}','{DD933951-1A29-424F-B08E-9B3A63E338E9}','Thu','Working Day','9:00','17:00','2018-07-09 12:24:45',1,NULL,NULL),('{D8507066-869E-4248-BC24-E2812694DF97}','{DDA0E3B2-71B1-4F7B-A71A-3BE4B9EEEFA0}','Wed','Working Day','07:00','15:00','2018-08-18 09:41:56',1,NULL,NULL),('{E26F8DFF-59C5-4AF3-AE2A-F2536C63BB42}','{DE75401A-7531-4322-9687-E91E733FCD34}','Wed','Working Day','17:00','08:00','2021-06-29 15:35:07',19,'2021-06-29 15:35:07',19),('{2A3D53FF-72F9-4CC3-B79E-672C82C8326E}','{DF7A8304-8763-48DC-98BF-5F8B28926322}','Sat','Working Day','09:00','17:00','2018-07-09 12:24:45',1,NULL,NULL),('{750255CD-A786-4503-BD11-CCDACAAB836D}','{E02EBD68-34A0-4561-B460-B0B24A951019}','Thu','Working Day','19:00','07:00','2022-04-28 12:27:29',6,'2022-04-28 12:27:29',6),('{4EEA1AF8-0BAC-4634-8410-D3B68B57EA7A}','{E22A21D5-E709-4D3D-A242-E8C3ECD7EFCF}','Sat','Holiday','09:00','14:00','2020-12-16 13:41:26',3,'2020-12-16 13:41:26',3),('{6366FF68-79E7-4D62-8267-DCE767F63E51}','{E27486A0-FB61-442B-9322-59A2789DD6D4}','Sat','Working Day','17:00','09:00','2020-12-16 13:41:35',3,'2020-12-16 13:41:35',3),('{C4451DF5-FEC3-47A9-9192-6B2EB6C8FD67}','{E2F91A3E-9F43-4B17-90EA-7EC561A9A106}','Tue','Working Day','07:00','19:00','2022-04-28 12:26:36',6,'2022-04-28 12:26:36',6),('{FB6B21DE-7ACB-4CBF-B1BB-9673A7DA7BDA}','{E30BFEAD-29F6-4A67-A7B1-ED7119C976F1}','Sat','Working Day','14:00','22:00','2018-08-18 09:42:56',1,NULL,NULL),('{F0088DC9-9405-4252-BB7C-533A584CC92A}','{E78E58C5-3940-4857-9B2D-92AACD2B8EFC}','Wed','Working Day','09:00','17:00','2021-11-02 16:51:21',1,'2021-11-02 16:51:21',1),('{D6D0DCC3-7A5F-426C-A911-2995F91580A7}','{EAB3756E-AB89-483A-B601-BA5ECC4DAD54}','Wed','Working Day','9:00','17:00','2020-12-16 13:41:41',3,'2020-12-16 13:41:41',3),('{08BFE024-66BC-445E-8F2C-B3CF1C980CD0}','{EE66FF5C-8C99-4DDD-8EE7-2F5936D9D874}','Thu','Working Day','9:00','17:00','2020-12-16 13:41:18',3,'2020-12-16 13:41:18',3),('{C4451DF5-FEC3-47A9-9192-6B2EB6C8FD67}','{EF0C5B64-52C9-4A36-9EEF-89C4C311D6BC}','Thu','Working Day','07:00','19:00','2022-04-28 12:26:36',6,'2022-04-28 12:26:36',6),('{62BEC8B0-2850-42ED-8B84-3D130305D450}','{EF14F1A0-A714-4294-A399-F73532503C7F}','Sun','Holiday','0:00','0:00','2020-12-16 13:41:57',3,'2020-12-16 13:41:57',3),('{BCA835BE-C1CC-423D-A219-8AB800EC7DC3}','{F2444821-F679-4A48-B48C-2F7C4F14A5C4}','Wed','Working Day','08:00','13:00','2021-06-29 15:35:00',19,'2021-06-29 15:35:00',19),('{F0088DC9-9405-4252-BB7C-533A584CC92A}','{F4DA3309-8AC0-4BE7-878D-ABB0113596FA}','Tue','Working Day','09:00','17:00','2021-11-02 16:51:21',1,'2021-11-02 16:51:21',1),('{ADC4DFD1-211D-4BBE-A9CC-5665F947583C}','{F5A6352B-DA17-4EC3-AC7E-AFB80357B1FE}','Mon','Working Day','9:00','17:00','2020-12-16 13:38:25',3,'2020-12-16 13:38:25',3),('{D6D0DCC3-7A5F-426C-A911-2995F91580A7}','{F683CE66-CE4A-413F-A2F6-F9EE07F1F9F7}','Sat','Working Day','09:00','17:00','2020-12-16 13:41:41',3,'2020-12-16 13:41:41',3),('{5549525E-C8CC-4630-9940-A992323897BA}','{F72A137B-079C-4553-AF2E-B0420D63B7DE}','Mon','Working Day','9:00','17:00','2021-11-05 16:16:18',1,'2021-11-05 16:16:18',1),('{8DDA0E53-75F6-405E-82D0-F27B3779651F}','{F787C4C9-0626-42AC-AC19-6A2FBA5A8D47}','Fri','Working Day','08:15','14:00','2021-11-02 16:51:16',1,'2021-11-02 16:51:16',1),('{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','{F7B550E6-8E04-48E1-A98C-E836271A7778}','Thu','Working Day','20:00','08:00','2021-11-02 16:51:26',1,'2021-11-02 16:51:26',1),('{08BFE024-66BC-445E-8F2C-B3CF1C980CD0}','{F7E05087-0CF9-41FD-B9FE-46FBCF566C07}','Fri','Working Day','9:00','17:00','2020-12-16 13:41:18',3,'2020-12-16 13:41:18',3),('{D8507066-869E-4248-BC24-E2812694DF97}','{F895D19E-05EB-4489-9FAE-89A49C09DD0A}','Tue','Working Day','07:00','15:00','2018-08-18 09:41:56',1,NULL,NULL),('{DB7FEEE7-894C-481F-B63E-2E5CC0772CED}','{FA1ECACF-6966-46C6-A3E3-488325A9AD59}','Tue','Working Day','07:30','12:30','2020-12-16 13:38:55',3,'2020-12-16 13:38:55',3),('{2A3D53FF-72F9-4CC3-B79E-672C82C8326E}','{FAA581DC-4C8D-42BB-AEA1-22DF19C18EC1}','Sun','Holiday','0:00','0:00','2018-07-09 12:24:45',1,NULL,NULL),('{8857CF67-3A87-4805-9DC9-9E9F6AB954B7}','{FBB47B78-0F90-4310-AE79-01BFDF333D16}','Thu','Working Day','10:30','01:00','2022-01-13 15:16:31',3,'2022-01-13 15:16:31',3),('{C13B2D7B-3F42-4630-8943-72CE904DB128}','{FBE33896-1C68-4938-874B-A6DA3CE91EE0}','Tue','Working Day','17:00','08:00','2021-03-03 10:11:46',1,'2021-03-03 10:11:46',1),('{F507C00F-DCE9-4341-87D5-1BC1C173A77E}','{FDA6DAF7-A5B0-4BAE-B9C6-9F6CB08CD1CA}','Sun','Holiday','0:00','0:00','2021-01-04 09:22:08',1,'2021-01-04 09:22:08',1),('{F2C42367-FDA9-400B-BB44-0FC9BA471412}','{FE0FE22F-CABA-4F99-8692-69196966091D}','Thu','Working Day','08:00','20:00','2021-11-02 16:51:32',1,'2021-11-02 16:51:32',1),('{4EEA1AF8-0BAC-4634-8410-D3B68B57EA7A}','{FEF77D59-F2F9-45EF-A6B3-74DE152C61EE}','Fri','Working Day','9:00','17:00','2020-12-16 13:41:26',3,'2020-12-16 13:41:26',3),('{BCFC7D26-C85D-49F7-AC06-CA520DE4B5DC}','{FF6D6A79-888E-4481-B51C-4DCD00538838}','Wed','Holiday','00:00','00:00','2021-11-02 16:51:36',1,'2021-11-02 16:51:36',1),('{8DDA0E53-75F6-405E-82D0-F27B3779651F}','{FF7CEACE-279F-4598-BF36-8B080A391A4D}','Wed','Working Day','08:15','14:00','2021-11-02 16:51:16',1,'2021-11-02 16:51:16',1),('{2DCB3B70-B8A6-4E8A-981B-946E331C8C28}','{FF96F63E-E57A-4379-AB75-E1690681BEC1}','Mon','Working Day','9:00','17:00','2021-06-29 15:35:16',19,'2021-06-29 15:35:16',19),('{A8D05D73-9860-4A6C-B99B-E1E96971D12C}','{FFC3FE2C-5DD0-49E4-A7F2-91125230D3B5}','Sun','Holiday','0:00','0:00','2020-12-16 13:38:18',3,'2020-12-16 13:38:18',3),('{C4451DF5-FEC3-47A9-9192-6B2EB6C8FD67}','{FFDC742C-227A-499F-9F81-356D907A969D}','Wed','Working Day','07:00','19:00','2022-04-28 12:26:36',6,'2022-04-28 12:26:36',6);

/*Table structure for table `audit` */

CREATE TABLE `audit` (
  `audit_id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `company_branch_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `batch_identity` char(40) DEFAULT NULL,
  `document` varchar(255) NOT NULL,
  `transaction_type` char(6) NOT NULL,
  `transaction_table` varchar(255) NOT NULL,
  `transaction_id` char(40) NOT NULL,
  `document_identity` varchar(255) DEFAULT NULL,
  `query` text,
  `created_by_id` char(40) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`audit_id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

/*Data for the table `audit` */

insert  into `audit`(`audit_id`,`company_id`,`company_branch_id`,`fiscal_year_id`,`batch_identity`,`document`,`transaction_type`,`transaction_table`,`transaction_id`,`document_identity`,`query`,`created_by_id`,`created_at`) values (1,1,0,6,'174287','common/change_password','UPDATE','user','9',NULL,'UPDATE `user` SET `login_password` = \'d8a8a2d126d19f9316dad39498c32b0b\' WHERE `user_id` = \'9\'','9','2022-07-10 20:54:39'),(2,1,0,6,'174287','common/password_changed','UPDATE','user_login','9',NULL,'UPDATE `user_login` SET `user_id` = \'9\', `last_login_ip` = \'182.180.191.125\', `last_login_date` = \'2022-07-10 20:54:39\', `last_password_changed` = \'2022-07-10 20:54:39\' WHERE `user_id` = \'9\'','9','2022-07-10 20:54:39'),(3,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{1226ABFE-C77D-4BAF-AFC9-E66D73069CD7}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{1226ABFE-C77D-4BAF-AFC9-E66D73069CD7}\'','9','2022-07-10 21:13:30'),(4,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{16378DFB-EE55-4612-BC6D-321759E8013F}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{16378DFB-EE55-4612-BC6D-321759E8013F}\'','9','2022-07-10 21:13:30'),(5,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{1CB9B2CD-4E08-485C-885A-58E57B6ABD37}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{1CB9B2CD-4E08-485C-885A-58E57B6ABD37}\'','9','2022-07-10 21:13:30'),(6,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{714BFACC-0448-48F3-A77E-202B73DB375F}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{714BFACC-0448-48F3-A77E-202B73DB375F}\'','9','2022-07-10 21:13:30'),(7,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{73B2D46D-35AF-4E09-B23B-E4104EE5816F}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{73B2D46D-35AF-4E09-B23B-E4104EE5816F}\'','9','2022-07-10 21:13:30'),(8,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{7DCEE4B2-3390-4C87-8D34-1E8BC2DB6730}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{7DCEE4B2-3390-4C87-8D34-1E8BC2DB6730}\'','9','2022-07-10 21:13:30'),(9,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{8B8E47FA-6C0B-47FE-8DD2-9CFBF8901C2B}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{8B8E47FA-6C0B-47FE-8DD2-9CFBF8901C2B}\'','9','2022-07-10 21:13:30'),(10,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{AF828753-7922-4097-86BD-5941F7FDD740}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{AF828753-7922-4097-86BD-5941F7FDD740}\'','9','2022-07-10 21:13:30'),(11,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{B8CD0EE7-D443-46AE-893D-C50BE98371AC}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{B8CD0EE7-D443-46AE-893D-C50BE98371AC}\'','9','2022-07-10 21:13:30'),(12,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{E28C94A4-E19C-4F7B-86EA-B1EC00FDAE7E}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{E28C94A4-E19C-4F7B-86EA-B1EC00FDAE7E}\'','9','2022-07-10 21:13:30'),(13,1,0,6,'174854','setup/core_setting','DELETE','core_setting','{F256AB45-3561-4906-A1EE-E6428AD2206A}',NULL,'DELETE FROM `core_setting` WHERE `setting_id` = \'{F256AB45-3561-4906-A1EE-E6428AD2206A}\'','9','2022-07-10 21:13:30'),(14,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{AB895A0E-9DF7-7598-6B6C-B387DC8CADE0}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'config_mail_engine\', `value` = \'mail\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{AB895A0E-9DF7-7598-6B6C-B387DC8CADE0}\'','9','2022-07-10 21:13:30'),(15,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{035B49E3-5533-0E72-BE14-99954CBA5C6D}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'config_mail_smtp_hostname\', `value` = \'smtp.gmail.com\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{035B49E3-5533-0E72-BE14-99954CBA5C6D}\'','9','2022-07-10 21:13:30'),(16,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{1AC4EC4C-8DBD-75BA-3E42-2FBA0B2083FA}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'config_mail_smtp_username\', `value` = \'noreply@gmail.com\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{1AC4EC4C-8DBD-75BA-3E42-2FBA0B2083FA}\'','9','2022-07-10 21:13:30'),(17,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{5A25A8DE-4B8A-791E-317C-DE8A02AB3903}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'config_mail_smtp_password\', `value` = \'zhgqprdabtiugnoa\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{5A25A8DE-4B8A-791E-317C-DE8A02AB3903}\'','9','2022-07-10 21:13:30'),(18,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{930FFFEE-6F9D-6415-33AE-79FEB42DB1EE}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'config_mail_parameter\', `value` = \'\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{930FFFEE-6F9D-6415-33AE-79FEB42DB1EE}\'','9','2022-07-10 21:13:30'),(19,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{13B60648-5322-B47D-50A4-39931BF0831B}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'config_mail_smtp_port\', `value` = \'25\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{13B60648-5322-B47D-50A4-39931BF0831B}\'','9','2022-07-10 21:13:30'),(20,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{09E5BC2E-CC12-5739-86C9-A8C1F8BD06FD}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'config_mail_smtp_timeout\', `value` = \'5\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{09E5BC2E-CC12-5739-86C9-A8C1F8BD06FD}\'','9','2022-07-10 21:13:30'),(21,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{36CD8413-A483-478A-9BF1-B5F43536346A}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'config_mail_smtp_displayname\', `value` = \'noreply\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{36CD8413-A483-478A-9BF1-B5F43536346A}\'','9','2022-07-10 21:13:30'),(22,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{35967CA1-E2F3-743A-3113-0CBE608E53CE}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'sms_user_name\', `value` = \'03028501641\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{35967CA1-E2F3-743A-3113-0CBE608E53CE}\'','9','2022-07-10 21:13:30'),(23,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{1450CC2A-76A6-0ABC-3330-37697DB9DD66}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'sms_password\', `value` = \'SmS.53210\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{1450CC2A-76A6-0ABC-3330-37697DB9DD66}\'','9','2022-07-10 21:13:30'),(24,1,0,6,'174854','setup/core_setting','INSERT','core_setting','{F04B303D-506D-3D93-6041-CDE6C7512FD1}',NULL,'INSERT INTO `core_setting` SET  `company_id` = \'1\', `module` = \'general\', `field` = \'sms_from_mask\', `value` = \'7005157\', `created_at` = \'2022-07-10 21:13:30\', `created_by_id` = \'9\', `setting_id` = \'{F04B303D-506D-3D93-6041-CDE6C7512FD1}\'','9','2022-07-10 21:13:30'),(25,1,0,6,'93083','common/change_password','UPDATE','user','1',NULL,'UPDATE `user` SET `login_password` = \'2ca31d1dc5483ce92a8352352730958e\' WHERE `user_id` = \'1\'','1','2022-07-13 10:21:51'),(26,1,0,6,'93083','common/password_changed','UPDATE','user_login','1',NULL,'UPDATE `user_login` SET `user_id` = \'1\', `last_login_ip` = \'119.152.102.137\', `last_login_date` = \'2022-07-13 10:21:51\', `last_password_changed` = \'2022-07-13 10:21:51\' WHERE `user_id` = \'1\'','1','2022-07-13 10:21:51'),(27,1,0,6,'93387','employee/employee_profile','INSERT','employee','{C5DA0414-6C0D-A068-8D17-95D45555CCB9}',NULL,'INSERT INTO `employee` SET  `employee_image` = \'\', `employee_code` = \'16\', `title_first_name` = \'\', `first_name` = \'Muhammad\', `title_middle_name` = \'\', `middle_name` = \'Zulnurain\', `surname` = \'Anwar\', `full_name` = \'Muhammad Zulnurain Anwar\', `joining_date` = \'2022-04-07\', `its_no` = \'\', `dob` = NULL, `gender` = \'Male\', `marital_status` = \'\', `mobile_no` = \'+92 340 8735131\', `phone_no` = \'\', `email` = \'\', `qualification_id` = \'\', `employee_category_id` = \'\', `city` = \'\', `area` = \'\', `nationality` = \'\', `cnic_no` = \'4230128897133\', `cnic_expiry` = NULL, `cnic_name` = \'\', `cnic_address` = \'\', `nicop_no` = \'\', `nicop_expiry` = NULL, `nicop_name` = \'\', `nicop_address` = \'\', `passport_no` = \'\', `passport_expiry` = NULL, `passport_name` = \'\', `passport_address` = \'\', `eobi_no` = \'\', `eobi_date` = NULL, `eobi_sno` = \'\', `ntn_no` = \'\', `probation_from` = NULL, `probation_to` = NULL, `company_id` = \'1\', `ramzan_enayat` = \'0\', `created_at` = \'2022-07-13 10:26:10\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 10:26:10\', `modified_by_id` = \'1\', `employee_id` = \'{C5DA0414-6C0D-A068-8D17-95D45555CCB9}\'','1','2022-07-13 10:26:10'),(28,1,0,6,'93494','employee/employee_profile','UPDATE','employee','{C5DA0414-6C0D-A068-8D17-95D45555CCB9}',NULL,'UPDATE `employee` SET `employee_image` = \'\', `login_id` = \'zulnurain\', `login_password` = \'9277c2aa43413db448a9c1b1d3a8cac2\', `employee_code` = \'16\', `title_first_name` = \'\', `first_name` = \'Muhammad\', `title_middle_name` = \'\', `middle_name` = \'Zulnurain\', `surname` = \'Anwar\', `full_name` = \'Muhammad Zulnurain Anwar\', `joining_date` = \'2022-04-07\', `its_no` = \'\', `dob` = NULL, `gender` = \'Male\', `marital_status` = \'\', `mobile_no` = \'+92 340 8735131\', `phone_no` = \'\', `email` = \'\', `qualification_id` = \'\', `employee_category_id` = \'\', `city` = \'\', `area` = \'\', `nationality` = \'\', `cnic_no` = \'4230128897133\', `cnic_expiry` = NULL, `cnic_name` = \'\', `cnic_address` = \'\', `nicop_no` = \'\', `nicop_expiry` = NULL, `nicop_name` = \'\', `nicop_address` = \'\', `passport_no` = \'\', `passport_expiry` = NULL, `passport_name` = \'\', `passport_address` = \'\', `eobi_no` = \'\', `eobi_date` = NULL, `eobi_sno` = \'\', `ntn_no` = \'\', `probation_from` = NULL, `probation_to` = NULL, `ramzan_enayat` = \'0\', `modified_at` = \'2022-07-13 10:27:26\', `modified_by_id` = \'1\' WHERE `employee_id` = \'{C5DA0414-6C0D-A068-8D17-95D45555CCB9}\'','1','2022-07-13 10:27:26'),(29,1,0,6,'93585','employee/employee_profile','UPDATE','employee','{C5DA0414-6C0D-A068-8D17-95D45555CCB9}',NULL,'UPDATE `employee` SET `employee_image` = \'\', `login_id` = \'zulnurain\', `employee_code` = \'16\', `title_first_name` = \'\', `first_name` = \'Muhammad\', `title_middle_name` = \'\', `middle_name` = \'Zulnurain\', `surname` = \'Anwar\', `full_name` = \'Muhammad Zulnurain Anwar\', `joining_date` = \'2022-04-07\', `its_no` = \'\', `dob` = NULL, `gender` = \'Male\', `marital_status` = \'\', `mobile_no` = \'+92 340 8735131\', `phone_no` = \'\', `email` = \'nurayn.anwar@gmail.com\', `qualification_id` = \'\', `employee_category_id` = \'\', `city` = \'\', `area` = \'\', `nationality` = \'\', `cnic_no` = \'4230128897133\', `cnic_expiry` = NULL, `cnic_name` = \'\', `cnic_address` = \'\', `nicop_no` = \'\', `nicop_expiry` = NULL, `nicop_name` = \'\', `nicop_address` = \'\', `passport_no` = \'\', `passport_expiry` = NULL, `passport_name` = \'\', `passport_address` = \'\', `eobi_no` = \'\', `eobi_date` = NULL, `eobi_sno` = \'\', `ntn_no` = \'\', `probation_from` = NULL, `probation_to` = NULL, `ramzan_enayat` = \'0\', `modified_at` = \'2022-07-13 10:28:05\', `modified_by_id` = \'1\' WHERE `employee_id` = \'{C5DA0414-6C0D-A068-8D17-95D45555CCB9}\'','1','2022-07-13 10:28:05'),(30,1,0,6,'93723','employee/employee_profile','INSERT','employee','{CB300019-C61B-9114-4A11-985F5A525FBB}',NULL,'INSERT INTO `employee` SET  `employee_image` = \'\', `login_id` = \'ahmed\', `login_password` = \'32aa2fd87338e241978c48ab319641bc\', `employee_code` = \'17\', `title_first_name` = \'\', `first_name` = \'Ahmed\', `title_middle_name` = \'\', `middle_name` = \'Ali\', `surname` = \'Shah\', `full_name` = \'Ahmed Ali Shah\', `joining_date` = NULL, `its_no` = \'\', `dob` = NULL, `gender` = \'Male\', `marital_status` = \'\', `mobile_no` = \'+92 333 8816716\', `phone_no` = \'\', `email` = \'ahmedalishah00@gmail.com\', `qualification_id` = \'\', `employee_category_id` = \'\', `city` = \'\', `area` = \'\', `nationality` = \'\', `cnic_no` = \'4240133594485\', `cnic_expiry` = NULL, `cnic_name` = \'\', `cnic_address` = \'\', `nicop_no` = \'\', `nicop_expiry` = NULL, `nicop_name` = \'\', `nicop_address` = \'\', `passport_no` = \'\', `passport_expiry` = NULL, `passport_name` = \'\', `passport_address` = \'\', `eobi_no` = \'\', `eobi_date` = NULL, `eobi_sno` = \'\', `ntn_no` = \'\', `probation_from` = NULL, `probation_to` = NULL, `company_id` = \'1\', `ramzan_enayat` = \'0\', `created_at` = \'2022-07-13 10:29:38\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 10:29:38\', `modified_by_id` = \'1\', `employee_id` = \'{CB300019-C61B-9114-4A11-985F5A525FBB}\'','1','2022-07-13 10:29:38'),(31,1,0,6,'94590','setup/department','INSERT','department','1',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'1\', `department_name` = \'Mobile App Development\', `address` = \'Address\', `phone_no` = \'121121\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 10:49:39\', `created_by_id` = \'1\'','1','2022-07-13 10:49:39'),(32,1,0,6,'94631','setup/department','INSERT','department','2',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'2\', `department_name` = \'Web App Development\', `address` = \'Address\', `phone_no` = \'1234\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 10:50:08\', `created_by_id` = \'1\'','1','2022-07-13 10:50:08'),(33,1,0,6,'94641','setup/department','INSERT','department','3',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'3\', `department_name` = \'Quality Assurrance\', `address` = \'Address\', `phone_no` = \'1234\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 10:50:31\', `created_by_id` = \'1\'','1','2022-07-13 10:50:31'),(34,1,0,6,'94683','setup/department','INSERT','department','4',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'4\', `department_name` = \'Designing\', `address` = \'1234\', `phone_no` = \'1234\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 10:51:13\', `created_by_id` = \'1\'','1','2022-07-13 10:51:13'),(35,1,0,6,'94718','setup/department','INSERT','department','5',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'5\', `department_name` = \'Management\', `address` = \'Address\', `phone_no` = \'1234\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 10:51:36\', `created_by_id` = \'1\'','1','2022-07-13 10:51:36'),(36,1,0,6,'94799','setup/department','INSERT','department','6',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'6\', `department_name` = \'Customer Support\', `address` = \'Address\', `phone_no` = \'1234\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 10:52:17\', `created_by_id` = \'1\'','1','2022-07-13 10:52:17'),(37,1,0,6,'102665','setup/department','INSERT','department','7',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'7\', `department_name` = \'App Development\', `address` = \'Address\', `phone_no` = \'1234\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 11:43:43\', `created_by_id` = \'1\'','1','2022-07-13 11:43:43'),(38,1,0,6,'102729','setup/department','INSERT','department','8',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'8\', `department_name` = \'Data Analysis\', `address` = \'Address\', `phone_no` = \'1234\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 11:44:33\', `created_by_id` = \'1\'','1','2022-07-13 11:44:33'),(39,1,0,6,'102822','setup/designation','INSERT','designation','1',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Web App Developer\', `created_at` = \'2022-07-13 11:45:51\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:45:51\', `modified_by_id` = \'1\'','1','2022-07-13 11:45:51'),(40,1,0,6,'102848','setup/designation','INSERT','designation','2',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Mobile App Developer\', `created_at` = \'2022-07-13 11:45:57\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:45:57\', `modified_by_id` = \'1\'','1','2022-07-13 11:45:57'),(41,1,0,6,'102875','setup/designation','INSERT','designation','3',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Quality Assurance Engineer\', `created_at` = \'2022-07-13 11:46:08\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:46:08\', `modified_by_id` = \'1\'','1','2022-07-13 11:46:08'),(42,1,0,6,'103290','setup/designation','INSERT','designation','4',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Web Designer\', `created_at` = \'2022-07-13 11:49:00\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:49:00\', `modified_by_id` = \'1\'','1','2022-07-13 11:49:00'),(43,1,0,6,'103316','setup/designation','INSERT','designation','5',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Project Manager\', `created_at` = \'2022-07-13 11:49:09\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:49:09\', `modified_by_id` = \'1\'','1','2022-07-13 11:49:09'),(44,1,0,6,'103342','setup/designation','INSERT','designation','6',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Chief Technical Officer\', `created_at` = \'2022-07-13 11:49:22\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:49:22\', `modified_by_id` = \'1\'','1','2022-07-13 11:49:22'),(45,1,0,6,'103370','setup/designation','INSERT','designation','7',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Chief Executive Officer\', `created_at` = \'2022-07-13 11:49:31\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:49:31\', `modified_by_id` = \'1\'','1','2022-07-13 11:49:31'),(46,1,0,6,'103400','setup/designation','INSERT','designation','8',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Customer Support Representative\', `created_at` = \'2022-07-13 11:49:39\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:49:39\', `modified_by_id` = \'1\'','1','2022-07-13 11:49:39'),(47,1,0,6,'103487','setup/designation','INSERT','designation','9',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Sr. Software Developer\', `created_at` = \'2022-07-13 11:50:25\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:50:25\', `modified_by_id` = \'1\'','1','2022-07-13 11:50:25'),(48,1,0,6,'103517','setup/designation','INSERT','designation','10',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Sr  Software Engineer / Team Lead\', `created_at` = \'2022-07-13 11:50:38\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:50:38\', `modified_by_id` = \'1\'','1','2022-07-13 11:50:38'),(49,1,0,6,'103559','setup/designation','INSERT','designation','11',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Data Analyst\', `created_at` = \'2022-07-13 11:50:52\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:50:52\', `modified_by_id` = \'1\'','1','2022-07-13 11:50:52'),(50,1,0,6,'103639','setup/designation','INSERT','designation','12',NULL,'INSERT INTO `designation` SET  `designation_name` = \'QA and Development\', `created_at` = \'2022-07-13 11:51:20\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 11:51:20\', `modified_by_id` = \'1\'','1','2022-07-13 11:51:20'),(51,2,0,6,'104441','employee/employee_registration','UPDATE','employee_registration','{F5C5C174-2335-8100-CAD2-8DFB25547310}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'1\', `department_id` = \'13\', `employee_id` = \'{678C8595-FE95-7172-C734-F8100EF6A8AF}\', `designation_id` = \'5\', `attendance_shift_id` = \'{9A707E69-23DE-4787-A7FC-6F0BA5E14832}\', `attendance_code` = \'1\', `joining_date` = \'2020-06-15\', `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'2\', `modified_at` = \'2022-07-13 11:59:36\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{F5C5C174-2335-8100-CAD2-8DFB25547310}\'','1','2022-07-13 11:59:36'),(52,2,0,6,'104664','employee/employee_registration','UPDATE','employee_registration','{B0BC566C-2391-2C7A-8280-FE896029900B}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'104\', `department_id` = \'15\', `employee_id` = \'{71748319-2DD8-13B6-1633-23E3E2850287}\', `designation_id` = \'9\', `attendance_shift_id` = \'{9A707E69-23DE-4787-A7FC-6F0BA5E14832}\', `attendance_code` = \'4\', `joining_date` = NULL, `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'2\', `modified_at` = \'2022-07-13 12:01:35\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{B0BC566C-2391-2C7A-8280-FE896029900B}\'','1','2022-07-13 12:01:35'),(53,2,0,6,'104721','employee/employee_registration','UPDATE','employee_registration','{0D8542CE-74AE-37F4-777E-D6411FE52A9B}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'105\', `department_id` = \'10\', `employee_id` = \'{8833635A-60E7-27B6-870A-549B9E7D76C2}\', `designation_id` = \'1\', `attendance_shift_id` = \'{9A707E69-23DE-4787-A7FC-6F0BA5E14832}\', `attendance_code` = \'8\', `joining_date` = NULL, `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'2\', `modified_at` = \'2022-07-13 12:02:02\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{0D8542CE-74AE-37F4-777E-D6411FE52A9B}\'','1','2022-07-13 12:02:02'),(54,2,0,6,'104760','employee/employee_registration','UPDATE','employee_registration','{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'106\', `department_id` = \'10\', `employee_id` = \'{98C03A27-A91B-D2E3-C80A-FE51F76B90F3}\', `designation_id` = \'10\', `attendance_shift_id` = \'{9A707E69-23DE-4787-A7FC-6F0BA5E14832}\', `attendance_code` = \'9\', `joining_date` = \'2022-09-05\', `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'2\', `modified_at` = \'2022-07-13 12:02:24\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}\'','1','2022-07-13 12:02:25'),(55,2,0,6,'104801','employee/employee_registration','UPDATE','employee_registration','{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'107\', `department_id` = \'12\', `employee_id` = \'{1B6A9CE0-6AA1-9E91-301D-0331CFE876BE}\', `designation_id` = \'4\', `attendance_shift_id` = \'{9A707E69-23DE-4787-A7FC-6F0BA5E14832}\', `attendance_code` = \'10\', `joining_date` = NULL, `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'2\', `modified_at` = \'2022-07-13 12:02:49\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}\'','1','2022-07-13 12:02:49'),(56,2,0,6,'104834','employee/employee_registration','UPDATE','employee_registration','{86464FAB-D7E9-0A62-5F9F-4B80473EA081}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'108\', `department_id` = \'11\', `employee_id` = \'{8EE598C0-72A2-513F-3FB5-79D8A617DB03}\', `designation_id` = \'12\', `attendance_shift_id` = \'{9A707E69-23DE-4787-A7FC-6F0BA5E14832}\', `attendance_code` = \'11\', `joining_date` = \'2022-02-03\', `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'2\', `modified_at` = \'2022-07-13 12:03:11\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}\'','1','2022-07-13 12:03:11'),(57,2,0,6,'104867','employee/employee_registration','UPDATE','employee_registration','{D8C42212-5A32-236C-9652-51151DE1D56B}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'109\', `department_id` = \'10\', `employee_id` = \'{340DF38A-79D0-5857-2379-3764F88F7BB2}\', `designation_id` = \'1\', `attendance_shift_id` = \'{9A707E69-23DE-4787-A7FC-6F0BA5E14832}\', `attendance_code` = \'12\', `joining_date` = \'2021-01-06\', `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'2\', `modified_at` = \'2022-07-13 12:04:37\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{D8C42212-5A32-236C-9652-51151DE1D56B}\'','1','2022-07-13 12:04:37'),(58,1,0,6,'104933','employee/employee_registration','UPDATE','employee_registration','{4D7622CE-465D-7B03-5B9C-5277A8F063B0}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'2\', `department_id` = \'1\', `employee_id` = \'{FEEE3174-89B3-CF50-6419-964421B981CE}\', `designation_id` = \'2\', `attendance_code` = \'2\', `joining_date` = \'2022-05-23\', `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'1\', `modified_at` = \'2022-07-13 12:05:10\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}\'','1','2022-07-13 12:05:10'),(59,1,0,6,'105195','employee/employee_registration','UPDATE','employee_registration','{175EE610-BF1A-BF01-5A7F-904823C47108}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'3\', `department_id` = \'6\', `employee_id` = \'{72C7BDF0-E50A-DABA-D59E-A2791B1E9033}\', `designation_id` = \'8\', `attendance_code` = \'3\', `joining_date` = NULL, `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'1\', `modified_at` = \'2022-07-13 12:06:24\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{175EE610-BF1A-BF01-5A7F-904823C47108}\'','1','2022-07-13 12:06:24'),(60,1,0,6,'105357','employee/employee_registration','UPDATE','employee_registration','{E6D6C251-8460-0699-5AF2-FD029521F9BF}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'5\', `department_id` = \'5\', `employee_id` = \'{D2AF4500-371C-F68F-D744-2338A66271DE}\', `designation_id` = \'6\', `attendance_code` = \'6\', `joining_date` = NULL, `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'1\', `modified_at` = \'2022-07-13 12:07:02\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{E6D6C251-8460-0699-5AF2-FD029521F9BF}\'','1','2022-07-13 12:07:02'),(61,1,0,6,'105465','employee/employee_registration','UPDATE','employee_registration','{F60B10E3-CC65-04F6-0B43-646CF45B11C1}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'6\', `department_id` = \'8\', `employee_id` = \'{5986D375-FB79-067F-C265-960CD15934F2}\', `designation_id` = \'11\', `attendance_code` = \'7\', `joining_date` = NULL, `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'1\', `modified_at` = \'2022-07-13 12:07:34\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{F60B10E3-CC65-04F6-0B43-646CF45B11C1}\'','1','2022-07-13 12:07:34'),(62,1,0,6,'105588','employee/employee_registration','UPDATE','employee_registration','{7305964F-EE02-FB38-519A-C1F6F0368BE9}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'4\', `department_id` = \'2\', `employee_id` = \'{6AF5D1E5-FBD8-DF06-CC4B-598D58D8C031}\', `designation_id` = \'1\', `attendance_code` = \'5\', `joining_date` = \'2020-01-11\', `status` = \'Inactive\', `leaving_date` = \'2022-07-08\', `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'1\', `modified_at` = \'2022-07-13 12:08:21\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{7305964F-EE02-FB38-519A-C1F6F0368BE9}\'','1','2022-07-13 12:08:21'),(63,1,0,6,'105658','employee/employee_registration','UPDATE','employee_registration','{2AE513B4-BEA1-E03F-2C32-D1ABFB54CDB2}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'8\', `department_id` = \'5\', `employee_id` = \'{1094676F-F17E-CA37-6FD8-4D6E73BBDC79}\', `designation_id` = \'7\', `attendance_code` = \'14\', `joining_date` = \'2004-01-01\', `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'1\', `modified_at` = \'2022-07-13 12:08:55\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{2AE513B4-BEA1-E03F-2C32-D1ABFB54CDB2}\'','1','2022-07-13 12:08:55'),(64,1,0,6,'105916','setup/designation','INSERT','designation','13',NULL,'INSERT INTO `designation` SET  `designation_name` = \'Office Boy\', `created_at` = \'2022-07-13 12:11:02\', `created_by_id` = \'1\', `modified_at` = \'2022-07-13 12:11:02\', `modified_by_id` = \'1\'','1','2022-07-13 12:11:02'),(65,1,0,6,'106208','setup/department','INSERT','department','24',NULL,'INSERT INTO `department` SET  `company_id` = \'1\', `department_code` = \'17\', `department_name` = \'Support\', `address` = \'Address\', `phone_no` = \'1234\', `party_id` = \'1234\', `ah_key` = \'1234\', `budget_key` = \'1234\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `created_at` = \'2022-07-13 12:12:44\', `created_by_id` = \'1\'','1','2022-07-13 12:12:44'),(66,1,0,6,'106296','employee/employee_registration','UPDATE','employee_registration','{D73857F6-E04B-F279-1B99-39059EE1DD6A}',NULL,'UPDATE `employee_registration` SET `registration_code` = \'7\', `department_id` = \'24\', `employee_id` = \'{80500690-5BAB-169E-2D49-654BCB281E3E}\', `designation_id` = \'13\', `attendance_code` = \'13\', `joining_date` = \'2018-04-04\', `status` = \'Active\', `leaving_date` = NULL, `employee_bank_id` = \'\', `bank_id` = \'\', `bank_account` = \'\', `bank_title` = \'\', `bank_iban` = \'\', `party_id` = \'0\', `total_payroll` = \'0\', `arrears` = \'0.00\', `deduction_days` = \'\', `deduction_percent` = \'\', `override_attendance_policy` = \'0\', `override_allowance_policy` = \'0\', `attendance_exempted` = \'0\', `company_id` = \'1\', `modified_at` = \'2022-07-13 12:13:10\', `modified_by_id` = \'1\' WHERE `employee_registration_id` = \'{D73857F6-E04B-F279-1B99-39059EE1DD6A}\'','1','2022-07-13 12:13:10');

/*Table structure for table `audit_detail` */

CREATE TABLE `audit_detail` (
  `audit_detail_id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `company_branch_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `audit_id` int(11) NOT NULL,
  `field` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`audit_detail_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1173 DEFAULT CHARSET=utf8;

/*Data for the table `audit_detail` */

insert  into `audit_detail`(`audit_detail_id`,`company_id`,`company_branch_id`,`fiscal_year_id`,`audit_id`,`field`,`value`) values (1,NULL,NULL,NULL,1,'login_password','d8a8a2d126d19f9316dad39498c32b0b'),(2,NULL,NULL,NULL,1,'modified_at','2022-07-10 20:54:38'),(3,NULL,NULL,NULL,1,'modified_by_id','9'),(4,NULL,NULL,NULL,2,'user_id','9'),(5,NULL,NULL,NULL,2,'last_login_ip','182.180.191.125'),(6,NULL,NULL,NULL,2,'last_login_date','2022-07-10 20:54:39'),(7,NULL,NULL,NULL,2,'last_password_changed','2022-07-10 20:54:39'),(8,NULL,NULL,NULL,2,'modified_at','2022-07-10 20:54:39'),(9,NULL,NULL,NULL,2,'modified_by_id','9'),(10,NULL,NULL,NULL,3,'setting_id','{1226ABFE-C77D-4BAF-AFC9-E66D73069CD7}'),(11,NULL,NULL,NULL,3,'company_id','1'),(12,NULL,NULL,NULL,3,'department_id',''),(13,NULL,NULL,NULL,3,'fiscal_year_id',''),(14,NULL,NULL,NULL,3,'module','general'),(15,NULL,NULL,NULL,3,'field','config_mail_smtp_displayname'),(16,NULL,NULL,NULL,3,'value','noreply'),(17,NULL,NULL,NULL,3,'created_at','2022-03-25 15:57:33'),(18,NULL,NULL,NULL,3,'created_by_id','1'),(19,NULL,NULL,NULL,4,'setting_id','{16378DFB-EE55-4612-BC6D-321759E8013F}'),(20,NULL,NULL,NULL,4,'company_id','1'),(21,NULL,NULL,NULL,4,'department_id',''),(22,NULL,NULL,NULL,4,'fiscal_year_id',''),(23,NULL,NULL,NULL,4,'module','general'),(24,NULL,NULL,NULL,4,'field','config_mail_smtp_port'),(25,NULL,NULL,NULL,4,'value','25'),(26,NULL,NULL,NULL,4,'created_at','2022-03-25 15:57:33'),(27,NULL,NULL,NULL,4,'created_by_id','1'),(28,NULL,NULL,NULL,5,'setting_id','{1CB9B2CD-4E08-485C-885A-58E57B6ABD37}'),(29,NULL,NULL,NULL,5,'company_id','1'),(30,NULL,NULL,NULL,5,'department_id',''),(31,NULL,NULL,NULL,5,'fiscal_year_id',''),(32,NULL,NULL,NULL,5,'module','general'),(33,NULL,NULL,NULL,5,'field','config_mail_smtp_hostname'),(34,NULL,NULL,NULL,5,'value','smtp.gmail.com'),(35,NULL,NULL,NULL,5,'created_at','2022-03-25 15:57:33'),(36,NULL,NULL,NULL,5,'created_by_id','1'),(37,NULL,NULL,NULL,6,'setting_id','{714BFACC-0448-48F3-A77E-202B73DB375F}'),(38,NULL,NULL,NULL,6,'company_id','1'),(39,NULL,NULL,NULL,6,'department_id',''),(40,NULL,NULL,NULL,6,'fiscal_year_id',''),(41,NULL,NULL,NULL,6,'module','general'),(42,NULL,NULL,NULL,6,'field','sms_password'),(43,NULL,NULL,NULL,6,'value','SmS.53210'),(44,NULL,NULL,NULL,6,'created_at','2022-03-25 15:57:33'),(45,NULL,NULL,NULL,6,'created_by_id','1'),(46,NULL,NULL,NULL,7,'setting_id','{73B2D46D-35AF-4E09-B23B-E4104EE5816F}'),(47,NULL,NULL,NULL,7,'company_id','1'),(48,NULL,NULL,NULL,7,'department_id',''),(49,NULL,NULL,NULL,7,'fiscal_year_id',''),(50,NULL,NULL,NULL,7,'module','general'),(51,NULL,NULL,NULL,7,'field','sms_user_name'),(52,NULL,NULL,NULL,7,'value','03028501641'),(53,NULL,NULL,NULL,7,'created_at','2022-03-25 15:57:33'),(54,NULL,NULL,NULL,7,'created_by_id','1'),(55,NULL,NULL,NULL,8,'setting_id','{7DCEE4B2-3390-4C87-8D34-1E8BC2DB6730}'),(56,NULL,NULL,NULL,8,'company_id','1'),(57,NULL,NULL,NULL,8,'department_id',''),(58,NULL,NULL,NULL,8,'fiscal_year_id',''),(59,NULL,NULL,NULL,8,'module','general'),(60,NULL,NULL,NULL,8,'field','sms_from_mask'),(61,NULL,NULL,NULL,8,'value','7005157'),(62,NULL,NULL,NULL,8,'created_at','2022-03-25 15:57:33'),(63,NULL,NULL,NULL,8,'created_by_id','1'),(64,NULL,NULL,NULL,9,'setting_id','{8B8E47FA-6C0B-47FE-8DD2-9CFBF8901C2B}'),(65,NULL,NULL,NULL,9,'company_id','1'),(66,NULL,NULL,NULL,9,'department_id',''),(67,NULL,NULL,NULL,9,'fiscal_year_id',''),(68,NULL,NULL,NULL,9,'module','general'),(69,NULL,NULL,NULL,9,'field','config_mail_smtp_username'),(70,NULL,NULL,NULL,9,'value','noreply@dawatkhi.com'),(71,NULL,NULL,NULL,9,'created_at','2022-03-25 15:57:33'),(72,NULL,NULL,NULL,9,'created_by_id','1'),(73,NULL,NULL,NULL,10,'setting_id','{AF828753-7922-4097-86BD-5941F7FDD740}'),(74,NULL,NULL,NULL,10,'company_id','1'),(75,NULL,NULL,NULL,10,'department_id',''),(76,NULL,NULL,NULL,10,'fiscal_year_id',''),(77,NULL,NULL,NULL,10,'module','general'),(78,NULL,NULL,NULL,10,'field','config_mail_parameter'),(79,NULL,NULL,NULL,10,'value',''),(80,NULL,NULL,NULL,10,'created_at','2022-03-25 15:57:33'),(81,NULL,NULL,NULL,10,'created_by_id','1'),(82,NULL,NULL,NULL,11,'setting_id','{B8CD0EE7-D443-46AE-893D-C50BE98371AC}'),(83,NULL,NULL,NULL,11,'company_id','1'),(84,NULL,NULL,NULL,11,'department_id',''),(85,NULL,NULL,NULL,11,'fiscal_year_id',''),(86,NULL,NULL,NULL,11,'module','general'),(87,NULL,NULL,NULL,11,'field','config_mail_smtp_timeout'),(88,NULL,NULL,NULL,11,'value','5'),(89,NULL,NULL,NULL,11,'created_at','2022-03-25 15:57:33'),(90,NULL,NULL,NULL,11,'created_by_id','1'),(91,NULL,NULL,NULL,12,'setting_id','{E28C94A4-E19C-4F7B-86EA-B1EC00FDAE7E}'),(92,NULL,NULL,NULL,12,'company_id','1'),(93,NULL,NULL,NULL,12,'department_id',''),(94,NULL,NULL,NULL,12,'fiscal_year_id',''),(95,NULL,NULL,NULL,12,'module','general'),(96,NULL,NULL,NULL,12,'field','config_mail_engine'),(97,NULL,NULL,NULL,12,'value','mail'),(98,NULL,NULL,NULL,12,'created_at','2022-03-25 15:57:33'),(99,NULL,NULL,NULL,12,'created_by_id','1'),(100,NULL,NULL,NULL,13,'setting_id','{F256AB45-3561-4906-A1EE-E6428AD2206A}'),(101,NULL,NULL,NULL,13,'company_id','1'),(102,NULL,NULL,NULL,13,'department_id',''),(103,NULL,NULL,NULL,13,'fiscal_year_id',''),(104,NULL,NULL,NULL,13,'module','general'),(105,NULL,NULL,NULL,13,'field','config_mail_smtp_password'),(106,NULL,NULL,NULL,13,'value','zhgqprdabtiugnoa'),(107,NULL,NULL,NULL,13,'created_at','2022-03-25 15:57:33'),(108,NULL,NULL,NULL,13,'created_by_id','1'),(109,NULL,NULL,NULL,14,'company_id','1'),(110,NULL,NULL,NULL,14,'module','general'),(111,NULL,NULL,NULL,14,'field','config_mail_engine'),(112,NULL,NULL,NULL,14,'value','mail'),(113,NULL,NULL,NULL,14,'created_at','2022-07-10 21:13:30'),(114,NULL,NULL,NULL,14,'created_by_id','9'),(115,NULL,NULL,NULL,14,'modified_at','2022-07-10 21:13:30'),(116,NULL,NULL,NULL,14,'modified_by_id','9'),(117,NULL,NULL,NULL,14,'setting_id','{AB895A0E-9DF7-7598-6B6C-B387DC8CADE0}'),(118,NULL,NULL,NULL,15,'company_id','1'),(119,NULL,NULL,NULL,15,'module','general'),(120,NULL,NULL,NULL,15,'field','config_mail_smtp_hostname'),(121,NULL,NULL,NULL,15,'value','smtp.gmail.com'),(122,NULL,NULL,NULL,15,'created_at','2022-07-10 21:13:30'),(123,NULL,NULL,NULL,15,'created_by_id','9'),(124,NULL,NULL,NULL,15,'modified_at','2022-07-10 21:13:30'),(125,NULL,NULL,NULL,15,'modified_by_id','9'),(126,NULL,NULL,NULL,15,'setting_id','{035B49E3-5533-0E72-BE14-99954CBA5C6D}'),(127,NULL,NULL,NULL,16,'company_id','1'),(128,NULL,NULL,NULL,16,'module','general'),(129,NULL,NULL,NULL,16,'field','config_mail_smtp_username'),(130,NULL,NULL,NULL,16,'value','noreply@gmail.com'),(131,NULL,NULL,NULL,16,'created_at','2022-07-10 21:13:30'),(132,NULL,NULL,NULL,16,'created_by_id','9'),(133,NULL,NULL,NULL,16,'modified_at','2022-07-10 21:13:30'),(134,NULL,NULL,NULL,16,'modified_by_id','9'),(135,NULL,NULL,NULL,16,'setting_id','{1AC4EC4C-8DBD-75BA-3E42-2FBA0B2083FA}'),(136,NULL,NULL,NULL,17,'company_id','1'),(137,NULL,NULL,NULL,17,'module','general'),(138,NULL,NULL,NULL,17,'field','config_mail_smtp_password'),(139,NULL,NULL,NULL,17,'value','zhgqprdabtiugnoa'),(140,NULL,NULL,NULL,17,'created_at','2022-07-10 21:13:30'),(141,NULL,NULL,NULL,17,'created_by_id','9'),(142,NULL,NULL,NULL,17,'modified_at','2022-07-10 21:13:30'),(143,NULL,NULL,NULL,17,'modified_by_id','9'),(144,NULL,NULL,NULL,17,'setting_id','{5A25A8DE-4B8A-791E-317C-DE8A02AB3903}'),(145,NULL,NULL,NULL,18,'company_id','1'),(146,NULL,NULL,NULL,18,'module','general'),(147,NULL,NULL,NULL,18,'field','config_mail_parameter'),(148,NULL,NULL,NULL,18,'value',''),(149,NULL,NULL,NULL,18,'created_at','2022-07-10 21:13:30'),(150,NULL,NULL,NULL,18,'created_by_id','9'),(151,NULL,NULL,NULL,18,'modified_at','2022-07-10 21:13:30'),(152,NULL,NULL,NULL,18,'modified_by_id','9'),(153,NULL,NULL,NULL,18,'setting_id','{930FFFEE-6F9D-6415-33AE-79FEB42DB1EE}'),(154,NULL,NULL,NULL,19,'company_id','1'),(155,NULL,NULL,NULL,19,'module','general'),(156,NULL,NULL,NULL,19,'field','config_mail_smtp_port'),(157,NULL,NULL,NULL,19,'value','25'),(158,NULL,NULL,NULL,19,'created_at','2022-07-10 21:13:30'),(159,NULL,NULL,NULL,19,'created_by_id','9'),(160,NULL,NULL,NULL,19,'modified_at','2022-07-10 21:13:30'),(161,NULL,NULL,NULL,19,'modified_by_id','9'),(162,NULL,NULL,NULL,19,'setting_id','{13B60648-5322-B47D-50A4-39931BF0831B}'),(163,NULL,NULL,NULL,20,'company_id','1'),(164,NULL,NULL,NULL,20,'module','general'),(165,NULL,NULL,NULL,20,'field','config_mail_smtp_timeout'),(166,NULL,NULL,NULL,20,'value','5'),(167,NULL,NULL,NULL,20,'created_at','2022-07-10 21:13:30'),(168,NULL,NULL,NULL,20,'created_by_id','9'),(169,NULL,NULL,NULL,20,'modified_at','2022-07-10 21:13:30'),(170,NULL,NULL,NULL,20,'modified_by_id','9'),(171,NULL,NULL,NULL,20,'setting_id','{09E5BC2E-CC12-5739-86C9-A8C1F8BD06FD}'),(172,NULL,NULL,NULL,21,'company_id','1'),(173,NULL,NULL,NULL,21,'module','general'),(174,NULL,NULL,NULL,21,'field','config_mail_smtp_displayname'),(175,NULL,NULL,NULL,21,'value','noreply'),(176,NULL,NULL,NULL,21,'created_at','2022-07-10 21:13:30'),(177,NULL,NULL,NULL,21,'created_by_id','9'),(178,NULL,NULL,NULL,21,'modified_at','2022-07-10 21:13:30'),(179,NULL,NULL,NULL,21,'modified_by_id','9'),(180,NULL,NULL,NULL,21,'setting_id','{36CD8413-A483-478A-9BF1-B5F43536346A}'),(181,NULL,NULL,NULL,22,'company_id','1'),(182,NULL,NULL,NULL,22,'module','general'),(183,NULL,NULL,NULL,22,'field','sms_user_name'),(184,NULL,NULL,NULL,22,'value','03028501641'),(185,NULL,NULL,NULL,22,'created_at','2022-07-10 21:13:30'),(186,NULL,NULL,NULL,22,'created_by_id','9'),(187,NULL,NULL,NULL,22,'modified_at','2022-07-10 21:13:30'),(188,NULL,NULL,NULL,22,'modified_by_id','9'),(189,NULL,NULL,NULL,22,'setting_id','{35967CA1-E2F3-743A-3113-0CBE608E53CE}'),(190,NULL,NULL,NULL,23,'company_id','1'),(191,NULL,NULL,NULL,23,'module','general'),(192,NULL,NULL,NULL,23,'field','sms_password'),(193,NULL,NULL,NULL,23,'value','SmS.53210'),(194,NULL,NULL,NULL,23,'created_at','2022-07-10 21:13:30'),(195,NULL,NULL,NULL,23,'created_by_id','9'),(196,NULL,NULL,NULL,23,'modified_at','2022-07-10 21:13:30'),(197,NULL,NULL,NULL,23,'modified_by_id','9'),(198,NULL,NULL,NULL,23,'setting_id','{1450CC2A-76A6-0ABC-3330-37697DB9DD66}'),(199,NULL,NULL,NULL,24,'company_id','1'),(200,NULL,NULL,NULL,24,'module','general'),(201,NULL,NULL,NULL,24,'field','sms_from_mask'),(202,NULL,NULL,NULL,24,'value','7005157'),(203,NULL,NULL,NULL,24,'created_at','2022-07-10 21:13:30'),(204,NULL,NULL,NULL,24,'created_by_id','9'),(205,NULL,NULL,NULL,24,'modified_at','2022-07-10 21:13:30'),(206,NULL,NULL,NULL,24,'modified_by_id','9'),(207,NULL,NULL,NULL,24,'setting_id','{F04B303D-506D-3D93-6041-CDE6C7512FD1}'),(208,NULL,NULL,NULL,25,'login_password','2ca31d1dc5483ce92a8352352730958e'),(209,NULL,NULL,NULL,25,'modified_at','2022-07-13 10:21:51'),(210,NULL,NULL,NULL,25,'modified_by_id','1'),(211,NULL,NULL,NULL,26,'user_id','1'),(212,NULL,NULL,NULL,26,'last_login_ip','119.152.102.137'),(213,NULL,NULL,NULL,26,'last_login_date','2022-07-13 10:21:51'),(214,NULL,NULL,NULL,26,'last_password_changed','2022-07-13 10:21:51'),(215,NULL,NULL,NULL,26,'modified_at','2022-07-13 10:21:51'),(216,NULL,NULL,NULL,26,'modified_by_id','1'),(217,NULL,NULL,NULL,27,'primary_key',''),(218,NULL,NULL,NULL,27,'employee_image',''),(219,NULL,NULL,NULL,27,'employee_code','16'),(220,NULL,NULL,NULL,27,'title_first_name',''),(221,NULL,NULL,NULL,27,'first_name','Muhammad'),(222,NULL,NULL,NULL,27,'title_middle_name',''),(223,NULL,NULL,NULL,27,'middle_name','Zulnurain'),(224,NULL,NULL,NULL,27,'surname','Anwar'),(225,NULL,NULL,NULL,27,'full_name','Muhammad Zulnurain Anwar'),(226,NULL,NULL,NULL,27,'joining_date','2022-04-07'),(227,NULL,NULL,NULL,27,'its_no',''),(228,NULL,NULL,NULL,27,'dob',''),(229,NULL,NULL,NULL,27,'gender','Male'),(230,NULL,NULL,NULL,27,'marital_status',''),(231,NULL,NULL,NULL,27,'mobile_no','+92 340 8735131'),(232,NULL,NULL,NULL,27,'phone_no',''),(233,NULL,NULL,NULL,27,'email',''),(234,NULL,NULL,NULL,27,'qualification_id',''),(235,NULL,NULL,NULL,27,'employee_category_id',''),(236,NULL,NULL,NULL,27,'city',''),(237,NULL,NULL,NULL,27,'area',''),(238,NULL,NULL,NULL,27,'nationality',''),(239,NULL,NULL,NULL,27,'cnic_no','4230128897133'),(240,NULL,NULL,NULL,27,'cnic_expiry',''),(241,NULL,NULL,NULL,27,'cnic_name',''),(242,NULL,NULL,NULL,27,'cnic_address',''),(243,NULL,NULL,NULL,27,'nicop_no',''),(244,NULL,NULL,NULL,27,'nicop_expiry',''),(245,NULL,NULL,NULL,27,'nicop_name',''),(246,NULL,NULL,NULL,27,'nicop_address',''),(247,NULL,NULL,NULL,27,'passport_no',''),(248,NULL,NULL,NULL,27,'passport_expiry',''),(249,NULL,NULL,NULL,27,'passport_name',''),(250,NULL,NULL,NULL,27,'passport_address',''),(251,NULL,NULL,NULL,27,'eobi_no',''),(252,NULL,NULL,NULL,27,'eobi_date',''),(253,NULL,NULL,NULL,27,'eobi_sno',''),(254,NULL,NULL,NULL,27,'ntn_no',''),(255,NULL,NULL,NULL,27,'probation_from',''),(256,NULL,NULL,NULL,27,'probation_to',''),(257,NULL,NULL,NULL,27,'company_id','1'),(258,NULL,NULL,NULL,27,'ramzan_enayat','0'),(259,NULL,NULL,NULL,27,'created_at','2022-07-13 10:26:10'),(260,NULL,NULL,NULL,27,'created_by_id','1'),(261,NULL,NULL,NULL,27,'modified_at','2022-07-13 10:26:10'),(262,NULL,NULL,NULL,27,'modified_by_id','1'),(263,NULL,NULL,NULL,27,'employee_id','{C5DA0414-6C0D-A068-8D17-95D45555CCB9}'),(264,NULL,NULL,NULL,28,'primary_key','{C5DA0414-6C0D-A068-8D17-95D45555CCB9}'),(265,NULL,NULL,NULL,28,'employee_image',''),(266,NULL,NULL,NULL,28,'login_id','zulnurain'),(267,NULL,NULL,NULL,28,'login_password','9277c2aa43413db448a9c1b1d3a8cac2'),(268,NULL,NULL,NULL,28,'employee_code','16'),(269,NULL,NULL,NULL,28,'title_first_name',''),(270,NULL,NULL,NULL,28,'first_name','Muhammad'),(271,NULL,NULL,NULL,28,'title_middle_name',''),(272,NULL,NULL,NULL,28,'middle_name','Zulnurain'),(273,NULL,NULL,NULL,28,'surname','Anwar'),(274,NULL,NULL,NULL,28,'full_name','Muhammad Zulnurain Anwar'),(275,NULL,NULL,NULL,28,'joining_date','2022-04-07'),(276,NULL,NULL,NULL,28,'its_no',''),(277,NULL,NULL,NULL,28,'dob',''),(278,NULL,NULL,NULL,28,'gender','Male'),(279,NULL,NULL,NULL,28,'marital_status',''),(280,NULL,NULL,NULL,28,'mobile_no','+92 340 8735131'),(281,NULL,NULL,NULL,28,'phone_no',''),(282,NULL,NULL,NULL,28,'email',''),(283,NULL,NULL,NULL,28,'qualification_id',''),(284,NULL,NULL,NULL,28,'employee_category_id',''),(285,NULL,NULL,NULL,28,'city',''),(286,NULL,NULL,NULL,28,'area',''),(287,NULL,NULL,NULL,28,'nationality',''),(288,NULL,NULL,NULL,28,'cnic_no','4230128897133'),(289,NULL,NULL,NULL,28,'cnic_expiry',''),(290,NULL,NULL,NULL,28,'cnic_name',''),(291,NULL,NULL,NULL,28,'cnic_address',''),(292,NULL,NULL,NULL,28,'nicop_no',''),(293,NULL,NULL,NULL,28,'nicop_expiry',''),(294,NULL,NULL,NULL,28,'nicop_name',''),(295,NULL,NULL,NULL,28,'nicop_address',''),(296,NULL,NULL,NULL,28,'passport_no',''),(297,NULL,NULL,NULL,28,'passport_expiry',''),(298,NULL,NULL,NULL,28,'passport_name',''),(299,NULL,NULL,NULL,28,'passport_address',''),(300,NULL,NULL,NULL,28,'eobi_no',''),(301,NULL,NULL,NULL,28,'eobi_date',''),(302,NULL,NULL,NULL,28,'eobi_sno',''),(303,NULL,NULL,NULL,28,'ntn_no',''),(304,NULL,NULL,NULL,28,'probation_from',''),(305,NULL,NULL,NULL,28,'probation_to',''),(306,NULL,NULL,NULL,28,'ramzan_enayat','0'),(307,NULL,NULL,NULL,28,'modified_at','2022-07-13 10:27:26'),(308,NULL,NULL,NULL,28,'modified_by_id','1'),(309,NULL,NULL,NULL,29,'primary_key','{C5DA0414-6C0D-A068-8D17-95D45555CCB9}'),(310,NULL,NULL,NULL,29,'employee_image',''),(311,NULL,NULL,NULL,29,'login_id','zulnurain'),(312,NULL,NULL,NULL,29,'employee_code','16'),(313,NULL,NULL,NULL,29,'title_first_name',''),(314,NULL,NULL,NULL,29,'first_name','Muhammad'),(315,NULL,NULL,NULL,29,'title_middle_name',''),(316,NULL,NULL,NULL,29,'middle_name','Zulnurain'),(317,NULL,NULL,NULL,29,'surname','Anwar'),(318,NULL,NULL,NULL,29,'full_name','Muhammad Zulnurain Anwar'),(319,NULL,NULL,NULL,29,'joining_date','2022-04-07'),(320,NULL,NULL,NULL,29,'its_no',''),(321,NULL,NULL,NULL,29,'dob',''),(322,NULL,NULL,NULL,29,'gender','Male'),(323,NULL,NULL,NULL,29,'marital_status',''),(324,NULL,NULL,NULL,29,'mobile_no','+92 340 8735131'),(325,NULL,NULL,NULL,29,'phone_no',''),(326,NULL,NULL,NULL,29,'email','nurayn.anwar@gmail.com'),(327,NULL,NULL,NULL,29,'qualification_id',''),(328,NULL,NULL,NULL,29,'employee_category_id',''),(329,NULL,NULL,NULL,29,'city',''),(330,NULL,NULL,NULL,29,'area',''),(331,NULL,NULL,NULL,29,'nationality',''),(332,NULL,NULL,NULL,29,'cnic_no','4230128897133'),(333,NULL,NULL,NULL,29,'cnic_expiry',''),(334,NULL,NULL,NULL,29,'cnic_name',''),(335,NULL,NULL,NULL,29,'cnic_address',''),(336,NULL,NULL,NULL,29,'nicop_no',''),(337,NULL,NULL,NULL,29,'nicop_expiry',''),(338,NULL,NULL,NULL,29,'nicop_name',''),(339,NULL,NULL,NULL,29,'nicop_address',''),(340,NULL,NULL,NULL,29,'passport_no',''),(341,NULL,NULL,NULL,29,'passport_expiry',''),(342,NULL,NULL,NULL,29,'passport_name',''),(343,NULL,NULL,NULL,29,'passport_address',''),(344,NULL,NULL,NULL,29,'eobi_no',''),(345,NULL,NULL,NULL,29,'eobi_date',''),(346,NULL,NULL,NULL,29,'eobi_sno',''),(347,NULL,NULL,NULL,29,'ntn_no',''),(348,NULL,NULL,NULL,29,'probation_from',''),(349,NULL,NULL,NULL,29,'probation_to',''),(350,NULL,NULL,NULL,29,'ramzan_enayat','0'),(351,NULL,NULL,NULL,29,'modified_at','2022-07-13 10:28:05'),(352,NULL,NULL,NULL,29,'modified_by_id','1'),(353,NULL,NULL,NULL,30,'primary_key',''),(354,NULL,NULL,NULL,30,'employee_image',''),(355,NULL,NULL,NULL,30,'login_id','ahmed'),(356,NULL,NULL,NULL,30,'login_password','32aa2fd87338e241978c48ab319641bc'),(357,NULL,NULL,NULL,30,'employee_code','17'),(358,NULL,NULL,NULL,30,'title_first_name',''),(359,NULL,NULL,NULL,30,'first_name','Ahmed'),(360,NULL,NULL,NULL,30,'title_middle_name',''),(361,NULL,NULL,NULL,30,'middle_name','Ali'),(362,NULL,NULL,NULL,30,'surname','Shah'),(363,NULL,NULL,NULL,30,'full_name','Ahmed Ali Shah'),(364,NULL,NULL,NULL,30,'joining_date',''),(365,NULL,NULL,NULL,30,'its_no',''),(366,NULL,NULL,NULL,30,'dob',''),(367,NULL,NULL,NULL,30,'gender','Male'),(368,NULL,NULL,NULL,30,'marital_status',''),(369,NULL,NULL,NULL,30,'mobile_no','+92 333 8816716'),(370,NULL,NULL,NULL,30,'phone_no',''),(371,NULL,NULL,NULL,30,'email','ahmedalishah00@gmail.com'),(372,NULL,NULL,NULL,30,'qualification_id',''),(373,NULL,NULL,NULL,30,'employee_category_id',''),(374,NULL,NULL,NULL,30,'city',''),(375,NULL,NULL,NULL,30,'area',''),(376,NULL,NULL,NULL,30,'nationality',''),(377,NULL,NULL,NULL,30,'cnic_no','4240133594485'),(378,NULL,NULL,NULL,30,'cnic_expiry',''),(379,NULL,NULL,NULL,30,'cnic_name',''),(380,NULL,NULL,NULL,30,'cnic_address',''),(381,NULL,NULL,NULL,30,'nicop_no',''),(382,NULL,NULL,NULL,30,'nicop_expiry',''),(383,NULL,NULL,NULL,30,'nicop_name',''),(384,NULL,NULL,NULL,30,'nicop_address',''),(385,NULL,NULL,NULL,30,'passport_no',''),(386,NULL,NULL,NULL,30,'passport_expiry',''),(387,NULL,NULL,NULL,30,'passport_name',''),(388,NULL,NULL,NULL,30,'passport_address',''),(389,NULL,NULL,NULL,30,'eobi_no',''),(390,NULL,NULL,NULL,30,'eobi_date',''),(391,NULL,NULL,NULL,30,'eobi_sno',''),(392,NULL,NULL,NULL,30,'ntn_no',''),(393,NULL,NULL,NULL,30,'probation_from',''),(394,NULL,NULL,NULL,30,'probation_to',''),(395,NULL,NULL,NULL,30,'company_id','1'),(396,NULL,NULL,NULL,30,'ramzan_enayat','0'),(397,NULL,NULL,NULL,30,'created_at','2022-07-13 10:29:38'),(398,NULL,NULL,NULL,30,'created_by_id','1'),(399,NULL,NULL,NULL,30,'modified_at','2022-07-13 10:29:38'),(400,NULL,NULL,NULL,30,'modified_by_id','1'),(401,NULL,NULL,NULL,30,'employee_id','{CB300019-C61B-9114-4A11-985F5A525FBB}'),(402,NULL,NULL,NULL,31,'company_id','1'),(403,NULL,NULL,NULL,31,'department_code','1'),(404,NULL,NULL,NULL,31,'department_name','Mobile App Development'),(405,NULL,NULL,NULL,31,'address','Address'),(406,NULL,NULL,NULL,31,'phone_no','121121'),(407,NULL,NULL,NULL,31,'party_id','1234'),(408,NULL,NULL,NULL,31,'ah_key','1234'),(409,NULL,NULL,NULL,31,'budget_key','1234'),(410,NULL,NULL,NULL,31,'deduction_days',''),(411,NULL,NULL,NULL,31,'deduction_percent',''),(412,NULL,NULL,NULL,31,'override_attendance_policy','0'),(413,NULL,NULL,NULL,31,'override_allowance_policy','0'),(414,NULL,NULL,NULL,31,'attendance_exempted','0'),(415,NULL,NULL,NULL,31,'created_at','2022-07-13 10:49:39'),(416,NULL,NULL,NULL,31,'created_by_id','1'),(417,NULL,NULL,NULL,31,'modified_at','2022-07-13 10:49:39'),(418,NULL,NULL,NULL,31,'modified_by_id','1'),(419,NULL,NULL,NULL,32,'company_id','1'),(420,NULL,NULL,NULL,32,'department_code','2'),(421,NULL,NULL,NULL,32,'department_name','Web App Development'),(422,NULL,NULL,NULL,32,'address','Address'),(423,NULL,NULL,NULL,32,'phone_no','1234'),(424,NULL,NULL,NULL,32,'party_id','1234'),(425,NULL,NULL,NULL,32,'ah_key','1234'),(426,NULL,NULL,NULL,32,'budget_key','1234'),(427,NULL,NULL,NULL,32,'deduction_days',''),(428,NULL,NULL,NULL,32,'deduction_percent',''),(429,NULL,NULL,NULL,32,'override_attendance_policy','0'),(430,NULL,NULL,NULL,32,'override_allowance_policy','0'),(431,NULL,NULL,NULL,32,'attendance_exempted','0'),(432,NULL,NULL,NULL,32,'created_at','2022-07-13 10:50:08'),(433,NULL,NULL,NULL,32,'created_by_id','1'),(434,NULL,NULL,NULL,32,'modified_at','2022-07-13 10:50:08'),(435,NULL,NULL,NULL,32,'modified_by_id','1'),(436,NULL,NULL,NULL,33,'company_id','1'),(437,NULL,NULL,NULL,33,'department_code','3'),(438,NULL,NULL,NULL,33,'department_name','Quality Assurrance'),(439,NULL,NULL,NULL,33,'address','Address'),(440,NULL,NULL,NULL,33,'phone_no','1234'),(441,NULL,NULL,NULL,33,'party_id','1234'),(442,NULL,NULL,NULL,33,'ah_key','1234'),(443,NULL,NULL,NULL,33,'budget_key','1234'),(444,NULL,NULL,NULL,33,'deduction_days',''),(445,NULL,NULL,NULL,33,'deduction_percent',''),(446,NULL,NULL,NULL,33,'override_attendance_policy','0'),(447,NULL,NULL,NULL,33,'override_allowance_policy','0'),(448,NULL,NULL,NULL,33,'attendance_exempted','0'),(449,NULL,NULL,NULL,33,'created_at','2022-07-13 10:50:31'),(450,NULL,NULL,NULL,33,'created_by_id','1'),(451,NULL,NULL,NULL,33,'modified_at','2022-07-13 10:50:31'),(452,NULL,NULL,NULL,33,'modified_by_id','1'),(453,NULL,NULL,NULL,34,'company_id','1'),(454,NULL,NULL,NULL,34,'department_code','4'),(455,NULL,NULL,NULL,34,'department_name','Designing'),(456,NULL,NULL,NULL,34,'address','1234'),(457,NULL,NULL,NULL,34,'phone_no','1234'),(458,NULL,NULL,NULL,34,'party_id','1234'),(459,NULL,NULL,NULL,34,'ah_key','1234'),(460,NULL,NULL,NULL,34,'budget_key','1234'),(461,NULL,NULL,NULL,34,'deduction_days',''),(462,NULL,NULL,NULL,34,'deduction_percent',''),(463,NULL,NULL,NULL,34,'override_attendance_policy','0'),(464,NULL,NULL,NULL,34,'override_allowance_policy','0'),(465,NULL,NULL,NULL,34,'attendance_exempted','0'),(466,NULL,NULL,NULL,34,'created_at','2022-07-13 10:51:13'),(467,NULL,NULL,NULL,34,'created_by_id','1'),(468,NULL,NULL,NULL,34,'modified_at','2022-07-13 10:51:13'),(469,NULL,NULL,NULL,34,'modified_by_id','1'),(470,NULL,NULL,NULL,35,'company_id','1'),(471,NULL,NULL,NULL,35,'department_code','5'),(472,NULL,NULL,NULL,35,'department_name','Management'),(473,NULL,NULL,NULL,35,'address','Address'),(474,NULL,NULL,NULL,35,'phone_no','1234'),(475,NULL,NULL,NULL,35,'party_id','1234'),(476,NULL,NULL,NULL,35,'ah_key','1234'),(477,NULL,NULL,NULL,35,'budget_key','1234'),(478,NULL,NULL,NULL,35,'deduction_days',''),(479,NULL,NULL,NULL,35,'deduction_percent',''),(480,NULL,NULL,NULL,35,'override_attendance_policy','0'),(481,NULL,NULL,NULL,35,'override_allowance_policy','0'),(482,NULL,NULL,NULL,35,'attendance_exempted','0'),(483,NULL,NULL,NULL,35,'created_at','2022-07-13 10:51:36'),(484,NULL,NULL,NULL,35,'created_by_id','1'),(485,NULL,NULL,NULL,35,'modified_at','2022-07-13 10:51:36'),(486,NULL,NULL,NULL,35,'modified_by_id','1'),(487,NULL,NULL,NULL,36,'company_id','1'),(488,NULL,NULL,NULL,36,'department_code','6'),(489,NULL,NULL,NULL,36,'department_name','Customer Support'),(490,NULL,NULL,NULL,36,'address','Address'),(491,NULL,NULL,NULL,36,'phone_no','1234'),(492,NULL,NULL,NULL,36,'party_id','1234'),(493,NULL,NULL,NULL,36,'ah_key','1234'),(494,NULL,NULL,NULL,36,'budget_key','1234'),(495,NULL,NULL,NULL,36,'deduction_days',''),(496,NULL,NULL,NULL,36,'deduction_percent',''),(497,NULL,NULL,NULL,36,'override_attendance_policy','0'),(498,NULL,NULL,NULL,36,'override_allowance_policy','0'),(499,NULL,NULL,NULL,36,'attendance_exempted','0'),(500,NULL,NULL,NULL,36,'created_at','2022-07-13 10:52:17'),(501,NULL,NULL,NULL,36,'created_by_id','1'),(502,NULL,NULL,NULL,36,'modified_at','2022-07-13 10:52:17'),(503,NULL,NULL,NULL,36,'modified_by_id','1'),(504,NULL,NULL,NULL,37,'company_id','1'),(505,NULL,NULL,NULL,37,'department_code','7'),(506,NULL,NULL,NULL,37,'department_name','App Development'),(507,NULL,NULL,NULL,37,'address','Address'),(508,NULL,NULL,NULL,37,'phone_no','1234'),(509,NULL,NULL,NULL,37,'party_id','1234'),(510,NULL,NULL,NULL,37,'ah_key','1234'),(511,NULL,NULL,NULL,37,'budget_key','1234'),(512,NULL,NULL,NULL,37,'deduction_days',''),(513,NULL,NULL,NULL,37,'deduction_percent',''),(514,NULL,NULL,NULL,37,'override_attendance_policy','0'),(515,NULL,NULL,NULL,37,'override_allowance_policy','0'),(516,NULL,NULL,NULL,37,'attendance_exempted','0'),(517,NULL,NULL,NULL,37,'created_at','2022-07-13 11:43:43'),(518,NULL,NULL,NULL,37,'created_by_id','1'),(519,NULL,NULL,NULL,37,'modified_at','2022-07-13 11:43:43'),(520,NULL,NULL,NULL,37,'modified_by_id','1'),(521,NULL,NULL,NULL,38,'company_id','1'),(522,NULL,NULL,NULL,38,'department_code','8'),(523,NULL,NULL,NULL,38,'department_name','Data Analysis'),(524,NULL,NULL,NULL,38,'address','Address'),(525,NULL,NULL,NULL,38,'phone_no','1234'),(526,NULL,NULL,NULL,38,'party_id','1234'),(527,NULL,NULL,NULL,38,'ah_key','1234'),(528,NULL,NULL,NULL,38,'budget_key','1234'),(529,NULL,NULL,NULL,38,'deduction_days',''),(530,NULL,NULL,NULL,38,'deduction_percent',''),(531,NULL,NULL,NULL,38,'override_attendance_policy','0'),(532,NULL,NULL,NULL,38,'override_allowance_policy','0'),(533,NULL,NULL,NULL,38,'attendance_exempted','0'),(534,NULL,NULL,NULL,38,'created_at','2022-07-13 11:44:33'),(535,NULL,NULL,NULL,38,'created_by_id','1'),(536,NULL,NULL,NULL,38,'modified_at','2022-07-13 11:44:33'),(537,NULL,NULL,NULL,38,'modified_by_id','1'),(538,NULL,NULL,NULL,39,'designation_name','Web App Developer'),(539,NULL,NULL,NULL,39,'created_at','2022-07-13 11:45:51'),(540,NULL,NULL,NULL,39,'created_by_id','1'),(541,NULL,NULL,NULL,39,'modified_at','2022-07-13 11:45:51'),(542,NULL,NULL,NULL,39,'modified_by_id','1'),(543,NULL,NULL,NULL,40,'designation_name','Mobile App Developer'),(544,NULL,NULL,NULL,40,'created_at','2022-07-13 11:45:57'),(545,NULL,NULL,NULL,40,'created_by_id','1'),(546,NULL,NULL,NULL,40,'modified_at','2022-07-13 11:45:57'),(547,NULL,NULL,NULL,40,'modified_by_id','1'),(548,NULL,NULL,NULL,41,'designation_name','Quality Assurance Engineer'),(549,NULL,NULL,NULL,41,'created_at','2022-07-13 11:46:08'),(550,NULL,NULL,NULL,41,'created_by_id','1'),(551,NULL,NULL,NULL,41,'modified_at','2022-07-13 11:46:08'),(552,NULL,NULL,NULL,41,'modified_by_id','1'),(553,NULL,NULL,NULL,42,'designation_name','Web Designer'),(554,NULL,NULL,NULL,42,'created_at','2022-07-13 11:49:00'),(555,NULL,NULL,NULL,42,'created_by_id','1'),(556,NULL,NULL,NULL,42,'modified_at','2022-07-13 11:49:00'),(557,NULL,NULL,NULL,42,'modified_by_id','1'),(558,NULL,NULL,NULL,43,'designation_name','Project Manager'),(559,NULL,NULL,NULL,43,'created_at','2022-07-13 11:49:09'),(560,NULL,NULL,NULL,43,'created_by_id','1'),(561,NULL,NULL,NULL,43,'modified_at','2022-07-13 11:49:09'),(562,NULL,NULL,NULL,43,'modified_by_id','1'),(563,NULL,NULL,NULL,44,'designation_name','Chief Technical Officer'),(564,NULL,NULL,NULL,44,'created_at','2022-07-13 11:49:22'),(565,NULL,NULL,NULL,44,'created_by_id','1'),(566,NULL,NULL,NULL,44,'modified_at','2022-07-13 11:49:22'),(567,NULL,NULL,NULL,44,'modified_by_id','1'),(568,NULL,NULL,NULL,45,'designation_name','Chief Executive Officer'),(569,NULL,NULL,NULL,45,'created_at','2022-07-13 11:49:31'),(570,NULL,NULL,NULL,45,'created_by_id','1'),(571,NULL,NULL,NULL,45,'modified_at','2022-07-13 11:49:31'),(572,NULL,NULL,NULL,45,'modified_by_id','1'),(573,NULL,NULL,NULL,46,'designation_name','Customer Support Representative'),(574,NULL,NULL,NULL,46,'created_at','2022-07-13 11:49:39'),(575,NULL,NULL,NULL,46,'created_by_id','1'),(576,NULL,NULL,NULL,46,'modified_at','2022-07-13 11:49:39'),(577,NULL,NULL,NULL,46,'modified_by_id','1'),(578,NULL,NULL,NULL,47,'designation_name','Sr. Software Developer'),(579,NULL,NULL,NULL,47,'created_at','2022-07-13 11:50:25'),(580,NULL,NULL,NULL,47,'created_by_id','1'),(581,NULL,NULL,NULL,47,'modified_at','2022-07-13 11:50:25'),(582,NULL,NULL,NULL,47,'modified_by_id','1'),(583,NULL,NULL,NULL,48,'designation_name','Sr  Software Engineer / Team Lead'),(584,NULL,NULL,NULL,48,'created_at','2022-07-13 11:50:38'),(585,NULL,NULL,NULL,48,'created_by_id','1'),(586,NULL,NULL,NULL,48,'modified_at','2022-07-13 11:50:38'),(587,NULL,NULL,NULL,48,'modified_by_id','1'),(588,NULL,NULL,NULL,49,'designation_name','Data Analyst'),(589,NULL,NULL,NULL,49,'created_at','2022-07-13 11:50:52'),(590,NULL,NULL,NULL,49,'created_by_id','1'),(591,NULL,NULL,NULL,49,'modified_at','2022-07-13 11:50:52'),(592,NULL,NULL,NULL,49,'modified_by_id','1'),(593,NULL,NULL,NULL,50,'designation_name','QA and Development'),(594,NULL,NULL,NULL,50,'created_at','2022-07-13 11:51:20'),(595,NULL,NULL,NULL,50,'created_by_id','1'),(596,NULL,NULL,NULL,50,'modified_at','2022-07-13 11:51:20'),(597,NULL,NULL,NULL,50,'modified_by_id','1'),(598,NULL,NULL,NULL,51,'primary_key','{F5C5C174-2335-8100-CAD2-8DFB25547310}'),(599,NULL,NULL,NULL,51,'registration_code','1'),(600,NULL,NULL,NULL,51,'department_id','13'),(601,NULL,NULL,NULL,51,'employee_id','{678C8595-FE95-7172-C734-F8100EF6A8AF}'),(602,NULL,NULL,NULL,51,'employee_code','1'),(603,NULL,NULL,NULL,51,'employee_name','Taikhum Shabbir Farhullah'),(604,NULL,NULL,NULL,51,'designation_id','5'),(605,NULL,NULL,NULL,51,'attendance_shift_id','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}'),(606,NULL,NULL,NULL,51,'attendance_code','1'),(607,NULL,NULL,NULL,51,'joining_date','2020-06-15'),(608,NULL,NULL,NULL,51,'status','Active'),(609,NULL,NULL,NULL,51,'leaving_date',''),(610,NULL,NULL,NULL,51,'employee_bank_id',''),(611,NULL,NULL,NULL,51,'bank_id',''),(612,NULL,NULL,NULL,51,'bank_account',''),(613,NULL,NULL,NULL,51,'bank_title',''),(614,NULL,NULL,NULL,51,'bank_iban',''),(615,NULL,NULL,NULL,51,'party_id','0'),(616,NULL,NULL,NULL,51,'total_payroll','0'),(617,NULL,NULL,NULL,51,'arrears','0.00'),(618,NULL,NULL,NULL,51,'wef_date',''),(619,NULL,NULL,NULL,51,'employee_salary_id',''),(620,NULL,NULL,NULL,51,'basic_salary',''),(621,NULL,NULL,NULL,51,'taxable','Yes'),(622,NULL,NULL,NULL,51,'taxable_house_rent_percent',''),(623,NULL,NULL,NULL,51,'employee_allowances',''),(624,NULL,NULL,NULL,51,'employee_deductions',''),(625,NULL,NULL,NULL,51,'total_allowance',''),(626,NULL,NULL,NULL,51,'gross_amount',''),(627,NULL,NULL,NULL,51,'taxable_amount',''),(628,NULL,NULL,NULL,51,'total_deduction',''),(629,NULL,NULL,NULL,51,'net_amount',''),(630,NULL,NULL,NULL,51,'deduction_days',''),(631,NULL,NULL,NULL,51,'deduction_percent',''),(632,NULL,NULL,NULL,51,'override_attendance_policy','0'),(633,NULL,NULL,NULL,51,'override_allowance_policy','0'),(634,NULL,NULL,NULL,51,'attendance_exempted','0'),(635,NULL,NULL,NULL,51,'company_id','2'),(636,NULL,NULL,NULL,51,'modified_at','2022-07-13 11:59:36'),(637,NULL,NULL,NULL,51,'modified_by_id','1'),(638,NULL,NULL,NULL,52,'primary_key','{B0BC566C-2391-2C7A-8280-FE896029900B}'),(639,NULL,NULL,NULL,52,'registration_code','104'),(640,NULL,NULL,NULL,52,'department_id','15'),(641,NULL,NULL,NULL,52,'employee_id','{71748319-2DD8-13B6-1633-23E3E2850287}'),(642,NULL,NULL,NULL,52,'employee_code','4'),(643,NULL,NULL,NULL,52,'employee_name','Syed Yahya Hussaini'),(644,NULL,NULL,NULL,52,'designation_id','9'),(645,NULL,NULL,NULL,52,'attendance_shift_id','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}'),(646,NULL,NULL,NULL,52,'attendance_code','4'),(647,NULL,NULL,NULL,52,'joining_date',''),(648,NULL,NULL,NULL,52,'status','Active'),(649,NULL,NULL,NULL,52,'leaving_date',''),(650,NULL,NULL,NULL,52,'employee_bank_id',''),(651,NULL,NULL,NULL,52,'bank_id',''),(652,NULL,NULL,NULL,52,'bank_account',''),(653,NULL,NULL,NULL,52,'bank_title',''),(654,NULL,NULL,NULL,52,'bank_iban',''),(655,NULL,NULL,NULL,52,'party_id','0'),(656,NULL,NULL,NULL,52,'total_payroll','0'),(657,NULL,NULL,NULL,52,'arrears','0.00'),(658,NULL,NULL,NULL,52,'wef_date',''),(659,NULL,NULL,NULL,52,'employee_salary_id',''),(660,NULL,NULL,NULL,52,'basic_salary',''),(661,NULL,NULL,NULL,52,'taxable','Yes'),(662,NULL,NULL,NULL,52,'taxable_house_rent_percent',''),(663,NULL,NULL,NULL,52,'employee_allowances',''),(664,NULL,NULL,NULL,52,'employee_deductions',''),(665,NULL,NULL,NULL,52,'total_allowance',''),(666,NULL,NULL,NULL,52,'gross_amount',''),(667,NULL,NULL,NULL,52,'taxable_amount',''),(668,NULL,NULL,NULL,52,'total_deduction',''),(669,NULL,NULL,NULL,52,'net_amount',''),(670,NULL,NULL,NULL,52,'deduction_days',''),(671,NULL,NULL,NULL,52,'deduction_percent',''),(672,NULL,NULL,NULL,52,'override_attendance_policy','0'),(673,NULL,NULL,NULL,52,'override_allowance_policy','0'),(674,NULL,NULL,NULL,52,'attendance_exempted','0'),(675,NULL,NULL,NULL,52,'company_id','2'),(676,NULL,NULL,NULL,52,'modified_at','2022-07-13 12:01:35'),(677,NULL,NULL,NULL,52,'modified_by_id','1'),(678,NULL,NULL,NULL,53,'primary_key','{0D8542CE-74AE-37F4-777E-D6411FE52A9B}'),(679,NULL,NULL,NULL,53,'registration_code','105'),(680,NULL,NULL,NULL,53,'department_id','10'),(681,NULL,NULL,NULL,53,'employee_id','{8833635A-60E7-27B6-870A-549B9E7D76C2}'),(682,NULL,NULL,NULL,53,'employee_code','8'),(683,NULL,NULL,NULL,53,'employee_name','Saad Ullah Khan'),(684,NULL,NULL,NULL,53,'designation_id','1'),(685,NULL,NULL,NULL,53,'attendance_shift_id','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}'),(686,NULL,NULL,NULL,53,'attendance_code','8'),(687,NULL,NULL,NULL,53,'joining_date',''),(688,NULL,NULL,NULL,53,'status','Active'),(689,NULL,NULL,NULL,53,'leaving_date',''),(690,NULL,NULL,NULL,53,'employee_bank_id',''),(691,NULL,NULL,NULL,53,'bank_id',''),(692,NULL,NULL,NULL,53,'bank_account',''),(693,NULL,NULL,NULL,53,'bank_title',''),(694,NULL,NULL,NULL,53,'bank_iban',''),(695,NULL,NULL,NULL,53,'party_id','0'),(696,NULL,NULL,NULL,53,'total_payroll','0'),(697,NULL,NULL,NULL,53,'arrears','0.00'),(698,NULL,NULL,NULL,53,'wef_date',''),(699,NULL,NULL,NULL,53,'employee_salary_id',''),(700,NULL,NULL,NULL,53,'basic_salary',''),(701,NULL,NULL,NULL,53,'taxable','Yes'),(702,NULL,NULL,NULL,53,'taxable_house_rent_percent',''),(703,NULL,NULL,NULL,53,'employee_allowances',''),(704,NULL,NULL,NULL,53,'employee_deductions',''),(705,NULL,NULL,NULL,53,'total_allowance',''),(706,NULL,NULL,NULL,53,'gross_amount',''),(707,NULL,NULL,NULL,53,'taxable_amount',''),(708,NULL,NULL,NULL,53,'total_deduction',''),(709,NULL,NULL,NULL,53,'net_amount',''),(710,NULL,NULL,NULL,53,'deduction_days',''),(711,NULL,NULL,NULL,53,'deduction_percent',''),(712,NULL,NULL,NULL,53,'override_attendance_policy','0'),(713,NULL,NULL,NULL,53,'override_allowance_policy','0'),(714,NULL,NULL,NULL,53,'attendance_exempted','0'),(715,NULL,NULL,NULL,53,'company_id','2'),(716,NULL,NULL,NULL,53,'modified_at','2022-07-13 12:02:02'),(717,NULL,NULL,NULL,53,'modified_by_id','1'),(718,NULL,NULL,NULL,54,'primary_key','{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}'),(719,NULL,NULL,NULL,54,'registration_code','106'),(720,NULL,NULL,NULL,54,'department_id','10'),(721,NULL,NULL,NULL,54,'employee_id','{98C03A27-A91B-D2E3-C80A-FE51F76B90F3}'),(722,NULL,NULL,NULL,54,'employee_code','9'),(723,NULL,NULL,NULL,54,'employee_name','Syed Raza Haider'),(724,NULL,NULL,NULL,54,'designation_id','10'),(725,NULL,NULL,NULL,54,'attendance_shift_id','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}'),(726,NULL,NULL,NULL,54,'attendance_code','9'),(727,NULL,NULL,NULL,54,'joining_date','2022-09-05'),(728,NULL,NULL,NULL,54,'status','Active'),(729,NULL,NULL,NULL,54,'leaving_date',''),(730,NULL,NULL,NULL,54,'employee_bank_id',''),(731,NULL,NULL,NULL,54,'bank_id',''),(732,NULL,NULL,NULL,54,'bank_account',''),(733,NULL,NULL,NULL,54,'bank_title',''),(734,NULL,NULL,NULL,54,'bank_iban',''),(735,NULL,NULL,NULL,54,'party_id','0'),(736,NULL,NULL,NULL,54,'total_payroll','0'),(737,NULL,NULL,NULL,54,'arrears','0.00'),(738,NULL,NULL,NULL,54,'wef_date',''),(739,NULL,NULL,NULL,54,'employee_salary_id',''),(740,NULL,NULL,NULL,54,'basic_salary',''),(741,NULL,NULL,NULL,54,'taxable','Yes'),(742,NULL,NULL,NULL,54,'taxable_house_rent_percent',''),(743,NULL,NULL,NULL,54,'employee_allowances',''),(744,NULL,NULL,NULL,54,'employee_deductions',''),(745,NULL,NULL,NULL,54,'total_allowance',''),(746,NULL,NULL,NULL,54,'gross_amount',''),(747,NULL,NULL,NULL,54,'taxable_amount',''),(748,NULL,NULL,NULL,54,'total_deduction',''),(749,NULL,NULL,NULL,54,'net_amount',''),(750,NULL,NULL,NULL,54,'deduction_days',''),(751,NULL,NULL,NULL,54,'deduction_percent',''),(752,NULL,NULL,NULL,54,'override_attendance_policy','0'),(753,NULL,NULL,NULL,54,'override_allowance_policy','0'),(754,NULL,NULL,NULL,54,'attendance_exempted','0'),(755,NULL,NULL,NULL,54,'company_id','2'),(756,NULL,NULL,NULL,54,'modified_at','2022-07-13 12:02:24'),(757,NULL,NULL,NULL,54,'modified_by_id','1'),(758,NULL,NULL,NULL,55,'primary_key','{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}'),(759,NULL,NULL,NULL,55,'registration_code','107'),(760,NULL,NULL,NULL,55,'department_id','12'),(761,NULL,NULL,NULL,55,'employee_id','{1B6A9CE0-6AA1-9E91-301D-0331CFE876BE}'),(762,NULL,NULL,NULL,55,'employee_code','10'),(763,NULL,NULL,NULL,55,'employee_name','Muhammad Hammad Wajid'),(764,NULL,NULL,NULL,55,'designation_id','4'),(765,NULL,NULL,NULL,55,'attendance_shift_id','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}'),(766,NULL,NULL,NULL,55,'attendance_code','10'),(767,NULL,NULL,NULL,55,'joining_date',''),(768,NULL,NULL,NULL,55,'status','Active'),(769,NULL,NULL,NULL,55,'leaving_date',''),(770,NULL,NULL,NULL,55,'employee_bank_id',''),(771,NULL,NULL,NULL,55,'bank_id',''),(772,NULL,NULL,NULL,55,'bank_account',''),(773,NULL,NULL,NULL,55,'bank_title',''),(774,NULL,NULL,NULL,55,'bank_iban',''),(775,NULL,NULL,NULL,55,'party_id','0'),(776,NULL,NULL,NULL,55,'total_payroll','0'),(777,NULL,NULL,NULL,55,'arrears','0.00'),(778,NULL,NULL,NULL,55,'wef_date',''),(779,NULL,NULL,NULL,55,'employee_salary_id',''),(780,NULL,NULL,NULL,55,'basic_salary',''),(781,NULL,NULL,NULL,55,'taxable','Yes'),(782,NULL,NULL,NULL,55,'taxable_house_rent_percent',''),(783,NULL,NULL,NULL,55,'employee_allowances',''),(784,NULL,NULL,NULL,55,'employee_deductions',''),(785,NULL,NULL,NULL,55,'total_allowance',''),(786,NULL,NULL,NULL,55,'gross_amount',''),(787,NULL,NULL,NULL,55,'taxable_amount',''),(788,NULL,NULL,NULL,55,'total_deduction',''),(789,NULL,NULL,NULL,55,'net_amount',''),(790,NULL,NULL,NULL,55,'deduction_days',''),(791,NULL,NULL,NULL,55,'deduction_percent',''),(792,NULL,NULL,NULL,55,'override_attendance_policy','0'),(793,NULL,NULL,NULL,55,'override_allowance_policy','0'),(794,NULL,NULL,NULL,55,'attendance_exempted','0'),(795,NULL,NULL,NULL,55,'company_id','2'),(796,NULL,NULL,NULL,55,'modified_at','2022-07-13 12:02:49'),(797,NULL,NULL,NULL,55,'modified_by_id','1'),(798,NULL,NULL,NULL,56,'primary_key','{86464FAB-D7E9-0A62-5F9F-4B80473EA081}'),(799,NULL,NULL,NULL,56,'registration_code','108'),(800,NULL,NULL,NULL,56,'department_id','11'),(801,NULL,NULL,NULL,56,'employee_id','{8EE598C0-72A2-513F-3FB5-79D8A617DB03}'),(802,NULL,NULL,NULL,56,'employee_code','11'),(803,NULL,NULL,NULL,56,'employee_name','Anum Mehfooz Alam'),(804,NULL,NULL,NULL,56,'designation_id','12'),(805,NULL,NULL,NULL,56,'attendance_shift_id','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}'),(806,NULL,NULL,NULL,56,'attendance_code','11'),(807,NULL,NULL,NULL,56,'joining_date','2022-02-03'),(808,NULL,NULL,NULL,56,'status','Active'),(809,NULL,NULL,NULL,56,'leaving_date',''),(810,NULL,NULL,NULL,56,'employee_bank_id',''),(811,NULL,NULL,NULL,56,'bank_id',''),(812,NULL,NULL,NULL,56,'bank_account',''),(813,NULL,NULL,NULL,56,'bank_title',''),(814,NULL,NULL,NULL,56,'bank_iban',''),(815,NULL,NULL,NULL,56,'party_id','0'),(816,NULL,NULL,NULL,56,'total_payroll','0'),(817,NULL,NULL,NULL,56,'arrears','0.00'),(818,NULL,NULL,NULL,56,'wef_date',''),(819,NULL,NULL,NULL,56,'employee_salary_id',''),(820,NULL,NULL,NULL,56,'basic_salary',''),(821,NULL,NULL,NULL,56,'taxable','Yes'),(822,NULL,NULL,NULL,56,'taxable_house_rent_percent',''),(823,NULL,NULL,NULL,56,'employee_allowances',''),(824,NULL,NULL,NULL,56,'employee_deductions',''),(825,NULL,NULL,NULL,56,'total_allowance',''),(826,NULL,NULL,NULL,56,'gross_amount',''),(827,NULL,NULL,NULL,56,'taxable_amount',''),(828,NULL,NULL,NULL,56,'total_deduction',''),(829,NULL,NULL,NULL,56,'net_amount',''),(830,NULL,NULL,NULL,56,'deduction_days',''),(831,NULL,NULL,NULL,56,'deduction_percent',''),(832,NULL,NULL,NULL,56,'override_attendance_policy','0'),(833,NULL,NULL,NULL,56,'override_allowance_policy','0'),(834,NULL,NULL,NULL,56,'attendance_exempted','0'),(835,NULL,NULL,NULL,56,'company_id','2'),(836,NULL,NULL,NULL,56,'modified_at','2022-07-13 12:03:11'),(837,NULL,NULL,NULL,56,'modified_by_id','1'),(838,NULL,NULL,NULL,57,'primary_key','{D8C42212-5A32-236C-9652-51151DE1D56B}'),(839,NULL,NULL,NULL,57,'registration_code','109'),(840,NULL,NULL,NULL,57,'department_id','10'),(841,NULL,NULL,NULL,57,'employee_id','{340DF38A-79D0-5857-2379-3764F88F7BB2}'),(842,NULL,NULL,NULL,57,'employee_code','12'),(843,NULL,NULL,NULL,57,'employee_name','Muhammad Owais Afsar'),(844,NULL,NULL,NULL,57,'designation_id','1'),(845,NULL,NULL,NULL,57,'attendance_shift_id','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}'),(846,NULL,NULL,NULL,57,'attendance_code','12'),(847,NULL,NULL,NULL,57,'joining_date','2021-01-06'),(848,NULL,NULL,NULL,57,'status','Active'),(849,NULL,NULL,NULL,57,'leaving_date',''),(850,NULL,NULL,NULL,57,'employee_bank_id',''),(851,NULL,NULL,NULL,57,'bank_id',''),(852,NULL,NULL,NULL,57,'bank_account',''),(853,NULL,NULL,NULL,57,'bank_title',''),(854,NULL,NULL,NULL,57,'bank_iban',''),(855,NULL,NULL,NULL,57,'party_id','0'),(856,NULL,NULL,NULL,57,'total_payroll','0'),(857,NULL,NULL,NULL,57,'arrears','0.00'),(858,NULL,NULL,NULL,57,'wef_date',''),(859,NULL,NULL,NULL,57,'employee_salary_id',''),(860,NULL,NULL,NULL,57,'basic_salary',''),(861,NULL,NULL,NULL,57,'taxable','Yes'),(862,NULL,NULL,NULL,57,'taxable_house_rent_percent',''),(863,NULL,NULL,NULL,57,'employee_allowances',''),(864,NULL,NULL,NULL,57,'employee_deductions',''),(865,NULL,NULL,NULL,57,'total_allowance',''),(866,NULL,NULL,NULL,57,'gross_amount',''),(867,NULL,NULL,NULL,57,'taxable_amount',''),(868,NULL,NULL,NULL,57,'total_deduction',''),(869,NULL,NULL,NULL,57,'net_amount',''),(870,NULL,NULL,NULL,57,'deduction_days',''),(871,NULL,NULL,NULL,57,'deduction_percent',''),(872,NULL,NULL,NULL,57,'override_attendance_policy','0'),(873,NULL,NULL,NULL,57,'override_allowance_policy','0'),(874,NULL,NULL,NULL,57,'attendance_exempted','0'),(875,NULL,NULL,NULL,57,'company_id','2'),(876,NULL,NULL,NULL,57,'modified_at','2022-07-13 12:04:37'),(877,NULL,NULL,NULL,57,'modified_by_id','1'),(878,NULL,NULL,NULL,58,'primary_key','{4D7622CE-465D-7B03-5B9C-5277A8F063B0}'),(879,NULL,NULL,NULL,58,'registration_code','2'),(880,NULL,NULL,NULL,58,'department_id','1'),(881,NULL,NULL,NULL,58,'employee_id','{FEEE3174-89B3-CF50-6419-964421B981CE}'),(882,NULL,NULL,NULL,58,'employee_code','2'),(883,NULL,NULL,NULL,58,'employee_name','Maaz Uddin Khan'),(884,NULL,NULL,NULL,58,'designation_id','2'),(885,NULL,NULL,NULL,58,'attendance_code','2'),(886,NULL,NULL,NULL,58,'joining_date','2022-05-23'),(887,NULL,NULL,NULL,58,'status','Active'),(888,NULL,NULL,NULL,58,'leaving_date',''),(889,NULL,NULL,NULL,58,'employee_bank_id',''),(890,NULL,NULL,NULL,58,'bank_id',''),(891,NULL,NULL,NULL,58,'bank_account',''),(892,NULL,NULL,NULL,58,'bank_title',''),(893,NULL,NULL,NULL,58,'bank_iban',''),(894,NULL,NULL,NULL,58,'party_id','0'),(895,NULL,NULL,NULL,58,'total_payroll','0'),(896,NULL,NULL,NULL,58,'arrears','0.00'),(897,NULL,NULL,NULL,58,'wef_date',''),(898,NULL,NULL,NULL,58,'employee_salary_id',''),(899,NULL,NULL,NULL,58,'basic_salary',''),(900,NULL,NULL,NULL,58,'taxable','Yes'),(901,NULL,NULL,NULL,58,'taxable_house_rent_percent',''),(902,NULL,NULL,NULL,58,'employee_allowances',''),(903,NULL,NULL,NULL,58,'employee_deductions',''),(904,NULL,NULL,NULL,58,'total_allowance',''),(905,NULL,NULL,NULL,58,'gross_amount',''),(906,NULL,NULL,NULL,58,'taxable_amount',''),(907,NULL,NULL,NULL,58,'total_deduction',''),(908,NULL,NULL,NULL,58,'net_amount',''),(909,NULL,NULL,NULL,58,'deduction_days',''),(910,NULL,NULL,NULL,58,'deduction_percent',''),(911,NULL,NULL,NULL,58,'override_attendance_policy','0'),(912,NULL,NULL,NULL,58,'override_allowance_policy','0'),(913,NULL,NULL,NULL,58,'attendance_exempted','0'),(914,NULL,NULL,NULL,58,'company_id','1'),(915,NULL,NULL,NULL,58,'modified_at','2022-07-13 12:05:10'),(916,NULL,NULL,NULL,58,'modified_by_id','1'),(917,NULL,NULL,NULL,59,'primary_key','{175EE610-BF1A-BF01-5A7F-904823C47108}'),(918,NULL,NULL,NULL,59,'registration_code','3'),(919,NULL,NULL,NULL,59,'department_id','6'),(920,NULL,NULL,NULL,59,'employee_id','{72C7BDF0-E50A-DABA-D59E-A2791B1E9033}'),(921,NULL,NULL,NULL,59,'employee_code','3'),(922,NULL,NULL,NULL,59,'employee_name','Uzair Anwar Kaimkhani'),(923,NULL,NULL,NULL,59,'designation_id','8'),(924,NULL,NULL,NULL,59,'attendance_code','3'),(925,NULL,NULL,NULL,59,'joining_date',''),(926,NULL,NULL,NULL,59,'status','Active'),(927,NULL,NULL,NULL,59,'leaving_date',''),(928,NULL,NULL,NULL,59,'employee_bank_id',''),(929,NULL,NULL,NULL,59,'bank_id',''),(930,NULL,NULL,NULL,59,'bank_account',''),(931,NULL,NULL,NULL,59,'bank_title',''),(932,NULL,NULL,NULL,59,'bank_iban',''),(933,NULL,NULL,NULL,59,'party_id','0'),(934,NULL,NULL,NULL,59,'total_payroll','0'),(935,NULL,NULL,NULL,59,'arrears','0.00'),(936,NULL,NULL,NULL,59,'wef_date',''),(937,NULL,NULL,NULL,59,'employee_salary_id',''),(938,NULL,NULL,NULL,59,'basic_salary',''),(939,NULL,NULL,NULL,59,'taxable','Yes'),(940,NULL,NULL,NULL,59,'taxable_house_rent_percent',''),(941,NULL,NULL,NULL,59,'employee_allowances',''),(942,NULL,NULL,NULL,59,'employee_deductions',''),(943,NULL,NULL,NULL,59,'total_allowance',''),(944,NULL,NULL,NULL,59,'gross_amount',''),(945,NULL,NULL,NULL,59,'taxable_amount',''),(946,NULL,NULL,NULL,59,'total_deduction',''),(947,NULL,NULL,NULL,59,'net_amount',''),(948,NULL,NULL,NULL,59,'deduction_days',''),(949,NULL,NULL,NULL,59,'deduction_percent',''),(950,NULL,NULL,NULL,59,'override_attendance_policy','0'),(951,NULL,NULL,NULL,59,'override_allowance_policy','0'),(952,NULL,NULL,NULL,59,'attendance_exempted','0'),(953,NULL,NULL,NULL,59,'company_id','1'),(954,NULL,NULL,NULL,59,'modified_at','2022-07-13 12:06:24'),(955,NULL,NULL,NULL,59,'modified_by_id','1'),(956,NULL,NULL,NULL,60,'primary_key','{E6D6C251-8460-0699-5AF2-FD029521F9BF}'),(957,NULL,NULL,NULL,60,'registration_code','5'),(958,NULL,NULL,NULL,60,'department_id','5'),(959,NULL,NULL,NULL,60,'employee_id','{D2AF4500-371C-F68F-D744-2338A66271DE}'),(960,NULL,NULL,NULL,60,'employee_code','6'),(961,NULL,NULL,NULL,60,'employee_name','Huzaifa Hussaini Khambaty'),(962,NULL,NULL,NULL,60,'designation_id','6'),(963,NULL,NULL,NULL,60,'attendance_code','6'),(964,NULL,NULL,NULL,60,'joining_date',''),(965,NULL,NULL,NULL,60,'status','Active'),(966,NULL,NULL,NULL,60,'leaving_date',''),(967,NULL,NULL,NULL,60,'employee_bank_id',''),(968,NULL,NULL,NULL,60,'bank_id',''),(969,NULL,NULL,NULL,60,'bank_account',''),(970,NULL,NULL,NULL,60,'bank_title',''),(971,NULL,NULL,NULL,60,'bank_iban',''),(972,NULL,NULL,NULL,60,'party_id','0'),(973,NULL,NULL,NULL,60,'total_payroll','0'),(974,NULL,NULL,NULL,60,'arrears','0.00'),(975,NULL,NULL,NULL,60,'wef_date',''),(976,NULL,NULL,NULL,60,'employee_salary_id',''),(977,NULL,NULL,NULL,60,'basic_salary',''),(978,NULL,NULL,NULL,60,'taxable','Yes'),(979,NULL,NULL,NULL,60,'taxable_house_rent_percent',''),(980,NULL,NULL,NULL,60,'employee_allowances',''),(981,NULL,NULL,NULL,60,'employee_deductions',''),(982,NULL,NULL,NULL,60,'total_allowance',''),(983,NULL,NULL,NULL,60,'gross_amount',''),(984,NULL,NULL,NULL,60,'taxable_amount',''),(985,NULL,NULL,NULL,60,'total_deduction',''),(986,NULL,NULL,NULL,60,'net_amount',''),(987,NULL,NULL,NULL,60,'deduction_days',''),(988,NULL,NULL,NULL,60,'deduction_percent',''),(989,NULL,NULL,NULL,60,'override_attendance_policy','0'),(990,NULL,NULL,NULL,60,'override_allowance_policy','0'),(991,NULL,NULL,NULL,60,'attendance_exempted','0'),(992,NULL,NULL,NULL,60,'company_id','1'),(993,NULL,NULL,NULL,60,'modified_at','2022-07-13 12:07:02'),(994,NULL,NULL,NULL,60,'modified_by_id','1'),(995,NULL,NULL,NULL,61,'primary_key','{F60B10E3-CC65-04F6-0B43-646CF45B11C1}'),(996,NULL,NULL,NULL,61,'registration_code','6'),(997,NULL,NULL,NULL,61,'department_id','8'),(998,NULL,NULL,NULL,61,'employee_id','{5986D375-FB79-067F-C265-960CD15934F2}'),(999,NULL,NULL,NULL,61,'employee_code','7'),(1000,NULL,NULL,NULL,61,'employee_name','Umair khan Khan'),(1001,NULL,NULL,NULL,61,'designation_id','11'),(1002,NULL,NULL,NULL,61,'attendance_code','7'),(1003,NULL,NULL,NULL,61,'joining_date',''),(1004,NULL,NULL,NULL,61,'status','Active'),(1005,NULL,NULL,NULL,61,'leaving_date',''),(1006,NULL,NULL,NULL,61,'employee_bank_id',''),(1007,NULL,NULL,NULL,61,'bank_id',''),(1008,NULL,NULL,NULL,61,'bank_account',''),(1009,NULL,NULL,NULL,61,'bank_title',''),(1010,NULL,NULL,NULL,61,'bank_iban',''),(1011,NULL,NULL,NULL,61,'party_id','0'),(1012,NULL,NULL,NULL,61,'total_payroll','0'),(1013,NULL,NULL,NULL,61,'arrears','0.00'),(1014,NULL,NULL,NULL,61,'wef_date',''),(1015,NULL,NULL,NULL,61,'employee_salary_id',''),(1016,NULL,NULL,NULL,61,'basic_salary',''),(1017,NULL,NULL,NULL,61,'taxable','Yes'),(1018,NULL,NULL,NULL,61,'taxable_house_rent_percent',''),(1019,NULL,NULL,NULL,61,'employee_allowances',''),(1020,NULL,NULL,NULL,61,'employee_deductions',''),(1021,NULL,NULL,NULL,61,'total_allowance',''),(1022,NULL,NULL,NULL,61,'gross_amount',''),(1023,NULL,NULL,NULL,61,'taxable_amount',''),(1024,NULL,NULL,NULL,61,'total_deduction',''),(1025,NULL,NULL,NULL,61,'net_amount',''),(1026,NULL,NULL,NULL,61,'deduction_days',''),(1027,NULL,NULL,NULL,61,'deduction_percent',''),(1028,NULL,NULL,NULL,61,'override_attendance_policy','0'),(1029,NULL,NULL,NULL,61,'override_allowance_policy','0'),(1030,NULL,NULL,NULL,61,'attendance_exempted','0'),(1031,NULL,NULL,NULL,61,'company_id','1'),(1032,NULL,NULL,NULL,61,'modified_at','2022-07-13 12:07:34'),(1033,NULL,NULL,NULL,61,'modified_by_id','1'),(1034,NULL,NULL,NULL,62,'primary_key','{7305964F-EE02-FB38-519A-C1F6F0368BE9}'),(1035,NULL,NULL,NULL,62,'registration_code','4'),(1036,NULL,NULL,NULL,62,'department_id','2'),(1037,NULL,NULL,NULL,62,'employee_id','{6AF5D1E5-FBD8-DF06-CC4B-598D58D8C031}'),(1038,NULL,NULL,NULL,62,'employee_code','5'),(1039,NULL,NULL,NULL,62,'employee_name','Muhammad Salman Kamboh'),(1040,NULL,NULL,NULL,62,'designation_id','1'),(1041,NULL,NULL,NULL,62,'attendance_code','5'),(1042,NULL,NULL,NULL,62,'joining_date','2020-01-11'),(1043,NULL,NULL,NULL,62,'status','Inactive'),(1044,NULL,NULL,NULL,62,'leaving_date','2022-07-08'),(1045,NULL,NULL,NULL,62,'employee_bank_id',''),(1046,NULL,NULL,NULL,62,'bank_id',''),(1047,NULL,NULL,NULL,62,'bank_account',''),(1048,NULL,NULL,NULL,62,'bank_title',''),(1049,NULL,NULL,NULL,62,'bank_iban',''),(1050,NULL,NULL,NULL,62,'party_id','0'),(1051,NULL,NULL,NULL,62,'total_payroll','0'),(1052,NULL,NULL,NULL,62,'arrears','0.00'),(1053,NULL,NULL,NULL,62,'wef_date',''),(1054,NULL,NULL,NULL,62,'employee_salary_id',''),(1055,NULL,NULL,NULL,62,'basic_salary',''),(1056,NULL,NULL,NULL,62,'taxable','Yes'),(1057,NULL,NULL,NULL,62,'taxable_house_rent_percent',''),(1058,NULL,NULL,NULL,62,'employee_allowances',''),(1059,NULL,NULL,NULL,62,'employee_deductions',''),(1060,NULL,NULL,NULL,62,'total_allowance',''),(1061,NULL,NULL,NULL,62,'gross_amount',''),(1062,NULL,NULL,NULL,62,'taxable_amount',''),(1063,NULL,NULL,NULL,62,'total_deduction',''),(1064,NULL,NULL,NULL,62,'net_amount',''),(1065,NULL,NULL,NULL,62,'deduction_days',''),(1066,NULL,NULL,NULL,62,'deduction_percent',''),(1067,NULL,NULL,NULL,62,'override_attendance_policy','0'),(1068,NULL,NULL,NULL,62,'override_allowance_policy','0'),(1069,NULL,NULL,NULL,62,'attendance_exempted','0'),(1070,NULL,NULL,NULL,62,'company_id','1'),(1071,NULL,NULL,NULL,62,'modified_at','2022-07-13 12:08:21'),(1072,NULL,NULL,NULL,62,'modified_by_id','1'),(1073,NULL,NULL,NULL,63,'primary_key','{2AE513B4-BEA1-E03F-2C32-D1ABFB54CDB2}'),(1074,NULL,NULL,NULL,63,'registration_code','8'),(1075,NULL,NULL,NULL,63,'department_id','5'),(1076,NULL,NULL,NULL,63,'employee_id','{1094676F-F17E-CA37-6FD8-4D6E73BBDC79}'),(1077,NULL,NULL,NULL,63,'employee_code','14'),(1078,NULL,NULL,NULL,63,'employee_name','Murtaza Asghar Ali Bharmal'),(1079,NULL,NULL,NULL,63,'designation_id','7'),(1080,NULL,NULL,NULL,63,'attendance_code','14'),(1081,NULL,NULL,NULL,63,'joining_date','2004-01-01'),(1082,NULL,NULL,NULL,63,'status','Active'),(1083,NULL,NULL,NULL,63,'leaving_date',''),(1084,NULL,NULL,NULL,63,'employee_bank_id',''),(1085,NULL,NULL,NULL,63,'bank_id',''),(1086,NULL,NULL,NULL,63,'bank_account',''),(1087,NULL,NULL,NULL,63,'bank_title',''),(1088,NULL,NULL,NULL,63,'bank_iban',''),(1089,NULL,NULL,NULL,63,'party_id','0'),(1090,NULL,NULL,NULL,63,'total_payroll','0'),(1091,NULL,NULL,NULL,63,'arrears','0.00'),(1092,NULL,NULL,NULL,63,'wef_date',''),(1093,NULL,NULL,NULL,63,'employee_salary_id',''),(1094,NULL,NULL,NULL,63,'basic_salary',''),(1095,NULL,NULL,NULL,63,'taxable','Yes'),(1096,NULL,NULL,NULL,63,'taxable_house_rent_percent',''),(1097,NULL,NULL,NULL,63,'employee_allowances',''),(1098,NULL,NULL,NULL,63,'employee_deductions',''),(1099,NULL,NULL,NULL,63,'total_allowance',''),(1100,NULL,NULL,NULL,63,'gross_amount',''),(1101,NULL,NULL,NULL,63,'taxable_amount',''),(1102,NULL,NULL,NULL,63,'total_deduction',''),(1103,NULL,NULL,NULL,63,'net_amount',''),(1104,NULL,NULL,NULL,63,'deduction_days',''),(1105,NULL,NULL,NULL,63,'deduction_percent',''),(1106,NULL,NULL,NULL,63,'override_attendance_policy','0'),(1107,NULL,NULL,NULL,63,'override_allowance_policy','0'),(1108,NULL,NULL,NULL,63,'attendance_exempted','0'),(1109,NULL,NULL,NULL,63,'company_id','1'),(1110,NULL,NULL,NULL,63,'modified_at','2022-07-13 12:08:55'),(1111,NULL,NULL,NULL,63,'modified_by_id','1'),(1112,NULL,NULL,NULL,64,'designation_name','Office Boy'),(1113,NULL,NULL,NULL,64,'created_at','2022-07-13 12:11:02'),(1114,NULL,NULL,NULL,64,'created_by_id','1'),(1115,NULL,NULL,NULL,64,'modified_at','2022-07-13 12:11:02'),(1116,NULL,NULL,NULL,64,'modified_by_id','1'),(1117,NULL,NULL,NULL,65,'company_id','1'),(1118,NULL,NULL,NULL,65,'department_code','17'),(1119,NULL,NULL,NULL,65,'department_name','Support'),(1120,NULL,NULL,NULL,65,'address','Address'),(1121,NULL,NULL,NULL,65,'phone_no','1234'),(1122,NULL,NULL,NULL,65,'party_id','1234'),(1123,NULL,NULL,NULL,65,'ah_key','1234'),(1124,NULL,NULL,NULL,65,'budget_key','1234'),(1125,NULL,NULL,NULL,65,'deduction_days',''),(1126,NULL,NULL,NULL,65,'deduction_percent',''),(1127,NULL,NULL,NULL,65,'override_attendance_policy','0'),(1128,NULL,NULL,NULL,65,'override_allowance_policy','0'),(1129,NULL,NULL,NULL,65,'attendance_exempted','0'),(1130,NULL,NULL,NULL,65,'created_at','2022-07-13 12:12:44'),(1131,NULL,NULL,NULL,65,'created_by_id','1'),(1132,NULL,NULL,NULL,65,'modified_at','2022-07-13 12:12:44'),(1133,NULL,NULL,NULL,65,'modified_by_id','1'),(1134,NULL,NULL,NULL,66,'primary_key','{D73857F6-E04B-F279-1B99-39059EE1DD6A}'),(1135,NULL,NULL,NULL,66,'registration_code','7'),(1136,NULL,NULL,NULL,66,'department_id','24'),(1137,NULL,NULL,NULL,66,'employee_id','{80500690-5BAB-169E-2D49-654BCB281E3E}'),(1138,NULL,NULL,NULL,66,'employee_code','13'),(1139,NULL,NULL,NULL,66,'employee_name','Aqal Nawaz khan'),(1140,NULL,NULL,NULL,66,'designation_id','13'),(1141,NULL,NULL,NULL,66,'attendance_code','13'),(1142,NULL,NULL,NULL,66,'joining_date','2018-04-04'),(1143,NULL,NULL,NULL,66,'status','Active'),(1144,NULL,NULL,NULL,66,'leaving_date',''),(1145,NULL,NULL,NULL,66,'employee_bank_id',''),(1146,NULL,NULL,NULL,66,'bank_id',''),(1147,NULL,NULL,NULL,66,'bank_account',''),(1148,NULL,NULL,NULL,66,'bank_title',''),(1149,NULL,NULL,NULL,66,'bank_iban',''),(1150,NULL,NULL,NULL,66,'party_id','0'),(1151,NULL,NULL,NULL,66,'total_payroll','0'),(1152,NULL,NULL,NULL,66,'arrears','0.00'),(1153,NULL,NULL,NULL,66,'wef_date',''),(1154,NULL,NULL,NULL,66,'employee_salary_id',''),(1155,NULL,NULL,NULL,66,'basic_salary',''),(1156,NULL,NULL,NULL,66,'taxable','Yes'),(1157,NULL,NULL,NULL,66,'taxable_house_rent_percent',''),(1158,NULL,NULL,NULL,66,'employee_allowances',''),(1159,NULL,NULL,NULL,66,'employee_deductions',''),(1160,NULL,NULL,NULL,66,'total_allowance',''),(1161,NULL,NULL,NULL,66,'gross_amount',''),(1162,NULL,NULL,NULL,66,'taxable_amount',''),(1163,NULL,NULL,NULL,66,'total_deduction',''),(1164,NULL,NULL,NULL,66,'net_amount',''),(1165,NULL,NULL,NULL,66,'deduction_days',''),(1166,NULL,NULL,NULL,66,'deduction_percent',''),(1167,NULL,NULL,NULL,66,'override_attendance_policy','0'),(1168,NULL,NULL,NULL,66,'override_allowance_policy','0'),(1169,NULL,NULL,NULL,66,'attendance_exempted','0'),(1170,NULL,NULL,NULL,66,'company_id','1'),(1171,NULL,NULL,NULL,66,'modified_at','2022-07-13 12:13:10'),(1172,NULL,NULL,NULL,66,'modified_by_id','1');

/*Table structure for table `bank` */

CREATE TABLE `bank` (
  `bank_id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(255) DEFAULT NULL,
  `bank_address` varchar(255) DEFAULT NULL,
  `manager_name` varchar(255) DEFAULT NULL,
  `manager_email` varchar(255) DEFAULT NULL,
  `manager_phone` varchar(255) DEFAULT NULL,
  `contact_person_name` varchar(255) DEFAULT NULL,
  `contact_person_email` varchar(255) DEFAULT NULL,
  `contact_person_phone` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`bank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

/*Data for the table `bank` */

insert  into `bank`(`bank_id`,`bank_name`,`bank_address`,`manager_name`,`manager_email`,`manager_phone`,`contact_person_name`,`contact_person_email`,`contact_person_phone`,`status`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values (1,'JS Bank Limited','Shaheen Commercial Complex, Karachi','Mr Zulfiqar Abidi','','','','','','Active','2018-04-27 06:22:37',1,NULL,NULL),(2,'Al-Barka Islamic Bank\r\n',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(3,'American Express  Bank Ltd.\r\n',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(4,'Bank Al Habib Ltd','Clifton','a','a','0','a','a','0','Active',NULL,NULL,'2020-08-05 17:03:00',3),(5,'MCB Bank Limited\r\n',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(6,'Standard Chartered Bank Ltd.\r\n',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(7,'National Bank of Pakistan','PNSC Building Lalazar Area, Off M.T. Khan Road, Sindh Karachi, Pakistan.','','','','','','','Active','2019-01-31 13:34:31',1,'2019-01-31 13:34:31',1),(8,'Soneri Bank',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(9,'Meezan Bank',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(10,'Habib Bank Limited',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(11,'Habib Metropolitan Bank',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(12,'Bank Alfalah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(14,'Allied Bank',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Active',NULL,NULL,NULL,NULL),(15,' Summit Bank','Karachi','','','','','','','Active','2021-03-03 11:10:16',1,'2021-03-03 11:10:16',1),(16,'BankIslami Pakistan Limited','','','','','','','','Active','2021-03-04 09:09:00',1,'2021-03-04 09:09:00',1),(17,'Faysal Bank Limited','','','','','','','','Active','2021-03-08 11:22:51',1,'2021-03-08 11:22:51',1),(18,'Askari Bank','Haidery, North Nazimabad, Karachi','Askari Bank','','','','','','Active','2021-07-06 10:28:06',3,'2021-07-06 10:28:06',3),(19,'United Bank Limited','I.I Chundrigar Rd, Seari Quarters, Karachi, Karachi City, Sindh','','','','','','','Active','2022-01-28 11:22:49',1,'2022-01-28 11:22:49',1);

/*Table structure for table `bank_letter` */

CREATE TABLE `bank_letter` (
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `bank_letter_id` char(38) CHARACTER SET utf8 NOT NULL,
  `document_prefix` char(16) CHARACTER SET utf8 DEFAULT NULL,
  `document_no` int(11) DEFAULT NULL,
  `document_identity` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `document_date` date DEFAULT NULL,
  `document_title` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `bank_reference` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `letter_type` enum('Transfer','RTGS','IFT') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Transfer',
  `source_type` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `source_date` date DEFAULT NULL,
  `company_account_id` int(11) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `cheque_no` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `total_employee` int(11) DEFAULT NULL,
  `total_amount` decimal(11,2) DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  `is_post` tinyint(4) NOT NULL DEFAULT '0',
  `post_at` datetime DEFAULT NULL,
  `post_by_id` int(11) DEFAULT NULL,
  `bno` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`bank_letter_id`),
  KEY `company_id` (`company_id`),
  KEY `document_date` (`document_date`),
  KEY `document_identity` (`document_identity`),
  KEY `fiscal_year_id` (`fiscal_year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `bank_letter` */

/*Table structure for table `bank_letter_detail` */

CREATE TABLE `bank_letter_detail` (
  `bank_letter_detail_id` char(38) CHARACTER SET utf8 NOT NULL,
  `bank_letter_id` char(38) CHARACTER SET utf8 NOT NULL,
  `source_table` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `source_table_id` char(38) CHARACTER SET utf8 DEFAULT NULL,
  `employee_registration_id` char(38) CHARACTER SET utf8 NOT NULL,
  `employee_id` char(38) CHARACTER SET utf8 NOT NULL,
  `employee_code` int(11) NOT NULL,
  `registration_code` int(11) NOT NULL,
  `employee_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `bank_id` int(11) NOT NULL DEFAULT '0',
  `bank_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `bank_title` varchar(255) CHARACTER SET utf8 NOT NULL,
  `bank_iban` varchar(255) CHARACTER SET utf8 NOT NULL,
  `amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`bank_letter_detail_id`),
  KEY `bank_letter_id` (`bank_letter_id`),
  KEY `employee_id` (`employee_id`),
  KEY `employee_registration_id` (`employee_registration_id`),
  KEY `source_table` (`source_table`),
  KEY `source_table_id` (`source_table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `bank_letter_detail` */

/*Table structure for table `certificate_serial_no` */

CREATE TABLE `certificate_serial_no` (
  `certificate_serial_no_id` char(38) NOT NULL,
  `parent_company_id` int(11) DEFAULT NULL,
  `company_id` int(11) NOT NULL,
  `fiscal_year_id` int(11) NOT NULL,
  `employee_registration_id` char(38) NOT NULL,
  `serial_no` int(11) NOT NULL,
  PRIMARY KEY (`certificate_serial_no_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `certificate_serial_no` */

/*Table structure for table `class` */

CREATE TABLE `class` (
  `class_id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `class` */

/*Table structure for table `company` */

CREATE TABLE `company` (
  `parent_company_id` int(11) NOT NULL DEFAULT '0',
  `company_id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` varchar(255) DEFAULT NULL,
  `sesi_registration_no` varchar(40) DEFAULT NULL,
  `company_logo` varchar(255) NOT NULL,
  `company_name` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `phone_no` varchar(255) NOT NULL,
  `fax_no` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `gst_no` varchar(255) NOT NULL,
  `ntn_no` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `time_zone` varchar(255) DEFAULT NULL,
  `eobi_party_id` int(11) DEFAULT NULL,
  `eobi_ah_key` int(11) DEFAULT NULL,
  `tax_party_id` int(11) DEFAULT NULL,
  `tax_ah_key` int(11) DEFAULT NULL,
  `yearly_leave` int(11) NOT NULL DEFAULT '0',
  `attendance_exempted` tinyint(4) NOT NULL DEFAULT '0',
  `leave_request_verified_by` enum('User','Admin') NOT NULL DEFAULT 'User',
  `approval_authority_email` text NOT NULL,
  `approval_authority_mobile` text NOT NULL,
  `deduction_days` int(11) NOT NULL DEFAULT '0',
  `deduction_percent` int(11) NOT NULL DEFAULT '0',
  `allowance_request_verified_by` enum('User','Admin') NOT NULL DEFAULT 'User',
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `distance` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Data for the table `company` */

insert  into `company`(`parent_company_id`,`company_id`,`ref_id`,`sesi_registration_no`,`company_logo`,`company_name`,`address`,`phone_no`,`fax_no`,`email`,`gst_no`,`ntn_no`,`status`,`time_zone`,`eobi_party_id`,`eobi_ah_key`,`tax_party_id`,`tax_ah_key`,`yearly_leave`,`attendance_exempted`,`leave_request_verified_by`,`approval_authority_email`,`approval_authority_mobile`,`deduction_days`,`deduction_percent`,`allowance_request_verified_by`,`latitude`,`longitude`,`distance`,`created_at`,`created_by_id`) values (0,1,'','','','Bharmal System Designers','','','','','','','Active','Asia/Karachi',0,0,0,0,0,0,'User','','',30,0,'User','24.849758940130634','67.00189205187215','0.621371','2018-04-23 18:56:09',1),(1,2,'4','','','Lets Dream Beyond','','','','','','','Active','Asia/Karachi',35,1182,28,503,20,0,'User','','',30,0,'User','24.849758940130634','67.00189205187215','0.621371','2018-04-26 12:58:24',1);

/*Table structure for table `company_account` */

CREATE TABLE `company_account` (
  `company_account_id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `bank_branch` varchar(255) DEFAULT NULL,
  `account_title` varchar(255) DEFAULT NULL,
  `account_no` varchar(255) DEFAULT NULL,
  `iban` varchar(255) DEFAULT NULL,
  `party_id` int(11) DEFAULT NULL,
  `ah_key` int(11) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`company_account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `company_account` */

/*Table structure for table `company_allowance` */

CREATE TABLE `company_allowance` (
  `company_allowance_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `allowance_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`company_allowance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `company_allowance` */

insert  into `company_allowance`(`company_allowance_id`,`company_id`,`allowance_id`,`created_at`,`created_by_id`) values ('{00502FAE-776A-46A7-BE92-CBE32F754818}',1,1,'2022-03-17 12:32:53',1),('{01DF585D-313F-4484-8F97-352531E6B615}',2,2,'2021-09-07 14:48:24',1),('{315D5EF0-B03D-4163-9267-CC7040364EBB}',1,6,'2022-03-17 12:32:53',1),('{60D96070-F9FF-4D88-B534-734F68879C8A}',1,7,'2022-03-17 12:32:53',1),('{6206D146-80B5-4A11-B553-C006A5F91022}',1,2,'2022-03-17 12:32:53',1),('{7191AEA4-8BF0-4786-A90B-78FF23AC4DE2}',1,4,'2022-03-17 12:32:53',1),('{A8716CFC-EC7B-4C19-8CA2-04EDE7D50426}',2,7,'2021-09-07 14:48:24',1),('{CB83D005-5A28-4DD1-8F5D-092452C86F91}',1,5,'2022-03-17 12:32:53',1),('{E8EFE735-D093-4A85-B683-FE7D15F9ECAE}',2,3,'2021-09-07 14:48:24',1),('{F85A8E4F-A316-47CE-BA20-53A91CDE15CF}',1,3,'2022-03-17 12:32:53',1),('{F8820902-6A82-4FFE-A069-CB42AC8F1AF5}',2,4,'2021-09-07 14:48:24',1),('{FF43CE60-240A-47C1-8F4D-16233093EDB7}',2,1,'2021-09-07 14:48:24',1);

/*Table structure for table `company_allowance_policy` */

CREATE TABLE `company_allowance_policy` (
  `company_allowance_policy_id` char(38) NOT NULL,
  `company_id` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `relation` enum('Self','Parent','Sibling','Spouse','Child') NOT NULL,
  `allowance_type_id` int(11) NOT NULL,
  `allowance_category_id` int(11) NOT NULL DEFAULT '0',
  `allowance_on` enum('Percent','Fixed') NOT NULL,
  `allowance_value` decimal(11,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`company_allowance_policy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `company_allowance_policy` */

/*Table structure for table `company_bank` */

CREATE TABLE `company_bank` (
  `company_bank_id` char(38) NOT NULL,
  `company_id` char(38) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `bank_id` char(38) DEFAULT NULL,
  `account_no` varchar(255) DEFAULT NULL,
  `account_title` varchar(255) DEFAULT NULL,
  `iban_no` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`company_bank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `company_bank` */

/*Table structure for table `company_deduction` */

CREATE TABLE `company_deduction` (
  `company_deduction_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `deduction_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`company_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `company_deduction` */

insert  into `company_deduction`(`company_deduction_id`,`company_id`,`deduction_id`,`created_at`,`created_by_id`) values ('{0916E1FA-4922-4876-8271-2D9070D8203E}',1,11,'2022-03-17 12:32:53',1),('{11A560F5-8C79-4DDE-B314-62BCB2E43BF9}',1,7,'2022-03-17 12:32:53',1),('{26A8110E-363D-499A-9F72-A72A4A944846}',1,10,'2022-03-17 12:32:53',1),('{4D36BA3A-4184-4952-B8C9-0D92A0113766}',1,6,'2022-03-17 12:32:53',1),('{66D2F0DF-2B16-4483-93C8-1701C31180A3}',1,5,'2018-07-05 11:53:14',1),('{66E5C60B-47F9-4D31-9947-45E51924105C}',1,4,'2022-03-17 12:32:53',1),('{7963E6DB-80A5-4273-BF30-3C802B792A99}',2,7,'2021-09-07 14:48:24',1),('{7AF6D703-B368-4A40-8F89-812AA8D88B03}',1,3,'2018-07-05 11:53:14',1),('{868F6F84-C861-4D0B-B463-35A03DB9A42B}',1,2,'2018-07-05 11:53:14',1),('{B1406C3E-CDDD-45FA-B4A5-B8EEBA3CE080}',1,9,'2022-03-17 12:32:53',1),('{B55D8301-F946-43DB-B86A-524598D20DBB}',2,8,'2021-09-07 14:48:24',1),('{E08004F7-13DC-42F4-8062-ACB06D236985}',1,8,'2022-03-17 12:32:53',1);

/*Table structure for table `core_setting` */

CREATE TABLE `core_setting` (
  `setting_id` char(40) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `module` varchar(255) DEFAULT NULL,
  `field` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `core_setting` */

insert  into `core_setting`(`setting_id`,`company_id`,`department_id`,`fiscal_year_id`,`module`,`field`,`value`,`created_at`,`created_by_id`) values ('{035B49E3-5533-0E72-BE14-99954CBA5C6D}',1,NULL,NULL,'general','config_mail_smtp_hostname','smtp.gmail.com','2022-07-10 21:13:30',9),('{09E5BC2E-CC12-5739-86C9-A8C1F8BD06FD}',1,NULL,NULL,'general','config_mail_smtp_timeout','5','2022-07-10 21:13:30',9),('{0E90C86B-34BC-48CF-8BE3-9E476D0A3D42}',2,NULL,NULL,'general','sms_from_mask','ALJAMEA','2021-07-14 15:41:06',1),('{13B60648-5322-B47D-50A4-39931BF0831B}',1,NULL,NULL,'general','config_mail_smtp_port','25','2022-07-10 21:13:30',9),('{1450CC2A-76A6-0ABC-3330-37697DB9DD66}',1,NULL,NULL,'general','sms_password','SmS.53210','2022-07-10 21:13:30',9),('{1AC4EC4C-8DBD-75BA-3E42-2FBA0B2083FA}',1,NULL,NULL,'general','config_mail_smtp_username','noreply@gmail.com','2022-07-10 21:13:30',9),('{223F2A82-CBB2-47B3-B440-46E3C604524E}',2,NULL,NULL,'general','config_mail_smtp_displayname','noreply','2021-07-14 15:41:06',1),('{35967CA1-E2F3-743A-3113-0CBE608E53CE}',1,NULL,NULL,'general','sms_user_name','03028501641','2022-07-10 21:13:30',9),('{36CD8413-A483-478A-9BF1-B5F43536346A}',1,NULL,NULL,'general','config_mail_smtp_displayname','noreply','2022-07-10 21:13:30',9),('{3F891B37-F778-4A0F-AA45-66D8A23C318B}',2,NULL,NULL,'general','config_mail_smtp_timeout','5','2021-07-14 15:41:06',1),('{5A25A8DE-4B8A-791E-317C-DE8A02AB3903}',1,NULL,NULL,'general','config_mail_smtp_password','zhgqprdabtiugnoa','2022-07-10 21:13:30',9),('{5BCA67FF-F7F4-49A2-B85C-9FF5F2005744}',2,NULL,NULL,'general','sms_user_name','03028501641','2021-07-14 15:41:06',1),('{6DE8D98F-1793-4FD7-B8ED-51FC6FCAF779}',2,NULL,NULL,'general','config_mail_engine','mail','2021-07-14 15:41:06',1),('{8B4E1110-9B9E-4486-8B05-018CD59412F3}',2,NULL,NULL,'general','config_mail_smtp_username','noreply@dawatkhi.com','2021-07-14 15:41:06',1),('{8C27FC7A-186A-464E-B3C8-B0CF9898AE58}',2,NULL,NULL,'general','sms_password','123.123','2021-07-14 15:41:06',1),('{930FFFEE-6F9D-6415-33AE-79FEB42DB1EE}',1,NULL,NULL,'general','config_mail_parameter','','2022-07-10 21:13:30',9),('{96020758-E6E1-45FC-A147-37DB7AB66597}',2,NULL,NULL,'general','config_mail_parameter','','2021-07-14 15:41:06',1),('{AB895A0E-9DF7-7598-6B6C-B387DC8CADE0}',1,NULL,NULL,'general','config_mail_engine','mail','2022-07-10 21:13:30',9),('{C91A047B-88D6-4C92-A105-EF1145E27AA9}',2,NULL,NULL,'general','config_mail_smtp_port','25','2021-07-14 15:41:06',1),('{CD2D1D32-3A94-4B7C-A8B3-32917B1E7402}',2,NULL,NULL,'general','config_mail_smtp_password','zhgqprdabtiugnoa','2021-07-14 15:41:06',1),('{F04B303D-506D-3D93-6041-CDE6C7512FD1}',1,NULL,NULL,'general','sms_from_mask','7005157','2022-07-10 21:13:30',9),('{F1669CDF-2806-45E6-99FD-05BD7BF4916F}',2,NULL,NULL,'general','config_mail_smtp_hostname','smtp.gmail.com','2021-07-14 15:41:06',1);

/*Table structure for table `covid_vaccine` */

CREATE TABLE `covid_vaccine` (
  `covid_vaccine_id` int(11) NOT NULL AUTO_INCREMENT,
  `vaccine_name` varchar(255) NOT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  PRIMARY KEY (`covid_vaccine_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `covid_vaccine` */

/*Table structure for table `deduction` */

CREATE TABLE `deduction` (
  `deduction_id` int(11) NOT NULL AUTO_INCREMENT,
  `deduction_code` varchar(8) DEFAULT NULL,
  `deduction_name` varchar(255) DEFAULT NULL,
  `company_account_id` int(11) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`deduction_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

/*Data for the table `deduction` */

insert  into `deduction`(`deduction_id`,`deduction_code`,`deduction_name`,`company_account_id`,`status`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values (4,'VC-QH','VC Repayment',7,'Active','2018-04-27 10:21:56',1,'2021-03-05 11:48:22',1),(6,'ITAX','Income Tax',0,'Active','2018-04-27 10:22:29',1,'2021-06-17 09:08:45',3),(7,'OTH','Others',0,'Active','2018-04-27 10:56:24',1,'2021-06-17 09:07:32',3),(8,'EOBI','Eobi Deduction',0,'Active','2018-04-27 10:56:42',1,'2021-03-05 11:43:48',1),(9,'QTM-1','Qutbi Tawfeerul Mubarak - 1',6,'Active','2018-07-17 05:48:34',1,'2021-03-05 11:45:27',1),(10,'QTM-2','Qutbi Tawfeerul Mubarak - 2',6,'Active','2018-07-17 06:37:25',3,NULL,NULL),(11,'QTM-QH','Qutbi Tawfeerul Mubarak - QH',6,'Active','2018-07-17 06:37:53',3,NULL,NULL),(12,'DHP-QH','DHP Repayment',1,'Active','2018-08-16 07:19:17',6,NULL,NULL),(13,'HT-QH','Hatimi QH',13,'Active','2018-11-02 17:01:41',1,'2018-11-02 17:01:41',1),(14,'QTM3','Qutbi Tawfeerul Mubarak - 3',6,'Active','2019-01-07 16:09:50',1,'2021-03-05 11:45:54',1),(15,'HMAQH','HMA - QH',9,'Active','2021-08-26 13:37:32',1,'2021-08-26 13:37:32',1),(16,'Hutaib','Al-Hutaib Trust - QH',29,'Active','2021-11-10 14:46:57',1,'2021-11-10 14:46:57',1);

/*Table structure for table `department` */

CREATE TABLE `department` (
  `department_id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `department_code` char(3) DEFAULT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  `address` text,
  `phone_no` varchar(255) DEFAULT NULL,
  `party_id` int(11) DEFAULT NULL,
  `ah_key` int(11) DEFAULT NULL,
  `override_attendance_policy` tinyint(4) NOT NULL DEFAULT '0',
  `override_allowance_policy` tinyint(4) NOT NULL DEFAULT '0',
  `attendance_exempted` tinyint(1) NOT NULL DEFAULT '0',
  `deduction_days` int(11) NOT NULL DEFAULT '0',
  `deduction_percent` decimal(11,2) NOT NULL DEFAULT '0.00',
  `budget_key` int(11) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` char(40) DEFAULT NULL,
  `ref_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`department_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

/*Data for the table `department` */

insert  into `department`(`department_id`,`company_id`,`department_code`,`department_name`,`address`,`phone_no`,`party_id`,`ah_key`,`override_attendance_policy`,`override_allowance_policy`,`attendance_exempted`,`deduction_days`,`deduction_percent`,`budget_key`,`status`,`created_at`,`created_by_id`,`ref_id`) values (1,1,'1','Mobile App Development','Address','121121',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:49:39','1',NULL),(2,1,'2','Web App Development','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:50:08','1',NULL),(3,1,'3','Quality Assurrance','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:50:31','1',NULL),(4,1,'4','Designing','1234','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:51:13','1',NULL),(5,1,'5','Management','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:51:36','1',NULL),(6,1,'6','Customer Support','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:52:17','1',NULL),(7,1,'7','App Development','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 11:43:43','1',NULL),(8,1,'8','Data Analysis','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 11:44:33','1',NULL),(9,2,'9','Mobile App Development','Address','121121',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:49:39','1',NULL),(10,2,'10','Web App Development','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:50:08','1',NULL),(11,2,'11','Quality Assurrance','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:50:31','1',NULL),(12,2,'12','Designing','1234','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:51:13','1',NULL),(13,2,'13','Management','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:51:36','1',NULL),(14,2,'14','Customer Support','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 10:52:17','1',NULL),(15,2,'15','App Development','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 11:43:43','1',NULL),(16,2,'16','Data Analysis','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 11:44:33','1',NULL),(24,1,'17','Support','Address','1234',1234,1234,0,0,0,0,'0.00',1234,'Active','2022-07-13 12:12:44','1',NULL);

/*Table structure for table `department_allowance_policy` */

CREATE TABLE `department_allowance_policy` (
  `department_allowance_policy_id` char(38) NOT NULL,
  `department_id` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `relation` enum('Self','Parent','Sibling','Spouse','Child') NOT NULL,
  `allowance_type_id` int(11) NOT NULL,
  `allowance_category_id` int(11) NOT NULL DEFAULT '0',
  `allowance_on` enum('Percent','Fixed') NOT NULL,
  `allowance_value` decimal(11,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`department_allowance_policy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `department_allowance_policy` */

/*Table structure for table `deposit_slip` */

CREATE TABLE `deposit_slip` (
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `deposit_slip_id` char(38) NOT NULL,
  `deposit_slip_no` int(11) DEFAULT NULL,
  `deposit_slip_date` date DEFAULT NULL,
  `deposit_slip_title` varchar(255) DEFAULT NULL,
  `payroll_date` date DEFAULT NULL,
  `department_id` varchar(255) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `company_account_id` char(38) DEFAULT NULL,
  `bank_name` varchar(255) DEFAULT NULL,
  `bank_branch` varchar(255) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `cheque_no` varchar(255) DEFAULT NULL,
  `cheque_amount` decimal(11,2) DEFAULT '0.00',
  `is_post` enum('No','Yes') DEFAULT 'No',
  `post_at` datetime DEFAULT NULL,
  `post_by_id` int(11) DEFAULT NULL,
  `post_transaction_id` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`deposit_slip_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `deposit_slip` */

/*Table structure for table `deposit_slip_detail` */

CREATE TABLE `deposit_slip_detail` (
  `company_id` int(11) NOT NULL,
  `fiscal_year_id` int(11) NOT NULL,
  `deposit_slip_id` char(38) NOT NULL,
  `deposit_slip_detail_id` char(38) NOT NULL,
  `payroll_id` char(38) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `employee_code` varchar(255) DEFAULT NULL,
  `registration_code` varchar(255) DEFAULT NULL,
  `employee_name` varchar(255) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `account_title` varchar(255) NOT NULL,
  `account_no` varchar(255) NOT NULL,
  `amount` decimal(17,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`deposit_slip_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `deposit_slip_detail` */

/*Table structure for table `designation` */

CREATE TABLE `designation` (
  `designation_id` int(11) NOT NULL AUTO_INCREMENT,
  `designation_name` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`designation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

/*Data for the table `designation` */

insert  into `designation`(`designation_id`,`designation_name`,`status`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values (1,'Web App Developer','Active','2022-07-13 11:45:51',1,'2022-07-13 11:45:51',1),(2,'Mobile App Developer','Active','2022-07-13 11:45:57',1,'2022-07-13 11:45:57',1),(3,'Quality Assurance Engineer','Active','2022-07-13 11:46:08',1,'2022-07-13 11:46:08',1),(4,'Web Designer','Active','2022-07-13 11:49:00',1,'2022-07-13 11:49:00',1),(5,'Project Manager','Active','2022-07-13 11:49:09',1,'2022-07-13 11:49:09',1),(6,'Chief Technical Officer','Active','2022-07-13 11:49:22',1,'2022-07-13 11:49:22',1),(7,'Chief Executive Officer','Active','2022-07-13 11:49:31',1,'2022-07-13 11:49:31',1),(8,'Customer Support Representative','Active','2022-07-13 11:49:39',1,'2022-07-13 11:49:39',1),(9,'Sr. Software Developer','Active','2022-07-13 11:50:25',1,'2022-07-13 11:50:25',1),(10,'Sr  Software Engineer / Team Lead','Active','2022-07-13 11:50:38',1,'2022-07-13 11:50:38',1),(11,'Data Analyst','Active','2022-07-13 11:50:52',1,'2022-07-13 11:50:52',1),(12,'QA and Development','Active','2022-07-13 11:51:20',1,'2022-07-13 11:51:20',1),(13,'Office Boy','Active','2022-07-13 12:11:02',1,'2022-07-13 12:11:02',1);

/*Table structure for table `employee` */

CREATE TABLE `employee` (
  `employee_id` char(38) NOT NULL,
  `login_id` varchar(255) DEFAULT NULL,
  `login_password` varchar(255) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `employee_image` varchar(255) DEFAULT NULL,
  `employee_code` int(11) DEFAULT NULL,
  `title_first_name` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `title_middle_name` varchar(255) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `surname` varchar(255) DEFAULT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `its_no` varchar(255) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `marital_status` varchar(255) DEFAULT NULL,
  `mobile_no` varchar(255) NOT NULL,
  `phone_no` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `qualification_id` int(11) DEFAULT NULL,
  `employee_category_id` int(11) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `area` varchar(255) DEFAULT NULL,
  `nationality` varchar(255) DEFAULT NULL,
  `cnic_no` varchar(255) DEFAULT NULL,
  `cnic_name` varchar(255) DEFAULT NULL,
  `cnic_expiry` date DEFAULT NULL,
  `cnic_address` varchar(255) DEFAULT NULL,
  `nicop_no` varchar(255) DEFAULT NULL,
  `nicop_name` varchar(255) DEFAULT NULL,
  `nicop_expiry` date DEFAULT NULL,
  `nicop_address` varchar(255) DEFAULT NULL,
  `passport_no` varchar(255) DEFAULT NULL,
  `passport_name` varchar(255) DEFAULT NULL,
  `passport_expiry` date DEFAULT NULL,
  `passport_address` varchar(255) DEFAULT NULL,
  `eobi_no` varchar(255) DEFAULT NULL,
  `eobi_date` date DEFAULT NULL,
  `eobi_sno` varchar(255) DEFAULT NULL,
  `ntn_no` varchar(255) DEFAULT NULL,
  `probation_from` date DEFAULT NULL,
  `probation_to` date DEFAULT NULL,
  `ramzan_enayat` tinyint(4) NOT NULL DEFAULT '0',
  `joining_date` date DEFAULT NULL,
  `party_id` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  `access_token` text,
  `intime_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`employee_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee` */

insert  into `employee`(`employee_id`,`login_id`,`login_password`,`company_id`,`employee_image`,`employee_code`,`title_first_name`,`first_name`,`title_middle_name`,`middle_name`,`surname`,`full_name`,`its_no`,`dob`,`gender`,`marital_status`,`mobile_no`,`phone_no`,`email`,`qualification_id`,`employee_category_id`,`city`,`area`,`nationality`,`cnic_no`,`cnic_name`,`cnic_expiry`,`cnic_address`,`nicop_no`,`nicop_name`,`nicop_expiry`,`nicop_address`,`passport_no`,`passport_name`,`passport_expiry`,`passport_address`,`eobi_no`,`eobi_date`,`eobi_sno`,`ntn_no`,`probation_from`,`probation_to`,`ramzan_enayat`,`joining_date`,`party_id`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`,`access_token`,`intime_status`) values ('{1094676F-F17E-CA37-6FD8-4D6E73BBDC79}','murtaza','129e3011b32e8c12fd23475e3106ff6b',1,'',14,'','Murtaza','','Asghar Ali','Bharmal','Murtaza Asghar Ali Bharmal','',NULL,'Male','','','','murtazabharmal@gmail.com',0,0,'','','','4210115929759','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2004-01-01',0,'2022-06-23 16:26:41',1,'2022-06-23 16:29:11',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6InsxMDk0Njc2Ri1GMTdFLUNBMzctNkZEOC00RDZFNzNCQkRDNzl9IiwiZnVsbF9uYW1lIjoiTXVydGF6YSBBc2doYXIgQWxpIEJoYXJtYWwiLCJlbWFpbCI6Im11cnRhemFiaGFybWFsQGdtYWlsLmNvbSIsImV4cCI6MjM4NDYyMDQ0MDQ4MH0.OQ2Gcn_E9YDaH9pTuMulJqbBBuW9zIcrHEeXUvxTgto',1),('{1B6A9CE0-6AA1-9E91-301D-0331CFE876BE}','hammad','3d58301d074ddafde51a23f9cf18b4a6',2,'',10,'','Muhammad','','Hammad','Wajid','Muhammad Hammad Wajid','',NULL,'Male','','+92 324 1806435','','muhammadhammad.mail@gmail.com',0,0,'','','','4220193363793','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,NULL,0,'2022-06-23 10:13:00',25,'2022-06-23 16:19:47',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6InsxQjZBOUNFMC02QUExLTlFOTEtMzAxRC0wMzMxQ0ZFODc2QkV9IiwiZnVsbF9uYW1lIjoiTXVoYW1tYWQgSGFtbWFkIFdhamlkIiwiZW1haWwiOiJtdWhhbW1hZGhhbW1hZC5tYWlsQGdtYWlsLmNvbSIsImV4cCI6MjM4NzA3MTUyMDY0MH0.US6gOqBp3yNKZl2d_505pMOAGiZ7GagQXst_SUeaHsk',1),('{340DF38A-79D0-5857-2379-3764F88F7BB2}','owais','c54059c80158cc3de017a7a661653f00',2,'',12,'','Muhammad','','Owais','Afsar','Muhammad Owais Afsar','',NULL,'Male','','+92 348 7828482','','owais.afsar@letsdreambeyond.com',0,0,'','','','4220135750113','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2021-01-06',0,'2022-06-23 10:18:21',25,'2022-06-23 16:21:45',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6InszNDBERjM4QS03OUQwLTU4NTctMjM3OS0zNzY0Rjg4RjdCQjJ9IiwiZnVsbF9uYW1lIjoiTXVoYW1tYWQgT3dhaXMgQWZzYXIiLCJlbWFpbCI6Im93YWlzLmFmc2FyQGxldHNkcmVhbWJleW9uZC5jb20iLCJleHAiOjIzODcwNzE0OTQ3MjB9.Et3im-5fSACIB1MJEQHoQTw6lpuhXXKReLidX-9_yhY',1),('{40C19AF1-C8CA-218A-5FC0-0D1EFFA6509F}','test','cc03e747a6afbbcbf8be7668acfebee5',1,'',15,'','Test','','test','Company','Test test Company','',NULL,'Male','','+31 243 1531535','+32 145 1234512','test@gmail.com',0,0,'','','','34544-64565444-6','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2022-06-07',0,'2022-06-28 11:44:41',25,'2022-06-28 16:30:29',25,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins0MEMxOUFGMS1DOENBLTIxOEEtNUZDMC0wRDFFRkZBNjUwOUZ9IiwiZnVsbF9uYW1lIjoiVGVzdCB0ZXN0IENvbXBhbnkiLCJlbWFpbCI6InRlc3RAZ21haWwuY29tIiwiZXhwIjoyMzg3MDc0MTI5OTIwfQ.qBpKsDUXSfGmt3B4SvWqzx2qpUATcVs2WAfX7VD2CDo',0),('{5986D375-FB79-067F-C265-960CD15934F2}','umair','1259da98eb5e36d00dfe84d186aa3aae',1,'',7,'','Umair','','khan','Khan','Umair khan Khan','',NULL,'Male','','+92 309 1212508','','umairkhankail@gmail.com',0,0,'','','','4210186155847','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,NULL,0,'2022-06-23 10:00:27',25,'2022-06-23 16:18:24',1,NULL,0),('{678C8595-FE95-7172-C734-F8100EF6A8AF}','taikhum','b11ccac7d09d4072c9f26e083e252a57',1,'WhatsApp Image 2022-06-23 at 1.27.11 PM.jpeg',1,'','Taikhum','','Shabbir','Farhullah','Taikhum Shabbir Farhullah','','1997-05-21','Male','Single','+92 322 9241038','','taikhum.farhullah53@gmail.com',0,0,'Karachi','','','4230189779793','',NULL,'Mir Karam Ali Talpur Road','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2020-06-15',0,'2022-06-21 17:11:54',1,'2022-06-23 14:51:27',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins2NzhDODU5NS1GRTk1LTcxNzItQzczNC1GODEwMEVGNkE4QUZ9IiwiZnVsbF9uYW1lIjoiVGFpa2h1bSBTaGFiYmlyIEZhcmh1bGxhaCIsImVtYWlsIjoidGFpa2h1bS5mYXJodWxsYWg1M0BnbWFpbC5jb20iLCJleHAiOjIzODcwNjcyMjUxMjB9.GXPYWSH_DMljmvEBhnr8a9_t1JLrr4SNE4Ah0rtbUAs',1),('{6AF5D1E5-FBD8-DF06-CC4B-598D58D8C031}','salman','97502267ac1b12468f69c14dd70196e9',1,'salman.jpg',5,'','Muhammad','','Salman','Kamboh','Muhammad Salman Kamboh','',NULL,'Male','','+92 311 3900961','','engr.salmankamboh@gmail.com',0,0,'','','','4170106295325','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2020-01-11',0,'2022-06-23 09:49:51',25,'2022-06-23 16:26:58',NULL,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins2QUY1RDFFNS1GQkQ4LURGMDYtQ0M0Qi01OThENThEOEMwMzF9IiwiZnVsbF9uYW1lIjoiTXVoYW1tYWQgU2FsbWFuIEthbWJvaCIsImVtYWlsIjoiZW5nci5zYWxtYW5rYW1ib2hAZ21haWwuY29tIiwiZXhwIjoyMzg2MzIxMjYwNDgwfQ.2rIeEZFENzrtjKL9hk71Ob2GI0bsM_gfU8iO114bH90',1),('{71748319-2DD8-13B6-1633-23E3E2850287}','yahya','3ab896b5b94e97beb42b6d91294dbd62',2,'',4,'','Syed','','Yahya','Hussaini','Syed Yahya Hussaini','',NULL,'Male','','+92 345 3050710','','yahya.hussaini@letsdreambeyond.com',0,0,'','','','4210124936719','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,NULL,0,'2022-06-22 18:12:00',25,'2022-06-23 16:15:25',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins3MTc0ODMxOS0yREQ4LTEzQjYtMTYzMy0yM0UzRTI4NTAyODd9IiwiZnVsbF9uYW1lIjoiU3llZCBZYWh5YSBIdXNzYWluaSIsImVtYWlsIjoieWFoeWEuaHVzc2FpbmlAbGV0c2RyZWFtYmV5b25kLmNvbSIsImV4cCI6MjM4NzA3MTQ5NDcyMH0.dxHqBW4pdewKaMhXHNcs_zJ-kHGUZkYExs6xrf3cFHU',1),('{72C7BDF0-E50A-DABA-D59E-A2791B1E9033}','uzair','71766146a0e95ebc3c87c40c0ebd1b93',1,'uzair.jpg',3,'','Uzair','','Anwar','Kaimkhani','Uzair Anwar Kaimkhani','',NULL,'Male','Single','+92 332 3994566','+92 332 3994566','uqaimi@gmail.com',6,0,'','','','4170105899467 ','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2022-05-31',0,'2022-06-22 18:02:57',25,'2022-06-23 16:31:28',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins3MkM3QkRGMC1FNTBBLURBQkEtRDU5RS1BMjc5MUIxRTkwMzN9IiwiZnVsbF9uYW1lIjoiVXphaXIgQW53YXIgS2FpbWtoYW5pIiwiZW1haWwiOiJ1cWFpbWlAZ21haWwuY29tIiwiZXhwIjoyMzg2MzE5NjQzMzYwfQ.o8gNvSdfxkrRwUKlLD9d7L5lx2V-aFYOM7BTutQUt48',1),('{80500690-5BAB-169E-2D49-654BCB281E3E}','aqal','7f0148aee9eae2cc648dbe3c9628f2cb',1,'',13,'','Aqal','','Nawaz','khan','Aqal Nawaz khan','',NULL,'Male','','+92 330 2746780','','aqalnawaz@gmail.com',0,0,'','','','4220142335879','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2018-04-04',0,'2022-06-23 11:30:36',25,'2022-06-23 14:43:07',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins4MDUwMDY5MC01QkFCLTE2OUUtMkQ0OS02NTRCQ0IyODFFM0V9IiwiZnVsbF9uYW1lIjoiQXFhbCBOYXdheiBraGFuIiwiZW1haWwiOiJhcWFsbmF3YXpAZ21haWwuY29tIiwiZXhwIjoyMzg1NTc1MDQyNDAwfQ.InIrZKfpEmsYr-8XcMPkbPucVMIyvfM7HLKmVp2lmaY',1),('{8833635A-60E7-27B6-870A-549B9E7D76C2}','saad','f290ca45b0dec2ec16cf3afcafbea6ac',2,'',8,'','Saad','','Ullah','Khan','Saad Ullah Khan','',NULL,'Male','','+92 336 2012909','','saadullah.khan@letsdreambeyond.com',0,0,'','','','4210117042071','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,NULL,0,'2022-06-23 10:04:05',25,'2022-06-23 10:04:55',25,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins4ODMzNjM1QS02MEU3LTI3QjYtODcwQS01NDlCOUU3RDc2QzJ9IiwiZnVsbF9uYW1lIjoiU2FhZCBVbGxhaCBLaGFuIiwiZW1haWwiOiJzYWFkdWxsYWgua2hhbkBsZXRzZHJlYW1iZXlvbmQuY29tIiwiZXhwIjoyMzg3MDY2MzQ2NzIwfQ.PcjGvy_LUbNTfVBF4yFbtc0T2BuZHDCr7V8CRRy2hVs',1),('{8EE598C0-72A2-513F-3FB5-79D8A617DB03}','anum','2f2a96e26f4304e9ee37940b06bcb9e4',2,'',11,'','Anum','','Mehfooz','Alam','Anum Mehfooz Alam','',NULL,'Female','','+92 317 2109742','','anum.mehfooz@letsdreambeyond.com',0,0,'','','','4200099183522','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2022-02-03',0,'2022-06-23 10:15:15',25,'2022-06-23 16:20:38',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins4RUU1OThDMC03MkEyLTUxM0YtM0ZCNS03OUQ4QTYxN0RCMDN9IiwiZnVsbF9uYW1lIjoiQW51bSBNZWhmb296IEFsYW0iLCJlbWFpbCI6ImFudW0ubWVoZm9vekBsZXRzZHJlYW1iZXlvbmQuY29tIiwiZXhwIjoyMzg3MDY3MDMyMTYwfQ.Jj4eMa4ZUMc-je9WqeF1T89_9nyHb7F7H1USnufVaxc',1),('{98C03A27-A91B-D2E3-C80A-FE51F76B90F3}','raza','4bd9294273ff8134d0d2d55b93c9baf1',2,'',9,'','Syed','','Raza','Haider','Syed Raza Haider','',NULL,'Male','','+92 321 2783871','','raza.haider@letsdreambeyond.com',0,0,'','','','4210167829193','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2022-09-05',0,'2022-06-23 10:08:33',25,'2022-06-23 16:17:44',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6Ins5OEMwM0EyNy1BOTFCLUQyRTMtQzgwQS1GRTUxRjc2QjkwRjN9IiwiZnVsbF9uYW1lIjoiU3llZCBSYXphIEhhaWRlciIsImVtYWlsIjoicmF6YS5oYWlkZXJAbGV0c2RyZWFtYmV5b25kLmNvbSIsImV4cCI6MjM4NzA3NDczMDQwMH0.XeJLRa3HzSdLwa-sELXdb8Y3C_doDp2iUXkX32dJphg',1),('{C5DA0414-6C0D-A068-8D17-95D45555CCB9}','zulnurain','9277c2aa43413db448a9c1b1d3a8cac2',1,'',16,'','Muhammad','','Zulnurain','Anwar','Muhammad Zulnurain Anwar','',NULL,'Male','','+92 340 8735131','','nurayn.anwar@gmail.com',0,0,'','','','4230128897133','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2022-04-07',0,'2022-07-13 10:26:10',1,'2022-07-13 10:28:05',1,NULL,0),('{CB300019-C61B-9114-4A11-985F5A525FBB}','ahmed','32aa2fd87338e241978c48ab319641bc',1,'',17,'','Ahmed','','Ali','Shah','Ahmed Ali Shah','',NULL,'Male','','+92 333 8816716','','ahmedalishah00@gmail.com',0,0,'','','','4240133594485','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,NULL,0,'2022-07-13 10:29:38',1,'2022-07-13 10:29:38',1,NULL,0),('{D2AF4500-371C-F68F-D744-2338A66271DE}','huzaifa','16a97d7143c742b320c7812a126a25fe',1,'',6,'','Huzaifa','','Hussaini','Khambaty','Huzaifa Hussaini Khambaty','',NULL,'Male','','+92 333 2221175','','huzaifa.khambaty@gmail.com',0,0,'','','','4210136284643','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,NULL,0,'2022-06-23 09:53:58',25,'2022-06-23 16:16:49',1,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6IntEMkFGNDUwMC0zNzFDLUY2OEYtRDc0NC0yMzM4QTY2MjcxREV9IiwiZnVsbF9uYW1lIjoiSHV6YWlmYSBIdXNzYWluaSBLaGFtYmF0eSIsImVtYWlsIjoiaHV6YWlmYS5raGFtYmF0eUBnbWFpbC5jb20iLCJleHAiOjIzODUzNjE5MzY4MDB9.88cyD53r6jmL-BCYAQzgZDKZWICGuNTB7QDzEthBg70',0),('{FEEE3174-89B3-CF50-6419-964421B981CE}','maaz','57ff9d3e6c74b0bf1d9e21c0fdbcbca4',1,'maaz.png',2,'','Maaz','','Uddin','Khan','Maaz Uddin Khan','','1998-10-15','Male','Single','+92 332 0356771','+92 332 0356771','maazuddin799@gmail.com',0,0,'','','','4220144642689','',NULL,'','','',NULL,'','','',NULL,'','',NULL,'','',NULL,NULL,0,'2022-05-23',0,'2022-06-21 17:13:57',1,'2022-06-23 12:55:50',NULL,'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbXBsb3llZV9pZCI6IntGRUVFMzE3NC04OUIzLUNGNTAtNjQxOS05NjQ0MjFCOTgxQ0V9IiwiZnVsbF9uYW1lIjoiTWFheiBVZGRpbiBLaGFuIiwiZW1haWwiOiJtYWF6dWRkaW43OTlAZ21haWwuY29tIiwiZXhwIjoyMzg3MDc0MTEyNjQwfQ.54EQFkhnAMuss6Az_IyHiiT8d1gfmH1z1-QvGYnKV1k',1);

/*Table structure for table `employee_allowance` */

CREATE TABLE `employee_allowance` (
  `employee_salary_id` char(38) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `employee_allowance_id` char(38) NOT NULL,
  `allowance_id` int(11) DEFAULT NULL,
  `allowance_amount` decimal(10,2) DEFAULT '0.00',
  `grossable` tinyint(4) NOT NULL DEFAULT '0',
  `taxable` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_allowance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_allowance` */

/*Table structure for table `employee_allowance_policy` */

CREATE TABLE `employee_allowance_policy` (
  `employee_allowance_policy_id` char(38) NOT NULL,
  `employee_registration_id` char(38) NOT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `relation` enum('Self','Parent','Spouse','Child','Family','Sibling') NOT NULL DEFAULT 'Self',
  `allowance_type_id` int(11) NOT NULL,
  `allowance_category_id` int(11) NOT NULL,
  `allowance_on` enum('Percent','Fixed') NOT NULL DEFAULT 'Percent',
  `allowance_value` decimal(11,2) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_allowance_policy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_allowance_policy` */

/*Table structure for table `employee_attendance` */

CREATE TABLE `employee_attendance` (
  `employee_attendance_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `department_id` int(38) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `attendance_date` date DEFAULT NULL,
  `time_in` varchar(10) DEFAULT NULL,
  `time_out` varchar(10) DEFAULT NULL,
  `date_out` date DEFAULT NULL,
  `shift_in` varchar(10) DEFAULT NULL,
  `shift_out` varchar(10) DEFAULT NULL,
  `status` enum('P','A','LP','LD','LT','H','WV','UA') DEFAULT NULL,
  `attendance_type` enum('Automatic','Manual') DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_attendance_id`),
  UNIQUE KEY `unique_record` (`company_id`,`employee_registration_id`,`attendance_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_attendance` */

insert  into `employee_attendance`(`employee_attendance_id`,`company_id`,`department_id`,`employee_registration_id`,`attendance_date`,`time_in`,`time_out`,`date_out`,`shift_in`,`shift_out`,`status`,`attendance_type`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values ('01acf3d0-19e2-4a10-a5b3-d1a1d19730a7',2,247,'{0D8542CE-74AE-37F4-777E-D6411FE52A9B}','2022-06-30','09:20','18:14','2022-06-30',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('05731457-0d54-4383-879e-5275929bc8f7',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-07-07','10:12','10:03','2022-07-13',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('05c6d2d2-1844-4fb2-8c97-68a63ffa46d8',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-07-13','08:55',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('06dee467-1d06-4ada-95af-a3d2cc4b0cd4',2,247,'{0D8542CE-74AE-37F4-777E-D6411FE52A9B}','2022-06-27','09:25','09:11','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('06f316e0-d5c2-4390-b94e-8cf8c6f1eebb',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-06-28','09:27','19:41','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('0a6ad471-0758-4964-bc15-4e67e47904bc',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-06-23','16:29','18:33','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('0c91202a-92e9-4af5-a300-835e7238328f',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-06-27','09:52','09:27','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('0cb8a6fe-f152-42da-b71c-1e8ab3725e6a',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-06-30','08:58','09:03','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('134565c8-d53c-4527-b949-6193fe9c4e30',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-06-27','08:52','18:22','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('17083eb4-018e-4782-b593-ff203523d03f',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-06-24','09:16','18:48','2022-06-24',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('1a6393d4-f883-4350-b818-0e4d0ff4fb0e',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-07-01','09:03','18:44','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('1d6ac1a1-3077-4366-b62a-14cc89917474',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-06-27','09:05','18:23','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('21bbde05-597f-4e09-87cb-091cb848eb7f',2,247,'{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}','2022-07-13','10:39',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('22beaf04-715e-4298-8ed4-3e8bcd24d717',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-06-27','09:53','18:05','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('23bc5cd7-da44-4b08-bb88-251462d54ead',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-06-28','09:10','18:17','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('2467c26b-940a-4b5d-a6ae-05b36c1e3fbc',2,247,'{0D8542CE-74AE-37F4-777E-D6411FE52A9B}','2022-06-28','09:11','19:41','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('279554bf-5a5a-4cc3-b016-e1418425a537',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-06-30','08:58','18:54','2022-06-30',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('29b43b36-ceca-4da9-ba3b-5903c7c4eff7',1,250,'{D73857F6-E04B-F279-1B99-39059EE1DD6A}','2022-06-23','16:55','09:24','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('2a4b62a8-396e-4f42-afc3-718a34037b94',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-06-27','09:00','18:50','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('2c34b410-ea8d-4680-a0ab-bdc5004af84f',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-06-30','09:00','18:55','2022-06-30',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('2c8ef154-54c8-444a-93b3-58274846e53d',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-07-01','09:17','18:41','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('2e14f15a-3c1e-48eb-a30b-04a00270a291',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-06-30','09:02','10:13','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('3013e441-c7e3-49fd-a097-86d5870b35ff',2,247,'{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}','2022-07-01','08:58','18:43','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('39bdc831-0037-448b-9e33-d5d7cfdde295',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-06-30','09:23','18:55','2022-06-30',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('3da0fb83-05e2-4053-b19d-4b5d287af5fa',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-06-24','11:20','09:52','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('3e16a762-665b-40e2-855b-316735483d15',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-07-05','09:13','09:13','2022-07-05',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('410411a3-eb73-4c69-9faf-21af181ca8fc',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-07-13','09:01',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('42e94cff-e0e3-4621-a738-5c16895c9b6a',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-06-30','09:02','08:12','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('450ba2e7-9899-4122-8730-9f2fed18a686',1,241,'{E6D6C251-8460-0699-5AF2-FD029521F9BF}','2022-06-27','11:59','11:22','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('47d010f1-5272-4514-a5df-d769651bf2bb',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-07-01','09:02',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('4a730514-7c0c-432c-9fb3-bca9a3bbf2a8',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-07-07','09:06','18:40','2022-07-07',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('4d687df7-bfd3-447d-a63a-b71b195e6b64',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-06-23','16:53','18:40','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('4de82993-9265-46df-bb30-03bcae7c49bc',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-06-28','09:10','18:18','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('4e5d54ea-8aa0-4fe1-b4fe-bd45ca4c6362',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-06-29','09:08','17:30','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('515849e7-a378-45f9-af5d-b6b0b94501d5',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-07-07','10:11',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('528c2db3-0952-43f7-9692-fa7ddae1fb43',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-07-01','09:01','09:54','2022-07-05',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('54bda8b6-2096-4bbf-a845-694654273783',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-07-07','08:59',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('5c12dd21-82f0-43c7-91b9-566f5a94fac2',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-06-29','09:01','09:02','2022-06-30',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('69bf3e86-a2fc-4b15-a4c2-f2cde715422b',2,247,'{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}','2022-06-24','08:58','09:52','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('6b877a27-b8ef-4ff5-8925-1814603d995b',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-07-07','09:08','09:13','2022-07-13',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('6f74b8e7-80eb-49fe-b454-470db2e70ee4',1,241,'{2AE513B4-BEA1-E03F-2C32-D1ABFB54CDB2}','2022-06-23','17:15',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('700f6dd2-61ac-4b36-be79-711e1396be1c',2,247,'{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}','2022-06-27','09:52','08:57','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('73f1de5f-6c0d-4921-9764-aca44275e5fb',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-07-13','10:02',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('7782ba7d-3071-41b1-9107-4f8b7a198604',2,247,'{0D8542CE-74AE-37F4-777E-D6411FE52A9B}','2022-06-29','09:09','20:01','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('77d6e995-0b9e-4ab0-836b-91236e76cc19',2,247,'{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}','2022-06-23','16:25','19:04','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('784852a6-286e-4bd3-898a-fc7339d3b1bb',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-06-29','09:05','18:31','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('793db7b3-f395-4492-9d44-c4a893e447ba',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-06-29','09:04','20:01','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('79d6cae2-236b-4f70-8272-292b4f082470',1,250,'{D73857F6-E04B-F279-1B99-39059EE1DD6A}','2022-07-01','09:22',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('7e802d9e-32d4-44c4-95a2-2b05b193cead',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-07-13','09:10',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('7fe8a185-a04e-4802-9240-3d795b95185d',2,247,'{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}','2022-06-29','08:53','20:01','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('8d6a28f3-72e3-4cfe-9ed2-fcb0d0c7adaf',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-06-27','09:04','09:50','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('8eb2984c-a760-4f8d-bc24-10695c9d52c9',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-06-24','09:01','09:52','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('93f6ccda-c345-4bb7-9d7b-0d48f65acd95',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-07-07','09:09','08:54','2022-07-13',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('98849e56-a03c-40e1-9d5c-112e35e307e8',1,241,'{E6D6C251-8460-0699-5AF2-FD029521F9BF}','2022-06-29','11:22','16:12','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('99e5a998-15a5-4a06-ad93-b90e77519430',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-07-05','09:07','09:08','2022-07-07',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('9b73eaf2-f0df-425c-b2f7-d08305580bfb',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-06-29','12:50','20:01','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a0502a91-72b6-41cf-b9be-4e2fb2f6d720',2,247,'{0D8542CE-74AE-37F4-777E-D6411FE52A9B}','2022-07-01','09:00','09:57','2022-07-05',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a0762dfd-0b32-467f-8c6e-a69848c5a53c',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-07-01','10:13','09:13','2022-07-05',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a25fb974-cb2a-4d79-b941-8652e09a92d7',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-07-05','09:09','08:58','2022-07-07',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a2f39a3c-d14c-447d-aecc-ec26eb4c232d',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-07-01','09:15','18:42','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a358b4ac-7185-4ad2-91b2-26fcac77e241',1,250,'{D73857F6-E04B-F279-1B99-39059EE1DD6A}','2022-06-29','09:24','09:22','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a46263e4-9650-4894-bbaf-a96d273e2ead',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-06-27','09:02','09:10','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a4e021b8-5a73-4fc3-9af7-de5ed1f2a98e',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-06-23','16:30','18:19','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a52dcb7d-a98a-46db-8345-633057e45932',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-06-23','16:26','00:26','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('a95705d5-2c68-4e95-9756-41d7ceb160b4',1,241,'{E6D6C251-8460-0699-5AF2-FD029521F9BF}','2022-06-23','17:05','17:05','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('aafbf3c5-ef12-4a6d-b7d1-f073f955f396',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-07-13','10:03',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('af84a35b-369b-4e06-ae10-e3a9603e9e6f',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-07-04','09:18','09:37','2022-07-04',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('b11469c9-ab74-4666-96e3-d90dd86a2edc',1,241,'{E6D6C251-8460-0699-5AF2-FD029521F9BF}','2022-06-24','05:26','11:59','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('b210a796-f4d0-4a7f-a1b9-fd551362b684',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-07-13','09:13',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('b22553cd-e7ff-4c8b-a670-dba46bf27eab',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-06-29','09:14','18:26','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('b5f67d55-d5e3-4ad3-b847-e04defc6fe9e',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-06-28','09:27','09:01','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('b859d636-6175-43e2-9299-aae624c8c4e3',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-07-05','09:05','17:23','2022-07-05',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('ba3fbf05-9c30-43b5-9b0d-35314abe43bf',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-06-24','09:01',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('bbbb29e5-1507-4309-818d-58c9b0e9fa4b',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-06-30','09:20','17:31','2022-06-30',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('bd006511-098f-4578-a9ad-d5dea0e1dce0',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-06-24','08:43','18:50','2022-06-24',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('bf7e4ecd-5bbe-48be-92f9-2f7fe1bcb115',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-06-24','08:47','19:03','2022-06-24',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('c3a8c117-4d97-4ae7-87a6-42a110017d37',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-06-23','15:45','18:23','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('c42fb9de-416b-4234-a46b-c8535578bd9d',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-06-27','09:09','18:23','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('cab528bf-4655-42a7-985f-95066bebf0ab',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-07-05','09:09','09:09','2022-07-07',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('ce244d63-4fea-4504-b02b-7ce3487144dc',2,247,'{0D8542CE-74AE-37F4-777E-D6411FE52A9B}','2022-07-13','09:02',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('d2886b4f-0e1e-4b18-886d-aabce8315d11',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-06-23','16:26','16:28','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('d2a555a6-9bdf-42d5-b6b7-3d06f53eb04f',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-07-01','09:03','18:23','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('d454744b-ff7c-410b-84d7-8ef501a05356',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-06-24','11:20','17:26','2022-06-24',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('d67c9da1-3397-4b90-94e7-76fd78455dde',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-06-28','09:50','09:50','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('d680c0ab-6560-4305-8af7-4eac0575f9b3',2,247,'{0D8542CE-74AE-37F4-777E-D6411FE52A9B}','2022-07-05','09:57','18:25','2022-07-05',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('d915b91a-78b9-4172-b828-4e0d7dfc5f70',2,247,'{B0BC566C-2391-2C7A-8280-FE896029900B}','2022-07-07','09:09','10:02','2022-07-13',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('dbee250b-5d5f-4f9f-abe3-93f32e330149',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-07-05','09:54','18:21','2022-07-05',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('dffdef4a-04d9-4d08-8411-82da31e92a1d',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-07-07','09:19',NULL,NULL,NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('e23fdebd-69d0-4e5a-a387-b5c701cc2fbb',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-06-23','16:26','22:34','2022-06-23',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('e2a90977-6dcd-4cfa-bfe5-64b8ad36ba9d',2,245,'{86464FAB-D7E9-0A62-5F9F-4B80473EA081}','2022-07-01','08:58','18:45','2022-07-01',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('ea825a0c-d83a-41e2-8e11-655c00df3dc0',1,239,'{C34FED80-B030-85A1-20F6-908E7282992D}','2022-06-28','16:04','16:14','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('eb97f256-838f-448c-b6c6-60f8a1537385',2,247,'{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}','2022-06-28','08:57','19:41','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('ebee4a76-8aca-4c37-8e36-4eb32b0da68c',2,244,'{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}','2022-07-05','09:56','18:21','2022-07-05',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('f0514338-4909-4191-81f7-cca8135b4a7f',2,246,'{D8C42212-5A32-236C-9652-51151DE1D56B}','2022-06-24','11:20','10:58','2022-06-27',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('f1bac405-22cc-4b64-be3c-68a7bb7a4b72',1,242,'{175EE610-BF1A-BF01-5A7F-904823C47108}','2022-06-28','09:08','18:16','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('f228113b-8105-445a-a0b1-1ca2e77fedaa',1,238,'{F5C5C174-2335-8100-CAD2-8DFB25547310}','2022-06-28','09:10','18:13','2022-06-28',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('f34bdeea-b7b5-47e7-9b01-ebe076ec553c',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-06-29','09:06','18:33','2022-06-29',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('f65229b2-028f-4b41-8bb6-b036d87dedce',1,238,'{7305964F-EE02-FB38-519A-C1F6F0368BE9}','2022-07-05','09:11','09:19','2022-07-07',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL),('f9dac192-78b1-4cd5-999d-7a261c118241',1,237,'{4D7622CE-465D-7B03-5B9C-5277A8F063B0}','2022-06-29','09:03','08:58','2022-06-30',NULL,NULL,'P',NULL,NULL,NULL,NULL,NULL);

/*Table structure for table `employee_bank` */

CREATE TABLE `employee_bank` (
  `employee_bank_id` char(38) NOT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `bank_id` char(38) DEFAULT NULL,
  `account_no` varchar(255) DEFAULT NULL,
  `account_title` varchar(255) DEFAULT NULL,
  `iban_no` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_bank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_bank` */

/*Table structure for table `employee_category` */

CREATE TABLE `employee_category` (
  `employee_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_category` varchar(255) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_category` */

/*Table structure for table `employee_covid_certificate` */

CREATE TABLE `employee_covid_certificate` (
  `employee_covid_certificate_id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` char(38) NOT NULL,
  `employee_code` int(11) DEFAULT NULL,
  `employee_name` varchar(255) DEFAULT NULL,
  `vaccine_type` varchar(255) DEFAULT NULL,
  `dose1_date` date DEFAULT NULL,
  `dose2_date` date DEFAULT NULL,
  `certificate_no` varchar(255) DEFAULT NULL,
  `certificate_image` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_covid_certificate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_covid_certificate` */

/*Table structure for table `employee_deduction` */

CREATE TABLE `employee_deduction` (
  `employee_salary_id` char(38) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `employee_deduction_id` char(38) NOT NULL,
  `deduction_id` int(11) DEFAULT NULL,
  `deduction_amount` decimal(11,2) DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_deduction` */

/*Table structure for table `employee_family` */

CREATE TABLE `employee_family` (
  `employee_family_id` char(38) NOT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `sort_order` int(11) DEFAULT '0',
  `relation` varchar(255) DEFAULT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `qualification_id` int(11) DEFAULT NULL,
  `school_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `period_start_date` date DEFAULT NULL,
  `period_end_date` date DEFAULT NULL,
  `cnic_no` varchar(255) DEFAULT NULL,
  `its_no` varchar(255) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_family_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_family` */

/*Table structure for table `employee_leave` */

CREATE TABLE `employee_leave` (
  `company_id` int(11) DEFAULT NULL,
  `employee_leave_id` char(38) NOT NULL,
  `request_date` date DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `leave_from` date DEFAULT NULL,
  `leave_to` date DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `description` text,
  `status` enum('Pending','Pending Verification','Requested','Approved','Rejected') NOT NULL DEFAULT 'Pending',
  `is_post` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1 = Yes, 0 = No',
  `approved_type` enum('LP','LD','WV','UA') DEFAULT NULL,
  `approved_from` date DEFAULT NULL,
  `approved_to` date DEFAULT NULL,
  `remarks` text,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_leave_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_leave` */

/*Table structure for table `employee_medical` */

CREATE TABLE `employee_medical` (
  `employee_medical_id` char(38) NOT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `relation` enum('Self','Parent','Spouse','Children') DEFAULT 'Self',
  `medical_type_id` int(11) DEFAULT NULL,
  `medical_on` enum('Percent','Fixed') DEFAULT 'Fixed',
  `medical_value` decimal(11,2) DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_medical_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_medical` */

/*Table structure for table `employee_qualification` */

CREATE TABLE `employee_qualification` (
  `employee_qualification_id` char(38) NOT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `qualification_id` int(11) DEFAULT NULL,
  `major_subject` varchar(255) DEFAULT NULL,
  `institute_type` varchar(255) DEFAULT NULL,
  `institute_name` varchar(255) DEFAULT NULL,
  `completion_date` date DEFAULT NULL,
  `grade_percent` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_qualification_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_qualification` */

/*Table structure for table `employee_registration` */

CREATE TABLE `employee_registration` (
  `company_id` int(11) DEFAULT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `employee_registration_id` char(38) NOT NULL,
  `registration_code` int(11) DEFAULT NULL,
  `attendance_code` int(11) NOT NULL DEFAULT '0',
  `department_id` int(11) DEFAULT NULL,
  `designation_id` int(11) DEFAULT NULL,
  `override_attendance_policy` tinyint(4) NOT NULL DEFAULT '0',
  `override_allowance_policy` tinyint(4) NOT NULL DEFAULT '0',
  `attendance_exempted` tinyint(4) NOT NULL DEFAULT '0',
  `deduction_days` int(11) NOT NULL DEFAULT '0',
  `deduction_percent` decimal(11,2) NOT NULL DEFAULT '0.00',
  `attendance_shift_id` char(38) DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `leaving_date` date DEFAULT NULL,
  `employee_bank_id` char(38) DEFAULT NULL,
  `bank_id` char(38) DEFAULT NULL,
  `bank_account` varchar(255) DEFAULT NULL,
  `bank_title` varchar(255) DEFAULT NULL,
  `bank_iban` varchar(255) DEFAULT NULL,
  `arrears` decimal(17,2) DEFAULT '0.00',
  `status` varchar(255) DEFAULT NULL,
  `total_payroll` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  `party_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_registration_id`),
  KEY `company_id` (`company_id`),
  KEY `department_id` (`department_id`),
  KEY `employee_id` (`employee_id`),
  KEY `employee_registration_id` (`employee_registration_id`),
  KEY `status` (`status`),
  KEY `attendance_shift_id` (`attendance_shift_id`),
  KEY `bank_id` (`bank_id`),
  KEY `designation_id` (`designation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_registration` */

insert  into `employee_registration`(`company_id`,`employee_id`,`employee_registration_id`,`registration_code`,`attendance_code`,`department_id`,`designation_id`,`override_attendance_policy`,`override_allowance_policy`,`attendance_exempted`,`deduction_days`,`deduction_percent`,`attendance_shift_id`,`joining_date`,`leaving_date`,`employee_bank_id`,`bank_id`,`bank_account`,`bank_title`,`bank_iban`,`arrears`,`status`,`total_payroll`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`,`party_id`) values (2,'{8833635A-60E7-27B6-870A-549B9E7D76C2}','{0D8542CE-74AE-37F4-777E-D6411FE52A9B}',105,8,10,1,0,0,0,0,'0.00','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}',NULL,NULL,'','','','','','0.00','Active',0,'2022-06-23 11:18:23',25,'2022-07-13 12:02:02',1,0),(1,'{72C7BDF0-E50A-DABA-D59E-A2791B1E9033}','{175EE610-BF1A-BF01-5A7F-904823C47108}',3,3,6,8,0,0,0,0,'0.00',NULL,NULL,NULL,'','','','','','0.00','Active',0,'2022-06-23 10:47:40',25,'2022-07-13 12:06:24',1,0),(1,'{1094676F-F17E-CA37-6FD8-4D6E73BBDC79}','{2AE513B4-BEA1-E03F-2C32-D1ABFB54CDB2}',8,14,5,7,0,0,0,0,'0.00',NULL,'2004-01-01',NULL,'','','','','','0.00','Active',0,'2022-06-23 16:30:35',1,'2022-07-13 12:08:55',1,0),(2,'{1B6A9CE0-6AA1-9E91-301D-0331CFE876BE}','{2E5A98E3-8FEF-6FB0-72A8-D3885079A58C}',107,10,12,4,0,0,0,0,'0.00','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}',NULL,NULL,'','','','','','0.00','Active',0,'2022-06-23 11:21:24',25,'2022-07-13 12:02:49',1,0),(1,'{FEEE3174-89B3-CF50-6419-964421B981CE}','{4D7622CE-465D-7B03-5B9C-5277A8F063B0}',2,2,1,2,0,0,0,0,'0.00',NULL,'2022-05-23',NULL,'','','','','','0.00','Active',0,'2022-06-21 17:17:27',1,'2022-07-13 12:05:10',1,0),(2,'{98C03A27-A91B-D2E3-C80A-FE51F76B90F3}','{6F7C1AF2-8A5C-EE01-F1EA-1FA07E22A807}',106,9,10,10,0,0,0,0,'0.00','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','2022-09-05',NULL,'','','','','','0.00','Active',0,'2022-06-23 11:20:09',25,'2022-07-13 12:02:24',1,0),(1,'{6AF5D1E5-FBD8-DF06-CC4B-598D58D8C031}','{7305964F-EE02-FB38-519A-C1F6F0368BE9}',4,5,2,1,0,0,0,0,'0.00',NULL,'2020-01-11','2022-07-08','','','','','','0.00','Inactive',0,'2022-06-23 11:02:35',25,'2022-07-13 12:08:21',1,0),(2,'{8EE598C0-72A2-513F-3FB5-79D8A617DB03}','{86464FAB-D7E9-0A62-5F9F-4B80473EA081}',108,11,11,12,0,0,0,0,'0.00','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','2022-02-03',NULL,'','','','','','0.00','Active',0,'2022-06-23 11:23:03',25,'2022-07-13 12:03:11',1,0),(2,'{71748319-2DD8-13B6-1633-23E3E2850287}','{B0BC566C-2391-2C7A-8280-FE896029900B}',104,4,15,9,0,0,0,0,'0.00','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}',NULL,NULL,'','','','','','0.00','Active',0,'2022-06-23 11:17:16',25,'2022-07-13 12:01:35',1,0),(1,'{40C19AF1-C8CA-218A-5FC0-0D1EFFA6509F}','{C34FED80-B030-85A1-20F6-908E7282992D}',9,15,239,162,0,0,0,0,'0.00',NULL,'2022-06-07',NULL,'','','','','','0.00','Active',0,'2022-06-28 16:04:14',25,'2022-06-28 16:04:14',25,0),(1,'{80500690-5BAB-169E-2D49-654BCB281E3E}','{D73857F6-E04B-F279-1B99-39059EE1DD6A}',7,13,24,13,0,0,0,0,'0.00',NULL,'2018-04-04',NULL,'','','','','','0.00','Active',0,'2022-06-23 11:36:29',25,'2022-07-13 12:13:10',1,0),(2,'{340DF38A-79D0-5857-2379-3764F88F7BB2}','{D8C42212-5A32-236C-9652-51151DE1D56B}',109,12,10,1,0,0,0,0,'0.00','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','2021-01-06',NULL,'','','','','','0.00','Active',0,'2022-06-23 11:23:58',25,'2022-07-13 12:04:37',1,0),(1,'{D2AF4500-371C-F68F-D744-2338A66271DE}','{E6D6C251-8460-0699-5AF2-FD029521F9BF}',5,6,5,6,0,0,0,0,'0.00',NULL,NULL,NULL,'','','','','','0.00','Active',0,'2022-06-23 11:04:21',25,'2022-07-13 12:07:02',1,0),(2,'{678C8595-FE95-7172-C734-F8100EF6A8AF}','{F5C5C174-2335-8100-CAD2-8DFB25547310}',1,1,13,5,0,0,0,0,'0.00','{9A707E69-23DE-4787-A7FC-6F0BA5E14832}','2020-06-15',NULL,'','','','','','0.00','Active',0,'2022-06-21 17:16:51',1,'2022-07-13 11:59:36',1,0),(1,'{5986D375-FB79-067F-C265-960CD15934F2}','{F60B10E3-CC65-04F6-0B43-646CF45B11C1}',6,7,8,11,0,0,0,0,'0.00',NULL,NULL,NULL,'','','','','','0.00','Active',0,'2022-06-23 11:06:50',25,'2022-07-13 12:07:34',1,0);

/*Table structure for table `employee_salary` */

CREATE TABLE `employee_salary` (
  `company_id` int(11) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `employee_salary_id` char(38) NOT NULL,
  `wef_date` date DEFAULT NULL,
  `basic_salary` decimal(10,0) DEFAULT NULL,
  `taxable` enum('Yes','No') DEFAULT 'No',
  `taxable_house_rent` enum('No','Yes') DEFAULT 'No',
  `taxable_house_rent_percent` decimal(11,2) NOT NULL DEFAULT '0.00',
  `total_allowance` decimal(11,2) NOT NULL DEFAULT '0.00',
  `gross_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `taxable_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `total_deduction` decimal(11,2) DEFAULT '0.00',
  `net_amount` decimal(11,2) DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_salary_id`),
  KEY `company_id` (`company_id`),
  KEY `wef_date` (`wef_date`),
  KEY `employee_registration_id` (`employee_registration_id`),
  KEY `employee_salary_id` (`employee_salary_id`),
  KEY `employee_id` (`employee_id`),
  KEY `department_id` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_salary` */

/*Table structure for table `employee_scholarship` */

CREATE TABLE `employee_scholarship` (
  `employee_scholarship_id` char(38) NOT NULL,
  `employee_registration_id` char(38) NOT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `relation` enum('Self','Parent','Spouse','Children','Family') NOT NULL DEFAULT 'Self',
  `scholarship_type_id` int(11) NOT NULL DEFAULT '0',
  `scholarship_on` enum('Percent','Fixed') NOT NULL DEFAULT 'Percent',
  `scholarship_value` decimal(11,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `create_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`employee_scholarship_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_scholarship` */

/*Table structure for table `employee_sesi_contribution` */

CREATE TABLE `employee_sesi_contribution` (
  `sesi_contribution_id` varchar(40) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `for_month` int(20) DEFAULT NULL,
  `document_date` date DEFAULT NULL,
  `document_identity` varchar(255) DEFAULT NULL,
  `document_no` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`sesi_contribution_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_sesi_contribution` */

/*Table structure for table `employee_sesi_contribution_detail` */

CREATE TABLE `employee_sesi_contribution_detail` (
  `sesi_contribution_detail_id` varchar(40) NOT NULL,
  `sesi_contribution_id` varchar(40) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `sesi_member_id` varchar(40) DEFAULT NULL,
  `amount` decimal(20,4) DEFAULT NULL,
  PRIMARY KEY (`sesi_contribution_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_sesi_contribution_detail` */

/*Table structure for table `employee_sesi_member` */

CREATE TABLE `employee_sesi_member` (
  `sesi_member_id` varchar(40) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `employee_registration_id` varchar(40) DEFAULT NULL,
  `social_security_no` varchar(255) DEFAULT NULL,
  `amount` decimal(20,4) DEFAULT NULL,
  PRIMARY KEY (`sesi_member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `employee_sesi_member` */

/*Table structure for table `enayat_event` */

CREATE TABLE `enayat_event` (
  `enayat_event_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `SysTag` varchar(4) DEFAULT NULL,
  `ah_key` int(11) DEFAULT NULL,
  `budget_key` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`enayat_event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enayat_event` */

/*Table structure for table `fiscal_year` */

CREATE TABLE `fiscal_year` (
  `fiscal_year_id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `fy_code` char(4) DEFAULT NULL,
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `db_name` varchar(255) NOT NULL,
  `status` enum('Active','Inactive') NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by_id` int(11) NOT NULL,
  PRIMARY KEY (`fiscal_year_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

/*Data for the table `fiscal_year` */

insert  into `fiscal_year`(`fiscal_year_id`,`ref_id`,`name`,`fy_code`,`date_from`,`date_to`,`db_name`,`status`,`created_at`,`created_by_id`) values (6,NULL,'JUL 2021 - JUN 2022','2122','2021-07-01','2022-06-30','','Active','2021-07-01 08:00:00',1);

/*Table structure for table `group` */

CREATE TABLE `group` (
  `group_id` int(11) NOT NULL,
  `group_name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `group` */

/*Table structure for table `holiday` */

CREATE TABLE `holiday` (
  `holiday_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `holiday_name` varchar(100) DEFAULT NULL,
  `holiday_date` date DEFAULT NULL,
  PRIMARY KEY (`holiday_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `holiday` */

/*Table structure for table `individual_cheque` */

CREATE TABLE `individual_cheque` (
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `individual_cheque_id` char(38) CHARACTER SET utf8 NOT NULL,
  `document_prefix` char(16) CHARACTER SET utf8 DEFAULT NULL,
  `document_no` int(11) DEFAULT NULL,
  `document_identity` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `document_date` date DEFAULT NULL,
  `document_title` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `source_type` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `source_date` date DEFAULT NULL,
  `company_account_id` int(11) DEFAULT NULL,
  `total_employee` int(11) DEFAULT NULL,
  `total_amount` decimal(11,2) DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  `is_post` tinyint(4) NOT NULL DEFAULT '0',
  `post_at` datetime DEFAULT NULL,
  `post_by_id` int(11) DEFAULT NULL,
  `bno` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`individual_cheque_id`),
  KEY `company_id` (`company_id`),
  KEY `document_date` (`document_date`),
  KEY `document_identity` (`document_identity`),
  KEY `fiscal_year_id` (`fiscal_year_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `individual_cheque` */

/*Table structure for table `individual_cheque_detail` */

CREATE TABLE `individual_cheque_detail` (
  `individual_cheque_detail_id` char(38) CHARACTER SET utf8 NOT NULL,
  `individual_cheque_id` char(38) CHARACTER SET utf8 NOT NULL,
  `source_table` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `source_table_id` char(38) CHARACTER SET utf8 DEFAULT NULL,
  `employee_registration_id` char(38) CHARACTER SET utf8 NOT NULL,
  `employee_id` char(38) CHARACTER SET utf8 NOT NULL,
  `employee_code` int(11) NOT NULL,
  `registration_code` int(11) NOT NULL,
  `employee_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `cheque_date` date NOT NULL,
  `cheque_no` varchar(255) CHARACTER SET utf8 NOT NULL,
  `cheque_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`individual_cheque_detail_id`),
  KEY `employee_id` (`employee_id`),
  KEY `employee_registration_id` (`employee_registration_id`),
  KEY `individual_cheque_id` (`individual_cheque_id`),
  KEY `source_table_id` (`source_table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `individual_cheque_detail` */

/*Table structure for table `language` */

CREATE TABLE `language` (
  `language_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL DEFAULT '',
  `code` varchar(5) NOT NULL,
  `locale` varchar(255) NOT NULL,
  `image` varchar(64) NOT NULL,
  `directory` varchar(32) NOT NULL DEFAULT '',
  `filename` varchar(64) NOT NULL DEFAULT '',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`language_id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Data for the table `language` */

insert  into `language`(`language_id`,`name`,`code`,`locale`,`image`,`directory`,`filename`,`sort_order`,`status`) values (1,'English','en','en_US.UTF-8,en_US,en-gb,english','gb.png','english','english',1,1);

/*Table structure for table `loan` */

CREATE TABLE `loan` (
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `loan_id` char(38) NOT NULL,
  `date` date DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `registration_code` int(11) DEFAULT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `employee_code` int(11) DEFAULT NULL,
  `total_amount` decimal(11,2) DEFAULT '0.00',
  `description` text,
  `deduction_id` int(11) NOT NULL DEFAULT '0',
  `company_account_id` int(11) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `cheque_no` varchar(255) DEFAULT NULL,
  `total_installment` int(11) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`loan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `loan` */

/*Table structure for table `loan_installment` */

CREATE TABLE `loan_installment` (
  `loan_installment_id` char(38) NOT NULL,
  `loan_id` char(38) DEFAULT NULL,
  `installment_date` date DEFAULT NULL,
  `installment_amount` decimal(11,2) DEFAULT '0.00',
  `adjustment_type` enum('Payroll','Cash','Transfer') DEFAULT 'Payroll',
  `installment_remarks` varchar(255) DEFAULT NULL,
  `payroll_id` char(38) NOT NULL,
  `payroll_deduction_id` char(38) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`loan_installment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `loan_installment` */

/*Table structure for table `parent_company` */

CREATE TABLE `parent_company` (
  `parent_company_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_company` varchar(255) DEFAULT NULL,
  `sesi_registration_no` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`parent_company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `parent_company` */

insert  into `parent_company`(`parent_company_id`,`parent_company`,`sesi_registration_no`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values (1,'Dawat e Hadiyah',NULL,'2018-08-06 08:58:13',1,NULL,NULL);

/*Table structure for table `payroll` */

CREATE TABLE `payroll` (
  `payroll_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `document_date` date DEFAULT NULL,
  `document_title` varchar(255) DEFAULT NULL,
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `working_days` int(11) DEFAULT NULL,
  `remaining_payroll` int(11) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
  `eobi_no` varchar(255) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `exclude_payroll` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1 = Yes, 0 = No',
  `house_rent_percent` decimal(17,2) NOT NULL DEFAULT '0.00',
  `house_rent_allowance` decimal(17,2) NOT NULL DEFAULT '0.00',
  `basic_salary` decimal(17,2) NOT NULL DEFAULT '0.00',
  `grossable_allowance` decimal(17,2) NOT NULL DEFAULT '0.00',
  `taxable_allowance` decimal(17,2) NOT NULL DEFAULT '0.00',
  `other_allowance` decimal(17,2) NOT NULL DEFAULT '0.00',
  `arrears` decimal(17,2) NOT NULL DEFAULT '0.00',
  `gross_salary` decimal(17,2) NOT NULL DEFAULT '0.00',
  `taxable_salary` decimal(17,2) NOT NULL DEFAULT '0.00',
  `other_deduction` decimal(17,2) NOT NULL DEFAULT '0.00',
  `tax_deduction` decimal(17,2) NOT NULL DEFAULT '0.00',
  `manual_addition` decimal(17,2) NOT NULL DEFAULT '0.00',
  `manual_deduction` decimal(17,2) NOT NULL DEFAULT '0.00',
  `overtime` decimal(17,2) NOT NULL DEFAULT '0.00',
  `net_salary` decimal(17,2) NOT NULL DEFAULT '0.00',
  `total_present` int(11) NOT NULL DEFAULT '0',
  `total_absent` int(11) NOT NULL DEFAULT '0',
  `attendance_deduction` decimal(17,2) NOT NULL DEFAULT '0.00',
  `payable_salary` decimal(17,2) NOT NULL DEFAULT '0.00',
  `bank_id` int(11) DEFAULT NULL,
  `bank_account_no` varchar(255) DEFAULT NULL,
  `bank_account_title` varchar(255) DEFAULT NULL,
  `bank_iban` varchar(255) DEFAULT NULL,
  `deposit_slip_id` char(38) NOT NULL,
  `tax_challan_date` date DEFAULT NULL,
  `tax_challan_no` varchar(255) NOT NULL,
  `tax_challan_bank_id` int(11) NOT NULL DEFAULT '0',
  `tax_challan_branch` varchar(255) NOT NULL,
  `is_email` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`payroll_id`),
  KEY `fiscal_year_id` (`fiscal_year_id`),
  KEY `company_id` (`company_id`),
  KEY `employee_registration_id` (`employee_registration_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll` */

/*Table structure for table `payroll_allowance` */

CREATE TABLE `payroll_allowance` (
  `payroll_allowance_id` char(38) NOT NULL,
  `payroll_id` char(38) DEFAULT NULL,
  `allowance_id` int(11) DEFAULT NULL,
  `allowance_code` varchar(255) DEFAULT NULL,
  `allowance_name` varchar(255) DEFAULT NULL,
  `allowance_amount` decimal(17,2) NOT NULL DEFAULT '0.00',
  `grossable` tinyint(4) NOT NULL DEFAULT '0',
  `taxable` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`payroll_allowance_id`),
  KEY `allowance_id` (`allowance_id`),
  KEY `payroll_id` (`payroll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_allowance` */

/*Table structure for table `payroll_deduction` */

CREATE TABLE `payroll_deduction` (
  `payroll_deduction_id` char(38) NOT NULL,
  `payroll_id` char(38) DEFAULT NULL,
  `ref_document` varchar(255) DEFAULT NULL,
  `deduction_id` char(38) DEFAULT NULL,
  `deduction_code` varchar(255) DEFAULT NULL,
  `deduction_name` varchar(255) DEFAULT NULL,
  `deduction_amount` decimal(17,2) DEFAULT '0.00',
  `bank_id` int(11) DEFAULT NULL,
  `bank_account_no` varchar(255) DEFAULT NULL,
  `bank_account_title` varchar(255) DEFAULT NULL,
  `bank_iban` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`payroll_deduction_id`),
  KEY `deduction_id` (`deduction_id`),
  KEY `payroll_id` (`payroll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payroll_deduction` */

/*Table structure for table `qualification` */

CREATE TABLE `qualification` (
  `qualification_id` int(11) NOT NULL AUTO_INCREMENT,
  `qualification` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`qualification_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

/*Data for the table `qualification` */

insert  into `qualification`(`qualification_id`,`qualification`,`status`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values (1,'None','Active','2018-04-27 09:23:56',1,NULL,NULL),(2,'Pre-Primary','Active','2018-09-26 12:31:50',1,NULL,NULL),(3,'Primary','Active','2018-09-26 12:32:07',1,NULL,NULL),(4,'SSC','Active','2018-09-26 12:32:27',1,NULL,NULL),(5,'HSC','Active','2018-09-26 12:32:40',1,NULL,NULL),(6,'Bachelors','Active','2018-09-26 12:33:13',1,NULL,NULL),(7,'Masters','Active','2018-09-26 12:33:26',1,NULL,NULL),(8,'O\' Level','Active','2018-09-29 08:52:28',1,NULL,NULL),(9,'A\' Level','Active','2018-09-29 08:52:39',1,NULL,NULL);

/*Table structure for table `salary_increment` */

CREATE TABLE `salary_increment` (
  `salary_increment_id` varchar(40) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `document_no` int(11) DEFAULT NULL,
  `document_identity` varchar(255) DEFAULT NULL,
  `department_id` varchar(40) DEFAULT NULL,
  `wef_date` date DEFAULT NULL,
  `increment_percent` varchar(40) DEFAULT NULL,
  `increment_amount` varchar(40) DEFAULT NULL,
  `is_post` tinyint(1) DEFAULT '0' COMMENT '1 = Yes, 0 = No',
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`salary_increment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `salary_increment` */

/*Table structure for table `salary_increment_detail` */

CREATE TABLE `salary_increment_detail` (
  `salary_increment_id` varchar(40) DEFAULT NULL,
  `salary_increment_detail_id` varchar(40) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `employee_registration_id` varchar(40) DEFAULT NULL,
  `employee` varchar(255) DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `no_of_years` int(11) DEFAULT NULL,
  `designation_name` varchar(255) DEFAULT NULL,
  `last_salary_updated` date DEFAULT NULL,
  `basic_salary` decimal(17,2) DEFAULT NULL,
  `increment_percent` decimal(17,2) DEFAULT NULL,
  `increment_amount` decimal(17,2) DEFAULT NULL,
  `new_salary` decimal(17,2) DEFAULT NULL,
  `employee_salary_id` varchar(40) DEFAULT NULL,
  `employee_id` varchar(40) DEFAULT NULL,
  `taxable` varchar(40) DEFAULT NULL,
  `taxable_house_rent_percent` decimal(17,4) DEFAULT NULL,
  `total_allowance` decimal(17,4) DEFAULT NULL,
  `taxable_amount` decimal(17,4) DEFAULT NULL,
  `total_deduction` decimal(17,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`salary_increment_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `salary_increment_detail` */

/*Table structure for table `school` */

CREATE TABLE `school` (
  `school_id` int(11) NOT NULL AUTO_INCREMENT,
  `school_name` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`school_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `school` */

/*Table structure for table `section` */

CREATE TABLE `section` (
  `company_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `section_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_name` varchar(255) DEFAULT NULL,
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `section` */

/*Table structure for table `special_allowance` */

CREATE TABLE `special_allowance` (
  `special_allowance_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `document_date` date DEFAULT NULL,
  `document_no` int(11) DEFAULT NULL,
  `document_identity` varchar(255) DEFAULT NULL,
  `special_allowance_type_id` int(11) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `registration_code` int(11) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_directory` varchar(255) DEFAULT NULL,
  `is_taxable` int(11) DEFAULT NULL,
  `total_amount` decimal(17,2) DEFAULT '0.00',
  `medical_from` date DEFAULT NULL,
  `medical_to` date DEFAULT NULL,
  `approved_status` varchar(255) NOT NULL DEFAULT 'Pending',
  `approved_amount` decimal(17,2) DEFAULT '0.00',
  `is_post` tinyint(4) NOT NULL DEFAULT '0',
  `post_at` datetime DEFAULT NULL,
  `post_by_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`special_allowance_id`),
  KEY `company_id` (`company_id`),
  KEY `document_date` (`document_date`),
  KEY `document_identity` (`document_identity`),
  KEY `employee_registration_id` (`employee_registration_id`),
  KEY `fiscal_year_id` (`fiscal_year_id`),
  KEY `special_allowance_type_id` (`special_allowance_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `special_allowance` */

/*Table structure for table `special_allowance_category` */

CREATE TABLE `special_allowance_category` (
  `special_allowance_type_id` int(11) DEFAULT NULL,
  `special_allowance_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `special_allowance_category` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`special_allowance_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `special_allowance_category` */

/*Table structure for table `special_allowance_detail` */

CREATE TABLE `special_allowance_detail` (
  `special_allowance_detail_id` char(38) NOT NULL,
  `special_allowance_id` char(38) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `allowance_for` varchar(50) DEFAULT NULL,
  `employee_family_id` char(38) DEFAULT NULL,
  `school_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `special_allowance_category_id` int(11) DEFAULT NULL,
  `period_start_date` date DEFAULT NULL,
  `period_end_date` date DEFAULT NULL,
  `amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `remarks` text,
  `receipt_date` date DEFAULT NULL,
  `receipt_no` varchar(255) DEFAULT NULL,
  `approved_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `policy_on` enum('Percent','Fixed') NOT NULL DEFAULT 'Percent',
  `policy_value` decimal(11,2) NOT NULL DEFAULT '0.00',
  `policy_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`special_allowance_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `special_allowance_detail` */

/*Table structure for table `special_allowance_installments` */

CREATE TABLE `special_allowance_installments` (
  `special_allowance_installment_id` varchar(40) NOT NULL,
  `special_allowance_id` varchar(40) NOT NULL,
  `installment_date` date NOT NULL,
  `installment_amount` varchar(255) NOT NULL,
  `created_by_id` int(30) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`special_allowance_installment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `special_allowance_installments` */

/*Table structure for table `special_allowance_type` */

CREATE TABLE `special_allowance_type` (
  `special_allowance_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `special_allowance_type` varchar(255) DEFAULT NULL,
  `SysTag` varchar(4) DEFAULT NULL,
  `budget_key` int(11) NOT NULL DEFAULT '0',
  `ah_key` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`special_allowance_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `special_allowance_type` */

insert  into `special_allowance_type`(`special_allowance_type_id`,`special_allowance_type`,`SysTag`,`budget_key`,`ah_key`,`created_at`,`created_by_id`,`modified_at`,`modified_by_id`) values (1,'Scholarship',NULL,0,0,'2018-08-30 08:46:03',1,NULL,NULL),(2,'Medical',NULL,0,0,'2018-08-30 08:46:25',1,NULL,NULL),(3,'Fuel',NULL,0,0,NULL,NULL,NULL,NULL);

/*Table structure for table `special_enayat` */

CREATE TABLE `special_enayat` (
  `special_enayat_id` char(38) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `document_no` int(11) NOT NULL,
  `document_identity` varchar(255) DEFAULT NULL,
  `document_date` date DEFAULT NULL,
  `document_title` varchar(255) DEFAULT NULL,
  `company_account_id` int(11) NOT NULL DEFAULT '0',
  `enayat_event_id` varchar(40) DEFAULT NULL,
  `total_employee` int(11) NOT NULL DEFAULT '0',
  `total_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `is_post` tinyint(4) DEFAULT NULL,
  `post_at` datetime DEFAULT NULL,
  `post_by_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`special_enayat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `special_enayat` */

/*Table structure for table `special_enayat_detail` */

CREATE TABLE `special_enayat_detail` (
  `special_enayat_detail_id` char(38) NOT NULL,
  `special_enayat_id` char(38) NOT NULL,
  `employee_registration_id` char(38) NOT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `employee_name` varchar(255) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `cheque_no` varchar(255) DEFAULT NULL,
  `amount` decimal(11,0) DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `party_id` int(11) NOT NULL DEFAULT '0',
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`special_enayat_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `special_enayat_detail` */

/*Table structure for table `tax_slab` */

CREATE TABLE `tax_slab` (
  `tax_slab_id` int(11) NOT NULL AUTO_INCREMENT,
  `fiscal_year_id` int(11) DEFAULT NULL,
  `range_from` decimal(17,4) DEFAULT '0.0000',
  `range_to` decimal(17,4) DEFAULT '0.0000',
  `tax_percent` decimal(17,4) DEFAULT '0.0000',
  `tax_type` varchar(255) DEFAULT NULL,
  `additional` decimal(11,2) DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`tax_slab_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `tax_slab` */

/*Table structure for table `temp_account_posting` */

CREATE TABLE `temp_account_posting` (
  `payroll_id` char(38) NOT NULL,
  `deposit_slip_id` char(38) NOT NULL,
  `cheque_no` varchar(255) NOT NULL,
  `employee_code` int(11) NOT NULL DEFAULT '0',
  `registration_code` int(11) NOT NULL DEFAULT '0',
  `employee_name` varchar(255) NOT NULL,
  `basic_salary` decimal(11,2) NOT NULL DEFAULT '0.00',
  `house_rent_allowance` decimal(11,2) NOT NULL DEFAULT '0.00',
  `other_allowance` decimal(11,2) NOT NULL DEFAULT '0.00',
  `arrears` decimal(11,2) NOT NULL DEFAULT '0.00',
  `gross_salary` decimal(11,2) NOT NULL DEFAULT '0.00',
  `other_deduction` decimal(11,2) NOT NULL DEFAULT '0.00',
  `tax_deduction` decimal(11,2) NOT NULL DEFAULT '0.00',
  `manual_addition` decimal(11,2) NOT NULL DEFAULT '0.00',
  `manual_deduction` decimal(11,2) NOT NULL DEFAULT '0.00',
  `overtime` decimal(11,2) NOT NULL DEFAULT '0.00',
  `attendance_deduction` decimal(11,2) NOT NULL DEFAULT '0.00',
  `payable_salary` decimal(11,2) NOT NULL DEFAULT '0.00',
  `advance_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `eobi_amount` decimal(11,2) NOT NULL DEFAULT '0.00',
  `bank_party_id` int(11) NOT NULL DEFAULT '0',
  `bank_ah_key` int(11) NOT NULL DEFAULT '0',
  `eobi_party_id` int(11) NOT NULL DEFAULT '0',
  `eobi_ah_key` int(11) NOT NULL DEFAULT '0',
  `tax_party_id` int(11) NOT NULL DEFAULT '0',
  `tax_ah_key` int(11) NOT NULL DEFAULT '0',
  `dept_party_id` int(11) NOT NULL DEFAULT '0',
  `dept_ah_key` int(11) NOT NULL DEFAULT '0',
  `dept_budget_key` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`payroll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `temp_account_posting` */

/*Table structure for table `temp_department` */

CREATE TABLE `temp_department` (
  `department_id` int(11) NOT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `temp_department` */

insert  into `temp_department`(`department_id`,`department_name`) values (1,'Burhani Mahal (Staff)'),(2,'Burhani Mahal'),(3,'Burhani Mahal (Chowkidar)'),(4,'Old Clifton'),(5,'P. E. C. H. S.'),(6,'Ahmed Villah'),(7,'D/20'),(8,'Najmi Manzil'),(9,'Yousufi Manzil'),(10,'Barkat-e-Hyderi Trust (S . F).'),(11,'Hatimi Manzil'),(12,'SR/6-10'),(13,'Islamabad Property'),(14,'Qasr-e-Zaiba C-102/C'),(15,'C-2 Lines Area'),(16,'UMMALS'),(17,'OFFICE STAFF'),(18,'SERVANTS / CARETAKERS'),(19,'FAIZIL MAWEEDUL BURHANIYAH /QH'),(20,'OFF. SERVANTS / PEONS / DRIVER'),(21,'OTHERS & EZZI HOMES'),(22,'ATTALIM OFFICE'),(23,'Shareka Fakhriyah Trust.'),(24,'WAZIFA & ALLOWANCES'),(25,'ISLAMABAD PLOT'),(26,'PORT QASIM AUTHORITY'),(27,'PLOT NO CL-8/3'),(28,'Construction Department'),(29,'Property Security'),(30,'Plot no.D-8 Block-C, N-N-Kar'),(31,'WAZIFA ASATEZA'),(32,'WAZIFA ASATEZA GIRLS PERIOD'),(33,'WAZIFA ASATEZA GIRLS MONTHLY'),(34,'1'),(35,'2'),(36,'3'),(37,'4'),(38,'5'),(39,'.'),(40,'.'),(41,'TANZEEM OFFICE DEPARTMENT'),(42,'MAINTENANCE DEPARTMENT'),(43,'MAKTABATUL JAMEA DEPARTMENT'),(44,'MAHADULZAHRA DEPARTMENT'),(45,'GIRLS SECTION DEPARTMENT'),(46,'RABWAT JIBLA DEPARTMENT'),(47,'AL-MAWAEED SAIFIYAH DEPARTMENT'),(48,'BOYS SECTION DEPARTMENT'),(49,'MAHALUSHIFA DEPARTMENT'),(50,'MASAKIN MOHAMMADIYAH DEPARTMEN'),(51,'KHIDMAT GUZAR DEPARTMENT'),(52,'I.B.O. DEPARTMENT'),(53,'TADREEB-E-MANZELI DEPARTMENT'),(54,'TAQWEYAT DEPARTMENT'),(55,'QISM DEPARTMENT'),(56,'BURHANI MAHAL DEPARTMENT'),(57,'SSC DEPARTMENT'),(58,'MAHAD UZ ZAHARA KIDMATGUZAR'),(59,'KHAIMAT-UL-RIYAZAT'),(60,'SWIMMING POOL DEPARTMENT'),(61,'TEACHERS PERIOD BASIS'),(62,'TEHFIZUL QURAN DEPARTMENT'),(63,'R.O. PLANT (FILTER PLANT)'),(64,'MAHMAL'),(65,'FUNUNUL QURAN'),(66,'AUDITORIUM'),(67,'TADREEBE FANNI'),(68,'BAND'),(69,'KHAZANA AAMERA'),(70,'Qism ul Manshuraat'),(71,'Classific & Database (Library)'),(72,'.'),(73,'.'),(74,'.'),(75,'.'),(76,'.'),(77,'.'),(78,'.'),(79,'.'),(80,'.'),(81,'.'),(82,'.'),(83,'.'),(84,'.'),(85,'.'),(86,'.'),(87,'.'),(88,'.'),(89,'.'),(90,'.'),(91,'.'),(92,'.'),(93,'.'),(94,'.'),(95,'.'),(96,'.'),(97,'.'),(98,'.'),(99,'PAINT, MAINTENCE AND CONVEYANC'),(100,'.'),(101,'STSMF'),(102,'Gawadar'),(103,'Gulshan-e-Iqbal Property'),(104,'BARKAT-E-HAYDERI TRUST.'),(105,'AUDITORIUM'),(106,'New Mahad - u - Zahara'),(107,'C-32 Block C'),(108,'32/A Block-2 Shabbirabad'),(109,'139-Soldier Bazar.'),(110,'Plot no.D-5 Block-C, N-N-Kar.'),(111,'Haidery Bungalow.'),(112,'Asateza Building.'),(113,'Plot no.25 (Old Queens Road)'),(114,'.'),(115,'.'),(116,'.'),(117,'.'),(118,'.'),(119,'.'),(120,'.'),(121,'Sharak Mohammediyah Trust'),(122,'Education Upliftment Project'),(123,'Al-Hutaib Trust'),(124,'.'),(125,'.'),(126,'.'),(127,'.'),(128,'.'),(129,'.'),(130,'.'),(131,'HATIMI BUILDING MAINTENANCE'),(132,'Staff'),(133,'Mukhayyam Ul Quran'),(134,'.'),(135,'.'),(136,'.'),(137,'.'),(138,'.'),(139,'.'),(140,'.'),(141,'HBMC HVAC'),(142,'HBMC POWER'),(143,'HBMC MAINTENCE');

/*Table structure for table `temp_employee` */

CREATE TABLE `temp_employee` (
  `emp_no` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `old_emp_no` varchar(255) DEFAULT NULL,
  `sex` varchar(255) DEFAULT NULL,
  `idn_no` varchar(255) DEFAULT NULL,
  `passport` varchar(255) DEFAULT NULL,
  `new_id_no` varchar(255) DEFAULT NULL,
  `fam_code` varchar(255) DEFAULT NULL,
  `dob` varchar(255) DEFAULT NULL,
  `add1` varchar(255) DEFAULT NULL,
  `add2` varchar(255) DEFAULT NULL,
  `area` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `postal_code` varchar(255) DEFAULT NULL,
  `phone_no` varchar(255) DEFAULT NULL,
  `mobile_no` varchar(255) DEFAULT NULL,
  `fax_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `id_name` varchar(255) DEFAULT NULL,
  `eobi_no` varchar(255) DEFAULT NULL,
  `eobi_date` varchar(255) DEFAULT NULL,
  `tax_no` varchar(255) DEFAULT NULL,
  `ticket_no` varchar(255) DEFAULT NULL,
  `qualifications` varchar(255) DEFAULT NULL,
  `experience` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `id_father_name` varchar(255) DEFAULT NULL,
  `sno` varchar(255) DEFAULT NULL,
  `personal_joining_date` varchar(255) DEFAULT NULL,
  `personal_leaving_date` varchar(255) DEFAULT NULL,
  `party_id` varchar(255) DEFAULT NULL,
  `ytax` varchar(255) DEFAULT NULL,
  `tax_order` varchar(255) DEFAULT NULL,
  `tax_remarks` varchar(255) DEFAULT NULL,
  `eobi_assign` varchar(255) DEFAULT NULL,
  `eobi_sno` varchar(255) DEFAULT NULL,
  `tax_name` varchar(255) DEFAULT NULL,
  `tax_father_name` varchar(255) DEFAULT NULL,
  `challan_no` varchar(255) DEFAULT NULL,
  `challan_date` varchar(255) DEFAULT NULL,
  `c87` varchar(255) DEFAULT NULL,
  `cpr_no` varchar(255) DEFAULT NULL,
  `tax_effect_date` varchar(255) DEFAULT NULL,
  `tax_active` varchar(255) DEFAULT NULL,
  `company_no` varchar(255) DEFAULT NULL,
  `expr_1002` varchar(255) DEFAULT NULL,
  `dept_no` varchar(255) DEFAULT NULL,
  `group_no` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `bank_id` varchar(255) DEFAULT NULL,
  `bank_account_title` varchar(255) DEFAULT NULL,
  `bank_account_no` varchar(255) DEFAULT NULL,
  `sal_master_doj` varchar(255) DEFAULT NULL,
  `sal_master_dol` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `temp_employee` */

insert  into `temp_employee`(`emp_no`,`first_name`,`middle_name`,`last_name`,`old_emp_no`,`sex`,`idn_no`,`passport`,`new_id_no`,`fam_code`,`dob`,`add1`,`add2`,`area`,`city`,`postal_code`,`phone_no`,`mobile_no`,`fax_no`,`email`,`id_name`,`eobi_no`,`eobi_date`,`tax_no`,`ticket_no`,`qualifications`,`experience`,`remarks`,`id_father_name`,`sno`,`personal_joining_date`,`personal_leaving_date`,`party_id`,`ytax`,`tax_order`,`tax_remarks`,`eobi_assign`,`eobi_sno`,`tax_name`,`tax_father_name`,`challan_no`,`challan_date`,`c87`,`cpr_no`,`tax_effect_date`,`tax_active`,`company_no`,`expr_1002`,`dept_no`,`group_no`,`type`,`bank_id`,`bank_account_title`,`bank_account_no`,`sal_master_doj`,`sal_master_dol`,`designation`,`company_id`) values ('492','Fida','Hussain','Ghulam Nabi','','Male','1439-3190827','','42301-5000000-0','L2T4T8','1966-01-01','Bali Tang,','Post Office Khas','0','Kohat','','021 5656197','3332299098','','','Fida Hussain','','','','','','','','Ghulam Nabi','','2001-08-01','','0','0','0','','N','0','','','0','','0','','','FALSE','16','','24','7','','1','Fida Hussain Ghulam Nabi','204390','2006-07-01','','Security Supervisor',6),('494','Mohammad','Bashir Khan','Sarwar Khan','','Male','1438-2578837','','14301-4000000-0','S61Q4P','1982-04-10','Sami Khail','Togh Bala','0','Kohat','','021 5656197','0','0','0','Mohammad Bashir Khan0','0','','0','','0','0','0','Sarwar Khan','0','2002-07-01','','0','0','0','0','N','0','','','0','','0','','','FALSE','16','','24','7','','1','Mohammad Bashir Khan','204396','2006-07-01','','Painter',6),('537','Aijaz Hussain','Mohammad Afzal Khan','.','','Male','241-90-427507','','42301-5253174-1','50D3Y6','1970-01-01','House No 17, Street No 21,','Hijrat Colony, Sector D-2,','M.T. Khan Road, ','Karachi','','','','','','Aijaz Hussain','0200e262341','2007-11-12','','','','','DHP\nAppointed as mali in burhani mahal. Refered by Mohammad Buksh. Salary Rs 5,000 pm from November 2007. EOBI deducted from November 2007.','Mohammad Afzal Khan','','2007-11-12','','3602','0','0','','','0','','','0','','0','','','FALSE','16','','24','7','','1','Aijaz Hussain','102569','2010-09-15','','Gardener',6),('665','Mohammad Kashif','Farzand','Ali','','Male','','','42201-5711123-7','LQ8K2L','1984-10-30','House No M-119','Muslimabad, Post Office Street','Malir City','Karachi','','','0345-2817711','','','Mohammad Kashif','','','','','','','As Electrition at STSMF (Replacement of Sabir Masih)','Farzand Ali','','2009-11-16','','0','0','0','','','0','','','0','','0','','','FALSE','16','','24','7','','1','Mohammad Kashif','204394','2009-11-16','','Electrition',6),('777','Riyaz Hussain','Ashiq','Hussain','','Male','','','38101-0648775-3','','1983-07-03','Kaniri','Dakhana Khas','Tehsil','Bakhar','','0334-9624024','','','','Riyaz Hussain','','','','','','','Gardner at STSMF Building employee of HMA Building Maintenance Co.','Ashiq Hussain','','2011-08-01','','0','0','0','','','0','','','0','','0','','','FALSE','16','','24','7','','1','Riyaz Hussain Ashiq Hussain','271168','2011-08-01','','Gardner',6),('915','Hatim','Shk Hashim','Dohadwala','','Male','42301-5408926-3','','42301-5408926-3','M9N339','1985-09-30','Flat No.15,3rd Flr,','Alvi Mension','Pakistan Chowk','Karachi','','','','','','Hatim','','','','','','','','Hashim','','2013-04-01','','0','0','0','','','0','','','0','','0','','','FALSE','16','','132','7','','1','Hatim Hashim','418700','2013-04-01','','Acountant',6),('960','Mohammed Sharif','Mohammed sadiq','','','Male','42301-9953741-1','','42301-9953741-1','MS857T','1974-01-01','H/No.34, Mohallah tekhry ','H/No.34, Mohallah tekhry ','colony bath island','karachi','','','','','','Mohammed Sharif','','','','','','','','Mohammed Sadiq','','2013-11-01','','0','0','0','','','0','','','0','','0','','','FALSE','16','','24','7','','1','Mohammed Shareef','476794','2013-11-01','','Gardener',6),('1114','Ghulam Abbas','Hussain','Baksh','','Male','42301-2864108-9','','42301-2864108-9','','1956-09-01','House No. 258, Street No. 19','','Neelum Colony','Karachi','74400','','0333-3412537','','','Ghulam Abbas','','','','','','','Gardner ','Hussain Baksh','','2016-01-01','','0','0','0','','','0','','','0','','0','','','FALSE','16','','24','7','','1','Ghulam Abbas ','725453','2016-01-01','','Gardener',6),('1234','Adnan Darugar','Imran Ali ','Darugar','','Male','','','42301-8639970-9','','1977-09-30','Al Maskan Building,Flat No.12','CIA Center','Saddar','Karachi','','','0302-8283994','','adnanjamalikhi@gmail.com','Adnan Darugar','','','','','Graduate','','','Imran Ali Darugar','','2017-05-01','','0','0','0','','','0','','','0','','0','','','FALSE','16','','132','7','','1','Adnan Darugar','990897','2017-05-01','','Administrator',6),('382','Aliasghar','Shabbir ','Nawab','','Male','','','42101-2279447-5','MJ5939','1985-10-18','House # A-2,','Block\'C\',','North Nazimabad.','Karachi.','74700','216671331','3002648528','215681418','ali4u052@hotmail.com','Aliasghar','','','','','','','','Shabbir Hussain','','2003-08-18','','0','0','0','','','0','','','','','','','','FALSE','16','','132','7','','1','Ali Asghar Nawab','104965','2008-07-01','','Manager',6),('1323','Kamran Younus','Mohammed','Younus','','Male','42301-0209404-5','CN-6904041','42301-0209404-5','','1985-04-04','H.No.2158, ST#10','','Azam Town','Karachi','','','0333-3512522','','','Kamran Younus','','','','','MBA','','','Mohammed Younus','','2018-01-15','','0','0','0','','N','0','','','0','','0','','','FALSE','16','','24','7','','1','Kamran Younus','1091998','2018-01-15','','Operator',6),('1310','Muhammed','Sh Norrudin','Adeeb','','Male','42101-1474418-7','','42101-1474418-7','','1992-01-31','Flat No.N-357','al burhan arcade','N.Nazimabad','Karachi','','','0331-2150797','','adeeb.muhammad13@gmail.com','Muhammed','','','','','BS(Civil engineering)','','','Nooruddin','','2017-12-04','','0','0','0','','','0','','','0','','0','','','FALSE','16','','132','7','','1','Muhammed SO Nooruddin','1076082','2017-12-04','','Engineer',6),('1309','Mustansir ','Hussain','Hussaini Najmuddin','','Male','42101-6659479-7','','42101-6659479-7','','1994-01-21','Flat A-26,Alsabah Appartment','','N.Nazimabad','Karachi','','','0335-0352953','','mustansirhusain786@gmail.com','Mustansir Hussain','N','','','','BS(Civil Engineer)','','','Hussaini Najmuddin','','2017-12-11','','0','0','0','','','0','','','0','','0','','','FALSE','16','','132','7','','1','Mustansir Hussain','1076078','2017-12-11','','Engineer',6);

/*Table structure for table `temp_employee34` */

CREATE TABLE `temp_employee34` (
  `emp_no` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `old_emp_no` varchar(255) DEFAULT NULL,
  `sex` varchar(255) DEFAULT NULL,
  `idn_no` varchar(255) DEFAULT NULL,
  `passport` varchar(255) DEFAULT NULL,
  `new_id_no` varchar(255) DEFAULT NULL,
  `fam_code` varchar(255) DEFAULT NULL,
  `dob` varchar(255) DEFAULT NULL,
  `add1` varchar(255) DEFAULT NULL,
  `add2` varchar(255) DEFAULT NULL,
  `area` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `postal_code` varchar(255) DEFAULT NULL,
  `phone_no` varchar(255) DEFAULT NULL,
  `mobile_no` varchar(255) DEFAULT NULL,
  `fax_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `id_name` varchar(255) DEFAULT NULL,
  `eobi_no` varchar(255) DEFAULT NULL,
  `eobi_date` varchar(255) DEFAULT NULL,
  `tax_no` varchar(255) DEFAULT NULL,
  `ticket_no` varchar(255) DEFAULT NULL,
  `qualifications` varchar(255) DEFAULT NULL,
  `experience` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `id_father_name` varchar(255) DEFAULT NULL,
  `sno` varchar(255) DEFAULT NULL,
  `personal_joining_date` varchar(255) DEFAULT NULL,
  `personal_leaving_date` varchar(255) DEFAULT NULL,
  `party_id` varchar(255) DEFAULT NULL,
  `ytax` varchar(255) DEFAULT NULL,
  `tax_order` varchar(255) DEFAULT NULL,
  `tax_remarks` varchar(255) DEFAULT NULL,
  `eobi_assign` varchar(255) DEFAULT NULL,
  `eobi_sno` varchar(255) DEFAULT NULL,
  `tax_name` varchar(255) DEFAULT NULL,
  `tax_father_name` varchar(255) DEFAULT NULL,
  `challan_no` varchar(255) DEFAULT NULL,
  `challan_date` varchar(255) DEFAULT NULL,
  `c87` varchar(255) DEFAULT NULL,
  `cpr_no` varchar(255) DEFAULT NULL,
  `tax_effect_date` varchar(255) DEFAULT NULL,
  `tax_active` varchar(255) DEFAULT NULL,
  `company_no` varchar(255) DEFAULT NULL,
  `expr_1002` varchar(255) DEFAULT NULL,
  `dept_no` varchar(255) DEFAULT NULL,
  `group_no` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `bank_id` varchar(255) DEFAULT NULL,
  `bank_account_title` varchar(255) DEFAULT NULL,
  `bank_account_no` varchar(255) DEFAULT NULL,
  `sal_master_doj` varchar(255) DEFAULT NULL,
  `sal_master_dol` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `temp_employee34` */

insert  into `temp_employee34`(`emp_no`,`first_name`,`middle_name`,`last_name`,`old_emp_no`,`sex`,`idn_no`,`passport`,`new_id_no`,`fam_code`,`dob`,`add1`,`add2`,`area`,`city`,`postal_code`,`phone_no`,`mobile_no`,`fax_no`,`email`,`id_name`,`eobi_no`,`eobi_date`,`tax_no`,`ticket_no`,`qualifications`,`experience`,`remarks`,`id_father_name`,`sno`,`personal_joining_date`,`personal_leaving_date`,`party_id`,`ytax`,`tax_order`,`tax_remarks`,`eobi_assign`,`eobi_sno`,`tax_name`,`tax_father_name`,`challan_no`,`challan_date`,`c87`,`cpr_no`,`tax_effect_date`,`tax_active`,`company_no`,`expr_1002`,`dept_no`,`group_no`,`type`,`bank_id`,`bank_account_title`,`bank_account_no`,`sal_master_doj`,`sal_master_dol`,`designation`,`company_id`) values ('2','Naeem bhaisaheb','Mansoor Bhaisaheb','Mohyuddin','0','Male','510-60-249193','','42301-7536224-1','JX6S0V','1960-01-01','69-D, Block 5,','Kehkashan ','Clifton ','Karachi','','','','','naeem52@yahoo.com','Naeem Mohyuddin','Not Applicable','','0548022-1','1','','Habiba Mohyuddin A/c No 100105556 JS Bank','','S/o. Mansoor bhai Mohyuddin ','','1960-01-01','','471','4507','101','Income Tax Rs 4,507 for the year 2008 from July 2007 to June 2008 has been deducted in July 2007.','','','Naeem Mohyuddin','Mansoor bhai Mohyuddin','8','2007-08-04','0','IT20070804-0250-0000008','2007-07-01','TRUE','1','','24','0','','12','Mr. Naeem Mohyuddin','005445','','','Nominee',4),('8','Mulla Mustansir ','Fakhruddin ','Khambatwala','0','Male','502-76-511725','','42000-0498401-7','N14J58','1976-05-12','Room no 18, Qasr-e-Fakhruddin','Block E, Barakat-e-Haidery,','North Nazimabad','Karachi','','36635678','03332104252','','mfkhambati@gmail.com','Mustansir','020-OA-165616','1997-01-25','1215710-4','1','','','On marriage leave from 05/12/2003 to 14/12/2003 for 9 days.','S/o. Fakhruddin ','','1997-01-25','','467','436','105','Income Tax Rs 436 for the year 2008 from July 2007 to June 2008 has been deducted in July 2007.','','','Mustansir ','Fakhruddin ','8','2007-08-04','','IT20070804-0250-0000008','2007-07-01','TRUE','1','','17','0','','12','Mr. Mustansir Fakhruddin','005406','2000-06-01','','Chief Accountant',4),('9','Syed Waqar Ahmed Jaffery','Syed Ansar Ahmed  ','Jaffery','0','Male','501-66-490411','','42101-6872516-7','O178FW','1966-01-01','House No F-16/ Federal ',' Capital  ','Area','Karachi','','','','','wjaffri@gmail.com','Syed Waqar Ahmed Jaffery','020-OG-141404','1997-02-18','1215704-0','','','','He is on leave for 3 days from 17/04/08 to 19/04/08 for his sister marriage.','S/o. Syed  Ansar Ahmed Jaffery ','','1997-02-18','','700','390','10001','Income Tax Rs 390 for the year 2008 from July 2007 to June 2008 has been deducted in July 2007.','','','Syed Waqar Ahmed Jaffery','Syed Ansar Ahmed  ','8','2007-08-04','','IT20070804-0250-0000008','2007-07-01','TRUE','1','','17','0','','12','Mr. Syed Waqar Ahmed Jafferi','005397','1986-09-01','','Typist ',4),('11','Mulla Ali Asgar AlKhumusi','Taher Ali ','Surty','0','Male','502-87-703447','','42000-0512158-3','KJ3J48','1958-05-28','Flat No B-6, 2nd Floor,','KDA Apartments, Block A,','North Nazimabad','Karachi','','6636743','','','surty52@yahoo.com','Ali Asgar Al-Khumusi','020-OJ-165617','1996-05-11','3330092-5','','','','','S/o. Taher Ali Surty','','1996-05-11','','717','397','106','Income Tax Rs 397 for the year 2008 from July 2007 to June 2008 has been deducted in July 2007.','','','Ali Asgher Al khumusi','Tahir Ali ','8','2007-08-04','','IT20070804-0250-0000008','2007-07-01','FALSE','1','','17','0','','12','Mr. Ali Asger Khumusi','005465','2000-06-01','','System Analyist.',4),('12','Hussain ','Abbas  ','Vanak','0','Male','512-93-302149','','42401-3627244-5','K065RZ','1974-08-22','House No 8,Azim Mansion,','Thatai Compound, Lunda Bazar,','','Karachi','','32732305','0321-2605252','','vanak52@gmail.com','Hussain ','020-OI-165618','2000-03-19','','','','','','Abbas ','','2000-03-19','','270','','','','','','Hussain ','Abbas  ','','','','','','TRUE','1','','17','0','','12','Mr. Hussain Abbas','005442','2000-06-01','','Accountant',4),('19','Ali Sher ','Abdul Hamid ','.','0','Male','123-86-641501','','42301-0988490-7','KM2F0Y','1935-01-01','H-166 Sector D near Ibrahim ','Masjid M. T. Khan road','Sultanabad','Karachi','','','','','','Ali Sher','020-OI-141402','1986-09-01','3314070-7','','','','Rs 200 increased from salary from April 2008','Abdul Hamid ','','1949-01-01','','61','','','','','','Ali Sher ','Abdul Hamid ','','','','','','FALSE','1','','20','0','','12','Mr. Ali Sher Abdul Hameed','005417','1949-01-01','','Head Peon',4),('20','Abdul Samad','Ali Sher','.','0','Male','123-92-641505','','42401-9663500-3','L6470Q','1970-01-01','H-166 Sector D near Ibrahim ','Masjid M. T. Khan road','Sultanabad ','Karachi','','','','','','Abdul Samad','020-OF-141405','1997-06-01','','','','','He came back from leave on 1/6/05.','Ali Sher ','','1997-06-01','','18','','','','','','Abdul Samad','Ali Sher','','','','','','FALSE','1','','20','0','','10','Mr. Abdul Samad Ali Sher','1000 99343','1986-09-01','','Office Peon',4),('21','Gul Samad','Ali Sher','.','0','Male','123-93-641509','','42401-1703329-1','N45752','1973-01-01','HA-166 Sector D Near Ibrahim','Masjid M. T. Khan road','Sultanabad','Karachi','','','','','','Gul Samad','020-OH-141403','1993-10-01','','','','','','Ali Sher ','','1993-10-01','','224','','','','','','Gul Samad','Ali Sher','','','','','','FALSE','1','','20','0','','12','Mr. Gul Samad Ali Sher','005399','1986-09-01','','Office Peon',4),('25','Fatema','Shaikh Hassan ','Ghalib','0','Female','502-38-501492','.','42101-5461838-2','N51C5Z','1935-01-10','Flat No C-306, Burhani Bagh,','Barkat-e-Haidery, Block E,','Haidery, North Nazimabad','Karachi','','','','','','Fatema','Above Age','','','','','','Her Wazifa increased from 1st August 2003  Rs 3,500/= as per Manzoori from Mumbai.Rs 1000 increased from April 2008 approved by Shz A. Fakhruddin saheb.Total salary Rs 6,000 from April 2008.','Mulla Hassan Ghalib ','','','','191','','','','','','Fatema','Shaikh Hassan ','','','','','','TRUE','1','','24','0','','10','Mrs. Fatema Hassan Ghalib','101441','','','Retired Moalima',4),('30','Mufaddal bhai','Tayeb bhaisaheb','Saifuddin','0','Male','513-86-028102','','42301-9840371-5','KL2337','1967-11-26','Hasani Masjid,','Clifton,','','Karachi','','','','','abuhuzefa@yahoo.com','Mufaddal Tayab Saifuddin','020-OG-165602','2000-06-01','1842613-1','1','','','','S/o. Tayeb A. Saifuddin','5','2000-06-01','','429','1958','4','Income Tax Rs 1,958 for the year 2008 from July 2007 to June 2008 and from Rajab 1428 to Jamadil Akhar 1429 has been deducted in July 2007.','','','Mufaddal','Tayeb A. Saifuddin','21','2007-07-20','2820','IT20070720-0250-0000021','2007-07-01','TRUE','1','','16','12','','21','Mr. Mufaddal Tyeb Saifuddin','1120657','2005-05-01','','Aamil Saleh Al Mohallahtul Mohammadiyah',4),('31','Juzer bhai','Tayeb bhai','.','0','Male','517-63-164650','','42301-1067454-3','J19J5Y','1963-09-05','Qutbi Masjid,','Saifee Market, Model Colony,','','Karachi','','','','','umme_adam@hotmail.com','Juzer Tayeb','0200D296163','2000-06-01','3737651-9','1','','','','S/o. Tayeb Yousuf Bhai','15','2000-06-01','','308','1958','21','Income Tax Rs 1,958 for the year 2008 from July 2007 to June 2008 and from Rajab 1428 to Jamadil Akhar 1429 has been deducted in July 2007.','','','Juzer bhaisaheb','Tayeb bhaisaheb','20','2007-07-20','255','IT20070720-0250-0000020','2007-07-01','TRUE','1','','16','1','','21','Mr. Juzer Tyeb','101366','2011-06-01','','Aamil Mohammadi Mohallah Soldierbazar',4),('32','Mustansir bhaisaheb','Mansoor bhaisaheb','Taheri','0','Male','515-90-118325','','42201-7209481-3','KR2R96','1957-10-16','Yousufi Masjid, Syedna ','Idris Road, ','','Karachi','','35375148','','35369252','786mustansir@gmail.com','Mustansir Mohyuddin ','020-OF-165604','2000-06-01','0914080-8','1','','','','S/o. Mansoor Taher Mohyuddin','3','2000-06-01','','465','1140','20','Income Tax Rs 1,140 for the year 2008 from July 2007 to June 2008 and from Rajab 1428 to Jamadil Akhar 1429 has been deducted in July 2007.','','','Mustansir bhaisaheb','Mansoor bhaisaheb','20','2007-07-20','1620','IT20070720-0250-0000020','2007-07-01','TRUE','1','','16','1','','21','Mr. Mustansir Mohyuddin','101427','2011-06-01','','Aamil Hussaini Mohallah Defence',4),('34','Saifuddin bhaisaheb','Tayeb bhaisaheb','.','0','Male','502-54-174171','','42101-7935521-9','','1954-10-21','Flat No C-404,','Samar Park View, ','Haidery, North Nazimabad,','Karachi','','0614516064','','','stz78652@gmail.com','Saifuddin ','020-OD-165605','2002-08-05','3728959-4','1','','Appointed as a Dawat office staff from August 2013. Salary Rs 33,000.','Farman for free from Rangoon (India) and appointed as Aamil in Quetta from 12th Zilqad 1428.Wazifa paid from Zilqad 1428.EOBI deducted from November 2007.Wazifa Rs 15,000.Reappointed as Aamil Multan. Farigh from Multan from Moharram 1434.','S/o. Tayeb bhaisaheb','8','2000-06-01','','1138','435','34','','','','Saifuddin bhaisaheb','Tayeb bhaisaheb','','2007-11-23','','','2007-11-01','TRUE','1','','24','0','','10','Mr. Saifuddin bhai Tayeb bhai','101440','2013-08-01','','Retired Aamil',4),('35','Shaikh Abbas','Mulla Akbar Ali ','Udaipurwala','0','Male','512-54-213341','CB9823461','90209-0916346-1','','1954-09-21','Ground Floor, Flat No 01,','Classic Homes, Block C,','North Nazimabad,','Karachi','','','','','','Abbas Ali Nasir','020-OE-217029','','','1','','','Appointed as Aamil Abbotabad from Jamadil Awwal 1427.Appointed as aamil in new mohalla Fakhriyah mohallah from 12/01/1428. Wazifa Rs 15,000.Additional manzori of Rs 12,000 pm from Ramazan 1433 as retired aamil.Wazifa starts from Moharram 1435 Rs 40,000','Akbar Ali ','','2006-05-01','','3008','1958','34','Income Tax Rs 1,958 for the year 2008 from July 2007 to June 2008 and from Rajab 1428 to Jamadil Akhar 1429 has been deducted in July 2007.','Y','309','Shaikh Abbas','Akber Ali ','21','2007-07-20','','IT20070720-0250-0000021','2007-07-01','TRUE','1','','24','0','','10','Mr. Abbas Ali','101442','2011-06-01','','Retired Aamil',4),('39','Shaikh Murtaza ','Najmuddin ','Godhrawala','0','Male','512-93-272104','','54400-9301097-7','Q48C2D','1973-01-01','Bohra Masjid, Burhani Nagar,','','','Hyderabad','','','','','murtazanajmuddin@gmail.com','Murtaza Najmuddin','020-OC-078663','2000-07-01','1573209-6','1','','','Transfer from Anjuman-e-Mohammadi Al-Mohallatul Mohammadiyah to USA from Jamadilawwal 1427.No wazifa paid to him from J.Awwal 1427.Transfer to Africa from Shaban 1435.','S/o. Najmuddin ','6','2000-07-01','','447','3199','14','do','','','Murtaza','Najmuddin ','113','2004-07-27','2820','','2007-07-01','TRUE','1','','16','11','','21','Mr. Murtaza Najmuddin','1000 97243','2017-04-01','','Aamil Saheb Mohallahtul Fakhriyah',4),('40','Shaikh Qutbuddin ','Shaikh Shabbir ','Kothari','0','Male','511-94-058461','','42101-1394739-7','L3G6QR','1974-02-10','Essa Masjid, Pan Mandi,','Mohammad Shah Street,','Nanakwada,','Karachi','','','','','arabi92@gmail.com','Qutbuddin Kothari','020-OI-078659','2002-08-26','2613168-4','1','','','Farman for free from Saifee Mohallah. Last wazifa paid to him for R. Akhar 1427.','S/o. Shaikh Shabbir Hussain Kothari','20','2002-08-26','','568','3199','19','do\n','','','Qutbuddin Kothari','Shabbir Kothari','111','2004-07-27','2820','','2007-07-01','TRUE','3','','35','0','','4','Mr. Qutbuddin Kothari','101486','2002-08-26','','Teacher',3),('42','Yahyah bhai','Ismail bhai','Zakavi','0','Male','517-38-326693','','42000-0489282-3','L860JT','1938-01-01','Bohra Masjid.','Anjuman-e-Saifee, Saddar,','Syedna Taher Saifuddin Road,','Hyderabad','','0222782951','','','mustaliyz@gmail.com','Yahyah bhai','Above Age','','1697910-9','1','','','Transfer as Aamil in Hyderabad Sindh from J.Awwal 1429.','S/o. Ismail bhai','6','','','770','979','8','Income Tax Rs 979 for the year 2008 from July 2007 to June 2008 and from Rajab 1428 to Jamadil Akhar 1429 has been deducted in July 2007.','','','Yahyah bhai','Ismail bhai','20','2007-07-20','2115','IT20070720-0250-0000020','2007-07-01','TRUE','1','','16','1','','21','Mr. Yahyah bhai Ismail bhai','101492','2008-05-01','','Aamil Saleh Mohallah Garikhata',4),('45','Huzefa bhai','Shabbir bhai','Zakavi','0','Male','502-93-611969','','42000-0472130-1','JB8R59','1975-01-01','Ibrahim Masjid,','Ibrahim Mohallah, Saifee Nagar','Near KMC Workshop Nishter Road','Karachi','','','','','huzefa53@yahoo.com','Huzefa ','020-OE-078653','2000-06-01','2362627-5','1','','','','S/o. Shabbir bhaisaheb','17','2000-06-01','31-May-15','284','1958','20001','Income Tax Rs 1,958 for the year 2008 from July 2007 to June 2008 and from Rajab 1428 to Jamadil Akhar 1429 has been deducted in July 2007.','Y','210','Huzefa bhai','Shabbir bhaisaheb','20','2007-07-20','2820','IT20070720-0250-0000020','2007-07-01','FALSE','1','','16','1','','21','Mr. Huzaifa Shabbir bhai','101557','2007-07-01','','Moavin Aamil Saleh Mohallah',4),('46','Nooruddin bhai','Taher bhai','Maimoon','0','Male','502-44-198588','','42101-1593937-3','L902J6','1945-06-15','Taheri Masjid, Mansfield ','Street, Dr. Syedna Mohammad','Burhanuddin Road, Saddar,','Karachi','','','','','karachiamil@alvazarat.org','Nooruddin bhai','020-OJ-165609','2000-06-01','1590904-2','1','','','','S/o. Taher bhai','4','2000-06-01','31-May-15','528','2273','10','Income Tax Rs 2,480 for the year 2007 from July 2006 to June 2007 and from Rajab 1427 to Jamadil Akhar 1428 has been deducted in July 2006.Appointed as Aamil Karachi from Rajab 1432.','','','Nooruddin bhaisaheb','Taher bhaisaheb','100','2004-07-27','3915','','2007-07-01','FALSE','1','','16','1','','21','Mr. Nooruddin bhaisaheb','1001 01372','2011-06-01','','Aamil Karachi',4),('47','Shaikh Saifuddin ','Ahmed Ali ','Munniwala','0','Male','513-65-053646','','42301-0741498-7','OM302W','1965-08-03','Burhani Masjid,','Tipu Sultan Road, Off Shahrah','-e-Faisal,','Karachi','','','','','shksaifuddinmunni@hotmail.com','Saifuddin ','020-OF-165611','2002-08-05','2613166-8','1','','Again appointed Aamil Lahore on 27/11/1423. Left from last service on 27/08/2002. His first wazifa due from Safar 1424 Rs 8,752. EOBI deducted from April 2003.','Free from Lahore from R.Akhar 1427. No wazifa paid to him from J. Awwal 1427.','S/o. Ahmed Ali Ibrahimjee','14','2011-06-01','','625','0','2100','Income Tax Rs 1,958 for the year 2007 from July 2006 to June 2007 and from Rajab 1427 to Jamadil Akhar 1428 has been deducted in July 2006.','','','Saifuddin Ahmed Ali','Ibrahimjee','115','2004-07-27','2820','','2007-07-01','TRUE','1','','16','1','','21','Mr. Saifuddin Ahmedali','101630','2011-06-01','','Aamil Ibrahim Masjid Saifee Nagar',4),('52','Shaikh Kumail Bhai','Shaikh Yunus Bhai','Tayabjee','0','Male','514-59-098908','','42301-1088845-1','N211RQ','1959-07-27','100/II, Phase VI, ','Khayaban-e-Seher','D. H. A.','Karachi','','','','','kumaily@gmail.com','Kumail ','Not Applicable','','0612333-3','1','','',' ','S/o. Yunus Tayabjee','','','','328','4762','0','Income Tax Rs 4,762 for the year 2008 from July 2007 to June 2008 has been deducted in July 2007.','','','Kumail Yunus','Tayebjee','8','2007-08-04','','IT20070804-0250-0000008','2007-07-01','TRUE','1','','24','0','','12','Mr. Kumail Yunus','005452','','','Nominee',4),('54','Ghulam Bahadur','Ayaz Khan','.','0','Male','510-43-030768','','42401-1816729-7','I6V2LJ','1943-01-01','House No D2/25, New Haji Camp,','Sultanabad,','','Karachi.','','','','','','Ghulam Bahadur','020-OC-141408','1986-01-01','3990903-4','','','','He left from service from 01/02/2003 & rejoined from 07/08/2003. He was on leave.Again from leave from 06/01/05 & willbe return back after Moharram 1426.He cameback on 10/05/2005.As per instruction of KY on 30/05/06 Rs 1000 willnotbe deducted from G.Bahad','Ayaz Khan ','','1986-01-01','','214','','','','','','Ghulam Bahadur','Ajaz Khan','','','','','','FALSE','1','','20','0','','12','Mr. Ghulam Bahadur','005421','1986-09-01','','Driver',4),('55','Abdullah Khan','Ayaz','.','0','Male','123-54-599159','','42401-0987162-3','MZ1V69','1954-10-24','House No D2/25, M.T. Khan Road','Sultanabad,','','Karachi','','','','','','Abdullah Khan','0200A262329','2011-02-01','','','','','Appointed as driver in FTC. Salary Rs 13,000. He is an employee of Port Qasim Authority Plot.','Ayaz','','2011-02-01','01-Aug-16','2164','','','','','','Abdullah Khan','Arbaz Khan','','','','','','FALSE','1','','20','0','','10','Mr. Abdullah Khan','228385','2015-02-01','','Driver',4),('72','Shaikh Shabbir ','Mulla Haider Ali ','Rasheed','0','Male','502-52-353131','','42101-1619988-7','MB8Z6R','1952-04-14','303 Yousufi Manzil ','Husami Masjid, Block C','North Nazimabad,','Karachi.','','6673356','','','shaikhshabbir52@hotmail.com','Shabbir Haiderali','020-OC-165622','2000-06-01','0612338-4','1','','','','S/o. Haiderali','','2000-06-01','','652','2032','302','Income Tax Rs 2,047 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mulla Shabbir','Haider Ali','11','2007-07-14','1729','IT20071010-0250-0000020','2007-07-01','TRUE','3','','35','0','','4','Shabbir Haiderali','1000 91911','2000-06-01','','Teacher',3),('74','Shaikh Tahir ','Ebrahim Abdul Hussain ','Godhrawala','0','Male','502-51-451129','','42101-1592229-5','16J4TF','1951-08-30','203 Najmi Manzil Husam','Masjid, Block C','North Nazimabad ','Karachi.','','6672820','','','najgod@gmail.com','Taher Ibrahim Godhrawala','020-OA-165624','2000-06-01','0612336-8','1','','','','S/o. Ibrahim Abdul Hussain  Godhrawala','','2000-06-01','','824','2032','304','Income Tax Rs 2,047 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Taher Ibrahim Godhrawala','Ibrahim Abdul Hussain','10','2007-07-14','1729','IT20071010-0250-0000019','2007-07-01','TRUE','3','','35','0','','4','Taher Ebrahim Godhrawala','1000 91687','2000-06-01','','Teacher',3),('75','Shaikh Mustansir ','Ebrahimjee','Rangoonwala','0','Male','515-92-279794','','42101-6997025-9','IS8G94','1954-07-01','204 Yousufi Manzil Husami,','Masjid Block C ','North Nazimabad ','Karachi.','','6634933','','','mer5152@gmail.com','Mustansir bhai','020-OJ-165625','2000-06-01','0886695-3','1','','','','S/o. Ebrahimjee ','','2000-06-01','','466','2032','305','Income Tax Rs 2,047 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mustansir bhai','Ebrahimjee','12','2007-07-14','1729','IT20071010-0250-0000021','2007-07-01','TRUE','3','','35','0','','4','Mustansir Ibrahimje','1000 91733','2000-06-01','','Teacher',3),('76','Shaikh Murtaza ','Akber Ali ','Africawala','0','Male','502-51-436027','','42101-8866457-5','OY3Y7L','1951-05-30','203, Yousufi Manzil Husami','Masjid Block C','North Nazimabad ','Karachi.','','6672637','','','morbi92@yahoo.com','Murtaza Akber Ali','020-OA-078657','2000-06-01','0886680-5','1','','','','S/o. Akber Ali ','','2000-06-01','','442','1933','306','Income Tax Rs 1,948 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Murtaza','Akber Ali ','10','2007-07-14','1759','IT20071010-0250-0000018','2007-07-01','TRUE','3','','35','0','','4','Murtaza Akbarali','1000 91946','2000-06-01','','Teachers',3),('77','Shaikh Mustafa ','Hassan Ali ','Rasheed','0','Male','502-54-822986','','42101-1777407-3','L219BR','1954-04-09','105 Najmi Manzil Husam','Masjid, Block C ','North Nazimabad ','Karachi.','','6671978','','','shmustafah@gmail.com','Mustafa ','020-OH-165627','2000-06-01','1336604-1','1','','','','S/o. Hassan Ali ','','2000-06-01','','456','1933','307','Income Tax Rs 1,948 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mustafa','Hassan Ali ','10','2007-07-14','1759','IT20071010-0250-0000018','2007-07-01','TRUE','3','','35','0','','4','Mustafa Hassan Ali','1000 91709','2000-06-01','','Teachers',3),('80','Shaikh Essa ','Shaikh Abdulqadir','Haidermota','0','Male','510-86-263475','','42101-6830038-9','O58D4D','1955-01-05','101 Najmi Manzil Husami','Masjid, Block C','North Nazimabad','Karachi.','','6673174','0320-5031133','','essa5152@gmail.com','Essa bhai Abdul Kader','020-OH-165635','2000-06-01','0885800-4','1','','','','S/o. Shaikh  Abdul Kader','','2000-06-01','','162','1933','309','Income Tax Rs 1,948 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Essa bhai','Shaikh Abdul Kader','10','2007-07-14','1759','IT20071010-0250-0000018','2007-07-01','TRUE','3','','35','0','','4','Essa Bhai Abdulqadar','1000 91717','2000-06-01','','Teacher',3),('81','Shaikh Shabbir ','Haji Yousuf Ali ','.','0','Male','515-91-279788','','42101-1594186-3','M593CD','1958-04-01','002 Najmi Manzil Husami','Masjid, Block C','North Nazimabad ','Karachi.','','','0300-9220938','','rashabi52@gmail.com','Shabbir bhai','020-OI-165676','2000-08-01','2613172-2','1','','','','S/o. Yousuf Ali ','','2000-08-01','','659','1238','2202','Income Tax Rs 1,247 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Haji Shabbir bhai','Haji Yousuf Ali ','13','2007-07-14','1537','IT20071010-0250-0000022','2007-07-01','TRUE','3','','35','0','','4','Shabbir Bhai Yousuf Ali','1000 91768','2000-08-01','','Teacher',3),('82','Shaikh Saifuddin ','Yousuf Ali ','Halai','0','Male','502-55-183549','','42101-1777415-7','O07Z7L','1955-01-01','005 Najmi Manzil Husami','Masjid, Block C','North Nazimabad ','Karachi.','','6671946','','','saifhalai53@gmail.com','Mulla Saifuddin ','020-OG-165628','2000-06-01','2613173-7','1','','','','S/o. Yousuf Ali','','2000-06-01','','628','1238','311','Income Tax Rs 1,247 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mulla Saifuddin','Yousuf Ali ','13','2007-07-14','1537','IT20071010-0250-0000021','2007-07-01','TRUE','3','','35','0','','4','Mulla Saifuddin Yousuf Ali','1000 91881','2000-06-01','','Teacher',3),('83','Shaikh Juzer ','Shaikh Qurban Hussain ','Adeeb','0','Male','518-55-132946','','42000-0457081-7','KL111R','1955-05-21','004 Najmi Manzil Husami','Masjid,  Block C','North Nazimabad ','Karachi.','','6672723','0300-2135286','','jadeeb52@gmail.com','Juzer Adeeb','020-OF-165629','2000-06-01','1590966-2','1','','','','S/o. Shaikh Qurban Hussain Adeeb','','2000-06-01','','309','1238','312','Income Tax Rs 1,247 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Juzer Adeeb','Sh. Qurban Hussain Adeeb','11','2007-07-14','1537','IT20071010-0250-0000019','2007-07-01','TRUE','3','','35','0','','4','Juzer Adeeb','1000 91725','2000-06-01','','Teacher',3),('84','Shaikh Zoeb ','Abdul Hussain ','Attar','0','Male','502-56-546848','','42101-8351844-1','IS3Q9M','1956-01-01','006 Najmi Manzil Husami','Masjid, Block C','North Nazimabad ','Karachi.','','6673173','','','zoebjumana110@gmail.com','Zoeb Attar','020-OC-165630','2000-06-01','2618034-7','1','','','','S/o. Abdul Hussain Attar','','2000-06-01','','802','1238','313','Income Tax Rs 1,247 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Zoeb Attar','Abdul Hussain Attar','12','2007-07-14','1537','IT20071010-0250-0000020','2007-07-01','TRUE','3','','35','0','','4','Zoeb Attar','1000 91830','2000-06-01','','Teacher',3),('85','Muder Bhaisaheb','Hatim Bhaisaheb','.','0','Male','450-87-083159','','42000-0531180-7','JT4F4W','1958-08-24','103 Najmi Manzil Husami','Masjid, Block C','North Nazimabad ','Karachi.','','6672217','','','muderhatim1@gmail.com','Muder Hatim bhai ','020-OB-165631','2000-06-01','0886365-2','1','','','','S/o. Hatim ','','2000-06-01','','428','1238','314','Income Tax Rs 1,247 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Muder Bhai','Hatim Bhai','10','2007-07-14','1537','IT20071010-0250-0000018','2007-07-01','TRUE','1','','16','1','','21','Mr. Muder Hatim bhai','100091865','2018-04-01','','Aamil Hasani Mohallah Clifton',4),('86','Murtaza Bhai','Tayeb Bhai','.','0','Male','502-85-310466','','42101-1777405-9','O07X7V','1958-08-01','104 Najmi Manzil Husami','Masjid, Block C','North Nazimabad ','Karachi.','','6624931','','','mzjamea@gmail.com','Murtaza bhai','020-OA-165632','2000-06-01','2618035-9','1','','','','S/o. Tayeb bhai ','','2000-06-01','','844','1238','315','Income Tax Rs 1,247 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Murtaza Bhai','Tayeb Bhai','10','2007-07-14','1537','IT20071010-0250-0000018','2007-07-01','TRUE','3','','35','0','','4','Murtaza bhai Tyeb bhai','1000 91792','2000-06-01','','Teacher',3),('87','Shaikh Qutub Khan','Shaikh Amiruddin ','Kothari','0','Male','502-89-731422','','42101-8227578-1','J0P7T4','1957-01-01','001 Najmi Manzil Husami','Masjid, Block C ','North Nazimabad ','Karachi.','','6673353','0333-2208548','','qutubkhankothari786@gmail.com','Qutub Khan Kothari','020-OJ-165633','2000-06-01','1420865-2','1','','','','S/o. Shaikh  Amiruddin','','2000-06-01','','569','1188','316','Income Tax Rs 1,198 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Qutub Khan Kothari','Shaikh Amiruddin ','13','2007-07-14','1321','IT20071010-0250-0000021','2007-07-01','TRUE','3','','35','0','','4','Qutub Khan Kothari','1000 91741','2000-06-01','','Teacher',3),('88','Shaikh Hussain ','Mulla Najmuddin ','Jessorwala','0','Male','502-60-030352','','42101-1778396-7','JT1051','1960-11-11','201 Yousufi Manzil ','Husami Masjid, Block C','North Nazimabad ','Karachi.','','6673825','','','hussain_najmuddin@yahoo.com','Hussain Haji Najmuddin','020-OF-078652','2000-06-01','2613174-9','1','','','','S/o. Najmuddin Mulla Adam Ali','','2000-06-01','','273','1138','319','Income Tax Rs 1,147 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Hussain Najmuddin','Haji Najmuddin Mulla Adamali','11','2007-07-14','1102','IT20071010-0250-0000019','2007-07-01','TRUE','3','','35','0','','4','Hussain Haji Najmuddin','1000 92063','2000-06-01','','Teacher',3),('89','Shaikh Mustafa ','Fazle Abbas','Mithaiwala','0','Male','502-56-335701','','42101-1777882-5','M448NG','1956-01-01','101 Yousufi Manzil ','Husami Masjid Block C','North Nazimabad ','Karachi.','','6671705','','','mmithai@hotmail.com','Mustafa Fazal Abbas','020-OH-165677','2000-08-01','0276506-3','1','','','','S/o. Fazal Abbas ','','2000-08-01','','455','1138','320','Income Tax Rs 1,147 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mustafa','Fazal Abbas','12','2007-07-14','1102','IT20071010-0250-0000021','2007-07-01','TRUE','3','','35','0','','4','Mustafa Fazalabbas','1000 91989','2000-08-01','','Teacher',3),('90','Shaikh Tayeb ','Shaikh Taher Ibrahim','Jamali','0','Male','508-62-314137','','42101-1788004-3','','1962-09-04','301 Yousufi Manzil, ST-4,','Husami Masjid, Block C','North Nazimabad','Karachi.','','6672032','0320-4065252','','tfjam21@gmail.com','Tayeb Jamali','020-OG-165678','2000-08-01','2618036-7','1','','','','S/o. Tahir Shaikh Ibrahim Jamali','','2000-08-01','','725','1138','321','Income Tax Rs 1,147 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Tayeb','Taher Shaikh Ibrahim','11','2007-07-14','1102','IT20071010-0250-0000019','2007-07-01','TRUE','3','','35','0','','4','Tayyab Jamali','594028','2000-08-01','','Teacher',3),('91','Shaikh Mohammad','Mulla Saifuddin ','Anjarwala','0','Male','502-62-054059','','42101-1708866-3','J22P3X','1962-10-27','202 Yousufi Manzil ','Husami Masjid, Block C','North Nazimabad ','Karachi.','','6625188','','','shmohammedezzi202@gmail.com','Mohammad Saifuddin','020-OF-165679','2000-08-01','1229981-2','1','','','','S/o. Saifuddin Tayeb Ali ','','2000-08-01','','420','1138','322','Income Tax Rs 1,147 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mohammad','Saifuddin Tayeb Ali','10','2007-07-14','1102','IT20071010-0250-0000018','2007-07-01','TRUE','3','','35','0','','4','Mohammad Saifuddin','1000 91903','2000-08-01','','Teacher',3),('94','Quresh Bhai','Abbas Bhai','.','0','Male','502-63-177081','','42101-1785987-9','OW157N','1963-11-25','C-11 Block C, ','Haidery,','North Nazimabad','Karachi','','6632752','03222702722','','qureshabbas51@gmail.com','Quresh Abbas','020-OG-165636','2000-06-01','2400890-7','1','','','','S/o. Abbas A. bhai','','2000-06-01','','560','1089','2203','Income Tax Rs 408 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Quresh','Abbas A. Bhaisaheb','11','2007-07-14','883','IT20071010-0250-0000019','2007-07-01','TRUE','1','','16','2','','21','Mr. Quresh Abbas','100091873','2018-04-01','','Aamil Rawalpindi',4),('95','Shaikh Quresh ','Saifuddin ','Faizullahbhoy','0','Male','502-89-745467','','42101-4412911-1','O33Z13','1965-12-15','103 Yousufi Manzil ','Husami Masjid, Block C','North Nazimabad ','Karachi.','','6674418','0300-8262676','','qurfaiz@gmail.com','Quresh ','020-OB-165681','2000-08-01','2613176-5','1','','','','S/o. Saifuddin ','','2000-08-01','','562','1005','328','Income Tax Rs 1,013 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Quresh','Saifuddin ','10','2007-07-14','518','IT20071010-0250-0000018','2007-07-01','TRUE','3','','35','0','','4','Quresh Saifuddin','1000 92357','2000-08-01','','Teacher',3),('96','Shaikh Mustafa ','Shaikh Qutbuddin ','Khambatwala','0','Male','513-62-013266','','42101-0741662-7','I1L2T4','1962-10-29','102 Yousufi Manzil ','Husami Masjid, Block C','North Nazimabad ','Karachi.','','6672492','','','taj5152@gmail.com','Mustafa ','0200D328261','2016-05-01','2618038-3','1','','','','S/o. Qutbuddin ','','2000-08-01','','964','1005','329','Income Tax Rs 1,013 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mustafa','Qutbuddin','14','2007-07-14','518','IT20071010-0250-0000022','2007-07-01','TRUE','3','','35','0','','4','Mustafa Kutbuddin','1000 91954','2000-08-01','','Teacher',3),('97','Shaikh Fakhruddin ','Shaikh Fida Hussain','Rampurawala','0','Male','502-86-000784','','42101-1619992-5','O6Y6Y5','1968-05-12','304 Yousufi Manzil','Husami Masjid, Block C','North Nazimabad ','Karachi.','','6634650','','','fakhrf@yahoo.com','Fakhruddin Fida Hussain','020-OJ-165683','2000-08-01','2613177-3','1','','','','S/o. Fida Hussain Mulla Ibrahim','','2000-08-01','','832','469','333','Income Tax Rs 473 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Fakhruddin','Fida Hussain M. Ibrahim','12','2007-07-14','228','IT20071010-0250-0000020','2007-07-01','TRUE','3','','35','0','','4','Fakhruddin Fidahussain','1000 91997','2000-08-01','','Teacher',3),('99','Shaikh Khuzema','Shaikh Ali Hussain ','Ramakdawala','0','Male','517-62-136357','','42101-1379513-7','J2361W','1962-07-29','C-23/C  ','Block C','North Nazimabad ','Karachi','','6636764','','','khuzaimaramakra@gmail.com','Khuzema ','020-OH-165685','2000-08-01','2366470-3','1','','','','S/o. Ali Hussain ','','2000-08-01','','325','1089','326','Income Tax Rs 408 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Khuzema','Ali Hussain','12','2007-07-14','883','IT20071010-0250-0000020','2007-07-01','TRUE','3','','35','0','','4','Khuzaima Ali Hussain','1000 92012','2000-08-01','','Teacher',3),('100','Shaikh Hassan ','Shaikh Fakhruddin ','Muhezawala','0','Male','','','834420-362367-1','','1968-01-01','Flat No 302, Block A,','Shadman Apartment,','Shabbirabad,','Karachi.','','6671435','0300-2110880','','jamboafrika@yahoo.com','Hassan ','020-OG-165686','2000-08-01','2616700-0','1','','','','S/o. Fakhruddin ','','2000-08-01','','253','469','330','Income Tax Rs 473 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Hassan','Fakhruddin','10','2007-07-14','228','IT20071010-0250-0000018','2007-07-01','TRUE','3','','35','0','','4','Hassan Fakhruddin Muhezawala','1200 18985','2000-08-01','','Teacher',3),('101','Shaikh Abbas ','Abdullah ','Motiwala','0','Male','502-88-007340','','42101-2652115-3','IM4D2R','1970-02-19','204 Yousufi Manzil ','Husami Masjid, Block C','North Nazimabad ','Karachi.','','','','','aamotiwala@gmail.com','Abbas Motiwala','0200C308458','2014-08-01','2616701-8','1','','','','S/o. Abdullah ','','2000-08-01','','5','469','0','Income Tax Rs 473 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Abbas','Abdullah ','12','2007-07-14','228','IT20071010-0250-0000020','2007-07-01','TRUE','3','','35','0','','4','Abbas Motiwala Abdullah','544628','2000-08-01','','Teacher',3),('102','Shaikh Ali Ashger','Zoaib ','Multanwala','0','Male','515-88-018286','','42101-1708953-3','LT3042','1970-01-01','G-5 Yousufi Manzil Husami ','Masjid, Block C','North Nazimabad ','Karachi.','','','','','aliasghar9063@yahoo.co.in','Ali Ashger ','020-OE-165688','2000-08-01','2618040-5','1','','','','S/o. Zoaib ','','2000-08-01','','49','469','335','Income Tax Rs 473 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Ali Ashger','Zoaib Multanwala','13','2007-07-14','228','IT20071010-0250-0000021','2007-07-01','TRUE','3','','35','0','','4','Ali Asghar Zoaib','100103871','2000-08-01','','Teacher',3),('104','Shaikh Moiz ','Zoaib ','Noorani','0','Male','502-69-926972','','42101-1777376-7','NY4Y0D','1969-06-19','04 Yousufi Manzil ','Husami Masjid, Block C','North Nazimabad ','Karachi.','','','','','mznoorani@yahoo.com','Moiz Noorani','020-OA-165690','2000-08-01','2613178-1','1','','','','S/o. Zoaib  Noorani ','','2000-08-01','','423','453','337','Income Tax Rs 457 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Moiz Noorani','Zoaib Adam Ali Noorani','13','2007-07-14','85','IT20071010-0250-0000021','2007-07-01','TRUE','3','','35','0','','4','Moiz Noorani Zoeb Noorani','1000 97219','2000-08-01','','Teacher',3),('106','Shaikh Shabbir ','Mulla Fakhruddin ','Baghichawala','0','Male','502-92-766234','','42101-7888294-3','O00Y7M','1973-01-01','Flat No 9, 2nd Floor, Ghosia','Market, Haidery,','North Nazimabad,','Karachi.','','','','','shabbirhusaini@yahoo.com','Shabbir Hussaini','020-OI-165692','2000-08-01','3728931.4','1','','','','S/o. Fakhruddin ','','2000-08-01','','959','403','342','Income Tax Rs 406 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mulla Shabbir ','Mulla Fakhruddin ','13','2007-07-14','','IT20071010-0250-0000022','2007-07-01','TRUE','3','','35','0','','4','Shabbir Hussaini Fakhruddin','1001 01143','2000-08-01','','Teacher',3),('108','Shaikh Tahir ','Ibrahim Ali','Ramakdawala','0','Male','502-55-091486','','42000-0540016-1','KF427C','1955-01-01','Flat No 1, Mohammadi Manzil','Block C, D-20,','North Nazimabad,','Karachi.','','6635065','','','shktahir52@gmail.com','Tahir Ali','020-OF-165637','2000-06-01','1507331-9','1','','','','Ibrahim Bhai','','2000-06-01','','710','1188','317','Income Tax Rs 1,198 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Tahir Ali Ramakdawala','Ibrahim','11','2007-07-14','1321','IT20071010-0250-0000020','2007-07-01','TRUE','3','','36','0','','4','Taher Ali Ramakdawala','1000 91806','2000-06-01','','Khidmatguzar',3),('109','Shaikh Shabbir ','Mulla Hassan Ali ','Jamnagarwala','0','Male','515-54-054499','','42101-1778431-9','MT0Y5W','1954-01-01','Flat No 2 Burhani Bagh Block E','Haidery, ','North Nazimabad','Karachi.','','','','','shabbir800@gmail.com','Shabbir Hussain ','020-OG-165694','2000-08-01','0886987-1','1','','','','S/o. Hassan Ali ','','2000-08-01','','653','1188','318','Income Tax Rs 443 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Shabbir Hussain','Hassan Ali','13','2007-07-14','1321','IT20071010-0250-0000021','2007-07-01','TRUE','3','','36','0','','4','Shabbir Hussain Hassan Ali','1000 92004','2000-08-01','','Khidmatguzar',3),('110','Shaikh Ali Asgher ','Shaikh Abdul Hussain','Bhinderwala','0','Male','513-80-083927','','42101-1932424-7','JJ7V6G','1961-06-26','Flat No 103/A, Burhani Bagh','Block E,','North Nazimabad','Karachi.','','','','','saasah@gmail.com','Ali Asgher ','020-OF-165695','2000-08-01','2613175-7','1','','','','S/o. Abdul Hussain ','','2000-08-01','','44','1089','323','Income Tax Rs 1,097 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Ali Asgher','Abdul Hussain','12','2007-07-14','883','IT20071010-0250-0000020','2007-07-01','TRUE','3','','36','0','','4','Aliasghar Abdulhussain','1000 92020','2000-08-01','','Khidmatguzar',3),('111','Shaikh Abdul Hussain ','Shaikh Ismail','Rampurawala','0','Male','450-62-001583','','42101-1376401-9','M152QJ','1962-06-08','Flat No 6 Burhani Bagh Block E','North Nazimabad','Haidery,','Karachi.','','','','','ahrzb@yahoo.com','Abdul Hussain ','020-OE-165638','2000-06-01','2616699-2','1','','','','S/o. Shaikh Ismail ','','2000-06-01','','16','1089','324','Income Tax Rs 408 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Abdul Hussain','Shaikh Ismail','11','2007-07-14','883','IT20071010-0250-0000019','2007-07-01','TRUE','3','','36','0','','4','AbdulHussain Shaikh Ismail','1000 91784','2000-06-01','','Khidmatguzar',3),('112','Shaikh Saifuddin ','Zainuddin','Rampurawala','0','Male','512-89-142017','','42101-1932393-5','O8B3ZC','1967-01-01','D-20 Mohammadi Manzil','Block C, North Nazimabad','Haidery,','Karachi.','','','','','szrfar@gmail.com','Saifuddin ','020-OE-165696','2000-08-01','1307838-7','1','','','','S/o. Zainuddin ','','2000-08-01','','629','469','332','Income Tax Rs 473 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Saifuddin','Zainuddin','12','2007-07-14','228','IT20071010-0250-0000020','2007-07-01','TRUE','3','','36','0','','4','Saifuddin Zainuddin','1000 91822','2000-08-01','','Khidmatguzar',3),('114','Shaikh Hatim Ali ','Ghulam Abbas','Mandasorewala','0','Male','513-74-127526','','42301-0849762-9','OB6M8C','1974-01-28','House No 49-B, Kanchwala','Building, ','Nishter Road, ','Karachi.','','','','','htmj52@gmail.com','Hatim ','020-OF-165645','2000-07-01','3737104-5','1','','','','S/o. Ghulam Abbas ','','2000-07-01','','254','376','342','Income Tax Rs 376 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Mulla Hatim Ali ','Ghulam Abbas','13','2007-07-14','','IT20071010-0250-0000021','2007-07-01','TRUE','3','','35','0','','4','Hatim Ghulamabbas','1001 02220 ','2001-07-01','','Teacher',3),('116','Munira ','Ilyas Bhaisaheb','.','0','Female','502-61-322489','','42000-0359757-6','J5S657','1971-01-01','Flat No 202 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery','Karachi.','','','','','itb102@gmail.com','Munira Ilyas','020-OF-172684','2000-07-01','','','','','','W/o. Ilyas ','','2000-07-01','','438','234','0','','','','Munira ','Ilyas Bhaisaheb','','','','','','FALSE','3','','32','5','','24','Munira Ilyas','0100251871010','2000-07-01','','Teacher',3),('117','Mulla Durriyah','Mohammad Hussain ','Noorani','0','Male','515-51-027892','','42101-7342462-6','I417R9','1951-01-01','Flat No 38 Mustafa Market ','Block G,','North Nazimabad, Haidery ','Karachi.','','','','','durriya9032@gmail.com','Durriyah Mohammad Bhai','020-OE-172685','2000-07-01','3988052-4','','','','','W/o. Mohammad bhai ','0','2000-07-01','','152','677','2601','','','','Mulla Durriyah','Mohammad Hussain ','','','','','','TRUE','3','','32','5','','5','Durriya Mohammad Bhai','1000 92810','2000-07-01','','Teacher',3),('117','Mulla Durriyah','Mohammad Hussain ','Noorani','0','Male','515-51-027892','','42101-7342462-6','I417R9','1951-01-01','Flat No 38 Mustafa Market ','Block G,','North Nazimabad, Haidery ','Karachi.','','','','','durriya9032@gmail.com','Durriyah Mohammad Bhai','020-OE-172685','2000-07-01','3988052-4','','','','','W/o. Mohammad bhai ','0','2000-07-01','','152','677','2601','','','','Mulla Durriyah','Mohammad Hussain ','','','','','','TRUE','3','','35','0','','4','Durriya Mohammad Bhai','100092810','2005-03-01','','Teacher',3),('118','Mulla Rashida ','Shaikh Hussain Najmuddin','Jessorwala','0','Female','502-88-717560','','42101-1653796-8','JT1051','1968-01-15','Flat No 201 Yousufi Manzil','Husami Masjid Compound Block C','North Nazimabad Haidery ','Karachi.','','','','','hussain_najmuddin@yahoo.com','Rashida','020-OD-172686','2000-07-01','4071100-5','','','','','W/o. Hussain ','0','2000-07-01','','581','38','2602','','','','Mulla Rashida ','Shaikh Hussain Najmuddin','','','','','','TRUE','3','','35','0','','4','Rashida Hussain','100103251','2005-03-01','','Teacher',3),('120','Mulla Raziya ','Mulla Ahmed  ','Burhani','0','Male','513-92-122517','','42301-0960864-6','IJ9M37','1962-11-17','House No D-37, Clifton Estate,','Khayaban-e-Jami, ','Clifton ','Karachi','','','','','raziaburhani5253@gmail.com','Raziyah Ahmed Burhani','020-OI-172681','2000-07-01','2381655-4','','','','','W/o. Ahmed Burhani ','','2000-07-01','','586','','2604','','','','Mulla Raziya ','Mulla Ahmed  ','','','','','','TRUE','3','','32','5','','5','Razia Ahmed Burhani','1000 94074','2000-07-01','','Teacher',3),('120','Mulla Raziya ','Mulla Ahmed  ','Burhani','0','Male','513-92-122517','','42301-0960864-6','IJ9M37','1962-11-17','House No D-37, Clifton Estate,','Khayaban-e-Jami, ','Clifton ','Karachi','','','','','raziaburhani5253@gmail.com','Raziyah Ahmed Burhani','020-OI-172681','2000-07-01','2381655-4','','','','','W/o. Ahmed Burhani ','','2000-07-01','','586','','2604','','','','Mulla Raziya ','Mulla Ahmed  ','','','','','','TRUE','3','','35','0','','4','Razia Ahmed Burhani','100094074','2005-03-01','','Teacher',3),('121','Mulla Asma ','Shaikh Qutub Khan ','Kothari ','0','Female','502-89-731423','','42000-0419581-4','J0P7T4','1965-01-01','Flat No 001 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad  Haidery ','Karachi.','','','','','asma_kothari@hotmail.com','Asma','020-OE-172651','2000-07-01','3986923-7','','','','','W/o. Qutub Khan Kothari','','2000-07-01','','93','0','8008','','','','Mulla Asma ','Shaikh Qutub Khan ','','','','','','TRUE','3','','32','5','','5','Asma Qutubkhan Kothari','1001 03189','2000-07-01','','Teacher',3),('121','Mulla Asma ','Shaikh Qutub Khan ','Kothari ','0','Female','502-89-731423','','42000-0419581-4','J0P7T4','1965-01-01','Flat No 001 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad  Haidery ','Karachi.','','','','','asma_kothari@hotmail.com','Asma','020-OE-172651','2000-07-01','3986923-7','','','','','W/o. Qutub Khan Kothari','','2000-07-01','','93','0','8008','','','','Mulla Asma ','Shaikh Qutub Khan ','','','','','','TRUE','3','','35','0','','4','Asma Qutubkhan Kothari','100103189','2005-03-01','','Teacher',3),('122','Mulla Builquis ','Ali Mohammad','Ujjainwala','0','Female','502-68-244761','','42101-4445040-8','J4B5SN','1968-03-01','Flat No C-25 Ali Rehana Square','Block G Haidery ','North Nazimabad','Karachi.','','','','','bilqueesali@yahoo.com','Builquis','020-OD-172652','2000-07-01','2546801-4','','','','','W/o. Ali Mohammad','','2000-07-01','','108','110','0','','','','Mulla Builquis ','Saifuddin ','','','','','','TRUE','3','','32','5','','5','Bilquees Ali Mohammad','1000 92802','2000-07-01','','Teacher',3),('122','Mulla Builquis ','Ali Mohammad','Ujjainwala','0','Female','502-68-244761','','42101-4445040-8','J4B5SN','1968-03-01','Flat No C-25 Ali Rehana Square','Block G Haidery ','North Nazimabad','Karachi.','','','','','bilqueesali@yahoo.com','Builquis','020-OD-172652','2000-07-01','2546801-4','','','','','W/o. Ali Mohammad','','2000-07-01','','108','110','0','','','','Mulla Builquis ','Saifuddin ','','','','','','TRUE','3','','35','0','','4','Bilquees Ali Mohammad','100092802','2005-03-01','','Teacher',3),('123','Mulla Munira','Mulla Ali Asgher ','Rampurawala','0','Male','502-69-801777','','42101-1609155-0','O760D0','1969-07-06','E/35 Block E Haidery ','Memorial Market','North Nazimabad ','Karachi.','','','','','mabrook52@live.com','Munira Ali Asgher','020-OC-172653','2000-07-01','3987391-9','','','','','W/o. Ali Asgher ','','2000-07-01','','439','340','0','','','','Mulla Munira','Mulla Ali Asgher ','','','','','','TRUE','3','','35','0','','4','Munira Ali Asgher','100093132','2005-03-01','','Teacher',3),('123','Mulla Munira','Mulla Ali Asgher ','Rampurawala','0','Male','502-69-801777','','42101-1609155-0','O760D0','1969-07-06','E/35 Block E Haidery ','Memorial Market','North Nazimabad ','Karachi.','','','','','mabrook52@live.com','Munira Ali Asgher','020-OC-172653','2000-07-01','3987391-9','','','','','W/o. Ali Asgher ','','2000-07-01','','439','340','0','','','','Mulla Munira','Mulla Ali Asgher ','','','','','','TRUE','3','','32','5','','5','Munira Aliasgher','1000 93132','2000-07-01','','Teacher',3),('124','Mulla Farida ','Shaikh Zohair Abbas ','Haidermota','0','Female','515-92-286864','','42101-6018549-0','K700B4','1965-07-21','A-5/9 Al Hamrah Square ','North Nazimabad ','Haidery ','Karachi.','','','03322121523','','fzjamea@yahoo.com','Farida','020-OC-172687','2000-07-01','1558001-6','','','','','W/o. Zohair ','','2000-07-01','','184','342','8009','','','','Farida ','Mulla Zohair Abbas ','','','','','','TRUE','3','','35','0','','4','Farida Zohair','100095968','2005-03-01','','Teacher',3),('124','Mulla Farida ','Shaikh Zohair Abbas ','Haidermota','0','Female','515-92-286864','','42101-6018549-0','K700B4','1965-07-21','A-5/9 Al Hamrah Square ','North Nazimabad ','Haidery ','Karachi.','','','03322121523','','fzjamea@yahoo.com','Farida','020-OC-172687','2000-07-01','1558001-6','','','','','W/o. Zohair ','','2000-07-01','','184','342','8009','','','','Farida ','Mulla Zohair Abbas ','','','','','','TRUE','3','','32','5','','5','Farida Zohair','1000 95968','2000-07-01','','Teacher',3),('125','Nafisa','Shaikh Ali Asgher ','Feroze','0','Female','507-76-288632','','42101-1484166-4','L703JC','1976-11-19','Flat No 01 Yousufi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery ','Karachi.','','','','','nafeesaaliaghar@yahoo.com','Nafisa','020-OC-172679','2000-07-01','','','','','','W/o. Ali Asgher ','','','','475','557','0','','','','Nafisa','Mulla Ali Asgher Zoaib','','','','','','FALSE','3','','32','5','','5','Nafeesa Aliasgher','1000 97782','2000-07-01','','Teacher',3),('126','Shaikh Zainuddin ','Ismail  ','Karimjee','0','Male','507-58-018142','','42301-4626107-7','KX6S0Z','1958-01-01','House No 99/11, 10th Commercia','Street, Phase IV, DHA,','','Karachi.','','','','','zainuddinshakir@gmail.com','Zainuddin','020-OJ-172680','2000-07-01','3929308-4','','','','','S/o. M. Ismail ','','2000-07-01','','794','','0','','','','Shaikh Zainuddin ','Ismail  ','','','','','','TRUE','3','','32','5','','5','Zainuddin Mulla Ismail','1000 99041','2000-07-01','','Teacher',3),('126','Shaikh Zainuddin ','Ismail  ','Karimjee','0','Male','507-58-018142','','42301-4626107-7','KX6S0Z','1958-01-01','House No 99/11, 10th Commercia','Street, Phase IV, DHA,','','Karachi.','','','','','zainuddinshakir@gmail.com','Zainuddin','020-OJ-172680','2000-07-01','3929308-4','','','','','S/o. M. Ismail ','','2000-07-01','','794','','0','','','','Shaikh Zainuddin ','Ismail  ','','','','','','TRUE','3','','35','0','','4','Zainuddin Mulla Ismail','100099041','2008-07-01','','Teacher',3),('128','Mazahir ','Hatim','Godhrawala','0','Male','502-65-034623','','42101-8395006-5','MB2P5V','1965-09-06','Flat No 1, Qasr-e-Walibhai,','Block E, Al-Burhan Compound,','North Nazimabad','Karachi','','','','','','Mazahir','020-OE-165646','2000-07-01','1044283-9','','','','','S/o. Hatim bhai','','1996-01-01','','363','','10004','','','','Mazahir ','Hatim','','','','','','TRUE','3','','44','0','','7','Mazahir Hatim','100096441','2008-07-09','','Assistant Administrator',3),('128','Mazahir ','Hatim','Godhrawala','0','Male','502-65-034623','','42101-8395006-5','MB2P5V','1965-09-06','Flat No 1, Qasr-e-Walibhai,','Block E, Al-Burhan Compound,','North Nazimabad','Karachi','','','','','','Mazahir','020-OE-165646','2000-07-01','1044283-9','','','','','S/o. Hatim bhai','','1996-01-01','','363','','10004','','','','Mazahir ','Hatim','','','','','','TRUE','3','','41','0','','7','Mazahir Hatim Bhai','1000 96441','2000-07-01','','Computer Programmer',3),('132','Safdar Khan','Khaiber Khan','.','0','Male','107-06-112386','','42101-4410425-7','K1712R','1968-01-01','C/o. Al-Jameatus Saifiyah,','ST -8 Block C North Nazimabad','Haidery ','Karachi.','','','','','','Sadbar Khan','020-OG-141420','1986-01-01','','','','','','Khaiber ','','1996-01-07','','611','','','','','','Safdar Khan','Khaiber Khan','','','','','','FALSE','3','','41','0','','7','Sadbar Khan','1200 03473','1986-09-01','','Peon Second Floor',3),('133','Mohammad Aman ','Khan','.','0','Male','443-90-028714','','42101-7935431-3','IG249F','1971-01-01','Al Jamea tus Saifiyah','St-3 Block C North Nazimabad','Haidery ','Karachi.','','','','','','Mohammad Aman','0200D262350','2004-11-01','','','','','DHP\nAppointed as chowkidar at D-20/C. Refered by Sh. Taherali Ramakdawala. EOBI deducted from Nov 2004. Salary Rs 4000.','Khan ','','2004-11-01','','2376','','','','Y','261','Mohammad Amin ','Haji Khan','','','','','','FALSE','3','','7','0','','7','Mohammad Aman Khan','105092','2004-11-01','','Chowkidar',3),('139','Shujauddin ','Ghulam Abbas','Barwaniwala','0','Male','505-86-230451','','42101-1630763-9','KOX9G3','1951-01-01','House No 121, Block E, Haidery','Barkat-e-Haidery,','North Nazimabad','Karachi','','','','','','Shujauddin','020-OG-165709','2000-11-01','','','','','','Ghulam Abbas ','','2000-03-16','','677','','','','','','Shujauddin ','Ghulam Abbas','','','','','','FALSE','3','','41','0','','7','Shujauddin Ghulam Abbas','567446','2000-11-01','','Peon Tanzeem Office',3),('140','Mohammad Yousuf ','Abdul Haleem ','.','0','Male','503-65-013617','','42401-4797705-3','JK1Q4D','1965-01-01','House No 1018, Islamia ','Qasba Colony, Near Mustafa ','Masjid, Manghopir Road, Orangi','Karachi','','','','','','Mohammad Yousuf ','020-OD-141423','1986-01-01','','','','','','Abdul Haleem ','','1991-01-11','','412','','','','','','Mohammad Yousuf ','Abdul Haleem ','','','','','','FALSE','3','','42','0','','7','Mohammad Yousuf Abdul Haleem','1200 02272','1986-09-01','','Carpenter',3),('142','Enayat Hussain ','Tahir Ali ','Shahjahanpurwala','0','Male','513-48-032330','','42301-0857271-3','LQ3372','1948-01-01','Flat No 30, Gali Fazal Mohamad','Bander Road, ','','Karachi','','','','','','Enayat Hussain','020-OH-165651','2000-07-01','','','','','','Tahir Ali .','','1997-01-09','','161','','','','','','Enayat Hussain ','Tahir Ali ','','','','','','FALSE','3','','41','0','','7','Enayat Hussain Taherali','1200 02396','2000-07-01','','Helper',3),('143','Mohammad Rashid','Haq Nawaz','.','0','Male','502-91-364239','','31202-5213925-9','EL2R1T','1978-01-01','Al Jamea tus Saifyah','St-3 Block C North Nazimabad','Haidery ','Karachi.','','','','','','Mohammad Rashid','020-OG-165652','2000-07-01','','','','','','Haq Nawaz','','1997-01-05','','840','','','','','','Rashid Rasheed ','Haq Nawaz','','','','','','TRUE','3','','42','0','','7','Mohammad Rasheed Haq Nawaz','1200 03317','2000-07-01','','Plumber',3),('145','Mohammad Ayub ','Akbar Shah','.','0','Male','156-78-035232','','42000-0474464-3','O6W9OR','1975-01-01','House No K-14-34-S-22, ','6 Mirza Adam Khan Road, ','Gulishtan,','Karachi','','','','','','Mohammad Ayub Shah','020-OA-141426','1986-01-01','3986961-0','','','','','Akbar Shah','','1998-11-09','','838','','','','','','Mohammad Ayub ','Akbar Shah','','','','','','TRUE','3','','42','0','','7','Mohammad Ayub Shah','1200 03341','1986-09-01','','Electrician',3),('147','Huzefa Hussain ','Ismail','.','0','Male','502-79-880941','','42101-1611063-7','M4K4DM','1979-10-10','House No D-108, Block G,','Nagina Square, Haidery ','North Nazimabad','Karachi','','6678077','','','','Huzefa Ismail','020-OF-165661','2000-07-01','','','','','','Ismail Jivajee','','1997-08-01','','268','','','','','','Huzefa Hussain ','Ismail','','','','','','TRUE','3','','43','0','','7','Huzefa Ismail','1200 02345','2000-07-01','','Liabrarian',3),('150','Rashida','Shaikh Mustafa Hassan Ali','Rasheed','0','Female','502-61-822987','','42000-0357664-6','L219BR','1961-11-21','Flat No 105 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery ','Karachi','','','','','','Rashida Mustafa','020-OI-078667','2000-07-01','','','','','','Mustafa ','','2000-07-01','','583','','','','','','Rashida','Shaikh Mustafa Hassan Ali','','','','','','FALSE','3','','53','0','','7','Rashida Mustafa','208210','2004-06-01','','Teacher',3),('150','Rashida','Shaikh Mustafa Hassan Ali','Rasheed','0','Female','502-61-822987','','42000-0357664-6','L219BR','1961-11-21','Flat No 105 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery ','Karachi','','','','','','Rashida Mustafa','020-OI-078667','2000-07-01','','','','','','Mustafa ','','2000-07-01','','583','','','','','','Rashida','Shaikh Mustafa Hassan Ali','','','','','','FALSE','3','','61','0','','7','Rashida Mustafa','208210','2000-07-01','','Teacher',3),('152','Banoo','Yunus','Bhinderwala','0','Female','502-60-735705','.','42101-1527107-2','MN642F','1960-07-01','Flat No A-91 Nagina Square','Block G North Nazimabad','Haidery ','Karachi.','','','','','','Banoo ','020-OE-078661','2000-07-01','3724887-1','','','','','Yunus ','','2000-07-01','','102','','0','','','','Banoo','Yunus','','','','','','TRUE','3','','53','0','','7','Bano Yunus','1001 03480','2000-07-01','','Teacher',3),('152','Banoo','Yunus','Bhinderwala','0','Female','502-60-735705','.','42101-1527107-2','MN642F','1960-07-01','Flat No A-91 Nagina Square','Block G North Nazimabad','Haidery ','Karachi.','','','','','','Banoo ','020-OE-078661','2000-07-01','3724887-1','','','','','Yunus ','','2000-07-01','','102','','0','','','','Banoo','Yunus','','','','','','TRUE','3','','61','0','','7','Bano Yunus','1001 03480','2007-07-01','','',3),('157','Qeemat Shah','Qalander Shah','.','0','Male','123-63-596661','','42401-5964364-7','MK6K8P','1963-01-01','C-26, Near New Haji Camp, ','Sultanabad, M.T. Khan Road,','','Karachi.','','','','','','Qeemat Shah','020-OJ-165659','2000-07-01','','','','','','Qalander Shah','','2000-07-01','','558','','','','','','Qeemat Shah','Qalander Shah','','','','','','FALSE','3','','46','0','','7','Qeemat Shah','1200 05395','2000-07-01','','Chowkidar D.Sakinat',3),('158','Gul Rawan Khan','Alam Gul Khan','.','0','Male','511-52-083766','','42301-4706859-5','LM8091','1952-01-01','Near New Haji Camp, House No ','C-240, Sultanabad, M.T. Khan ','Road,','Karachi.','','','','','','Gul Rawan Khan','020-OB-172654','2000-07-01','','','','','','Alam Gul Khan','','2000-07-01','','223','','','','','','Gul Rawan Khan','Alam Gul Khan','','','','','','FALSE','3','','46','0','','7','Gul Rawan Khan','1200 05409','2000-07-01','','Chowkidar C Block C.',3),('160','Mariam  ','Mohammad ','Zakiuddin','0','Female','515-42-135296','','42301-9947240-2','O9J3XR','1942-01-01','House No C-11, Block C, ','Haidery, ','North Nazimabad','Karachi','','','','','','Mariam Zakiuddin','020-OD-165639','2000-06-01','','','','','','Mohammad Zakiuddin','','2000-06-01','','356','','','','','','Mariam  ','Mohammad ','','','','','','FALSE','3','','53','0','','18','Maryam Zakiuddin','01-6563406-01','2000-06-01','','Teacher',3),('160','Mariam  ','Mohammad ','Zakiuddin','0','Female','515-42-135296','','42301-9947240-2','O9J3XR','1942-01-01','House No C-11, Block C, ','Haidery, ','North Nazimabad','Karachi','','','','','','Mariam Zakiuddin','020-OD-165639','2000-06-01','','','','','','Mohammad Zakiuddin','','2000-06-01','','356','','','','','','Mariam  ','Mohammad ','','','','','','FALSE','3','','46','0','','7','Maryam Zakiuddin','1000 94988','2000-06-01','','Warden',3),('161','Durriyah ','Taher Ali','Sehorewala','0','Female','513-47-053997','','42101-1489903-6','K9N58F','1947-01-01','House No B-19, Block E','Aminabad Apartment ,','North Nazimabad, Haidery ','Karachi.','','','','','','Durriyah Taher Ali','020-OH-165716','2000-11-01','','','','','','Taher Ali','','2000-11-01','','153','','0','','','','Durriyah ','Taher Ali','','','','','','FALSE','3','','41','0','','7','Durriyah Taher Ali','100094937','2016-01-01','','Kidmatguzar ',3),('165','Nafisa ','Valije  ','Nek','0','Female','515-58-084053','','42101-4468180-6','K3S97L','1958-01-01','9 Mustafa Manzil','Syedna Mohammad Burhanuddin','Road, Saddar,','Karachi','','','','','','Nafisa Nek','020-OF-165700','2000-08-01','','','','','','Valije Nek.','','2000-08-01','','481','','','','','','Nafisa ','Valije  ','','','','','','FALSE','3','','46','0','','7','Nafisa Nek Waliji Nek','1001 06145','2000-08-01','','Warden',3),('175','Gulshan','Mohammad Ali  ','Motiwala','0','Female','502-38-032154','','','','1938-07-17','C-67 Block C','Haidery  ','North Nazimabad','Karachi','','','','','','Gulshan Motiwala','Above Age','','','','','','','Mohammad Ali Motiwala .','','','31-Dec-05','225','','','','','','Gulshan','Mohammad Ali  ','','','','','','FALSE','3','','52','0','','7','Gulshan Motiwala','1000 94902','2003-09-01','','Teacher',3),('175','Gulshan','Mohammad Ali  ','Motiwala','0','Female','502-38-032154','','','','1938-07-17','C-67 Block C','Haidery  ','North Nazimabad','Karachi','','','','','','Gulshan Motiwala','Above Age','','','','','','','Mohammad Ali Motiwala .','','','31-Dec-05','225','','','','','','Gulshan','Mohammad Ali  ','','','','','','FALSE','3','','57','0','','7','','','2002-06-01','','Teacher',3),('176','Saifuddin ','Ahmed Ali','Jamnagarwala','0','Male','508-86-049448','','42101-6270282-7','MD1F90','1966-08-03','House No A-312, Block C,','Haidery, North Nazimabad,','','Karachi','','','','','','Saifuddin','020-OJ-165722','2000-11-01','','','','','','Ahmed Ali ','','2000-11-01','','624','','','','','','Saifuddin ','Ahmed Ali','','','','','','FALSE','3','','61','0','','7','Saifuddin Ahmed Ali','1000 95038','2000-11-01','','Teacher',3),('182','Dr Sohail ','Hussain Ali ','Rangwala','0','Male','502-86-004317','','42101-0793911-1','I0K4FT','1960-08-29','C-87 Block C','Haidery ','North Nazimabad','Karachi','','','','','','Sohail Rangwala','020-OE-165701','2000-08-01','','','','','','Hussain Ali ','','2000-08-01','','149','','10005','','','','Dr Sohail ','Hussain Ali ','','','','','','FALSE','3','','49','0','','7','Sohail Rangwala Hussain Ali','1000 95135','2000-08-01','','Doctor',3),('184','Nafisa ','Late Fakhruddin ','Ujjainwala','0','Female','502-50-004658','','42101-2952365-8','LV5R50','1950-01-01','Flat No C-125, Al-Burhan Bldg,','Burhani Bagh, Haidery, ','North Nazimabad','Karachi','','','','','','Nafisa Fakhruddin Ujjainwala','020-OH-165724','2000-11-01','','','','','','Fakhruddin .','','1999-07-01','','476','','','','','','Nafisa ','Late Fakhruddin ','','','','','','FALSE','3','','49','0','','7','Nafisa Fakhruddin','1200 02426','2000-11-01','','Compounder',3),('186','Mulla Moiz Ali','Mohammad Ali','Sidhpurwala','0','Male','502-89-592345','','42101-1381224-9','OP042X','1958-01-01','E-26 Block E ','Haidery ','North Nazimabad','Karachi','','6670864','','','','Moiz Ali','020-OC-165698','2000-08-01','','','','','','Mohammad Ali ','','1994-10-12','','421','','','','','','Moiz ','Mohammad Ali','','','','','','FALSE','3','','66','0','','7','Moiz Ali Mohammad Ali','120002302','2000-07-01','','Incharge Auditorium ',3),('191','Shirin','Shaikh Juzer Qurbanhusain','Adeeb','0','Female','518-85-384521','','42101-1484129-6','MV6817','1960-01-01','Flat No 004 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery','Karachi.','','','','','','Shirin Juzer Adeeb','','2001-09-01','','','','','','Juzer Shaikh Qurban Hussain ','','2001-09-01','','674','','','','','','Shirin','Shaikh Juzer Qurbanhusain','','','','','','FALSE','3','','53','0','','7','Shireen Juzer','100091725','2001-09-01','','Teacher',3),('192','Nafisa ','Shaikh Ismail ','.','0','Female','502-46-179431','','42101-1483291-8','K8623K','1946-01-01','Flat No 201 Najmi Manzil ','Husami Masjid Block C','North Nazimabad Haidery ','Karachi','','','','','','Nafisa',' ','','','','','','','Shaikh Ismail ','','2001-09-01','','479','','','','','','Nafisa ','Shaikh Ismail ','','','','','','FALSE','3','','53','0','','7','Nafisa Sh. Ismail','1000 91962','2001-09-01','','Teacher',3),('192','Nafisa ','Shaikh Ismail ','.','0','Female','502-46-179431','','42101-1483291-8','K8623K','1946-01-01','Flat No 201 Najmi Manzil ','Husami Masjid Block C','North Nazimabad Haidery ','Karachi','','','','','','Nafisa',' ','','','','','','','Shaikh Ismail ','','2001-09-01','','479','','','','','','Nafisa ','Shaikh Ismail ','','','','','','FALSE','3','','61','0',' ','7','Nafisa Sh. Ismail','100091962','2001-09-01','','Teacher',3),('194','Mehtab Banoo','Mannan Hatim ','.','0','Female','502-85-676542','','','','1963-06-01','E-25 Block E ','Haidery Memorial market','North Nazimabad ','Karachi','','','','','','Mehtab Banoo',' ','2001-09-01','','','','','','Mannan Hatim Ali','','2001-09-01','31-Dec-05','368','','','','','','Mehtab Banoo','Mannan Hatim ','','','','','','FALSE','3','','53','0','','0','','','2001-09-01','','Teacher',3),('197','Tasneem ','Shaikh Mustaali','Beawarwala','0','Female','502-85-670806','','42101-1546357-8','O9T3W9','1964-02-18','A-193/C, Block C,','Haidery ','North Nazimabad ','Karachi','','','','','','Tasneem Mustaali','020-OF-172692','2001-09-01','','','','','','Mustaali ','','2001-09-01','','721','','','','','','Tasneem ','Mustaali','','','','','','FALSE','3','','61','0','','7','Tasneem Mustaali','1001 12870','2001-09-01','','',3),('197','Tasneem ','Shaikh Mustaali','Beawarwala','0','Female','502-85-670806','','42101-1546357-8','O9T3W9','1964-02-18','A-193/C, Block C,','Haidery ','North Nazimabad ','Karachi','','','','','','Tasneem Mustaali','020-OF-172692','2001-09-01','','','','','','Mustaali ','','2001-09-01','','721','','','','','','Tasneem ','Mustaali','','','','','','FALSE','3','','53','0','','7','Tasneem Mustaqali','1001 12870','2001-09-01','','Teacher',3),('198','Azra Nadeem','Nadeem Taher ','Moochala','0','Female','513-89-066267','','42301-0772936-2','IP3Z6G','1970-01-01','House No 16, Al-Qayum Building','Mansfield Street, Saddar,','','Karachi','','','','','','Azra Nadeem','0200G295902','2001-09-01','','','','','','Nadeem Taher Moochala','','2002-04-01','','99','','','','','','Azra','Nooruddin ','','','','','','FALSE','3','','61','0','','7','Azra Nadeem','184206','2002-04-01','','Teacher',3),('198','Azra Nadeem','Nadeem Taher ','Moochala','0','Female','513-89-066267','','42301-0772936-2','IP3Z6G','1970-01-01','House No 16, Al-Qayum Building','Mansfield Street, Saddar,','','Karachi','','','','','','Azra Nadeem','0200G295902','2001-09-01','','','','','','Nadeem Taher Moochala','','2002-04-01','','99','','','','','','Azra','Nooruddin ','','','','','','FALSE','3','','53','0','','7','Azra Nadeem','184206','2002-04-01','','Teacher',3),('199','Jumana','Mohammad','.','0','Female','515-56-027890','','42101-5467666-8','','1956-12-17','House No 38, Mustafa Market,','Haidery, Block H,','North Nazimabad,','Karachi','','','','','','Jumana Mohammad bhai',' ','2001-09-01','','','','','','Mohammad  bhai Hussain bhai','','2001-09-01','','305','','','','','','Jumana','Mohammad','','','','','','FALSE','3','','53','0','','7','Jumana Mohammad','185269','2001-09-01','','Teacher',3),('199','Jumana','Mohammad','.','0','Female','515-56-027890','','42101-5467666-8','','1956-12-17','House No 38, Mustafa Market,','Haidery, Block H,','North Nazimabad,','Karachi','','','','','','Jumana Mohammad bhai',' ','2001-09-01','','','','','','Mohammad  bhai Hussain bhai','','2001-09-01','','305','','','','','','Jumana','Mohammad','','','','','','FALSE','3','','61','0','','7','Jumana Mohammad','185269','2001-09-01','','Teacher',3),('200','Farida ','Shaikh Tayab ','Jamali','0','Female','508-68-404077','','42101-1780364-6','J1R1W9','1968-01-01','Flat No 301 Yousufi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery ','Karachi.','','','','','','Farida Tayab','0200F295903','2001-09-01','','','','','','Tayab Tahir','','2001-09-01','','187','','','','','','Farida ','Shaikh Tayab ','','','','','','FALSE','3','','61','0','','7','Farida Tayeb','100092349','2001-09-01','','Teacher',3),('200','Farida ','Shaikh Tayab ','Jamali','0','Female','508-68-404077','','42101-1780364-6','J1R1W9','1968-01-01','Flat No 301 Yousufi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery ','Karachi.','','','','','','Farida Tayab','0200F295903','2001-09-01','','','','','','Tayab Tahir','','2001-09-01','','187','','','','','','Farida ','Shaikh Tayab ','','','','','','FALSE','3','','53','0','','7','Farida Tayeb','594028','2001-09-01','','Teacher',3),('203','Mulla Zohair ','Abbas','Haidermota','0','Male','515-68-098105','','','','1968-01-01','3rd floor Al Hamra ','apartment Block E Haidery','North Nazimabad ','Karachi','','','','','','Mulla Zohair','Left','2001-09-01','','','','','','Abbas Haidermota ','','2001-09-01','30-Jun-05','803','','','','','','Mulla Zohair ','Abbas','','','','','','FALSE','3','','54','0','','7','Zohair Abbas','1000 95968','2001-09-01','','Teacher',3),('204','Munira ','Zohair Hussain','.','0','Female','515-68-293892','','42101-1770526-0','','1969-07-06','Flat No 12 3rd floor ','Al Hamra Plaza Block E','North Nazimbad ','Karachi','','','','','','Munira','020-OA-165658','2000-07-01','','','','','','Zoher Hussain','','2000-07-01','','5682','','','','','','Munira ','Zohair Hussain','','','','','','FALSE','3','','61','0','','7','Munira Zohair','243935','2000-07-01','','Teacher',3),('206','Mulla Abbas Ali','Mohammad Hussain ','Hakimi','0','Male','508-65-123082','','42101-8044793-5','L2164Y','1965-11-20','House No A-489, Block C,','Haidery','North Nazimabad','Karachi','','','','','','Abbas Ali ','Temporary','2002-06-01','','','','','','Mohammad Hussain','','2002-06-01','','10','','','','','','Mulla Abbas ','Mohammad Hussain ','','','','','','FALSE','3','','67','0','','0','','','2002-06-01','','Teacher',3),('206','Mulla Abbas Ali','Mohammad Hussain ','Hakimi','0','Male','508-65-123082','','42101-8044793-5','L2164Y','1965-11-20','House No A-489, Block C,','Haidery','North Nazimabad','Karachi','','','','','','Abbas Ali ','Temporary','2002-06-01','','','','','','Mohammad Hussain','','2002-06-01','','10','','','','','','Mulla Abbas ','Mohammad Hussain ','','','','','','FALSE','3','','53','0','','0','','','2002-06-01','','Teacher',3),('207','Umme Aimen','Ibrahim','Shehabi','0','Female','502-73-815003','','42000-0357742-2','M5L69C','1973-01-01','Flat No 204 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery ','Karachi.','','','','','usjamea@gmail.com','Umme Aimen','020-OH-172682','2000-07-01','','','','','','W/o. Ibrahim Shehabi','','2000-07-01','','749','0','0','','','','Umme Aimen','Ibrahim','','','','','','TRUE','3','','32','5','','5','Ummeaiman Ibrahim Shehabi','1000 97960','2000-07-01','','Teacher',3),('207','Umme Aimen','Ibrahim','Shehabi','0','Female','502-73-815003','','42000-0357742-2','M5L69C','1973-01-01','Flat No 204 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery ','Karachi.','','','','','usjamea@gmail.com','Umme Aimen','020-OH-172682','2000-07-01','','','','','','W/o. Ibrahim Shehabi','','2000-07-01','','749','0','0','','','','Umme Aimen','Ibrahim','','','','','','TRUE','3','','35','0','','4','Umme Aimen Ibrahim Shehabi','100097960','2005-03-01','','Teacher',3),('214','Nafisa','Muder ','Hyderabadwala','0','Female','502-74-856657','','42101-1654738-8','JJ2B01','1974-01-01','E-35 Block E','Haidery Memorial Market ','North Nazimabad','Karachi','','','','','','Nafisa','','2002-06-01','','','','','','Muder .','','2002-06-01','','478','','','','','','Nafisa','Muder ','','','','','','FALSE','3','','53','0','','7','Nafisa Muder','184213','2002-06-01','','Teacher',3),('215','Munira ','Shaikh Shabbir','Khambatwala','0','Female','502-85-682622','','42000-0418155-4','IT4283','1968-09-16','House No G-229, Block E,','Al-Burhan Arcade, Haidery,','North Nazimabad','Karachi','','','','','','Munira Shabbir ','','','','','','','','Shabbir Najib','','','','440','','','','','','Munira ','Shaikh Shabbir','','','','','','FALSE','3','','53','0','','7','Munira Shabbir Khambati','186153','2002-04-01','','Teacher',3),('216','Farida','Khurshid Ali  ','Haidery','0','Female','513-87-105160','','42301-0889495-2','','1955-03-16','Amina Mansion','22/23 Belasis Street','Arambagh','Karachi','','','','','','Farida','','2002-05-01','','','','','','Khurshid Ali Haidery .','','2002-05-01','','183','','','','','','Farida','Khurshid Ali  ','','','','','','FALSE','3','','61','0','','7','Farida Khusheed Ali ','857768','2016-08-01','','Teacher',3),('220','Shaikh Tayeb Ali','Ghulam Abbas','Quettawala','0','Male','515-85-025909','','37405-3898599-9','9P6195','1958-10-24','Adam Masjid,','Opposite City Court,','Syedna Taher Saifuddin Road','Karachi','','','','','adamasjidpakamil@alvazarat.org','Mulla Tayeb Ali ','0200H306786','2014-06-01','2613167-6','1','','','Appointed as Aamil Saheb Taliyar (South Africa). Last wazifa paid to him till J.Akhar 1424. Also 2 months arrears paid to him. Appointed as Aamil Ebrahim Mohallah from 12/03/1425.Transfer to Hyderabad from Shaban 1435.','S/o. Ghulam Abbas ','4','2000-11-01','','724','2219','16','Income Tax Rs 2,219 for the year 2008 from July 2007 to June 2008 and from Rajab 1428 to Jamadil Akhar 1429 has been deducted in July 2007.','','','Mulla Tayeb Ali','Ghulam Abbas','20','2007-07-20','2920','IT20070720-0250-0000020','2007-07-01','TRUE','1','','16','2','','21','Mr. Tayab Ali Ghulam Abbas','104933','2014-06-01','','Aamil Badri Mohallah Hyderabad',4),('224','Syed Waqif Shah','Syed Akber Shah','.','0','Male','502-93-251320','','42201-4540004-7','kc851k','1973-01-01','Flat No F-76/B, Chawla Flat,','Dhoobipara, ','New Town,','Karachi','','','','','','Syed Waqif Shah','020-OC-078671','2000-08-01','','','','Reappointed as a gardner in Najmi and Yousufi Manzil. Salary in Najmi Rs 2,000 and salary in Yousufi is Rs 2,000. Referred by Shaikh Essa bhai. He is in place of Mohib Ali.','','Syed Akber Shah .','','2010-08-01','','1521','','','','','','Waqif Shah','Syed Akber Shah','','','','','','FALSE','3','','99','0','','7','Syed Waqif Shah','201705','2016-01-01','','Gardner Khaimat',3),('230','Shaikh Qusai ','Shaikh Abdul Qadir','Dewan','0','Male','515-79-317471','','42301-0982233-7','N71P6Y','1979-09-08','303 Al Saddar ','Building Biichjee Street','Mansfield Street Saddar','Karachi','','','','','qusai4u@gmail.com','Qusai Diwan','020-OI-165731','2000-11-01','3737477-0','1','','','','Abdul Qadir Diwan','','2000-11-01','','563','','353','','','','Mulla Qusai ','Shaikh Abdul Qadir','','','','IT20071010-0250-0000018','2007-09-01','TRUE','3','','36','0','','4','Qusai Diwan','1200 04313','2006-07-01','','Teacher',3),('235','Murtaza','Shabbir Hussain ','Jessorwala','0','Male','502-82-730376','','42101-1374390-1','O03D69','1982-03-06','Room No 6 Qasr-e-Haidery','Block C Haidery ','North Nazimabad','Karachi','','','','','','Murtaza','020-OJ-165714','2000-11-01','','','','','','Shabbir Hussain .','','2000-05-03','','448','','','','','','Murtaza','Shabbir Hussain ','','','','','','FALSE','3','','43','0','','7','Murtaza Shabbir Hussain','1200 04429','2000-11-01','','Liabrarian',3),('237','Mustafa ','Khan Ali ','.','0','Male','502-80-973074','','42101-1365406-5','L914VV','1980-12-26','House No D-81, Haidery,','Nagina Square Block G','North Nazimabad','Karachi','','','','','','Mustafa','020-OD-165728','2000-11-01','','','','','','Khan Ali .','','2000-11-11','','459','','','','','','Mustafa ','Khan Ali ','','','','','','TRUE','3','','41','0','','7','Mustafa Khanali','1200 02477','2000-11-01','','Accountant',3),('243','Habib Razzak','Ali Sher','.','0','Male','123-86-641504','','13504-2253046-9','V824C5','1965-01-01','Burhani Mahal McIver road','Opp Cant Telephone ','Exchange','Karachi.','','','','','','Habib Razzak','020-OE-141406','1986-01-01','','','','','Habib on leave from 01/10/2003 to 31/10/2003 due to his son\'s death. He rejoined from 01/11/2003.He again on leave frm 1/6/05 & retrn till 3/8/05.He is again on leave for 2 months from 4/8/06to3/10/2006. Rejoined from 5/10/2006.Heisonleave from 13/01/08 f','Ali Sher ','','1990-01-01','31-May-17','230','','','','','','Habib Razzak','Ali Sher','','','','','','FALSE','1','','20','0','','12','Mr. Habib Razzaq Ali Sher','005402','1986-09-01','','Office Peon',4),('250','Farida  ','Qurban Hussain','Multanwala','0','Female','512-47-007542','','','','1947-01-01','Flat No 8 Asma Manzil ','Soldier Bazar No 1','','Karachi.','','','','','','Farida','Above Age','2003-02-01','','','','','','Qurban Hussain','','2003-02-01','31-Dec-05','185','','','','','','Farida  ','Qurban Hussain','','','','','','FALSE','3','','53','0','','0','','','2003-08-01','','Teacher',3),('256','Mulla  Murtaza','Mulla Turab Ali','Rozkarnawala','0','Male','515-81-308163','','42301-1124183-7','IS9Q75','1981-01-24','House No 5Turabali Roozanawala','Mainsion,Mir Karam Ali ','Talpur Rroad, Saddar','Karachi','','','','','rozan915@hotmail.com','Murtaza','020-OA-078681','','3990179-3','','','','','Turab Ali ','','2000-09-01','','976','','11','','','','Mulla  Murtaza','Mulla Turab Ali','','','','','','TRUE','3','','36','0','','4','Murtaza Turab Ali','120002337','2001-03-01','','Assataza',3),('257','Farida ','Faizullah','.','0','Female','502-54-128278','','','','1954-01-01','C-120. Block C, Barkat-e- ','Haidery, North Nazimabad','','Karachi','','','','','','Farida Faizullah','','2002-04-01','','','','','','Faizullah .','','2002-04-01','31-Dec-05','180','','','','','','Farida ','Faizullah','','','','','','FALSE','3','','52','0','','0','','','2002-04-01','','Teacher',3),('261','Sahebzada','Mutebar Khan','.','0','Male','107-78-408626','','42101-4647464-1','NJ1245','1978-01-01','Al Jamea tus Saifiyah','St-3 Block C North Nazimabad','Haidery','Karachi.','','','','','','Sahebzada','020-OJ-078682','2001-05-01','','','','','','Mutebar Khan ','','2001-05-04','','614','','','','','','Sahebzada','Mutebar Khan','','','','','','TRUE','3','','47','0','','7','Sahebzad Mutebar Khan','100113982','2001-05-01','','Cook',3),('262','Shabbir Hussain','Jaffar Bhai','Kokawala','0','Male','510-85-119260','','42301-0718301-9','L8949S','1949-10-16','Dawoodi Manzil ','Bottel Gali','Hassan Ali Lane ','Karachi','','','','','','Shabbir Hussain','020-OI-078683','2001-05-01','','','','','','Jaffar Bhai ','','2001-05-01','','655','','0','','','','Shabbir Hussain','Jaffar Bhai','','','','','','TRUE','3','','61','0','','7','Shabbir Hussain Jaffer Bhai','1200 04410','2001-05-01','','Teacher',3),('270','Tasneem Ali Asgher ','Ali Asgher ','Ajmerwala','0','Female','517-93-465143','','42201-3975781-6','M437PF','1972-08-19','268-B, Shabbirabad D, PECHS,','Amir Khusroo Road,','','Karachi','','','','','','Tasneem Ali Asgher','0200E295904853','2003-04-01','','','','','','Ali Asgher ','','2003-04-01','','1493','','','','','227','Tasneem Ali Asgher ','Ali Asgher ','','','','','','FALSE','3','','53','0','','0','','','2003-04-01','','Teacher',3),('271','Samina  ','Murtaza bhaisaheb','.','0','Female','502-88-714958','','42101-1653793-2','O07X7V','1963-11-08','Flat No 104 Najmi Manzil ','Husami Masjid Compound Block C','North Nazimabad Haidery','Karachi.','','','','','','Samina Murtaza','020-OA-175001','2002-08-01','','','','','','Murtaza Bhai','','2003-01-01','','639','','','','','','Samina  ','Murtaza bhaisaheb','','','','','','FALSE','3','','61','0','','7','Samina Murtaza','1200 09269','2003-01-01','','Teachers',3),('273','Moiz bhai','Abdul Hussain bhai','.','0','Male','502-47-236355','','42101-1365514-7','1241RN','1947-12-31','Badri Masjid, ','Near Islami Chowck,','Densohall, Marriott Road,','Karachi.','74000','7729820','','','','Moiz bhai Abdul Hussain bhaisaheb','020-OH-172690','2001-07-01','1377547-2','1','','','','S/o. Abdul Hussain ','','2001-07-01','31-Aug-13','422','1026','10009','Income Tax Rs 984 for the year 2007 from July 2006 to June 2007 has been deducted in July 2006.','T','','Moiz  bhai','Abdul Hussain bhaisaheb','1','2007-08-28','1864','IT20070829-0250-0000001','2007-07-01','FALSE','1','','22','0','','2','Mr. Moiz bhai Abdulhusain bhai','101343','2001-07-01','','Co Ordinator',4),('283','Sakina Taher','Taher Shaikh Ibrahim','Godhrawala','0','Female','508-41-101469','','','','1941-05-11','Faiz Husaini Mahal','North Napier road','','Karachi.','','','','','','Sakina Taher','Temporary','2001-09-01','','','','','','Taher Shaikh Ibrahim','','2001-09-01','31-Dec-05','','','','','','','Sakina Taher','Taher Shaikh Ibrahim','','','','','','FALSE','3','','53','0','','0','','','2001-09-01','','Teacher',3),('284','Alifiyah ','Shaikh Mansoor ','Khambatwala','0','Female','502-78-517904','','42101-1325040-4','','1978-05-30','House No. A/124','Block C','North Nazimabad','Karachi','','','','','','Alifiyah Najib','','2001-09-01','','','','','','Najib Haider Ali','','2001-09-01','','66','','','','','','Alifiyah ','Shaikh Mansoor ','','','','','','FALSE','3','','53','0','','7','Alifiyah','184207','2001-09-01','','Teacher',3),('285','Tahera ','Juzer ','Khambatwala','0','Female','502-66-655365','','','','1966-03-23','House No A/124 Block C','North Nazimabad','Haidery ','Karachi.','','','','','','Tahera Juzer Khambati','Temporary','2001-09-01','','','','','','Juzer Khambati','','2001-09-01','','708','','','','','','Tahera ','Juzer ','','','','','','FALSE','3','','53','0','','0','','','2001-09-01','','Teacher',3),('286','Ummehani','Abdul Kader  ','Diwan','0','Female','515-79-561083','','','','1979-06-10','Flat No 9 Burhani Bagh','Block E North Nazimabad','Haidery','Karachi.','','','','','','Ummehani','Temporary','2001-09-01','','','','','','Abdul Kader Diwan','','2001-09-01','31-Dec-05','750','','','','','','Ummehani','Abdul Kader  ','','','','','','FALSE','3','','53','0','','0','','','2001-09-01','','Teacher',3),('292','Mariam','Zoaibali','','0','Female','512-86-215023','','','','1953-01-01','01/23. Hasinabai Abdullah bhai','Building, Panmandi, Nanakwada,','','Karachi.','','','','','','Mariam bai ','Temporary','','','','','','','Zoaibali','','','31-Dec-05','357','','','','','','Mariam','Zoaibali','','','','','','FALSE','3','','53','0','','0','','','','','Teacher',3),('295','Shaikh Murtaza ','Shaikh  Abdul Hussain','Haryanawala','0','Male','516-93-290833','','42000-7565728-7','MK3864','1975-02-14','13th STreet, Khayaban-e-Sehar,','Phase VI, Defence Housing','Authority, Defence','Karachi','','','','','murtaza.a.harianawala@gmail.com','Murtaza Haryanawala','020-OJ-172664','2002-01-31','3723802-7','1','','','','S/o. Abdul Hussain Haryanawala','','2002-01-31','','449','419','341','Income Tax Rs 422 for the year 2008 from July 2007 to June 2008 & from Jamadil Akhir 1428 to Jamadil Awwal 1429 has been deducted in July 2007.','','','Murtaza','Abdul Hussain Haryanawala','11','2007-07-14','','IT20071010-0250-0000019','2007-07-01','TRUE','3','','35','0','','4','Murtaza Haryanawala Abdulhussa','593986','2002-01-31','','Teacher',3),('300','Mustansir bhai','Shabbir bhai','Hasani','0','Male','502-65-611968','','42101-4110022-3','K0T2WM','1965-01-01','Hussaini Mohallah, 10/1, ','Khayaban-e-Shehbaz, Phase VI,','P.D.O.H.A. ','Karachi','75500','35240504','','','786mustansir@gmail.com','Mustansir Hasani  ','020-OH-172666','2002-03-01','2365148-2','1','','','','S/o. Shabbir bhai','7','2002-03-01','31-May-15','940','7050','2002','Income Tax Rs 4,230 has been deducted from Jamadil Akhar 1425 to Jamadil Awwal 1426.Transfer to Mohammadi Mohallah Soldierbazar from J.Akhar 1430.','','','Mustansir bhai','Shabbir bhai','106','2004-07-27','2820','','2007-07-01','FALSE','1','','16','1','','21','Mr. Mustansir Shabbir','101802','2009-06-01','','Aamil Hussaini Mohallah Defence',4),('302','Mulla Aliasghar ','Hakimuddin','Samiwala','0','Male','502-79-908088','','42201-5219271-7','K7G9BX','1979-08-31','C-78. Block C, Haidery,','North Nazimabad, ','Haidery,','Karachi','74700','6630502','','','asamiwala52@gmail.com','Aliasghar Sami','020-OG-172667','2002-03-01','','','','','','Hakimuddin ','','2001-06-11','','896','','','','','','Aliasghar ','Hakimuddin','','','','','','TRUE','1','','17','0','','12','Mr. Aliasghar Sami','005395','2002-03-01','','Accountant',4),('306','Fehmida  ','Zoaib Hussain','.','0','Female','502-54-871656','','42101-1547116-2','O1679R','1954-01-01','Flat No B-S. Gulshan-e-Zubaida','Block E, Haidery, ','North Nazimabad','Karachi','74700','','','','','Fehmida ','Temporary','2002-04-01','','','','','','Zoaib Hussain','','2002-04-01','','196','','','','','','Fehmida  ','Zoaib Hussain','','','','','','FALSE','3','','61','0','','7','Fehmida Zoaib Hussain','193837','2002-04-01','','Teacher',3),('306','Fehmida  ','Zoaib Hussain','.','0','Female','502-54-871656','','42101-1547116-2','O1679R','1954-01-01','Flat No B-S. Gulshan-e-Zubaida','Block E, Haidery, ','North Nazimabad','Karachi','74700','','','','','Fehmida ','Temporary','2002-04-01','','','','','','Zoaib Hussain','','2002-04-01','','196','','','','','','Fehmida  ','Zoaib Hussain','','','','','','FALSE','3','','53','0','','7','Fehmida Zoaib Hussain','193837','2002-04-01','','Teacher',3),('308','Zohair','Ismail','Khambatwala','0','Male','502-85-000855','','','','1968-03-02','Room No 17. Qasr-e-Fakhruddin,','Barkat-e-Haidery,','North Nazimabad','Karachi','','','','','','Zohair','Left','2002-05-01','','','','','','Ismail','','2002-05-01','31-Dec-05','804','','','','','','Zohair','Ismail','','','','','','FALSE','3','','58','0','','0','','','2002-05-01','','Teacher',3),('310','Syed Aamir Iqbal','Syed Moinuddin','.','0','Male','515-94-206766','','','','1975-06-13','290/B. Mehmoodabad No 1.','Karachi.','','','','','','','','Syed Aamir Iqbal','','','','','','','','Syed Moinuddin','','2002-05-01','31-Dec-05','696','','','','','0','Syed Aamir Iqbal','Syed Moinuddin','','','','','','FALSE','3','','52','0','','0','','','2002-05-01','','Teacher',3),('311','Mulla Taizoon ','Shaikh Shoaib ','Haidery','0','Male','508-76-354630','','','','1976-02-11','2nd Floor, Rom No 209. Badri ','Building, Block E, Haidery','North Nazimabad, ','Karachi','','','','','','Taizoon Shoaib Haidery','020-OD-175016','2002-05-01','','','','','','Shoaib Ghulamhussain Haidery','','2002-05-01','31-Dec-05','713','','','','Y','234','Mulla Taizoon ','Shaikh Shoaib ','','','','','','FALSE','3','','52','0','','0','','','2002-05-01','','Teacher',3),('312','Rashida ','Najmuddin ','Mehsari','0','Female','513-86-073439','','','','1952-03-31','18. Mohammadi Terrace, Tayyab','jee Road, Haqqani Chowck, ','Garikhata, ','Karachi','','','','','','Rashida Najmuddin Mehsari','020-OE-175015','2002-05-01','','','','','','Najmuddin Mehsari','','2002-05-01','31-Dec-05','580','','','','Y','233','Rashida ','Najmuddin ','','','','','','FALSE','3','','52','0','','0','','','2002-05-01','','Teacher',3),('313','Raj Mohammad Shah','Syed Mohammad Shah','.','0','Male','123-78-763634','','42401-1742628-1','KL3P75','1978-12-01','House No D2/26, Moulvi ','Tamizuddin Khan Road, New','Haji Khan, Camp Sultan,','Karachi','','','','','raj1978pk@gmail.com','Raj Mohammad Shah','020-OE-172669','2002-04-01','','','','','His monthly savings increased from 01/09/2003 Rs 3,000 as discussed KY with Mohammad Shah, decided on 06/09/2003.He is going on 1 month leave for his marriage from 17/08/05 to 16/09/2005.','Syed Mohammad Shah','','2002-04-01','','574','','','','','','Raj Mohammad Shah','Syed Mohammad Shah','','','','','','FALSE','1','','17','0','','12','Mr. Raj Mohammad Shah','005398','2002-04-01','','Computer Programmer',4),('317','Zainab','Adnan','.','0','Female','512-80-283793','','42000-0423577-2','L7Y5QC','1980-01-26','House No C-104 Block C','North Nazimabad','Haidery','Karachi.','','','','','','Zainab Adnan','0200C334904','2016-12-01','','','','','','Adnan Zainuddin','','2002-06-01','','792','','','','','','Zainab','Ahsan Ali','','','','','','FALSE','3','','53','0','','7','Zainab Adnan','101915','2002-06-01','','Teacher',3),('317','Zainab','Adnan','.','0','Female','512-80-283793','','42000-0423577-2','L7Y5QC','1980-01-26','House No C-104 Block C','North Nazimabad','Haidery','Karachi.','','','','','','Zainab Adnan','0200C334904','2016-12-01','','','','','','Adnan Zainuddin','','2002-06-01','','792','','','','','','Zainab','Ahsan Ali','','','','','','FALSE','3','','61','0',' ','0','','','2002-06-01','','Teacher',3),('321','Tasneem ','Mustafa','Surty','0','Female','502-72-878781','','42000-0359703-6','O2J6V6','1972-09-06','House No 202, Block C, ','Najmi Manzil, Haidery,','North Nazimabad,','Karachi','','','','','','Tasneem Mustafa Bhai','020-OA-172671','2002-07-01','','','','','','Mustafa Jaffer bhai Surty','','2002-07-01','','849','','','','','','Tasneem ','Mustafa','','','','','','FALSE','3','','61','0','','7','Tasneem Mustafa Bhai','1200 09439','2002-07-01','','Teacher',3),('321','Tasneem ','Mustafa','Surty','0','Female','502-72-878781','','42000-0359703-6','O2J6V6','1972-09-06','House No 202, Block C, ','Najmi Manzil, Haidery,','North Nazimabad,','Karachi','','','','','','Tasneem Mustafa Bhai','020-OA-172671','2002-07-01','','','','','','Mustafa Jaffer bhai Surty','','2002-07-01','','849','','','','','','Tasneem ','Mustafa','','','','','','FALSE','3','','53','0','','7','Tasneem Mustafa Bhai','104526','2017-09-01','','Teacher',3),('322','Farida ','Shaikh Mustafa Fazalabbas','Mithaiwala','0','Female','502-67-836227','','42101-1487766-2','M448NG','1967-08-20','Yousufi Manzil, Block C, ST-8,','North Nazimabad,','','Karachi','','6671705','','','','Farida','0200D295905','2013-11-01','','','','','','Mustafa ','','2002-06-19','','977','','','','','','Farida ','Shaikh Mustafa Fazalabbas','','','','','','FALSE','3','','53','0','','7','Farida Mustafa','100113761','2002-06-19','','Teacher',3),('322','Farida ','Shaikh Mustafa Fazalabbas','Mithaiwala','0','Female','502-67-836227','','42101-1487766-2','M448NG','1967-08-20','Yousufi Manzil, Block C, ST-8,','North Nazimabad,','','Karachi','','6671705','','','','Farida','0200D295905','2013-11-01','','','','','','Mustafa ','','2002-06-19','','977','','','','','','Farida ','Shaikh Mustafa Fazalabbas','','','','','','FALSE','3','','133','0','','9','Farida Mustafa','102399','2017-09-01','','Teacher',3),('322','Farida ','Shaikh Mustafa Fazalabbas','Mithaiwala','0','Female','502-67-836227','','42101-1487766-2','M448NG','1967-08-20','Yousufi Manzil, Block C, ST-8,','North Nazimabad,','','Karachi','','6671705','','','','Farida','0200D295905','2013-11-01','','','','','','Mustafa ','','2002-06-19','','977','','','','','','Farida ','Shaikh Mustafa Fazalabbas','','','','','','FALSE','3','','61','0','','7','Farida Mustafa ','100113761','2002-06-19','','Teacher ',3),('323','Tasneem','Mushtaq Ali ','Tapal Wala','0','Female','518-61-526867','','42301-0802371-4','N6N4PS','1961-02-28','House No.10, Tapalwala Buildin','1st floor, Haqani chowck','','Karachi','','2620784','','','','Tasneem Tapal','0200C295906','2013-11-01','','','','','','Mushtaq Ali','','2002-06-19','','989','','','','','','Tasneem','Mushtaq Ali ','','','','','','FALSE','3','','53','0','','7','Tasneem Tapal ','185118','2002-06-19','','Teacher',3),('323','Tasneem','Mushtaq Ali ','Tapal Wala','0','Female','518-61-526867','','42301-0802371-4','N6N4PS','1961-02-28','House No.10, Tapalwala Buildin','1st floor, Haqani chowck','','Karachi','','2620784','','','','Tasneem Tapal','0200C295906','2013-11-01','','','','','','Mushtaq Ali','','2002-06-19','','989','','','','','','Tasneem','Mushtaq Ali ','','','','','','FALSE','3','','61','0','','7','Tasneem Tapal ','185118','2002-06-19','','Teacher',3),('326','Lubaina','Juzer Ali','Shahjahanpurwala','0','Female','512-75-310197','','42101-7688302-6','O45115','1975-09-07','Plot No Fl-8, Flat No A-10,','Al Saba Apartment, Haidery,','North Nazimabad,','Karachi','','','','','','Lubaina ','020-OJ-172698','2002-08-01','','','','','','Juzer Ali','','2002-08-01','','968','','','','','','Lubaina','Moiz Ali Hussaini','','','','','','FALSE','3','','61','0','','7','Lubaina Juzer Ali','1200 07797','2002-08-01','','Teacher',3),('328','Najmuddin','Ali Hussain','Ujjainwala','0','Male','502-89-002879','','42101-1372476-9','M817CT','1970-07-09','House No 10, Block G, ','Iqbal Market, Haidery,','North Nazimabad,','Karachi','','','','','','Najmuddin','020-OE-172677','2002-11-01','','','','','','Ali Hussain','','2002-11-01','','1044','0','','','','','Najmuddin','Ali Hussain','','','','','','FALSE','3','','47','0','','7','Najmuddin Ali Hussain','1200 06294','2002-11-01','','Asstt. Supervisor',3),('334','Sakina Hassanali','Hassanali','Dahoodwala','0','Female','502-86-694202','','42000-0357751-2','OF7QOP','1961-03-03','A-191, Block C, Haidery, ','North Nazimabad,','','Karachi','','6635156','','','','Sakina Hassanali','0200B295907','2003-01-01','','','Bachelor of Arts','Former Teacher in Saifee High School Bombay & childcare at Jamea.','She is studying in Jamea period basis @ Rs 75 per period.','Hassanali','','2003-01-01','','988','0','0','','','','Sakina Hassanali','Hassanali','','','','','','FALSE','3','','61','0','','7','Sakina Hassan Ali','184242','2003-01-01','','Teachers',3),('334','Sakina Hassanali','Hassanali','Dahoodwala','0','Female','502-86-694202','','42000-0357751-2','OF7QOP','1961-03-03','A-191, Block C, Haidery, ','North Nazimabad,','','Karachi','','6635156','','','','Sakina Hassanali','0200B295907','2003-01-01','','','Bachelor of Arts','Former Teacher in Saifee High School Bombay & childcare at Jamea.','She is studying in Jamea period basis @ Rs 75 per period.','Hassanali','','2003-01-01','','988','0','0','','','','Sakina Hassanali','Hassanali','','','','','','FALSE','3','','53','0','','7','Sakina Hassan Ali','184242','2003-04-01','','Teacher',3),('335','Maleka','Saifuddin','.','0','Female','502-92-796663','','42101-4868116-4','M25236','1968-11-12','Flat No A-18, Mustafa Apartmen','Near GPO, Haidery, North ','Nazimabad, ','Karachi','','6675395','','','','Maleka','020-OH-175004','2003-01-01','','','Bachelor of Arts','','Apointed as a Maths teacher in Jamea from 01/01/2003 @ Rs 75 per period basis.','Saifuddin','','2003-01-01','','1302','0','0','','','','Maleka','Saifuddin','','','','','','FALSE','3','','61','0','','18','Maleka Saifuddin','01-6562396-01','2003-01-01','','Teachers',3),('336','Mustafa','Mohammad Hussain','Patanwala','0','Male','513-68-038132','','42301-0768834-3','JW662W','1968-06-26','Flat No 6, Zulaikha Manzil,','Dawood Street, Pakistan Chowck','','Karachi','','2624741','0300-2170380','','','Mustafa Patanwala','020-OI-175003','2003-01-01','','','','','Appointed as teacher in Jamea of General Science from 01/01/2003 @ Rs 75 per period basis.','Mohammad Hussain Patanwala','','2003-01-01','31-Dec-05','1150','0','0','','','','Mustafa','Mohammad Hussain','','','','','','FALSE','3','','61','0','','7','Mustafa Mohammad Hussain','1200 05069','2003-01-01','','Teachers',3),('337','Fatema','Noman','Saraaf','0','Female','517-76-410459','','42101-1532922-0','KiF64R','1976-11-13','House No 31-D. Block E,','Aminabad Apartment, Haidery,','North Nazimabad,','Karachi','','6625730','','','','Fatema Noman','020-OG-175005','2003-01-01','','','','','Appointed as teacher in Jamea from 01/01/2003 @ Rs 75 per period basis.','Noman Mohammad Ali Saraaf','','2003-01-01','','1154','0','0','','','','Fatema','Noman','','','','','','FALSE','3','','61','0','','7','Fatema Nauman','1001 05041','2003-01-01','','Teachers',3),('338','Abbas Ali','Ismail','Kika bhai','0','Male','502-80-744377','','42101-1610677-1','O3468Q','1980-08-19','House No D-81, Al-Saba','Apartment, Barkat-e-Haidery,','Block E, North Nazimabad, ','Karachi','','6624213','','','','Abbas Ali','020-OF-175006','2003-01-01','','','','','Appointed as Teacher in Manahij Department @ Rs 75 per period basis salary.','Ismail Kika bhai','','2003-01-01','31-Dec-05','1311','0','0','','','','Abbas Ali','Ismail','','','','','','FALSE','3','','61','0','','7','Abbas Ali Ismail Kika Bhai','1200 09285','2003-01-01','','Teacher',3),('340','Mulla Mustafa','Shafaqat Hussain','.','0','Male','513-77-129749','','42301-0158028-9','M57G5W','1977-02-15','Room No 9, Irfan Manzil, ','Syedna Taher Saifuddin Road,','City Court, Bandar Road,','Karachi','','','','','shafq7@gmail.com','Mustafa','020-OB-171852','2003-03-03','3736630-7','1','Fare Sani from Jamea','','Paid wazifa from Zilqad 1423 @ Rs 6000 p.m.','Shafaqat Hussain','','2003-03-03','','1245','0','345','','','226','Mulla Mustafa','Shafaqat Hussain','','','','IT20071010-0250-0000022','2007-09-01','TRUE','3','','35','0','','4','Mustafa Shafqat Hussain','1200 06219','2003-03-03','','Teacher',3),('343','Shaikh Yousuf ','Mulla Ahmed Ali','Nadir','0','Male','513-48-033666','','42201-0785989-7','OY9W1S','1946-09-22','Bohra Masjid, Anjuman-e-Hamidi','Ghani Bukhari Road, ','','Multan','','7768133','','7774654','shayousuf53@gmail.com','Shaikh Yousuf Nadir','020-OI-175011','2003-03-04','0908836-9','','','','Appointed as Aamil Adam Masjid. Wazifa due from Moharram 1424.Farigh from Amalat from 01/06/2005. Rejoin from Shaban 1435 in Multan.','S/o. Mulla Ahmed Ali','18','2003-03-04','','1224','7050','22','Income Tax Rs 4,230 has been deducted from Jamadil Akhar 1425 to Jamadil Awwal 1426.','','221','Shaikh Yousuf ','Mulla Ahmed Ali','110','2004-07-27','2820','','2007-07-01','TRUE','3','','35','0','','4','Yousuf Nadir','530404','2016-06-01','','Asataza',3),('344','Zubaida ','Shabbir Hussain','.','0','Female','517-60-335558','','42201-0413217-2','KF3P32','1960-11-04','House No 133, Syedna Nooruddin','Road, Shabbirabad Block B,','','Karachi','','','','','','Zubaida Shabbir Hussain','020-OF-175014','2003-04-01','','','','','Referred by Mulla Asma Shaikh Qutubkhan Kothari. Her salary Rs 2,040 period basis. She is in Tadreeb-e-Manzeli Department.','Shabbir Hussain','','2003-04-01','','1466','0','0','','','224','Zubaida ','Shabbir Hussain','','','','','','FALSE','3','','53','0','','7','Zubaida Shabbir Hussain','187160','2003-04-01','','Teacher',3),('345','Sabit Khan','Ayaz','.','0','Male','123-56-599157','','13504-2242131-3','','1956-01-01','Burhani Mahal, McIver Road,','Opposite Cantt Telephone ','Exchange,','Karachi','','5685676','','5681418','','Sabit Khan','020-OJ-175010','2003-03-01','','','','','Recommended by Shaikh Kumail bhaisaheb. Brother of Ghulam Bahadur. Salary approved Rs 7,625. EOBI paid from March 2003. As driver appointed.','Ayaz','','2011-07-01','31-Jan-18','1480','0','0','','','220','Sabit Khan','Ayaz','','','','','','FALSE','1','','20','0','','10','Sabit Khan','101518','2016-08-01','','Driver',4),('347','Shahida Sakina','Ali Hussain','Bhinderwala','0','Female','502-72-864366','','42101-6968125-2','JV2L59','1972-01-01','Room No 21, Qasr-e-Kulsoom,','Barkat-e-Haidery, North','Nazimabad,','Karachi','','','','','','Shahida Sakina','0200C296164','2003-05-01','','','Intermediate','3 years experienced in teaching in Jameatus Saifiyah previously.','Appointed as Teacher of Tadreeb-e-Manzeli. Refered by Mulla Asma Sh. Qutubkhan. Salary Rs 1500 from 01/05/03. Rs 20 deducted EOBI from May 2003.','Ali Hussain','','2003-05-01','','1518','0','0','','','228','Shahida Sakina','Ali Hussain','','','','','','FALSE','3','','46','0','','7','Shahida Sakina','185038','2013-03-16','','Office Healper',3),('347','Shahida Sakina','Ali Hussain','Bhinderwala','0','Female','502-72-864366','','42101-6968125-2','JV2L59','1972-01-01','Room No 21, Qasr-e-Kulsoom,','Barkat-e-Haidery, North','Nazimabad,','Karachi','','','','','','Shahida Sakina','0200C296164','2003-05-01','','','Intermediate','3 years experienced in teaching in Jameatus Saifiyah previously.','Appointed as Teacher of Tadreeb-e-Manzeli. Refered by Mulla Asma Sh. Qutubkhan. Salary Rs 1500 from 01/05/03. Rs 20 deducted EOBI from May 2003.','Ali Hussain','','2003-05-01','','1518','0','0','','','228','Shahida Sakina','Ali Hussain','','','','','','FALSE','3','','53','0','','7','Shahida Sakina ','185038','2003-05-01','','Teacher',3),('348','Mubina Begum ','Syed Shah Nawaz','.','0','Female','501-52-426066','','','','1952-01-01','House No A-121, Block G,','Haidery, Nagina Square,','North Nazimabad,','Karachi','','','','','','Mubina Begum','020-OI-171855','2003-05-01','','','Intermediate','2 years teacheing experience in St. John High School','Refered by M. Asma Sh. Qutubkhan. Salary approved Rs 1,280 from 01/05/03. Rs 20 deducted as EOBI from May 2003.','Syed Shah Nawaz','','2003-05-01','31-Dec-05','1519','0','0','','','229','Mubina Begum ','Syed Shah Nawaz','','','','','','FALSE','3','','53','0','','0','','','2003-05-01','','Teacher',3),('350','Mohammad','Nooruddin','Godhrawala','0','Male','502-80-919581','','','','1980-05-20','Flat No 5, Burhani Bagh,','Block E, Haidery, North','Nazimabad,','Karachi','','','','','','Mohammad ','020-OB-175018','2003-06-01','','','B-Com','','Refered  by Shakh Quresh Saifuddin. Salary Rs 1,500 from 01/06/2003. Rs 20 EOBI deducted from 01/06/2003.','Nooruddin','','2003-06-01','31-Dec-05','0','0','0','','Y','236','Mohammad','Nooruddin','','','','','','FALSE','3','','52','0','','0','','','2003-06-01','','Teacher',3),('350','Mohammad','Nooruddin','Godhrawala','0','Male','502-80-919581','','','','1980-05-20','Flat No 5, Burhani Bagh,','Block E, Haidery, North','Nazimabad,','Karachi','','','','','','Mohammad ','020-OB-175018','2003-06-01','','','B-Com','','Refered  by Shakh Quresh Saifuddin. Salary Rs 1,500 from 01/06/2003. Rs 20 EOBI deducted from 01/06/2003.','Nooruddin','','2003-06-01','31-Dec-05','0','0','0','','Y','236','Mohammad','Nooruddin','','','','','','FALSE','3','','57','0','','0','','','2004-06-01','','Teacher',3),('351','Nafeesa','Mulla Huzefa','Madhwala','0','Female','','L1172169','','','1960-03-06','Flat No 304, Burhani Bagh, ','Block E, Haidery, North ','Nazimabad, Karachi','','','','','','','Nafeesa','Foreigner','2003-06-01','','','','Teacher at Yoland School of Speech & Drama in Srilanka','Appointed in Manahij Talimihay Department. Salary approved by Ilyas bhaisaheb @ Rs 75 per period basis for 2 months','Huzefa','','2003-06-01','31-Dec-05','0','0','0','','','0','Nafeesa','Mulla Huzefa','','','','','','FALSE','3','','61','0','','7','Nafeesa Huzefa','1200 09277','2003-06-01','','Teacher',3),('357','Shaikh Mufaddal','Yusufali','Zavery','0','Male','','A-0263348','834586-835747-1','','1980-05-25','C-32, Block C,','North Nazimabad,','','Karachi','','','','','mufaddalmoshi@gmail.com','Mufazal ','Foreigner','','3910019-7','','','','As per Manzoori appointed as Helper in Mahaduzahra Department for 2 years. Paid Rs 2,000 as Wazifa from August 2003.','Yusufali Zavery','','2003-08-01','','1678','0','5002','','','0','Mufazal','Yusufali Zavery','','','','','','TRUE','3','','37','0','','4','Mufaddal Yousufali Zavery','1200 09463','2008-06-01','','Teacher',3),('361','Sakina Ghazala','Shaikh Murtaza Akbarali','Africawala','1941','Female','502-51-615182','','42101-1653795-4','KW1D5M','1961-04-20','House No 302, Yousufi Manzil,','Block C, Haidery,','North Nazimabad','Karachi','','','','','','Ghazala ','','','','','','','Appointed as teacher in Tadbeer-e-Manzeli, Rs 1,600 salary. Refered by Mulla Asma Shaikh Qutubkhan. EOBI deducted from March 2004 Rs 20.','Murtaza Akbarali','','2004-03-01','31-Dec-05','0','0','0','','','0','','','','','','','','FALSE','3','','53','0','','0','Ghazala Murtaza Akbarali','','2004-03-01','','Teacher',3),('367','Shaikh Mustafa','Asgharali','Bharmal','0','Male','','','42101-1592970-7','IN2404','1979-06-29','Bohra Masjid,','Anjuman-e-Saifee,','Saddar,','Hyderabad','','6671343','0333-2324326','','','Mustafa Asgharali Bharmal','020-OA-183703','2004-05-01','2401610-1','1','','','Appointed as Muawin Aamil Hasani Masjid from Rajab 1424. Wazifa Rs 10,000. EOBI deducted  from Rajab 1424. Appointed as Moavin Aamil Hyderabd from J.Akhar 1431.','S/o. Asgharali Bharmal','27','2004-05-01','','1787','0','27','Income Tax Rs 1,958 for the year 2008 from July 2007 to June 2008 and from Rajab 1428 to Jamadil Akhar 1429 has been deducted in July 2007.','Y','245','Mustafa','Asgharali','0','2007-07-20','802','IT20070720-0250-0000021','2007-07-01','TRUE','1','','16','1','','21','Mr. Mustafa Asgherali Bharmal','104862','2017-04-01','','Aamil Saheb Adam Masjid City Court',4),('372','Fatema','Mulla Huzaifa','Motiwala','0','Female','','','42101-3255658-0','J229PQ','1982-03-09','House No B-139, Block C, ','Haidery, North Nazimabad,','','Karachi','','','','','','Fatema Motiwala','020-OE-183709','2004-07-01','','','','','Appointed as teacher Tadbeere Manzeli. Salary approved Rs 2,000 ','Huzaifa Shabbir Motiwala','','2004-04-01','31-Dec-05','0','0','0','','','0','','','','','','','','FALSE','3','','53','0','','0','','','2004-04-01','','Teacher',3),('372','Fatema','Mulla Huzaifa','Motiwala','0','Female','','','42101-3255658-0','J229PQ','1982-03-09','House No B-139, Block C, ','Haidery, North Nazimabad,','','Karachi','','','','','','Fatema Motiwala','020-OE-183709','2004-07-01','','','','','Appointed as teacher Tadbeere Manzeli. Salary approved Rs 2,000 ','Huzaifa Shabbir Motiwala','','2004-04-01','31-Dec-05','0','0','0','','','0','','','','','','','','FALSE','3','','61','0','','0','','','2004-07-01','','Teacher',3),('373','Abbas ','Feroze Haiderali','Quettawala','0','Male','','','42101-1615605-3','L42S3Z','1982-04-30','House No 5, Iqbal Market,','Block G, Haidery, ','North Nazimabad,','Karachi','','6627603','0300-2599152','','abbasfiroz@yahoo.com','Abbas Feroze','020-OG-183707','2004-05-17','','','','','Appointed as Accountant Al-Mawaedus Saifiyah. Salary Rs 4,500. EOBI deducted from June 2004. Referred by Muder bhaisaheb.','Feroze Haiderali','','2004-05-17','','2070','0','0','','Y','247','','','','','','','','FALSE','3','','47','0','','7','Abbas Feroze','1200 16559','2004-05-17','','Accountant ',3),('374','Rukshana','Hilal','.','0','Male','523-71-053408','','','','1971-01-01','Flat No B-14, Nagina Square, ','Nagina Square, Phase 2, Block ','G, North Nazimabad,','Karachi','','','','','','Rukshana','','2004-04-20','','','','','Appointed as Yoga Teacher in Rabwatjibla. Salary Rs 5,000. Refereed by Nematullah baisaheb. EOBI deducted Rs 20 from June 2004.','Hilal','','2004-04-20','31-Dec-05','2071','0','0','','','0','','','','','','','','FALSE','3','','53','0','','0','','','2004-04-20','','Yoga Teacher',3),('380','Tasneem','Yousuf','Ilaichee','0','Female','','E5713130','','','1979-08-04','C/o. Al-Jameatus Saifiyah','ST-4, Block C, Haidery,','North Nazimabad,','Karachi','','','','','','Tasneem Yousuf Hatim','Foreigner','','','','','','Appointed as teacher in Manahij Talimiyah Department. Salary as period basis @ Rs 65 per period. Refered by Shaikh Mustansir Rangoonwala. No EOBI deducted.','','','2004-03-01','31-Dec-05','2202','0','0','','','0','','','','','','','','FALSE','3','','61','0','','0','','','2004-03-01','','Teacher',3),('383','Riyaz Hussain Rajpur','Mohammad Ramzan','.','0','Male','443-81-086576','','42101-1797718-9','J2X4P7','1982-01-01','Goth Mohammad Hashim, ','Rajpur, Post Daryakhan Mori,','','Khairpur','','','','','','Riyaz Hussain Rajpur','020-OA-183711','2004-06-01','','','','','DHP\nEmployee at Yousufi Manzil. Refered by Shaikh Mustafa Fazalabbas. Appointed from 01/06/2004. EOBI deducted from July including arrear June 2004. Salary Rs 3,500.','Mohammad Ramzan','','2004-06-01','','2217','0','0','','Y','248','','','','','','','','FALSE','3','','112','0','','7','Riyaz Hussain Rajpur','120016125','2004-06-01','','Generator Operator',3),('391','Shaikh Murtaza ','Shaikh Abid Hussain','Saboowala','0','Male','','','42101-1775450-5','K8N491','1979-07-17','House No A-136, Block C,','Haidery',', North Nazimabad,','Karachi','','','','','murtazaabid@gmail.com','Murtaza','','','3725854-7','','','','Appointed as teacher from Zilqad 1424. EOBI deducted from Zilqad 1424. ','Abid Hussain','','2004-11-01','','2327','0','8008','','Y','273','Murtaza','Abid Hussain','0','','','IT20071010-0250-0000022','2007-09-01','TRUE','3','','35','0','','4','Murtaza Abid Hussain','1200 17253','2004-11-01','','Teacher',3),('395','Shaikh Khuzaima','Saifuddin','Rangwala','0','Male','','','42000-9307725-9','','1967-08-24','A-384, Block C, Haidery,,','','North Nazimabad','Karachi','','','','','rangwallakd@yahoo.com','Khuzaima Rangwala','020-OJ-202655','2004-11-01','3339279-0','1','','','Employee of Attalim. As per manzoori salary paid from Dawat. Salary Rs 13,700. EOBI deducted from January 2005.','Saifuddin Rangwala','','2004-11-01','','2196','456','5004','Income Tax Rs 456 for the year 2007 from July 2006 to June 2007 has been deducted in July 2006.','Y','255','Khuzaima Rangwala','Saifuddin Rangwala','1','2007-08-28','','IT20070829-0250-0000001','2007-07-01','TRUE','1','','22','0','','2','Mr. Khuzaima Rangwala Saifudin','104771','2004-11-01','','Moalim',4),('397','Shaikh Shabbir','Zulfiqar','Mandasorewala','0','Male','515-90-029601','','42000-0392642-3','OV4XBL','1972-06-10','House No 16, Chiragh Square,','3rd Floor,','Saddar,','Karachi','','','','','shabbir403@yahoo.com','Shabbir','020-OJ-202656','2004-11-01','3722968-7','1','','','Employee of Attalim. As per manzoori salary paid from Dawat. Salary Rs 13,300. EOBI deducted from January 2005.','Zulfiqar','','2004-11-01','','1139','459','5005','Income Tax Rs 459 for the year 2007 from July 2006 to June 2007 has been deducted in July 2006.','Y','257','Shabbir','Zulfiqar','1','2007-08-28','','IT20070829-0250-0000001','2007-07-01','TRUE','1','','22','0','','2','Mr. Shabbir Zulfiqar','101716','2004-11-01','','Moalim',4),('399','Shaikh Yousuf','Moiz','Khambatwala','0','Male','502-64-432436','','42101-3395348-5','LG5L1B','1964-01-01','Flat No A-20, ','Al-Saba Apartment, Block E,','Haidery, North Nazimabad,','Karachi','','','','','ymoiz@yahoo.com','Yousuf ','020-OG-202658','2004-11-01','3726959-3','1','','','Employee of Attalim. As per manzoori salary paid from Dawat. Salary Rs 13,000. EOBI deducted from January 2005.','Moiz','','2004-11-01','','1112','435','5006','Income Tax Rs 450 for the year 2007 from July 2006 to June 2007 has been deducted in July 2006.','Y','259','Yousuf','Moiz','1','2007-08-28','','IT20070829-0250-0000001','2007-07-01','TRUE','1','','22','0','','2','Mr. Yousuf Moiz','101723','2004-11-01','','Moalim',4),('403','Safeer Hussain Chowdhry','Abdul Hameed Chowdhry','.','0','Male','710-76-362991','','42101-5801941-7','K1L35M','1976-05-13','House No A-978, Sector 11-B,','North Karachi','','Karachi','','','','','','Safeer Hussain Chowdhry','020-OG-202666','2005-02-01','','','','','Appointed as Watchman in Maweed gate. Salary Rs 3,600 from 01/02/2005. EOBI deducted from Feb 2005.Before leaving he joined from 01/02/2005.He now again rejoined from 01/07/08.Salary Rs 6,500 in Tanzeem Department','Abdul Hameed Chowdhry','','2008-07-01','','2464','0','0','','Y','267','','','0','','','','','FALSE','3','','41','0','','7','Safeer Hussain Chowdhry','125735','2008-07-01','','Gate Keeper Main Gate',3),('405','Mir Rujeeb Naseem','Syed Tamshal Ahmed Askari','.','0','Male','502-91-552523','','42101-5604838-1','K1T1TX','1971-09-17','B-232, Block J, ','North Nazimabad, ','','Karachi','','','','','','Mir Rujeeb Naseem','020-OI-202664','2005-01-01','','','','','Appointed as teacher in IBO Department. Salary Rs 350 per period. On job from 01/01/2005. EOBI deducted from March 2005.','Syed Tamshaal Ahmed Askari','','2005-01-01','31-Dec-05','2468','0','0','','Y','265','','','0','','','','','FALSE','3','','52','0','','0','','','2005-01-01','','Teacher',3),('406','Farhana ','Yousuf Ali','Nadir','0','Female','513-82-147144','','42201-0603218-2','J9R08Y','1982-06-26','2nd Floor, Riyaz Centre,','Block A, Shabbirabad,','shahrah-e-Faisal,','Karachi','','','','','','Farhana Yousuf Ali','020-OJ-202663','2005-01-01','','','','','Appointed as teacher in IBO department. Salary as period basis Rs 350 per period. Paid salary from March 2005. EOBI deducted from March 2005.','Yousuf Ali','','2005-01-01','31-Dec-05','2469','0','0','','Y','264','','','0','','','','','FALSE','3','','52','0','','0','','','2005-01-01','','Teacher',3),('408','Mulla Hussain ','Fakhruddin','Quettawala','0','Male','515-81-236902','','42301-0963918-9','KR621V','1981-05-20','House No 14, Razak Wahab','Manzil, Saddar, ','Syedna Mohammad Burhanuddin Rd','Karachi','','','','','hussainezzy@gmail.com','Hussain Quettawala','','','3737423-7','1','','','Appointed as khidmatguzars in Al-Jamea. Wazifa due from Rabiul Awwal 1426 on probition. Rs 5000 wazifa paid to him. EOBI deducted.','Fakhruddin Quettawala','','','','1410','0','347','','Y','278','Hussain Quettawala','Fakhruddin Quettawala','0','','','IT20071010-0250-0000022','2007-09-01','TRUE','3','','35','0','','4','Hussain Quettawala Fakhruddin','1200 18381','2005-05-01','','Teacher',3),('409','Shaikh Yousef Ali ','Mohammed','AlNaggar','0','Male','','00936023','','','1981-02-01','C/o. Al-Jameatus Saifiyah','ST-8, Block C, Haidery,','North Nazimabad,','Karachi','','','','','yusufnajjar@gmail.com','Yousef Ali Mohammed','Foreigner','','3150895-2','1','','','Appointed as khidmatguzar in AJS. Wazifa paid to him Rs 5000 from Rabiul Awwal 1426.He is on probation.No EOBI deducted.','Al-Naggar','0','2005-05-01','','2480','0','351','','','0','Yousef Ali Mohammed','Al-Naggar','0','','','IT20071010-0250-0000019','2007-09-01','TRUE','3','','35','0','','4','Yousef Ali Mohammed','1200 18624','2005-05-01','','Teacher',3),('410','Alifiyah ','Abdullah','Motiwala','0','Female','','','42101-1503937-8','JX0Q4C','1947-12-26','House No C-216, Block A,','North Nazimabad,','','Karachi','','','','','','Alifiyah','','','','','','','Appointed as teacher in Manahij Talimiyah Department as period basis. Per period @ Rs 75.','Abdullah Motiwala','','2005-03-22','','2481','0','0','','','0','','','0','','','','','FALSE','3','','61','0','','7','Aleifiyah Abdullah Motiwala','1001 13060','2005-03-22','','Teacher',3),('411','Rashida','Shaikh Quresh','Haidery','0','Female','','','42101-4835698-6','K391GW','1984-04-19','Flat No L-345, Al-Burhan Arcad','Haidery, North Nazimabad, ','','Karachi','','','','','','Rashida Haidery','','','','','','','Appointed as teacher in Tadbeer-e-Manzeli Deptt for interior decorator.','Quresh','','2005-01-05','','2483','0','0','','','0','','','0','','','','','FALSE','3','','53','0','','7','Rashida Haidery','186135','2005-01-05','','Teacher',3),('415','Shaikh Huzaifa ','Shaikh Quaidjohar','Latif','0','Male','515-80-317953','','42301-5622875-7','KM3192','1980-01-04','House No GS7-139, ','Dawoodi Masjid Building, ','Bohri Bazar, Saddar,','Karachi','','','','','huzlatif@gmail.com','Huzaifa ','','','4079103-3','','','','Appointed as khidmatguzar in Maduzahra. Approval for conveyance Rs 2,000 per month.','Quaidjohar','','2005-01-01','','2441','0','2605','','Y','274','Huzaifa','Quaidjohar','0','','','','','TRUE','3','','37','0','','4','Huzaifa Quaidjohar','1200 18756','2008-06-01','','Khidmatguzar',3),('416','Shaikh Mustafa','Shaikh Quresh','Kothari','0','Male','513-84-136101','','42301-3719920-7','MX7927','1984-09-30','Flat No 601, Al-Mufaddal Bldg,','Decrose Lane,','Saddar,','Karachi','','','','','MUSTAFA_Q63@HOTMAIL.COM','Mustafa Kothari','0200A262337','2005-01-01','3990350-8','','','','Appointed as khidmatguzars in Mahaduzahra. Approval of conveyance Rs 2,000 per month.','Quresh Kothari','','2005-01-01','','2504','0','0','','Y','275','Mustafa Kothari','Quresh Kothari','0','','','','','TRUE','3','','37','0','','4','Mustafa Kothari','100112730','2008-06-01','','Khidmatguzar',3),('417','Farzana ','Murtaza Ali','.','0','Female','512-79-227132','','42000-0408971-4','LG6W8M','1979-01-27','House No 402, Saifee Building,','Shahrah-e-Liaquat,','','Karachi','','','','','','Farzana','','','','','','M.A. Sociology','Appointed as teacher period basis. Per period Rs 75. ','Murtaza Ali','','2005-04-21','31-Dec-05','2509','0','0','','','0','','','0','','','','','FALSE','3','','61','0','','0','Farzana Murtaza Ali','','2005-04-15','','Teacher',3),('418','Muzammil','Fakhruddin','Shahjanpoorwala','0','Male','','','42000-0501461-7','IB761S','1983-02-23','Flat No 23, Millwala Apartment','Block B, Nishter Road,','','Karachi','','','','','','Muzammil','','','','','','','Appointed as office assistant in IBO Department.','Fakhruddin','','2005-05-01','','2517','0','0','','Y','276','','','0','','','','','FALSE','3','','41','0','','7','Muzammil Fakhruddin','1001 12854','2005-05-01','','I.B Assistance',3),('419','Tasneem','Shaikh Abbas','Motiwala','0','Female','','','83442-0600184-2','','1978-01-12','Flat No 204, Yousufi Manzil,','ST-4, Block C,','Haidery, North Nazimabad,','Karachi','','','','','','Tasnim Abbas Motiwala','0200G334918','2016-12-01','','','','','Appointed as teacher in Taqweeyat Department. ','Abbas Abdullah Motiwala','','2005-05-01','','1364','0','0','','','0','','','0','','','','','FALSE','3','','53','0','','7','Tasneem Abbas Motiwala','186599','2005-05-01','','Teacher',3),('419','Tasneem','Shaikh Abbas','Motiwala','0','Female','','','83442-0600184-2','','1978-01-12','Flat No 204, Yousufi Manzil,','ST-4, Block C,','Haidery, North Nazimabad,','Karachi','','','','','','Tasnim Abbas Motiwala','0200G334918','2016-12-01','','','','','Appointed as teacher in Taqweeyat Department. ','Abbas Abdullah Motiwala','','2005-05-01','','1364','0','0','','','0','','','0','','','','','FALSE','3','','54','0','','7','Tasneem Abbas Motiwala','721164','2016-12-01','','Teacher',3),('427','Salma ','Iqbal Hussain','Chatai','0','Female','513-60-130868','','42201-2383690-2','O51T0F','1960-01-01','Flat No 403, Zandani Arcade,','Plot 14-C, Central Commercial ','Area, K.C.H.S. Block 7/8,','Karachi','','','','','','Salma Iqbal','','','','','','','Appointed as teacher in Tadreeb-e-Manzeli Department. Rs 100 per period. ','Iqbal Hussain','','2005-06-18','','2686','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','Salma Iqbal Hussain','','2005-06-18','','Teacher',3),('430','Mulla Dawood Ali','Feroze Ali','.','0','Male','512-76-331784','','42201-0245014-5','1118Q','1976-08-12','Room No 8, Kaka Street,','Salma Building, Saddar,','','Karachi','','','','','','Dawood Ali','','','','','','','Appointed as teacher in Tehfizul Quran Department. Salary period wise approved Rs 69 per period.EOBI deducted from September 2005.','Feroze Ali','','2005-09-14','31-Dec-05','1151','0','0','','Y','283','','','0','','0','','','FALSE','3','','62','0','','18','Dawood Ali Feroz Ali','01-6565867-01','2005-09-14','','Teacher',3),('433','Mohammad Khalid Warsi','Saghir Ahmad Warsi','.','0','Male','516-62-243992','','42201-4558546-5','K8R6L0','1962-05-11','43 F,Jail Road,','','','Karachi','','','0300-2154697','','hamiz2010@hotmail.com','Mohammad Khalid Warsi','010-OF-027901','1985-01-24','','','B.A. Private','','Appointed as Assisstant in Passport Department from 07/11/2005. Salary Rs 5,000. EOBI deducted from November 2005.Refered by Waqar Ahmed Jafferi.','Saghir Ahmad Warsi','','2005-11-07','','2743','0','0','','Y','285','Mohammad Khalid Warsi','Saghir Ahmad Warsi','0','','0','','','FALSE','1','','17','0','','12','Mr. Mohammad Khalid Warsi','005400','2005-11-07','','Assisstant in Passport Department',4),('434','Shaikh Muslim','Shaikh Ghulamabbas','Cyclewala','0','Male','515-79-317525','','42301-0829662-7','O61W6P','1979-01-20','House No 6, Adam Mansion,','Syedna Mohammad Burhanuddin Rd','Saddar,','Karachi','','','','','almyles@gmail.com','Muslim Ghulamabbas','0200A262298','2005-08-01','3737050-2','1','','','Appointed as teacher from Jamadilakhar 1426. Salary Rs 5,000 paid. EOBI deducted from August 2005 in December 2005.','Ghulamabbas','','2005-08-01','','2596','0','348','','','0','Muslim','Ghulamabbas','0','','0','IT20071010-0250-0000022','2007-09-01','TRUE','3','','35','0','','4','Muslim Ghulamabbas','100112617','2005-08-01','','Teacher',3),('441','Tasneem Jaherali','Mulla Aliasghar','Jesorwala','0','Female','','F4074567','','','1978-02-24','D-16 Block \"F\",','North Nazimabad, Karachi.','','','','','','','','Tasnim Jaheralibhai','Foreigner','','','','','','Appointed as teacher in Manahij Talimiyah Department @ Rs 65 per period. No EOBI deducted.','.','','2006-01-13','','2848','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Tasneem Jaher Ali Bhai','1001 12803','2006-01-13','','Teacher',3),('443','Anwar Ali','Mohammad Ali','Dabbawala','0','Male','501-49-102310','','42000-0386552-5','','1941-01-01','5th Floor, Anwarali Manzil,','Chabagali, Kharadar,','','Karachi','','','','','','Anwar Ali','Above Age','','','','','','As per instruction of Naeem bs, on 29/03/2006 that salary paid of attalim employee from march 2006 from DH-VC. EOBI not deducted due to aboveage. Salary Rs 3,000','Mohammad Ali','','2006-03-01','','84','0','0','','','0','','','0','','0','','','FALSE','1','','22','0','','2','Mr. Anwar Ali','102224','2006-03-01','','Attalim Office Peon  ',4),('445','Sarah Husain','Murtaza Ali','Neemachwala','0','Female','','','911030-106190-2','','1982-01-31','J-339, Al-Burhan Arcade,','Block E, Haidery, ','North Nazimabad,','Karachi','','','','','','Sarah Husain','Foreigner','','','','','','','Murtaza Ali','','2006-03-15','','2908','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','0','Sarah Husain Murtaza Ali','','2006-03-15','','Teacher',3),('448','Qari Rehman Dad','Hakim Dad','.','0','Male','12778057818','','42101-5278353-7','L2J515','1977-06-17','Plot no.S-1043/9,','Umar Farooq Colony,','North Nazimabad','Karachi.','','','','','','Qari Rehman Dad','','','','','','','Appoint as a teacher in Daeratul Lughaat department. period basis @ 300.','Hakim Dad','','2006-03-15','31-Dec-05','2923','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','18','Qari Rehman Dad','01-6570046-01','2006-03-15','','Teacher',3),('457','Zain Mohammad','Ali Zair','.','0','Male','127-82-053201','','13504-2206524-3','TK6436','1982-01-01','Kaladhaka, Newdarband,','Madakhail,','','Mansehra Dist','','','','','','Zain Mohammad','020-OI-217009','','','','','','Appointed as chowkidar office gate in absence of Habib Syed. He is on duty for temporary 3 months from May 2006 to July 2006.Refered by Ali Sher Abdul Hameed.He is on leave from 26/2/07 on urgent basis by the permison of KY.Khaista Gul s/o Juma gul appoin','Ali Zair','','2006-05-01','25-Jul-11','2970','0','0','','Y','289','','','0','','0','','','FALSE','1','','20','0','','12','Mr. Zain Mohammad','008366','2006-05-01','','Chowkidar Office Gate',4),('459','Fatema','Akber','Hamid','0','Female','511-74-159430','','42301-0783640-0','LN9C3X','1974-12-07','Flat No 101, Hatim Manzil','Baba-e-Urdu Road,','Block B,','Karachi','','5683745','03052014145','','fhamid07@gmail.com','Fatema Akber','0200E217011','','3860662-3','1','','','Appointed as office secretary. Salary paid to her from June 2006.EOBI deducted from June 2006.Rs 3000 increament from Nov 2006.Her salary Rs 15,000','Akber','','2006-04-01','','2971','1043','2204','Income Tax Rs 1,043 for the year 2008 from July 2007 to June 2008 has been deducted in July 2007.','Y','291','Fatema','Akber','8','2007-08-04','0','IT20070804-0250-0000008','2007-07-01','TRUE','1','','17','0','','12','Mrs. Fatema Akber','005408','2006-05-16','','Office Secretary',4),('462','Hafiz Mazher Hussain','Mohammad Hussain','.','0','Male','','','42101-9771640-3','JK6R6C','1982-03-01','Shamsul Uloom Jamea,','Block N, North Nazimabad,','','Karachi','','','0300-2491665','','','Hafiz Mazher Hussain','','','','','','','Appointed as Qari in Tehfizul Quran Department. Salary Rs 300 per period. EOBI deducted from May 2006.','Mohammad Hussain','','2006-05-01','31-Dec-05','2990','0','0','','','0','','','0','','0','','','FALSE','3','','62','0','','0','Hafiz Mazher Hussain','01-','2006-05-01','','Qari Teacher',3),('476','Sh MushtaqHusain Mustansi','Abdul Qadir Bhai','Gandhi','0','Male','502-58-434758','','42101-1640436-5','LL3J2Z','1958-04-03','House No 20, Block C,','North Nazimabad,','','Karachi','','','','','mustansirburhani_52@hotmail.com','Mushtaq Husssain Mustansir','0200F298626','2006-07-01','','','','','Appointed as teacher in period basis @ Rs 100 each. EOBI deducted from July 2006.','Abdul Qadir Bhai','','2006-07-01','','3049','0','0','','','0','','','0','','0','','','FALSE','3','','32','5','','5','Mushtaq Hussain Mustansir','100115713','2006-07-01','','Teacher',3),('476','Sh MushtaqHusain Mustansi','Abdul Qadir Bhai','Gandhi','0','Male','502-58-434758','','42101-1640436-5','LL3J2Z','1958-04-03','House No 20, Block C,','North Nazimabad,','','Karachi','','','','','mustansirburhani_52@hotmail.com','Mushtaq Husssain Mustansir','0200F298626','2006-07-01','','','','','Appointed as teacher in period basis @ Rs 100 each. EOBI deducted from July 2006.','Abdul Qadir Bhai','','2006-07-01','','3049','0','0','','','0','','','0','','0','','','FALSE','3','','38','0','','4','Mushtaq Hussain Mustansir','100115713','2008-07-01','','Teacher',3),('478','Mulla Kumail','Mulla Ismail','Nadir','0','Male','512-76-215725','','42101-1593929-1','MD207Z','1976-01-01','House No 8, Hussain Square,','Block E, SF-10,','North Nazimabad,','Karachi','','6626137','','','','Kumail','','','','','','','Appointed as teacher in Manahij Talimiyah department. Salary paid from August 2006. EOBI deducted from August 2006. Period basis salary Rs 100 each.','Ismail Nadir','','2006-06-27','31-Dec-05','1105','0','0','','Y','294','','','0','','0','','','FALSE','3','','61','0','','7','Kumail Nadir','100104800','2006-06-27','','Teacher',3),('480','Mulla Mustafa','Shaikh Juzar','Colombowala','0','Male','','M-1589925','','','1984-12-19','Al-Jameatus Saifiyah,','ST-8, Block C,','North Nazimabad,','Karachi','','','0333-3307952','','MUSTAFAMISHI@GMAIL.COM','Mustafa ','Foreigner','','4182476-8','','','','','Juzar','','2006-02-01','','3061','0','0','','','0','Mustafa','Juzar','0','','0','','','TRUE','3','','37','0','','4','Mustafa Juzar','100112641','2008-06-01','','Teacher',3),('484','Turab Ali','Baqir Ali','Rozanawala','0','Male','515-44-064793','','42301-1124181-9','IS9Q75','1944-01-01','House No 6, Saddar Mansion,','Mir Karam Ali Talpur Road,','Saddar,','Karachi','','','0333-3473003','','','Turab Ali Rozanawala','ABOVE AGE','','','','','','He is in place of Zahid Hussain Sharafali Haryanawala.He is appointed as supervisor.Salary Rs 4,000.','Baqir Ali Rozanawala','','2006-12-18','','3163','0','0','','','0','','','0','','0','','','FALSE','3','','47','0','','7','Turab Ali Rozanwala','1001 12897','2006-12-18','','Supervisor',3),('488','Mohammad Irfan','Ansar Hayat','.','0','Male','','','42101-6719397-1','NQ0J9G','1986-06-21','House No 346, Umar Farooq','Colony No 2, Block Q, ','North Nazimabad,','Karachi','','6625246','0345-2267811','','','Mohammad Irfan','020-OD-217020','','','','','','Appointed as photostate machine operator in tanzeem office. Salary Rs 3,300.EOBI ded from January 2007.He is in place of Abdul Shakoor Mohammad Sharif.','Ansar Hayat','','2007-01-01','','3216','0','0','','Y','301','','','0','','0','','','FALSE','3','','41','0','','7','Mohammad Irfan','1001 12889','2007-01-01','','Photostate Machine Operator',3),('503','Mohammad Nazir','Mohammad Hussain','.','0','Male','760-79-186089','','71103-2261336-7','T6K4YJ','1979-05-28','Mohallah Muntazirabad, Kawaro,','Tehsil Iskardo,','District Baltistan','','','6058821','0334-3626383','','','Mohammad Nazir','','','','','','Karachi Address, P-492, Peoples Colony, Block N, North Nazimabad, Karachi','Apointed as teacher in Manahij Talimiyah. Salary @ Rs 400 per period.','Mohammad Hussain','','2007-02-24','','3286','0','0','','Y','304','','','0','','0','','','FALSE','3','','61','0','','7','Mohammad Nazir','1001 12994','2007-02-24','','Teacher',3),('505','Sakina','Abdullah','Sidhpurwala','0','Female','502-73-152240','','42000-0490805-4','NW7M1R','1973-08-28','House No 10, Burhani Bagh,','Haidery, Block E, ','North Nazimabad,','Karachi','','6625064','0301-2234068','','','Sakina Abdullah','0200I217025','','','','','','Appointed as laboratory attendant. She is in place of Munira Yousuf Barwaniwala. Salary Rs 2,000.','Abdullah bhai','','2007-02-15','','3292','0','0','','Y','305','','','0','','0','','','FALSE','3','','43','0','','7','Sakina Abdullah','429433','2007-03-16','','Laboratory Attendant',3),('505','Sakina','Abdullah','Sidhpurwala','0','Female','502-73-152240','','42000-0490805-4','NW7M1R','1973-08-28','House No 10, Burhani Bagh,','Haidery, Block E, ','North Nazimabad,','Karachi','','6625064','0301-2234068','','','Sakina Abdullah','0200I217025','','','','','','Appointed as laboratory attendant. She is in place of Munira Yousuf Barwaniwala. Salary Rs 2,000.','Abdullah bhai','','2007-02-15','','3292','0','0','','Y','305','','','0','','0','','','FALSE','3','','71','0','','7','Sakina Shabbir','102318','2017-12-01','','Data Management',3),('511','Iqbal Hussain','Mohammad Nawaz','.','0','Male','241-89-310797','','38101-4836812-1','','1968-01-01','Dakhana Shahani','','','Bakhar','','','0300-7032430','','','Iqbal Hussain','0200A295908','2007-05-22','','','','','Appointed as mali for daily checking of garden in Ahmedvilla. Salary Rs 4,000 from 22/05/2007. ','Mohammad Nawaz','','2007-05-22','','3377','0','0','','','0','','','0','','0','','','FALSE','3','','44','0','','7','Iqbal Hussain','323640','2013-11-01','','Mali',3),('517','Shiakh Abbas','Aun Ali','.','0','Male','','','42201-0524452-1','J250PF','1983-01-15','House No B-224, Shabbirabad,','Syedna Ismail',' Road,','Karachi','','','','','abbasaunali@gmail.com','Abbas ','0200J295909','2007-05-01','3730959-5','1','','','Appointed as khidmatguzar in Mahaduzahra from 01/05/2007. Salary Rs 5,000.EOBI deducted from May 2007.Appointed towards Manzoori.','Aun Ali','','2007-05-01','','3436','0','2100','','','0','Abbas','Aun Ali','0','','0','','','TRUE','3','','36','0','','4','Abbas Aunali','100113419','2007-05-01','','Khidmatguzar',3),('518','Tasneem','Saifuddin','Jodiawala','0','Female','512-78-317771','','42101-0412573-2','J4M0MB','1978-07-03','Flat No F-125, ','Al-Burhan Arcade, Haidery,','North Nazimabad,','Karachi','','','03322327902','','','Tasneem Saifuddin','','','','','','','Appointed as teacher in Manahij Talimiyah department. Salary Rs 100 period basis.She is a teacher of Physiotherapy.','Saifuddin','','2007-07-09','31-Dec-05','3481','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Tasneem Saifuddin','100115136','2007-07-09','','Teacher',3),('519','Mufaddal ','Taher Abdulhussain','Jamnagarwala','0','Male','512-68-005309','','42301-7848984-1','N6N64V','1968-01-01','Flat No 11, Qasr-e-Kulsoom,','Block E, Haidery,','North Nazimabad,','Karachi','','','0333-2284571','','','Mufaddal','0200F217028','','','','Intermediate','','Appointed as airconditioner technician in maintenance department.  Salary Rs 10,500. Reappointed as a swimming instructor for Boys. Salary Rs 6,000 from March 2008.','Taher Abdulhussain','','2007-06-07','31-Dec-05','3482','0','0','','Y','308','Mufaddal','Taher Abdulhussain','0','','0','','','FALSE','3','','60','0','','7','Mufaddal Taher Abdulhussain','100114199','2008-03-01','','Swimming Instructor',3),('520','Mohammad Younus','Basheer Ahmed','.','0','Male','','','32301-6511593-3','66B6RD','1986-01-10','House NO 2169/1, Umar Farooq','Colony, Block Q,','North Nazimabad,','Karachi','','','0301-2801525','','','Mohammad Younus','0200I217033','','','','','','Appointed as peon on 3rd Floor in Tanzeem Office. Salary Rs 3,500 from July 2007.','Basheer Ahmed','','2007-07-10','','3483','0','0','','Y','313','','','0','','0','','','FALSE','3','','41','0','','7','Mohammad Yunus Basheer Ahmed','100114202','2007-07-10','','Peon Third Floor',3),('522','Shaikh Zainuddin','Fidahussain','Khambatwala','0','Male','','Z-1017267','','','1955-06-05','Yousufi Masjid,','Syedna Idrees Road,','Shabbirabad,','Karachi','','','','','yusufimasjidpakamil@alvazarat.org','Zainuddin Fidahussain','','','2957293-2','1','','','Appointed as Aamil in Yousufi Masjid. Wazifa Rs 15,000.','Fidahussain','','2007-07-01','31-May-11','3487','4568','36','Income Tax Rs 4,568 for the year 2008 from July 2007 to June 2008 and from Jamadil Awwal 1428 to Jamadil Akhar 1429 has been deducted in August 2007.','','0','Zainuddin','Fidahussain','37','2007-09-05','0','IT-0250-0000037','2007-08-01','FALSE','1','','16','1','','21','Mr. Zainuddin Fidahussain Kham','102453','2007-07-01','','Aamil Yousufi Mohallah',4),('523','Mulla Huzefa','Shabbir Hussain','Jalebiwala','0','Male','','Z-20555','42301-8763686-1','KJ8Z71','1985-09-22','Flat No 3, Rafiq Plaza,','5th Floor, M.R. Kiyani Road, ','','Karachi','','','0345-2874147','','hsjalebiwala@gmail.com','Huzefa','0200B217030','','','','','','Appointed as teacher in Tanzeem office, Salary Rs 5,000.','Shabbir Hussain','','2007-07-01','','2951','0','0','','Y','310','Huzefa','Shabbir Hussain','0','','0','','','TRUE','3','','36','0','','4','Huzefa Shabbir Hussain','100113397','2010-03-16','','Teacher',3),('524','Durriyah','Aqeel Hussain','Ujjainwala','0','Male','502-9380090-0','','42101-1523606-2','MF1C3K','1961-05-18','House No A-192, Block C,','North Nazimabad,','','Karachi','','6673616','03022125152','','','Durriyah','','','','','','','Appointed as teacher in Imtehanat Ukhra SSC, Salary Rs 4,000.','Aqeel Hussain','','2007-07-01','31-Dec-05','3489','0','0','','Y','311','','','0','','0','','','FALSE','3','','57','0','','0','Durriyah Aqeel Hussain','','2007-07-01','','Teacher',3),('525','Mulla Yousuf','Zoaib Hussain','Madarwala','0','Male','','','42101-7459901-7','KK7X05','1986-01-26','House No C-8, Taimuria Square,','Barkat-e-Haidery,','North Nazimabad,','Karachi','','','03333727752','','ymadar52@gmail.com','Yousuf Zoaib','0200J217032','','4078921-7','','','','Appointed as teacher in Jawazat Department. Salary Rs 5,000.','Zoaib Hussain','','2007-07-01','','3232','0','8001','','Y','312','Yousuf','Zoaib Hussain','0','','0','','','TRUE','3','','36','0','','4','Yousuf Zoaib','100113400','2010-03-16','','Jawazaat Department',3),('539','Dr. Nafisa','Ashfaq Hussain','Burhanpurwala','0','Female','523-64-020305','','42101-8973119-2','O36R71','1964-12-07','Room No 206, Samar Pride,','Block E, Haidery,','North Nazimabad,','Karachi','','2010992','0603-2152559','','','Nafisa Ashfaq','0200G295910','2007-11-01','','','','','Appointed as Dr. in mahalushifa for talebaat. Salary Rs 3,500. She is in place of Dr. Zubaida Iqbal Mirza.','Ashfaq Hussain','','2007-11-01','','3631','0','0','','Y','320','','','0','','0','','','FALSE','3','','49','0','','7','Nafisa Ashfaq','100119778','2007-11-01','','Doctor',3),('540','Shaikh Tayyib','Shaikh Zoeb','Tinwala','0','Male','','711126987','','','1975-11-14','C/o Al-Jameatus Saifiyah','ST-8, Block C, Haidery,','North Nazimabad,','Karachi','','','','','tayyibt@gmail.com','Tayyib Zoeb Tinwala','FOREIGNER','','3150891-0','1','','','Appointed as teacher in Jamea. Wazifa paid to him from Rajab 1428.No EOBI deducted.','Zoeb Tinwala','','2007-12-01','','3643','0','352','','','0','Tayyib Zoeb','Tinwala','0','','0','','2008-01-01','TRUE','3','','35','0','','4','Taiyeb Zoeb Bhai','100119840','2007-12-01','','Teacher',3),('542','Mohammad Shafiq','Shaikh Ahmed','.','0','Male','','','13501-8821047-9','VN840M','1987-11-08','City Court Dakhana,','Tehsil Balakot,','District Mansehra','','','','','','','Mohammad Shafiq','0200F262358','2007-09-01','','','','','DHP\nAppointed as chowkidar in Burhani Bagh. Salary Rs 4,000.','Shaikh Ahmed','','2007-09-01','','3696','0','0','','Y','321','','','0','','0','','','FALSE','3','','104','0','','7','Mohammad Shafiq','100123104','2007-09-01','','Chowkidar',3),('545','Houzaifa','Ilyas bhaisaheb','.','0','Male','','','42101-2708034-3','J5S657','1986-06-07','Flat No 202, Najmi Manzil,','ST-8, Block C, Haidery,','North Nazimabad,','Karachi','','6672841','','','huzefaibs@gmail.com','Houzaifa Ilyas','0200E262325','2007-12-08','3726678-7','','','','Appointed as teacher from Zilhaj 1428. Wazifa Rs 10,000 permonth.','Ilyas','','2007-12-08','','3634','0','0','','Y','327','Houzaifa Ilyas','Ilyas','0','','0','','','TRUE','3','','36','0','','4','Huzefa Ilyas','256741','2007-12-08','','Teacher',3),('549','Aliasghar','Shabbirhussain','Lunawadwala','0','Male','','','42101-2340819-1','I0B770','1986-06-21','House No 17, Qasr-e-Wali bhai,','Barkat-e-Haidery,','North Nazimabad,','Karachi','','','0333-3100852','','','Aliasghar','','','','','M.Sc Final Applied Chemistry','','Appointed as teacher in Manahij Talimiyah. Referred by Murtaza bhaisaheb, Salary @ Rs 100 per period basis.','Shabbirhussain','','2008-02-29','22-Feb-09','3732','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','0','','','2008-02-29','','Teacher',3),('550','Sakina','Shabbir Hussain','Bharmal','0','Female','508-8233650-2','','42301-0725920-2','J7953J','1982-06-26','House No 203, Tawakkal Mansion','New Challi, ','Karachi','','','2635107','03452079137','','sakbharmal101@gmail.com','Sakina','0200J262338','2008-03-05','','','','','Appointed as Receptionist. Salary Rs 4,000. After 6 months probition salary increase Rs 500. Refered by Rashida bhen, Saifiyah Girls School.Rs 1000 increased salary from Aug 2008','Shabbir Hussain','','2008-03-05','','3753','0','0','','','0','','','0','','0','','','FALSE','1','','17','0','','12','Ms. Sakina Shabbir Hussain','008365','2008-03-05','','Receptionist',4),('552','Shaikh Mohammad Adeeb','Shaikh Fidaali Adeeb','Adeeb','0','Male','502-83-988552','','42201-2685467-3','K7Z7RL','1983-03-14','House No A-8, ','Shabbirabad Square, ','Ameer Khusroo Road,','Karachi','','6638975','03343264648','','mfidaaliadeeb@gmail.com','Mohammad Adeeb','0200G262357','2008-04-01','3988955-6','','','','Appointed as teacher from Rabiul Akhar 1429.','Fidaali Adeeb','','2008-04-01','','3797','0','10000','','','0','Mohammad Adeeb','Fidaali Adeeb','0','','0','','','TRUE','3','','35','0','','4','Mohammad Adeeb','120522','2008-04-01','','Teacher',3),('553','Shaikh Aamir ','Shaikh Abbas Ali','Ajmerwala','0','Male','517-84-518238','','42000-5731827-1','17C8SK','1984-02-28','House No 199,','Shabbirabad,','','Karachi','','4526019','03442461192','','aamirajmerwala@gmail.com','Aamir Abbas Ali','0200D262368','2005-04-01','3987086-3','','','','Appointed as teacher from Rabiul Akhar 1429. Salary Rs 7,000pm. ','Abbas Ali Ghulam Ali','','2008-04-01','','1408','0','10008','','','0','Aamir Abbas Ali','Abbas Ali Ghulam Ali','0','','0','','','TRUE','3','','35','0','','4','Aamir Abbas Ali','120519','2008-04-01','','Teacher',3),('555','Dr. Jabir Hussain','Feroze Hussain','Burhanpurwala','0','Male','502-50-422462','','42101-0810875-9','','1950-01-01','House No C-6, ','Block D, ','North Nazimabad,','Karachi','','6638318','','','','Jabir Hussain','ABOVE AGE','','','','MBBS, FRSH','','Appointed as a Doctor in Mahalushifa. Salary Rs 10,000. Timming 10am to 11am and 6pm to 7pm daily','Feroze Hussain','','2008-02-28','','3807','0','0','','Y','325','Jabir Hussain','Feroze Hussain','0','','0','','','FALSE','3','','49','0','','7','Jabir Hussain Feroz Hussain','130198','2008-02-28','','Doctor',3),('556','Shaikh Mufaddal','Mulla Qutbuddin','Shakir Ajmerwala','0','Male','','A16418822','','','1983-08-11','Flat No 205, Yousufi Manzil,','ST-8, Block C,','North Nazimabad,','Karachi','','','03333165327','','mufaddalshakir52@gmail.com','Mufazzal Bin Kutbuddin','FOREIGNER','','3208278-9','','He is Malaysian Nationals.','','Appointed as teacher from Rabiul Akhar 1429. NO EOBI deducted.','Kutbuddin','','2008-04-01','','3809','0','0','','','0','Mufazzal','Bin Kutbuddin','0','','0','','','TRUE','3','','35','0','','4','Mufazzal Bin Kutbuddin','121051','2008-04-01','','Teacher',3),('557','Maan Gul','Hamesh Gul','.','0','Male','','','21704-4478269-7','I1Z718','1984-01-01','Wishtenai Dakhana,','Jandola, Tehsil Sararogha,','District South','Waziristan Agen','','','03082010968','','','Maan Gul','0200E262333','2008-02-26','','','Nil','','Appointed as watchman in Masakin. Salary Rs 4,000. He is in place of Rahimullah Sultan. His duty timing 8am to 8pm daily.','Hamesh Gul','','2008-02-26','','3834','0','0','Quarter No 34, Peerabad Street No 10, Banaras, Karachi','','0','','','0','','0','','','FALSE','3','','50','0','','7','Maan Gul','122166','2008-02-26','','Watchman',3),('560','Yaqoota','Fakhruddin','Painter','0','Female','502-77-878724','','42000-0422907-2','KG6Q77','1977-01-01','Flat No 109, Burhani Bagh,','Barkat-e-Haidery,','North Nazimabad,','Karachi','','','','','','Yaqoota','0200C334920','2016-12-01','','','','','Appointed as Aerobic Teacher. Salary Rs 7,000 per month. Refered by Nematullah bhensaheb.Reappoint as a ','Fakhruddin','','2010-05-01','','3857','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Yaqoota Fakhruddin','189604','2016-12-01','','Yoga Teacher',3),('562','Mulla Huzaifa ','Abde Munaf','Mundrawala','0','Male','','','42201-8086938-9','M786CJ','1983-11-05','Flat No 8, 1st Floor,','Al-Batool, Decroze Lane,','Soldier Bazar No 3,','Karachi','','2226252','03322264952','','huzefa7005@GMAIL.COM','Huzaifa ','0200I262339','2008-04-06','3735611-9','','','','Appointed as teacher in QTM khidmatguzar.','Abde Munaf','','2008-04-06','','2135','0','8006','','Y','329','Huzaifa','Abde Munaf','0','','0','','','TRUE','3','','37','0','','4','Huzaifa Abde Munaf','123170','2008-04-06','','Teacher',3),('563','Mulla Aun Ali ','Feroze','Khambatwala','0','Male','502-85-863604','','42101-3814504-7','J5M45C','1985-01-03','House No B-128, Block C,','North',' Nazimabad,','Karachi','','4242853','03333585052','','AUNALI1134@gmail.com','Aun Ali','0200G262349','2008-04-06','3445356-3','','','','Appointed as teacher in QTM khidmatguzar.','Feroze','','2008-04-06','','3245','0','0','','Y','330','Aun Ali','Feroze','0','','0','','','TRUE','3','','37','0','','4','Aun Ali','123167','2008-04-06','','Teacher',3),('564','Shaikh Abuzar','Hussain Ali ','Ratlamwala','0','Male','','','42201-1240014-1','N3J8ZX','1984-02-15','Flat No 6, Shabbir Manzil,','3rd Floor, Soldier Bazar,','No 1,','Karachi','','2253133','03333745437','','mmabizer@gmail.com','Abuzar ','0200G262284','2008-04-06','3732226-5','','','','Appointed as teacher in QTM khidmatguzar.','Hussain Ali','','2008-04-06','','2873','0','8007','','Y','331','Abuzar','Hussain Ali','0','','0','','','TRUE','3','','37','0','','4','Abuzar Hussain Ali','123168','2008-04-06','','Teacher',3),('565','Mulla Mohammad','Haider Ali','Sunailwala','0','Male','','','42301-0207481-3','LG4X10','1985-09-13','2nd Floor, Salma Manzil,','Floor Mills Street, Garikhata,','Haqqani Chowck,','Karachi','','2626056','03343782785','','tips133@gmail.com','Mohammad','0200I262363','2008-04-06','3989903-9','','','','Appointed as teacher in QTM khidmatguzar.','Haider Ali','','2008-04-06','','3244','0','0','','Y','332','Mohammad','Haider Ali','0','','0','','','TRUE','3','','37','0','','4','Mohammad Haider Ali','123169','2008-04-06','','Teacher',3),('572','Hussain','Mulla Mohammad Hussain','Godhrawala','0','Male','','','42101-2700972-5','NR0Q67','1985-12-08','Flat No 10, Qasr-e-Qutbuddin,','Block E, Barkat-e-Haidery,','North Nazimabad,','Karachi','','','03333829622','','','Hussain Mohammad','','','','','Under graduate','','Appointed as teacher for I.B. (HSC) department. Salary Rs 11,000. Refered by Shaikh Mustafa Hassanali Rasheed.','Mohammad Hussain','','2008-04-03','','3954','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','0','Hussain Mohammad','','2008-04-03','','Teacher',3),('584','Shaikh Ismail ','Abbas','Oonwala','0','Male','.','','42000-0365926-1','.','1947-06-26','C-317 ','Al Burhan Arcade','Block E North Nazimabad','Karachi','','','','','','Ismail Abbas','Above Age','','2402159-8','1','','Retired From PIA','Joined as Manager at STSMF. Now from July 2010 transfer as office staff dawat. Salary Rs 24,000.','Abbas Mohammad Ali','','2008-07-01','','5025','0','1503','','','0','Ismail','Abbas','0','','0','','','TRUE','1','','17','0','','10','Mr. Ismail Abbas','1045785','2010-12-24','','Public Relation Officer',4),('600','Abdul Mateen','Ghulam Bahadur','.','0','Male','123-89-595911','','42301-2123642-5','JS3X4Q','1967-01-01','House No 245, Street No D-2,','MT Khan Road, Near Bilal','Masjid, Sultanabad,','Karachi','','','0346-3566005','','','Abdul Mateen','','','','','Primary','','Appointed as a Driver to Nematullah baisaheb. He is in place of Naseebzada. Salary Rs 7,850.','Ghulam Bahadur','','2008-10-18','','4257','0','0','','','0','','','0','','0','','','FALSE','3','','46','0','','7','Abdul Mateen Ghulam Bahadur','132017','2008-10-18','','Driver',3),('604','Shaikh Huzaifa ','Shaikh Taher','Godhrawala','0','Male','502-80-598547','','42101-1592228-5','I6J4TF','1980-01-13','203, Najmi Manzil,','ST-4, Block C,','North Nazimabad,','Karachi','','','','','huz796@gmail.com','Huzaifa Taher Godhrawala','0200C262343','2008-07-03','3725107-4','','','','Appointed as a teacher. ','Taher Ebrahim Godhrawala','','','','1619','0','10006','','','0','Huzaifa Taher Godhrawala','Taher Ebrahim Godhrawala','0','','0','','','TRUE','3','','35','0','','4','Huzaifa Taher','130926','2008-07-03','','Teacher',3),('614','Masooma ','Moiz Ali','Dharolia','0','Female','512-67-323968','','42000-0366521-0','IL9M8W','1967-04-14','House No A-187, Block C,','North Nazimabad,','','Karachi','','6702523','0321-2017861','','','Masooma Moiz Ali','0200C296237','2009-01-01','','','B.Sc, B.E8','','Appointed as teacher period basis @ Rs 110 per period. She is in place of Samina Adnan. She is appointed in Manahij Talimiyah department. Referred by Shaikh aliasghar Feroze.','Moiz Ali','','2009-01-21','','4371','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Masooma Moiz Ali','137907','2016-12-01','','Teacher',3),('614','Masooma ','Moiz Ali','Dharolia','0','Female','512-67-323968','','42000-0366521-0','IL9M8W','1967-04-14','House No A-187, Block C,','North Nazimabad,','','Karachi','','6702523','0321-2017861','','','Masooma Moiz Ali','0200C296237','2009-01-01','','','B.Sc, B.E8','','Appointed as teacher period basis @ Rs 110 per period. She is in place of Samina Adnan. She is appointed in Manahij Talimiyah department. Referred by Shaikh aliasghar Feroze.','Moiz Ali','','2009-01-21','','4371','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Masooma Moiz Ali','137907','2009-01-21','','Teacher',3),('617','Sarah ','Fakhruddin','Rampurawala','0','Female','502-69-883700','','42101-1483152-0','OV6P9S','1969-10-10','House No E-36, Block E','Haidery Memorial Market,','North Nazimabad,','Karachi','','6625069','0334-3311452','','sarafakhruddin@gmail.com','Sarah Fakhruddin','','','','','B.Sc, B. Pharmacy','','Appointed as teacher period basis. Salary Rs 110 per period. She is in Manahij Talimiyah department','Fakhruddin','','2009-02-02','31-Dec-05','4385','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Sarah Fakhruddin','138555','2009-02-02','','Teacher',3),('618','Taher Shabbir','Shabbir Ismail ','Bandrawala','0','Male','','','42101-1067848-9','LL910G','1990-07-06','House No 9/1-B, Al-Hamra','Square, Block E, Haidery,','North Nazimabad,','Karachi','','','0321-8207152','','','Taher Shabbir','','','','','Intermediate','','Appointed as lab attendant. He is in place of Shabbir Hussain Alihussain. His timing 9.30am to 4pm. Salary Rs 5,500','Shabbir Ismail Bandrawala','','2009-02-02','30-Sep-11','4386','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Taher Shabbir','138520','2009-02-02','','Lab Attendant',3),('627','Taher ','Shabbir','Amreliwala','0','Male','502-86-750893','','42101-2879252-9','K5R9Q2','1986-07-14','Flat No 23, Qasr-e-Saifee,','Barakat-e-Haidery,','North Nazimabad,','Karachi','','6624814','0346-2771852','','','Taher Shabbir','','','','','','','Appointed as a teacher period basis. Rs 100 per period. Referred by Shaikh Qutubkhan Kothari. He is in place of Aliasghar Shabbir.He is in Manahij Talimiyah Department.','Shabbir Fazal Hussain','','2009-02-24','','4445','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Taher Shabbir','140868','2009-02-24','','Teacher',3),('628','Mulla Taha','Safdar Ali','Shakir','0','Male','513-85-137090','','42101-0409622-5','ID719K','1985-01-10','House No 13, Imran Plaza,','Block G, North Nazimabad,','','Karachi','','','','','taha.shakir52@gmail.com','Taha ','0200J262354','2009-02-25','3987168-1','','','','Appointed as a teacher.','Safdar Ali Shakir','','2009-02-25','','3774','0','0','','','0','Taha','Safdar Ali Shakir','0','','0','','','TRUE','3','','36','0','','4','Taha Safdar Ali Shakir','140864','2009-02-25','','Teacher',3),('629','Shaikh Taher','Shabbir Hussain','Rahat','0','Male','211-84-345061','','42101-2007562-1','OT3Z32','1984-08-23','1st Floor, Flat No D-4392,','Water Tank, Gawalmandi,','','Rawalpindi','','','','','taherpindi@gmail.com','Taher Shabbir Rahat','0200E295912','2009-02-25','4078919-5','','','','Appointed as a teacher.','Shabbir Hussain Rahat','','2009-02-25','','2872','0','8002','','','0','Taher Shabbir Rahat','Shabbir Hussain Rahat','0','','0','','','TRUE','3','','35','0','','4','Taher Shabbir Rahat','140867','2009-02-25','','Teacher',3),('630','Shaikh Murtaza ','Shaikh Abbas Ali','Udaipurwala','0','Male','','','42101-0320281-1','N9522K','1985-08-10','Flat No B-3, 1st Floor,','Adil Apartment, Block G,','North Nazimabad,','Karachi','','','','','m.sh.abbas@gmail.com','Murtaza Abbas Ali','0200D295913','2009-02-25','3987160-6','','','','Appointed as a teacher.','Abbas Ali','','2009-02-25','','2874','0','8003','','','0','Murtaza','Abbas Ali','0','','0','','','TRUE','3','','35','0','','4','Murtaza Abbas Ali','140869','2009-02-25','','Teacher',3),('631','Shaikh Huzaifa ','Yunus Fakhruddin','Rampurawala','0','Male','','','42301-3164917-3','I3167Q','1984-10-30','Plot No SB-1/75, Zubaida ','Palace, Kingham Market Lane,','Saddar,','Karachi','','','','','huz.unis@gmail.com','Huzaifa ','0200C262351','2009-02-25','3990313-3','','','','Appointed as a teacher','Yunus Fakhruddin','','2009-02-25','','1433','0','8004','','','0','Huzaifa','Yunus Fakhruddin','0','','0','','','TRUE','3','','36','0','','4','Huzaifa Yunus Fakhruddin','140866','2009-02-25','','Teacher',3),('632','Shaikh Moiz ','Mohammad Ali','Lakrawala','0','Male','502-84-878949','','42301-4970223-5','O9261M','1984-11-18','Flat No 3/3, Rafiq Plaza,','Lucky Star, Saddar,','','Karachi','','','','','moiz1118@gmail.com','Moiz ','0200F262340','2009-02-25','','','','','Appointed as a teacher','Mohammad Ali','','2009-02-25','','2871','0','0','','','0','Moiz','Mohammad Ali','0','','0','','','TRUE','3','','35','0','','4','Moiz Mohammad Ali','140865','2009-02-25','','Teacher',3),('635','Aliasgher ','Alihussain','Bhopalwala','0','Male','512-82-246747','','42101-0726917-1','ON4395','1982-03-06','Flat No 27, Qasr-e-Haidery,','Block E, North Nazimabad','','Karachi','','6636097','0332-3620550','','','Aliasgher','0200C295914','2009-02-01','','','Intermediate','','Appointed as Fitness Trainer teacher. Salary Rs 7,000. He is appointed as part time trainer. Referred by Shaikh Essa. Haidermota. His timing is 3pm to 6pm. He is in Khaimat Department.','Alihussain','','2009-02-01','','4480','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Ali Asghar Ali Hussain','165409','2012-02-01','','Swimming Coach',3),('636','Mulla Huzaifa','Kalimuddin','.','0','Male','502-00-773361','','42301-4092114-1','N129WB','1984-03-15','Flat No 8, 3rd Floor,','Irfan Manzil, City Court,','','Karachi','','','','','H.KALIMUDDIN@GMAIL.COM','Huzaifa Kalimudin','0200J262370','2008-07-03','','','','','Appointed as teacher.','Kalimuddin','','2008-07-03','','1452','0','0','','','0','Huzaifa','Kalimuddin','0','','0','','','TRUE','3','','37','0','','4','Huzaifa Kalimuddin','141867','2008-07-03','','Teacher',3),('637','Shaikh Taher','Shaikh Moiz','Galiakotwala','0','Male','513-85-124786','','42101-1624089-7','OM2B6Q','1985-07-07','Plot No SC-2, Flat No 204,','Kashana Arcade, Block C,','North Nazimabad,','Karachi','','','','','tahershmoiz@gmail.com','Taher','0200D262279','2009-02-25','3987413-3','','','','Appointed as a teacher','Shaikh Moiz','','2009-02-25','','3584','0','0','','','0','Taher','Shaikh Moiz','0','','0','','','TRUE','3','','36','0','','4','Taher Shaikh Moiz','141731','2009-02-25','','Teacher',3),('638','Rashida Zakir','Murtaza Zakir','Jupiterwala','0','Female','502-84-674977','','42101-1980373-6','N1X39C','1984-09-25','Flat No 29, Plot No 1,','Kandaala Building, ','Clifton Cantt,','Karachi','','35651725','0300-2732710','','','Rashida ','0200G334942','2016-12-01','','','M. Sc (Home Economics)','','Appointed as a teacher in Tadbeere Manzeli Department. Salary @ Rs 80 per period','Saleem Hussain','','2009-02-01','','4481','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Rashida Saleem Hussain','187144','2009-02-01','','Teacher',3),('638','Rashida Zakir','Murtaza Zakir','Jupiterwala','0','Female','502-84-674977','','42101-1980373-6','N1X39C','1984-09-25','Flat No 29, Plot No 1,','Kandaala Building, ','Clifton Cantt,','Karachi','','35651725','0300-2732710','','','Rashida ','0200G334942','2016-12-01','','','M. Sc (Home Economics)','','Appointed as a teacher in Tadbeere Manzeli Department. Salary @ Rs 80 per period','Saleem Hussain','','2009-02-01','','4481','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Rashida Saleem Hussain','187144','2009-02-01','','Teacher',3),('659','Ume Salama','Shaikh Murtaza ','Haryanawala','0','Female','51678488159','','42301-0480602-8','MK3864','1978-06-11','House No. 89/II Street No. 13','Khayaban-e-Shehar','DHA Phase 6','Karachi','','','0332-2375043','','','Ume Salama','0200J334907','2016-12-01','','','','','','Murtaza Haryanawala','','2009-05-04','','1233','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Umesalma Murtaza Haryanawala','187330','2017-09-01','','Teacher',3),('659','Ume Salama','Shaikh Murtaza ','Haryanawala','0','Female','51678488159','','42301-0480602-8','MK3864','1978-06-11','House No. 89/II Street No. 13','Khayaban-e-Shehar','DHA Phase 6','Karachi','','','0332-2375043','','','Ume Salama','0200J334907','2016-12-01','','','','','','Murtaza Haryanawala','','2009-05-04','','1233','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Ume Salama Shaikh Murtaza','187330','2009-11-01','','Teacher ',3),('659','Ume Salama','Shaikh Murtaza ','Haryanawala','0','Female','51678488159','','42301-0480602-8','MK3864','1978-06-11','House No. 89/II Street No. 13','Khayaban-e-Shehar','DHA Phase 6','Karachi','','','0332-2375043','','','Ume Salama','0200J334907','2016-12-01','','','','','','Murtaza Haryanawala','','2009-05-04','','1233','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Ume Salama Shaikh Murtaza','187330','2009-11-01','','Teacher',3),('660','Jumana Shabbir ','Shabbir Taher Ali','Motorwala','0','Female','51571298455','','42301-8769378-6','','1971-10-10','Blue Heavan Shahra-e-Iraq','Saddar Flat No. 303','Saddar ','Karachi.','','','0333-3346652','','','Jumana Shabbir','0200F295911','2013-11-01','','','','','','Shabbir Taher Ali','','2009-11-01','','4873','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Jumana Shabbir ','243939','2009-11-01','','Teacher',3),('660','Jumana Shabbir ','Shabbir Taher Ali','Motorwala','0','Female','51571298455','','42301-8769378-6','','1971-10-10','Blue Heavan Shahra-e-Iraq','Saddar Flat No. 303','Saddar ','Karachi.','','','0333-3346652','','','Jumana Shabbir','0200F295911','2013-11-01','','','','','','Shabbir Taher Ali','','2009-11-01','','4873','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Jumana Shabbir','243939','2009-11-01','','Teacher',3),('666','Shaikh Yousuf ','Shaikh Abdulqadir','Farhullah','0','Male','','','42301-6228831-3','','1969-01-12','House No 1, Zaini Manzil,','Mir Karam Ali Talpur Road,','Saddar, ','Karachi','','','','','yousufaf@attalim.net','Yousuf','0200F262366','2009-12-01','3860663-1','1','','','Transfered from Manchester to Attalim office Karachi.','Abdulqadir Farhullah','','2009-12-01','','1113','0','5007','','','0','Yousuf','Abdulqadir Farullah','0','','0','','','TRUE','1','','22','0','','2','Mr. Yousuf Abdulqadir','101707','2009-12-01','','Moallim',4),('668','Mulla Muder','Shabbir Hussain ','Sunailwala','0','Male','','','42301-0549059-7','J59X68','1986-11-06','House No 7, Zainab Manzil, ','Kangi Tilsi Das Street,','GPO, ','Karachi','','32210260','03312125506','','muder1275@gmail.com','Muder','0200J262299','2009-11-18','','','HSC','','Appointed as Teacher in QTM department. Salary Rs 8,000 from December 2009 and from Zilhaj1430.','Shabbir Hussain','','2009-11-18','','4601','0','0','','','0','','','0','','0','','','TRUE','3','','37','0','','4','Muder Shabbir Hussain','166456','2009-11-18','','Teacher',3),('670','Mulla Adnan','Hunaid','Godhrawala','0','Male','','','42101-9726563-1','M51X63','1988-11-23','Flat No 317, Al-Burhan Buildin','Block E, North Nazimabad','Haidery,','Karachi','','36671550','03362024880','','ismael552@gmail.com','Adnan Hunaid','0200A295916','2009-11-18','3988245-4','','HSC','','appointed as teacher in QTM department. Salary Rs 8,000 from Zilhaj 1430 and from December 2009.','Hunaid Hatim bhai','','2009-11-18','','3767','0','0','','','0','','','0','','0','','','TRUE','3','','37','0','','4','Adnan Hunaid','164693','2009-11-18','','Teacher',3),('671','Mulla Houzaifa','Mohammad Asgharali','Halai','0','Male','.','.','42301-1456580-9','MV5R96','1988-10-22','Flat No 4B-S, Tayeb Ali & ','Ismailjee Building, ','Saddar,','Karachi','','35677629','03323075392','','huzefasmh@gmail.com','Houzaifa','0200E262294','2009-11-18','','','HSC','','appointed as teacher in QTM department. Salary Rs 8,000 from Zilhaj 1430 and from December 2009.','Mohammad Asgharali','','2009-11-18','','4775','0','2001','','','0','Houzaifa','Mohammad Asgharali','0','','0','','','TRUE','3','','37','0','','4','Huzaifa Mohammad Asghar Ali','164687','2009-11-18','','Teacher',3),('674','Mustafa','Feroze','Mandasorewala','0','Male','','','42101-0723497-3','MP3457','1990-02-22','Flat No 14, Ali Rehan Square, ','Block G, North Nazimabad,','','Karachi','','','03343897336','','','Mustafa Feroze','0200I262371','2010-01-15','','','Matric','Technician','Appointed as a technician in Masakin department. Salary Rs 7,000.','Feroze','','2010-01-15','','5036','0','0','','','0','','','0','','0','','','FALSE','1','','42','0','','7','Mustafa Feroze','169575','2013-09-01','','Technician',4),('674','Mustafa','Feroze','Mandasorewala','0','Male','','','42101-0723497-3','MP3457','1990-02-22','Flat No 14, Ali Rehan Square, ','Block G, North Nazimabad,','','Karachi','','','03343897336','','','Mustafa Feroze','0200I262371','2010-01-15','','','Matric','Technician','Appointed as a technician in Masakin department. Salary Rs 7,000.','Feroze','','2010-01-15','','5036','0','0','','','0','','','0','','0','','','FALSE','3','','42','0','','7','Mustafa Feroz','169575','2013-09-01','','Technician',3),('682','Maria ','Aun Mohammad Hussain','Nikobarwala','0','Female','502-80-873123','','42101-1457672-6','MJ6J60','1980-04-17','House No C-304, 3rd Floor,','al-Burhan Building, Haidery,','North Nazimabad,','Karachi','','','03002191459','','','Maria Aun','','','','','Graduate','','appointed as teacher in Tadreebe Manzeli. Skill work of sketching, origami and crystal work. Referred by Shaikh Mustafa Fazalabbas.','Aun Mohammad Hussain','','2010-01-01','','5109','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','Maria Aun Mohammad Hussain','','2010-01-01','','Teacher',3),('683','Quaidjohar','Ibrahim','Chittalwala','0','Male','502-91-082844','','42000-0539586-9','I4B07T','1972-12-06','House No 18, Block E, ','Barkat-e-Haidery, ','North Nazimabad,','Karachi','','','03452127215','','','Quaidjohar','','','','','','','Appointed in Tadreebe Fanni department as electrician. Referred by Shaikh Mustafa Fazalabbas bhai','Ibrahim bhai','','2010-01-01','','4789','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','Quaidjohar Ibrahim','','2010-01-01','','Teacher',3),('685','Sabina ','Hussain','Halai','0','Female','515-61-209308','','42000-0438804-2','L0X2LR','1961-12-22','House No 10, Shujauddin Manzil','Willington Street,','Saddar,','Karachi','','32783210','03333055407','','','Sabina Halai','','','','','BSC','','Appointed as a teacher in Manahij Talimiyah department. Referred by Shaikh Qutubkhan Kothari.','Hussain bhai','','2010-01-26','','426','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Sabina Halai Hussain','174880','2010-01-26','','Teacher',3),('686','Rashida ','Najmuddin','Kankaroliwala','0','Female','516-90-374617','','42101-1259409-4','L0707Y','1966-01-01','House No B-103, Block C,','North Nazimabad,','','Karaci','','','03362496692','','','Rashida Najmuddin','0200D262287','2010-02-03','','','Bcom','','Appointed as a Receptionist in Zawayah department. Referred by Shaikh Shabbir Haji. Salary Rs 5,000.','Najmuddin','','2010-02-03','','5107','0','0','','','0','','','0','','0','','','FALSE','3','','43','0','','7','Rashida Najmuddin','174878','2010-02-03','','Librearian',3),('689','Samina ','Nooruddin','Karimi','0','Female','502-76-8694377','','42101-5198457-0','OB1K00','1976-04-29','House No D-7, Block C,','Barakat-e-Haidery,','North Nazimabad,','Karachi','','36674014','03453034753','36635966','','Samina','0200B296238','2010-03-10','','','Bachelor of Commerce','','Appointed as teacher in period basis. Rs 175 per period. Referred by Shaikh Qutubkhan Kothari.','Nooruddin','','2010-03-10','','5262','0','0','','','0','','','0','','0','','','FALSE','3','','61','0',' ','7','Samina Nooruddin','183945','2010-03-10','','Teacher',3),('690','Arif Hussain','Mulla Mohammad Hussain','Mama','0','Male','508-86-177441','','42301-1973691-5','IP6S2Z','1968-05-28','1st Floor, Flat No 2,','al-Hussaini Building, ','Faiz Mohammad Fateh Ali Road, ','Karachi','','','03002407052','','','Arif Hussain','0200J295917','2010-03-03','','','B. Com','','Appointed as swimming coach. Salary Rs 15,000. Referred by Shaikh Essa Haidermota','Mulla Mohammad Hussain','','2010-03-03','','5263','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Arif Husain Mulla Mohammad','183964','2012-02-01','','Swimming Coach',3),('694','Feroze Khan','Rahim Gul','.','0','Male','','','42301-7890695-3','','1953-01-01','House No 254, City Railway','Station,','','Karachi','','','','','','Feroze Khan','','','','','','','Appointed as gatekeeper in auditorium. He is in place of Fareenzada. His salary Rs 8,000.','Rahim Gul','','2010-04-01','','5267','0','0','','','0','','','0','','0','','','FALSE','3','','66','0','','7','Feroze Khan Rahim Gul','178042','2010-04-01','','Watchman',3),('699','Shaikh Mustafa','Shaikh Haider Ali','Jack','0','Male','515-86-096938','','42301-7785582-3','O7G8M3','1967-01-01','Husami Masjid,','ST-4, Block C,','Haidery, North Nazimabad,','Karachi','','','','','smjack052@yahoo.com','Mustafa','0200H295919','2010-05-14','2612844-6','1','','','Appointed as Aamil in Mohammadi Mohallah Soldier Bazar from 1st Jamadil Akhar 1431. Wazifa Rs 30,000. Transfer to AFrica from Shaban 1435.','Haider Ali','','2010-05-14','','1804','0','1502','','','0','Mustafa','Haiderali','0','','0','','','FALSE','3','','35','0','','4','Mustafa Haiderali','189347','2018-05-01','','Teacher',3),('715','Sughra bai','Abdul Ghani','.','0','Female','507-61-214551','','42301-3698511-6','J35R39','1961-01-01','House No 3, Maooji Building,','3rd Floor, Kalbanji Stret, ','Ranchoreline,','Karachi','','','','','','Sughra bai','0200A262345','2010-08-01','','','','','appointed as maasi in attalim department. She is in place of Nadir Khan. Her salary is Rs 4,000.','Abdul Ghani','','2010-08-01','','5482','0','0','','','0','','','0','','0','','','FALSE','1','','22','0','','2','Mrs. Sughra bai Abdul Ghani','198094','2010-08-01','','Maasi',4),('717','Shaikh Taher','Shaikh Ebrahim','Rasheed','0','Male','','G-9595786','','','1950-02-15','Husami Masjid, ST-4,','Block C, Haidery,','North Nazimabad, ','Karachi','','','','','shaikhtaher@gmail.com','Taher bhai Shaikh Ebrahim bhai','Foreigner','','3792697-7','','','','Appointed as Moavin Aamil Saheb AMB. Wazifa Rs 23,000.','Shaikh Ebrahim bhai','','2010-05-01','06-Jun-13','5493','0','2200','','','0','Taher bhai','Shaikh Ebrahim bhai','0','','0','','','FALSE','1','','16','11','','21','Mr. Taher bhai Shaikh Ebrahim ','198706','2010-05-01','','Aamil Husami Masjid',4),('724','Mulla Yousuf','Nisar Ahmed ','Jamali','0','Male','','','42301-5392192-3','O9T4S1','1986-12-03','House No 111, Tawakal Mansion,','Bilasis Road,','','Karachi','','','','','yusuf.katib@gmail.com','Yousuf Nisar','0200D262300','2010-09-01','3990446-6','','','','','Nisar Ahmed','','2010-09-01','','5580','0','0','','','0','Yousuf Nisar','Nisar Ahmed','0','','0','','','TRUE','3','','36','0','','4','Yousuf Nisar','205145','2010-11-01','','Teacher',3),('725','Mulla Juzer','Shaikh Saifuddin ','Halai','0','Male','','','42101-3697768-1','O07Z7L','1986-09-26','Flat No 5, Najmi Manzil,','Block C, North Nazimabad.','','Karachi','','','','','juzerhalai52@gmail.com','Juzer','0200F262293','2010-11-01','3987746-9','','','','','Mulla Saifuddin','','','','5579','0','0','','','0','Juzer','Mulla Saifuddin','0','','0','','','TRUE','3','','35','0','','4','Juzer Mulla Saifuddin','204240','2010-11-01','','Teacher',3),('735','Mohammad Ali','Premjee','.','0','Male','512-77-333418','','42301-0858371-1','IS7206','1977-09-10','Flat No 607, Chandni Arcade,','AlFreed Street, ','Garden West,','Karachi','','','','','','Mohammad Ali','0200A262361','1997-08-01','','','','','Old employee No 149.','Premjee','','2010-10-01','','5643','0','0','','','0','','','0','','0','','','FALSE','3','','44','0','','7','Mohammad Ali Premji','196466','2010-10-01','','Peon',3),('744','Batool','Mustafa','Khambatwala','0','Female','','','42101-9330688-0','N8Z1BC','1988-07-13','House No A-151, Block C,','North Nazimabad,','','Karachi','','34226119','03062178465','','','Batool Mustafa','0200D295921','2010-10-01','','','Intermediate','','Appointed as office attendant. She is in place of Shahida Sakina. Timing 10.30am to 12.30pm. Salary Rs 5,000. Referred by Nematullah baisaheb.','Mustafa','','2010-10-01','','4785','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','0','Batool Mustafa','','2010-10-01','','Teacher',3),('744','Batool','Mustafa','Khambatwala','0','Female','','','42101-9330688-0','N8Z1BC','1988-07-13','House No A-151, Block C,','North Nazimabad,','','Karachi','','34226119','03062178465','','','Batool Mustafa','0200D295921','2010-10-01','','','Intermediate','','Appointed as office attendant. She is in place of Shahida Sakina. Timing 10.30am to 12.30pm. Salary Rs 5,000. Referred by Nematullah baisaheb.','Mustafa','','2010-10-01','','4785','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','Batool Mustafa','','2010-10-01','','Office Attendant',3),('746','Fakhruddin','Abbas bhai','partabgarhwala','0','Male','508-92-114052','','42301-0887167-3','KV182D','1955-01-01','House No 9, Alvi Trust Bldg','Chakiwara No 2, Liyari,','Near Tauhidi Masjid,','Karachi','','37089052','03432227552','','','Fakhruddin','0200B262360','2011-01-18','','','','','Appointed as a warden in place of Waliji akbarali. Salary Rs 7,000. Night Shift timing.','Abbas bhai','','2011-01-18','','5804','0','0','','','0','','','0','','0','','','FALSE','3','','50','0','','7','Fakhruddin','243937','2011-01-18','','Warden',3),('747','Abbas Ali','Nooruddin','Godhrawala','0','Male','502-81-944583','','42000-0365948-3','K9726J','1981-01-25','Room No 23, Qasr-e-Fakhruddin','Block E, Barakat-e-Haidery,','North Nazimabad,','Karachi','','36624515','03082402152','','','Abbas Ali','0200I262282','2011-01-12','','','Intermediate','','Appointed as an arabic typist. Salary Rs 6,500. 8am to 5pm. Referred by Muder bhaisaheb','Nooruddin bhai','','2011-01-12','','4064','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Abbas Ali','243915','2011-01-12','','Arabic Typist',3),('755','Mohammad Kashif','Abdulghaffar','.','0','Male','','','31201-6859819-7','59334M','1983-12-07','Qadirabad, Dakhana ','Uchersharif, Tehsil Ahmedpur,','District','Bahawalpur','','','03082112615','','','Mohammad Kashif','0200B262352','2011-02-01','','','Middle','','Appointed as a electrician helper. Salary Rs 7,000. He is in place of Allah Buksh. Referred by Shaikh Taherali Ramakdawala.','Abdulghaffar','','2011-02-01','','5951','0','0','','','0','','','0','','0','','','FALSE','3','','42','0','','7','Mohammad Kashif','243940','2011-02-01','','Electrician Helper',3),('762','Sakina','Hussain','Wakhanairwala','0','Female','513-87-001901','','42000-0490382-4','JOX2NX','1947-05-21','E-25, Block E, Haidery','Memorial Market, North','Nazimabad,','Karachi','','','03002813352','','','Sakina Hussain','Above Age','','','','BA','','Appointed as warden in new Rabwatjibla banglow. Salary Rs 4,000. Referred by Nematullah baisaheb. Timing full day.','Hussain bhai','','2011-02-07','','5454','0','0','','','0','','','0','','0','','','FALSE','3','','46','0','','7','Sakina Hussain','246679','2011-02-07','','Warden',3),('763','Sakina','Quaidjohar','Bhanpurwala','0','Female','','','42101-3331067-4','M5R8BN','1992-05-12','House No A-142, Block C,','North Nazimabad,','','Karachi','','36674494','03323418360','','','Sakina','0200B295923','2011-02-09','','','Intermediate','','Appointed as a computer operator in Mahmal Talebaat department. Salary Rs 5,500. Referred by Nematullah baisaheb. Timing 5pm to 10pm.','Quaidjohar','','2011-02-09','','5993','0','0','','','0','','','0','','0','','','FALSE','3','','44','0','','7','Sakina Quaidjohar','246693','2011-02-09','','Computer Operator',3),('770','Mohammad Irfan','Pannu','.','0','Male','','','42301-8703126-1','OQ41MY','1990-07-19','House No 275, Street No 5,','Azam Town,','','Karachi','','','','','','Mohammad Irfan','0200I295926','2011-06-01','','','','','Appointed as a mali in attalim office from 01/06/2011. He is in place of Naeem Abbas. Salary Rs 5,000. Now salary increased to Rs 11,000 from 01/11/2011.','Pannu','','2011-06-01','','6091','0','0','','','0','','','0','','0','','','FALSE','1','','22','0','','2','Mr. Mohammad Irfan Pannu','254690','2011-06-01','','Mali',4),('773','Mariyah','Hussain','Bhinderwala','0','Female','','','42101-3069642-2','M65C6Z','1986-10-07','House No A-386, Block C,','Haidery, North Nazimabad,','','Karachi','','','03333045852','','','Mariyah Hussain','','','','','Graduation','','Appointed as a embriodery teacher in TadbereManzeli department. Salary Rs 120 per hour. Referred by Nematullah baisaheb.','Hussain','','2011-02-06','','6100','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','0','Mariyah Hussain','','2011-02-06','','Teacher',3),('774','Huzefa bhai','Nooruddin bhai','Maimoon','0','Male','','','42101-1600310-7','L902J6','1982-05-02','C-12, Block C, Haidery,','North Nazimabad,','','Karachi','','','03008217190','','huzzi2u@yahoo.com','Huzefa','','','','','','','appointed as Muavin Aamil Karachi. Wazifa Rs 23,000 from Rajab 1432.','Nooruddin bhai','','2011-06-01','31-Aug-13','2979','0','0','','','0','Huzefa','Nooruddin bhai','0','','0','','','FALSE','1','','16','1','','21','Mr. Huzefa Nooruddin bhai','255450','2011-06-01','','Moavin Aamil Karachi',4),('780','Qutbuddin ','Ali Hussain ','Mandasorewala','0','Male','502-55-067032','','42101-1896317-1','O2V81X','1956-01-01','House No 34, Block E, Yaqoob','Market, Haidery,','North Nazimabad,','Karachi','','','03122008250','','','Qutbuddin','0200C295930','2011-09-20','','','Matric','','Appointed as a plumber in siyanat department. Salary Rs 9,000. Referred by Sh Taherali Ramakdawala.','Ali Hussain','','2011-09-20','','6295','0','0','','','0','','','0','','0','','','FALSE','3','','42','0','','7','Mr. Qutbuddin Ali Hussain','287037','2011-09-20','','Plumber',3),('784','Rashida','Shaikh Qutubkhan','Kothari','0','Female','.','.','42000-9991807-2','JOP7T4','1987-10-02','Flat No 1, Najmi Manzil,','ST-4, Block C, ','North Nazimabad,','Karachi','','','03333271522','','opal52@hotmail.com','Rashida','0200A295932','2011-09-21','','','Fiqiul Jayyad','','Apppointed as a teacher.','Qutubkhan Kothari','','2011-09-12','','6338','0','2002','','','0','Rashida','Qutubkhan Kothari','0','','0','','','FALSE','3','','38','0','','4','Rashida Qutub Khan Kothari','315414','2016-08-01','','Teacher',3),('784','Rashida','Shaikh Qutubkhan','Kothari','0','Female','.','.','42000-9991807-2','JOP7T4','1987-10-02','Flat No 1, Najmi Manzil,','ST-4, Block C, ','North Nazimabad,','Karachi','','','03333271522','','opal52@hotmail.com','Rashida','0200A295932','2011-09-21','','','Fiqiul Jayyad','','Apppointed as a teacher.','Qutubkhan Kothari','','2011-09-12','','6338','0','2002','','','0','Rashida','Qutubkhan Kothari','0','','0','','','FALSE','3','','53','0','','7','Rashida Qutub Khan Kothari','315414','2017-09-01','','Teacher',3),('786','Mohammad Younus','Nawas Khan','.','0','Male','','','15101-6441280-1','VZ5R5K','1985-01-01','Chanal Dakhana,','Nagrai, ','Tehsil Dagar, District','Bunair','','','','','','Mohammad Younus','0200J295933','2011-11-01','','','','','Appointed as a driver with Naeem bhaisaheb. He is in place of Naik Mohammad Khan, which was going on leave for 4 months. His salary Rs 13,000.','Nawas Khan','','2011-11-01','','6353','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Mohammad Younus Nawas Khan','290395','2011-11-01','','Driver',4),('788','Fatema ','Asgarali','Kesaria','0','Female','','F1231367','','','1976-10-06','ST-8, Block C,','Al-Jameatus Saifiyah, ','North Nazimabad,','Karachi','','','03212029819','','','Fatema Asgarali Kesaria','','','','','B.Com','','Appointed as a teacher in Tadbirul Manzeli. Salary @ Rs 120 per period. Referred by Nematullah baisaheb.','','','','','6367','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','Fatema Asgarali Kesaria','','2011-10-01','','Teacher',3),('793','Khayal Nawab Syed','Habib Syed','.','0','Male','','','13502-5315195-9','S1B3DN','1988-01-01','Madakhail, Mera Madakhail, ','Dakhana, New Darband,','Tehsil Kaladhaka, District','Mansehra','','','03463110081','','','Khayal Nawab Syed','0200F295937','2012-01-01','','','Nil','','Appointed as a gatekeeper in Seminar Hall. Timing from 7pm to 7am. Salary Rs 8,050. He is in place of Gul Nawab Khan.','Habib Syed','','2012-01-01','','6312','0','0','','','0','','','0','','0','','','FALSE','3','','66','0','','7','Khayal Nawab Syed Habib Syed','303818','2012-01-01','','Gatekeeper',3),('796','Hussain','Abbas bhai','Jamnagarwala','0','Male','502-23-680821','','42101-1776595-1','L3K4JO','1972-02-15','House No 21, 3rd Floor, Iqbal','Market, Block G, Haidery,','North Nazimabad,','Karachi','','','03333417704','','','Hussain','0200E295938','2012-01-14','','','Intermediate','','Appointed as a karate instructor. Salary Rs 4,000. Referred by Shaikh Essa bhai. Timing 5pm to 5.30pm','Abbas bhai','','2012-01-14','','6481','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Hussain Abbas bhai','313551','2012-01-14','','Karate Instructor',3),('797','Sohail Parvaiz','Niyat Khan','.','0','Male','750-81-212744','','42101-0492123-9','LD9W96','1981-10-10','House No A-14, Allied Centre,','Gulbahar No 1,','','Karachi','','','03125285566','','','Sohail Parvaiz','','','','','Nil','Eobi not deducted because another Job at Citi School.','Appointed as a football coach. Salary Rs 8,000. Referred by Shaikh Essa bhai. Timing 4.30pm to 5.30pm. ','Niyat Khan','','2012-01-01','','5955','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Sohail Parvaiz','312543','2012-01-01','','Football Coach',3),('798','Zohair','Enayat Hussain ','Barnegarwala','0','Male','502-93-810590','','42101-1384830-1','L425KC','1973-12-16','Flat No 17, Block E, Saifee','Building, Barkat-e-Haidery,','North Nazimabad,','Karachi','','','03009275322','','','Zohair','','','','','Intermediate','','Appointed as a Sports Coach. Salary Rs 10,000. Referred by Shaikh Essa bhai. Timing 4.30pm to 5.30pm.','Enayat Hussain','','2012-01-01','','6090','0','0','','','1001','','','0','','0','','','FALSE','3','','59','0','','7','Zohair Enayat Hussain','312420','2012-01-01','','Sports Coach',3),('813','Hatim bhaisaheb','Naeem bhaisaheb','Burhani','0','Male','.','.','42301-2899047-9','JX6S0V','1987-11-30','House No D-69, Kehkashan,','Block 5, Clifton,','','Karachi','','','','','hatim5152@gmail.com','Hatim Mohyuddin','0200D295939','2011-11-06','3990292-7','','','','Appointed as a teacher in tadrees department. Salary Rs 20,000 from Zilhaj 1432.','Naeem Mohyuddin','','2011-11-06','','6482','0','10007','','','0','Hatim Mohyuddin','Naeem Mohyuddin','0','','0','','','TRUE','3','','34','0','','4','Hatim Mohyuddin Naeem Mohyuddi','308489','2011-11-06','','Teacher',3),('816','Rahimullah','Khyber','.','0','Male','','','15701-0698508-1','UV9577','1993-12-05','Flat No D-272, Umer Farooq ','Colony, Block Q,','North Nazimabad,','Karachi','','','03462238792','','','Rahimullah ','0200A295940','2012-02-01','','','Nil','','Appointed as a gatekeeper in C-59 Masakin Banglow. Salary Rs 8,000. Timing 9am to 9pm.','Khyber','','2012-02-01','','6535','0','0','','','1002','','','0','','0','','','FALSE','3','','41','0','','7','Rahimullah Khaibar','315513','2013-10-01','','Gate Keeper New Talebaat Class room',3),('829','Farida','Shaikh Moiz','Noorani','0','Female','502-71-926973','','42000-0490244-2','NY4Y0D','1971-07-07','House No 4, Yousufi Manzil,','ST-4, Block C,','North Nazimabad,','Karachi','','','03343065263','','','Farida','0200H295943','2012-01-14','','','','','Appointed as a teacher in Tadberul Manzeli. Salary Rs 120 per period. ','Moiz Noorani','','2012-01-14','','5762','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','Farida Moiz Noorani','','2012-01-14','','Teacher',3),('838','Taher bhaisaheb','Shaikh Kumail bhaishaeb','.','0','Male','','','42301-9857294-9','N210RV','1984-08-24','House No 100/II, Khayaban-e-','Sehar, Phase VI, DHA,','Street 14,','Karachi','','','03008221052','','taherpk@gmail.com','Taher Kumail','','','2981158-9','','','','Appointed a executive in Dawat-e-Hadiyah. Salary Rs 85,000 from March 2012.','Kumail Yunus','','2012-03-01','','6590','0','0','','','0','Taher','Kumail','0','','0','','','TRUE','1','','24','0','','12','Mr. Taher Kumail','007505','2012-03-01','','Executive',4),('840','Mulla Houzaifa','Nooruddin','Saintmarrywala','0','Male','','','42201-5595116-9','O20L5F','1986-08-21','House No B-1, Jamali Square,','Shabbirabad, Ahmed Shah Road','Block A,','Karachi','','','03322350609','','huzstmary@gmail.com','Houzaifa','0200G295944','2011-10-01','','','Faqiul Jawwyed','','Appointed as a teacher from Zilqad 1432. Salary Rs 20,000 per month.','Nooruddin','','2011-10-01','','3123','0','0','','','0','Houzaifa','Nooruddin','0','','0','','','TRUE','3','','35','0','','4','Houzaifa Nooruddin','336898','2011-10-01','','Teacher',3),('842','Abdulqadar bhai','Nooruddin bhaisaheb','Maimoon','0','Male','','','42101-0751479-5','L902J6','1985-12-09','House No C-12, Al-Naeem,','Block C, Haidery,','North Nazimabad,','Karachi','','','03333894996','','anz_52@yahoo.com','Abdulqadar','0200F295945','2012-05-01','4366763-5','','','','Appointed as a Aamil in Saifee Mohallah from Rajab 1433. Wazifa Rs 30,000.','Nooruddin','','2012-05-01','','6683','0','0','','','0','Abdulqadar','Nooruddin','0','','0','','','FALSE','1','','16','2','','21','Mr. Abdulqadar Nooruddin','339772','2014-06-01','','Aamil Burhani Nagar Hyderabad',4),('850','Shaikh Idrees','Abbas Ali','Jamnagarwala','0','Male','515-85-113638','','42301-5569173-5','L89D72','1966-08-03','House No B-406, Al-Jauhar','Mansion, Block A,','North Nazimabad,','Karachi','','','03115521152','','shkidris@gmail.com','Idrees Badri','0200E295946','2012-07-19','3620258-4','','','','Appointed as a Masool-ul-Mooze in Abbotabad from Ramazan 1433. Wazifa Rs 23,000.','Abbas Ali','','2012-07-19','','3015','0','0','','','0','Idrees','Abbas Ali','0','','0','','','TRUE','1','','16','11','','21','Mr. Idrees Abbas Ali','623416','2017-04-01','','Moavin Aail Saheb Husami Masjid',4),('854','Gulzar Shah','Gulimarshah','.','0','Male','','','42401-6163161-9','J6Z731','1994-02-03','House No D-2/26, New Haji','Camp, Sultanabad,','M. T. Khan Road,','Karachi','','','','','','Gulzar Shah','0200C295948','2012-07-01','','','','','Appointed as a office peon. Salary Rs 9,000.Rs 2,000 increased in his salary as per Taher bs instruction to do cleaning work in admin block from May 2013.','Gulimar Shah','','2012-07-01','','6775','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Gulzar Shah Gulimar Shah','364349','2012-07-01','','Office Peon',4),('868','Shaikh Faizan','Shaikh Mohyuddin','.','0','Male','','','42401-5011104-7','I9B6G3','1992-03-28','House No L-1310,','Surgani Town, Sector 4-A,','','Karachi','','0315215401','03242172673','','','Shaikh Faizan','0200H295951','2012-09-01','','','Matroic','','Appointed as a hardware engineer in computer department. Salary Rs 9,000. He is in place of Hussain Saleem. Referred by Shaikh Ali Asghar Shaikh Abdulhussain Bhinderwala','Shaikh Mohyuddin','','2012-09-01','','6860','0','0','','','1006','','','0','','0','','','FALSE','3','','41','0','','7','Shaikh Faizan Shaikh Mohyuddin','373704','2012-09-01','','Hardware Engineer',3),('871','Shaikh Hatim','Qurban Hussain ','Khumusi','0','Male','','G 8342768','','','1946-03-05','Flat No. 8 D/20 Block C','North Nazimabad ','Haidery ','Karachi','','','','','','Hatim Qurban Hussain','','','4027751-8','','','','','Qurban Hussain Abdul Qayum','','2012-08-01','','6917','0','0','','','0','Hatim Qurban Hussain','Qurban Hussain Abdul Qayum','0','','0','','','TRUE','3','','35','0','','4','Hatim Qurban Hussain','371411','2012-08-01','','Teacher',3),('872','Mulla Shabbir ','Saifuddin','Rampurawala','0','Male','','','42000-4313420-7','I6P1Y0','1988-10-27','House No 9, Soldier Bazar,','Baitul Shabbir,','','Karachi','','','03343885074','','shabbirpia52@gmail.com','Shabbir','0200F295953','2012-10-01','','','','','','Saifuddin','','2012-10-01','','6952','0','0','','','0','Shabbir','Saifuddin','0','','0','','','TRUE','3','','37','0','','4','Shabbir Saifuddin','703670','2012-11-01','','Teacher',3),('873','Mulla Houzaifa','Shamsheer Hussain','Godhrawala','0','Male','','','42101-3171216-7','I44J13','1986-05-29','Flat No a-23, Al-Sabah','Apartment, North Nazimabad,','','Karachi','','','03312491252','','huzaifashamsheer@gmail.com','Houzaifa Shamsheer','0200E295954','2012-10-01','','','','','','Shamsheer Hussain','','2012-10-01','','6953','0','0','','','0','Houzaifa Shamsheer','Shamsheer Hussain','0','','0','','','TRUE','3','','37','0','','4','Houzaifa Shasheer','377412','2012-11-01','','Teacher',3),('874','Shaikh Idrees ','Shaikh Shoaib ','Haidery','0','Male','','','42101-0361938-7','NF7V9R','1983-03-28','Flat No 205 Ezzi Manzil,','Block E, North Nazimabad,','Haidery Memorial Market,','Karachi','','','03332147525','','ishaidry@gmail.com','Idrees Haidery','0200D295955','2012-09-01','','','','','','Shoaib Ghulam Hussain Haidery','','2012-09-01','','6954','0','0','','','0','Idrees Haidery','Shoaib Ghulam Hussain','0','','0','','','TRUE','3','','35','0','','4','Idrees Haidery ','385096','2012-09-01','','Teacher',3),('875','Shaikh Murtaza','Shaikh Quresh','Haidery','0','Male','502-83-770458','','42101-0360988-7','K391GW','1983-05-13','Flat No L-345, Al-Burhan','Arcade, Block E, North ','Nazimabad,','Karachi','','','03312491372','','mqhaidry@gmail.com','Murtaza Haidery','0200C295956','2012-09-01','','','','','','Quresh','','','','6955','0','0','','','0','Murtaza Haidery','Quresh','0','','0','','','TRUE','3','','35','0','','4','Murtaza shoaib s/o Shoaib Ghul','385099','2012-09-01','','Teacher',3),('876','Mulla Ali Asghar','Saifuddin','Lamuwala','0','Male','','','42301-2288532-3','N6V6RC','1987-08-08','Saifee House, 2nd Floor, ','Flat No 2-A, Syedna Mohammad','Burhanuddin Road, Saddar,','Karachi','','','03123040952','','alilamu@gmail.com','Ali Asghar Saifuddin','0200B295957','2012-10-01','','','','','','Saifuddin','','2012-10-01','','2876','0','0','','','0','Ali Asghar Saifuddin','Saifuddin','0','','0','','','TRUE','3','','35','0','','4','Ali Asghar Saifuddin','385100','2012-10-01','','Teacher',3),('880','Mohammad Jawaid','Maroof Gul','.','0','Male','','','42401-7786216-1','U2X5SM','1988-04-14','House No D2-25, M. T. Khan','Road, Sultanabad,','','Karachi','','','03123332736','','','Mohammad Jawaid','0200A295958','2012-12-07','','','8th Class','','Appointed as a office peon in admin block. Referred by Maroof Gul. Salary Rs 10,000. Rs 2,000 increased in his salary as per Taher bs instruction to do cleaning work in admin block from May 2013.','Maroof Gul','','2012-12-07','','6969','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Mohammad Jawaid','389523','2012-12-07','','Peon',4),('892','Mulla Hasnain','Aftab Hussain','Kothari','0','Male','512-82-244853','','42301-0960290-9','OS8Z8N','1982-10-18','House No 19, Burhani Manzil, ','Haqqani Chowck, ','Tayebjee Road,','Karachi','','','03002111352','','','Hasnain','0200a296239','2012-12-14','','','MBA','','Appointed as a teacher in Manahij Talimiyah. Salary Rs 200 per period. Referred by Shaikh Quresh Saifuddin.','Aftab Hussain','','2012-12-24','','2315','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Hasnain Mustafa','400158','2013-01-01','','Teacher',3),('893','Kamran','Mohammad Mehmood','.','0','Male','','','42201-8860337-1','O53588','1981-06-12','House No 1, Street No 10,','36-C Area,','Landhi','Karachi','','','','','','Kamran','0200F295961','2013-01-01','','','Primary','','Appointed as a Mason Helper in siyanat department. Salary Rs 9,000. Referred by Shaikh Taherali Ramakdawala. He is in place of Late Mohammad Shakeel.','Mohammad Mehmood','','2013-01-01','','7056','0','0','','','1009','','','0','','0','','','FALSE','3','','42','0','','7','Kamran Mohammad Mehmood','400012','2013-01-01','','Mason Helper',3),('899','Houzaifa ','Shabbir Hussan','Shaikhbhaiwala','0','Male','','','42301-6918353-1','KB630S','1983-12-20','Flat No 3, 2nd Floor,','Asia Manzil, Siddiq Wahab Road','Jinnahabad,','Karachi','','','03323082352','','','Houzaifa','0200D295963','2013-02-01','','','Bcom','','Appointed as a accountant in Amanatuljamea department. Salary Rs 11,000. Referred by Muder bhaisaheb. Timing 8.30am to 5.30pm. ','Shabbir Hussain','','2013-02-01','','7109','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Houzaifa Shabbir Hussain ','405639','2013-02-01','','Accountant Amanat.',3),('902','Fatema baisaheb','Hatim bhaisaheb','Mohyuddin','0','Female','','Z2472900','','','1989-05-16','House No D-69, Block 5,','Kehkashan,','Clifton,','Karachi','','','','','fatemath52@gmail.com','Fatema Taha Hakimuddin','','','','','','','Appointed as a teacher in Al-Jameatus Saifiyah. Wazifa Rs 17,250 per month from Zilqad 1433.','','','','','7114','0','0','','','0','','','0','','0','','','FALSE','3','','34','0','','4','Fatema Mohyuddin','401219','2012-10-01','','Teacher',3),('912','Mulla Hussain','Imraanally','Bagasrawala','0','Male','','N2699636','','','1989-06-29','Flat No 303, Najmi Building,','Block C, North Nazimabad,','ST-4,','Karachi','','','03352111553','','hussain.imran52@gmail.com','Hussain ','','','4284746-0','','','','Appointed as a teacher. Wazifa Rs 20,000 from Jamadil Awwal 1434.','Imraanally','','','','7212','0','0','','','0','Hussain','Imraanally','0','','0','','','TRUE','3','','35','0','','4','Mr. Hussain Imraanally','422101','2013-03-01','','Teacher',3),('917','Mulla Hatim ','Shaikh Esmail','Hussein','0','Male','','03967968','','','1989-06-27','Al-Jameatu Saifiyah, ST-8,','Block C, North Nazimabad,','','Karachi','','','03472883852','','hatimsauti@gmail.com','Hatim Esmail Hussein','','','4283728-6','','','','Appointed as a teacher. Wazifa Rs 20,000 from Jamadil Awwal 1434.','Esmail Hussein','','','','7255','0','0','','','0','Hatim','Esmail Hussein','0','','0','','','TRUE','3','','35','0',' ','4','Hatim Ismail Hussain','426622','2013-03-01','','Teacher',3),('918','Nafisa ','Juzer ','Ratlamwala','0','Female','502-74-174741','','42301-0956541-4','J3P728','1974-02-19','House No 41, Mohammadi ','Apartment, Block G,','North Nazimabad,','Karachi','','','03002442276','','','Nafisa Juzer','','','','','Intermediate','','Appointed as a teacher in Tadbeere Manzeli. Salary Rs 120 per hour. Referred by Nematullah baisaheb.','Juzer','','','','7256','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','Nafisa Juzer','','2013-01-01','','Teacher',3),('920','Shaikh Saifuddin ','Shaikh Alihussain ','Adeeb','0','Male','502-59-455707','','42000-0483934-7','KC6Q9P','1959-08-03','House No 9, 3rd Floor,','Ghosia Centre, ','Soldier Bazar No 1,','Karachi','','','','','','Saifuddin Adeeb','0200D295971','2013-05-01','0256746-6','','','','Appointed as a Masoolul mooze at Quetta from Rajab 1434. Wazifa Rs 30,000. He is in place of Shaikh Yahya Nooruddin Multanwala.','Mulla Alihussain Adeeb','','2013-05-01','','951','0','0','','','0','Saifuddin Adeeb','Mulla Alihussain Adeeb','0','','0','','','TRUE','1','','16','2','','21','Mr. Saifuddin Adeeb Alihussain','100105009','2016-05-01','','Aamil Multan',4),('921','Mulla Hussain ','Asghar Abbas','Lokhandwala','0','Male','','','42000-1640544-5','I1M98M','1988-05-14','Flat No 8, Qasr-e-Saifee,','Block E, North Nazimabad,','','Karachi','','','03343025052','','','Haseeb','0200C295972','2013-05-01','','','','','Appointed as a Aamil in Ibrahim Mohallah from Rajab 1434.','Asghar Abbas','','2013-05-01','','7259','0','0','','','0','Haseeb','Asghar Abbas','0','','0','','','FALSE','1','','16','12','','21','Mr. Haseeb Asghar Abbas','430286','2013-05-01','','Moavin Aamil Saheb Mohallah Mohammadiyah',4),('921','Mulla Hussain ','Asghar Abbas','Lokhandwala','0','Male','','','42000-1640544-5','I1M98M','1988-05-14','Flat No 8, Qasr-e-Saifee,','Block E, North Nazimabad,','','Karachi','','','03343025052','','','Haseeb','0200C295972','2013-05-01','','','','','Appointed as a Aamil in Ibrahim Mohallah from Rajab 1434.','Asghar Abbas','','2013-05-01','','7259','0','0','','','0','Haseeb','Asghar Abbas','0','','0','','','FALSE','3','','133','0','','9','Haseeb Asgher Abbas','430286','2017-09-01','','Teacher',3),('922','Shaikh Taizoon','Shaikh Shoaib','Haidery','0','Male','508-76-354630','','42101-7126170-7','KR542Y','1976-02-11','Essa Masjid, Nanakwada,','Mohammad Shah Street,','','Karachi','','','03424520152','','tshaidry@hotmail.com','Taizoon Shoaib Haidery','020-OD-175016','2002-05-01','0855208-8','','','','Appointed as a Aamil in Essa Mohallah from Rajab 1434.','Shoaib Ghulam Hussain Haidery','','2013-05-01','31-May-15','7261','0','0','','','0','Taizoon Shoaib Haidery','Shoaib Ghulam Hussain','0','','0','','','FALSE','1','','16','1','','21','Mr. Taizoon Shoaib Haidery','427200','2013-05-01','','Aamil Essa Masjid',4),('926','Yousuf Din','Saleh Din','.','0','Male','145-89-205431','','14201-2134233-5','V8X2Y1','1971-01-01','Mardan Khail, Dakhana','Eesak Khamari, ','Tehsil Banda Dawood Shah','Karak','','','','','','Yousuf Din','0200I296176','2013-11-27','','','','','Appointed as a driver of Nematullah baisaheb. Salary Rs 10,900. Rejoin as Kumail saheb driver from 27/11/2013. Salary Rs 11,000 conveyance Rs 1,000 and lunch Rs 3,000. Overtime Rs 40 per hour.He will be on leave for his susar death from 2/4/15 to 2/6/2015','Saleh Din','','2013-11-27','28-Feb-17','7288','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Yousuf Din Saleh Din','430863','2013-11-27','','Driver',4),('928','Behlool','Fakhruddin','Khambatwala','0','Male','502-80-800139','','42101-8347698-3','JP5V68','1980-03-18','1st Floor, Adeel Manzil, Z/159','Flat No 2, Amir Khusroo Road,','','Karachi','','','03003561052','','','Behlool','0200J295975','2013-05-01','','','BCS','','Appointed as a web developer in tanzeem office. Salary Rs 15,000. Referred by Muder bhaisaheb. Rejoined as a Computer Programmer Dated: 1-10-2017 at Tanzeem Office. Salary Rs. 25,000/-. Referred by Shaikh Tayyeb Shaikh Zoeb Tinwala','Fakhruddin','','2013-05-01','','1252','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Behlool Fakhruddin','436036','2013-05-01','','Web Developer',3),('936','Mulla Ibrahim','Shaikh Zoeb','Lokhandwala','0','Male','','','42301-9747880-5','KZ6D91','1987-10-14','House No 5, Jami Estate,','Clifton Block 8,','','Karachi','','','03333166505','','lokhandwala.ibrahim45@gmail.com','Ibrahim Lokhandwala','0200G295978','2013-08-01','','','Faqeeh','','Appointed as a audio video photography in Mahaduzahra department. Salary Rs 14,040. ','Zoeb Lokhandwala','','2013-08-01','','5644','0','0','','','0','','','0','','0','','','TRUE','3','','36','0','','4','Ibrahim Lokhandwala','215133','2013-08-01','','Audio Video Photography',3),('937','Mulla Mustafa','Fakhruddin','Anjarwala','0','Male','','','42000-1385405-5','O9Y14P','1989-09-09','Flat No A-14, Fayz-e-Husayni','Building, Babae Urdu Road,','','Karachi','','','03313933425','','anjari470@gmail.com','Mustafa','0200F295979','2013-08-01','','','','','Appointed as a teacher from Shawwal 1434. Wazifa Rs 20,000.','Fakhruddin','','2013-08-01','','7461','0','0','','','0','Mustafa','Fakhrudin','0','','0','','','TRUE','3','','35','0','','4','Mustafa Fakhruddin','452813','2013-08-01','','Teacher',3),('938','Mulla Ammar','Mulla Taher','Wajihi  Madarwala','0','Male','','','41302-6721872-9','N01M42','1990-01-28','House No 365/1-2, Bohri Bazar,','Saddar, ','Hyderabad Cantt,','Hyderabad','','','03233657221','','ammarvajihi@gmail.com','Ammar Taher','0200C295980','2013-08-01','','','','','Appointed as a teacher from Shawwal 1434. Wazifa Rs 20,000.','Taher Ali','','2013-08-01','','7462','0','0','','','0','Ammar Taher','Taher Ali','0','','0','','','TRUE','3','','35','0','','4','Ammar Taher Taher Ali','452812','2013-08-01','','Teacher',3),('939','Fatema','Khuzaima','Jackwala','0','Female','512-75-289158','','42301-0750972-0','NM2T71','1975-04-14','1st Floor, Flat No 112, Saifee','Foundation, Saddar,','Mansfield Street','Karachi','','','03313632063','','','Fatema Khuzaima','0200B295981','2013-08-15','','','MA','','She is appointed as a office attendant in C-32/C. Referred by Shakh Taherali Ramakdawala. Salary Rs 9,000.','Khuzaima','','2013-08-15','','7559','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Fatema Khuzaima','460713','2013-08-15','','Office Attendant',3),('941','Noman ','Mohammad Irshaad','.','0','Male','','','42101-5560988-7','I11455','1992-06-27','Plot No 14, KDA Colony, ','Block C, North Nazimabad,','Haidery','Karachi','','','03422451689','','','Noman','0200A295982','2013-08-06','','','Matric','','Appointed as a peon in Marhalat 4. Salary Rs 8,000. Referred by Shaikh Taherali Ramakdawala.','Mohammad Irshaad','','2013-08-06','','7554','0','0','','','0','','','0','','0','','','FALSE','1','','41','0','','0','Noman Mohammad Irshaad','','2013-08-06','','Peon Marhalat ',4),('942','Bezur Khan','Ali Zar','.','0','Male','','','13601-0486771-9','U6412Z','1994-01-01','Paranjal Madakhail,','Newdarband Dakhana','District Tehsil','Torghar','','','03428937371','','','Bezur Khan','0200J295983','2013-09-01','','','Middle','','Appointed as a Peon in Rabwatjibla. Salary Rs 8,500. Referred by Qeemat Shah. ','Ali Zar','','2013-09-01','','7558','0','0','','','0','','','0','','0','','','FALSE','1','','46','0','','0','Bezur Khan Ali Zair','','2013-09-01','','Peon',4),('943','Tasneem ','Abid Hussain','Mandasorewala','0','Female','502-74-705333','','42101-1509313-0','KQ3Z4S','1974-09-04','Flat No B-4, Saifee Nagar','1st Floor, Lawrance Road,','','Karachi','','','03362496522','','','Tasneem','0200I295984','2013-09-01','','','Matric','','Appointed as a liabrarian. Salary Rs 4,280. Referred by Shaikh Moiz bhai Noorani.','Abid Hussain','','2013-09-01','','7556','0','0','','','0','','','0','','0','','','FALSE','1','','43','0','','0','Tasneem Abid Hussain','','2013-09-01','','Liabrarian',4),('944','Rehmat Gul','Zafar Khan','.','0','Male','','','42101-7476805-3','KR0T0C','1993-06-20','House No KESC 2162,','Paharghanj Colony,','Block Q,','Karachi','','','03433233592','','','Rehmat Gul','0200H295985','2013-09-01','','','8th Passed','','Appointed as a gatekeeper (day) in Masakin. Salary Rs 8,500. Referred by Shaikh Essa bhai','Zafar Khan','','2013-09-01','','7557','0','0','','','0','','','0','','0','','','FALSE','1','','50','0','','0','Rehmat Gul Zafar Khan','','2013-09-01','','Gatekeeper',4),('945','Yousuf','Feroze','Mandasorewala','0','Male','','','42101-7972660-3','MP3457','1987-11-21','House No 14, Ali Rehana Square','Block G, North','Nazimabad, Haidery,','Karachi','','','03222634905','','','Yousuf Feroze','0200G295986','2013-09-01','','','FSC','','Appointed as a hardware engineer. Salary Rs 10,000. Referred by Shaikh Ali Asghar Shaikh Abdulhussain Bhinder.','Feroze','','2013-09-01','','7554','0','0','','','0','','','0','','0','','','FALSE','1','','41','0','','0','Yousuf Feroze','','2013-09-01','','Hardware Engineer',4),('945','Yousuf','Feroze','Mandasorewala','0','Male','','','42101-7972660-3','MP3457','1987-11-21','House No 14, Ali Rehana Square','Block G, North','Nazimabad, Haidery,','Karachi','','','03222634905','','','Yousuf Feroze','0200G295986','2013-09-01','','','FSC','','Appointed as a hardware engineer. Salary Rs 10,000. Referred by Shaikh Ali Asghar Shaikh Abdulhussain Bhinder.','Feroze','','2013-09-01','','7554','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Yousuf Feroz','460709','2013-09-01','','Hardware Engineer',3),('956','Abdeali','Shabbir Hussain','Multanwala','0','Male','','','42101-5498615-3','K0M99D','1992-07-12','Flat No 20, Qasr-e-Saifee,','Barakat-e-Haidery,','North Nazimabad,','Karachi','','','03462819852','','','Abdeali','0200G295994','2013-10-01','','','Intermediate','','Appointed as a office attendant. Salary Rs 7,500. Referred by Mulla Moiz Lakdawala.','Shabbir Hussain','','2013-10-01','','7625','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Abdeali Shabbir Hussain','466570','2013-10-01','','Office Attendant',3),('957','Safdar Nazar','Mohammad Nazar','.','0','Male','','','42401-7920677-5','J4C25G','1982-04-17','House No F-734,','Manghopir Road,','','Karachi','','','','','','Safdar Nazar','0200b296246','2013-09-27','','','','','Appointed as a rickshaw driver for Burhani Mahal office work. Salary Rs 11,000. Referred by Ali Sher Abdul Hameed.','Mohammad Nazar','','2013-09-27','','7628','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Safdar Nazar MohammadNazar','467812','2013-09-27','','Driver',4),('962','Liaquat','Mohammad Suleman','.','0','Male','502-90-075191','','42101-6304902-9','O2074Y','1955-01-01','House No 10, Nishter Colony,','Block C,','North Nazimabad','Karachi','','','03135635932','','','Liaquat','','','','','Middle','','Appointed as a rickshaw driver in Al-Jameatus Saifiyah. Salary Rs 9,000. Timing 8am to 5pm. ','Mohammad Suleman','','2013-11-15','','7631','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Liaquat Mohammad Suleman','481834','2013-11-15','','Rickshaw Driver',3),('965','Nafisa','Shaikh Hatim','AlKhumusi','0','Male','','J1648873','','','1949-01-01','Mohammadi Manzil,','D-20, Block C,','North Nazimabad','Karachi','','','','','','Nafisa Mulla Hatim AlKhumusi','Foreigner','','','','','','Appointed as a teacher in Tadbeerul Manzeli department. Salary @ Rs 120 in cooking department.','','','2013-08-15','','7713','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Nafisa Mulla Hatim','371411','2013-12-15','','Teacher',3),('967','Zainab','Houzaifa','Badri','0','Female','','','42101-4504833-4','JB2D75','1988-09-03','House No 202, Block C, ','Najmi Manzil, Haidery,','North Nazimabad,','Karachi','','36672841','03323420121','','','Zainab Houzaifa','0200I334908','2016-12-01','','','Graduate','','Appointed as a teacher in Tadbere Manzili. Salary Rs 4,000. Appointed as a office attendant. She is in place of Batool Mustafa. Referred by Nematullah baisaheb.','Houzaifa Ilyas','','2013-12-21','','7762','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Zainab Huzaifa Huzaifa Ilyas','491407','2017-09-01','','Teacher',3),('967','Zainab','Houzaifa','Badri','0','Female','','','42101-4504833-4','JB2D75','1988-09-03','House No 202, Block C, ','Najmi Manzil, Haidery,','North Nazimabad,','Karachi','','36672841','03323420121','','','Zainab Houzaifa','0200I334908','2016-12-01','','','Graduate','','Appointed as a teacher in Tadbere Manzili. Salary Rs 4,000. Appointed as a office attendant. She is in place of Batool Mustafa. Referred by Nematullah baisaheb.','Houzaifa Ilyas','','2013-12-21','','7762','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Zainab Houzaifa','491407','2016-12-01','','Office Attendant ',3),('967','Zainab','Houzaifa','Badri','0','Female','','','42101-4504833-4','JB2D75','1988-09-03','House No 202, Block C, ','Najmi Manzil, Haidery,','North Nazimabad,','Karachi','','36672841','03323420121','','','Zainab Houzaifa','0200I334908','2016-12-01','','','Graduate','','Appointed as a teacher in Tadbere Manzili. Salary Rs 4,000. Appointed as a office attendant. She is in place of Batool Mustafa. Referred by Nematullah baisaheb.','Houzaifa Ilyas','','2013-12-21','','7762','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Zainab Houzaifa','491407','2016-12-01','','Teacher',3),('971','Shaikh Juzer','Shaikh Yousuf','Noorani','0','Male','','Z2143354','','','1977-04-24','Bohra Masjid, Anjuman-e-Saifee','Mission Road, 58-A,','','Lahore','','','03356667264','','juzar.mandviwala@gmail.com','Juzar Yusuf','Foreigner','','4341130-4','','','','Appointed as a Masoolul Mooze in Lahore. He is in place of Shaikh Mustafa Akhter Hussain.','Yusuf Karim bhai','','2014-02-01','','7768','0','0','','','0','Juzar Yusuf','Yusuf Karim bhai','0','','0','','','TRUE','1','','16','1','','21','Mr. Juzer Yusuf','540271','2014-02-01','','Masoolul Mooze Qutbi Masjid Modelcolony',4),('973','Jameel Ahmed','Mohammad Ramzan','.','0','Male','','','42101-4656779-3','L0G30W','1988-05-05','House No 393, Street No 2,','Block Q, Paharghanj Colony, ','North Nazimabad,','Karachi','','','03048350017','','','Jameel Ahmed','0200E301967','2014-03-01','','','8th','','Appointed as a peone in Tanzeem Office. SalaryRs 9,000. Referred by Shaikh Hassan bhai. He is in place of Azam Khan. Timing 8am to 5.30pm','Mohammad Ramzan','','2014-03-01','','7812','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Jameel Ahmed Mohammad Ramzan','504235','2014-03-01','','Peon',3),('975','Mohammad Faroq','Mohammd Fareed','.','0','Male','','','13501-7546541-9','VS9M3X','1991-01-01','Mattikot, Balakot','Dakhana Balakot,','District','Mansehra','','','03222872683','','','Mohammad Farooq','0200A301898','2013-10-10','','','Middle','','Appointed as a peon in New Buildng Burhani Bagh. Salary Rs 9,500. Referred by Mulla Abizer Hussain bhai. Timing 9am to 9pm.','Mohammad Fareed','','2013-10-10','','7814','0','0','','','0','','','0','','0','','','FALSE','3','','104','0','','7','Mohammad Farooq','502677','2013-10-10','','Peon',3),('983','Rehman Safdar','Sadbar Khan','.','0','Male','502-93-1051506','','42101-4310515-7','K1712R','1995-10-05','House No 272, Street No 3,','Umar Farooq Colony, Block Q','North Nazimabad,','Karachi','','','0300213639','','','Rehman Safdar','0200I305577','2014-04-01','','','Matric','','Appointed as a photocopy machine operator. Salary Rs 9,000. Referred by his father Safdar Khan. Timing 8am to 5pm.','Sadbar Khan','','2014-04-01','','7863','0','0','','','0','','','0','','0','','','FALSE','3','','50','0','','7','Khaista Al Rehman Sadbar Khan','520410','2014-04-01','','Photocopy machine operator',3),('984','Murtaza','Shabbir','Kaka','0','Male','502-81-961759','','42000-0460300-9','L129BY','1981-11-20','Flat No 009, Burhani Bagh','Block E,','North Nazimabad,','Karachi','','','03422088854','','','Murtaza Shabbir','0200D303457','2014-04-01','','','B. Pharmacy','','Appointed as a compounder in Mahalushifa Department. Salary Rs 10,000. Referred by Shaikh Essa bhai. Timing 8am to 5pm.','Shabbir Hussain','','2014-04-01','','7864','0','0','','','0','','','0','','0','','','FALSE','3','','49','0','','7','Murtaza Shabbir','509967','2014-04-01','','Compounder',3),('985','Mohammad Zahiruddin Babar','Abdul Rehman','.','0','Male','','','42101-9062607-3','JpC39B','1994-09-07','Mohallah Ibrahimi Masjid,','Block A,','North Nazimabad,','Karachi','','','03069117574','','','Mohammad Zahiruddin Babar','0200E303456','2014-04-01','','','5th Class','','Appointed as a electrician helper. Salary Rs 8,000. Referred by Shaikh Taherali Ramakdawala. Timing 8hours.','Abdul Rehman','','2014-04-01','','7865','0','0','','','0','','','0','','0','','','FALSE','3','','42','0','','7','Mohammad Zahiruddin Babar','509968','2014-04-01','','Electrician Helper',3),('992','Imdad Hussain','Manzoor Hussain ','Rajpur','0','Male','','','45201-7897606-3','L9P0X0','1989-07-04','Goth Latho Khan Rajpur,','Tapal Ghar, Daryakhan Maree,','Faizghang, District','Khairpur','','','03023207094','','','Imdad Hussain','0200j305534','2014-05-01','','','Intermediate','','Appointed as a watchman in Hatimi Manzil. Salary Rs 9,000. Referred by Shaikh Saifuddin Halai., Timing 24hours. He is in place of Mohammad Hashim.','Manzoor Hussain Rajpur','','2014-05-01','','7907','0','0','','','0','','','0','','0','','','FALSE','3','','112','0','','7','Imdad Hussain Manzoor Hussain','517159','2014-05-01','','Gate Keeper',3),('994','Mohammad Waqar Raza','Saleem Raza','.','0','Male','','','42301-9934077-5','K8G9YK','1989-10-11','House No 1, Block 7,','City Railway Colony,','','Karachi','','03062913366','03462014022','','','Mohammad Waqar Raza','0200A305533','2014-05-20','','','Intermediate','','Appointed as a operator in admin block Dawat office. Salary Rs 14,000. Referred by Syed Waqar Ahmed Jafferi. He is on probition for 6 months.','Saleem Raza','','2014-05-20','','7922','0','0','','','0','','','0','','0','','','FALSE','1','','17','0','','10','Mr. Mohammad Waqar Raza ','517770','2014-05-20','','Telephone Operator',4),('998','Husein bhaisaheb','Shaikh Kumail bhai','Tyebjee','0','Male','','','42301-5982929-3','N211RQ','1985-10-30','House No 100/II, Khayaban-e-','Sehar, Phase VI, DHA,','Street No 14','Karachi','','','','','husainpk@gmail.com','Husein Kumail','','','2981169-4','','','','','Kumail','','2013-10-01','','7970','0','0','','','0','Husein','Kumail','0','','0','','','TRUE','1','','24','0','','12','Mr. Husein Kumail','007506','2013-10-01','','Executive',4),('1004','Mohammad','Aziz','Sunailwala','0','Male','','','42301-7993425-3','','1990-10-28','Flat No 1, 1st Floor','Zehra Manzil, Plot No S-B-1-21','Saddar','Karachi','','','','','m.aziz5152@gmail.com','Mohammad','0200A308337','2014-08-01','7195159-1','','','','Appointed as a software and Web Developer in Dawat office. Salary Rs 30,000. Referred by Taher bs.','Aziz','','2014-08-04','','8061','0','0','','','0','','','0','','0','','','TRUE','1','','17','0','','10','Mr. Mohammad Aziz','539657','2014-08-04','','Web Developer',4),('1005','Samina ','Fakhruddin','Multanwala','0','Female','508-63-329384','','42301-6245501-4','','1963-01-01','Flat No 39, 3rd Floor','Bhujwala Building, Thattai','Compound, Light House,','Karachi','','','03343575151','','','Samina','0200E308464','2014-08-01','','','Matric','','Appointed as a warden in Rabwatjibla. Salary Rs 4,600. REferred by Nematullah baisaheb. She is in place of Nafisa Zainuddin.','Fakhruddin','','2014-08-01','','8062','0','0','','','0','','','0','','0','','','FALSE','3','','46','0','','7','Samina Fakhruddin','540206','2014-08-01','','Warden',3),('1006','Mulla Houzaifa','Ali Kausar','Udaipurwala','0','Male','','','42101-1955281-7','I0N8RS','1991-04-14','Flat No 106, Samar Pride,','Block E, North Nazimabad','Haidery','Karachi','','36624288','03003378652','','huzaifa1523@gmail.com','Houzaifa','0200B308459','2014-08-01','','','','','Appointed as a Teacher. Wazifa start from Shawwal 1435. Wazifa Rs 20,000.','Ali Kausar','','2014-08-01','','7368','0','0','','','0','','','0','','0','','','TRUE','3','','35','0','','4','Houzaifa Ali Kausar','540204','2014-07-28','','Teacher',3),('1007','Shaikh Taher','Shaikh Shabbir','Haji','0','Male','','','42101-0322474-3','M593CD','1985-09-14','House No 2, Najmi Manzil,','Barakat-e-Haidery,','North Nazimabad,','Karachi','','','03323735152','','taher2251@gmail.com','Taher','0200I308460','2014-08-01','','','FJ','','Appointed as a Teacher. Wazifa Rs 32,023 from Shawwal 1435.','Shabbir bhai','','2014-07-28','','3585','0','0','','','0','Taher','Shabbir Bhai','0','','0','','','TRUE','3','','35','0','','4','Taher Shabbir bhai','540207','2014-07-28','','Teacher',3),('1009','Fatema','Mulla Juzer','Marzaban','0','Female','','','54400-4704523-8','Q3275F','1991-06-18','House No A4, Saryab Road,','GSP Officer Colony,','','Quetta','','','03313645234','','fatmarzban@gmail.com','Fatema Juzer Marzaban','0200G308462','2014-08-01','','','','','Appointed as a Ustaad from Shawwal 1435. Wazifa Rs 20,000.','Juzer Marzaban','','2014-07-28','','8063','0','0','','','0','','','0','','0','','','TRUE','3','','38','0','','4','Fatema Juzar Marzbanwala','540308','2016-08-01','','Teacher',3),('1018','Mustafa bhaisaheb','Jaffer bhaisaheb','Zaini','0','Male','502-67-322491','','42101-3288478-3','','1967-12-08','Flat No 13, Haidery Compound, ','Block E, North Nazimabad','Haidery','Karachi','','','03243241272','','','Mustafa Jaffer bhai Surti','0200A309359','2014-09-01','1609747-5','','BA','','Appointed as a incharge procurement helpdisk in siyanat department. Salary Rs 30,000. Referred by Muder bhaisaheb.','Jaffer Abbas bhai Surti','','2014-09-01','','7485','0','0','','','0','','','0','','0','','','TRUE','3','','42','0','','7','Mustafa Jaffer Bhai Surti','547536','2014-09-01','','Incharge Procurement Helpdesk',3),('1023','Khalid Masih','Boota Masih','.','0','Male','287-87-384841','','42101-7691679-7','KX0F0L','1967-01-01','House No K-502,','Kausar Niyazi Colony, Block F,','North Nazimabad,','Karachi','','','','','','Khalid Masih','0200H309360','2014-09-01','','','Nil','','Appointed as a sweeper in siyanat department. Salary Rs 5,000. Referred by Shaikh Taher Ali Ramakdawala. He is in place of Hakim Masih.','Boota Masih','','2014-09-01','','1968','0','0','','','0','','','0','','0','','','FALSE','3','','42','0','','7','Khalid Masih','553542','2014-09-01','','Sweeper',3),('1024','Zohair','Saifuddin ','Vasanwala','0','Male','502-64-804845','','42101-1593956-9','MQ7M26','1964-12-31','House No 18, Qasr-e-Fatema,','Barakat-e-Haidery, ','North Nazimabad,','Karachi','','','03442196527','','','Zohair','0200G309361','2014-09-01','','','Matric','','Appointed as a peon in Masakin Mohammadiyah. Referred by Shaikh Essa bhai. Salary Rs 9,000. Timing 8am to 8pm. He is in place of Rehmat Gul Employee No 944.','Saifuddin Yousuf Ali','','2014-09-01','','8126','0','0','','','0','','','0','','0','','','FALSE','3','','50','0','','7','Zohair Saifuddin Yousuf Ali','549387','2014-09-01','','Peon',3),('1028','Kalimullah','Mohammad Saleem','.','0','Male','','','42401-6164773-7','N40M7W','1991-11-15','House No D-408,','Al-Mustafa Colony,','Orangi Town, Sector 11-E','Karachi','','','03456018073','','','Kalimullah','0200D310331','2014-10-01','','','','','contract employee','Mohammad Saleem','','2014-09-01','','6878','0','0','','','0','','','0','','0','','','FALSE','3','','99','0','','7','Kalimullah Mohammad Saleem','551072','2014-07-01','','Painter',3),('1030','Mohammad Saleem','Shafqat Hussain','.','0','Male','','','42401-6606806-9','N40M7W','1958-01-01','Sector 11, House No D-408,','Mustafa Colony, Orangi Town E,','','Karachi','','','','','','Mohammad Saleem','0200B310333','2014-10-01','','','','','','Shafqat Hussain','','2014-07-01','','406','0','0','','','0','','','0','','0','','','FALSE','3','','99','0','','7','Mohamamd Saleem Shafqat Hussai','230391','2014-07-01','','Painter',3),('1031','Mohammad Munir','Mir Ahmed','.','0','Male','','','42401-4776070-1','T95W1V','1986-01-01','House No C-93,','Haidery','North Nazimabad,','Karachi','','','','','','Mohammad Munir','0200I310336','2014-10-01','','','','','','Mir Ahmed','','2014-07-01','','5916','0','0','','','0','','','0','','0','','','FALSE','3','','99','0','','7','Mohammad Munir Mir Ahmed','231653','2014-07-01','','Gardener Khaimat',3),('1033','Mustansir','Abdeali','Mahuwala','0','Male','502-93-1062029','','42101-5779898-9','','1996-09-16','Flat No A-6/8, Al-Hamra ','Square, Block E,','North Nazimabad,','Karachi','','','03363285102','','','Mustansir','0200B314670','2015-03-01','','','Intermeidate','','Appointed as a office attendant in Masakin Mohammadiyah. Salary Rs 9,000. Referred by Shaikh Essa bhai. Timing 8am to 6pm.','Abdeali','','2014-08-01','','8187','0','0','','','0','','','0','','0','','','FALSE','3','','50','0','','7','Mustansir Abdeali','565061','2014-08-01','','Office Attendent',3),('1034','Zainab','Hasnain','Burhanpurwala','0','Female','','','42101-7480571-8','O84L33','1988-01-08','House No C-30, Block C,','North Nazimabad','','Karachi','','','03333628387','','','Zainab Hasnain','','','','','MSC','','Appointment as a Nutritionist. Salary Rs 15,000. She is for 8 months.','Hasnain Jawaid','','2014-08-25','','8186','0','0','','','0','','','0','','0','','','FALSE','3','','47','0','','7','Zainab Hasnain','565062','2014-08-25','','Nutritionist',3),('1035','Rizwan Gul','Mohammad Gul','.','0','Male','','','42101-8346125-7','I4Z78Y','1995-08-10','House No D-165, Usman Ghani ','Colony, Block Q, ','North Nazimabad,','Karachi','','','03119214967','','','Rizwan Gul','0200C310340','2014-10-01','','','Matric','','Appointed as a peon in tanzeem office marhalat-2. Salary Rs 9,000. Referred by Shaikh Taher ali bha Ramakdawala. He is in place of Mohamamd Afzal. Timing 8am to 5pm.','Mohammad Gul','','2014-10-01','','8185','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Rizwan Gul Mohammad Gul','565059','2014-10-01','','Peon',3),('1041','Albert ','Baboo Riyaz','.','0','Male','','','42101-4676284-9','O68L11','1984-08-30','Plot No 1720, Paharghanj ','Colony, Block Q, ','North Nazimabad','Karachi','','','','','','Albert','0200C312457','2014-12-01','','','Nil','','Appointed as a sweeper in Asateza\'s Flat Building No 3. Salary Rs 10,000. He is in place of Waqif Shah. ','Baboo Riyaz','','2014-12-01','','2756','0','0','','','0','','','0','','0','','','FALSE','3','','112','0','','7','Albert Baboo Riyaz','568398','2014-12-01','','Sweeper Gardener',3),('1042','Wahid Shah','Sher Khan','.','0','Male','','','16102-1421770-5','V45C1X','1990-01-01','Gujarabad, Afzalabad,','Mandvi, Tehsil Takhtbhai,','District','Mardan','','','03443019224','','','Wahid Shah','0200F312462','2014-12-01','','','Middle','','Appointed as a night gatekeeper at Masakin Mohammadiyah. Salary Rs 9,000. Referred by Shaikh Essa bhai. He is in place of Mohammad Tariq Employee No 866. Timing 8pm to 8am.','Sher Khan','','2014-11-01','','8244','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Wahid Shah','571108','2014-11-01','','Gatekeper Night',3),('1043','Mulla Ibrahim','Mulla Abdeali','Gheewala','0','Male','','','42301-3330922-1','','1991-09-12','Flat No 15, Asif Centre,','Raja Ghazanfar Road,','Saddar,','Karachi','','','03333521152','','Ibrahim_ghee@hotmail.com','Ibrahim','0200H312460','2014-12-01','','','','','Appointed as a teacher from Shawwal 1436. Wazifa Rs 20,000.','Abdeali Gheewala','','2014-08-01','','8245','0','0','','','0','','','0','','0','','','TRUE','3','','37','0','','4','Ibrahim Abdeali','566788','2014-08-01','','Teacher',3),('1044','Baaz Mohammad','Shaikh Ahmed','.','0','Male','','','13501-9591708-9','S6Q56N','1964-01-01','Matti Coat, Dakhana Balakot,','Tehsil Balakot,','District','Mansehra','','','03218961632','','','Baaz Mohammad','0200I314673','2015-03-01','','','Middle','','Appointed as a gatekeeper and gardner. Salary Rs 9,000 as a gatekeeper and 6,000 as a gardner. Referred by Shaikh Essa bhai. Timing 24 hours.','Shaikh Ahmed','','2014-12-01','','8256','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Baaz Mohammad','571106','2014-12-01','','Gatekeper Gardner',3),('1045','Mulla Adnan','Mulla Aliasghar','Khumusi','0','Male','','','42000-4111368-3','KJ3J48','1990-12-13','House No A-2, Block C,','North Nazimabad,','','Karachi','','','','','akhumusi@gmail.com','Adnan','0200G312461','2014-12-01','','','','','Apppointed as a teacher in Tehfizul Quran Lilmumineen. Wazifa Rs 23,800 per month from Safar 1436.','Ali Asghar Alkhumusi','','2014-11-01','','6233','0','0','','','0','','','0','','0','','','TRUE','3','','37','0','','4','Adnan Ali Asghar ','272329','2014-12-01','','Teacher',3),('1047','Mulla Saleh','Mohammad','Jalebiwala','0','Male','','','42101-3380828-7','J714YM','1991-03-28','House No C-62, Block C,','North Nazimabad','','Karachi','','','','','','Saleh Mohammad','0200B312458','2014-12-01','','','','','','Mohammad Hussain','','2014-08-01','','7999','0','0','','','0','','','0','','0','','','TRUE','1','','24','0','','10','Mr. Saleh Mohammad','535624','2014-08-01','','Faizul Maweedul Burhaniyah',4),('1048','Mulla Houzaifa','Mulla Hassan ','Dahoodwala','0','Male','','','42101-9642251-9','OF7Q0P','1991-01-11','House No A-191, Block C,','North Nazimabad,','','Karachi','','','','','','Houzaifa Ali','0200A312459','2014-12-01','','','','','','Hassan Ali','','2014-08-01','','8037','0','0','','','0','','','0','','0','','','TRUE','1','','24','0','','10','Mr. Houzaifa Ali Hassan Ali','535625','2014-08-01','','Faizil Maweedul Burhaniyah',4),('1055','Amjad Ali','Mohammad Zaman ','Khan','0','Male','','','42101-3458722-3','','1995-01-12','Plot No B-242, Paharghanj','Colony, Block Q,','North Nazimabad,','Karachi','','','03142236403','','','Amjad Ali','0200I313740','2015-02-01','','','Matric','','Appointed as a lab attendant in Tanzeem Office. Salary Rs 9,500. Referred by Hussain Shabbir Ismail Bandrawala. Timing 9am to 6pm.','Mohammad Zaman Khan','','2015-01-26','','8446','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Amjad Ali Mohammad ','593816','2015-01-28','','Lab Attendent',3),('1063','Jumana','Shabbir Hussain','Lakdawala','0','Male','','','42101-1483617-4','O3L9MW','1973-03-20','Flat No 328, Al-Burhan','Building, Block E,','North Nazimabad,','Karachi','','','','','','Jumana','0200F313743','2015-02-01','','','','','Appointed in Khaimatul Riyazat. Salary Rs 15,000.','Shabbir Hussain','','','','8145','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Jumana Shabbir','566787','2015-01-01','','Swimming Coaches',3),('1064','Munira ','Moiz','Abbas Ali','0','Female','','','42201-0298991-4','N65N6L','1975-10-18','House No B-199, Block B','Shabbirabad, Syedna Tayyeb','Road, ','Karachi','','','','','','Munira','0200E313744','2015-02-01','','','','','','Moiz','','','','7892','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Munira Moiz','103162','2015-02-01','','Swimming Coache',3),('1065','Tasneem','Shaikh Mustafa','Mithaiwala','0','Female','','','42101-9427579-8','M448NG','1993-12-12','Flat No 101,','Yousufi Manzil, Block C,','North Nazimabad,','Karachi','','','','','','Tasneem','','','','','','','','Mustafa','','','','7891','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Tasneem Mustafa','526296','2015-02-01','','Tasneem Mustafa',3),('1070','Mohammad Mateen','Mohammad Yousuf','.','0','Male','103-711-035675','','42401-1056514-5','','1995-07-16','House No F-97/A, Qasba','Colony, Manghopir Road,','','Karachi','','','03111237065','','','Mohammad Mateen','0200C315421','2015-04-01','','','Matric','','Appointed as a office attendant in Khazana Aamera Department. Salary Rs 9,000. Referred by Shaikh Tayyab Jamali. He is in place of Mohammad Farhan. Timing 12pm to 8pm.','Mohammad Yousuf','','2015-04-01','','8540','0','0','','','0','','','0','','0','','','FALSE','3','','69','0','','7','Mohammad Mateen','609875','2015-04-01','','Office Attendent',3),('1071','Shaikh Ammar','Mohammad Hussain','Rasheed','0','Male','502-79-912190','','42000-0472337-9','','1979-07-20','Bohra Masjid, Anjuman-e-Badri','Gurdwara','','Abbotabad','','','','','ammarasheed@gmail.com','Ammar Mohammad Hussain','0200A317475','2015-06-01','','','','','Appointed as a Masoolul Mooze Abbotabad from Shaba 1436.','Mohammad Hussain','','2015-05-01','','1756','0','0','','','0','','','0','','0','','','TRUE','1','','16','2','','21','Mr. Ammar Mohammad Hussain','181657','','','Masoolul Mooze Abbotabad',4),('1072','Shaikh Taher Ali','Mulla Fazlehusain','Kapadia','0','Male','','K3790638','','','1956-01-13','Hasani Masjid, Kehkashan,','','Clifton','Karachi','','','','','','Shaikh Taher Ali Mulla Fazlehusain','Foreigner','','7127062-7','','','','Appointed as a aamil saheb clifton','Mulla Fazlehusain Abdulali Kapadia','','2015-05-01','','8582','0','0','','','0','','','0','','0','','','FALSE','3','','35','0','','4','Shaikh Taherali Mulla Fazal','655210','2018-05-01','','Teacher',3),('1078','Mulla Mohammad','Shaikh Yousuf','Anjarwala','0','Male','','','42301-5475346-3','L5N2V7','1985-07-29','Flat No 6/D, Riyaz & Kandawala','Building,','Clifton,','Karachi','','','','','','Mohammad','0200J317476','2015-06-01','','','','','appointed as a masoolul mooze in quetta from shaban 1436.','Yousuf Hussain','','2015-05-01','30-Jun-17','2141','0','0','','','0','','','0','','0','','','FALSE','1','','16','2','','21','Mr. Muhammad Yousuf Hussain','619411','2015-05-01','','Masoolul Mooze Quetta',4),('1086','Adam bhai','Juzer bhai','Zaini','0','Male','','','42301-4539169-9','J19J5Y','1991-03-14','House No 11/30','Bohra Masjid, ','Modelcolony, Saifee Market','Karachi','','','03127885152','','','Adam Juzer bhai','0200B319719','2015-07-01','','','Intermediate','','','Juzer Tayeb','','2015-07-01','','8649','0','0','','','0','','','0','','0','','','FALSE','1','','16','1','','21','Mr. Adam Juzer bhai','627220','','','Moavin Aamil Saheb Saifee Mohallah Chaki',4),('1088','Mulla Hussain','Saifuddin ','Mandviwala','0','Male','','','42301-6892319-1','','1992-05-18','Flat No 7, Haryanawala ','Building, Mansfield Street,','3rd Floor, Saddar,','Karachi','','','03318114521','','','Hussain ','0200C320858','2015-08-01','','','','','Appointed in Nazafat office from August 2015. Salary Rs 9,000. ','Saifuddin Hatim','','2015-08-01','','8390','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Hussain Saifuddin Hatim','988207','2017-09-01','','Teacher',3),('1097','Khalid Jawaid','Ashiq Ali','.','0','Male','149-88-190748','','12101-4430204-3','SG7V73','1970-01-01','House No 508, Street No 22,','Near Allahwali Masjid, ','Manzoor Colony, Sector H,','Karachi','','','03062618675','','','Khalid Jawaid','0200I323525','2015-11-01','','','Middle','','Appointed as a gardner in Najmi, Yousufi and Hatimi Manzil. Salary Rs 6,000. Referred by Shaikh Qusai Dewan.','Ashiq Ali','','2015-11-01','','6331','0','0','','','0','','','0','','0','','','FALSE','3','','112','0','','7','Khalid Jawaid','695263','2015-11-01','','Gardener',3),('1098','Mir Ahmed','Jumma','.','0','Male','123-88-397528','','13501-1339119-5','T95W1V','1962-07-06','Nagri Matti Kot,','Post Office, Balakot','District','Balakot','','','03132078290','','','Mir Ahmed','0200H323526','2015-11-01','','','Nil','','Appointed as a gatekeeper at Najmi Yousufi & Hatimi Building, Salary Rs 11,000. Referred by Shaikh Qusai Dewan.','Jumma','','2015-11-01','','8886','0','0','','','0','','','0','','0','','','FALSE','3','','112','0','','7','Mir Ahmed Jumma','698366','2015-11-01','','Gate Keeper',3),('1105','Mulla Dawood','Hussaini ','Mirza','0','Male','','','42000-8296789-5','JX5N6R','1992-01-08','Flat No 104, Babooje Pride','Plot No SC-6, Block C,','North Nazimabad','Karachi','','','03343752321','','dhmirza@gmail.com','Dawood','0200G324060','2015-12-01','','','','','Appointed as a teacher. Salary Rs 20,000 from Safar 1437.','Hussaini','','2015-12-01','','8908','0','0','','','0','','','0','','0','','','FALSE','3','','35','0','','4','Dawood Hussaini Mirza','704698','2015-11-01','','Teacher',3),('1106','Mulla Mustafa','Mohammad Hussain','Mandasorewala','0','Male','','','42101-2051278-7','','1992-06-06','House No B-113, Block C,','North Nazimabad,','','Karachi','','','','','mustafamm5253@gmail.com','Mustafa','0200F324061','2015-12-01','','','','','Appointed as a teacher from Safar 1437. Salary Rs 20,000.','Mohammad Hussain','','2015-12-01','','8909','0','0','','','0','','','0','','0','','','FALSE','3','','37','0','','4','Mustafa Mohammad Hussain','704699','2015-11-01','','Teacher',3),('1119','Mohammad','Zakir Hussain','Indorewala','0','Male','502-80-938585','','42101-6743833-5','JT9X69','1980-03-15','Flat No 107, Ezzi Bagh, ','Barakat-e-Haidery,','Block E, North Nazimabad','Karachi','','','','','','Mohammad ','0200J325924','2016-02-01','2850706-1','','','','for Ezzi Homes Burhani Nagar. Salary Rs 40,000.','Zakir Hussain','','2016-02-01','','7665','0','0','','','0','','','0','','0','','','TRUE','1','','21','0','','12','Mr. Mohammad Zakir ','1110-0981-004613-01-0','2016-02-01','','Ezzi Homes  Burhani Nagar',4),('1120','Murtaza','AbbasAli','Tiggiwala','0','Male','502-80-868679','','42101-7551104-5','J961NL','1980-01-07','House No A-105,','Burhani Bagh, Block E,','North Nazimabad,','Karachi','','','','','','Murtaza Abbas Ali','0200I325925','2016-01-01','2174604-4','','','','for Ezzi Homes Burhani Nagar. Salary Rs 40,000.','AbbasAli','','2016-02-01','','9011','0','0','','','0','','','0','','0','','','TRUE','1','','21','0','','12','Mr. Murtaza Abbas','1110-0981-004614-01-0','2016-02-01','','Ezzi Homes Burhani Nagar',4),('1124','Shad Mohammad','Shahjahan','.','0','Male','','','13501-1398122-5','S3D3PT','1988-01-01','Matti Kout, Dakhana','Balakot,','District','Mansehra','','','03112321620','','','Shad Mohammad','0200I326395','2016-03-01','','','8th','','appointed as a peon in khaimatul Riyazat. Salary Rs 10,000. Referred by Shaikh Essa bhai.','Shahjahan','','2016-03-01','','9066','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Shad Mohammad','751374','2016-03-01','','Chowkidar',3),('1131','Hunar Gul','Tor Khan','.','0','Male','510-51-011558','','42401-7462725-7','O7C8FL','1960-01-01','New Haji Camp, Street No 2,','Sultanabad,','','Karachi','','','','','','Hunar Gul','0200J327560','2016-04-01','','','Nil','','','Tor Khan','','','01-Oct-16','9090','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Hunar Gul Tor Khan','757667','2016-04-01','','Driver',4),('1132','Abdul Sher Khan','Raza Jan','.','0','Male','123-90-597463','','42000-2278453-7','N043N7','1972-08-14','House No 175, New Haji Camp,','Sultanabad, Near Ibrahim Masji','','Karachi','','','03003993094','','','Abdul Sher Khan','0200C327559','2016-04-01','','','','','','Raza Jan','','2016-04-01','31-Dec-16','19','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Abdul Sher Khan Raza Jan','768482','2016-04-01','','Driver',4),('1136','Juzer bhaisaheb','Abdullah bhaisaheb ','Zakavi','0','Male','','J3029049','','','1945-08-14','Taheri Masjid, Dr. Syedna','Mohammad Burhanuddin','Road, Saddar,','Karachi','','','','','','Juzer','Foreigner','','7355046-3','','','','Appointed as Aamil Saheb Karachi','Zakavi','','2016-05-01','','9125','0','0','','','0','','','0','','0','','','TRUE','1','','16','1','','21','Mr. Juzer Zakavi','878245','2016-05-01','','Aamil Saheb Karachi',4),('1137','Shabbir bhaisaheb','Abdeali bhaisaheb','Imadi','0','Male','','G8501774','','','1954-07-13','Husami Masjid, ST-4, Block C','Haidery, North Nazimabad,','','Karachi','','','','','','Shabbir Abdeali','Foreigner','','7290121-4','','','','Appointed as a Aamil Saheb AMB.','Imadi','','2016-05-01','','9126','0','0','','','0','','','0','','0','','','TRUE','1','','16','11','','21','Mr. Shabbir Abdeali Imadi','851439','2016-05-01','','Aamil Saheb Husami Masjid AMB',4),('1138','Yunus bhai bin','Hasan bhaisaheb','Zainuddin','0','Male','','Z3480455','','','1959-12-04','Yousufi Masjid, Syedna Idris','Road, Shabbirabad,','','Karachi','','','','','','Yunus Hasan bhai','Foreigner','','7335884-2','','','','','Zainuddin','','2016-05-01','','9129','0','0','','','0','','','0','','0','','','TRUE','1','','16','1','','21','Mr. Yunus Hasan bhai Zainuddin','880490','2016-05-01','','Aamil Saheb Yousufi Masjid',4),('1140','Murtaza bhai','Shabbir bhai','Zaini','0','Male','','','42000-9251382-7','8P52IZ','1989-12-03','Flat No 202, Najmi Manzil,','Block C, North Nazimabad,','','Karachi','','','','','','Murtaza Shabbir Zainuddin','0200E328553','2016-06-01','','','','','Appointed as a Aamil Saheb Jamali Mohallah UP More from Shaban 1437. Wazifa Rs 33,252.','Shabbir Jaffer Zainuddin','','2016-05-01','','9219','0','0','','','0','','','0','','0','','','TRUE','1','','16','2','','21','Mr. Murtaza Shabbir Zainuddin','803854','2016-05-01','','Aamil Lahore',4),('1147','Zeeshan ','Mohammad Irshad','.','0','Male','','','42101-7350284-5','I11455','1996-09-03','House No 14, Street No 1,','KDA Colony, Block C,','North Nazimabad,','Karachi','','','03421129028','','','Zeeshan ','0200I329076','2016-07-01','','','Matric','','Appointed as a peon in tanzeem office. Salary Rs 9,500. Referred by Shaikh Taherali Ramakdawala.','Mohammad Irshad','','2016-07-01','','9261','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Zeeshan Mohammad Irshad','815925','2016-07-01','','Tanzeem office',3),('1150','Mustafa Hussain','Manzoor Hussain ','Poonawala','0','Male','','','42201-5376664-1','NV8V04','1988-08-28','Flat No B-4, Jamani Square, ','Sultan Ahmed Shah Road,','','Karachi','','','03321378652','','mustafahussain1423@gmail.com','Mustafa Hussain','0200i333902','2016-11-01','','','','','Appointed in a Mahad Tehfeez. ','Manzoor Hussain','','2016-07-01','','7032','0','0','','','0','','','0','','0','','','FALSE','3','','35','0','','4','Mustafa Hussain','379874','2016-08-01','','Teacher',3),('1151','Moiz bhai','Houzaifa Tayeb bhai','Ezzi','0','Male','','','42101-7528207-9','M75M18','1991-02-12','Flat No J-4, M Y Square,','Block G,','North Nazimabad,','Karachi','','','03122008234','','mhbs786@hotmail.com','Moiz','0200C330007','2016-08-01','','','HSC II','','Appointed as a Musaid.','Houzaifa Tayeb','','2016-07-01','','8102','0','0','','','0','','','0','','0','','','FALSE','3','','35','0','','4','Moiz Houzaifa Tayeb','724399','2016-08-01','','Teacher',3),('1152','Munira','Aun Ali','Johar','0','Female','','','42101-1239117-6','K5P3RF','1989-02-12','Flat No 8, Hatimi Manzil','Block E, ','North Nazimabad','Karachi','','','03152752856','','munirajohar52@gmail.com','Munira Aun Ali','0200B330008','','','','Faqiul Jayyed','','Appointed in Tadrees Khidmat. ','Aun Ali','','2016-07-01','','7955','0','0','','','0','','','0','','0','','','FALSE','3','','38','0','','4','Munira Aun Ali','508908','2000-06-01','','Teacher',3),('1152','Munira','Aun Ali','Johar','0','Female','','','42101-1239117-6','K5P3RF','1989-02-12','Flat No 8, Hatimi Manzil','Block E, ','North Nazimabad','Karachi','','','03152752856','','munirajohar52@gmail.com','Munira Aun Ali','0200B330008','','','','Faqiul Jayyed','','Appointed in Tadrees Khidmat. ','Aun Ali','','2016-07-01','','7955','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Munira Aun Ali','508908','2017-09-01','','Teacher',3),('1153','Yaqoota','Saifuddin','Khambatwala','0','Female','502-77-862361','','42101-1715194-0','N6X4MV','1977-05-07','Flat No 002, Yousufi Manzil,','Block C, North Nazimabad,','','Karachi','','','03002052153','','yaqoota52@yahoo.com','Yaqoota Saifuddin','0200A330009','2016-08-01','','','Faqaul Jayyaed','','Appointed in Tadrees Khidmat.','Shabbir','','2016-07-01','','1064','0','0','','','0','','','0','','0','','','FALSE','3','','38','0','','4','Yaqoota Saifuddin','101756','2016-08-01','','Teacher ',3),('1154','Batool','Dawood','Mirza','0','Female','502-93-1101694','','42301-4895237-2','','1990-03-17','Flat No 6, Baboojee Arcade','Block C, North Nazimabad, ','Karachi','','','','03352130787','','bdmirza.53@gmail.com','Batool','','','','','Faqiul Jayyed','','Appointed in Tadrees Khidmat','Dawood','','2016-07-01','','9276','0','0','','','0','','','0','','0','','','FALSE','3','','38','0','','4','Batool Dawood','821075','2016-08-01','','Teacher',3),('1163','Ummekulsoom baisaheb','Naeem bhaisaheb','Burhani','0','Female','','','42301-4944810-2','JX6S0V','1989-02-11','House No D-69, Block 5,','Kehkashan,','Clifton','Karachi','','','','','','Ummekulsoom Mohyuddin','0200A333895','2016-11-01','','','','','appointed as a teacher. Salary Rs 29,855.','Naeem Mohyuddin','','','','9404','0','0','','','0','','','0','','0','','','TRUE','3','','34','0','','4','Umme Kulsoom Mohyuddin','866991','2016-11-01','','Teacher',3),('1164','Shaikh Mohammad','Asghar Ali','Halai','0','Male','515-56-146747','','42301-7599458-9','MV5R96','1956-01-01','House No 4B-S, Tayeb Ali','& Ismailjee Building,','Sommerset Street, Saddar','Karachi','','','','','','Mohammad Asghar Ali','','','3464089-4','','','','Appointed as Aamil Saheb Ezzi Mohallah, Burhani Nagar. Wazifa Rs 48,000.','Asghar Ali','','2016-08-01','','1133','0','0','','','0','','','0','','0','','','TRUE','1','','16','1','','21','Mr. Mohammad Asghar Ali','102455','2016-07-01','','Aamil Saheb Ezzi Mohallah Burhani Nagar',4),('1165','Mohammad Ali Aksar','Umar Hayat','.','0','Male','','','13501-0263518-1','S625NG','1994-12-01','Mattikot, Dakhana, ','Balakot, Tehsil','District','Mansehra','','','03248037590','','','Mohammad Ali Aksar','0200A333900','2017-01-01','','','Student 5 ','','Appointed as a peon in rabwatjibla. Referred by Shaikh Taher Ramakdawala. He is in place of Bezour Khan. Timing 24 hours.','Umar Hayat','','2016-11-01','','9415','0','0','','','0','','','0','','0','','','FALSE','3','','46','0','','7','Mohammad Ali Aksar','866712','2016-11-01','','Peon',3),('1168','Mulla Mohammad','Mulla Mustafa ','Kapasi','0','Male','','','90406-0150477-3','M1X3QK','1990-11-27','Flat No 17, Qasr-e-Haidery,','North Nazimabad','','Karachi','','','03112010726','','','Mohammad Aftab Hussain','0200I333897','2016-11-01','','','Faqiyul Jayyaed','','Appointed in siyanat. Salary Rs 20,000. ','Aftab Hussain','','2016-10-01','','9376','0','0','','','0','','','0','','0','','','FALSE','3','','36','0','','4','Mohammad Aftab Hussain','861954','2016-11-01','','Khidmat Guzar',3),('1168','Mulla Mohammad','Mulla Mustafa ','Kapasi','0','Male','','','90406-0150477-3','M1X3QK','1990-11-27','Flat No 17, Qasr-e-Haidery,','North Nazimabad','','Karachi','','','03112010726','','','Mohammad Aftab Hussain','0200I333897','2016-11-01','','','Faqiyul Jayyaed','','Appointed in siyanat. Salary Rs 20,000. ','Aftab Hussain','','2016-10-01','','9376','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Alefiyah Yousuf ','860276','2016-12-01','','Teacher',3),('1169','Alifiyah','Yousuf','Jessorwala','0','Female','','','42101-8515636-0','','1991-01-20','SD-4G, Flat No 201,','Block G, Rajput Shopping Mall,','North Nazimabad,','Karachi','','','03452825263','','','Alefiyah Yousuf','0200H333898','2016-11-01','','','','','Appointed as a teacher period basis from Safar 1438 in Manahij Talimiyah.','Yousuf','','2016-11-01','','9319','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Alefiyah Yousuf','860276','2016-12-01','','Teacher',3),('1169','Alifiyah','Yousuf','Jessorwala','0','Female','','','42101-8515636-0','','1991-01-20','SD-4G, Flat No 201,','Block G, Rajput Shopping Mall,','North Nazimabad,','Karachi','','','03452825263','','','Alefiyah Yousuf','0200H333898','2016-11-01','','','','','Appointed as a teacher period basis from Safar 1438 in Manahij Talimiyah.','Yousuf','','2016-11-01','','9319','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Alefiyah Yousuf ','860276','2017-02-01','','Teacher',3),('1169','Alifiyah','Yousuf','Jessorwala','0','Female','','','42101-8515636-0','','1991-01-20','SD-4G, Flat No 201,','Block G, Rajput Shopping Mall,','North Nazimabad,','Karachi','','','03452825263','','','Alefiyah Yousuf','0200H333898','2016-11-01','','','','','Appointed as a teacher period basis from Safar 1438 in Manahij Talimiyah.','Yousuf','','2016-11-01','','9319','0','0','','','0','','','0','','0','','','FALSE','3','','38','0','','4','Aliffiyah Yousuf','860276','2016-11-01','','Teacher',3),('1172','Johratussharaf','Shaikh Quresh','Faizullahbhoy','0','Female','502-72-789366','','42000-0359737-2','O33Z13','1972-04-09','House No 103, ST-4, ','Block C, ','North Nazimabad','Karachi','','','','','','Johratussharaf','0200F334919','2016-12-01','','','','','Appointed as a teacher period basis @ Rs 400 from april 2016.','Quresh','','','','1757','0','0','','','0','','','0','','0','','','FALSE','3','','54','0','','7','Johratusharaf','719707','2016-12-01','','Teacher',3),('1173','Fatema ','Mulla Houzaifa','Zaini','0','Female','','','42101-1802210-4','I5M7P9','1990-10-10','Flat No 7, Hatimi Manzil,','Block C,','North Nazimabad,','Karachi','','','','','','Fatema Houzaifa','','','','','','','Appointed as a teacher in Mahaduz Zahra.','Houzaifa Kalimuddin','','2016-12-01','','8259','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Fatema Houzaifa','545293','2016-12-01','','Teacher',3),('1173','Fatema ','Mulla Houzaifa','Zaini','0','Female','','','42101-1802210-4','I5M7P9','1990-10-10','Flat No 7, Hatimi Manzil,','Block C,','North Nazimabad,','Karachi','','','','','','Fatema Houzaifa','','','','','','','Appointed as a teacher in Mahaduz Zahra.','Houzaifa Kalimuddin','','2016-12-01','','8259','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Fatema Huzaifa Kalimuddin','545293','2017-09-01','','Teacher',3),('1174','Zahabiyah','Yahyah','Bhuriwala','0','Female','','','42101-5286068-8','O62Y3X','1980-06-10','Flat No P-65, Al-Burhan ','Arcade, Block E, ','North Nazimabad,','Karachi','','','','','','Zahabiyah Bhuriwala','0200J334923','2016-12-01','','','','','Appointed as a teacher in Mahaduz Zahra.','Yahyah Bhuriwala','','2016-12-01','','3246','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Zahabiyah Bhuriwala Yahya ','400778','2017-09-01','','Teacher',3),('1174','Zahabiyah','Yahyah','Bhuriwala','0','Female','','','42101-5286068-8','O62Y3X','1980-06-10','Flat No P-65, Al-Burhan ','Arcade, Block E, ','North Nazimabad,','Karachi','','','','','','Zahabiyah Bhuriwala','0200J334923','2016-12-01','','','','','Appointed as a teacher in Mahaduz Zahra.','Yahyah Bhuriwala','','2016-12-01','','3246','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Zahabiya Bhuriwala','400778','2016-12-01','','Teacher',3),('1175','Zainab','Abidhussain','Jiwaji','0','Female','','AB079482','','','1988-12-19','Al-Jameatus Saifiyah','ST-8, Block C,','North Nazimabad','Karachi','','','','','','Zainab Abid Hussein Jiwaji','Foreigner','','','','','','Appointed as a teacher in Mahaduz Zahra.','','','2016-12-01','','6729','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Zainab Abid Hussain','779245','2016-12-01','','Teacher',3),('1175','Zainab','Abidhussain','Jiwaji','0','Female','','AB079482','','','1988-12-19','Al-Jameatus Saifiyah','ST-8, Block C,','North Nazimabad','Karachi','','','','','','Zainab Abid Hussein Jiwaji','Foreigner','','','','','','Appointed as a teacher in Mahaduz Zahra.','','','2016-12-01','','6729','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','zainab Abid Hussein','779245','2017-09-01','','Teacher',3),('1176','Khadija','Tasadduq Hussain','Nathadrawala','0','Female','','','42101-5451130-8','JM5V5S','1993-02-19','Flat No C-4, Gulshan-e-Zubaida','Block E,','North Nazimabad,','Karachi','','','','','','Khadija','0200I334924','2016-12-01','','','','','Appointed as a teacher in Mahaduz Zahra.','Tasadduq Hussain','','2016-12-01','','6716','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Khadija Tassaduq Hussain','375574','2016-12-01','','Teacher',3),('1176','Khadija','Tasadduq Hussain','Nathadrawala','0','Female','','','42101-5451130-8','JM5V5S','1993-02-19','Flat No C-4, Gulshan-e-Zubaida','Block E,','North Nazimabad,','Karachi','','','','','','Khadija','0200I334924','2016-12-01','','','','','Appointed as a teacher in Mahaduz Zahra.','Tasadduq Hussain','','2016-12-01','','6716','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Khadija Tassaduq Hussain','375574','2017-09-01','','Teacher',3),('1177','Farida','Hussaini','Mirza','0','Female','507-88-236652','','42000-6663975-2','JX5N6R','1966-01-01','House No 35, Kanchwala ','Building, Nishter Road,','Bhimpura,','Karachi','','','','','','Farida','0200H334925','2016-12-01','','','','','Appointed as a teacher in Mahaduz Zahra.','Hussaini Mirza','','2016-12-01','','9443','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Farida Hussaini Mirza','723265','2016-12-01','','Teacher',3),('1178','Mulla Abdulqadar','Fakhruddin Ahmed Ali','.','0','Male','','','42101-9378298-7','L3Z0Q8','1991-07-12','Flat No G-331, ','Al-Burhan Arcade, Block E,','North Nazimabad,','Karachi','','','','','','Abdulqadar','0200G334926','2016-12-01','','','','','Appointed as a teacher in Mahaduz Zahra.','Fakhruddin Ahmed Ali','','2016-12-01','','9444','0','0','','','0','','','0','','0','','','FALSE','3','','36','0','','4','Abdul Kader Fakhruddin','860692','2017-05-01','','Teacher',3),('1178','Mulla Abdulqadar','Fakhruddin Ahmed Ali','.','0','Male','','','42101-9378298-7','L3Z0Q8','1991-07-12','Flat No G-331, ','Al-Burhan Arcade, Block E,','North Nazimabad,','Karachi','','','','','','Abdulqadar','0200G334926','2016-12-01','','','','','Appointed as a teacher in Mahaduz Zahra.','Fakhruddin Ahmed Ali','','2016-12-01','','9444','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Abdul Qadir Fakhruddin','860692','2016-12-01','','Teacher',3),('1180','Neelofar','Taher Hussain','Karimjee','0','Female','','','42101-1500861-0','I34W5C','1968-07-29','Flat No M-353, ','Al-Burhan Arcade, Block E,','Haidery, North Nazimabad','Karachi','','','03452072852','','','Neelofar ','0200F334901','2016-12-01','','','BA','','Appointed in Rabwatjibla. Salary Rs 7,000. As a assisstant of Nematullah baisaheba. ','Taher Hussain','','2016-07-01','','6719','0','0','','','0','','','0','','0','','','FALSE','3','','46','0','','7','Neelofar Taher Hussain','823504','2016-12-01','','Neelofar Taher Hussain',3),('1181','Quaidjohar','Shaikh Abdulhussain ','Khambatwala','0','Male','.','.','42301-1080515-3','','1979-02-25','House No A-160, Block C,','North Nazimabad,','','Karachi','','','03002364496','','','Quaidjohar ','0200B334921','2016-12-01','','','ACCA','','Appointed as a teacher in Manahij Talimiyah. Salary @ Rs 400 period basis. Referred by Shaikh Mustafa Shaikh Qutbuddin.','Abdulhussain','','2016-09-01','','9473','0','0','','','0','','','0','','0','','','FALSE','3','','61','0','','7','Quaid Johar','885719','2016-12-01','','',3),('1182','Nooriyah','Zoaib','Sawarkandlawala','0','Female','','','42301-8922085-2','N5S2YT','1986-12-11','Flat No B-8,','Taimuria Square, Block E,','North Nazimabad','Karachi','','','','','','Nooriyah Zoaib','0200F334927','2016-12-01','','','','','','Zoaib','','2016-12-01','','6713','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Nooriyah Zoeb','382467','2016-12-01','','Teacher',3),('1182','Nooriyah','Zoaib','Sawarkandlawala','0','Female','','','42301-8922085-2','N5S2YT','1986-12-11','Flat No B-8,','Taimuria Square, Block E,','North Nazimabad','Karachi','','','','','','Nooriyah Zoaib','0200F334927','2016-12-01','','','','','','Zoaib','','2016-12-01','','6713','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Nooriyah Zoeb Zoeb','382467','2017-09-01','','Teacher',3),('1184','Nafisa ','Shabbir Hussain','.','0','Female','','','42101-3680061-0','OL2Y3X','1956-11-27','Flat No B-7, Block G,','North Nazimabad,','Haidery','Karachi','','','','','','Nafisa','','','','','','','','Shabbir Hussain','','2016-12-01','','9483','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','','','2016-12-01','','Teacher',3),('1185','Dr. Sakina','Aliasghar','Khambatwala','0','Female','','','42101-4212502-8','N360RD','1986-10-26','House No A-118, Block C,','North Nazimabad,','Haidery','Karachi','','','','','','Sakina Aliasghar','0200A334914','2016-12-01','','','','','','Aliasghar Khambati','','2016-12-01','','9484','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','','','2016-12-01','','Teacher',3),('1187','Aqila','Juzer','Antaria','0','Female','','','42301-2987404-2','','1963-11-11','Flat No 10, Mustafa Market, ','2nd Floor, Light House','Adamjee Bhudhabhai, ','Karachi','','','','','','Aqila ','0200I334916','2016-12-01','','','','','','Juzer Antaria','','2016-12-01','','9486','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Aqila Juzar','753196','2016-12-01','','Teacher',3),('1188','Tasneem','Ishaq','.','0','Female','','','42101-4565415-4','NX1X1D','1987-11-05','Flat No 24, Amina Mansion,','3rd Floor, Bilasis Street, ','New Challi,','Karachi','','','','','','Tasneem Ishaq','0200H334917','2016-12-01','','','','','','Ishaq','','2016-12-01','','9487','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Tasneem Ishaq','884329','2016-12-01','','Teacher',3),('1189','Zehra','Binti','Husin','0','Female','458586-327008-2','21090701','','','1983-05-09','Flat No C-407, 4th Floor,','Burhani Bagh, ','North Nazimabad','Karachi','','','','','','Zehra Binti Husin','','','','','','','','','','2016-12-01','','9488','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Ms. Zehra Binti Husin Ali','184331','2017-09-01','','Teacher',3),('1189','Zehra','Binti','Husin','0','Female','458586-327008-2','21090701','','','1983-05-09','Flat No C-407, 4th Floor,','Burhani Bagh, ','North Nazimabad','Karachi','','','','','','Zehra Binti Husin','','','','','','','','','','2016-12-01','','9488','0','0','','','0','','','0','','0','','','FALSE','3','','58','0','','7','Zehra Binti Husin','184331','2016-12-01','','Teacher',3),('1208','Mohammad Usamauzaman ','Mohamad Saeeduzaman','Siddiqui','0','Male','','','42101-7294785-5','O7J6QK','1990-12-23','House No A-364, Block I,','North Nazimabad,','','Karachi','','','03002563725','','','Mohammad Usamauzaman Siddiqui','0200E335495','2017-01-01','','','BS Electronics','','Appointed as a MEP Manager. Salary Rs 40,000. Referred by Mulla Taher Shaikh Moiz.','Mohammad Saeeduzaman Siddiqui','','2017-01-01','','9547','0','0','','','0','','','0','','0','','','TRUE','3','','42','0','','7','Osama Uz  Zaman','914340','2017-01-01','','Engineer',3),('1209','Dr. Sakina','Ashfaq Hussain','Thattawala','0','Female','','','42101-0824634-6','','1955-07-01','House No A-489, Block C,','North Nazimabad,','','Karachi','','','03333346252','','','Sakina Ashfaq','','','','','MBBS','','Appointed as a Dr in Mahalushifa. Salary Rs 6,000. Referred by Nematullah bs. Timing 10am to 10.30am','Ashfaq Hussain','','2016-07-01','','9137','0','0','','','0','','','0','','0','','','FALSE','3','','49','0','','7','Sakina Ashfaq','891053','2017-01-01','','Doctor',3),('1210','Fatema','Ibrahim bhai','Shehabi','0','Female','','','42000-8281015-0','M5L69C','1993-08-26','Flat No 204, Najmi Manzil','Block C, North Nazimabad','','Karachi','','','','','','Fatema Shehabi','0200D335496','2017-01-01','','','','','','Ibrahim','','2016-01-01','','8258','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','0','Fatema Shahabi','','2017-01-01','','Teacher',3),('1211','Arwa','Shabbir','Painter','0','Female','','','42301-8187573-8','KT0Z0J','1983-12-28','House No 301, Kashana Arcade,','Block C,','North Nazimabad','Karachi','','','','','','Arwa Shabir','0200D336727','2017-02-01','','','','','Appointed as a operator in Attalim from February 2017. Salary Rs 10,000. She is in place of Tahera Nooruddin.','Shabbir Yahyah','','2017-02-01','','9550','0','0','','','0','','','0','','0','','','FALSE','1','','22','0','','2','Mrs. Arwa Shabbir','910527','2017-02-01','','Telephone Operator',4),('1218','Mohammad Ayub','Chandarkhan','.','0','Male','109-85-380219','','15307-5204243-3','T01T89','1985-01-01','Badoonbala, Dakhana','Badoon, Tehsil Oonzai','District','Loyerdair','','','03409822900','','','Mohammad Ayub','0200E336726','2017-02-01','','','Middle','','Appointed as a peon in Tadreebe Funni. Salary Rs 10,000. Timing 8am to 5pm. Referred by Safdar Khan.','Chandarkhan','','2017-02-09','','9585','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Mohammad Ayub','919331','2017-02-01','','Peon',3),('1232','Mohammad Hayat','Gul Nabi','.','0','Male','','','42401-9809443-7','U8479K','1990-01-01','House No C-40, Sultanabad','Haji Camp,','','Karachi','','','','','','Mohammad Hayat','','','','','','','Appointed as a driver of KY family. ','Gul Nabi','','2017-04-01','','9638','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Mohammad Hayat Gul Nabi','943659','2017-04-01','','Driver',4),('1237','Shaikh Mustafa','Faizullah','Ghadiyali','0','Male','512-93-214609','','42301-3010048-9','K2377Z','1960-01-01','Flat No 1, Near Taheri Masjid','Syedna Burhanuddin Road','Saddar','Karachi','','','','','','Mustafa','','','','','','','Appointed as a masool ul mooze in quetta.','Faizullah','','2017-07-01','','1287','0','0','','','0','','','0','','0','','','TRUE','1','','16','2','','21','Mr. Mustafa Faizullah','127214','2017-07-01','','Massol ul Mooze Quetta',4),('1238','Murtaza','Zahid Hussain','Rampurawala','0','Male','516-79-338424','','42201-8619093-7','J113B1','1979-07-02','Plot No 35, Al-Hilal Manzil','Bahadur Yar Jhang Road,','Soldier Bazar','Karachi','','','03333685012','','murzoaiman860@gmal.com','Murtaza Zahid Hussain','','','','','matric','','appointed as a area manager in siyanat department. salary Rs 18,000.','Zahid Hussain','','2017-07-01','','7023','0','0','','','0','','','0','','0','','','FALSE','3','','42','0','','7','Murtaza Zahid Hussain','988182','2017-07-01','','Area Manager',3),('1239','Abbas Ali','Zainuddin','Desaiwala','0','Male','103-56-1176574','','42101-9241995-5','','1997-09-02','House No A-405, Block C,','North Nazimabad,','','Karachi','','','03122217058','','','Abbas Ali Zainuddin','','','','','','','','Zainuddin','','2017-07-03','','9752','0','0','','','0','','','0','','0','','','FALSE','3','','43','0','','7','Abbas Ali Zainuddin','988177','2017-07-03','','Attendent',3),('1240','Mulla Hakimuddin','Qutbuddin','Ahmedabadwala','0','Male','','','42301-5720684-3','N6Z7RZ','1991-08-10','Flat No 125, 4th Floor, ','Abideen Nooruddin Building,','Mohammad Shah Street','Karachi','','','03212298552','','','Hakimuddin','','','','','Faqiul Jayyed','','Appointed in Mahad Tehfeez from Zilqad 1438.','Qutbuddin Ahmedabadwala','','2017-08-01','','9782','0','0','','','0','','','0','','0','','','FALSE','3','','37','0','','4','Hakimuddin Qutbuddin Ahmedabad','1001192','2017-08-01','','Mahad Tehfeez',3),('1247','Bilquis bai ','Dawood','Mandasorewala','0','Female','','','42301-2304011-4','LOB1NY','1952-01-01','Flat No 404, Al-Saddar Bldg','Near CIA centre, Saddar','','Karachi','','','','','','Bilquis bai','','','','','','','','Dawood','','2017-08-01','','1115','0','0','','','0','','','0','','0','','','FALSE','1','','22','0','','2','Mrs. Bilquis bai Dawood','100104983','2017-08-01','','Retired Moalima',4),('1248','Mehrunnisa','Yaqoob Ali','Bhoojwala','0','Female','','','42301-3297627-0','KG0W72','1952-12-25','Flat No 4, Chand Building,','2nd Floor, Ghulamshah Street','Jodia Bazar,','Karachi','','','','','','Mehrunnisa','','','','','','','','Yaqoob Ali','','2017-08-01','','1562','0','0','','','0','','','0','','0','','','FALSE','1','','22','0','','2','Mrs. Mehrunnisa Yaqoob Ali','100105262','2017-08-01','','Retired Moalima',4),('1249','Shaikh Hassan ','Abdullah ','Anjarwala','0','Male','','450-60-005229','42000-0507357-9','LD6Z54','1960-03-08','Flat No 6, Everest Enterprises','2nd Floor, lot No CC-2, ','Clifton','Karachi','','','','','','Hassan Abdullah Anjarwala','','','','','','','','Abdullah bhai','','2017-08-01','','1140','0','0','','','0','','','0','','0','','','FALSE','1','','22','0','','2','Mr. Hassan Abdulla Anjarwala','101727','2017-08-01','','Retired Moalim',4),('1250','Shaikh Saifuddin','Fakhruddin','Naik','0','Male','502-64-604184','','42101-1413651-7','','1964-08-14','Flat No E-24, Block E,','Haidery Memorial Market','North Nazimabad','Karachi','','','','','','Saifuddin','','','','','','','','Fakhruddin Naik','','2017-08-01','','1211','0','0','','','0','','','0','','0','','','FALSE','1','','22','0','','2','Mr. Saifuddin Fakhruddin Naik','101710','2017-08-01','','Retired Moalim',4),('1251','Batool','Mulla Yousuf','Madraswala','0','Female','512-80-233758','','42301-0802297-0','MX6S91','1980-06-24','House No E-7, Haidery Memorial','Market, Block E, North','Nazimabad, ','Karachi','','','','','','Batool Yousuf','','','','','','','','Yousuf Siraj','','2017-09-01','','1454','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Batool Yousuf Yousuf Siraj','375568','2017-09-01','','',3),('1252','Maria','Shamsheer Hussain','Godhrawala','0','Female','','','42101-3780324-8','I44J13','1993-03-09','Flat No A-23, Al Saba','Apartment, Block E,','North Nazimabad,','Karachi','','','','','','Maria ','','','','','','','','Shamsheer Hussain','','2017-09-01','','6712','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Maria Shamsheer Hussain','376811','2017-09-01','','Teacher',3),('1253','Fatema','Saifuddin','.','0','Female','502-93-1122519','','42101-7304856-2','','1997-02-26','House No D-20, Block C,','Haidery, North Nazimabad,','','Karachi','','','','','','Fatema ','','','','','','','','Saifuddin','','2017-09-01','','9482','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Fatema Saifuddin','881755','2017-09-01','','Teacher',3),('1254','Rashida','Mulla Mustansir','Khambatwala','0','Female','511-81-311883','','42301-0846450-4','I2680G','1981-09-10','Flat No 18, Qasr-e-Fakhruddin','Block C, Haidery,','North Nazimabad, ','Karachi','','','','','','Rashida Mustansir','','','','','','','','Mustansir','','2017-09-01','','2948','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Rashida Mustansir ','101846','2017-09-01','','Teacher',3),('1255','Alifiyah','Murtaza ','Haidery','0','Female','103-18-138353','','42101-7903240-6','','1990-08-05','House No L-345, Al-Burhan','Arcade, Block E, North ','Nazimabad, ','Karachi','','','','','','Alifiyah','','','','','','','','Murtaza Haidery','','2017-09-01','','9876','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Alefiyah Murtaza Haidry','1076262','2017-09-01','','Teacher',3),('1256','Maria','Shaikh Abbas ','Mandviwala','0','Female','502-76-829505','','42000-0376048-6','JN8J52','1976-03-27','Flat No E-28, Mohammadi Manzil','3rd Floor, Haidery Memorial ','Market, North Nazimabad','Karachi','','','','','','Maria Abbas','','','','','','','','Abbas','','2017-09-01','','2714','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Maria Abbas','674747','2017-09-01','','Teacher',3),('1257','Maria ','Hussain','.','0','Female','','','42101-6861177-8','','1994-01-21','House No B-38, Bhayani ','Extension, North Nazimabad','Karachi','','','','','','','Maria Hussain','','','','','','','','Hussain','','2017-09-01','','7011','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Maria Hussain Hussain','','2017-09-01','','Teacher',3),('1258','Ruqaiyah','Shaukat','Nazar Ali','0','Female','','','42000-9212550-2','','1994-08-22','Flat No WO-7/23/11 Street 11','Irfan Manzil, City Court','','Karachi','','','','','','Ruqaiyah','','','','','','','','Shaukat Nazar Ali','','2017-09-01','','9877','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Ruqaiya Shaukat Nazar Ali','1046901','2017-09-01','','Teacher',3),('1259','Hussain','Hunaid','.','0','Male','','','42101-2721272-3','M2R5PJ','1989-10-03','House No C-80, Block C,','North Nazimabad,','','Karachi','','','','','','Hussain ','','','','','','','','Hunaid','','2017-09-01','','9878','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Hussain Hunaid','1046904','2017-09-01','','Teacher',3),('1260','Zainab','Moiz','.','0','Female','','','42101-6745435-2','J620J9','1988-06-10','House No A-293, Block C','North Nazimabad,','','Karachi','','','','','','Zainab Moiz','','','','','','','','Moiz','','2017-09-01','','9879','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Zainab Moiz','1046906','2017-09-01','','Teacher',3),('1261','Khadija','Mulla Saifuddin','.','0','Female','','','42101-2744037-6','O07Z7L','1990-02-25','Flat No 05, Najmi Manzil','Block C, ','North Nazimabad','Karachi','','','','','','Khadija','','','','','','','','Mulla Saifuddin','','2017-09-01','','9880','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Khadija M.Saifuddin','','2017-09-01','','Teacher',3),('1263','Zahra ','Mohammadul Baqir','.','0','Female','103-56-1091051','','42301-4187796-4','','1990-07-17','Flat No D-44, Phase 2, ','Block G, Nagina Square','North Nazimabad','Karachi','','','','','','Zahra Mohammadul Baqir','','','','','','','','Mohammadul Baqir','','2017-09-01','','6711','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Zahra Mohammad Ul Baqir','','2017-09-01','','Teacher',3),('1264','Quratulain ','Murtaza','.','0','Female','','','42101-9959672-0','LG0W8Y','1989-04-09','House o 301, 3rd Floor, ','Burhan Luzury Apartment,','Mansfield Street, Saddar','Karachi','','','','','','Quratulain','','','','','','','','Murtaza','','2017-09-01','','9882','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Quratul Ain Murtaza','1046885','2017-09-01','','Teacher',3),('1265','Maria','Hatim Ali','.','0','Female','502-93-1091714','','42101-1729687-4','','1980-12-20','House No a-1, 2nd Floor, ','Block G, North Nazimabad','','Karachi','','','','','','Maria Hatim','','','','','','','','Hatim Ali','','2017-09-01','','9883','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Maria Hatim Hatim Ali','428807','2017-09-01','','Teacher',3),('1266','Fatema ','Shabbir','.','0','Female','502-74-884266','','42101-1482190-0','J88V8J','1974-12-03','House No A/137, Block C','North Nazimabad','','Karachi','','','','','','Fatema Shabbir','','','','','','','','Shabbir Saifuddin','','2017-09-01','','9884','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Fatema Shabbir Saifuddin','1046888','2017-09-01','','Teacher',3),('1267','Taha','Mustafa','.','0','Male','103-76-1099850','','42301-0288203-5','','1994-10-28','Flat No 1, Qasr-e-Hussain','Building, Jeeraam Street','Pakistan Chowck,','Karachi','','','','','','Taha','','','','','','','Duplicate','Mustafa','','2017-09-01','01-Jan-18','9726','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Taha Mustafa','1001189','2017-09-01','','Teacher',3),('1268','Yousuf Asghar','Asghar Ali','.','0','Male','103-15-1098628','','42301-1596020-7','','1988-01-16','Flat No a-34, Jabbar Plaza','Mansfield Street, Saddar','','Karachi','','','','','','Yousuf Asghar','','','','','','','','Asghar Ali','','2017-09-01','','6994','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Yousuf Asgher Asgher Ali','332946','2017-09-01','','Teacher',3),('1269','Alifiyah','Murtaza','.','0','Female','504-98-1031225','','42101-5940105-0','','1985-11-25','House No A-136, Block C, ','North Nazimabad','','Karachi','','','','','','Alifiyah Murtaza','','','','','','','','Murtaza','','2017-09-01','','9885','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Alifiyah Murtaza','','2017-09-01','','Teacher',3),('1270','Sarrah ','Murtaza Saifuddin','.','0','Female','502-93-1061831','','42101-1675130-6','','1979-09-02','House No K-141, ','Al-Burhan Arcade, Block E,','North Nazimabad','Karachi','','','','','','Sarrah Murtaza','','','','','','','','Murtaza Saifuddin','','2017-09-01','','9886','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Sarrah Murtaza Saifuddin','1046890','2017-09-01','','Teacher',3),('1271','Rashida ','Kausar','.','0','Female','502-81-615183','','42000-0359745-0','M9Y9F4','1981-09-09','House No B-121,','Block C, North Nazimabad,','','Karachi','','','','','','Rashida Kausar','','','','','','','','Kausar Abdullah Dhanerawala','','2017-09-01','','9887','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Rashida Kausar Abdullah ','','2017-09-01','','Teacher',3),('1272','Arwa Aun Ali','Idrees ','Haidery','0','Female','103-56-1109307','','42101-3900199-4','','1985-06-11','Flat No 205, Block E,','Ezzi Manzil, ','North Nazimabad','Karachi','','','','','','Arwa Aun Ali','','','','','','','','Idrees Haidery','','2017-09-01','','9888','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Arwa Aunali Idrees Haidery','','2017-09-01','','Teacher',3),('1273','Jamila','Mustafa','.','0','Female','502-93-1011044','','42101-9101184-6','','1993-12-13','House No A-487, Block C','North Nazimabad','','Karachi','','','','','','Jamila','','','','','','','','Mustafa','','2017-09-01','','9889','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Jamila Mustafa','1046897','2017-09-01','','Teacher',3),('1274','Mohamad ','Shaikh Abbas','Motiwala','0','Male','','','83442-0501854-3','','1997-10-03','201, Yousufi Manzil,','ST-4, Block C','North Nazimabad','Karachi','','','','','','Mohammad Motiwala','','','','','','','','Abbas Abdullah Motiwala','','2017-09-01','','9890','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Mohammad Motiwala Abbas','','2017-09-01','','Teacher',3),('1275','Hussaina','Shaikh Mustafa','Khambatwala','0','Female','513-72-129637','','42000-0490376-6','','1972-04-13','House No 102, Yousufi Manzil,','Block C, ','North Nazimabad','Karachi','','','','','','Hussaina','','','','','','','','Mustafa','','2017-09-01','','1794','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Hussaina Mustafa','126046','2017-09-01','','Teacher',3),('1276','Tasneem ','Shaikh Qusai','Dewan','0','Female','','','70258-6628223-2','','1983-11-22','103-A, Burhani Bagh, ','North Nazimabad,','','Karachi','','','','','','Tasneem Qusai Dewan','','','','','','','','Qusai Abdulqadir Dewan','','2017-09-01','','9891','0','0','','','0','','','0','','0','','','FALSE','3','','71','0','','7','Tasneem Qusai Dewan','1046907','2017-12-01','','Database Management',3),('1276','Tasneem ','Shaikh Qusai','Dewan','0','Female','','','70258-6628223-2','','1983-11-22','103-A, Burhani Bagh, ','North Nazimabad,','','Karachi','','','','','','Tasneem Qusai Dewan','','','','','','','','Qusai Abdulqadir Dewan','','2017-09-01','','9891','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Tasneem Qusai Diwan','1046907','2017-09-01','','Teacher',3),('1277','Mulla Mohammad','Aun Ali','Sunailwala','0','Male','','','42301-2165702-5','O5D3W9','1992-12-04','Flat No 14, Willington Street','Shahrah-e-Iraq, Saddar, ','','Karachi','','','','','','Mohammad','','','','','','','','Aun Ali','','2017-09-01','','8450','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Mohammad Aun Ali','644930','2017-09-01','','Teacher',3),('1278','Shaikh Houzaifa','Aftab Hussain','Roker','0','Male','502-77-777832','','42101-1706903-5','I12P58','1977-12-26','Flat No 205, Samar Pride','Block E, Haidery','North Nazimabad,','Karachi','','','','','','Houzaifa Aftab','','','3188635-3','','','','appointed as a aamil in Jamali mohallah.','Aftab Hussain','','2017-09-01','','1148','0','0','','','0','','','0','','0','','','TRUE','1','','16','11','','21','Mr. Houzaifa Aftab Hussain','120004046','2017-09-01','','Aamil Saheb Jamali Mohallah UP More',4),('1280','Mohammad Mansoor','Shahzad Khan','.','0','Male','506-58-150081','','42101-4131226-3','N3Z7SR','1958-11-15','House No 21, Sector 5-E','Surjani Town,','','Karachi','','','','','','Mohammad Mansoor Shahzad Khan','','','','','','','Appointed as an instructor in Khaimat. Salary Rs 10,000.','Mohammad Anwar Khan','','2017-10-01','','9560','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Mohammed Mansoor Shehzad Khan','1067618','2017-10-01','','Teacher',3),('1281','Hussain ','Zoeb Ali','Quettawala','0','Male','502-93-108358','','42101-9083187-5','','1984-09-28','House No 1-10, 4th Floor,','Block G, North Nazimabad','','Karachi','','','','','','Hussain Zoeb','','','','','','','Appointed as a computer teacher ','Zoeb Ali','','2017-07-01','','4774','0','0','','','0','','','0','','0','','','FALSE','3','','67','0','','7','Hussain Zoaib Zoaib Ali','1054356','2017-07-01','','Teacher',3),('1283','Mariyah','Qamruddin','.','0','Female','','','42101-4564560-4','N0W54C','1994-08-11','Flat No 3, N. R. Avenue,','Block G, North Nazimabad','','Karachi','','','','','','Mariyah','','','','','','','Appointed as a teacher in Mukhiyam.','Qamruddin','','2017-09-01','','9485','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Maria Qamruddin','','2017-09-01','','Teacher',3),('1284','Havrah','Mustansir ','Taherali','0','Female','512-92-298703','','42301-8283739-8','NK9Q8J','1974-08-08','House No 1, Thattai Compound','Light House','','Karachi','','','','','','Havrah','','','','','','','Appointed as a teacher in Mukhiyam.','Mustansir Taher Ali','','2017-09-01','','9906','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Hawra Mustansir Tahir Ali','','2017-09-01','','Teacher',3),('1286','Tasneem','Shaikh Hashim','Marsiyawala','0','Female','502-74-303732','','42301-0809834-6','','1974-12-29','Classic Homes, Flat No 202,','Block C, North Nazimabad','','Karachi','','','','','','Tasneem Hashim Marsiyawala','','','','','','','Appointed as a teacher in Mukhiyam.','Hashim Saifuddin Marsiyawala','','2017-09-01','','5104','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Tasneem Hashim Marasiya Wala','','2017-09-01','','Teacher',3),('1288','Mulla Aliasghar','Shaikh Hussain','Jessorwala','0','Male','','','42101-8486541-9','JT1051','1993-10-16','Flat No 201, Yousufi Manzil','Block C, ST-4, ','North Nazimabad,','Karachi','','','','','','Aliasghar','','','','','','','','Hussain Haji Najmuddin','','2017-10-01','','7373','0','0','','','0','','','0','','0','','','FALSE','1','','24','0','','10','Mr. Ali Asghar Hussain Haji','1047470','2017-10-01','','H.R.',4),('1288','Mulla Aliasghar','Shaikh Hussain','Jessorwala','0','Male','','','42101-8486541-9','JT1051','1993-10-16','Flat No 201, Yousufi Manzil','Block C, ST-4, ','North Nazimabad,','Karachi','','','','','','Aliasghar','','','','','','','','Hussain Haji Najmuddin','','2017-10-01','','7373','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Ali Asghar Hussain Najmuddin','1047470','2017-11-01','','Teacher',3),('1289','Mulla Hassan','Shaikh Quaid Hussain','.','0','Male','','','42101-4513899-5','J683W7','1992-11-03','Flat No 205, Johar Mansion','Block A, North Nazimabad','','Karachi','','','','','','Hassan','','','','','','','','Quaid Hussain','','2017-10-01','','9926','0','0','','','0','','','0','','0','','','FALSE','1','','24','0','','10','Mr. Hassan Quaid Hussain','1047301','2017-10-01','','Tijarat Rabeha',4),('1290','Mulla Mustafa','Abuzar','.','0','Male','','','42301-0202330-5','','1993-12-02','Ground Floor, Zahra Mansion,','STreet A-345, Cricketer Avenue','Block C, North Nazimabad,','Karachi','','','','','','Mustafa','','','','','','','','Abuzar','','2017-10-01','','9927','0','0','','','0','','','0','','0','','','FALSE','1','','24','0','','10','Mr. Mustafa Abuzar','1047316','2017-10-01','','Budget',4),('1291','Irshaad Badshah','Syed Badshah','.','0','Male','1328-93-120479','','17201-9290595-5','VS0S00','1972-01-01','Mohalah Mian Kaan Asukhail','Dakhana Nizampur','District ','Noshera','','','','','hussain.shujai@gmail.com','Irshaad Badshah','','','','','','','Appointed as a driver in Islamabad with  Hussain bhai Shujai. Salary Rs 27,000.','Syed Badshah','','2017-11-01','','9935','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Irshaad Badshah Syed Badsh','1055353','2017-11-01','','Driver Islamabad',4),('1292','Mulla Hussain','Hasnain','Doosajeewala','0','Male','502-83-1054270','','42301-6243821-3','','1996-10-03','Flat No 22/14, Shujauddin','Building, Saddar, Reamond ','Street','Karachi','','','03343065253','','','Husain Hasnain','','','','','matric','','appointed in audio video department, salary Rs 15,000.','Hasnain Saleh','','2017-11-01','','9881','0','0','','','0','','','0','','0','','','FALSE','3','','36','0','','4','Hussain Hasnain Saleh','1046900','2017-11-01','','Audio Video Department',3),('1293','Mulla Saifuddin','Shaikh Mohammad ','Ezzi','0','Male','','','42101-4021006-5','I0J930','1989-08-23','Flat No 202, Yousufi Manzil','Block C, North Nazimabad,','','Karachi','','','03474732997','','','Saifuddin','','','','','','','Appointed in Qism Tehfeez Department. Salary Rs 34,855.','Mohammad Saifuddin','','2017-11-01','','9943','0','0','','','0','','','0','','0','','','FALSE','3','','37','0','','4','Saifuddin Mohammad Saifuddin','1050405','2017-10-01','','Qism Tehfeez',3),('1294','Mulla Taha','Mustafa','Zangibarwala','0','Male','103-76-1099850','','42301-0288203-5','','1994-10-28','Flat No 1, Qasr-e-Hussain','Building, Jaeraam Street','Pakistan Chowck','Karachi','','','03333887052','','','Taha','','','','','','','','Mustafa','','2017-11-01','','9726','0','0','','','0','','','0','','0','','','FALSE','3','','36','0','','4','Taha Mustafa','1001189','2017-11-01','','Office Attendant',3),('1295','Hamza ','Shaukat Nazar Ali','.','0','Male','','','42000-9434334-3','OC8S0J','1993-04-06','Flat No 11, W-O-7/23','Irfan Manzil, Opposite City','Court, ','Karachi','','','','','','Hamza','','','','','','','','Shaukat Nazar Ali','','2017-11-01','','8452','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Hamza Shaukat Nazar Ali','591543','2017-11-01','','Teacher',3),('1296','Jamila','Mulla Hussain','Quettawala','0','Female','','','42101-8785469-6','I70Z1V','1986-11-19','House No 12, D-20, ','Block C,','North Nazimabad','Karachi','','','','','','Jamila Hussain','','','','','','','','Hussain Quettawala','','2017-11-01','','5541','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Jamila Hussain Quettawala','1064372','2017-11-01','','Teacher',3),('1297','Abbas Ali','Zahid Hussain','.','0','Male','','','42101-2671863-1','N5P8ZG','1996-04-26','House No D-14, Nadir Shah','Apartment, Block G,','North Nazimabad','Karachi','','','','','','Abbas Ali','','','','','','','','Zahid Hussain','','2017-11-01','','9949','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Abbas Ali Zahid Hussain','1052743','2017-11-01','','Teacher',3),('1298','Fatema','Mulla Murtaza','Sabir','0','Female','','','42000-6369892-2','OX8W0X','1988-11-12','House No A-160,','Block C,','North Nazimabad','Karachi','','','','','','Fatema Murtaza','','','','','','','','Murtaza','','2017-11-01','','9948','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Fatema Murtaza','1052745','2017-11-01','','Teacher',3),('1299','Maria ','Shabbir','.','0','Female','','AA5139222','42101-0959922-8','','1999-09-03','','','','','','','','','','Maria ','','','','','','','','Shabbir','','2017-11-01','','9951','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Mariya Shabbir','','2017-11-01','','Teacher',3),('1300','Zainab','Mustafa','Tawawala','0','Female','','GF210359','','','1993-10-14','','','','','','','','','','Zainab Mustapha','Foreigner','','','','','','','Tawawala','','2017-11-01','','9950','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Zainab Shabbir','1046896','2017-11-01','','Teacher',3),('1301','Abdul Razak','Umer Din','.','0','Male','','','42401-2727484-3','YG0L2G','1980-05-01','Mohammadi Colony, Al Falah ','Chowck, Maripur Road,','','Karachi','','','','','','Abdul Razak ','','','','','','','Appointed as a cook in admin block. Salary Rs 27,000.','Umer Din','','2017-11-01','','9893','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Abdul Razak Umer Din','1042796','2017-11-01','','Cook',4),('1303','Abdul Sajid','Abdul Nawab Khan','.','0','Male','','','42101-8897838-3','J71S2S','1997-09-13','House No 807, Umer Farooq ','Colony, Block P,','','Karachi','','','','','','Abdul Sajid','','','','','','','Appointed in Liabrary Department. Salary Rs 13000. after probition salary Rs 15,000.','Abdul Nawab Khan','','2017-11-01','','9957','0','0','','','0','','','0','','0','','','FALSE','3','','43','0','','7','Abdul Sajid Abdul Nawab','1056363','2017-11-01','','Library Attendant',3),('1304','Kanwar Mansoor','Tariq Mansoor','.','0','Female','','','42101-5843346-2','IG3G1V','1990-12-08','House No F-21, Setalite Colony','Bufferzone Sector 15-A/5','','Karachi','','','03334990909','','kanwal.mk89@gmail.com','Kanwar Mansoor','','','','','','','Appointed as a swimming instructor in khaimat. Salary Rs 4,000. AFter probition salary Rs 5,000.','Tariq Mansoor','','2017-10-01','','9958','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Kanwal Mansoor Tariq Mansoor','1061775','2017-10-01','','Swimming Instructor',3),('1305','Noman Saed','Mohammad Saeed','.','0','Male','','','42101-4479360-1','O7Y07K','1987-06-12','House No R-86, Sector 19-A,','Scheme 33, Near Bandukhan','Hotel, Teachers Society, ','Karachi','','','03323289907','','saeednoman22@yahoo.com','Noman Saeed','','','','','','','','Mohammad Saeed','','2017-11-09','','9959','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Noman Saeed Mohammed Saeed','1059131','2017-11-09','','Photocopy Machine Operator',3),('1308','Shaikh Aliasghar ','Saifuddin','Quettawala','0','Male','513-79-137341','','42301-0806078-7','','1979-06-03','House No 4, Qasr-e-Batool','Saddar','','Karachi','','','','','','Ali Asghar Saifuddin','','','','','','','','Saifuddin','','2017-07-01','','4350','0','0','','','0','','','0','','0','','','FALSE','1','','24','0','','10','Mr. Ali Asghar Saifuddin','102316','2017-07-01','','Tanzeem Office',4),('1315','Mulla Shabbir','Shaikh Tayyab ','Jamali','0','Male','505-43-1126114','','42101-2391514-7','','1993-08-07','Flkat No 301, Street No 4, ','Yousufi Building,','North Nazimabad','Karachi','','','03353206252','','','Shabbir Tayyab Tahir','','','','','Graduate','','Appointed from Rabiul Awwal 1439. Wazifa Rs 20,000.','Tayyab Jamaali','','2017-11-01','','10005','0','0','','','0','','','0','','0','','','FALSE','3','','36','0','','4','Shabbir Tayyeb Tahir','1069082','2017-12-01','','Khidmatguzar',3),('1319','Ali Akbar','Fakhruddin','Bhinderwala','0','Male','','','42201-9051726-3','KB5J6D','1991-01-06','House No M-1851/A-1','Street No 12, Muterpur,','Mareepur,','Rawalpindi','','','03368172852','','','Ali Akbar','','','','','Matric','','Appointed in Manshuraat department as office attendant. Salary Rs 15,000. ','Fakhruddin','','2018-01-01','','10027','0','0','','','0','','','0','','0','','','FALSE','3','','70','0','','7','Ali Akber Fakhruddin','1092045','2018-01-01','','Office Attendant',3),('1320','Wajid Zaman','Tehsinullah','.','0','Male','505-43-1167791','','42101-1677284-7','','1999-01-01','House No KESC-2173, ','Block Q, Usman Ghani','Colony, North Nazimabad','Karachi','','','03128784067','','','Wajid Zaman','','','','','8 class','','Appointed as a worker in Mahaduz Zahra Tehfeez department. Salary Rs 10,000.','Tehsinullah','','2018-01-01','','10028','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Wajid Zaman Tehsin Ullah','1087563','2017-12-01','','Peon',3),('1321','Patras Masih','Enayat Masih','.','0','Male','502-81-957319','','42101-6597344-1','N77K5S','1981-01-01','House No 1143, Umer Farooq','Colony, Paharghanj, ','North Nazimabad,','Karachi','','','','','','Patras Masih','','','','','','','Gardner at D-20/C. Salary Rs 15,023.','Enayat Masih','','2018-01-01','','9588','0','0','','','0','','','0','','0','','','FALSE','3','','7','0','','7','Patras Masih Enayat Masih','1052742','2018-01-01','','Gardener',3),('1322','Gul Nazeer','Juma Khan','.','0','Male','122-71-686673','','13301-1319950-9','SW148W','1971-01-01','House No K-4/34, Al Madina','Basti Civil Lines,','','Karachi','','','03442801526','','','Gul Nazeer','','','','','Nil','','Appointed as a gatekeeper in admin block. Salary Rs 14,500. Rs 500 increased from July 2018. No bonus allowed. Duty timing 24 hours.','Juma Khan','','2018-02-07','','4863','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Gul Nazeer Juma Khan','1106835','2018-02-07','','Office Gatekeeper',4),('1325','Fatema','Shaikh Aamir','Ajmeerwala','0','Female','','','42301-3882333-8','J57M1N','1989-07-06','A-487, Fatemi Manzil, Block C','Haidery','North Nazimabad','Karachi','','','03333931572','','faalip@gmail.com','Fatema Aamir Abbas','','','','','BA','','','Aamir Abbas Ali','','2018-01-20','','8563','0','0','','','0','','','0','','0','','','FALSE','3','','133','0','','9','Fatema Aamir Abbbas','1094871','2018-02-01','','Teacher',3),('1326','Abdul Ghafoor','Mohammad Shafi','.','0','Male','','','42501-5907292-1','L6P02R','1997-03-25','House No L-505, Liyari','Express Way, Taiser Town,','Sector 35B,','Karachi','','','03112054372','','','Abdul Ghafoor','','','','','Matric','','Appointed as a careem driver in Jamea for 6 months, Salary Rs 18,000. ','Mohammad Shafi','','2018-02-14','','10064','0','0','','','0','','','0','','0','','','FALSE','3','','41','0','','7','Abdul Ghafoor Mohammad Shafi','1105236','2018-02-14','','Driver',3),('1327','Tanveer Ahmed','Mohammad Haroon','.','0','Male','','','42101-5781266-5','U3386W','1987-12-19','Flat No 6-A, Qasr-e-Burhani','Plot No SF-2, Block E','North Nazimabad','Karachi','','','03122137356','','','Tanveer Ahmed','','','','','Nil','','Appointed as a worker in Maktabatul Jamea. Salary Rs 10,500.','Mohammad Haroon','','2018-02-01','','10065','0','0','','','0','','','0','','0','','','FALSE','3','','43','0','','7','Tanveer Ahmed Mohammad Haroon','1103750','2018-02-01','','Peon',3),('1328','Mohammad Ameen','Abdulkareem','.','0','Male','253-91-249346','','42201-0572022-7','L5711B','1968-11-18','House No 14, Block 124','SRE, Shahrah-e-Faisal,','','Karachi','','','03366793244','','','Mohammad Ameen','','','','','','','Appointed as band instructor. Salary Rs 25,000. ','Abdulkareem','','2018-02-01','','10067','0','0','','','0','','','0','','0','','','FALSE','3','','59','0','','7','Mohammad Ameen Abdul Kareem','','2018-02-01','','Band Instructor',3),('1329','Nisreen ','Fakhruddin','Kaukawala','0','Male','','','42301-8862847-0','O784Z1','1989-11-21','Flat No 8, Kaka Street, ','KMC,','','Karachi','','','03342026752','','xmart.fakhruddin52@gmail.com','Nisreen Fakhruddin','','','','','Intermediate','','Appointed as a teacher. ','Fakhruddin','','2017-12-01','','10068','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Nisreen Fakhruddin','','2017-12-30','','Teacher',3),('1330','Zainab','Murtaza','Chakera','0','Female','','','42101-1653754-2','M9M69N','1983-06-18','House No A-6, Gulshan-e-','Zubaida, Block E,','North Nazimabad','Karachi','','','03323310350','','','Zainab Murtaza','','','','','Intermediate','','Appointed as a teacher. Salary @ Rs 200 per hour.','Murtaza Hussain','','2017-12-01','','10069','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Zainab Murtaza Murtaza Hussain','','2017-12-01','','Teacher',3),('1331','Batool','Hakimuddin','Jamnagarwala','0','Female','','','42301-1592317-0','K105XB','1987-12-15','House No 89, Saifee Bagh','Building, Liyari, Chakiwara,','','Karachi','','','03225165722','','batoolhuzaifa@gmail.com','Batool','','','','','','','','Hakimuddin','','2017-12-01','','10070','0','0','','','0','','','0','','0','','','FALSE','3','','53','0','','7','Batool Hakimuddin','1093357','2018-02-01','','Teacher',3),('1339','Mustafa bhai','Murtaza bhaisaheb','Zainy','0','Male','','','42101-8428873-5','O07X7V','1991-05-17','Flat No 104, Street No 4,','Najmi Manzil, Block C,','North Nazimabad,','Karachi','','','','','','Mustafa','','','','','','','Appointed as a Aamil in Saifee Mohallah from Rajab 1439','Murtaza bhai','','2018-05-01','','9372','0','0','','','0','','','0','','0','','','FALSE','1','','16','1','','21','Mr. Mustafa Murtaza bhai','863004','2018-05-01','','Aamil Saifee Mohallah Chakiwara',4),('1340','Anwarul Haq','Abdul Yaseen','.','0','Male','','','42301-6942968-5','K0W2VJ','1982-02-11','House No 4, Bandooqwala','Building, Chundrywala Road','','Karachi','','','','','','Anwarul Haq','','','','','','','','Abdul Yaseen','','','','10192','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Anwarul Haq Abdul Yaseen','1157846','','','Driver',4),('1341','Roohul Ameen','Abdul Yameen','.','0','Male','123-80-596707','','13504-6768106-3','S58D1Q','1980-01-01','New Haji Camp,','M. T. Road, Sultanabad','','Karachi','','','','','','Roohul Ameen ','','','','','','','','Abdul Yameenn','','','','5046','0','0','','','0','','','0','','0','','','FALSE','1','','20','0','','10','Mr. Roohul Ameen Abdul Yameen','1157823','','','Driver',4),('1342','Houzaifa ','Shabbir','Nathani','0','Male','','','42201-2261801-9','L4Y1RW','1994-08-27','Flat No 406, Uzma Garden','East,','','Karachi','','','03362547751','','','Houzaifa Nathani','','','','','','','Appointed from Rajab 1439. Salary Rs 30,000.','Shabbir Nathani','','','','10133','0','0','','','0','','','0','','0','','','FALSE','3','','37','0','','4','Huzaifa Nathani SO Shabbir ','1145850','2018-04-01','','Teacher',3),('1343','Mulla Hussain ','Shaikh Yousuf ','Khambatwala','0','Male','','','42101-0195153-5','LG5L1B','1993-11-04','Flat No A-20, Al-Saba','Apartment, Block E','Haidery North Nazimabad','Karachi','','','03322347253','','','Hussain Khambati','','','','','','','Appointed on Rajab 1439. Salary Rs 30,000.','Yousuf  Khambati','','','','10132','0','0','','','0','','','0','','0','','','FALSE','3','','37','0','','4','Hussain Khambaty SO Yousuf','1145855','2018-04-01','','Teacher',3),('1344','Shaikh Saifuddin ','Karim bhai','Zakir','0','Male','','510845412','','','1964-05-16','Essa Masjid, Nanakwada,','Panmandi,','Mohammad Shah Street','Karachi','','','','','','Saifuddin','Foreigner','','','','','','Aamil Essa Masjid','Zakir','','2018-04-01','','10227','0','0','','','0','','','0','','0','','','FALSE','1','','16','1','','21','Mr. Saifuddin Zakir','1167387','2018-04-01','','Aamil Essa Masjid Panmandi',4),('1345','Shaikh Abizar','Kutbuddin','Ginwala','0','Male','','S0135735','','','1974-02-01','Burhani Masjid, Off Tipu Sulta','Road, Shabbirabad','','Karachi','','','','','','Abizar Kutbuddin','Foreigner','','','','','','Aamil Burhani Masjid Shabbirabad','Ginwala','','2018-04-01','','10228','0','0','','','0','','','0','','0','','','FALSE','1','','16','1','','21','Mr. Abizar Kutbuddin Ginwala','','2018-04-01','','Aamil Burhani Masjid Shabbirabad',4);

/*Table structure for table `temp_employee5` */

CREATE TABLE `temp_employee5` (
  `emp_no` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `old_emp_no` varchar(255) DEFAULT NULL,
  `sex` varchar(255) DEFAULT NULL,
  `idn_no` varchar(255) DEFAULT NULL,
  `passport` varchar(255) DEFAULT NULL,
  `new_id_no` varchar(255) DEFAULT NULL,
  `fam_code` varchar(255) DEFAULT NULL,
  `dob` varchar(255) DEFAULT NULL,
  `add1` varchar(255) DEFAULT NULL,
  `add2` varchar(255) DEFAULT NULL,
  `area` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `postal_code` varchar(255) DEFAULT NULL,
  `phone_no` varchar(255) DEFAULT NULL,
  `mobile_no` varchar(255) DEFAULT NULL,
  `fax_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `id_name` varchar(255) DEFAULT NULL,
  `eobi_no` varchar(255) DEFAULT NULL,
  `eobi_date` varchar(255) DEFAULT NULL,
  `tax_no` varchar(255) DEFAULT NULL,
  `ticket_no` varchar(255) DEFAULT NULL,
  `qualifications` varchar(255) DEFAULT NULL,
  `experience` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `id_father_name` varchar(255) DEFAULT NULL,
  `sno` varchar(255) DEFAULT NULL,
  `personal_joining_date` varchar(255) DEFAULT NULL,
  `personal_leaving_date` varchar(255) DEFAULT NULL,
  `party_id` varchar(255) DEFAULT NULL,
  `ytax` varchar(255) DEFAULT NULL,
  `tax_order` varchar(255) DEFAULT NULL,
  `tax_remarks` varchar(255) DEFAULT NULL,
  `eobi_assign` varchar(255) DEFAULT NULL,
  `eobi_sno` varchar(255) DEFAULT NULL,
  `tax_name` varchar(255) DEFAULT NULL,
  `tax_father_name` varchar(255) DEFAULT NULL,
  `challan_no` varchar(255) DEFAULT NULL,
  `challan_date` varchar(255) DEFAULT NULL,
  `c87` varchar(255) DEFAULT NULL,
  `cpr_no` varchar(255) DEFAULT NULL,
  `tax_effect_date` varchar(255) DEFAULT NULL,
  `tax_active` varchar(255) DEFAULT NULL,
  `company_no` varchar(255) DEFAULT NULL,
  `expr_1002` varchar(255) DEFAULT NULL,
  `dept_no` varchar(255) DEFAULT NULL,
  `group_no` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `bank_id` varchar(255) DEFAULT NULL,
  `bank_account_title` varchar(255) DEFAULT NULL,
  `bank_account_no` varchar(255) DEFAULT NULL,
  `sal_master_doj` varchar(255) DEFAULT NULL,
  `sal_master_dol` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `temp_employee5` */

/*Table structure for table `temp_register_20190913154021` */

CREATE TABLE `temp_register_20190913154021` (
  `payroll_id` char(38) NOT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `department_name` varchar(255) DEFAULT NULL,
  `document_date` varchar(255) DEFAULT NULL,
  `document_title` varchar(255) DEFAULT NULL,
  `employee_registration_id` char(38) DEFAULT NULL,
  `employee_id` char(38) DEFAULT NULL,
  `Reg No.` varchar(255) DEFAULT NULL,
  `Name` varchar(255) DEFAULT NULL,
  `Department` varchar(255) DEFAULT NULL,
  `S&A` decimal(11,2) NOT NULL DEFAULT '0.00',
  `Salary` decimal(11,2) NOT NULL DEFAULT '0.00',
  `Arrears` decimal(11,2) NOT NULL DEFAULT '0.00',
  `Bonus` decimal(11,2) NOT NULL DEFAULT '0.00',
  `Conveyance` decimal(11,2) NOT NULL DEFAULT '0.00',
  `Special` decimal(11,2) NOT NULL DEFAULT '0.00',
  `Overtime` decimal(11,2) NOT NULL DEFAULT '0.00',
  `MADD` decimal(11,2) NOT NULL DEFAULT '0.00',
  `OVT` decimal(11,2) NOT NULL DEFAULT '0.00',
  `Gross` decimal(11,2) NOT NULL DEFAULT '0.00',
  `OTH` decimal(11,2) NOT NULL DEFAULT '0.00',
  `QTM-1` decimal(11,2) NOT NULL DEFAULT '0.00',
  `EOBI` decimal(11,2) NOT NULL DEFAULT '0.00',
  `QTM-QH` decimal(11,2) NOT NULL DEFAULT '0.00',
  `ITAX` decimal(11,2) NOT NULL DEFAULT '0.00',
  `MDED` decimal(11,2) NOT NULL DEFAULT '0.00',
  `TAX` decimal(11,2) NOT NULL DEFAULT '0.00',
  `ATT Deduction` decimal(11,2) NOT NULL DEFAULT '0.00',
  `Payable` decimal(11,2) NOT NULL DEFAULT '0.00',
  `CHQ` varchar(255) NOT NULL,
  PRIMARY KEY (`payroll_id`),
  KEY `employee_id` (`employee_id`),
  KEY `employee_registration_id` (`employee_registration_id`),
  KEY `department_name` (`department_name`),
  KEY `Reg No.` (`Reg No.`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `temp_register_20190913154021` */

/*Table structure for table `tm_project` */

CREATE TABLE `tm_project` (
  `company_id` int(11) NOT NULL,
  `project_id` char(38) NOT NULL,
  `project_title` varchar(32) NOT NULL,
  `project_description` text,
  `project_color` varchar(64) DEFAULT NULL,
  `project_archived` enum('False','True') NOT NULL DEFAULT 'True',
  `created_at` datetime DEFAULT NULL,
  `created_by` varchar(32) NOT NULL,
  `created_by_id` int(11) NOT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by` varchar(32) DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tm_project` */

/*Table structure for table `tm_story` */

CREATE TABLE `tm_story` (
  `company_id` int(11) NOT NULL,
  `project_id` char(38) NOT NULL,
  `task_id` char(38) NOT NULL,
  `story_id` char(38) NOT NULL,
  `story_date` date NOT NULL,
  `text` text NOT NULL,
  `html` text NOT NULL,
  `hours` int(11) NOT NULL DEFAULT '0',
  `minutes` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `created_by` varchar(32) DEFAULT NULL,
  `created_by_id` char(38) DEFAULT NULL,
  PRIMARY KEY (`story_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tm_story` */

/*Table structure for table `tm_task` */

CREATE TABLE `tm_task` (
  `company_id` int(11) NOT NULL,
  `project_id` char(38) NOT NULL,
  `task_id` char(38) NOT NULL,
  `task_title` varchar(128) NOT NULL,
  `task_comment` text NOT NULL,
  `task_html_comment` text NOT NULL,
  `task_status` varchar(16) NOT NULL,
  `task_due_at` datetime DEFAULT NULL,
  `tags` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by_id` int(11) NOT NULL DEFAULT '0',
  `created_by` varchar(255) NOT NULL,
  `modified_at` datetime DEFAULT NULL,
  `modified_by_id` int(11) DEFAULT '0',
  `modified_by` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tm_task` */

/*Table structure for table `tmp_csv_file` */

CREATE TABLE `tmp_csv_file` (
  `employee_code` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `from_time` varchar(10) DEFAULT NULL,
  `to_time` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `tmp_csv_file` */

/*Table structure for table `user` */

CREATE TABLE `user` (
  `employee_id` char(38) DEFAULT NULL,
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_permission_id` int(11) NOT NULL,
  `login_name` varchar(20) NOT NULL DEFAULT '',
  `login_password` varchar(32) NOT NULL DEFAULT '',
  `user_name` varchar(32) NOT NULL DEFAULT '',
  `email` varchar(96) NOT NULL DEFAULT '',
  `user_image` varchar(255) NOT NULL DEFAULT '',
  `status` enum('Active','Inactive') NOT NULL DEFAULT 'Inactive',
  `colour_theme` varchar(255) DEFAULT NULL,
  `access_token` text,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Data for the table `user` */

insert  into `user`(`employee_id`,`user_id`,`user_permission_id`,`login_name`,`login_password`,`user_name`,`email`,`user_image`,`status`,`colour_theme`,`access_token`,`created_at`,`created_by_id`) values (NULL,1,1,'admin','2ca31d1dc5483ce92a8352352730958e','Mustafa Aziz','m.aziz5152@gmail.com','user_image_1.png','Active','skin-blue','eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.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.Eo-ejBetbLhpBLGQVTtX7WUgLuieOwBAjtpoUnAlxpU',NULL,NULL),(NULL,9,1,'huzaifa.khambaty','d8a8a2d126d19f9316dad39498c32b0b','Huzaifa Khambaty','huzaifa.khambaty@gmail.com','','Active','skin-blue',NULL,'2019-03-26 16:42:45',1),(NULL,25,7,'uzair','1148ec527b78b53dc49ce4bf475fcd8d','uzair','test@test.test','','Active','skin-blue',NULL,'2022-06-22 10:14:21',1);

/*Table structure for table `user_access` */

CREATE TABLE `user_access` (
  `user_access_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` char(40) NOT NULL,
  PRIMARY KEY (`user_access_id`)
) ENGINE=InnoDB AUTO_INCREMENT=390 DEFAULT CHARSET=utf8;

/*Data for the table `user_access` */

insert  into `user_access`(`user_access_id`,`user_id`,`company_id`,`created_at`,`created_by_id`) values (8,2,3,'2018-07-09 12:10:36','1'),(23,4,5,'2018-07-13 12:17:11','1'),(29,5,6,'2018-07-17 13:33:37','1'),(99,7,7,'2018-08-07 07:58:18','3'),(100,7,8,'2018-08-07 07:58:18','3'),(101,7,9,'2018-08-07 07:58:18','3'),(121,8,10,'2018-08-18 09:55:44','1'),(143,3,1,'2019-10-18 13:32:57','1'),(144,3,2,'2019-10-18 13:32:57','1'),(145,3,3,'2019-10-18 13:32:57','1'),(146,3,4,'2019-10-18 13:32:57','1'),(147,3,5,'2019-10-18 13:32:57','1'),(148,3,6,'2019-10-18 13:32:57','1'),(149,3,7,'2019-10-18 13:32:57','1'),(150,3,8,'2019-10-18 13:32:57','1'),(151,3,9,'2019-10-18 13:32:57','1'),(152,3,10,'2019-10-18 13:32:57','1'),(153,3,11,'2019-10-18 13:32:57','1'),(190,12,14,'2020-06-30 14:07:25','6'),(191,13,11,'2020-06-30 14:07:34','6'),(192,9,1,'2020-07-09 15:55:38','9'),(193,9,2,'2020-07-09 15:55:38','9'),(194,9,3,'2020-07-09 15:55:38','9'),(195,9,4,'2020-07-09 15:55:38','9'),(196,9,5,'2020-07-09 15:55:38','9'),(197,9,6,'2020-07-09 15:55:38','9'),(198,9,7,'2020-07-09 15:55:38','9'),(199,9,8,'2020-07-09 15:55:38','9'),(200,9,9,'2020-07-09 15:55:38','9'),(201,9,10,'2020-07-09 15:55:38','9'),(202,9,11,'2020-07-09 15:55:38','9'),(203,9,14,'2020-07-09 15:55:38','9'),(204,10,3,'2020-07-11 11:40:25','6'),(327,14,2,'2022-02-02 15:16:21','14'),(328,14,4,'2022-02-02 15:16:21','14'),(329,14,5,'2022-02-02 15:16:21','14'),(330,14,6,'2022-02-02 15:16:21','14'),(331,14,17,'2022-02-02 15:16:21','14'),(335,15,4,'2022-03-24 10:48:59','1'),(336,16,4,'2022-03-24 10:49:30','1'),(337,17,4,'2022-03-24 11:09:54','1'),(338,11,5,'2022-03-24 11:11:07','1'),(339,1,1,'2022-03-24 11:13:58','1'),(340,1,2,'2022-03-24 11:13:58','1'),(341,1,3,'2022-03-24 11:13:58','1'),(342,1,4,'2022-03-24 11:13:58','1'),(343,1,5,'2022-03-24 11:13:58','1'),(344,1,6,'2022-03-24 11:13:58','1'),(345,1,7,'2022-03-24 11:13:58','1'),(346,1,8,'2022-03-24 11:13:58','1'),(347,1,9,'2022-03-24 11:13:58','1'),(348,1,10,'2022-03-24 11:13:58','1'),(349,1,11,'2022-03-24 11:13:58','1'),(350,1,12,'2022-03-24 11:13:58','1'),(351,1,13,'2022-03-24 11:13:58','1'),(352,1,14,'2022-03-24 11:13:58','1'),(353,1,15,'2022-03-24 11:13:58','1'),(354,1,16,'2022-03-24 11:13:58','1'),(355,1,17,'2022-03-24 11:13:58','1'),(356,1,18,'2022-03-24 11:13:58','1'),(357,1,19,'2022-03-24 11:13:58','1'),(358,18,19,'2022-03-24 11:37:31','1'),(361,6,1,'2022-03-24 12:21:50','1'),(362,6,2,'2022-03-24 12:21:50','1'),(363,6,3,'2022-03-24 12:21:50','1'),(364,6,4,'2022-03-24 12:21:50','1'),(365,6,5,'2022-03-24 12:21:50','1'),(366,6,6,'2022-03-24 12:21:50','1'),(367,6,7,'2022-03-24 12:21:50','1'),(368,6,8,'2022-03-24 12:21:50','1'),(369,6,9,'2022-03-24 12:21:50','1'),(370,6,10,'2022-03-24 12:21:50','1'),(371,6,11,'2022-03-24 12:21:50','1'),(372,6,14,'2022-03-24 12:21:50','1'),(373,23,6,'2022-03-25 13:12:52','1'),(374,21,2,'2022-03-25 15:36:08','1'),(376,24,2,'2022-03-29 10:43:27','1'),(379,19,2,'2022-03-29 11:28:43','1'),(380,22,2,'2022-03-29 11:30:52','1'),(381,20,2,'2022-04-28 13:40:42','1'),(382,20,5,'2022-04-28 13:40:42','1'),(383,20,19,'2022-04-28 13:40:42','1'),(388,25,1,'2022-06-22 10:15:57','1'),(389,25,2,'2022-06-22 10:15:57','1');

/*Table structure for table `user_department` */

CREATE TABLE `user_department` (
  `user_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`company_id`,`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_department` */

insert  into `user_department`(`user_id`,`company_id`,`department_id`) values (1,2,3),(1,2,4),(1,2,5),(1,2,6),(1,2,7),(1,2,8),(1,2,9),(1,2,10),(1,2,11),(1,2,12),(1,2,142),(1,2,161),(1,2,166),(1,2,177),(1,2,180),(1,2,181),(1,2,184),(1,2,199),(1,2,202),(1,2,210),(1,3,218),(1,3,219),(1,3,220),(1,3,224),(1,5,131),(1,5,133),(1,5,173),(1,5,174),(1,6,132),(1,6,134),(1,11,165),(1,14,183),(1,17,205),(1,17,206),(1,17,207),(3,2,3),(3,2,4),(3,2,5),(3,2,6),(3,2,7),(3,2,8),(3,2,9),(3,2,10),(3,2,11),(3,2,12),(3,2,142),(3,2,161),(3,2,166),(3,2,177),(3,2,180),(3,2,181),(3,2,184),(3,2,199),(3,2,202),(3,2,210),(3,3,224),(3,4,48),(3,4,49),(3,4,144),(6,2,3),(6,2,5),(6,2,7),(6,2,10),(6,2,161),(6,2,199),(7,7,136),(9,3,15),(9,3,16),(9,3,17),(9,3,18),(9,3,19),(9,3,20),(9,3,224),(9,3,225),(10,3,14),(10,3,15),(10,3,16),(10,3,17),(10,3,18),(10,3,19),(10,3,20),(10,3,21),(10,3,22),(10,3,23),(10,3,24),(10,3,25),(10,3,26),(10,3,27),(10,3,28),(10,3,29),(10,3,30),(10,3,31),(10,3,32),(10,3,33),(10,3,34),(10,3,35),(10,3,36),(10,3,37),(10,3,38),(10,3,39),(10,3,40),(10,3,41),(10,3,42),(10,3,43),(10,3,44),(10,3,45),(10,3,46),(10,3,143),(10,3,146),(10,3,148),(10,3,149),(10,3,150),(10,3,151),(10,3,152),(10,3,153),(10,3,154),(10,3,155),(10,3,156),(10,3,157),(10,3,158),(10,3,159),(10,3,160),(10,3,163),(10,3,176),(10,3,179),(10,3,196),(10,3,198),(10,3,200),(10,3,201),(10,3,211),(10,3,216),(10,3,223),(10,3,224),(10,3,225),(10,3,226),(11,5,131),(11,5,173),(11,5,174),(12,14,183),(15,4,164),(15,4,214),(16,4,52),(17,4,52),(18,19,221),(18,19,227),(18,19,228),(19,2,202),(19,2,231),(20,2,145),(20,2,230),(20,5,174),(20,19,227),(21,2,2),(21,2,142),(22,2,6),(22,2,7),(22,2,10),(22,2,177),(23,6,132),(23,6,134),(24,2,13),(24,2,178);

/*Table structure for table `user_login` */

CREATE TABLE `user_login` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `last_login_date` datetime DEFAULT NULL,
  `last_login_ip` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  `last_password_changed` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `user_login` */

insert  into `user_login`(`user_id`,`last_login_date`,`last_login_ip`,`last_password_changed`) values (1,'2022-07-13 10:21:51','119.152.102.137','2022-07-13 10:21:51'),(9,'2022-07-10 20:54:39','182.180.191.125','2022-07-10 20:54:39'),(25,'2022-06-22 10:16:21','119.152.102.137','2022-06-22 10:16:21');

/*Table structure for table `user_permission` */

CREATE TABLE `user_permission` (
  `user_permission_id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `permission` text NOT NULL,
  PRIMARY KEY (`user_permission_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Data for the table `user_permission` */

insert  into `user_permission`(`user_permission_id`,`company_id`,`name`,`permission`) values (1,2,'Top Administrator','a:72:{s:26:\"employee/covid_certificate\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:28:\"employee/employee_attendance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:23:\"employee/employee_leave\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:25:\"employee/employee_profile\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:30:\"employee/employee_registration\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:22:\"employee/hod_allowance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:18:\"employee/hod_leave\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:26:\"employee/sesi_contribution\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:20:\"employee/sesi_member\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:22:\"employee/total_payroll\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:23:\"payroll/account_posting\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:15:\"payroll/advance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:25:\"payroll/allowance_posting\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:19:\"payroll/bank_letter\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:20:\"payroll/deposit_slip\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:20:\"payroll/enayat_event\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:24:\"payroll/generate_payroll\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:25:\"payroll/individual_cheque\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:12:\"payroll/loan\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:22:\"payroll/manual_payroll\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:15:\"payroll/payroll\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:24:\"payroll/salary_increment\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:25:\"payroll/special_allowance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:22:\"payroll/special_enayat\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:19:\"payroll/tax_challan\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:30:\"report/allowance_covering_list\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:26:\"report/employee_attendance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:20:\"report/employee_data\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:24:\"report/employee_data_old\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:21:\"report/employee_leave\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:23:\"report/employee_profile\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:11:\"report/eobi\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:29:\"report/income_tax_certificate\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:23:\"report/payroll_register\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:19:\"report/payroll_slip\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:24:\"report/salary_comparison\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:23:\"report/saving_statement\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:20:\"report/tax_deduction\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:18:\"report/tax_summary\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:28:\"report/withholding_statement\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:15:\"setup/allowance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:22:\"setup/attendance_shift\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:10:\"setup/bank\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:11:\"setup/class\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:13:\"setup/company\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:21:\"setup/company_account\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:18:\"setup/core_setting\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:15:\"setup/dashboard\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:15:\"setup/deduction\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:16:\"setup/department\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:17:\"setup/designation\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:23:\"setup/employee_category\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:17:\"setup/fiscal_year\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:13:\"setup/holiday\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:18:\"setup/medical_type\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:20:\"setup/parent_company\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:19:\"setup/qualification\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:12:\"setup/school\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:13:\"setup/section\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:32:\"setup/special_allowance_category\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:14:\"setup/tax_slab\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:11:\"tool/backup\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:10:\"tool/email\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:14:\"tool/error_log\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:13:\"tool/reminder\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:8:\"tool/sms\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:9:\"tool/sync\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:14:\"user/dashboard\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:9:\"user/user\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:20:\"user/user_department\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:20:\"user/user_permission\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:17:\"user/user_profile\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}}'),(2,1,'Operator','a:7:{s:28:\"employee/employee_attendance\";a:2:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";}s:23:\"employee/employee_leave\";a:2:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";}s:25:\"employee/employee_profile\";a:2:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";}s:30:\"employee/employee_registration\";a:2:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";}s:15:\"payroll/advance\";a:2:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";}s:24:\"payroll/generate_payroll\";a:2:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";}s:12:\"payroll/loan\";a:2:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";}}'),(3,1,'DH Accounts','a:5:{s:28:\"employee/employee_attendance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:23:\"employee/employee_leave\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:25:\"employee/employee_profile\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:30:\"employee/employee_registration\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:17:\"user/user_profile\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}}'),(4,1,'Allowance Submission (Scholarship/Medical)','a:2:{s:22:\"employee/hod_allowance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:30:\"report/allowance_covering_list\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}}'),(5,3,'Office Admin','a:2:{s:22:\"employee/hod_allowance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:18:\"employee/hod_leave\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}}'),(6,5,'HOD User','a:3:{s:23:\"employee/employee_leave\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:18:\"employee/hod_leave\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:26:\"report/employee_attendance\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}}'),(7,1,'data entry','a:5:{s:25:\"employee/employee_profile\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:30:\"employee/employee_registration\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:16:\"setup/department\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:17:\"setup/designation\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}s:17:\"user/user_profile\";a:5:{s:4:\"view\";s:1:\"1\";s:6:\"insert\";s:1:\"1\";s:6:\"update\";s:1:\"1\";s:6:\"delete\";s:1:\"1\";s:4:\"post\";s:1:\"1\";}}');

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
