CREATE VIEW `vw_advance` AS SELECT `a`.`company_id` AS `company_id`,`a`.`fiscal_year_id` AS `fiscal_year_id`,`a`.`advance_id` AS `advance_id`,`a`.`employee_registration_id` AS `employee_registration_id`,`a`.`registration_code` AS `registration_code`,`a`.`employee_id` AS `employee_id`,`a`.`employee_code` AS `employee_code`,`a`.`date` AS `date`,`a`.`amount` AS `amount`,`a`.`description` AS `description`,`a`.`company_account_id` AS `company_account_id`,`a`.`cheque_date` AS `cheque_date`,`a`.`cheque_no` AS `cheque_no`,`a`.`payroll_id` AS `payroll_id`,`a`.`payroll_deduction_id` AS `payroll_deduction_id`,`a`.`created_at` AS `created_at`,`a`.`created_by_id` AS `created_by_id`,`a`.`modified_at` AS `modified_at`,`a`.`modified_by_id` AS `modified_by_id`,`e`.`full_name` AS `employee_name`,`ca`.`bank_id` AS `bank_id`,`ca`.`bank_branch` AS `bank_branch`,`ca`.`account_title` AS `account_title`,`ca`.`account_no` AS `account_no`,`ca`.`iban` AS `iban` FROM ((`advance` `a` JOIN `employee` `e` ON((`e`.`employee_id` = `a`.`employee_id`))) LEFT JOIN `company_account` `ca` ON((`ca`.`company_account_id` = `a`.`company_account_id`)));
CREATE VIEW `vw_allowance_posting` AS SELECT `ap`.`allowance_posting_id` AS `allowance_posting_id`,`ap`.`company_id` AS `company_id`,`ap`.`fiscal_year_id` AS `fiscal_year_id`,`ap`.`document_date` AS `document_date`,`ap`.`document_no` AS `document_no`,`ap`.`document_identity` AS `document_identity`,`ap`.`document_title` AS `document_title`,`ap`.`pay_from_company_id` AS `pay_from_company_id`,`ap`.`company_account_id` AS `company_account_id`,`ap`.`bank_id` AS `bank_id`,`ap`.`bank_name` AS `bank_name`,`ap`.`bank_branch` AS `bank_branch`,`ap`.`account_title` AS `account_title`,`ap`.`account_no` AS `account_no`,`ap`.`iban` AS `iban`,`ap`.`party_id` AS `party_id`,`ap`.`ah_key` AS `ah_key`,`ap`.`special_allowance_type_id` AS `special_allowance_type_id`,`ap`.`from_allowance_date` AS `from_allowance_date`,`ap`.`to_allowance_date` AS `to_allowance_date`,`ap`.`department_id` AS `department_id`,`ap`.`total_amount` AS `total_amount`,`ap`.`created_at` AS `created_at`,`ap`.`created_by_id` AS `created_by_id`,`ap`.`modified_at` AS `modified_at`,`ap`.`modified_by_id` AS `modified_by_id`,`ap`.`is_post` AS `is_post`,`ap`.`post_at` AS `post_at`,`ap`.`post_by_id` AS `post_by_id`,`sat`.`special_allowance_type` AS `special_allowance_type`,`ca`.`party_id` AS `bank_party_id`,`ca`.`ah_key` AS `bank_ah_key` FROM ((`allowance_posting` `ap` LEFT JOIN `special_allowance_type` `sat` ON((`sat`.`special_allowance_type_id` = `ap`.`special_allowance_type_id`))) LEFT JOIN `company_account` `ca` ON((`ca`.`company_account_id` = `ap`.`company_account_id`)));
CREATE VIEW `vw_allowance_posting_detail` AS SELECT `ap`.`allowance_posting_id` AS `allowance_posting_id`,`ap`.`company_id` AS `company_id`,`ap`.`fiscal_year_id` AS `fiscal_year_id`,`ap`.`document_date` AS `document_date`,`ap`.`document_identity` AS `document_identity`,`ap`.`document_title` AS `document_title`,`ap`.`created_at` AS `created_at`,`ap`.`created_by_id` AS `created_by_id`,`apd`.`allowance_posting_detail_id` AS `allowance_posting_detail_id`,`apd`.`special_allowance_id` AS `special_allowance_id`,`apd`.`special_allowance_identity` AS `special_allowance_identity`,`apd`.`cheque_date` AS `cheque_date`,`apd`.`cheque_no` AS `cheque_no`,`apd`.`amount` AS `amount`,`apd`.`remarks` AS `remarks`,`apd`.`sort_order` AS `sort_order`,`e`.`full_name` AS `employee_name`,`e`.`cnic_name` AS `cnic_name`,`er`.`registration_code` AS `registration_code`,`er`.`party_id` AS `party_id`,`sat`.`special_allowance_type` AS `special_allowance_type`,`sat`.`SysTag` AS `TranCategory`,`sat`.`budget_key` AS `budget_key`,`sat`.`ah_key` AS `ah_key`,`c`.`ref_id` AS `Comp` FROM (((((`allowance_posting_detail` `apd` JOIN `allowance_posting` `ap` ON((`ap`.`allowance_posting_id` = `apd`.`allowance_posting_id`))) JOIN `special_allowance_type` `sat` ON((`sat`.`special_allowance_type_id` = `ap`.`special_allowance_type_id`))) JOIN `employee_registration` `er` ON((`er`.`employee_registration_id` = `apd`.`employee_registration_id`))) JOIN `employee` `e` ON((`e`.`employee_id` = `er`.`employee_id`))) LEFT JOIN `company` `c` ON((`c`.`company_id` = `ap`.`pay_from_company_id`)));
CREATE VIEW `vw_company_account` AS SELECT `ca`.`company_account_id` AS `company_account_id`,`ca`.`bank_id` AS `bank_id`,`ca`.`bank_branch` AS `bank_branch`,`ca`.`account_title` AS `account_title`,`ca`.`account_no` AS `account_no`,`ca`.`iban` AS `iban`,`ca`.`party_id` AS `party_id`,`ca`.`ah_key` AS `ah_key`,`ca`.`status` AS `status`,`ca`.`created_at` AS `created_at`,`ca`.`created_by_id` AS `created_by_id`,`ca`.`modified_at` AS `modified_at`,`ca`.`modified_by_id` AS `modified_by_id`,`ca`.`company_id` AS `company_id`,`b`.`bank_name` AS `bank_name` FROM (`company_account` `ca` LEFT JOIN `bank` `b` ON((`b`.`bank_id` = `ca`.`bank_id`)));
CREATE VIEW `vw_company_allowance` AS SELECT `a`.`allowance_id` AS `allowance_id`,`a`.`allowance_code` AS `allowance_code`,`a`.`allowance_name` AS `allowance_name`,`a`.`status` AS `status`,`a`.`created_at` AS `created_at`,`a`.`created_by_id` AS `created_by_id`,`a`.`modified_at` AS `modified_at`,`a`.`modified_by_id` AS `modified_by_id`,`ca`.`company_allowance_id` AS `company_allowance_id`,`ca`.`company_id` AS `company_id`,IF(ISNULL(`ca`.`allowance_id`),0,1) AS `selected` FROM (`allowance` `a` JOIN `company_allowance` `ca` ON((`ca`.`allowance_id` = `a`.`allowance_id`)));
CREATE VIEW `vw_company_deduction` AS SELECT `a`.`deduction_id` AS `deduction_id`,`a`.`deduction_code` AS `deduction_code`,`a`.`deduction_name` AS `deduction_name`,`a`.`company_account_id` AS `company_account_id`,`a`.`status` AS `status`,`a`.`created_at` AS `created_at`,`a`.`created_by_id` AS `created_by_id`,`a`.`modified_at` AS `modified_at`,`a`.`modified_by_id` AS `modified_by_id`,`ca`.`company_deduction_id` AS `company_deduction_id`,`ca`.`company_id` AS `company_id`,IF(ISNULL(`ca`.`deduction_id`),0,1) AS `selected` FROM (`deduction` `a` JOIN `company_deduction` `ca` ON((`ca`.`deduction_id` = `a`.`deduction_id`)));
CREATE VIEW `vw_deduction` AS SELECT `d`.`deduction_id` AS `deduction_id`,`d`.`deduction_code` AS `deduction_code`,`d`.`deduction_name` AS `deduction_name`,`d`.`company_account_id` AS `company_account_id`,`d`.`status` AS `status`,`d`.`created_at` AS `created_at`,`d`.`created_by_id` AS `created_by_id`,`d`.`modified_at` AS `modified_at`,`d`.`modified_by_id` AS `modified_by_id`,`ca`.`account_no` AS `account_no`,`ca`.`account_title` AS `account_title`,`ca`.`iban` AS `iban` FROM (`deduction` `d` LEFT JOIN `company_account` `ca` ON((`ca`.`company_account_id` = `d`.`company_account_id`)));
CREATE VIEW `vw_department` AS SELECT `d`.`department_id` AS `department_id`,`d`.`company_id` AS `company_id`,`d`.`department_code` AS `department_code`,`d`.`department_name` AS `department_name`,`d`.`address` AS `address`,`d`.`phone_no` AS `phone_no`,`d`.`party_id` AS `party_id`,`d`.`ah_key` AS `ah_key`,`d`.`override_attendance_policy` AS `override_attendance_policy`,`d`.`override_allowance_policy` AS `override_allowance_policy`,`d`.`attendance_exempted` AS `attendance_exempted`,`d`.`deduction_days` AS `deduction_days`,`d`.`deduction_percent` AS `deduction_percent`,`d`.`budget_key` AS `budget_key`,`d`.`status` AS `status`,`d`.`created_at` AS `created_at`,`d`.`created_by_id` AS `created_by_id`,`d`.`ref_id` AS `ref_id`,`c`.`company_name` AS `company_name`,(SELECT COUNT(0) FROM `employee_registration` `er` WHERE ((`er`.`company_id` = `d`.`company_id`) AND (`er`.`department_id` = `d`.`department_id`))) AS `total_registration` FROM (`department` `d` JOIN `company` `c` ON((`c`.`company_id` = `d`.`company_id`)));
CREATE VIEW `vw_employee` AS SELECT `e`.`employee_id` AS `employee_id`,`e`.`login_id` AS `login_id`,`e`.`login_password` AS `login_password`,`e`.`company_id` AS `company_id`,`e`.`employee_image` AS `employee_image`,`e`.`employee_code` AS `employee_code`,`e`.`title_first_name` AS `title_first_name`,`e`.`first_name` AS `first_name`,`e`.`title_middle_name` AS `title_middle_name`,`e`.`middle_name` AS `middle_name`,`e`.`surname` AS `surname`,`e`.`full_name` AS `full_name`,`e`.`its_no` AS `its_no`,`e`.`dob` AS `dob`,`e`.`gender` AS `gender`,`e`.`marital_status` AS `marital_status`,`e`.`mobile_no` AS `mobile_no`,`e`.`phone_no` AS `phone_no`,`e`.`email` AS `email`,`e`.`qualification_id` AS `qualification_id`,`e`.`employee_category_id` AS `employee_category_id`,`e`.`city` AS `city`,`e`.`area` AS `area`,`e`.`nationality` AS `nationality`,`e`.`cnic_no` AS `cnic_no`,`e`.`cnic_name` AS `cnic_name`,`e`.`cnic_expiry` AS `cnic_expiry`,`e`.`cnic_address` AS `cnic_address`,`e`.`nicop_no` AS `nicop_no`,`e`.`nicop_name` AS `nicop_name`,`e`.`nicop_expiry` AS `nicop_expiry`,`e`.`nicop_address` AS `nicop_address`,`e`.`passport_no` AS `passport_no`,`e`.`passport_name` AS `passport_name`,`e`.`passport_expiry` AS `passport_expiry`,`e`.`passport_address` AS `passport_address`,`e`.`eobi_no` AS `eobi_no`,`e`.`eobi_date` AS `eobi_date`,`e`.`eobi_sno` AS `eobi_sno`,`e`.`ntn_no` AS `ntn_no`,`e`.`probation_from` AS `probation_from`,`e`.`probation_to` AS `probation_to`,`e`.`ramzan_enayat` AS `ramzan_enayat`,`e`.`joining_date` AS `joining_date`,`e`.`party_id` AS `party_id`,`e`.`created_at` AS `created_at`,`e`.`created_by_id` AS `created_by_id`,`e`.`modified_at` AS `modified_at`,`e`.`modified_by_id` AS `modified_by_id`,`q`.`qualification` AS `qualification`,(SELECT COUNT(0) FROM `employee_registration` `er` WHERE (`er`.`employee_id` = `e`.`employee_id`)) AS `total_registration` FROM (`employee` `e` LEFT JOIN `qualification` `q` ON((`q`.`qualification_id` = `e`.`qualification_id`)));
CREATE VIEW `vw_employee_registration` AS SELECT `er`.`company_id` AS `company_id`,`er`.`employee_id` AS `employee_id`,`er`.`employee_registration_id` AS `employee_registration_id`,`er`.`registration_code` AS `registration_code`,`er`.`attendance_code` AS `attendance_code`,`er`.`department_id` AS `department_id`,`er`.`designation_id` AS `designation_id`,`er`.`attendance_shift_id` AS `attendance_shift_id`,`er`.`joining_date` AS `joining_date`,`er`.`leaving_date` AS `leaving_date`,`er`.`employee_bank_id` AS `employee_bank_id`,`er`.`bank_id` AS `bank_id`,`er`.`bank_account` AS `bank_account`,`er`.`bank_title` AS `bank_title`,`er`.`bank_iban` AS `bank_iban`,`er`.`arrears` AS `arrears`,`er`.`status` AS `status`,`er`.`total_payroll` AS `total_payroll`,`er`.`created_at` AS `created_at`,`er`.`created_by_id` AS `created_by_id`,`er`.`modified_at` AS `modified_at`,`er`.`modified_by_id` AS `modified_by_id`,`er`.`party_id` AS `party_id`,`er`.`attendance_exempted` AS `attendance_exempted`,`e`.`employee_image` AS `employee_image`,`e`.`employee_code` AS `employee_code`,`e`.`title_first_name` AS `title_first_name`,`e`.`first_name` AS `first_name`,`e`.`title_middle_name` AS `title_middle_name`,`e`.`middle_name` AS `middle_name`,`e`.`full_name` AS `employee_name`,`e`.`dob` AS `dob`,`e`.`gender` AS `gender`,`e`.`mobile_no` AS `mobile_no`,`e`.`phone_no` AS `phone_no`,`e`.`email` AS `email`,`e`.`its_no` AS `its_no`,`e`.`cnic_no` AS `cnic_no`,`e`.`cnic_name` AS `cnic_name`,`e`.`cnic_address` AS `cnic_address`,`e`.`eobi_date` AS `eobi_date`,`e`.`eobi_no` AS `eobi_no`,`e`.`ntn_no` AS `ntn_no`,`e`.`surname` AS `surname`,`e`.`marital_status` AS `marital_status`,`e`.`city` AS `city`,`e`.`area` AS `area`,`e`.`nationality` AS `nationality`,`e`.`cnic_expiry` AS `cnic_expiry`,`e`.`eobi_sno` AS `eobi_sno`,`e`.`probation_from` AS `probation_from`,`e`.`probation_to` AS `probation_to`,`e`.`ramzan_enayat` AS `ramzan_enayat`,`e`.`nicop_no` AS `nicop_no`,`e`.`nicop_name` AS `nicop_name`,`e`.`nicop_expiry` AS `nicop_expiry`,`e`.`nicop_address` AS `nicop_address`,`e`.`passport_no` AS `passport_no`,`e`.`passport_name` AS `passport_name`,`e`.`passport_expiry` AS `passport_expiry`,`e`.`passport_address` AS `passport_address`,`c`.`parent_company_id` AS `parent_company_id`,`c`.`company_name` AS `company_name`,`c`.`eobi_party_id` AS `eobi_party_id`,`c`.`eobi_ah_key` AS `eobi_ah_key`,`c`.`tax_party_id` AS `tax_party_id`,`c`.`tax_ah_key` AS `tax_ah_key`,`d`.`department_name` AS `department_name`,`d`.`party_id` AS `dept_party_id`,`d`.`ah_key` AS `dept_ah_key`,`d`.`budget_key` AS `dept_budget_key`,`ds`.`designation_name` AS `designation_name`,`s`.`shift_title` AS `shift_title`,`s`.`late_deduction` AS `late_deduction`,`b`.`bank_name` AS `bank_name` FROM ((((((`employee_registration` `er` LEFT JOIN `company` `c` ON((`c`.`company_id` = `er`.`company_id`))) LEFT JOIN `employee` `e` ON((`e`.`employee_id` = `er`.`employee_id`))) LEFT JOIN `department` `d` ON((`d`.`department_id` = `er`.`department_id`))) LEFT JOIN `designation` `ds` ON((`ds`.`designation_id` = `er`.`designation_id`))) LEFT JOIN `attendance_shift` `s` ON((`s`.`attendance_shift_id` = `er`.`attendance_shift_id`))) LEFT JOIN `bank` `b` ON((`b`.`bank_id` = `er`.`bank_id`)));
CREATE VIEW `vw_employee_allowance` AS SELECT `ea`.`employee_salary_id` AS `employee_salary_id`,`ea`.`employee_registration_id` AS `employee_registration_id`,`ea`.`employee_allowance_id` AS `employee_allowance_id`,`ea`.`allowance_id` AS `allowance_id`,`ea`.`allowance_amount` AS `allowance_amount`,`ea`.`grossable` AS `grossable`,`ea`.`taxable` AS `taxable`,`ea`.`created_at` AS `created_at`,`ea`.`created_by_id` AS `created_by_id`,`ea`.`modified_at` AS `modified_at`,`ea`.`modified_by_id` AS `modified_by_id`,`a`.`allowance_code` AS `allowance_code`,`a`.`allowance_name` AS `allowance_name`,`es`.`wef_date` AS `wef_date`,`es`.`basic_salary` AS `basic_salary` FROM ((`employee_allowance` `ea` JOIN `allowance` `a` ON((`a`.`allowance_id` = `ea`.`allowance_id`))) JOIN `employee_salary` `es` ON((`es`.`employee_salary_id` = `ea`.`employee_salary_id`)));
CREATE VIEW `vw_employee_bank` AS SELECT `eb`.`employee_bank_id` AS `employee_bank_id`,`eb`.`employee_id` AS `employee_id`,`eb`.`sort_order` AS `sort_order`,`eb`.`bank_id` AS `bank_id`,`eb`.`account_no` AS `account_no`,`eb`.`account_title` AS `account_title`,`eb`.`iban_no` AS `iban_no`,`eb`.`created_at` AS `created_at`,`eb`.`created_by_id` AS `created_by_id`,`eb`.`modified_at` AS `modified_at`,`eb`.`modified_by_id` AS `modified_by_id`,`b`.`bank_name` AS `bank_name` FROM (`employee_bank` `eb` JOIN `bank` `b` ON((`b`.`bank_id` = `eb`.`bank_id`)));
CREATE VIEW `vw_employee_deduction` AS SELECT `ed`.`employee_salary_id` AS `employee_salary_id`,`ed`.`employee_registration_id` AS `employee_registration_id`,`ed`.`employee_deduction_id` AS `employee_deduction_id`,`ed`.`deduction_id` AS `deduction_id`,`ed`.`deduction_amount` AS `deduction_amount`,`ed`.`created_at` AS `created_at`,`ed`.`created_by_id` AS `created_by_id`,`ed`.`modified_at` AS `modified_at`,`ed`.`modified_by_id` AS `modified_by_id`,`d`.`deduction_code` AS `deduction_code`,`d`.`deduction_name` AS `deduction_name`,`ca`.`bank_id` AS `bank_id`,`ca`.`bank_branch` AS `bank_branch`,`ca`.`account_title` AS `account_title`,`ca`.`account_no` AS `account_no`,`ca`.`iban` AS `iban`,`es`.`wef_date` AS `wef_date`,`es`.`basic_salary` AS `basic_salary` FROM (((`employee_deduction` `ed` JOIN `deduction` `d` ON((`d`.`deduction_id` = `ed`.`deduction_id`))) JOIN `employee_salary` `es` ON((`es`.`employee_salary_id` = `ed`.`employee_salary_id`))) LEFT JOIN `company_account` `ca` ON((`ca`.`company_account_id` = `d`.`company_account_id`)));
CREATE VIEW `vw_employee_family` AS SELECT `ef`.`employee_family_id` AS `employee_family_id`,`ef`.`employee_id` AS `employee_id`,`ef`.`sort_order` AS `sort_order`,`ef`.`relation` AS `relation`,`ef`.`full_name` AS `full_name`,`ef`.`qualification_id` AS `qualification_id`,`ef`.`school_id` AS `school_id`,`ef`.`class_id` AS `class_id`,`ef`.`period_start_date` AS `period_start_date`,`ef`.`period_end_date` AS `period_end_date`,`ef`.`cnic_no` AS `cnic_no`,`ef`.`its_no` AS `its_no`,`ef`.`dob` AS `dob`,`ef`.`mobile_no` AS `mobile_no`,`ef`.`email` AS `email`,`ef`.`created_at` AS `created_at`,`ef`.`created_by_id` AS `created_by_id`,`ef`.`modified_at` AS `modified_at`,`ef`.`modified_by_id` AS `modified_by_id`,`s`.`school_name` AS `school_name`,`c`.`class_name` AS `class_name`,`q`.`qualification` AS `qualification` FROM (((`employee_family` `ef` LEFT JOIN `school` `s` ON((`s`.`school_id` = `ef`.`school_id`))) LEFT JOIN `class` `c` ON((`c`.`class_id` = `ef`.`class_id`))) LEFT JOIN `qualification` `q` ON((`q`.`qualification_id` = `ef`.`qualification_id`)));
CREATE VIEW `vw_employee_leave` AS SELECT `el`.`company_id` AS `company_id`,`el`.`employee_leave_id` AS `employee_leave_id`,`el`.`request_date` AS `request_date`,`el`.`employee_registration_id` AS `employee_registration_id`,`el`.`leave_from` AS `leave_from`,`el`.`leave_to` AS `leave_to`,`el`.`reason` AS `reason`,`el`.`description` AS `description`,`el`.`status` AS `status`,`el`.`is_post` AS `is_post`,`el`.`approved_type` AS `approved_type`,`el`.`approved_from` AS `approved_from`,`el`.`approved_to` AS `approved_to`,`el`.`remarks` AS `remarks`,`el`.`created_at` AS `created_at`,`el`.`created_by_id` AS `created_by_id`,`el`.`modified_at` AS `modified_at`,`el`.`modified_by_id` AS `modified_by_id`,`er`.`registration_code` AS `registration_code`,`er`.`employee_id` AS `employee_id`,`er`.`employee_code` AS `employee_code`,`er`.`employee_name` AS `employee_name`,`er`.`department_id` AS `department_id`,`er`.`department_name` AS `department_name`,`er`.`company_name` AS `company_name` FROM (`employee_leave` `el` JOIN `vw_employee_registration` `er` ON((`er`.`employee_registration_id` = `el`.`employee_registration_id`)));
CREATE VIEW `vw_employee_medical` AS SELECT `em`.`employee_medical_id` AS `employee_medical_id`,`em`.`employee_registration_id` AS `employee_registration_id`,`em`.`sort_order` AS `sort_order`,`em`.`relation` AS `relation`,`em`.`medical_type_id` AS `medical_type_id`,`em`.`medical_on` AS `medical_on`,`em`.`medical_value` AS `medical_value`,`em`.`created_at` AS `created_at`,`em`.`created_by_id` AS `created_by_id`,`em`.`modified_at` AS `modified_at`,`em`.`modified_by_id` AS `modified_by_id`,IF(ISNULL(`sac`.`special_allowance_category`),'ALL',`sac`.`special_allowance_category`) AS `medical_type` FROM (`employee_medical` `em` LEFT JOIN `special_allowance_category` `sac` ON(((`sac`.`special_allowance_type_id` = 2) AND (`sac`.`special_allowance_category_id` = `em`.`medical_type_id`))));
CREATE VIEW `vw_employee_salary` AS SELECT `es`.`company_id` AS `company_id`,`es`.`employee_registration_id` AS `employee_registration_id`,`es`.`employee_id` AS `employee_id`,`es`.`department_id` AS `department_id`,`es`.`employee_salary_id` AS `employee_salary_id`,`es`.`wef_date` AS `wef_date`,`es`.`basic_salary` AS `basic_salary`,`es`.`taxable` AS `taxable`,`es`.`taxable_house_rent` AS `taxable_house_rent`,`es`.`taxable_house_rent_percent` AS `taxable_house_rent_percent`,`es`.`total_allowance` AS `total_allowance`,`es`.`gross_amount` AS `gross_amount`,`es`.`taxable_amount` AS `taxable_amount`,`es`.`total_deduction` AS `total_deduction`,`es`.`net_amount` AS `net_amount`,`es`.`created_at` AS `created_at`,`es`.`created_by_id` AS `created_by_id`,`es`.`modified_at` AS `modified_at`,`es`.`modified_by_id` AS `modified_by_id`,`e`.`employee_code` AS `employee_code`,`e`.`full_name` AS `employee_name`,`d`.`department_code` AS `department_code`,`d`.`department_name` AS `department_name` FROM ((`employee_salary` `es` JOIN `employee` `e` ON((`e`.`employee_id` = `es`.`employee_id`))) JOIN `department` `d` ON((`d`.`department_id` = `es`.`department_id`)));
CREATE VIEW `vw_loan` AS SELECT `l`.`company_id` AS `company_id`,`l`.`fiscal_year_id` AS `fiscal_year_id`,`l`.`loan_id` AS `loan_id`,`l`.`date` AS `date`,`l`.`employee_registration_id` AS `employee_registration_id`,`l`.`registration_code` AS `registration_code`,`l`.`employee_id` AS `employee_id`,`l`.`employee_code` AS `employee_code`,`l`.`total_amount` AS `total_amount`,`l`.`description` AS `description`,`l`.`deduction_id` AS `deduction_id`,`l`.`company_account_id` AS `company_account_id`,`l`.`cheque_date` AS `cheque_date`,`l`.`cheque_no` AS `cheque_no`,`l`.`total_installment` AS `total_installment`,`l`.`start_date` AS `start_date`,`l`.`created_at` AS `created_at`,`l`.`created_by_id` AS `created_by_id`,`l`.`modified_at` AS `modified_at`,`l`.`modified_by_id` AS `modified_by_id`,`e`.`full_name` AS `employee_name`,`ca`.`bank_id` AS `bank_id`,`ca`.`account_title` AS `account_title`,`ca`.`bank_name` AS `bank_name`,`ca`.`account_no` AS `account_no`,`ca`.`iban` AS `iban`,(SELECT COUNT(0) FROM `loan_installment` `li` WHERE ((`li`.`loan_id` = `l`.`loan_id`) AND ((`li`.`payroll_id` <> '') OR (`li`.`adjustment_type` <> 'Payroll')))) AS `balance_installment`,(SELECT SUM(`li`.`installment_amount`) FROM `loan_installment` `li` WHERE ((`li`.`loan_id` = `l`.`loan_id`) AND ((`li`.`payroll_id` <> '') OR (`li`.`adjustment_type` = 'Cash')))) AS `amount_returned`,(SELECT SUM(`li`.`installment_amount`) FROM `loan_installment` `li` WHERE ((`li`.`loan_id` = `l`.`loan_id`) AND (`li`.`adjustment_type` = 'Transfer'))) AS `amount_transfer` FROM ((`loan` `l` LEFT JOIN `employee` `e` ON((`e`.`employee_id` = `l`.`employee_id`))) LEFT JOIN `vw_company_account` `ca` ON((`ca`.`company_account_id` = `l`.`company_account_id`)));
CREATE VIEW `vw_loan_installment` AS SELECT `li`.`loan_installment_id` AS `loan_installment_id`,`li`.`loan_id` AS `loan_id`,`li`.`installment_date` AS `installment_date`,`li`.`installment_amount` AS `installment_amount`,`li`.`adjustment_type` AS `adjustment_type`,`li`.`installment_remarks` AS `installment_remarks`,`li`.`payroll_id` AS `payroll_id`,`li`.`payroll_deduction_id` AS `payroll_deduction_id`,`li`.`created_at` AS `created_at`,`li`.`created_by_id` AS `created_by_id`,`li`.`modified_at` AS `modified_at`,`li`.`modified_by_id` AS `modified_by_id`,`l`.`employee_registration_id` AS `employee_registration_id`,`l`.`registration_code` AS `registration_code`,`l`.`employee_id` AS `employee_id`,`l`.`employee_code` AS `employee_code`,`l`.`employee_name` AS `employee_name`,`l`.`date` AS `date`,`l`.`description` AS `description`,`l`.`cheque_date` AS `cheque_date`,`l`.`cheque_no` AS `cheque_no`,`l`.`bank_id` AS `bank_id`,`l`.`account_title` AS `account_title`,`l`.`bank_name` AS `bank_name`,`l`.`account_no` AS `account_no`,`l`.`iban` AS `iban`,`l`.`deduction_id` AS `deduction_id`,`d`.`deduction_code` AS `deduction_code`,`d`.`deduction_name` AS `deduction_name` FROM ((`loan_installment` `li` JOIN `vw_loan` `l` ON((`l`.`loan_id` = `li`.`loan_id`))) LEFT JOIN `deduction` `d` ON((`d`.`deduction_id` = `l`.`deduction_id`)));
CREATE VIEW `vw_payroll` AS SELECT `p`.`payroll_id` AS `payroll_id`,`p`.`company_id` AS `company_id`,`p`.`fiscal_year_id` AS `fiscal_year_id`,`p`.`document_date` AS `document_date`,`p`.`document_title` AS `document_title`,`p`.`from_date` AS `from_date`,`p`.`to_date` AS `to_date`,`p`.`working_days` AS `working_days`,`p`.`remaining_payroll` AS `remaining_payroll`,`p`.`department` AS `department`,`p`.`designation` AS `designation`,`p`.`eobi_no` AS `eobi_no`,`p`.`department_id` AS `department_id`,`p`.`employee_registration_id` AS `employee_registration_id`,`p`.`employee_id` AS `employee_id`,`p`.`exclude_payroll` AS `exclude_payroll`,`p`.`house_rent_percent` AS `house_rent_percent`,`p`.`house_rent_allowance` AS `house_rent_allowance`,`p`.`basic_salary` AS `basic_salary`,`p`.`grossable_allowance` AS `grossable_allowance`,`p`.`taxable_allowance` AS `taxable_allowance`,`p`.`other_allowance` AS `other_allowance`,`p`.`arrears` AS `arrears`,`p`.`gross_salary` AS `gross_salary`,`p`.`taxable_salary` AS `taxable_salary`,`p`.`other_deduction` AS `other_deduction`,`p`.`tax_deduction` AS `tax_deduction`,`p`.`manual_addition` AS `manual_addition`,`p`.`manual_deduction` AS `manual_deduction`,`p`.`overtime` AS `overtime`,`p`.`net_salary` AS `net_salary`,`p`.`total_present` AS `total_present`,`p`.`total_absent` AS `total_absent`,`p`.`attendance_deduction` AS `attendance_deduction`,`p`.`payable_salary` AS `payable_salary`,`p`.`bank_id` AS `bank_id`,`p`.`bank_account_no` AS `bank_account_no`,`p`.`bank_account_title` AS `bank_account_title`,`p`.`bank_iban` AS `bank_iban`,`p`.`deposit_slip_id` AS `deposit_slip_id`,`p`.`tax_challan_date` AS `tax_challan_date`,`p`.`tax_challan_no` AS `tax_challan_no`,`p`.`tax_challan_bank_id` AS `tax_challan_bank_id`,`p`.`tax_challan_branch` AS `tax_challan_branch`,`p`.`is_email` AS `is_email`,`p`.`created_at` AS `created_at`,`p`.`created_by_id` AS `created_by_id`,`p`.`modified_at` AS `modified_at`,`p`.`modified_by_id` AS `modified_by_id`,`er`.`parent_company_id` AS `parent_company_id`,`er`.`employee_code` AS `employee_code`,`er`.`registration_code` AS `registration_code`,`er`.`employee_name` AS `employee_name`,`er`.`department_name` AS `department_name`,`er`.`designation_name` AS `designation_name`,`er`.`dob` AS `dob`,`er`.`joining_date` AS `joining_date`,`er`.`mobile_no` AS `mobile_no`,`er`.`phone_no` AS `phone_no`,`er`.`email` AS `email`,`er`.`cnic_no` AS `cnic_no`,`er`.`cnic_name` AS `cnic_name`,`er`.`cnic_address` AS `cnic_address`,`er`.`eobi_date` AS `eobi_date`,`er`.`ntn_no` AS `ntn_no`,`er`.`dept_party_id` AS `dept_party_id`,`er`.`dept_ah_key` AS `dept_ah_key`,`er`.`dept_budget_key` AS `dept_budget_key`,`er`.`eobi_party_id` AS `eobi_party_id`,`er`.`eobi_ah_key` AS `eobi_ah_key`,`er`.`tax_party_id` AS `tax_party_id`,`er`.`tax_ah_key` AS `tax_ah_key` FROM (`payroll` `p` LEFT JOIN `vw_employee_registration` `er` ON((`er`.`employee_registration_id` = `p`.`employee_registration_id`)));
CREATE VIEW `vw_salary_increment` AS SELECT `s`.`salary_increment_id` AS `salary_increment_id`,`s`.`company_id` AS `company_id`,`s`.`fiscal_year_id` AS `fiscal_year_id`,`s`.`document_no` AS `document_no`,`s`.`document_identity` AS `document_identity`,`s`.`department_id` AS `department_id`,`s`.`wef_date` AS `wef_date`,`s`.`increment_percent` AS `increment_percent`,`s`.`increment_amount` AS `increment_amount`,`s`.`is_post` AS `is_post`,`s`.`created_at` AS `created_at`,`d`.`department_name` AS `department_name` FROM (`salary_increment` `s` LEFT JOIN `department` `d` ON((`d`.`department_id` = `s`.`department_id`)));
CREATE VIEW `vw_salary_increment_detail` AS SELECT `sid`.`salary_increment_id` AS `salary_increment_id`,`sid`.`salary_increment_detail_id` AS `salary_increment_detail_id`,`sid`.`company_id` AS `company_id`,`sid`.`fiscal_year_id` AS `fiscal_year_id`,`sid`.`employee_registration_id` AS `employee_registration_id`,`sid`.`employee` AS `employee`,`sid`.`joining_date` AS `joining_date`,`sid`.`no_of_years` AS `no_of_years`,`sid`.`designation_name` AS `designation_name`,`sid`.`last_salary_updated` AS `last_salary_updated`,`sid`.`basic_salary` AS `basic_salary`,`sid`.`increment_percent` AS `increment_percent`,`sid`.`increment_amount` AS `increment_amount`,`sid`.`new_salary` AS `new_salary`,`sid`.`employee_salary_id` AS `employee_salary_id`,`sid`.`employee_id` AS `employee_id`,`sid`.`taxable` AS `taxable`,`sid`.`taxable_house_rent_percent` AS `taxable_house_rent_percent`,`sid`.`total_allowance` AS `total_allowance`,`sid`.`taxable_amount` AS `taxable_amount`,`sid`.`total_deduction` AS `total_deduction`,`sid`.`created_at` AS `created_at`,`si`.`wef_date` AS `wef_date`,`si`.`is_post` AS `is_post`,`si`.`document_identity` AS `document_identity` FROM (`salary_increment_detail` `sid` JOIN `salary_increment` `si` ON((`sid`.`salary_increment_id` = `si`.`salary_increment_id`)));
CREATE VIEW `vw_section` AS SELECT `s`.`company_id` AS `company_id`,`s`.`department_id` AS `department_id`,`s`.`section_id` AS `section_id`,`s`.`section_name` AS `section_name`,`s`.`status` AS `status`,`s`.`created_at` AS `created_at`,`s`.`created_by_id` AS `created_by_id`,`s`.`modified_at` AS `modified_at`,`s`.`modified_by_id` AS `modified_by_id`,`d`.`department_code` AS `department_code`,`d`.`department_name` AS `department_name`,`c`.`company_name` AS `company_name` FROM ((`section` `s` JOIN `department` `d` ON(((`d`.`company_id` = `s`.`company_id`) AND (`d`.`department_id` = `s`.`department_id`)))) JOIN `company` `c` ON((`c`.`company_id` = `d`.`company_id`)));
CREATE VIEW `vw_special_allowance` AS SELECT `sa`.`special_allowance_id` AS `special_allowance_id`,`sa`.`company_id` AS `company_id`,`sa`.`fiscal_year_id` AS `fiscal_year_id`,`sa`.`document_date` AS `document_date`,`sa`.`document_no` AS `document_no`,`sa`.`document_identity` AS `document_identity`,`sa`.`special_allowance_type_id` AS `special_allowance_type_id`,`sa`.`employee_registration_id` AS `employee_registration_id`,`sa`.`registration_code` AS `registration_code`,`sa`.`file_name` AS `file_name`,`sa`.`file_directory` AS `file_directory`,`sa`.`is_taxable` AS `is_taxable`,`sa`.`total_amount` AS `total_amount`,`sa`.`medical_from` AS `medical_from`,`sa`.`medical_to` AS `medical_to`,`sa`.`approved_status` AS `approved_status`,`sa`.`approved_amount` AS `approved_amount`,`sa`.`is_post` AS `is_post`,`sa`.`post_at` AS `post_at`,`sa`.`post_by_id` AS `post_by_id`,`sa`.`created_at` AS `created_at`,`sa`.`created_by_id` AS `created_by_id`,`sa`.`modified_at` AS `modified_at`,`sa`.`modified_by_id` AS `modified_by_id`,`sat`.`special_allowance_type` AS `special_allowance_type`,`sat`.`budget_key` AS `budget_key`,`er`.`company_name` AS `company_name`,`er`.`department_id` AS `department_id`,`er`.`department_name` AS `department_name`,`er`.`employee_id` AS `employee_id`,`er`.`employee_code` AS `employee_code`,`er`.`employee_name` AS `employee_name`,`er`.`employee_image` AS `employee_image` FROM ((`special_allowance` `sa` LEFT JOIN `special_allowance_type` `sat` ON((`sat`.`special_allowance_type_id` = `sa`.`special_allowance_type_id`))) LEFT JOIN `vw_employee_registration` `er` ON((`er`.`employee_registration_id` = `sa`.`employee_registration_id`)));
CREATE VIEW `vw_special_allowance_category` AS SELECT `sac`.`special_allowance_type_id` AS `special_allowance_type_id`,`sac`.`special_allowance_category_id` AS `special_allowance_category_id`,`sac`.`special_allowance_category` AS `special_allowance_category`,`sac`.`created_at` AS `created_at`,`sac`.`created_by_id` AS `created_by_id`,`sac`.`modified_at` AS `modified_at`,`sac`.`modified_by_id` AS `modified_by_id`,`sat`.`special_allowance_type` AS `special_allowance_type` FROM (`special_allowance_category` `sac` LEFT JOIN `special_allowance_type` `sat` ON((`sat`.`special_allowance_type_id` = `sac`.`special_allowance_type_id`)));
CREATE VIEW `vw_special_allowance_detail` AS SELECT `sad`.`special_allowance_detail_id` AS `special_allowance_detail_id`,`sad`.`special_allowance_id` AS `special_allowance_id`,`sad`.`sort_order` AS `sort_order`,`sad`.`allowance_for` AS `allowance_for`,`sad`.`employee_family_id` AS `employee_family_id`,`sad`.`school_id` AS `school_id`,`sad`.`class_id` AS `class_id`,`sad`.`special_allowance_category_id` AS `special_allowance_category_id`,`sad`.`period_start_date` AS `period_start_date`,`sad`.`period_end_date` AS `period_end_date`,`sad`.`amount` AS `amount`,`sad`.`remarks` AS `remarks`,`sad`.`receipt_date` AS `receipt_date`,`sad`.`receipt_no` AS `receipt_no`,`sad`.`approved_amount` AS `approved_amount`,`sad`.`policy_on` AS `policy_on`,`sad`.`policy_value` AS `policy_value`,`sad`.`policy_amount` AS `policy_amount`,`s`.`school_name` AS `school_name`,`c`.`class_name` AS `class_name`,`sac`.`special_allowance_category` AS `special_allowance_category`,`ef`.`relation` AS `relation`,`ef`.`full_name` AS `full_name`,`sa`.`fiscal_year_id` AS `fiscal_year_id`,`sa`.`approved_status` AS `approved_status` FROM (((((`special_allowance_detail` `sad` JOIN `special_allowance` `sa` ON((`sa`.`special_allowance_id` = `sad`.`special_allowance_id`))) LEFT JOIN `school` `s` ON((`s`.`school_id` = `sad`.`school_id`))) LEFT JOIN `class` `c` ON((`c`.`class_id` = `sad`.`class_id`))) LEFT JOIN `special_allowance_category` `sac` ON((`sac`.`special_allowance_category_id` = `sad`.`special_allowance_category_id`))) LEFT JOIN `employee_family` `ef` ON((`ef`.`employee_family_id` = `sad`.`employee_family_id`)));
CREATE VIEW `vw_special_enayat` AS SELECT `se`.`special_enayat_id` AS `special_enayat_id`,`se`.`company_id` AS `company_id`,`se`.`fiscal_year_id` AS `fiscal_year_id`,`se`.`document_no` AS `document_no`,`se`.`document_identity` AS `document_identity`,`se`.`document_date` AS `document_date`,`se`.`document_title` AS `document_title`,`se`.`company_account_id` AS `company_account_id`,`se`.`enayat_event_id` AS `enayat_event_id`,`se`.`total_employee` AS `total_employee`,`se`.`total_amount` AS `total_amount`,`se`.`is_post` AS `is_post`,`se`.`post_at` AS `post_at`,`se`.`post_by_id` AS `post_by_id`,`se`.`created_at` AS `created_at`,`se`.`created_by_id` AS `created_by_id`,`se`.`modified_at` AS `modified_at`,`se`.`modified_by_id` AS `modified_by_id`,`ca`.`account_title` AS `account_title`,`ca`.`account_no` AS `account_no`,`ca`.`ah_key` AS `ah_key`,`ca`.`party_id` AS `party_id`,`b`.`bank_name` AS `bank_name` FROM ((`special_enayat` `se` LEFT JOIN `company_account` `ca` ON((`ca`.`company_account_id` = `se`.`company_account_id`))) LEFT JOIN `bank` `b` ON((`b`.`bank_id` = `ca`.`bank_id`)));
CREATE VIEW `vw_user_access` AS SELECT `ua`.`user_access_id` AS `user_access_id`,`ua`.`user_id` AS `user_id`,`ua`.`company_id` AS `company_id`,`ua`.`created_at` AS `created_at`,`ua`.`created_by_id` AS `created_by_id`,`c`.`company_name` AS `company_name` FROM (`user_access` `ua` JOIN `company` `c` ON((`c`.`company_id` = `ua`.`company_id`)));