<?php

use Illuminate\Support\Facades\Route;
use Http\Controllers\EmployeeController;

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function(){
    return 'API is Active';
});

// Authentication Routes
Route::post('auth/postLogin', 'AuthController@postLogin');
Route::post('logout', 'AuthController@logout');
Route::post('refresh', 'AuthController@refresh');
Route::post('user-profile', 'AuthController@me');
Route::post('change-password', 'AuthController@changePassword');

// Attendance Routes
Route::post('attendance/machine', 'AttendanceController@machine');
Route::post('attendance/checkin', 'AttendanceController@checkIn');
Route::post('attendance/checkout', 'AttendanceController@checkOut');
Route::post('attendance/get-attendance-report', 'AttendanceController@printReport');
Route::post('attendance/check-intime_status', 'AttendanceController@checkIntimeStatus');

// Leave Routes
Route::post('leave/post', 'LeaveController@postLeave');

// Team Routes
Route::get('getTeams', 'TaskManagementController@getTeams');
Route::get('getProjectsThroughTeam', 'TaskManagementController@getProjectsThroughTeam');
Route::get('getProjectsWithTeam', 'TaskManagementController@getProjectsWithTeam');

// Task Routes
Route::get('getSectionsFromProject/{project_id}', 'TaskManagementController@getSectionsFromProject');
Route::get('getTasksFromSection/{project_section_id}', 'TaskManagementController@getTasksFromSection');
Route::get('getTasksFromProject/{project_id}', 'TaskManagementController@getTasksFromProject');
Route::get('getTask', 'TaskManagementController@getTask');
Route::post('createTask', 'TaskManagementController@createTask');
Route::post('updateTask/{id}', 'TaskManagementController@updateTask');
Route::post('addComment', 'TaskManagementController@addComment');

// Leave Request
Route::post('createLeaveRequest', 'LeaveController@createLeaveRequest');
Route::post('updateLeaveRequest/{id}', 'LeaveController@updateLeaveRequest');
Route::get('getLeaveRequest/{employee_leave_id}', 'LeaveController@getLeaveRequest');
Route::get('getLeaveRequests', 'LeaveController@getLeaveRequests');
Route::get('leave/avail', 'LeaveController@availLeave');

// Employee Route
Route::get('employee/directory', 'EmployeeRegistrationController@employeeDirectory');