<?php

class ControllerCommonHome extends Controller {

    protected function getAlias() {
        return 'common/home';
    }

    public function index() {
        $this->data['lang'] = $this->load->language('common/home');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->data['heading_title'] = $this->language->get('heading_title');
        if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
            $this->data['base'] = HTTPS_BASE;
        } else {
            $this->data['base'] = HTTP_BASE;
        }

        if (isset($this->session->data['error'])) {
            $this->data['error_warning'] = $this->session->data['error'];

            unset($this->session->data['error']);
        } elseif (isset($this->session->data['warning'])) {
            $this->data['error_warning'] = $this->session->data['warning'];

            unset($this->session->data['warning']);
        } elseif (isset($this->session->data['error_warning'])) {
            $this->data['error_warning'] = $this->session->data['error_warning'];

            unset($this->session->data['error_warning']);
        } else {
            $this->data['error_warning'] = '';
        }

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text' => $this->data['lang']['dashboard'],
            'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'class' => 'fa fa-dashboard',
            'separator' => false
        );

        $this->data['token'] = $this->session->data['token'];

        $this->model['image'] = $this->load->model('tool/image');
        $this->model['employee'] = $this->load->model('employee/employee_profile');
        $this->model['payroll'] = $this->load->model('payroll/payroll');

        $employee = $this->model['employee']->getRow(array('employee_id'=> $this->session->data['employee_id']));
        $employee_image = $employee['employee_image'];
        if($employee_image!='' && file_exists(DIR_IMAGE.$employee_image)) {
            $this->data['employee_image'] = $this->model['image']->resize($employee_image,100,100);
        } else {
            $this->data['employee_image'] = $this->model['image']->resize('no_user.jpg',100,100);
        }
        $this->data['full_name'] = $employee['full_name'];
        $this->data['qualification'] = $employee['qualification'];
        $this->data['dob'] = ($employee['dob']?stdDate($employee['dob']):'');
        $this->data['gender'] = $employee['gender'];
        $this->data['marital_status'] = $employee['marital_status'];
        $this->data['mobile_no'] = $employee['mobile_no'];
        $this->data['email'] = $employee['email'];
        $this->data['cnic_no'] = $employee['cnic_no'];
        $this->data['eobi_no'] = $employee['eobi_no'];

        $payrolls = $this->model['payroll']->getRows(array('employee_id' => $employee['employee_id']), array('document_date desc'),6);
        foreach($payrolls as $payroll) {
            $this->data['payrolls'][] = array(
                'document_title' => $payroll['document_title'],
                'bank_account_no' => $payroll['bank_account_no'],
                'gross_salary' => $payroll['gross_salary'],
                'payable_salary' => $payroll['payable_salary'],
                'href_pay_slip' => $this->url->link('common/home/printPaySlip', 'token=' . $this->session->data['token'].'&payroll_id='.$payroll['payroll_id'], 'SSL')
            );
        }

        $this->data['href_employee_profile'] = $this->url->link('employee/employee_profile/update', 'token=' . $this->session->data['token'].'&employee_id='.$this->session->data['employee_id'], 'SSL');
        $this->template = 'common/home.tpl';
        $this->children = array(
            'common/header',
            'common/column_left',
            'common/column_right',
            'common/page_header',
            'common/page_footer',
            'common/footer',
        );

        $this->response->setOutput($this->render());
    }

    public function printPaySlip() {
        ini_set('max_execution_time',400);
        $lang = $this->load->language($this->getAlias());
        $payroll_id = $this->request->get['payroll_id'];
        $employee_id = $this->session->data['employee_id'];

        $arrWhere = array();
        $arrWhere[] = "`employee_id` = '".$employee_id."'";
        $arrWhere[] = "`payroll_id` = '".$payroll_id."'";

        $where = implode(' AND ', $arrWhere);

        $this->model['bank'] = $this->load->model('setup/bank');
        $this->model['deposit_slip'] = $this->load->model('payroll/deposit_slip');
        $this->model['payroll'] = $this->load->model('payroll/payroll');
        $this->model['payroll_allowance'] = $this->load->model('payroll/payroll_allowance');
        $this->model['payroll_deduction'] = $this->load->model('payroll/payroll_deduction');
        $row = $this->model['payroll']->getRow($where);
        //d($rows, true);
        $pdf = new PDFPaySlip('L', PDF_UNIT, 'A5', true, 'UTF-8', false);
        $pdf->data = array(
            'subtitle' => $row['document_title']
        );
        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Payroll Slip');
        $pdf->SetSubject('Payroll Slip');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 5);

        // add a page
        $pdf->AddPage();
        //$pdf->Cell(0, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        //$pdf->ln(10);
        //$pdf->Cell(180, 10, '', 1, false, 'L', 0, '', 0, false, 'M', 'M');
        $arrDepositSlip = array();
        $arrAllowances = array();
        $arrDeductions = array();
        $allowances = $this->model['payroll_allowance']->getRows(array('payroll_id' => $row['payroll_id']), array('allowance_id'));
        $deductions = $this->model['payroll_deduction']->getRows(array('payroll_id' => $row['payroll_id']),array('deduction_id'));
        $arrAllowances[] = array(
            'allowance_name' => 'Basic',
            'allowance_amount' => $row['basic_salary'],
        );
        if($row['arrears'] != 0) {
            $arrAllowances[] = array(
                'allowance_name' => 'Arrears',
                'allowance_amount' => $row['arrears'],
            );
        }
        foreach($allowances as $allowance) {
            $arrAllowances[] = array(
                'allowance_name' => $allowance['allowance_name'],
                'allowance_amount' => $allowance['allowance_amount'],
            );
        }
        foreach($deductions as $deduction) {
            $arrDeductions[] = array(
                'deduction_name' => $deduction['deduction_name'],
                'deduction_amount' => $deduction['deduction_amount'],
            );
        }
        $arrDeductions[] = array(
            'deduction_name' => 'Tax',
            'deduction_amount' => $row['tax_deduction'],
        );
        if($row['net_salary'] != $row['payable_salary']) {
            $arrDeductions[] = array(
                'deduction_name' => 'Attendance',
                'deduction_amount' => ($row['net_salary']-$row['payable_salary']),
            );
        }
        $count_loop = max(count($arrAllowances), count($arrDeductions));
        if(!isset($arrDepositSlip[$row['deposit_slip_id']])) {
            $deposit_slip = $this->model['deposit_slip']->getRow(array('deposit_slip_id' => $row['deposit_slip_id']));
            $arrDepositSlip[$row['deposit_slip_id']] = $deposit_slip;
        }
        $deposit_slip = $arrDepositSlip[$row['deposit_slip_id']];

        if(!isset($arrBanks[$row['bank_id']])) {
            $bank = $this->model['bank']->getRow(array('bank_id' => $row['bank_id']));
            $arrBanks[$row['bank_id']] = $bank;
        }
        $bank = $arrBanks[$row['bank_id']];
        //d(array($row['deposit_slip_id'], $arrDepositSlip), true);

        $start_page = $pdf->getPage();
        $pdf->startTransaction();
        $pdf->SetLineStyle(array('width' => 0.1, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
        $pdf->SetFont('freesans', 'B', 8);
        $pdf->Cell(150, 5, $this->session->data['company_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('freesans', '', 8);
        $pdf->Cell(30, 5, '(PAY SLIP)', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->ln(5);
        $pdf->SetFont('freesans', 'B', 8);
        $pdf->Cell(20, 5, 'Emp. No.', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('freesans', '', 8);
        $pdf->Cell(70, 5, $row['employee_code']. ' - ' .$row['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
        $pdf->ln(5);
        $pdf->SetFont('freesans', 'B', 8);
        $pdf->Cell(20, 5, 'CNIC Name', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('freesans', '', 8);
        $pdf->Cell(80, 5, $row['cnic_name']. ' ' .$row['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
        $pdf->SetFont('freesans', 'B', 8);
        $pdf->Cell(50, 5, 'CNIC', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('freesans', '', 8);
        $pdf->Cell(30, 5, $row['cnic_no'], 0, false, 'R', 0, '', 1, false, 'M', 'M');
        $pdf->ln(5);
        $pdf->SetFont('freesans', 'B', 8);
        $pdf->Cell(20, 5, 'By Cheque', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('freesans', '', 8);
        $pdf->Cell(70, 5, $deposit_slip['cheque_no'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(90, 5, $row['document_title'], 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->ln(5);
        $pdf->Cell(0, 1, '', 'T');
        $total_allowance = 0;
        $total_deduction = 0;
        for($i=0;$i<$count_loop;$i++) {
            $pdf->ln(4);
            if(isset($arrAllowances[$i])) {
                $pdf->Cell(30, 4, $arrAllowances[$i]['allowance_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 4, number_format($arrAllowances[$i]['allowance_amount'],2), 0, false, 'R', 0, '', 1, false, 'M', 'M');
                $total_allowance += $arrAllowances[$i]['allowance_amount'];
            } else {
                $pdf->Cell(30, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 4, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            }
            $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(1, 4, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            if(isset($arrDeductions[$i])) {
                $pdf->Cell(30, 4, $arrDeductions[$i]['deduction_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 4, number_format($arrDeductions[$i]['deduction_amount'],2), 0, false, 'R', 0, '', 1, false, 'M', 'M');
                $total_deduction += $arrDeductions[$i]['deduction_amount'];
            } else {
                $pdf->Cell(30, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 4, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
            }
            $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(1, 4, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        }
        $pdf->ln(3);
        $pdf->Cell(0, 1, '', 'T');
        $pdf->ln(3);
        $pdf->Cell(30, 4, 'Gross', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(20, 4, number_format($row['gross_salary'],2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(15, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(30, 4, 'Deductions', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(20, 4, number_format($total_deduction,2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
        $pdf->Cell(15, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(30, 4, 'Net', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(20, 4, number_format($row['payable_salary'],2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
        $pdf->ln(8);
        $pdf->SetFont('freesans', 'B', 8);
        $pdf->Cell(60, 5, 'Credited to A/C.: ' . $row['bank_account_no'].' in '.$bank['bank_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
        $pdf->ln(7);
        $pdf->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 4, 'color' => array(211, 211, 211)));
        $pdf->Cell(0, 1, '', 'T', false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->ln(5);
        $end_page = $pdf->getPage();
        if($start_page != $end_page) {
            $pdf->rollbackTransaction(true); //Do not forget to add True
            $pdf->AddPage();
            $pdf->SetLineStyle(array('width' => 0.1, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(150, 5, $this->session->data['company_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(30, 5, '(PAY SLIP)', 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(20, 5, 'Emp. No.', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(70, 5, $row['employee_code']. ' - ' .$row['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(20, 5, 'CNIC Name', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(80, 5, $row['cnic_name']. ' ' .$row['employee_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(50, 5, 'CNIC', 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(30, 5, $row['cnic_no'], 0, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(20, 5, 'By Cheque', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->SetFont('freesans', '', 8);
            $pdf->Cell(70, 5, $deposit_slip['cheque_no'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(90, 5, $row['document_title'], 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
            $pdf->Cell(0, 1, '', 'T');
            $total_allowance = 0;
            $total_deduction = 0;
            for($i=0;$i<$count_loop;$i++) {
                $pdf->ln(4);
                if(isset($arrAllowances[$i])) {
                    $pdf->Cell(30, 4, $arrAllowances[$i]['allowance_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(20, 4, number_format($arrAllowances[$i]['allowance_amount'],2), 0, false, 'R', 0, '', 1, false, 'M', 'M');
                    $total_allowance += $arrAllowances[$i]['allowance_amount'];
                } else {
                    $pdf->Cell(30, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(20, 4, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                }
                $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(1, 4, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                if(isset($arrDeductions[$i])) {
                    $pdf->Cell(30, 4, $arrDeductions[$i]['deduction_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(20, 4, number_format($arrDeductions[$i]['deduction_amount'],2), 0, false, 'R', 0, '', 1, false, 'M', 'M');
                    $total_deduction += $arrDeductions[$i]['deduction_amount'];
                } else {
                    $pdf->Cell(30, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(20, 4, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                }
                $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(1, 4, '', 'L', false, 'L', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(7, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            }
            $pdf->ln(3);
            $pdf->Cell(0, 1, '', 'T');
            $pdf->ln(3);
            $pdf->Cell(30, 4, 'Gross', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 4, number_format($row['gross_salary'],2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 4, 'Deductions', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 4, number_format($total_deduction,2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(15, 4, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(30, 4, 'Net', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(20, 4, number_format($row['payable_salary'],2), 'B', false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->ln(8);
            $pdf->SetFont('freesans', 'B', 8);
            $pdf->Cell(60, 5, 'Credited to A/C.: ' . $row['bank_account_no'].' in '.$bank['bank_name'], 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->ln(7);
            $pdf->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 4, 'color' => array(211, 211, 211)));
            $pdf->Cell(0, 1, '', 'T', false, 'L', 0, '', 0, false, 'M', 'M');
            $pdf->ln(5);
        } else {
            $pdf->commitTransaction();
        }

        //Close and output PDF document
        $pdf->Output('Payroll Slip:'.date('YmdHis').'.pdf', 'I');
    }

    public function login() {
        if(isset($this->session->data['employee_id']) && $this->session->data['employee_id']) {
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $employee = $this->model['employee']->getRow(array('employee_id' => $this->session->data['employee_id']));
            if ($employee) {
                $this->session->data['employee_id'] = $employee['employee_id'];
                $this->session->data['employee_name'] = $employee['full_name'];
                $this->session->data['employee_image'] = $employee['employee_image'];
            } else {
                unset($this->session->data['is_verify']);
                return $this->forward('common/logout');
            }
        }

        $route = '';

        if (isset($this->request->get['route'])) {
            $part = explode('/', $this->request->get['route']);

            if (isset($part[0])) {
                $route .= $part[0];
            }

            if (isset($part[1])) {
                $route .= '/' . $part[1];
            }
        }

        // for verification url escape login & logout
            $url = str_contains($route, 'common/login');
            if(isset($this->session->data['is_verify']) && $this->session->data['is_verify']==0 && !$url){
                 if($route=='common/logout'){
                    $this->session->data['is_verify'] = "1";
                 }else{
                    $this->redirect(HTTP_SERVER.'?route=common/login');
                 }
            }

        $ignore = array(
            'common/login',
            'common/preset',
            'common/forgotten',
            'common/filemanager',
            'common/reset'
        );

        //d(array($this->user->getData(), $this->session->data), true);
        if ((!$this->session->data['employee_id']) && !in_array($route, $ignore)) {
            return $this->forward('common/logout');
        }

//        $user_restricted_ip = $this->user->getIP();
//        if($user_restricted_ip &&  $user_restricted_ip != $this->request->server['REMOTE_ADDR']) {
//            return $this->forward('common/logout');
//        }
    }

    public function permission() {
//        $sk = $this->config->get('config_security_key');
//        if (!$sk) {
//            return $this->forward('error/security');
//        } else {
//            $arrSK = unserialize(base64_decode($sk));
//            if ($arrSK['server'] == $this->request->server['HTTP_HOST']) {
//                if ($arrSK['expiry_date'] != "") {
//                    if ($arrSK['expiry_date'] < date('Y-m-d')) {
//                        return $this->forward('error/security');
//                    }
//                }
//            } else {
//                return $this->forward('error/security');
//            }
//        }

        if (isset($this->request->get['route'])) {
            $route = '';

            $part = explode('/', $this->request->get['route']);

            if (isset($part[0])) {
                $route .= $part[0];
            }

            if (isset($part[1])) {
                $route .= '/' . $part[1];
            }

            $ignore = array(
                'common/home',
                'common/page_header',
                'common/login',
                'common/preset',
                'common/logout',
                'common/forgotten',
                'common/reset',
                'common/filemanager',
                'common/function',
                'error/not_found',
                'error/permission',
                'error/error'
            );

//            if (!in_array($route, $ignore) && !$this->user->hasPermission('view', $route)) {
//                return $this->forward('error/permission');
//            }
        }
    }

}

class PDFPaySlip extends TCPDF {
    public $data;
    //Page header
    public function Header() {
//        // Logo
//        //$image_file = DIR_IMAGE.'logo.jpg';
//        //$image_file = DIR_IMAGE.'no_image.jpg';
//        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
//        // Set font
//        $this->SetFont('freesans', 'B', 20);
//        // Title
//        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('freesans', 'B', 14);
//        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('freesans', '', 14);
//        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-10);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(60, 10, 'Payroll Slip', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>