<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require DIR_SYSTEM . 'library/PHPMailer/Exception.php';
require DIR_SYSTEM . 'library/PHPMailer/PHPMailer.php';
require DIR_SYSTEM . 'library/PHPMailer/SMTP.php';
class ControllerUserUserProfile extends HController {

    protected function getAlias() {
        return 'user/user_profile';
    }

    protected function getPrimaryKey() {
        return 'user_id';
    }

    public function index() {
        $this->redirect($this->url->link($this->getAlias().'/update', 'token=' . $this->session->data['token'] . '&user_id=' . $this->user->getId(), 'SSL'));
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('user/user');
        $this->data['lang'] = $this->load->language('user/user_profile');
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    public function update() {
        $this->init();
        if($this->request->get['user_id'] != $this->user->getId()) {
            $this->session->data['error_warning'] = $this->data['lang']['error_invalid_request'];
            $this->redirect($this->url->link($this->getAlias().'/update', 'token=' . $this->session->data['token'] . '&user_id=' . $this->user->getId(), 'SSL'));
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateUpdate()) {
            $this->db->beginTransaction();
            $id = $this->updateData($this->request->get[$this->getPrimaryKey()], $this->request->post);
            $this->db->commit();

            $this->session->data['success'] = $this->language->get('success_update');

            $this->updateRedirect($id, $this->request->post);
        }
        $this->getForm();
    }

    protected function getForm() {
        parent::getForm();

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text' => $this->data['lang']['dashboard'],
            'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'class' => 'fa fa-dashboard',
            'separator' => false
        );

        $this->data['breadcrumbs'][] = array(
            'text' => $this->data['lang']['user'],
            'href' => $this->url->link('user/user', 'token=' . $this->session->data['token'], 'SSL'),
            'class' => 'fa fa-user',
            'separator' => false
        );

        $this->model['company'] = $this->load->model('setup/company');
        $this->data['companies'] = $this->model['company']->getRows(array('status' => 'Active'));

        $this->model['user_permission'] = $this->load->model('user/user_permission');
        $this->data['user_permissions'] = $this->model['user_permission']->getRows();

        if (isset($this->request->get['user_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array($this->getPrimaryKey() => $this->request->get[$this->getPrimaryKey()]));
            foreach ($result as $field => $value) {
                $this->data[$field] = $value;
            }
            $this->data['companies'] = $this->model['company']->getRows();
        }

        $this->model['image'] = $this->load->model('tool/image');
        $this->data['no_image'] = $this->model['image']->resize('no_user.jpg', 300, 300);

        if ($this->data['user_image'] && file_exists(DIR_IMAGE . $this->data['user_image']) && is_file(DIR_IMAGE . $this->data['user_image'])) {
            $this->data['src_user_image'] = $this->model['image']->resize($this->data['user_image'], 300, 300);
        } else {
            $this->data['src_user_image'] = $this->model['image']->resize('no_user.jpg', 300, 300);
        }

        $this->data['ajax_email_url'] = $this->url->link('user/user_profile/RequestOTPEmail', '', 'SSL');
        $this->data['ajax_verify_email'] = $this->url->link('user/user_profile/VerifyEmail', '', 'SSL');
        $this->data['ajax_reset_pass'] = $this->url->link('user/user_profile/ResetPassword', '', 'SSL');

        $this->data['action_validate_name'] = $this->url->link($this->getAlias() . '/validateName', 'token=' . $this->session->data['token'] . '&user_id=' . $this->request->get['user_id']);
        $this->data['action_validate_email'] = $this->url->link($this->getAlias() . '/validateEmail', 'token=' . $this->session->data['token'] . '&user_id=' . $this->request->get['user_id']);
        $this->data['strValidation'] = "{
            'rules':{
                'login_name': {'required':true, 'minlength': 3, 'remote':  {url: '" . $this->data['action_validate_name'] . "', type: 'post'}},
                'user_name': {'required':true},
                'email': {'email': true, 'required': true, 'remote':  {url: '" . $this->data['action_validate_email'] . "', type: 'post'}},
                'login_password': {'minlength': 8},
                'confirm': {'equalTo': '#password'},
            },
        }";

        $this->template = 'user/user_profile.tpl';
        $this->response->setOutput($this->render());
    }

    protected function updateData($primary_key, $data)
    {
        if ($data['login_password']) {
            $data['login_password'] = md5($data['login_password']);
        } else {
            unset($data['login_password']);
        }

        $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
    }

    public function validateName()
    {
        $login_name = $this->request->post['login_name'];
        $user_id = $this->request->get['user_id'];
        $this->load->language('user/user');
        if ($login_name) {
            $this->model['user'] = $this->load->model('user/user');
            $where = "`login_name` = '".$login_name."' AND `user_id` != '".$user_id."'";
            $user = $this->model['user']->getRow($where);
            if ($user) {
                echo json_encode($this->language->get('error_duplicate_login_name'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_invalid'));
        }
        exit;
    }

    public function validateEmail() {
        $email = $this->request->post['email'];
        $user_id = $this->session->data['user_id'];
        $this->load->language('user/user');
        if($email) {
            $this->model['user'] = $this->load->model('user/user');
            $where = "`email` = '".$email."' AND `user_id` != '".$user_id."'";
            $user = $this->model['user']->getRow($where);
            if($user) {
                echo json_encode($this->language->get('error_duplicate_email'));
            } else {
                echo json_encode("true");
            }
        } else {
            echo json_encode($this->language->get('error_email'));
        }
        exit;
    }

        public function email_setting($type='email'){

            $this->model['core_setting'] = $this->load->model('common/setting');
            $filter = array(
                        'company_id' => $this->session->data['company_id'],
                        'module' => 'general',
            );
            $results = $this->model['core_setting']->getRows($filter);


            $responseArr = [];
            if($type=='email'){
                foreach ($results as $result) {
                    if($result['field']=='config_mail_smtp_hostname') {
                        $responseArr['host'] = $result['value'];
                    }elseif($result['field']=='config_mail_engine') {
                        $responseArr['mail_engine'] = $result['value'];
                    }elseif($result['field']=='config_mail_parameter') {
                        $responseArr['parameter'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_displayname') {
                        $responseArr['displayname'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_port') {
                        $responseArr['port'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_username') {
                        $responseArr['username'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_email') {
                        $responseArr['email'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_timeout') {
                        $responseArr['timeout'] = $result['value'];
                    }elseif($result['field']=='config_mail_smtp_password') {
                        $responseArr['password'] = $result['value'];
                    } 
                }
            }else{
                foreach ($results as $result) {
                    if($result['field']=='whatsapp_url') {
                        $responseArr['url'] = $result['value'];
                    }elseif($result['field']=='whatsapp_token') {
                        $responseArr['token'] = $result['value'];
                    }
                }
            }
            return $responseArr;
    }

     public function RequestOTPEmail(){
        $post = $this->request->post;
        $mobile_no = $this->session->data['mobile_no'];
        $code = str_pad(mt_rand(10000, 99999), 5, '0', STR_PAD_LEFT);

        if(!empty($mobile_no)){
            $mobile_no = str_replace('+','',trim($mobile_no));
            $mobile_no = str_replace(' ','',trim($mobile_no));
            $setting = $this->email_setting('whatsapp');
            $data = [
              'chatId'=> $mobile_no."@c.us",
              'message'=> "*".$code."* is your verification code for DHK Payroll, Do not share this code."
            ];
            $this->whatsAppAPI($data ,$setting );
        }

        $setting = $this->email_setting();
        $this->session->data['otp']  = $code;
        $this->session->data['resent']  = 1;

        $Mail_Parameters = '';
        $this_message = '';
        $template='';
        $Host = $setting['host'];
        $Mail_Engine = $setting['mail_engine'];
        $Username = $setting['username'];
        $Password = $setting['password'];
        $Port = $setting['port'];
        $Timeout = $setting['timeout'];
        $Sender = $setting['username'];
        $Display_Name = $setting['display_name'];
        $recipients = explode(",",$this->session->data['email'] );

        $this->template = 'email/verify-email.php';
        $this->data['verify_code'] = $code;
       if($Mail_Engine == 'mail') {
            $mail = new PHPMailer(true);


            try {  
                $mail->isSMTP();
                $mail->Host       = $Host;
                $mail->SMTPAuth   = true;
                $mail->Username   = $Username;
                $mail->Password   = $Password;


                // $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                $mail->Port       = $Port;
                $mail->Timeout = $Timeout;
                $mail->SMTPOptions = array(
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                        'allow_self_signed' => true
                    )
                );
           

                $mail->setFrom($Sender,$Display_Name);
                          foreach (array_filter($recipients) as $email) {
                        $mail->addAddress($email);
                    }
                $mail->isHTML(true);
                $mail->Subject = "OTP Email Verification";
                $mail->Body    =   $this->render();

                if ($mail->send()) {
                    echo json_encode("email sent");

                }else{
                    echo json_encode('Oops, something went wrong with your email! You might want to double-check your settings and try again. Error: ' . $mail->ErrorInfo) ;
                }
            } catch (Exception $e) {
                echo json_encode('Email could not be sent. Error: ' . $e->getMessage());
            }
        }else{
            echo json_encode(["msg" => "Invalid Email Address", "type" => "error"]);
        }

    }
    public function VerifyEmail(){
        $post = $this->request->post;
        $session = $this->session->data;
       
        if( $session['otp'] == $post['otp']){
            $this->session->data['is_verify'] = 1;
            echo json_encode(["msg" => "Verify Successfully !", "success" => true]);
        }else{
            echo json_encode(["msg" => "Verification Code not Matched !", "success" => false]);

        }
    }

     public function whatsAppAPI($data,$setting){

        $url = $setting['url'];
        $data = json_encode($data);
        $authorization = "Authorization: Bearer ".$setting['token'];
        $headers =  [
                        "Content-Type: application/json",
                        "Accept:application/json",  
                        $authorization      
                    ];

            $cc =  curl_init();
            curl_setopt($cc, CURLOPT_URL, $url); 
            curl_setopt($cc, CURLOPT_POST, true);
            curl_setopt($cc, CURLOPT_POSTFIELDS, $data);
            curl_setopt($cc, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($cc, CURLOPT_HTTPHEADER, $headers);
            $response = curl_exec($cc);
            curl_close($ch);
    }


}

?>