<?php

class ControllerCommonPageHeader extends Controller {

    public function index() {
        $this->data['lang'] = $this->load->language('common/page_header');
        $this->model['image'] = $this->load->model('tool/image');

        $this->data['employee_id'] = $this->session->data['employee_id'];
        $this->data['employee_name'] = $this->session->data['employee_name'];
        $this->data['employee_code'] = $this->session->data['employee_code'];

        $employee_image =  $this->session->data['employee_image']?$this->session->data['employee_image']:'no_user.jpg';
        $this->data['employee_image_50_50'] = $this->model['image']->resize($employee_image,50,50);
        $this->data['employee_image_160_160'] = $this->model['image']->resize($employee_image,160,160);

        $this->data['href_logout'] = $this->url->link('common/logout', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_employee_profile'] = $this->url->link('employee/employee_profile', 'token=' . $this->session->data['token'], 'SSL');

        $this->template = 'common/page_header.tpl';
        $this->render();
    }

    public function updateCompany() {
        $post = $this->request->post;
        $this->session->data['company_id'] = $post['login_company'];
        $this->redirect($post['redirect']);
    }
}

?>