<?php

class ControllerEmployeeEmployeeAllowanceRequest extends HController {

    protected function getAlias() {
        return 'employee/employee_allowance_request';
    }

    protected function getPrimaryKey() {
        return 'special_allowance_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $lang = $this->load->language($this->getAlias());

        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');

        $data = array();
        $aColumns = array('action','document_date', 'document_identity','special_allowance_type', 'registration_code', 'employee_name',  'total_amount','approved_status','approved_amount','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        //$arrWhere[] = "`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        $arrWhere[] = "`employee_id` = '".$this->session->data['employee_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $lang['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['approved_status']=='Pending') {
                $actions[] = array(
                    'text' => $lang['submit'],
                    'href' => 'javascript:void(0);',
                    'click' => "SubmitRequest('" . $this->url->link($this->getAlias() . '/submitRequest', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-thumbs-up'
                );

                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['target'])?'target="'.$action['target'].'"':'').' '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }
            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    public function submitRequest() {
        $lang = $this->load->language('employee/employee_allowance_request');
        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        $this->model['employee_family'] = $this->load->model('employee/employee_family');

        $special_allowance_id = $this->request->get['id'];
        $allowance = $this->model['special_allowance']->getRow(['special_allowance_id' => $special_allowance_id]);
        $details = $this->model['special_allowance_detail']->getRows(['special_allowance_id' => $special_allowance_id]);
        foreach($details as $detail) {
            $family_data = $this->model['employee_family']->getRow(['employee_family_id' => $detail['employee_family_id']]);

            $update_detail = [];
            $update_detail['school_id'] = $family_data['school_id'];
            $update_detail['class_id'] = $family_data['class_id'];
            $update_detail['period_start_date'] = $family_data['period_start_date'];
            $update_detail['period_end_date'] = $family_data['period_end_date'];

            $this->model['special_allowance_detail']->edit($this->getAlias(), $detail['special_allowance_detail_id'], $update_detail);
        }

        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(['company_id' => $allowance['company_id']]);
        if($company['allowance_request_verified_by']=='Admin') {
            $data['approved_status'] = 'Pending Verification';
        } else {
            $data['approved_status'] = 'Requested';
        }
        $this->model['special_allowance']->edit($this->getAlias(), $special_allowance_id, $data);

        $this->session->data['success'] = $lang['success_request_submit'];
        $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function getForm() {
        parent::getForm();

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getEmployeeDepartments($this->session->data['employee_id']);
        //d([$this->session->data['employee_id'], $this->data['employees']], true);
        $this->data['allowance_allowed'] = 0;
        $this->data['isEdit'] = 0;
        $this->data['html_policy'] = '';
        $this->data['approved_status'] = 'Pending';
        $this->model['special_allowance'] = $this->load->model('employee/employee_allowance_request');
        $this->data['approved_allowances'] = array();
        $this->data['document_date'] = stdDate();

        $this->model['special_allowance_type'] = $this->load->model('setup/special_allowance_type');
        $this->data['special_allowance_types'] = $this->model['special_allowance_type']->getRows();
        $arrPolicies = [];
        $policies = [];
        if (isset($this->request->get['special_allowance_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit'] = 1;

            $result = $this->model[$this->getAlias()]->getRow(array('special_allowance_id' => $this->request->get['special_allowance_id']));

            $this->model['special_allowance_category'] = $this->load->model('setup/special_allowance_category');
            $this->data['categories'] = $this->model['special_allowance_category']->getRows(array('special_allowance_type_id' => $result['special_allowance_type_id']));

            foreach($result as $field => $value) {
                if($field=='document_date') {
                    $this->data[$field] = stdDate($value);
                } elseif($field=='medical_from' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } elseif($field=='medical_to' && $value != '') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }
            if($result['file_directory'] != '' && file_exists(DIR_FILES . $result['file_directory'])) {
                $this->data['href_document_file'] = HTTP_FILES . $result['file_directory'];
            } else {
                $this->data['href'] = '';
                $this->data['file_directory'] = '';
                $this->data['file_name'] = '';
            }

            $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
            $allowance_details = $this->model['special_allowance_detail']->getRows(array('special_allowance_id' => $result['special_allowance_id']),array('sort_order DESC'));
            foreach($allowance_details as $row_id => $detail) {
                if($detail['receipt_date'] != '') {
                    $detail['receipt_date'] = stdDate($detail['receipt_date']);
                }
                if($detail['file_directory'] != '' && file_exists(DIR_FILES . $detail['file_directory'])) {
                    $detail['href'] = HTTP_FILES . $detail['file_directory'];
                } else {
                    $detail['href'] = '';
                    $detail['file_directory'] = '';
                    $detail['file_name'] = '';
                }
                $this->data['allowance_details'][$row_id] = $detail;
            }

            // This will show the selected Allowance Policy
            $this->model['employee'] = $this->load->model('employee/employee_registration');
            $employee = $this->model['employee']->getRecord(['employee_registration_id' => $result['employee_registration_id']]);
            $special_allowance_type_id = $result['special_allowance_type_id'];
            $company_id = $employee['company_id'];
            $department_id = $employee['department_id'];
            $employee_registration_id = $employee['employee_registration_id'];
            $employee_id = $employee['employee_id'];

            if($employee['override_allowance_policy']) {
                $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance_policy');
                $policies = $this->model['employee_allowance']->getRows(array('employee_registration_id' => $employee_registration_id, 'allowance_type_id' => $special_allowance_type_id));
            } else {
                $this->model['department'] = $this->load->model('setup/department');
                $department = $this->model['department']->getRow(['department_id' => $department_id]);
                if($department['override_allowance_policy']) {
                    $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
                    $policies = $this->model['policy']->getRecords(array('department_id' => $department_id, 'allowance_type_id' => $special_allowance_type_id));
                } else {
                    $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
                    $policies = $this->model['policy']->getRecords(array('company_id' => $company_id, 'allowance_type_id' => $special_allowance_type_id));
                }
            }

            $arrRelaton = [];
            foreach($policies as $policy) {
                $arrPolicies[$policy['relation']][$policy['allowance_category_id']] = [
                    'allowance_on' => $policy['allowance_on'],
                    'allowance_value' => $policy['allowance_value'],
                ];

                $arrRelaton[] = $policy['relation'];
            }

            $arrWhere = [];
            $arrWhere[] = "`employee_id` = '$employee_id'";
            $arrWhere[] = "`relation` IN ('".implode("','", $arrRelaton)."')";
            $where = implode(" AND ", $arrWhere);
            $this->model['employee_family'] = $this->load->model('employee/employee_family');
            $this->data['families'] = $this->model['employee_family']->getArrays('employee_family_id',array('employee_family_id','relation','school_id','school_name','class_id','class_name','full_name'),$where,array('sort_order'));

            // This will show the Previous Approved Allowances
            $this->model['special_allowance'] = $this->load->model('employee/employee_allowance_request');
            $this->data['approved_allowances'] = $this->model['special_allowance']->getRows(
                array(
                    'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                    'employee_registration_id' => $result['employee_registration_id'],
                    'special_allowance_type_id' => $result['special_allowance_type_id'],
                    'approved_status' => 'Approved',
                )
            );


            $this->data['href_post_allowance'] = $this->url->link($this->getAlias() . '/submitRequest', 'token=' . $this->session->data['token'].'&id='.$this->request->get['special_allowance_id']);
        }
        $this->data['policies'] = $policies;
        $this->data['arrPolicies'] = $arrPolicies;

        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $this->data['families'] = $this->model['employee_family']->getRows(array('employee_id'=>$this->session->data['employee_id']), array('sort_order'));
        $this->data['family_exists']=(empty($this->data['families'])?0:1);

        //$this->data['href_get_employee_departments'] = $this->url->link($this->getAlias() . '/getEmployeeDepartments', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);

        $this->data['href_employee_profile'] = $this->url->link('employee/employee_profile/update', 'token=' . $this->session->data['token'].'&employee_id='.$this->session->data['employee_id'], 'SSL');
        $this->data['href_get_allowed_allowance_type'] = $this->url->link($this->getAlias() . '/getAllowedAllowanceType', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);
        $this->data['href_get_emp_allowance'] = $this->url->link($this->getAlias() . '/getEmployeeAllowance', 'token=' . $this->session->data['token']);
        $this->data['href_get_allowance_category'] = $this->url->link($this->getAlias() . '/getAllowanceCategory', 'token=' . $this->session->data['token']);
        $this->data['href_get_policy'] = $this->url->link($this->getAlias() . '/getPolicy', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);
        $this->data['action_validate_name'] = $this->url->link($this->getAlias() . '/validateName', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);
        $this->data['strValidation']="{
            'rules':{
		        'document_date': {'required':true},
		        'employee_registration_id': {'required':true},
		        'special_allowance_type_id': {'required':true},
		        'total_amount': {'required':true, 'min':1},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function getAllowedAllowanceType() {
        $post = $this->request->post;
        $employee_registration_id = $post['employee_registration_id'];

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->model['policy'] = $this->load->model('employee/employee_allowance_policy');

        $employee = $this->model['employee']->getRecord(['employee_registration_id' => $employee_registration_id]);
        $company_id = $employee['company_id'];
        $department_id = $employee['department_id'];
        if($employee['override_allowance_policy']) {
            $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance_policy');
            $policies = $this->model['employee_allowance']->getRows(array('employee_registration_id' => $employee_registration_id),['sort_order']);
        } else {
            $this->model['department'] = $this->load->model('setup/department');
            $department = $this->model['department']->getRow(['department_id' => $department_id]);
            if($department['override_allowance_policy']) {
                $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('department_id' => $department_id),['sort_order']);
            } else {
                $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('company_id' => $company_id),['sort_order']);
            }
        }
        // d($post);
        // d($policies,true);
        $html = '';
        $html .= '<option value="">&nbsp;</option>';
        $arrExist = [];
        foreach($policies as $policy) {

            if(!isset($arrExist[$policy['allowance_type_id']])){
              $html .= '<option value="'.$policy['allowance_type_id'].'">'.$policy['allowance_type'].'</option>';
               $arrExist[$policy['allowance_type_id']] = $policy['allowance_type_id'];
            }
           
        }

        $json = array(
            'success' => true,
            'html' => $html
        );

        echo json_encode($json);
        exit;
    }

    public function getAllowanceCategory()
    {
        $post = $this->request->post;
        // d($post,true);
        $filter = array(
            'family_id' => $post['family_id'],
            'employee_registration_id' => $post['employee_registration_id'],
            'allowance_type_id' => $post['allowance_type_id'],
        );

        $this->model['employee_allowance_request'] = $this->load->model('employee/employee_allowance_request');
        $results = $this->model['employee_allowance_request']->getAllowanceCategory($filter);
        //d([$filter, $results], true);
        $this->model['special_allowance_category'] = $this->load->model('setup/special_allowance_category');
        foreach ($results as $key => $value) {
            if($value['allowance_category_id'] == 0)
            {
                // get all category type
                $allowance_list[] = $this->model['special_allowance_category']->getRows(array('special_allowance_type_id' => $filter['allowance_type_id']));
            }
            else
            {
                // get the specific category
                $allowance_list[] = $this->model['special_allowance_category']->getRows(array('special_allowance_type_id' => $filter['allowance_type_id'],
                    'special_allowance_category_id' => $value['allowance_category_id']));
            }
        }

        $html = '<option>&nbsp;</option>';
        foreach ($allowance_list as $key => $value) {
            foreach ($value as $key1 => $value1) {
                $html .= '<option value="'.$value1['special_allowance_category_id'].'" >'.$value1['special_allowance_category'].'</option>';
            }
        }

        // d($html,true);
        $json = array(
            'success' => true,
            'html' => $html,
        );
        echo json_encode($json);
        exit;
    }


    public function getEmployeeAllowance()
    {
        $post = $this->request->post;
        $emp_id = $post['employee_registration_id'];
        $allowance_type_id = $post['special_allowance_type_id'];
        if($allowance_type_id == 1)
        {
            // scholarship types
            $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
            $this->data['special_allowance'] = $this->model['special_allowance']->getEmployeeSpecialScholarshipAllowance($emp_id,1);
            // d($this->data['special_allowance'],true);

        }
        else if($allowance_type_id == 2)
        {
            // medical types
            $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
            $this->data['special_allowance'] = $this->model['special_allowance']->getEmployeeSpecialMedicalAllowance($emp_id,2);
            // d($this->data['special_allowance'],true);
        }

        $json = array(
            'success' => true,
            'post' => $post,
            'emp_allowances' => $this->data['special_allowance']
        );
        echo json_encode($json);
    }

    public function getPolicy() {
        $post = $this->request->post;
        $employee_registration_id = $post['employee_registration_id'];
        $company_id = $post['company_id'];
        $special_allowance_type_id = $post['special_allowance_type_id'];

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->model['allowance_category'] = $this->load->model('setup/special_allowance_category');
        $this->model['policy'] = $this->load->model('employee/employee_allowance_policy');

        $employee = $this->model['employee']->getRecord(['employee_registration_id' => $employee_registration_id]);
        $department_id = $employee['department_id'];
        $company_id = $employee['company_id'];
        $employee_id = $employee['employee_id'];
        if($employee['override_allowance_policy']) {
            $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance_policy');
            $policies = $this->model['employee_allowance']->getRows(array('employee_registration_id' => $post['employee_registration_id'], 'allowance_type_id' => $post['special_allowance_type_id']),['sort_order']);
        } else {
            $this->model['department'] = $this->load->model('setup/department');
            $department = $this->model['department']->getRow(['department_id' => $department_id]);
            if($department['override_allowance_policy']) {
                $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('department_id' => $department_id, 'allowance_type_id' => $post['special_allowance_type_id']),['sort_order']);
            } else {
                $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('company_id' => $company_id, 'allowance_type_id' => $post['special_allowance_type_id']),['sort_order']);
            }
        }

        $allowance_categories = $this->model['allowance_category']->getRows(array('special_allowance_type_id' => $post['special_allowance_type_id']));
        $html_policy = '';
        $arrRelaton = [];
        if($policies) {
            $html_policy .= '<table id="tblPolicy" class="table table-stripped">';
            $html_policy .= '<thead>';
            $html_policy .= '<tr>';
            $html_policy .= '<th>Allowance For</th>';
            $html_policy .= '<th>Allowance Category</th>';
            $html_policy .= '<th>Allowance On</th>';
            $html_policy .= '<th>Allowance Value</th>';
            $html_policy .= '</tr>';
            $html_policy .= '</thead>';
            $html_policy .= '<tbody>';

            $arrPolicies = array();
            foreach($policies as $policy) {
                $html_policy .= '<tr>';
                $html_policy .= '<td>'.$policy['relation'].'</td>';
                $html_policy .= '<td>'.$policy['allowance_category'].'</td>';
                $html_policy .= '<td>'.$policy['allowance_on'].'</td>';
                $html_policy .= '<td>'.$policy['allowance_value'].'</td>';
                $html_policy .= '</tr>';

                $arrPolicies[$policy['relation']][$policy['allowance_category_id']] = [
                    'allowance_on' => $policy['allowance_on'],
                    'allowance_value' => $policy['allowance_value'],
                ];
                $arrRelaton[] = $policy['relation'];
            }
            $html_policy .= '</tbody>';
            $html_policy .= '</table>';
            $allowance_allowed = 1;
        } else {
            $allowance_allowed = 0;
        }

        $arrWhere = [];
        $arrWhere[] = "`employee_id` = '$employee_id'";
        $arrWhere[] = "`relation` IN ('".implode("','", $arrRelaton)."')";
        $where = implode(" AND ", $arrWhere);
        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $families = $this->model['employee_family']->getArrays('employee_family_id',array('employee_family_id','relation','school_id','school_name','class_id','class_name','full_name','period_start_date','period_end_date'),$where,array('sort_order'));

        $this->model['special_allowance'] = $this->load->model('employee/employee_allowance_request');
        $approved_allowances = $this->model['special_allowance']->getRows(
            array(
                'fiscal_year_id' => $this->session->data['fiscal_year_id'],
                'employee_registration_id' => $post['employee_registration_id'],
                'special_allowance_type_id' => $post['special_allowance_type_id'],
                'approved_status' => 'Approved',
            )
        );
        $html_approved = '';
        foreach($approved_allowances as $allowance) {
            $html_approved .= '<tr>';
            $html_approved .= '<td>'.stdDate($allowance['document_date']).'</td>';
            $html_approved .= '<td>'.$allowance['document_identity'].'</td>';
            $html_approved .= '<td>'.$allowance['total_amount'].'</td>';
            $html_approved .= '<td>'.$allowance['approved_amount'].'</td>';
            $html_approved .= '</tr>';
        }

        $json = array(
            'success' => true,
            'post' => $post,
            'policies' => $arrPolicies,
            'families' => $families,
            'categories' => $allowance_categories,
            'allowance_allowed' => $allowance_allowed,
            'html_policy' => $html_policy,
            'html_approved'=>$html_approved,
            'emp_allowances' => $this->data['member_allowance']
        );
        echo json_encode($json);
    }

    protected function validateInsert() {
        $this->validateForm();

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    protected function insertData($data) {
        $submit = $this->request->get['submit'];
        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(['company_id' => $data['company_id']]);
        $document_no = $this->model[$this->getAlias()]->getMaxDocumentNo();

        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_no'] = $document_no;
        $data['document_identity'] = $this->session->data['fy_code'].'-'.str_pad($document_no,5,"0",STR_PAD_LEFT);
        $data['document_date'] = MySqlDate($data['document_date']);
        $data['created_by_id'] = $this->session->data['employee_name'];

        if($submit==1) {
            if($company['allowance_request_verified_by']=='Admin') {
                $data['approved_status'] = 'Pending Verification';
            } else {
                $data['approved_status'] = 'Requested';
            }
        } else {
            $data['approved_status'] = 'Pending';
        }

        if($data['medical_from'] != '') {
            $data['medical_from'] = MySqlDate($data['medical_from']);
        } else {
            $data['medical_from'] = NULL;
        }

        if($data['medical_to'] != '') {
            $data['medical_to'] = MySqlDate($data['medical_to']);
        } else {
            $data['medical_to'] = NULL;
        }

        $file = $this->request->files['document'];
        if($file['size'] < 1048576 && $file['size'] > 0) {
            $dir_files = DIR_FILES;
            $uploaded_file = '/'.$data['document_identity'].'-'.basename($file['name']);
            move_uploaded_file($file['tmp_name'], $dir_files . $uploaded_file);

            $data['file_name'] = $file['name'];
            $data['file_directory'] = $uploaded_file;

        }

        //d($data, true);
        $special_allowance_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        $arrFiles = array();
        foreach($this->request->files['details'] as $field => $files) {
            foreach($files as $index => $file) {
                $arrFiles[$index][$field] = $file['document'];
            }
        }
        //d(array($this->request->files['details'], $arrFiles),true);
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');

        foreach($data['details']  as $index => $detail){
            $detail['special_allowance_id'] = $special_allowance_id;
            $detail['sort_order'] = $index;

            if($detail['receipt_date'] != '') {
                $detail['receipt_date'] = MySqlDate($detail['receipt_date']);
            } else {
                $detail['receipt_date'] = NULL;
            }

            if(isset($arrFiles[$index]) && $arrFiles[$index]['tmp_name'] != '') {
                if($arrFiles[$index]['size'] < 1048576) {
//                    $dir_files = DIR_FILES;
//                    if(!file_exists($dir_files)) {
//                        mkdir($dir_files);
//                    }
                    $upload_file = $dir_files .'/'.$data['document_identity'].'-'.basename($arrFiles[$index]['name']);
                    move_uploaded_file($arrFiles[$index]['tmp_name'], $upload_file);

                    $detail['file_name'] = $data['document_identity'].'-'.basename($arrFiles[$index]['name']);
                    $detail['file_directory'] = $data['document_identity'].'-'.basename($arrFiles[$index]['name']);

                }
            }

            $this->model['special_allowance_detail']->add($this->getAlias(), $detail);
        }

        return $special_allowance_id;
    }

    protected function validateUpdate() {
        $this->validateForm();

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    protected function updateData($primary_key, $data) {
        ini_set('max_execution_time', '0');
        $submit = $this->request->get['submit'];
        $this->model['company'] = $this->load->model('setup/company');
        $company = $this->model['company']->getRow(['company_id' => $data['company_id']]);
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        $data['document_date'] = MySqlDate($data['document_date']);
        $data['modified_by_id'] = $this->session->data['employee_name'];

        if($submit==1) {
            if($company['allowance_request_verified_by']=='Admin') {
                $data['approved_status'] = 'Pending Verification';
            } else {
                $data['approved_status'] = 'Requested';
            }
        } else {
            $data['approved_status'] = 'Pending';
        }

        if($data['medical_from'] != '') {
            $data['medical_from'] = MySqlDate($data['medical_from']);
        } else {
            $data['medical_from'] = NULL;
        }

        if($data['medical_to'] != '') {
            $data['medical_to'] = MySqlDate($data['medical_to']);
        } else {
            $data['medical_to'] = NULL;
        }

        $file = $this->request->files['document'];
        if($file['size'] < 1048576 && $file['size'] > 0) {
            $dir_files = DIR_FILES;
            $uploaded_file = '/'.$data['document_identity'].'-'.basename($file['name']);
            move_uploaded_file($file['tmp_name'], $dir_files . $uploaded_file);

            $data['file_name'] = $file['name'];
            $data['file_directory'] = $uploaded_file;

        }
        //d($data, true);
        $special_allowance_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        $arrFiles = array();
        foreach($this->request->files['details'] as $field => $files) {
            foreach($files as $index => $file) {
                $arrFiles[$index][$field] = $file['document'];
            }
        }
        $this->model['special_allowance_detail']->deleteBulk($this->getAlias(), array('special_allowance_id' => $primary_key));
        //d($data['details'], true);
        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        foreach($data['details'] as $index => $detail){
            $family_data = $this->model['employee_family']->getRow(['employee_family_id' => $detail['employee_family_id']]);
            $detail['school_id'] = $family_data['school_id'];
            $detail['class_id'] = $family_data['class_id'];
            $detail['period_start_date'] = $family_data['period_start_date'];
            $detail['period_end_date'] = $family_data['period_end_date'];
            $detail['special_allowance_id'] = $special_allowance_id;
            $detail['sort_order'] = $index;

            if($detail['receipt_date'] != '') {
                $detail['receipt_date'] = MySqlDate($detail['receipt_date']);
            } else {
                $detail['receipt_date'] = NULL;
            }
            if($detail['period_start_date'] == '') {
                $detail['period_start_date'] = NULL;
            }
            if($detail['period_end_date'] == '') {
                $detail['period_end_date'] = NULL;
            }

            if(isset($arrFiles[$index]) && $arrFiles[$index]['tmp_name'] != '') {
                if($arrFiles[$index]['size'] < 1048576) {
                    $dir_files = DIR_FILES.'E'.$data['employee_code'];
                    if(!file_exists($dir_files)) {
                        mkdir($dir_files);
                    }
                    $upload_file = $dir_files .'/'. basename($arrFiles[$index]['name']);
                    move_uploaded_file($arrFiles[$index]['tmp_name'], $upload_file);

                    $detail['file_name'] = 'E'.$data['employee_code'].'/'.basename($arrFiles[$index]['name']);
                    $detail['file_directory'] = 'E'.$data['employee_code'].'/'.basename($arrFiles[$index]['name']);

                }
            }
            //d(array($data,$detail), true);
            $this->model['special_allowance_detail']->add($this->getAlias(), $detail);
        }

        return $primary_key;
    }

    protected function validateDelete($id='') {
        if (!$this->error) {
            return true;
        } else {
            $this->session->data['error_warning'] = $this->error['warning'];
            return false;
        }
    }

    protected function deleteData($primary_key) {
        $this->model['special_allowance_detail'] = $this->load->model('employee/employee_allowance_request_detail');
        $this->model['special_allowance_detail']->deleteBulk($this->getAlias(), array('special_allowance_id' => $primary_key));
        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);
    }

    public function printDocument() {
        $special_allowance_id = $this->request->get['special_allowance_id'];
        $lang = $this->load->language($this->getAlias());

        $this->model['special_allowance'] = $this->load->model('employee/employee_allowance_request');
        $this->model['special_allowance_detail'] = $this->load->model('employee/employee_allowance_request_detail');
        $this->model['employee'] = $this->load->model('employee/employee_registration');
        //$this->model['employee_medical'] = $this->load->model('employee/employee_medical');
        //$this->model['employee_scholarship'] = $this->load->model('employee/employee_scholarship');
        $this->model['employee_allowance_policy'] = $this->load->model('employee/employee_allowance_policy');
        $this->model['employee_family'] = $this->load->model('employee/employee_family');

        $voucher = $this->model['special_allowance']->getRow(array('special_allowance_id' => $special_allowance_id));
        $details = $this->model['special_allowance_detail']->getRows(array('special_allowance_id' => $special_allowance_id),array('FIELD(allowance_for,"Self","Spouse","Child","Parent","Sibling")','receipt_date'));
        //$employee = $this->model['employee']->getRow(array('employee_id' => $voucher['employee_id']));
        $employee = $this->model['employee']->getRecord(['employee_registration_id' => $voucher['employee_registration_id']]);
        $families = $this->model['employee_family']->getArrays('employee_family_id','full_name',array('employee_id' => $voucher['employee_id']));
        //$policies = $this->model['employee_allowance_policy']->getRows(array('employee_registration_id' => $voucher['employee_registration_id'], 'allowance_type_id' => $voucher['special_allowance_type_id']));
        $department_id = $employee['department_id'];
        $company_id = $employee['company_id'];
        if($employee['override_allowance_policy']) {
            $this->model['employee_allowance'] = $this->load->model('employee/employee_allowance_policy');
            $policies = $this->model['employee_allowance']->getRows(array('employee_registration_id' => $voucher['employee_registration_id'], 'allowance_type_id' => $voucher['special_allowance_type_id']),['sort_order']);
        } else {
            $this->model['department'] = $this->load->model('setup/department');
            $department = $this->model['department']->getRow(['department_id' => $department_id]);
            if($department['override_allowance_policy']) {
                $this->model['policy'] = $this->load->model('setup/department_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('department_id' => $department_id, 'allowance_type_id' => $voucher['special_allowance_type_id']),['sort_order']);
            } else {
                $this->model['policy'] = $this->load->model('setup/company_allowance_policy');
                $policies = $this->model['policy']->getRecords(array('company_id' => $company_id, 'allowance_type_id' => $voucher['special_allowance_type_id']),['sort_order']);
            }
        }
        //d($details,true);
        foreach($policies as $policy) {
            if($policy['relation']=='Children') {
                $policy['relation']='Child';
            }
            $arrPolicies[$policy['relation']][$policy['allowance_category']] = array(
                'allowance_on' => $policy['allowance_on'],
                'allowance_value' => $policy['allowance_value'],
            );
        }

        if($employee['employee_image'] && file_exists(DIR_IMAGE.$employee['employee_image'])) {
            $employee_image = DIR_IMAGE . $employee['employee_image'];
        } else {
            $employee_image = DIR_IMAGE . 'no_user.jpg';
        }
        //d(array($voucher, $details, $families), true);

        if($voucher['special_allowance_type_id']==1 || $voucher['special_allowance_type_id']==5) {
            //Scholarship
            $arrFamilyData=array();
            foreach($details as $detail) {
                //d($detail, true);
                if(!isset($arrFamilyData[$detail['employee_family_id']])) {
                    $arrFamilyData[$detail['employee_family_id']] = array(
                        'special_allowance_id' => $detail['special_allowance_id'],
                        'school_id' => $detail['school_id'],
                        'class_id' => $detail['class_id'],
                        'relation' => $detail['relation'],
                        'school_name' => $detail['school_name'],
                        'class_name' => $detail['class_name'],
                        'member_name' => $detail['full_name'],
                        'period' => ($detail['period_start_date']?stdDate($detail['period_start_date']).' - ':'').($detail['period_end_date']?stdDate($detail['period_end_date']):''),
                    );
                }

                $arrFamilyData[$detail['employee_family_id']]['details'][] = array(
                    'special_allowance_detail_id' => $detail['special_allowance_detail_id'],
                    'special_allowance_category_id' => $detail['special_allowance_category_id'],
                    'special_allowance_category' => $detail['special_allowance_category'],
                    'remarks' => $detail['remarks'],
                    'receipt_date' => ($detail['receipt_date']?stdDate($detail['receipt_date']):''),
                    'receipt_no' => $detail['receipt_no'],
                    'amount' => $detail['amount'],
                );
            }
            //d($arrFamilyData, true);
            $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->SetAuthor('Huzaifa Khambaty');
            $pdf->SetTitle('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis'));
            $pdf->SetSubject('Covering Letter');

            // set margins
            //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
            $pdf->SetHeaderMargin(10);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

            $pdf->data = array(
                'company_name' => $voucher['company_name'],
                'document_identity' => $voucher['document_identity'],
                'approved_status' => $voucher['approved_status']
            );
            $pdf->lang = $lang;
            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

            // add a page
            $pdf->AddPage();
            //$pdf->Cell(0,10,'',1,1);
            //$pdf->Cell(180,10,'',1,1);
            $pdf->Image($employee_image, 15, 20, 25, 25);

            $pdf->SetDrawColor(205,205,205);
            $pdf->SetFillColor(255,127,80);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(25, 6, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $voucher['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['document_identity'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['cnic_address'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, stdDate($voucher['document_date']), 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['cnic_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['special_allowance_type'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['its_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            if($voucher['approved_status'] == 'Pending')
            {
                $pdf->SetFillColor(255,255,255);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(25, 10, 'Status Pending', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            }
            $pdf->ln(20);
            $net_amount = 0;
            foreach($arrFamilyData as $data) {
                $pdf->SetFillColor(0,255,204);
                $pdf->SetTextColor(0,0,0);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(15, 8, 'Relation:', 'LTB', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(25, 8, $data['relation'], 'TB', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(20, 8, 'Name:', 'TB', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(120, 8, $data['member_name'], 'TBR', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(15, 8, 'Class:', 'BL', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(25, 8, $data['class_name'], 'B', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(20, 8, 'School:', 'B', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(50, 8, $data['school_name'], 'B', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(20, 8, 'Period:', 'B', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(50, 8, $data['period'], 'BR', false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
                $pdf->SetFillColor(0,206,209);
                $pdf->SetTextColor(255,255,255);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(35, 8, 'Category', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->Cell(75, 8, 'Remarks', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->Cell(20, 8, 'Receipt Date', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->Cell(30, 8, 'Receipt No', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->Cell(20, 8, 'Amount', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
                $total_amount = 0;
                foreach($data['details'] as $detail) {
                    $pdf->SetFillColor(255,255,255);
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont('helvetica', '', 8);
                    $pdf->Cell(35, 8, $detail['special_allowance_category'], 1, false, 'L', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(75, 8, $detail['remarks'], 1, false, 'L', 1, '', 1, false, 'T', 'M');
                    $pdf->Cell(20, 8, $detail['receipt_date'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(30, 8, $detail['receipt_no'], 1, false, 'C', 1, '', 1, false, 'T', 'M');
                    $pdf->Cell(20, 8, number_format($detail['amount'],2), 1, false, 'R', 1, '', 0, false, 'T', 'M');
                    $pdf->ln(8);
                    $total_amount += $detail['amount'];
                    $net_amount += $detail['amount'];
                }
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(160, 8, 'Total:', 1, false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 8);
                $pdf->Cell(20, 8, number_format($total_amount,2), 1, false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
                $pdf->ln(4);
            }
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(160, 8, 'Grand Total:', 1, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(20, 8, number_format($net_amount,2), 1, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->ln(32);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(40, 8, 'Applicant Signature', 'T', false, 'C');
            $pdf->Cell(30, 8, '', 0, false, 'C');
            $pdf->Cell(40, 8, 'Verified by', 'T', false, 'C');
            $pdf->Cell(30, 8, '', 0, false, 'C');
            $pdf->Cell(40, 8, 'Approved By', 'T', false, 'C');
        } elseif($voucher['special_allowance_type_id']==2) {
            //MEDICAL
            $arrFamilyData = array();
            foreach($details as $detail) {
                if(isset($arrPolicies[$detail['relation']][$detail['special_allowance_category']]) && $arrPolicies[$detail['relation']][$detail['special_allowance_category']]['allowance_on']=='Percent') {
                    $desc = $detail['relation'].' ['.$arrPolicies[$detail['relation']][$detail['special_allowance_category']]['allowance_value'].'% on '.$detail['special_allowance_category'].']';
                    $percent = $arrPolicies[$detail['relation']][$detail['special_allowance_category']]['allowance_value'];
                } elseif(isset($arrPolicies[$detail['relation']]['ALL'])) {
                    $desc = $detail['relation'].' ['.$arrPolicies[$detail['relation']]['ALL']['allowance_value'].'% on All]';
                    $percent = $arrPolicies[$detail['relation']]['ALL']['allowance_value'];
                } else {
                    $desc = $detail['relation'].' [0% on '.$detail['special_allowance_category'].']';
                    $percent = 0;
                }
                if(!isset($arrFamilyData[$desc])) {
                    $arrFamilyData[$desc] = array(
                        'category' => $detail['special_allowance_category'],
                        'relation' => $detail['relation'],
                        'percent' => $percent
                    );
                }
                $arrFamilyData[$desc]['details'][] = array(
                    'receipt_no' => $detail['receipt_no'],
                    'receipt_date' => $detail['receipt_date'],
                    'remarks' => $detail['remarks'],
                    'amount' => $detail['amount'],
                    'relation' => $detail['relation'],
                    'full_name' => $detail['full_name'],
                    'category' => $detail['special_allowance_category'],
                );
            }

            $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->SetAuthor('Huzaifa Khambaty');
            $pdf->SetTitle('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis'));
            $pdf->SetSubject('Covering Letter');

            // set margins
            //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
            $pdf->SetHeaderMargin(10);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

            $pdf->data = array(
                'company_name' => $voucher['company_name'],
                'document_identity' => $voucher['document_identity'],
                'approved_status' => $voucher['approved_status']
            );
            $pdf->lang = $lang;
            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

            // add a page
            $pdf->AddPage();
            //$pdf->Cell(0,10,'',1,1);
            //$pdf->Cell(180,10,'',1,1);

            $pdf->Image($employee_image, 15, 20, 25, 25);

            $pdf->SetDrawColor(205,205,205);
            $pdf->SetFillColor(255,127,80);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(25, 6, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $voucher['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. No:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['document_identity'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $employee['cnic_address'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. Date:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, stdDate($voucher['document_date']), 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $employee['cnic_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. Type:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['special_allowance_type'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['its_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            if($voucher['approved_status'] == 'Pending')
            {
                $pdf->SetFillColor(255,255,255);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(25, 10, 'Status Pending', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            }
            $pdf->ln(20);

            $pdf->SetFont('helvetica', 'B', 8);
            //$pdf->Cell(90, 5, 'Sheikh Kumail Saheb,', 0, false, 'L');
            //$pdf->ln(5);
            $pdf->Cell(90, 5, 'Dawat-e-Hadiyah,', 0, false, 'L');
            $pdf->ln(5);
            $pdf->Cell(90, 5, 'Karachi.', 0, false, 'L');
            $pdf->ln(5);
            $from_date = ($voucher['medical_from']?'From ' . date('M Y',strtotime($voucher['medical_from'])):'');
            $to_date = ($voucher['medical_to']?'To ' . date('M Y', strtotime($voucher['medical_to'])):'');
            $pdf->Cell(0, 8, 'Sub: Medical '.$from_date.' '.$to_date, 0, false, 'C');
            $pdf->ln(10);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(90, 8, 'Dear Sir,', 0, false, 'L');
            $pdf->ln(5);
            $pdf->Cell(90, 8, 'Most respectfully requesting for Medical Expenses as follows:', 0, false, 'L');
            $grand_total = 0;
            foreach($arrFamilyData as $heading => $data) {
                $pdf->ln(10);
                $pdf->SetFont('helvetica', 'B', 8);
                $pdf->Cell(90, 8, $heading, 0, false, 'L');
                $pdf->ln(7);
                $pdf->SetFont('helvetica', '', 8);
                $pdf->SetFillColor(0,206,209);
                $pdf->SetTextColor(255,255,255);
                $pdf->Cell(30, 8, 'Cash Memo / Bill No', 1, false, 'C',1);
                $pdf->Cell(20, 8, 'Date', 1, false, 'C',1);
                $pdf->Cell(100, 8, 'Particulars', 1, false, 'C',1);
                $pdf->Cell(30, 8, 'Amount', 1, false, 'C',1);
                $pdf->SetFont('helvetica', '', 8);

                $total_amount = 0;
                $policy_amount = 0;
                $pdf->SetFillColor(255,127,80);
                $pdf->SetTextColor(0,0,0);
                foreach($data['details'] as $detail) {
                    $pdf->ln(8);
                    $pdf->Cell(30, 8, $detail['receipt_no'], 1, false, 'C');
                    $pdf->Cell(20, 8, stdDate($detail['receipt_date']), 1, false, 'C');
                    $pdf->Cell(100, 8, $detail['remarks'], 1, false, 'L');
                    $pdf->Cell(30, 8, number_format($detail['amount'],2), 1, false, 'R');

                    $total_amount += $detail['amount'];
                    $policy_amount += ($detail['amount'] * $data['percent'] / 100);
                    $grand_total += ($detail['amount'] * $data['percent'] / 100);
                }
                $pdf->ln(8);
                $pdf->Cell(150, 8, 'Total Amount: ', 0, false, 'R');
                $pdf->Cell(30, 8, number_format($total_amount,2), 1, false, 'R');
                $pdf->ln(8);
                $pdf->Cell(150, 8, 'Policy Amount: '.$data['percent'].'% ', 0, false, 'R');
                $pdf->Cell(30, 8, number_format($policy_amount,2), 1, false, 'R');
            }
            $pdf->ln(15);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(130, 8, '', 0, false, 'R');
            $pdf->Cell(20, 8, 'Total Rs: ', 'TB', false, 'R');
            $pdf->Cell(30, 8, number_format($grand_total,0), 'TB', false, 'R');
            $pdf->ln(20);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(40, 8, 'Applicant Signature', 'T', false, 'C');
            $pdf->Cell(30, 8, '', 0, false, 'C');
            $pdf->Cell(40, 8, 'Verified by', 'T', false, 'C');
            $pdf->Cell(30, 8, '', 0, false, 'C');
            $pdf->Cell(40, 8, 'Approved By', 'T', false, 'C');
            $pdf->ln(4);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(40, 8, $employee['full_name'], 0, false, 'C');
        } else {
            // ALL Other
            $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
            $pdf->SetAuthor('Huzaifa Khambaty');
            $pdf->SetTitle('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis'));
            $pdf->SetSubject('Covering Letter');

            // set margins
            //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
            $pdf->SetHeaderMargin(10);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

            $pdf->data = array(
                'company_name' => $voucher['company_name'],
                'document_identity' => $voucher['document_identity'],
                'approved_status' => $voucher['approved_status']
            );
            $pdf->lang = $lang;
            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

            // add a page
            $pdf->AddPage();
            //$pdf->Cell(0,10,'',1,1);
            //$pdf->Cell(180,10,'',1,1);
            $pdf->Image($employee_image, 15, 20, 25, 25);
            $pdf->SetDrawColor(205,205,205);
            $pdf->SetFillColor(255,127,80);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(25, 6, '', 0, false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $voucher['employee_name'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. No:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['document_identity'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $employee['cnic_address'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. Date:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, stdDate($voucher['document_date']), 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(110, 6, $employee['cnic_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(20, 6, 'Doc. Type:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(25, 6, $voucher['special_allowance_type'], 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(6);
            $pdf->SetFont('helvetica', '', 8);
            $pdf->Cell(25, 6, '', '', false, 'C', 0, '', 0, false, 'T', 'M');
            $pdf->Cell(130, 6, $employee['its_no'], '', false, 'L', 0, '', 0, false, 'T', 'M');
            if($voucher['approved_status'] == 'Pending')
            {
                $pdf->SetFillColor(255,255,255);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(25, 10, 'Status Pending', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            }
            $pdf->ln(12);
            $pdf->SetFillColor(239,111,108);
            $pdf->SetTextColor(255,255,255);
            $pdf->SetFont('helvetica', 'B', 7);
            $pdf->Cell(0, 8, 'Current Request', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(8);
            $pdf->SetFillColor(255,255,255);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', '', 7);
            foreach($details as $detail) {
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(20, 6, 'Allowance For:', 'L', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 7);
                $pdf->Cell(70, 6, $families[$detail['employee_family_id']].' ('.$detail['allowance_for'].')', 0, false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(30, 6, 'Allowance Category:', 0, false, 'R', 0, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 7);
                $pdf->Cell(30, 6, $detail['special_allowance_category'], 0, false, 'L', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(13, 6, 'Amount:', 0, false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->SetFont('helvetica', '', 7);
                $pdf->Cell(17, 6, number_format($detail['amount'],2), 'R', false, 'R', 1, '', 0, false, 'T', 'M');
                $pdf->ln(6);
                if($detail['remarks']) {
                    $pdf->SetFont('helvetica', 'B', 7);
                    $pdf->Cell(20, 6, 'Remarks:', 'L', false,'R', 1, '', 0, false, 'T', 'M');
                    $pdf->SetFont('helvetica', '', 7);
                    $pdf->Cell(160, 6, $detail['remarks'], 'R', false, 'L', 0, '', 0, false, 'T', 'M');
                    $pdf->ln(6);
                }
                if($detail['receipt_no'] || $detail['receipt_date']) {
                    $pdf->SetFont('helvetica', 'B', 7);
                    $pdf->Cell(20, 6, 'Receipt No:', 'L', false, 'R', 1, '', 0, false, 'T', 'M');
                    $pdf->SetFont('helvetica', '', 7);
                    $pdf->Cell(120, 6, $detail['receipt_no'], 0, false, 'L', 1, '', 0, false, 'T', 'M');
                    $pdf->SetFont('helvetica', 'B', 7);
                    $pdf->Cell(20, 6, 'Receipt Date', 0, false, 'L', 1, '', 0, false, 'T', 'M');
                    $pdf->SetFont('helvetica', '', 7);
                    $pdf->Cell(20, 6, ($detail['receipt_date']!=''?stdDate($detail['receipt_date']):''), 'R', false, 'L', 1, '', 0, false, 'T', 'M');
                    $pdf->ln(6);
                }
                $pdf->Cell(0, 1, '', 'T');
                $pdf->ln(1);
            }
            $pdf->ln(4);
            $pdf->SetFont('helvetica', 'B', 7);
            $pdf->Cell(20, 8, 'Total Amount:', 0, false, 'L', 1, '', 0, false, 'T', 'M');
            $pdf->SetFont('helvetica', '', 7);
            $pdf->Cell(160, 8, number_format($voucher['total_amount'],2).' ('.Number2Words(round($voucher['total_amount'],0)).')', 0, false, 'L', 1, '', 0, false, 'T', 'M');
            $pdf->ln(20);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(40, 8, 'Applicant Signature', 'T', false, 'C');
            $pdf->Cell(30, 8, '', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(40, 8, 'Verified by', 'T', false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, '', 0, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(40, 8, 'Approved By', 'T', false, 'C');
        }

        $pdf->Output('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis').'.pdf', 'I');
    }
}

class PDF extends TCPDF {
    public $lang;
    public $data;

    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 10, 'Dawat e Hadiyah', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', 'B', 14);
//        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', '', 14);
//        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-20);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        if($this->data['approved_status'] == 'Pending')
        {
            $message = "This is the Draft Copy, Please submit your request for approval!";
            $this->Cell(70, 10, $message, 0, false, 'C', 0, '', 0, false, 'T', 'M');
            $this->Ln(10);
        }

        // Page number
        $this->Cell(60, 10, 'Ref: '.$this->data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>