<?php

class ControllerEmployeeEmployeeAttendance extends HController {

    protected function getAlias() {
        return 'employee/employee_attendance';
    }

    protected function getPrimaryKey() {
        return 'employee_attendance_id';
    }

    public function index()
    {
        $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
    }

    protected function getForm() {
        parent::getForm();

        $this->model['department'] = $this->load->model('setup/department');
        $this->data['departments'] = $this->model['department']->getRows(array('company_id'=>$this->session->data['company_id']), array('department_name'));

        $this->data['href_csv_format'] = HTTP_SERVER . 'csv_attendance_format.txt';
        $this->data['href_get_employee'] = $this->url->link($this->getAlias() . '/getEmployee', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['action_save_csv_file'] = $this->url->link($this->getAlias() . '/uploadCSV', 'token=' . $this->session->data['token'] . '&employee_registration_id=' . $this->request->get['employee_registration_id']);
        $this->data['strCSVValidation']="{
            'rules':{
		        'from_date': {'required':true},
		        'to_date': {'required':true},
		        'csv_file': {'required':true},
            },
            ignore:[]
        }";
        $this->data['strValidation']="{
            'rules':{
		        'attendance_date': {'required':true},
		        'department_id': {'required':true},
		        'employee_count': {'required':true, 'min':1},
            },
            ignore:[]
        }";

        $this->response->setOutput($this->render());
    }

    public function getEmployee() {
        $post = $this->request->post;
        $attendance_date = MySqlDate($post['attendance_date']);
        $day = date('D', strtotime($attendance_date));

        $this->model['employee_leave'] = $this->load->model('employee/employee_leave');
        $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');
        $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
        $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');

        $employee_registrations = $this->model['employee_registration']->getArrays('employee_registration_id',array('employee_registration_id','registration_code','employee_name', 'attendance_shift_id'),array('company_id' => $this->session->data['company_id'], 'department_id' => $post['department_id']), array('employee_name'));
        $attendances = $this->model['employee_attendance']->getArrays('employee_registration_id',array('employee_registration_id', 'status', 'attendance_type','time_in', 'time_out', 'shift_in', 'shift_out'),array('company_id' => $this->session->data['company_id'], 'department_id' => $post['department_id'], 'attendance_date' => $attendance_date));
        //d($attendances, true);
        foreach($employee_registrations as $employee_registration_id => $registration) {
            $shift = $this->model['attendance_shift_detail']->getRow(array('attendance_shift_id' => $registration['attendance_shift_id'], 'day' => $day));
            if(isset($attendances[$employee_registration_id])) {
                $registration['status'] = $attendances[$employee_registration_id]['status'];
                $registration['attendance_type'] = $attendances[$employee_registration_id]['attendance_type'];
                $registration['time_in'] = $attendances[$employee_registration_id]['time_in'];
                $registration['time_out'] = $attendances[$employee_registration_id]['time_out'];
                $registration['shift_in'] = $attendances[$employee_registration_id]['shift_in'];
                $registration['shift_out'] = $attendances[$employee_registration_id]['shift_out'];
            } else {
                $where = "`employee_registration_id`='".$employee_registration_id."' AND `status`='Approved' AND '".MysqlDate($post['attendance_date'])."' >=`approved_from` AND '".MysqlDate($post['attendance_date'])."'<=`approved_to`";
                $leave = $this->model['employee_leave']->getRow($where);
                $registration['time_in'] = '';
                $registration['time_out'] = '';
                $registration['shift_in'] = $shift['from_time'];
                $registration['shift_out'] = $shift['to_time'];
                if($leave) {
                    $registration['status'] = $leave['approved_type'];
                    $registration['attendance_type'] = 'Automatic';
                } else {
                    $registration['status'] = 'A';
                    $registration['attendance_type'] = 'Automatic';
                }
            }

            $employees[] = $registration;
        }

        $html = '';
        foreach($employees as $row_no => $employee) {
            $html .= '<tr>';
            $html .= '<td>'.($row_no+1).'</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_employee_registration_id" name="employees['.$row_no.'][employee_registration_id]" value="'.$employee['employee_registration_id'].'"/>';
            $html .= $employee['registration_code'];
            $html .= '</td>';
            $html .= '<td>'.$employee['employee_name'].'</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_shift_in" name="employees['.$row_no.'][shift_in]" value="'.$employee['shift_in'].'"/>';
            $html .= $employee['shift_in'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_shift_out" name="employees['.$row_no.'][shift_out]" value="'.$employee['shift_out'].'"/>';
            $html .= $employee['shift_out'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_time_in" name="employees['.$row_no.'][time_in]" value="'.$employee['time_in'].'"/>';
            $html .= $employee['time_in'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_time_out" name="employees['.$row_no.'][time_out]" value="'.$employee['time_out'].'"/>';
            $html .= $employee['time_out'];
            $html .= '</td>';
            $html .= '<td>';
            $html .= '<input type="hidden" id="employee_'.$row_no.'_attendance_type" name="employees['.$row_no.'][attendance_type]" value="'.$employee['attendance_type'].'"/>';
            $html .= '<select class="form-control" id="employee_'.$row_no.'_status" name="employees['.$row_no.'][status]" onChange="updateAttendanceType('.$row_no.');">';
            $html .= '<option value="P" '.($employee['status']=='P'?'selected="true"':'').'>Present</option>';
            $html .= '<option value="A" '.($employee['status']=='A'?'selected="true"':'').'>Absent</option>';
            $html .= '<option value="LP" '.($employee['status']=='LP'?'selected="true"':'').'>Leave with Pay</option>';
            $html .= '<option value="LD" '.($employee['status']=='LD'?'selected="true"':'').'>Leave with Deduction</option>';
            $html .= '<option value="LT" '.($employee['status']=='LT'?'selected="true"':'').'>Late</option>';
            $html .= '</select>';
            $html .= '</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'employee_count' => count($employees),
            'html' => $html
        );

        echo json_encode($json);
    }

    protected function insertData($data) {
        $attendance_date = MySqlDate($data['attendance_date']);
        $department_id = $data['department_id'];
        $this->model[$this->getAlias()]->deleteBulk($this->getAlias(), array('attendance_date' => $attendance_date, 'department_id' => $department_id));
        foreach($data['employees'] as $employee) {
            $employee['company_id'] = $this->session->data['company_id'];
            $employee['attendance_date'] = $attendance_date;
            $employee['department_id'] = $department_id;

            $this->model[$this->getAlias()]->add($this->getAlias(), $employee);
        }
    }

    public function uploadCSV() {
        ini_set('max_execution_time','0');
        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $file = $this->request->files['csv_file'];
        if($file['tmp_name'] != '') {
            $from_date = MySqlDate($post['from_date']);
            $to_date = MySqlDate($post['to_date']);
            $company_id = $this->session->data['company_id'];

            $this->model['machine_attendance'] = $this->load->model('employee/machine_attendance');
            $this->model['attendance_shift_detail'] = $this->load->model('setup/attendance_shift_detail');
            $this->model['employee'] = $this->load->model('employee/employee_profile');
            $this->model['employee_registration'] = $this->load->model('employee/employee_registration');
            $this->model['employee_attendance'] = $this->load->model('employee/employee_attendance');

            $this->model['machine_attendance']->truncateTempTable();
            $this->model['machine_attendance']->fillTempTable($file['tmp_name']);

            $sql = "SELECT DISTINCT `employee_code` as employee_code FROM `tmp_csv_file` WHERE `date` >='".$from_date."' AND `date`<='".$to_date."'";
            $query = $this->model['machine_attendance']->executeQuery($sql);
            $employees = $query->rows;

            foreach($employees as $employee) {
                $employee_code = $employee['employee_code'];
                $emp = $this->model['employee']->getRow(array('employee_code' => $employee_code));
                if($emp) {
                    $employee_id = $emp['employee_id'];
                    $registration = $this->model['employee_registration']->getRow(array('company_id' => $company_id, 'employee_id' => $employee_id));
                    $attendance_shift_id = $registration['attendance_shift_id'];
                    $shifts = $this->model['attendance_shift_detail']->getArrays('day',array('day_status','from_time','to_time'),array('attendance_shift_id' => $attendance_shift_id));
                    //d(array($registration, $shifts), true);
                    $sql = "SELECT * FROM `tmp_csv_file` WHERE `date` >='".$from_date."' AND `date` <='".$to_date."' AND `employee_code` = '".$employee_code."'";
                    $query = $this->model['attendance_shift_detail']->executeQuery($sql);
                    $rows = $query->rows;
                    //d($rows, true);
                    foreach($rows as $row) {
                        $day = date('D', strtotime($row['date']));
                        $day_status = $shifts[$day]['day_status'];
                        $shift_from_time = $shifts[$day]['from_time'];
                        $shift_to_time = $shifts[$day]['to_time'];
                        //d(array($row['date'], $day, $shifts), true);
                        if(strtotime($row['from_time']) > strtotime($shift_from_time) && $day_status['Working Day']) {
                            $status = 'LT';
                        } else {
                            $status = 'P';
                        }

                        $filter = array(
                            'company_id' => $company_id,
                            'employee_registration_id' => $registration['employee_registration_id'],
                            'attendance_date' => $row['date']
                        );
                        $attendance = $this->model['employee_attendance']->getRow($filter);
                        if(empty($attendance)) {
                            $insert_data = array(
                                'company_id' => $company_id,
                                'department_id' => $registration['department_id'],
                                'attendance_date' => $row['date'],
                                'time_in' => $row['from_time'],
                                'time_out' => $row['to_time'],
                                'shift_in' => $shift_from_time,
                                'shift_out' => $shift_to_time,
                                'employee_registration_id' => $registration['employee_registration_id'],
                                'status' => $status,
                                'attendance_type' => 'Automatic'
                            );
                            $this->model['employee_attendance']->add($this->getAlias(), $insert_data);
                        }
                    }
                }
            }

            $this->session->data['success'] = $lang['success_file_upload'];
        }

        $this->redirect($this->url->link($this->getAlias() . '/insert', 'token=' . $this->session->data['token'], 'SSL'));
    }

}

?>