<?php

class ControllerEmployeeEmployeeScholarship extends HController {

    protected function getAlias() {
        return 'employee/employee_scholarship';
    }

    protected function getPrimaryKey() {
        return 'special_allowance_id';
    }

    protected function validateDocument() {
        return false;
    }

    protected function init() {
        $this->model[$this->getAlias()] = $this->load->model('payroll/special_allowance');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');
        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $this->load->language($this->getAlias());
        $this->model[$this->getAlias()] = $this->load->model('payroll/special_allowance');
        $data = array();
        $aColumns = array('action','company_name','department_name', 'document_date', 'document_identity', 'total_amount', 'approved_status','approved_amount','created_at','check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`employee_id` = '".$this->session->data['employee_id']."'";
        $arrWhere[] = "`allowance_type` = 'Scholarship'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $this->data['lang']['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );

            $actions[] = array(
                'text' => $this->data['lang']['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['approved_status']=='Pending') {
                $actions[] = array(
                    'text' => $this->data['lang']['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' '.(isset($action['target'])?'target="'.$action['target'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                } else {
                    $row[] = $aRow[$aColumns[$i]];
                }

            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $this->data['employees'] = $this->model['employee']->getEmployeeDepartments($this->session->data['employee_id']);

        $this->data['document_date'] = stdDate();
        if (isset($this->request->get['special_allowance_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $result = $this->model[$this->getAlias()]->getRow(array('special_allowance_id' => $this->request->get['special_allowance_id']));
            foreach($result as $field => $value) {
                if($field=='document_date') {
                    $this->data[$field] = stdDate($value);
                } else {
                    $this->data[$field] = $value;
                }
            }
            if($result['file_directory'] != '' && file_exists(DIR_FILES . $result['file_directory'])) {
                $this->data['href_document_file'] = HTTP_FILES . $result['file_directory'];
            } else {
                $this->data['href'] = '';
                $this->data['file_directory'] = '';
                $this->data['file_name'] = '';
            }

            $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
            $allowance_details = $this->model['special_allowance_detail']->getRows(array('special_allowance_id' => $result['special_allowance_id']),array('sort_order'));
            foreach($allowance_details as $row_id => $detail) {
                if($detail['receipt_date'] != '') {
                    $detail['receipt_date'] = stdDate($detail['receipt_date']);
                }
                if($detail['file_directory'] != '' && file_exists(DIR_FILES . $detail['file_directory'])) {
                    $detail['href'] = HTTP_FILES . $detail['file_directory'];
                } else {
                    $detail['href'] = '';
                    $detail['file_directory'] = '';
                    $detail['file_name'] = '';
                }
                $this->data['allowance_details'][$row_id] = $detail;
            }

            $this->model['employee_scholarship'] = $this->load->model('employee/employee_scholarship');
            $this->data['scholarship_policies'] = $this->model['employee_scholarship']->getRows(array('employee_registration_id' => $result['employee_registration_id']));

            $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
            $this->data['approved_scholarships'] = $this->model['special_allowance']->getRows(array('employee_registration_id' => $result['employee_registration_id'], 'allowance_type'=>'Scholarship', 'approved_status' => 'Approved'));
        }

        $this->model['employee_family'] = $this->load->model('employee/employee_family');
        $this->data['families'] = $this->model['employee_family']->getRows(array('employee_id'=>$this->session->data['employee_id']));
        $this->data['family_exists']=(empty($this->data['families'])?0:1);

        $this->data['href_get_employee_departments'] = $this->url->link($this->getAlias() . '/getEmployeeDepartments', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);
        $this->data['href_get_policy'] = $this->url->link($this->getAlias() . '/getPolicy', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);
        $this->data['action_validate_name'] = $this->url->link($this->getAlias() . '/validateName', 'token=' . $this->session->data['token'] . '&employee_leave_id=' . $this->request->get['employee_leave_id']);
        $this->data['strValidation']="{
            'rules':{
		        'document_date': {'required':true},
		        'employee_registration_id': {'required':true},
		        'total_amount': {'required':true, 'min':1},
            },
        }";

        $this->response->setOutput($this->render());
    }

    public function getEmployeeDepartments() {
        $company_id = $this->request->post['company_id'];
        $this->model['employee'] = $this->load->model('employee/employee_registration');
        $departments = $this->model['employee']->getEmployeeDepartments($this->session->data['employee_id'], $company_id);
        $html = '<option value="" data-registration_id="">&nbsp;</option>';
        foreach($departments as $department) {
            $html .= '<option data-registration_id="'.$department['employee_registration_id'].'" value="'.$department['department_id'].'">'.$department['department_name'].'</option>';
        }

        $json = array(
            'success' => true,
            'html' => $html
        );

        echo json_encode($json);
    }

    public function getPolicy() {
        $employee_registration_id = $this->request->post['employee_registration_id'];

        $this->model['employee_scholarship'] = $this->load->model('employee/employee_scholarship');
        $policies = $this->model['employee_scholarship']->getRows(array('employee_registration_id' => $employee_registration_id));
        $html_policy = "";
        foreach($policies as $policy) {
            $html_policy .= '<tr>';
            $html_policy .= '<td>'.$policy['relation'].'</td>';
            $html_policy .= '<td>'.$policy['scholarship_on'].'</td>';
            $html_policy .= '<td>'.$policy['scholarship_value'].'</td>';
            $html_policy .= '<tr>';
        }

        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
        $allowances = $this->model['special_allowance']->getRows(array('employee_registration_id' => $employee_registration_id, 'allowance_type'=>'Scholarship', 'approved_status' => 'Approved'));
        $html_approved = "";
        foreach($allowances as $allowance) {
            $html_approved .= '<tr>';
            $html_approved .= '<td>'.stdDate($allowance['document_date']).'</td>';
            $html_approved .= '<td>'.$allowance['document_identity'].'</td>';
            $html_approved .= '<td>'.$allowance['total_amount'].'</td>';
            $html_approved .= '<td>'.$allowance['approved_amount'].'</td>';
            $html_approved .= '<tr>';
        }

        $json = array(
            'success' => true,
            'employee_registration_id' => $employee_registration_id,
            'html_policy' => $html_policy,
            'html_approved' => $html_approved
        );

        echo json_encode($json);
    }

    protected function validateInsert() {
        $this->validateForm();

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    protected function validateUpdate() {
        $this->validateForm();

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    protected function validateDelete($id='') {
        if (!$this->error) {
            return true;
        } else {
            $this->session->data['error_warning'] = $this->error['warning'];
            return false;
        }
    }

    protected function insertData($data) {
        $document_no = $this->model[$this->getAlias()]->getMaxDocumentNo();
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_no'] = $document_no;
        $data['document_identity'] = $this->session->data['fy_code'].'-'.str_pad($document_no,5,"0",STR_PAD_LEFT);
        $data['document_date'] = MySqlDate($data['document_date']);
        $file = $this->request->files['document'];
        if($file['size'] < 1048576 && $file['size'] > 0) {
            $dir_files = DIR_FILES;
            $uploaded_file = '/'.$data['document_identity'].'-'.basename($file['name']);
            move_uploaded_file($file['tmp_name'], $dir_files . $uploaded_file);

            $data['file_name'] = $file['name'];
            $data['file_directory'] = $uploaded_file;

        }
        $special_allowance_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);

        $arrFiles = array();
        foreach($this->request->files['details'] as $field => $files) {
            foreach($files as $index => $file) {
                $arrFiles[$index][$field] = $file['document'];
            }
        }

        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        foreach($data['details'] as $index => $detail) {
            $detail['special_allowance_id'] = $special_allowance_id;
            $detail['sort_order'] = $index;

            if($detail['receipt_date'] != '') {
                $detail['receipt_date'] = MySqlDate($detail['receipt_date']);
            } else {
                $detail['receipt_date'] = NULL;
            }

            if(isset($arrFiles[$index]) && $arrFiles[$index]['tmp_name'] != '') {
                if($arrFiles[$index]['size'] < 1048576) {
                    $dir_files = DIR_FILES;
                    $uploaded_file = $dir_files .'/'. basename($arrFiles[$index]['name']);
                    move_uploaded_file($arrFiles[$index]['tmp_name'], $uploaded_file);

                    $detail['file_name'] = $arrFiles[$index]['name'];
                    $detail['file_directory'] = '/'. basename($arrFiles[$index]['name']);

                }
            }
            $this->model['special_allowance_detail']->add($this->getAlias(), $detail);
        }
        return $special_allowance_id;
    }

    protected function updateData($primary_key, $data) {
        $data['document_date'] = MySqlDate($data['document_date']);
        $file = $this->request->files['document'];
        if($file['size'] < 1048576 && $file['size'] > 0) {
            $dir_files = DIR_FILES;
            $uploaded_file = '/'.$data['document_identity'].'-'.basename($file['name']);
            move_uploaded_file($file['tmp_name'], $dir_files . $uploaded_file);

            $data['file_name'] = $file['name'];
            $data['file_directory'] = $uploaded_file;

        }
        $special_allowance_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);

        $arrFiles = array();
        foreach($this->request->files['details'] as $field => $files) {
            foreach($files as $index => $file) {
                $arrFiles[$index][$field] = $file['document'];
            }
        }

        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        $this->model['special_allowance_detail']->deleteBulk($this->getAlias(), array('special_allowance_id' => $special_allowance_id));
        foreach($data['details'] as $index => $detail) {
            $detail['special_allowance_id'] = $special_allowance_id;
            $detail['sort_order'] = $index;

            if($detail['receipt_date'] != '') {
                $detail['receipt_date'] = MySqlDate($detail['receipt_date']);
            } else {
                $detail['receipt_date'] = NULL;
            }

            if(isset($arrFiles[$index]) && $arrFiles[$index]['tmp_name'] != '') {
                if($arrFiles[$index]['size'] < 1048576) {
                    $dir_files = DIR_FILES;
                    $uploaded_file = $dir_files .'/'. basename($arrFiles[$index]['name']);
                    move_uploaded_file($arrFiles[$index]['tmp_name'], $uploaded_file);

                    $detail['file_name'] = $arrFiles[$index]['name'];
                    $detail['file_directory'] = '/'. basename($arrFiles[$index]['name']);

                }
            }
            $this->model['special_allowance_detail']->add($this->getAlias(), $detail);
        }
        return $special_allowance_id;
    }

    public function printDocument() {
        $special_allowance_id = $this->request->get['special_allowance_id'];
        $lang = $this->load->language('employee/employee_scholarship');

        $this->model['special_allowance'] = $this->load->model('payroll/special_allowance');
        $this->model['special_allowance_detail'] = $this->load->model('payroll/special_allowance_detail');
        $this->model['employee_medical'] = $this->load->model('employee/employee_medical');
        $this->model['employee_scholarship'] = $this->load->model('employee/employee_scholarship');
        $this->model['employee_family'] = $this->load->model('employee/employee_family');

        $voucher = $this->model['special_allowance']->getRow(array('special_allowance_id' => $special_allowance_id));
        $details = $this->model['special_allowance_detail']->getRows(array('special_allowance_id' => $special_allowance_id));
        $medicals = $this->model['employee_medical']->getRows(array('employee_registration_id' => $voucher['employee_registration_id']));
        $scholarships = $this->model['employee_scholarship']->getRows(array('employee_registration_id' => $voucher['employee_registration_id']));
        $families = $this->model['employee_family']->getArrays('employee_family_id','full_name',array('employee_id' => $voucher['employee_id']));
        //d(array($voucher, $details, $medicals, $scholarships), true);

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis'));
        $pdf->SetSubject('Covering Letter');

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(PDF_MARGIN_LEFT, 20, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->data = array(
            'company_name' => $voucher['company_name'],
            'document_identity' => $voucher['document_identity']
        );
        $pdf->lang = $lang;
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();

        //$pdf->Cell(0,10,'',1,1);
        //$pdf->Cell(180,10,'',1,1);
        $pdf->SetDrawColor(205,205,205);
        $pdf->SetFillColor(239,111,108);
        $pdf->SetTextColor(255,255,255);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(20, 8, 'Doc. No.', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(20, 8, 'Doc. Date', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, 'Allowance Type', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(110, 8, 'Employee', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->ln(8);
        $pdf->SetFillColor(255,255,255);
        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('helvetica', '', 7);
        $pdf->Cell(20, 8, $voucher['document_identity'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(20, 8, $voucher['document_date'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, $voucher['allowance_type'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(110, 8, $voucher['employee_name'].' ['.$voucher['registration_code'].'/'.$voucher['employee_code'].']', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->ln(12);
        if($voucher['allowance_type']=='Scholarship') {
            $pdf->SetFillColor(239,111,108);
            $pdf->SetTextColor(255,255,255);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(0, 8, $voucher['allowance_type'] . ' Policy', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(8);
            $pdf->SetFillColor(255,255,255);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(60, 8, 'Relation', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(60, 8, 'Scholarship On', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(60, 8, 'Scholarship Value', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(8);
            $pdf->SetFont('helvetica', '', 7);
            if(empty($scholarships)) {
                $pdf->Cell(0, 8, 'No Policy Defined', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
            } else {
                foreach($scholarships as $policy) {
                    $pdf->Cell(60, 8, $policy['relation'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(60, 8, $policy['scholarship_on'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(60, 8, $policy['scholarship_value'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->ln(8);
                }
            }
            $pdf->ln(4);
        } elseif($voucher['allowance_type']=='Medical') {
            $pdf->SetFillColor(239,111,108);
            $pdf->SetTextColor(255,255,255);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(0, 8, $voucher['allowance_type'] . ' Policy', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(8);
            $pdf->SetFillColor(255,255,255);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(45, 8, 'Relation', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(45, 8, 'Medical Type', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(45, 8, 'Medical On', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(45, 8, 'Medical Value', 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(8);
            $pdf->SetFont('helvetica', '', 7);
            if(empty($medicals)) {
                $pdf->Cell(0, 8, 'No Policy Defined', 1, false, 'C', 1, '', 0, false, 'T', 'M');
                $pdf->ln(8);
            } else {
                foreach($scholarships as $policy) {
                    $pdf->Cell(45, 8, $policy['relation'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(45, 8, $policy['medical_type'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(45, 8, $policy['medical_on'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->Cell(45, 8, $policy['medical_value'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
                    $pdf->ln(8);
                }
            }
            $pdf->ln(4);
        }

        $pdf->SetFillColor(239,111,108);
        $pdf->SetTextColor(255,255,255);
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(0, 8, 'Current Request', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->ln(8);
        $pdf->SetFillColor(255,255,255);
        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(30, 8, 'Allowance For', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, 'Amount', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(60, 8, 'Remarks', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, 'Receipt Date', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->Cell(30, 8, 'Receipt No.', 1, false, 'C', 1, '', 0, false, 'T', 'M');
        $pdf->ln(8);
        $pdf->SetFont('helvetica', '', 7);
        foreach($details as $detail) {
            $pdf->Cell(30, 8, $families[$detail['employee_family_id']].' ('.$detail['allowance_for'].')', 1, false, 'L', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, number_format($detail['amount'],2), 1, false, 'R', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(60, 8, $detail['remarks'], 1, false, 'L', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, ($detail['receipt_date']!=''?stdDate($detail['receipt_date']):''), 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->Cell(30, 8, $detail['receipt_no'], 1, false, 'C', 1, '', 0, false, 'T', 'M');
            $pdf->ln(8);
        }
        $pdf->ln(4);
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(20, 8, 'Total Amount:', 0, false, 'L', 1, '', 0, false, 'T', 'M');
        $pdf->SetFont('helvetica', '', 7);
        $pdf->Cell(160, 8, number_format($voucher['total_amount'],2).' ('.Number2Words(round($voucher['total_amount'],0)).')', 0, false, 'L', 1, '', 0, false, 'T', 'M');
        $pdf->ln(16);
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(100, 8, '', 0);
        $pdf->Cell(80, 8, $voucher['company_name'], 'T', false, 'C', 1, '', 0, false, 'T', 'M');

        $pdf->Output('Covering Letter:'.$voucher['document_identity'].'@'.date('YmdHis').'.pdf', 'I');
    }
}

class PDF extends TCPDF {
    public $lang;
    public $data;

    //Page header
    public function Header() {
        // Logo
        //$image_file = DIR_IMAGE.'logo.jpg';
        //$image_file = DIR_IMAGE.'no_image.jpg';
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', 'B', 14);
//        $this->Cell(0, 10, $this->data['report_title'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->SetFont('helvetica', '', 14);
//        $this->Cell(0, 10, $this->data['subtitle'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(60, 10, 'Ref: '.$this->data['document_identity'], 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Cell(60, 10, 'Date: '.date('d-m-Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}
?>