<?php

class ModelEmployeeEmployeeAttendance extends HModel {

    protected function getTable() {
        return 'employee_attendance';
    }

//    protected function getView() {
//        return 'vw_employee_attendance';
//    }

    public function getAttendanceSummary($filter=array()) {
        $sql = "SELECT ea.`employee_registration_id`, er.`registration_code`, er.`employee_id`, er.`employee_code`, er.`employee_name`";
        $sql .= " , er.`shift_title`, er.`late_deduction`";
        $sql .= " , SUM(IF(ea.`status`='P',1,0)) AS total_p";
        $sql .= " , SUM(IF(ea.`status`='A',1,0)) AS total_a";
        $sql .= " , SUM(IF(ea.`status`='LT',1,0)) AS total_lt";
        $sql .= " , SUM(IF(ea.`status`='LP',1,0)) AS total_lp";
        $sql .= " , SUM(IF(ea.`status`='LD',1,0)) AS total_ld";
        $sql .= " , COUNT(*) AS total";
        $sql .= " FROM `employee_attendance` AS ea";
        $sql .= " INNER JOIN `vw_employee_registration` er ON er.`employee_registration_id` = ea.`employee_registration_id`";
        if($filter) {
            if(is_array($filter)) {
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getYearlyAttendance($employee_registration_id, $from_date, $to_date) {
        $sql = "SELECT c.`yearly_leave`, ash.`shift_title`, ash.`late_deduction`";
        $sql .= " FROM `employee_registration` er";
        $sql .= " INNER JOIN `company` c ON c.`company_id` = er.`company_id`";
        $sql .= " LEFT JOIN `attendance_shift` ash ON ash.`attendance_shift_id` = er.`attendance_shift_id`";
        $sql .= " WHERE er.`employee_registration_id` = '$employee_registration_id'";
        $query = $this->conn->query($sql);
        $row =  $query->row;
        $data = [
            'yearly_leave' => $row['yearly_leave'],
            'shift_title' => $row['shift_title'],
            'late_deduction' => $row['late_deduction'],
            'Absent' => 0,
            'Present' => 0,
            'Late' => 0,
            'LP' => 0,
            'LD' => 0,
        ];

        $sql = "SELECT ";
        $sql .= " SUM(IF(ea.`status`='A',1,0)) AS `Absent`";
        $sql .= ", SUM(IF(ea.`status`='P',1,0)) AS `Present`";
        $sql .= ", SUM(IF(ea.`status`='LT',1,0)) AS `Late`";
        $sql .= ", SUM(IF(ea.`status`='LP',1,0)) AS `LP`";
        $sql .= ", SUM(IF(ea.`status`='LD',1,0)) AS `LD`";
        $sql .= " FROM `employee_attendance` ea";
        $sql .= " WHERE ea.attendance_date >= '$from_date' AND ea.attendance_date <= '$to_date'";
        $sql .= " AND ea.employee_registration_id = '$employee_registration_id'";

        $query = $this->conn->query($sql);
        $row =  $query->row;
        if($row) {
            $data['Absent'] = empty($row['Absent'])?0:$row['Absent'];
            $data['Present'] = empty($row['Present'])?0:$row['Present'];
            $data['Late'] = empty($row['Late'])?0:$row['Late'];
            $data['LP'] = empty($row['LP'])?0:$row['LP'];
            $data['LD'] = empty($row['LD'])?0:$row['LD'];
        }


        return $data;
    }

}

?>