<?php

class ModelPayrollPayroll extends HModel {

    protected function getTable() {
        return 'payroll';
    }

    protected function getView() {
        return 'vw_payroll';
    }

    public function getTotalGross($filter) {
        $sql = "SELECT SUM(`gross_salary`) AS total_gross";
        $sql .= " FROM `".$this->getView()."`";
        if($filter) {
            if(is_array($filter)) {
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        $query = $this->conn->query($sql);
        $row = $query->row;
        return empty($row['total_gross'])?0:$row['total_gross'];
    }

    public function getTotalTax($filter) {
        $sql = "SELECT SUM(`tax_deduction`) AS total_tax";
        $sql .= " FROM `".$this->getView()."`";
        if($filter) {
            if(is_array($filter)) {
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        $query = $this->conn->query($sql);
        $row = $query->row;
        return empty($row['total_tax'])?0:$row['total_tax'];
    }

    public function getTotalPayrolls($filter){
        $sql = "SELECT COUNT(*) AS total_payroll";
        $sql .= " FROM `".$this->getView()."`";
        if($filter){
            if(is_array($filter)){
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        $query = $this->conn->query($sql);
        $row = $query->row;
        return empty($row['total_payroll'])?0:$row['total_payroll'];

    }

    public function getRegister($where) {
        $fiscal_year_id = $this->session->data['fiscal_year_id'];

        $sql = "SELECT DISTINCT allowance_id, allowance_name";
        $sql .= " FROM `payroll_allowance` pa";
        $sql .= " INNER JOIN `payroll` p ON p.`payroll_id` = pa.`payroll_id`";
        $sql .= " WHERE " . $where;
//        $sql .= " WHERE p.fiscal_year_id = '$fiscal_year_id' AND p.`document_date` = '$document_date'";
//        if($department_id != '') {
//            $sql .= " AND p.`department_id` =";
//        }
//        if(empty($company_id)) {
//            $sql .= " AND p.`company_id` = '".$this->session->data['company_id']."'";
//        } else {
//            $sql .= " AND p.`company_id` IN (".implode(',',$company_id).")";
//        }

        $query = $this->db->query($sql);
        $allowances = $query->rows;
        $sql = "SELECT DISTINCT deduction_id, deduction_code, deduction_name";
        $sql .= " FROM `payroll_deduction` pd";
        $sql .= " INNER JOIN `payroll` p ON p.`payroll_id` = pd.`payroll_id`";
        $sql .= " WHERE " . $where;
//        $sql .= " WHERE p.fiscal_year_id = '$fiscal_year_id' AND p.`document_date` = '$document_date'";
//        if($department_id != '') {
//            $sql .= " AND p.`department_id` =";
//        }
//        if(empty($company_id)) {
//            $sql .= " AND p.`company_id` = '".$this->session->data['company_id']."'";
//        } else {
//            $sql .= " AND p.`company_id` IN (".implode(',',$company_id).")";
//        }

        $query = $this->db->query($sql);
        $deductions = $query->rows;
        //d(array($sql, $deductions), true);

        $sql = "SELECT p.`payroll_id`, c.company_name, d.department_name, p.`document_date`, p.`document_title`, p.`employee_registration_id`, p.`employee_id`, p.`registration_code` as 'Reg No.', e.`full_name` as Name";
        $sql .= ", (p.`gross_salary` + p.`house_rent_allowance` - (p.`net_salary`-p.`payable_salary`)) as 'S&A', p.`basic_salary` as Salary, p.`arrears` as Arrears";
        foreach($allowances as $allowance) {
            $sql .= ", (SELECT allowance_amount FROM `payroll_allowance` pa WHERE pa.`payroll_id`=p.`payroll_id` AND pa.`allowance_id`='".$allowance['allowance_id']."') AS '".$allowance['allowance_name']."'";
        }
        $sql .= ", p.`gross_salary` as Gross";
        foreach($deductions as $deduction) {
            $sql .= ", (SELECT deduction_amount FROM `payroll_deduction` pd WHERE pd.`payroll_id`=p.`payroll_id` AND pd.`deduction_id`='".$deduction['deduction_id']."') AS '".$deduction['deduction_code']."'";
        }
        $sql .= ", p.`tax_deduction` AS TAX, (p.`net_salary`-p.`payable_salary`) AS 'ATT Deduction', p.`payable_salary` AS 'Payable', ds.cheque_no as CHQ";
        $sql .= " FROM `vw_payroll` p";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = p.`employee_id`";
        $sql .= " INNER JOIN `company` c ON c.`company_id` = p.`company_id`";
        $sql .= " INNER JOIN `department` d ON d.`department_id` = p.`department_id`";
        $sql .= " LEFT JOIN `deposit_slip` ds ON ds.`deposit_slip_id` = p.`deposit_slip_id`";
        $sql .= " WHERE " . $where;
        $sql .= " ORDER BY d.department_name, e.employee_code";
//        $sql .= " WHERE p.fiscal_year_id = '$fiscal_year_id' AND p.`document_date` = '$document_date'";
//        if($department_id != '') {
//            $sql .= " AND p.`department_id` =";
//        }
//        if(empty($company_id)) {
//            $sql .= " AND p.`company_id` = '".$this->session->data['company_id']."'";
//        } else {
//            $sql .= " AND p.`company_id` IN (".implode(',',$company_id).")";
//        }

        $query = $this->db->query($sql);
        // d($query,true);
        return $query->rows;
    }

    public function getPendingEmployees() {
        $sql = "SELECT DISTINCT employee_registration_id, registration_code, employee_code, employee_name";
        $sql .= " FROM `vw_payroll`";
        $sql .= " WHERE deposit_slip_id = ''";
        $sql .= " AND company_id = '".$this->session->data['company_id']."'";

        $query = $this->db->query($sql);
        return $query->rows;
    }
}
?>