<?php

class ModelSetupCompanyAllowancePolicy extends HModel {
    protected function getTable() {
        return 'company_allowance_policy';
    }

    public function getRecords($filter=NULL, $sort_order=NULL, $limit=NULL) {
        $sql = "SELECT p.*, t.`special_allowance_type` AS allowance_type, IF(p.`allowance_category_id`=0,'ALL',c.`special_allowance_category`) AS allowance_category";
        $sql .= " FROM `company_allowance_policy` p";
        $sql .= " INNER JOIN `special_allowance_type` t ON t.`special_allowance_type_id`=p.`allowance_type_id`";
        $sql .= " LEFT JOIN `special_allowance_category` c ON c.`special_allowance_category_id` = p.`allowance_category_id`";

        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "$column='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        if($limit) {
            $sql .= " LIMIT ".$limit;
        }

        $query = $this->conn->query($sql);
        return $query->rows;
    }


    public function getRecord($filter=NULL, $sort_order=NULL) {
        $sql = "SELECT p.*, t.`special_allowance_type` AS allowance_type, IF(p.`allowance_category_id`=0,'ALL',c.`special_allowance_category`) AS allowance_category";
        $sql .= " FROM `company_allowance_policy` p";
        $sql .= " INNER JOIN `special_allowance_type` t ON t.`special_allowance_type_id`=p.`allowance_type_id`";
        $sql .= " LEFT JOIN `special_allowance_category` c ON c.`special_allowance_category_id` = p.`allowance_category_id`";

        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "$column='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        $query = $this->conn->query($sql);
        return $query->row;
    }

}

?>