/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('change','#employee_code', function() {
    var $value = $(this).val();
    var $department_id = $('#department_id').val();
    if($department_id == '') {
        $(this).val('');
        alert('Select Department First');
        return;
    }
    if($value!='') {
        $.ajax({
            url: $URLGetEmployee,
            dataType: 'json',
            type: 'post',
            data: 'employee_code='+$value+'&department_id='+$department_id,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#employee_bank_id').before('<span id="loader" class="pull-right"><i class="fa fa-spin fa-refresh"></i></span>')
            },
            complete: function() {
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#employee_id').val(json.employee_id);
                    $('#employee_code').val(json.employee_code);
                    $('#employee_name').val(json.employee_name);
                    $('#employee_bank_id').html(json.banks).trigger('change');
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});

$(document).on('change', '#employee_bank_id', function() {
    var $data = $('#employee_bank_id option:selected').data();
    console.log($data);
    $('#bank_id').val($data.bank_id);
    $('#bank_account').val($data.bank_account);
    $('#bank_title').val($data.bank_title);
    $('#bank_iban').val($data.bank_iban);
})

$(document).on('change','#status', function() {
    var $value = $(this).val();
    if($value=='Active') {
        $('#divLeavingDate').hide('slow');
    } else {
        $('#divLeavingDate').show('slow');
    }
});

function editEmployeeSalary($employee_salary_id, $duplicate) {
    $.ajax({
        url: $URLGetEmployeeSalary,
        dataType: 'json',
        type: 'post',
        data: 'employee_salary_id='+$employee_salary_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {

        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $.each(json['data'], function(key,value){
                    if(key=='taxable') {
                        if(value=='Yes') {
                            $('#' + key).prop('checked',true);
                        } else {
                            $('#' + key).prop('checked',false);
                        }
                    } else if(key=='taxable_house_rent') {
                        if(value=='Yes') {
                            $('#' + key).prop('checked',true);
                            $('#divTaxableHouseRent').show();
                        } else {
                            $('#' + key).prop('checked',false);
                            $('#divTaxableHouseRent').hide();
                        }
                    } else {
                        $('#'+key).val(value);
                    }
                });
                if($duplicate==1) {
                    $('#employee_salary_id').val('');
                }
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })
};

$(document).on('change','#wef_date,#basic_salary',function() {
    var $wef_date = $('#wef_date').val();
    var $basic_salary = $('#basic_salary').val();
    if($wef_date && $basic_salary) {
        var $data = {
            department_id: $('#department_id').val(),
            employee_id: $('#employee_id').val(),
            wef_date: $('#wef_date').val(),
            basic_salary: $('#basic_salary').val()
        }

        $.ajax({
            url: $URLGetSalaryInfo,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#tabSalary .alert').remove();
            },
            complete: function() {
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    if(json.message != '') {
                        var $html = '';
                        $html +='<div class="alert alert-info alert-dismissable">';
                        $html +='<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>';
                        $html += json.message;
                        $html +='</div>';

                        $('#tabSalary').prepend($html);
                        $('#arrears').val(json.arrears);
                        if(json.taxable==1) {
                            $('#taxable').prop('checked',false);
                        } else {
                            $('#taxable').prop('checked',true);
                        }
                    } else {
                        $('#tabSalary .alert').remove();
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});

$(document).on('click','#taxable_house_rent',function() {
    var $checked = $(this).is(':checked');
    $('#taxable_house_rent_percent').val(0);
    if($checked) {
        $('#divTaxableHouseRent').show('slow');
    } else {
        $('#divTaxableHouseRent').hide('slow');
    }
});

function calculateSalaryTotal() {
    var $basic_salary = $('#basic_salary').val();
    var $total_allowance = 0;
    var $gross_amount = 0;
    var $total_deduction = 0;
    var $net_amount = 0;

    $('#tblEmployeeAllowance tbody input.fPDecimal').each(function() {
        var $allowance_amount = $(this).val() | 0;
        $total_allowance += parseFloat($allowance_amount);
    })

    $('#tblEmployeeDeduction tbody input.fPDecimal').each(function() {
        var $deduction_amount = $(this).val() | 0;
        $total_deduction += parseFloat($deduction_amount);
    })

    $gross_amount = parseFloat($basic_salary) + parseFloat($total_allowance);
    $net_amount = parseFloat($gross_amount) - parseFloat($total_deduction);

    $('#total_allowance').val($total_allowance)
    $('#gross_amount').val($gross_amount)
    $('#total_deduction').val($total_deduction)
    $('#net_amount').val($net_amount)
}

$(document).on('click', '#btnTax', function() {
    var $employee_id = $('#employee_id').val();
    var $wef_date = $('#wef_date').val();
    var $gross_amount = $('#gross_amount').val();
    var $basic_salary = $('#basic_salary').val();
    var $total_payroll = $('#total_payroll').val();
    var $taxable_house_rent_percent = $('#taxable_house_rent_percent').val();

    if($employee_id && $wef_date && $gross_amount) {
        var $data = {
            employee_id: $employee_id,
            wef_date: $wef_date,
            basic_salary: $basic_salary,
            gross_amount: $gross_amount,
            total_payroll: $total_payroll,
            taxable_house_rent: $taxable_house_rent_percent
        }

        $.ajax({
            url: $URLGetTaxInfo,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#btnTax').html('<i class="fa fa-refresh fa-spin"></i>');
            },
            complete: function() {
                $('#btnTax').html('Tax');
            },
            success: function(json) {
                if(json.success)
                {
                    var dialog = bootbox.dialog({
                        message: json.html,
                        backdrop: true
                    });
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});

$(document).on('click', '.btnAddScholarship', function() {
    $html = '';
    $html += '<tr id="scholarship_row_'+$scholarship_row+'" data-scholarship_row="'+$scholarship_row+'">';
    $html += '<td><a onclick="removeScholarship(this);" title="Remove" class="btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a></td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_scholarship_'+$scholarship_row+'_relation" name="employee_scholarships['+$scholarship_row+'][relation]">';
    $html += '<option value="Self">'+$lang['self']+'</option>';
    $html += '<option value="Parent">'+$lang['parent']+'</option>';
    $html += '<option value="Sibling">'+$lang['sibling']+'</option>';
    $html += '<option value="Spouse">'+$lang['spouse']+'</option>';
    $html += '<option value="Children">'+$lang['children']+'</option>';
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_scholarship_'+$scholarship_row+'_scholarship_on" name="employee_scholarships['+$scholarship_row+'][scholarship_on]">';
    $html += '<option value="Percent">'+$lang['percent']+'</option>';
    $html += '<option value="Fixed">'+$lang['fixed']+'</option>';
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<input type="text" class="form-control fPDecimal" id="employee_scholarship_'+$scholarship_row+'_scholarship_value" name="employee_scholarships['+$scholarship_row+'][scholarship_value]" value="" />';
    $html += '</td>';
    $html += '</tr>';

    $('#tblScholarship tbody').prepend($html);
    setFieldFormat();
    $scholarship_row++;
});

function removeScholarship($obj) {
    var $row_id = $($obj).parent().parent().data('scholarship_row');
    $('#scholarship_row_'+$row_id).remove();
}

$(document).on('click', '.btnAddMedical', function() {
    $html = '';
    $html += '<tr id="medical_row_'+$medical_row+'" data-medical_row="'+$medical_row+'">';
    $html += '<td><a onclick="removeMedical(this);" title="Remove" class="btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a></td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_medical_'+$medical_row+'_relation" name="employee_medicals['+$medical_row+'][relation]">';
    $html += '<option value="Self">'+$lang['self']+'</option>';
    $html += '<option value="Parent">'+$lang['parent']+'</option>';
    $html += '<option value="Sibling">'+$lang['sibling']+'</option>';
    $html += '<option value="Spouse">'+$lang['spouse']+'</option>';
    $html += '<option value="Children">'+$lang['children']+'</option>';
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_medical_'+$medical_row+'_medical_type_id" name="employee_medicals['+$medical_row+'][medical_type_id]" >';
    $html += '<option value="0">'+$lang['all']+'</option>';
    $.each($medical_types,function($field,$medical_type) {
        $html += '<option value="'+$medical_type.medical_type_id+'">'+$medical_type.medical_type+'</option>';
    });
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_medical_'+$medical_row+'_medical_on" name="employee_medicals['+$medical_row+'][medical_on]">';
    $html += '<option value="Percent">'+$lang['percent']+'</option>';
    $html += '<option value="Fixed">'+$lang['fixed']+'</option>';
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<input type="text" class="form-control fPDecimal" id="employee_medical_'+$medical_row+'_medical_value" name="employee_medicals['+$medical_row+'][medical_value]" value="" />';
    $html += '</td>';
    $html += '</tr>';

    $('#tblMedical tbody').prepend($html);
    setFieldFormat();
    $medical_row++;
});

function removeMedical($obj) {
    var $row_id = $($obj).parent().parent().data('medical_row');
    $('#medical_row_'+$row_id).remove();
}


