/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
})

$(document).on('change','#department_id', function() {
    var $department_id = $(this).val();
    if($department_id == '') {
        $('#employee_id').html('<option value="">&nbsp;</option>').trigger('change');
    } else {
        $.ajax({
            url: $URLGetEmployee,
            dataType: 'json',
            type: 'post',
            data: 'department_id='+$department_id,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#employee_id').before('<i id="loader" class="fa fa-refresh fa-spin"></i>');
            },
            complete: function() {
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#employee_id').html(json.html).trigger('change');
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
})

$(document).on('click','.btnAddAllowance', function() {
    var $html = '';
    $html += '<tr id="grid_row_allowance_'+$grid_row_allowance+'" data-grid_row_allowance_id="'+$grid_row_allowance+'">';
    $html += '<td style="width: 15px;">';
    $html += '<button type="button" data-toggle="tooltip" class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove">';
    $html += '<i class="fa fa-times"></i>';
    $html += '</button>';
    $html += '</td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_allowance_'+$grid_row_allowance+'_allowance_id" name="employee_allowances['+$grid_row_allowance+'][allowance_id]">';
    $html += '<option value="">&nbsp;</option>';
    $allowances.forEach(function($row) {
        $html += '<option value="'+$row['allowance_id']+'">'+$row['allowance_name']+'</option>';
    });
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_allowance_'+$grid_row_allowance+'_allowance_type" name="employee_allowances['+$grid_row_allowance+'][allowance_type]">';
    $html += '<option value="Fixed">Fixed</option>';
    $html += '<option value="Percent">Percent</option>';
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<input type="text" class="form-control fPDecimal" id="employee_allowance_'+$grid_row_allowance+'_allowance_value" name="employee_allowances['+$grid_row_allowance+'][allowance_value]" value="" />';
    $html += '</td>';
    $html += '</tr>';

    $('#tblEmployeeAllowance tbody').append($html);
    setFieldFormat();
    $grid_row_allowance++;
});

$(document).on('click','.btnRemoveAllowance', function() {
    $(this).parent().parent().remove();
});

$(document).on('click','.btnAddDeduction', function() {
    var $html = '';
    $html += '<tr id="grid_row_deduction_'+$grid_row_deduction+'" data-grid_row_deduction_id="'+$grid_row_deduction+'">';
    $html += '<td style="width: 15px;">';
    $html += '<button type="button" data-toggle="tooltip" class="btnRemoveDeduction btn btn-xs btn-danger" title="Remove">';
    $html += '<i class="fa fa-times"></i>';
    $html += '</button>';
    $html += '</td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_deduction_'+$grid_row_deduction+'_deduction_id" name="employee_deductions['+$grid_row_deduction+'][deduction_id]">';
    $html += '<option value="">&nbsp;</option>';
    $deductions.forEach(function($row) {
        $html += '<option value="'+$row['deduction_id']+'">'+$row['deduction_name']+'</option>';
    });
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<select class="form-control" id="employee_deduction_'+$grid_row_deduction+'_deduction_type" name="employee_deductions['+$grid_row_deduction+'][deduction_type]">';
    $html += '<option value="Fixed">Fixed</option>';
    $html += '<option value="Percent">Percent</option>';
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<input type="text" class="form-control fPDecimal" id="employee_deduction_'+$grid_row_deduction+'_deduction_value" name="employee_deductions['+$grid_row_deduction+'][deduction_value]" value="" />';
    $html += '</td>';
    $html += '</tr>';

    $('#tblEmployeeDeduction tbody').append($html);
    setFieldFormat();
    $grid_row_deduction++;
});

$(document).on('click','.btnRemoveDeduction', function() {
    $(this).parent().parent().remove();
});

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('change','#status', function() {
    var $value = $(this).val();
    console.log($value);
    if($value=='Active') {
        $('#divLeavingDate').hide('slow');
    } else {
        $('#divLeavingDate').show('slow');
    }
})